<?php

if (!defined('sugarEntry'))
    define('sugarEntry', true);


require_once('service/v4/SugarWebServiceImplv4.php');
require_once('service/v4_1/SugarWebServiceUtilv4_1.php');


require_once 'custom/include/custom_utils.php';

class SugarWebServiceImplv4_1_custom extends SugarWebServiceImplv4 {

    /**
     * Class Constructor Object
     *
     */
    public function __construct() {
        self::$helperObject = new SugarWebServiceUtilv4_1();
    }

    /**
     * Function : getUserTimezone
     *   get user timezone
     *
     * @param String $session -- Session ID returned by a previous call to login.
     * @param String $module_name -- The name of the module that the primary record is from.  This name should be the name the module was developed under (changing a tab name is studio does not affect the name that should be passed into this method)..
     * @param String $user_id -- User id
     * 
     * @return string '$timezone' -- current timezone of given user
     *              
     * @exception 'SoapFault' -- The SOAP error, if any
     */
    function checkEmailExists($session, $emailAddress) {
        $error = new SoapError();
        self::$helperObject = new SugarWebServiceUtilv4_1();
        if (!self::$helperObject->checkSessionAndModuleAccess($session, 'invalid_session', '', 'read', 'no_access', $error)) {
            $GLOBALS['log']->info('End: SugarWebServiceImpl->checkEmailExists');
            return;
        }
        $returnData = checkEmailExists($emailAddress);
        $recordID = '';
        if ($returnData['IsDuplicate']) {
            $recordID = $returnData['contactID'];
        }
        return array('recordID' => $recordID);
    }

}
