<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/UserBundle/EventListener/SearchSubscriber.php */
class __TwigTemplate_2fa4decd36940bbccf0912918f7faf47 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

namespace Mautic\\UserBundle\\EventListener;

use Mautic\\CoreBundle\\CoreEvents;
use Mautic\\CoreBundle\\DTO\\GlobalSearchFilterDTO;
use Mautic\\CoreBundle\\Event as MauticEvents;
use Mautic\\CoreBundle\\Security\\Permissions\\CorePermissions;
use Mautic\\CoreBundle\\Service\\GlobalSearch;
use Mautic\\UserBundle\\Model\\RoleModel;
use Mautic\\UserBundle\\Model\\UserModel;
use Symfony\\Component\\EventDispatcher\\EventSubscriberInterface;

class SearchSubscriber implements EventSubscriberInterface
{
    public function __construct(
        private UserModel \$userModel,
        private RoleModel \$userRoleModel,
        private CorePermissions \$security,
        private GlobalSearch \$globalSearch,
    ) {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            CoreEvents::GLOBAL_SEARCH => [
                ['onGlobalSearchUser', 0],
                ['onGlobalSearchRoles', 0],
            ],
            CoreEvents::BUILD_COMMAND_LIST => ['onBuildCommandList', 0],
        ];
    }

    public function onGlobalSearchUser(MauticEvents\\GlobalSearchEvent \$event): void
    {
        \$filterDTO = new GlobalSearchFilterDTO(\$event->getSearchString());
        \$results   = \$this->globalSearch->performSearch(
            \$filterDTO,
            \$this->userModel,
            '@MauticUser/SubscribedEvents/Search/global_user.html.twig'
        );

        if (!empty(\$results)) {
            \$event->addResults('mautic.user.users', \$results);
        }
    }

    public function onGlobalSearchRoles(MauticEvents\\GlobalSearchEvent \$event): void
    {
        \$filterDTO = new GlobalSearchFilterDTO(\$event->getSearchString());
        \$results   = \$this->globalSearch->performSearch(
            \$filterDTO,
            \$this->userRoleModel,
            '@MauticUser/SubscribedEvents/Search/global_role.html.twig'
        );

        if (!empty(\$results)) {
            \$event->addResults('mautic.user.roles', \$results);
        }
    }

    public function onBuildCommandList(MauticEvents\\CommandListEvent \$event): void
    {
        if (\$this->security->isGranted('user:users:view')) {
            \$event->addCommands(
                'mautic.user.users',
                \$this->userModel->getCommandList()
            );
        }
        if (\$this->security->isGranted('user:roles:view')) {
            \$event->addCommands(
                'mautic.user.roles',
                \$this->userRoleModel->getCommandList()
            );
        }
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/UserBundle/EventListener/SearchSubscriber.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/UserBundle/EventListener/SearchSubscriber.php", "/home/mauticapp/client/app/bundles/UserBundle/EventListener/SearchSubscriber.php");
    }
}
