<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Assets/css/app/less/marketplace.less */
class __TwigTemplate_ca6bd8b85fc889dd16850a3dc2456645 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield ".marketplace-header {
    overflow: hidden;
    border-radius: clamp(4px, var(--border-radius-lg), 32px);
    border: 2px solid rgb(0 0 0 / var(--custom-bg-overlay-opacity));

    &:before {
        content: \"\";
        position: absolute;
        left: -10%;
        right: -10%;
        top: -150%;
        height: 400%;
        transform: rotate(-10deg);
        background-position: center;
        opacity: 0;
        background-size: 90em;
        mix-blend-mode: multiply;
        backface-visibility: hidden;
        -webkit-backface-visibility: hidden;
        animation: marketplacefadeIn 0.5s ease-in-out forwards;
        pointer-events: none;
        z-index: -1;
    }

    &.mautic-plugin:before {
        background-image: url('data:image/svg+xml,<svg width=\"520\" height=\"200\" viewBox=\"0 0 520 200\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M11 20H15V29H11V20ZM25 16H29V29H25V16ZM18 10H22V29H18V10Z\" fill=\"black\"/><path d=\"M59 10.0508V21.0014H69.9506C69.4489 26.0547 65.1853 30.0014 60 30.0014C54.4771 30.0014 50 25.5243 50 20.0014C50 14.8161 53.9467 10.5525 59 10.0508ZM61 10.0508C65.7244 10.5199 69.4816 14.277 69.9506 19.0014H61V10.0508Z\" fill=\"black\"/><path d=\"M98.9999 10.0508L99 13.0723C95.6077 13.5575 93 16.4749 93 20.0014C93 23.8674 96.134 27.0014 100 27.0014C101.572 27.0014 103.024 26.483 104.192 25.6078L106.329 27.7442C104.605 29.155 102.401 30.0014 100 30.0014C94.4771 30.0014 90 25.5242 90 20.0014C90 14.8161 93.9466 10.5526 98.9999 10.0508ZM109.951 21.0015C109.751 23.0125 108.955 24.8482 107.743 26.3297L105.606 24.1936C106.293 23.2773 106.76 22.1873 106.929 21.0014L109.951 21.0015ZM101.001 10.0509C105.725 10.5204 109.481 14.2773 109.951 19.0013L106.929 19.0012C106.491 15.9359 104.066 13.5113 101.001 13.0724L101.001 10.0509Z\" fill=\"black\"/><path d=\"M133 11V27H149V29H131V11H133ZM147.939 13.9393L150.061 16.0607L144 22.1213L141 19.121L137.061 23.0607L134.939 20.9393L141 14.8787L144 17.879L147.939 13.9393Z\" fill=\"black\"/><path d=\"M185 23.2454V30.1169C185 30.393 184.776 30.617 184.5 30.617C184.409 30.617 184.32 30.5923 184.243 30.5457L180 28L175.757 30.5457C175.52 30.6877 175.213 30.6109 175.071 30.3742C175.025 30.2964 175 30.2075 175 30.1169V23.2454C173.171 21.7793 172 19.5264 172 17C172 12.5817 175.582 9 180 9C184.418 9 188 12.5817 188 17C188 19.5264 186.829 21.7793 185 23.2454ZM180 23C183.314 23 186 20.3137 186 17C186 13.6863 183.314 11 180 11C176.686 11 174 13.6863 174 17C174 20.3137 176.686 23 180 23ZM180 21C177.791 21 176 19.2091 176 17C176 14.7909 177.791 13 180 13C182.209 13 184 14.7909 184 17C184 19.2091 182.209 21 180 21Z\" fill=\"black\"/><path d=\"M220 15.001C224.418 15.001 228 18.5827 228 23.001C228 27.4193 224.418 31.001 220 31.001C215.582 31.001 212 27.4193 212 23.001C212 18.5827 215.582 15.001 220 15.001ZM220 18.501L218.677 21.1807L215.72 21.6104L217.86 23.6963L217.355 26.6416L220 25.251L222.645 26.6416L222.14 23.6963L224.28 21.6104L221.323 21.1807L220 18.501ZM221 10L226 10.001V13.001L224.637 14.1386C223.531 13.5587 222.302 13.1798 221.001 13.0505L221 10ZM219 10L219 13.0504C217.698 13.1796 216.47 13.5584 215.364 14.138L214 13.001V10.001L219 10Z\" fill=\"black\"/><path d=\"M258.007 10.1033C256.605 9.64957 255.082 10.2807 254.412 11.5926L253.606 13.1697C253.51 13.3571 253.358 13.5095 253.17 13.6053L251.593 14.4111C250.281 15.0813 249.65 16.6049 250.104 18.0065L250.649 19.6915C250.714 19.8917 250.714 20.1073 250.649 20.3075L250.104 21.9925C249.65 23.3941 250.281 24.9177 251.593 25.588L253.17 26.3937C253.358 26.4895 253.51 26.6419 253.606 26.8293L254.412 28.4065C255.082 29.7184 256.605 30.3495 258.007 29.8958L259.692 29.3503C259.892 29.2855 260.108 29.2855 260.308 29.3503L261.993 29.8958C263.395 30.3495 264.918 29.7184 265.588 28.4065L266.394 26.8293C266.49 26.6419 266.642 26.4895 266.83 26.3937L268.407 25.588C269.719 24.9177 270.35 23.3941 269.896 21.9925L269.351 20.3075C269.286 20.1073 269.286 19.8917 269.351 19.6915L269.896 18.0065C270.35 16.6049 269.719 15.0813 268.407 14.4111L266.83 13.6053C266.642 13.5095 266.49 13.3571 266.394 13.1697L265.588 11.5926C264.918 10.2807 263.395 9.64957 261.993 10.1033L260.308 10.6487C260.108 10.7135 259.892 10.7135 259.692 10.6487L258.007 10.1033ZM254.76 19.7568L256.174 18.3425L259.002 21.171L264.659 15.5142L266.073 16.9284L259.002 23.9994L254.76 19.7568Z\" fill=\"black\"/><path d=\"M309 18.063V12C309 11.4477 308.552 11 308 11H307C305.021 12.9786 301.303 14.0873 299 14.6128V25.3872C301.303 25.9127 305.021 27.0214 307 29H308C308.552 29 309 28.5523 309 28V21.937C309.863 21.715 310.5 20.9319 310.5 20C310.5 19.0681 309.863 18.285 309 18.063ZM293 15C291.895 15 291 15.8954 291 17V23C291 24.1046 291.895 25 293 25H294L295 30H297V15H293Z\" fill=\"black\"/><path d=\"M339.111 20C339.566 22.004 341.358 23.5 343.5 23.5C345.642 23.5 347.434 22.004 347.889 20H350V28C350 28.5523 349.552 29 349 29H331C330.448 29 330 28.5523 330 28V20H339.111ZM333 24H335V26H333V24ZM343.5 21.5C342.119 21.5 341 20.3807 341 19C341 17.6193 342.119 16.5 343.5 16.5C344.881 16.5 346 17.6193 346 19C346 20.3807 344.881 21.5 343.5 21.5ZM339.111 18H330V12C330 11.4477 330.448 11 331 11H349C349.552 11 350 11.4477 350 12V18H347.889C347.434 15.996 345.642 14.5 343.5 14.5C341.358 14.5 339.566 15.996 339.111 18Z\" fill=\"black\"/><path d=\"M381 29V31H379V29H371C370.448 29 370 28.5523 370 28V14H390V28C390 28.5523 389.552 29 389 29H381ZM376 18C374.343 18 373 19.3431 373 21C373 22.6569 374.343 24 376 24C377.657 24 379 22.6569 379 21H376V18ZM381 18V20H387V18H381ZM381 22V24H387V22H381ZM370 11H390V13H370V11Z\" fill=\"black\"/><path d=\"M416 12C416 13.1046 415.105 14 414 14C412.895 14 412 13.1046 412 12C412 10.8954 412.895 10 414 10C415.105 10 416 10.8954 416 12ZM413 24V30H411V18C411 16.3432 412.343 15 414 15C414.821 15 415.564 15.3295 416.106 15.8633L418.48 18.1057L420.793 15.7929L422.207 17.2071L418.52 20.8943L417 19.4587V30H415V24H413ZM418 13H427V22H418V24H422.365L425.189 30H427.399L424.576 24H428C428.552 24 429 23.5523 429 23V12C429 11.4477 428.552 11 428 11H418V13Z\" fill=\"black\"/><path d=\"M450.005 17H469.005C469.557 17 470.005 17.4477 470.005 18V28C470.005 28.5523 469.557 29 469.005 29H451.005C450.453 29 450.005 28.5523 450.005 28V17ZM451.005 11H466.005V15H450.005V12C450.005 11.4477 450.453 11 451.005 11ZM463.005 22V24H466.005V22H463.005Z\" fill=\"black\"/><path d=\"M508.005 30H492.005C491.453 30 491.005 29.5523 491.005 29V11C491.005 10.4477 491.453 10 492.005 10H508.005C508.557 10 509.005 10.4477 509.005 11V29C509.005 29.5523 508.557 30 508.005 30ZM497.005 14H495.005V16C495.005 18.7614 497.243 21 500.005 21C502.766 21 505.005 18.7614 505.005 16V14H503.005V16C503.005 17.6568 501.662 19 500.005 19C498.348 19 497.005 17.6568 497.005 16V14Z\" fill=\"black\"/><path d=\"M14.0049 57H27.9433L28.4433 55H16.0049V53H29.7241C30.2764 53 30.7241 53.4477 30.7241 54C30.7241 54.0818 30.7141 54.1632 30.6942 54.2425L28.1942 64.2425C28.083 64.6877 27.683 65 27.2241 65H13.0049C12.4526 65 12.0049 64.5523 12.0049 64V52H10.0049V50H13.0049C13.5572 50 14.0049 50.4477 14.0049 51V57ZM14.0049 71C12.9003 71 12.0049 70.1046 12.0049 69C12.0049 67.8954 12.9003 67 14.0049 67C15.1095 67 16.0049 67.8954 16.0049 69C16.0049 70.1046 15.1095 71 14.0049 71ZM26.0049 71C24.9003 71 24.0049 70.1046 24.0049 69C24.0049 67.8954 24.9003 67 26.0049 67C27.1095 67 28.0049 67.8954 28.0049 69C28.0049 70.1046 27.1095 71 26.0049 71Z\" fill=\"black\"/><path d=\"M50.0049 67H70.0049V69H50.0049V67ZM50.0049 53L55.0049 56L60.0049 50L65.0049 56L70.0049 53V65H50.0049V53Z\" fill=\"black\"/><path d=\"M103.005 50.0039C105.214 50.0039 107.005 51.7948 107.005 54.0039C107.005 54.7329 106.81 55.4164 106.469 56.005L111.005 56.0039V58.0039H109.005V68.0039C109.005 68.5562 108.557 69.0039 108.005 69.0039H92.0049C91.4526 69.0039 91.0049 68.5562 91.0049 68.0039V58.0039H89.0049V56.0039L93.5407 56.005C93.1999 55.4164 93.0049 54.7329 93.0049 54.0039C93.0049 51.7948 94.7957 50.0039 97.0049 50.0039C98.2001 50.0039 99.2729 50.5281 100.006 51.3592C100.737 50.5281 101.81 50.0039 103.005 50.0039ZM101.005 58.0039H99.0049V68.0039H101.005V58.0039ZM97.0049 52.0039C95.9003 52.0039 95.0049 52.8993 95.0049 54.0039C95.0049 55.0583 95.8208 55.9221 96.8556 55.9984L97.0049 56.0039H99.0049V54.0039C99.0049 53.0023 98.2686 52.1726 97.3077 52.0267L97.1542 52.0094L97.0049 52.0039ZM103.005 52.0039C101.951 52.0039 101.087 52.8198 101.01 53.8546L101.005 54.0039V56.0039H103.005C104.059 56.0039 104.923 55.188 104.999 54.1532L105.005 54.0039C105.005 52.8993 104.11 52.0039 103.005 52.0039Z\" fill=\"black\"/><path d=\"M149.005 51C149.557 51 150.005 51.4477 150.005 52V57.5C148.624 57.5 147.505 58.6193 147.505 60C147.505 61.3807 148.624 62.5 150.005 62.5V68C150.005 68.5522 149.557 69 149.005 69H131.005C130.453 69 130.005 68.5522 130.005 68V62.5C131.386 62.5 132.505 61.3807 132.505 60C132.505 58.6193 131.386 57.5 130.005 57.5V52C130.005 51.4477 130.453 51 131.005 51H149.005ZM144.005 57H136.005V63H144.005V57Z\" fill=\"black\"/><path d=\"M179.005 69C179.005 68.1715 178.333 67.5 177.505 67.5C176.676 67.5 176.005 68.1715 176.005 69H171.005C170.453 69 170.005 68.5522 170.005 68V52C170.005 51.4477 170.453 51 171.005 51H176.005C176.005 51.8284 176.676 52.5 177.505 52.5C178.333 52.5 179.005 51.8284 179.005 51H189.005C189.557 51 190.005 51.4477 190.005 52V57.5C188.624 57.5 187.505 58.6193 187.505 60C187.505 61.3807 188.624 62.5 190.005 62.5V68C190.005 68.5522 189.557 69 189.005 69H179.005ZM177.505 58.5C178.333 58.5 179.005 57.8284 179.005 57C179.005 56.1716 178.333 55.5 177.505 55.5C176.676 55.5 176.005 56.1716 176.005 57C176.005 57.8284 176.676 58.5 177.505 58.5ZM177.505 64.5C178.333 64.5 179.005 63.8284 179.005 63C179.005 62.1715 178.333 61.5 177.505 61.5C176.676 61.5 176.005 62.1715 176.005 63C176.005 63.8284 176.676 64.5 177.505 64.5Z\" fill=\"black\"/><path d=\"M220.005 70.0039C214.482 70.0039 210.005 65.5268 210.005 60.0039C210.005 54.4811 214.482 50.0039 220.005 50.0039C225.528 50.0039 230.005 54.4811 230.005 60.0039C230.005 65.5268 225.528 70.0039 220.005 70.0039ZM220.005 57.0039H216.005V59.0039H225.005L220.005 54.0039V57.0039ZM215.005 61.0039L220.005 66.0039V63.0039H224.005V61.0039H215.005Z\" fill=\"black\"/><path d=\"M257.335 59.5034L259.505 59.5039C261.99 59.5039 264.005 61.5186 264.005 64.0039H257.004L257.005 65.0039L265.005 65.0031V64.0039C265.005 62.9215 264.687 61.9008 264.119 61.0031L267.005 61.0039C268.997 61.0039 270.717 62.1692 271.521 63.8553C269.156 66.9759 265.327 69.0039 261.005 69.0039C258.244 69.0039 255.904 68.4133 254.005 67.3791L254.006 58.0749C255.251 58.2533 256.391 58.7596 257.335 59.5034ZM253.005 67.0039C253.005 67.5562 252.557 68.0039 252.005 68.0039H250.005C249.453 68.0039 249.005 67.5562 249.005 67.0039V58.0039C249.005 57.4516 249.453 57.0039 250.005 57.0039H252.005C252.557 57.0039 253.005 57.4516 253.005 58.0039V67.0039ZM266.005 53.0039C267.662 53.0039 269.005 54.347 269.005 56.0039C269.005 57.6608 267.662 59.0039 266.005 59.0039C264.348 59.0039 263.005 57.6608 263.005 56.0039C263.005 54.347 264.348 53.0039 266.005 53.0039ZM259.005 50.0039C260.662 50.0039 262.005 51.347 262.005 53.0039C262.005 54.6608 260.662 56.0039 259.005 56.0039C257.348 56.0039 256.005 54.6608 256.005 53.0039C256.005 51.347 257.348 50.0039 259.005 50.0039Z\" fill=\"black\"/><path d=\"M298.904 50.1016L308.804 51.5158L310.218 61.4153L301.026 70.6076C300.635 70.9982 300.002 70.9982 299.611 70.6076L289.712 60.7082C289.321 60.3176 289.321 59.6845 289.712 59.2939L298.904 50.1016ZM301.733 58.5868C302.514 59.3679 303.78 59.3679 304.561 58.5868C305.342 57.8058 305.342 56.5395 304.561 55.7584C303.78 54.9774 302.514 54.9774 301.733 55.7584C300.952 56.5395 300.952 57.8058 301.733 58.5868Z\" fill=\"black\"/><path d=\"M336.005 53.0039H339.005V62.0039H336.005V65.0039H334.005V62.0039H331.005V53.0039H334.005V50.0039H336.005V53.0039ZM346.005 58.0039H349.005V67.0039H346.005V70.0039H344.005V67.0039H341.005V58.0039H344.005V55.0039H346.005V58.0039Z\" fill=\"black\"/><path d=\"M371.901 65.8647L375.812 61.9537L378.641 64.7821L383.212 60.211L385.005 62.0039V57.0039H380.005L381.798 58.7968L378.641 61.9537L375.812 59.1252L370.867 64.0711C370.313 62.8285 370.005 61.4522 370.005 60.0039C370.005 54.4811 374.482 50.0039 380.005 50.0039C385.528 50.0039 390.005 54.4811 390.005 60.0039C390.005 65.5268 385.528 70.0039 380.005 70.0039C376.671 70.0039 373.718 68.3726 371.901 65.8647Z\" fill=\"black\"/><path d=\"M429 56C430.105 56 431 56.8954 431 58V62C431 63.1046 430.105 64 429 64H427.938C427.446 67.9463 424.08 71 420 71V69C423.314 69 426 66.3137 426 63V57C426 53.6863 423.314 51 420 51C416.686 51 414 53.6863 414 57V64H411C409.895 64 409 63.1046 409 62V58C409 56.8954 409.895 56 411 56H412.062C412.554 52.0537 415.92 49 420 49C424.08 49 427.446 52.0537 427.938 56H429ZM415.759 63.7849L416.82 62.0887C417.742 62.6662 418.832 63 420 63C421.168 63 422.258 62.6662 423.18 62.0887L424.241 63.7849C423.011 64.5549 421.558 65 420 65C418.442 65 416.989 64.5549 415.759 63.7849Z\" fill=\"black\"/><path d=\"M462 52.5V57C467.523 57 472 61.4772 472 67C472 67.2727 471.989 67.5428 471.968 67.81C470.505 65.0364 467.638 63.119 464.313 63.0053L464 63H462L462 67.5L454 60L462 52.5ZM456 52.5V55.237L450.92 60L455.999 64.761L456 67.5L448 60L456 52.5Z\" fill=\"black\"/><path d=\"M489.946 57.317C489.424 57.1428 489.42 56.8618 489.957 56.6827L509.043 50.3206C509.572 50.1444 509.875 50.4402 509.727 50.9585L504.274 70.0448C504.123 70.5732 503.818 70.5916 503.595 70.0892L500 62.0016L506 54.0016L498 60.0016L489.946 57.317Z\" fill=\"black\"/><path d=\"M11 91H29C29.5523 91 30 91.4477 30 92V108C30 108.552 29.5523 109 29 109H11C10.4477 109 10 108.552 10 108V92C10 91.4477 10.4477 91 11 91ZM20.0606 99.6829L13.6472 94.2377L12.3528 95.7623L20.0731 102.317L27.6544 95.7562L26.3456 94.2438L20.0606 99.6829Z\" fill=\"black\"/><path d=\"M58 91H62C66.4183 91 70 94.5817 70 99C70 103.418 66.4183 107 62 107V110.5C57 108.5 50 105.5 50 99C50 94.5817 53.5817 91 58 91Z\" fill=\"black\"/><path d=\"M94.4545 107L90 110.5V92C90 91.4477 90.4477 91 91 91H109C109.552 91 110 91.4477 110 92V106C110 106.552 109.552 107 109 107H94.4545ZM99 101V103H101V101H99ZM99 95V100H101V95H99Z\" fill=\"black\"/><path d=\"M149 91C149.552 91 150 91.4477 150 92V106C150 106.552 149.552 107 149 107H134.455L130 110.5V92C130 91.4477 130.448 91 131 91H149ZM141 95H139V103H141V95ZM145 97H143V103H145V97ZM137 99H135V103H137V99Z\" fill=\"black\"/><path d=\"M174.455 107L170 110.5V92C170 91.4477 170.448 91 171 91H189C189.552 91 190 91.4477 190 92V106C190 106.552 189.552 107 189 107H174.455ZM182 98.25V96H175V102H182V99.75L185 102V96L182 98.25Z\" fill=\"black\"/><path d=\"M211 91H220.382C220.761 91 221.107 91.214 221.276 91.5528L222 93H228C228.552 93 229 93.4477 229 94V105C229 105.552 228.552 106 228 106H221.618C221.239 106 220.893 105.786 220.724 105.447L220 104H213V110H211V91Z\" fill=\"black\"/><path d=\"M260 90C265.523 90 270 94.4771 270 100C270 105.523 265.523 110 260 110C254.477 110 250 105.523 250 100C250 94.4771 254.477 90 260 90ZM264.004 100.878C263.659 100.353 263.41 99.9746 262.462 100.125C260.672 100.409 260.473 100.722 260.388 101.238L260.364 101.394L260.339 101.56C260.242 102.243 260.245 102.501 260.559 102.831C261.824 104.158 262.582 105.115 262.812 105.675C262.924 105.948 263.212 106.775 263.014 107.593C264.237 107.107 265.316 106.333 266.165 105.356C266.276 104.982 266.355 104.517 266.355 103.952V103.847C266.355 102.925 266.355 102.504 265.703 102.131C265.428 101.975 265.223 101.881 265.058 101.806C264.691 101.639 264.448 101.53 264.12 101.05C264.081 100.993 264.042 100.936 264.004 100.878ZM260 91.8333C257.683 91.8333 255.591 92.7986 254.104 94.349C254.281 94.4719 254.435 94.6445 254.541 94.8826C254.745 95.3403 254.745 95.8112 254.745 96.2276C254.745 96.5562 254.744 96.8672 254.85 97.093C254.994 97.4013 255.616 97.5323 256.165 97.6474C256.362 97.6887 256.564 97.7308 256.748 97.7818C257.254 97.9223 257.646 98.3765 257.959 98.7412C258.09 98.8931 258.282 99.1163 258.378 99.1717C258.429 99.1356 258.59 98.9608 258.67 98.6735C258.731 98.4547 258.713 98.2597 258.624 98.1543C258.065 97.4944 258.095 96.2232 258.268 95.755C258.54 95.0161 259.391 95.0706 260.012 95.111C260.244 95.1259 260.463 95.1402 260.626 95.1198C261.248 95.0417 261.44 94.0954 261.575 93.91C261.867 93.5098 262.761 92.9071 263.316 92.5345C262.302 92.0838 261.181 91.8333 260 91.8333Z\" fill=\"black\"/><path d=\"M298 94V96H293V107H304V102H306V108C306 108.552 305.552 109 305 109H292C291.448 109 291 108.552 291 108V95C291 94.4477 291.448 94 292 94H298ZM309 91V100L305.206 96.207L299.207 102.207L297.793 100.793L303.792 94.793L300 91H309Z\" fill=\"black\"/><path d=\"M342.121 98.4807C341.731 98.0901 341.098 98.0901 340.707 98.4807L340 99.1878C339.219 99.9688 337.953 99.9688 337.172 99.1878C336.39 98.4067 336.39 97.1403 337.172 96.3593L342.802 90.7271C344.906 90.2512 347.201 90.8322 348.839 92.4702C351.258 94.8896 351.372 98.7417 349.179 101.295L347.071 103.43L342.121 98.4807ZM331.161 92.4702C333.335 90.2968 336.664 89.9843 339.17 91.5326L335.757 94.9451C334.195 96.5072 334.195 99.0399 335.757 100.602C337.272 102.117 339.699 102.163 341.269 100.74L341.414 100.602L345.657 104.845L341.414 109.087C340.633 109.868 339.367 109.868 338.586 109.087L331.161 101.663C328.623 99.1242 328.623 95.0086 331.161 92.4702Z\" fill=\"black\"/><path d=\"M384 90H372C371.448 90 371 90.4477 371 91V109C371 109.552 371.448 110 372 110H380.255C379.464 108.866 379 107.487 379 106C379 102.134 382.134 99 386 99C387.074 99 388.091 99.2417 389 99.6736V95L384 90ZM381.786 103.327C381.825 102.6 382.386 102.008 383.11 101.931L383.981 101.839C384.084 101.828 384.181 101.785 384.259 101.715L384.91 101.13C385.452 100.643 386.267 100.622 386.833 101.08L387.514 101.63C387.595 101.695 387.695 101.733 387.799 101.739L388.673 101.786C389.4 101.825 389.992 102.386 390.069 103.11L390.161 103.981C390.172 104.084 390.215 104.181 390.285 104.259L390.87 104.91C391.357 105.452 391.378 106.267 390.92 106.833L390.37 107.514C390.305 107.595 390.267 107.695 390.261 107.799L390.214 108.673C390.175 109.4 389.614 109.992 388.89 110.069L388.019 110.161C387.916 110.172 387.819 110.215 387.741 110.285L387.09 110.87C386.548 111.357 385.733 111.378 385.167 110.92L384.486 110.37C384.405 110.305 384.305 110.267 384.201 110.261L383.327 110.214C382.6 110.175 382.008 109.614 381.931 108.89L381.839 108.019C381.828 107.916 381.785 107.819 381.715 107.741L381.13 107.09C380.643 106.548 380.622 105.733 381.08 105.167L381.63 104.486C381.695 104.405 381.733 104.305 381.739 104.201L381.786 103.327ZM389.03 105.03L387.97 103.97L385.5 106.439L384.03 104.97L382.97 106.03L384.97 108.03L385.5 108.561L386.03 108.03L389.03 105.03Z\" fill=\"black\"/><path d=\"M410 99H430V108C430 108.552 429.552 109 429 109H411C410.448 109 410 108.552 410 108V99ZM425 91H429C429.552 91 430 91.4477 430 92V97H410V92C410 91.4477 410.448 91 411 91H415V89H417V91H423V89H425V91Z\" fill=\"black\"/><path d=\"M465.618 93.9681L467.071 92.5147L468.485 93.9289L467.032 95.3823C468.264 96.922 469 98.875 469 101C469 105.971 464.971 110 460 110C455.029 110 451 105.971 451 101C451 96.0294 455.029 92 460 92C462.125 92 464.078 92.7365 465.618 93.9681ZM459 96V102H461V96H459ZM456 89H464V91H456V89Z\" fill=\"black\"/><path d=\"M500 110C494.477 110 490 105.523 490 100C490 94.4771 494.477 90 500 90C505.523 90 510 94.4771 510 100C510 105.523 505.523 110 500 110ZM495 100C495 102.761 497.239 105 500 105C502.761 105 505 102.761 505 100H503C503 101.657 501.657 103 500 103C498.343 103 497 101.657 497 100H495Z\" fill=\"black\"/><path d=\"M9 133C9 132.448 9.44772 132 10 132H30C30.5523 132 31 132.448 31 133V147C31 147.552 30.5523 148 30 148H10C9.44772 148 9 147.552 9 147V133ZM21 136V138H27V136H21ZM26 140H21V142H26V140ZM18.5 138C18.5 136.619 17.3807 135.5 16 135.5C14.6193 135.5 13.5 136.619 13.5 138C13.5 139.381 14.6193 140.5 16 140.5C17.3807 140.5 18.5 139.381 18.5 138ZM16 141.5C14.067 141.5 12.5 143.067 12.5 145H19.5C19.5 143.067 17.933 141.5 16 141.5Z\" fill=\"black\"/><path d=\"M60 142V150H52C52 145.582 55.5817 142 60 142ZM60 141C56.685 141 54 138.315 54 135C54 131.685 56.685 129 60 129C63.315 129 66 131.685 66 135C66 138.315 63.315 141 60 141ZM69 145H70V150H62V145H63V144C63 142.343 64.3431 141 66 141C67.6569 141 69 142.343 69 144V145ZM67 145V144C67 143.448 66.5523 143 66 143C65.4477 143 65 143.448 65 144V145H67Z\" fill=\"black\"/><path d=\"M92 130H108C108.552 130 109 130.448 109 131V150.276C109 150.553 108.776 150.776 108.5 150.776C108.43 150.776 108.36 150.762 108.296 150.733L100 147.031L91.7037 150.733C91.4516 150.846 91.1559 150.732 91.0434 150.48C91.0148 150.416 91 150.347 91 150.276V131C91 130.448 91.4477 130 92 130ZM100 141.5L102.939 143.045L102.378 139.773L104.755 137.455L101.469 136.977L100 134L98.5305 136.977L95.2447 137.455L97.6224 139.773L97.0611 143.045L100 141.5Z\" fill=\"black\"/><path d=\"M135 133V130C135 129.448 135.448 129 136 129H144C144.552 129 145 129.448 145 130V133H149C149.552 133 150 133.448 150 134V148C150 148.552 149.552 149 149 149H131C130.448 149 130 148.552 130 148V134C130 133.448 130.448 133 131 133H135ZM132 143V147H148V143H132ZM139 139V141H141V139H139ZM137 131V133H143V131H137Z\" fill=\"black\"/><path d=\"M188 148C188 148.552 187.552 149 187 149H173C172.448 149 172 148.552 172 148V139H169L179.327 129.612C179.709 129.265 180.291 129.265 180.673 129.612L191 139H188V148ZM176.592 141.808L175.601 142.38L176.602 144.113L177.594 143.54C177.988 143.912 178.467 144.193 178.999 144.351V145.496H181.001V144.351C181.533 144.193 182.012 143.912 182.406 143.54L183.398 144.113L184.399 142.38L183.408 141.808C183.47 141.548 183.502 141.277 183.502 140.998C183.502 140.719 183.47 140.448 183.408 140.188L184.399 139.616L183.398 137.882L182.406 138.456C182.012 138.084 181.533 137.803 181.001 137.644V136.5H178.999V137.644C178.467 137.803 177.987 138.084 177.594 138.456L176.602 137.882L175.601 139.616L176.592 140.188C176.53 140.448 176.498 140.719 176.498 140.998C176.498 141.277 176.53 141.548 176.592 141.808ZM180 142.497C179.171 142.497 178.499 141.826 178.499 140.998C178.499 140.17 179.171 139.499 180 139.499C180.829 139.499 181.501 140.17 181.501 140.998C181.501 141.826 180.829 142.497 180 142.497Z\" fill=\"black\"/><path d=\"M229 141V148C229 148.552 228.552 149 228 149H212C211.448 149 211 148.552 211 148V141H210V139L211 134H229L230 139V141H229ZM213 141V147H227V141H213ZM214 142H222V145H214V142ZM211 131H229V133H211V131Z\" fill=\"black\"/><path d=\"M250 148H270V150H250V148ZM252 140H254V147H252V140ZM257 140H259V147H257V140ZM261 140H263V147H261V140ZM266 140H268V147H266V140ZM250 135L260 130L270 135V139H250V135ZM260 136C260.552 136 261 135.552 261 135C261 134.448 260.552 134 260 134C259.448 134 259 134.448 259 135C259 135.552 259.448 136 260 136Z\" fill=\"black\"/><path d=\"M310.005 138V148C310.005 148.552 309.557 149 309.005 149H291.005C290.453 149 290.005 148.552 290.005 148V138H310.005ZM310.005 136H290.005V132C290.005 131.448 290.453 131 291.005 131H309.005C309.557 131 310.005 131.448 310.005 132V136ZM303.005 144V146H307.005V144H303.005Z\" fill=\"black\"/><path d=\"M338 138.111V129L349 135V149H331V135L338 138.111Z\" fill=\"black\"/><path d=\"M377 147H380V140.942L376 137.454L372 140.942V147H375V143H377V147ZM389 149H371C370.448 149 370 148.552 370 148V140.487C370 140.198 370.125 139.923 370.343 139.733L374 136.544V132C374 131.448 374.448 131 375 131H389C389.552 131 390 131.448 390 132V148C390 148.552 389.552 149 389 149ZM384 139V141H386V139H384ZM384 143V145H386V143H384ZM384 135V137H386V135H384ZM380 135V137H382V135H380Z\" fill=\"black\"/><path d=\"M425 135C421.57 135 418.645 137.158 417.507 140.19L419.38 140.893C420.234 138.619 422.428 137 425 137C425.698 137 426.369 137.119 426.992 137.339C429.327 138.16 431 140.385 431 143C431 146.314 428.314 149 425 149H415C411.686 149 409 146.314 409 143C409 140.385 410.673 138.16 413.008 137.339C413.003 137.226 413 137.114 413 137C413 133.134 416.134 130 420 130C423.242 130 425.969 132.204 426.765 135.195C426.197 135.068 425.607 135 425 135Z\" fill=\"black\"/><path d=\"M468.997 130.992L469 149.008C469 149.545 468.555 150 468.007 150H451.993C451.445 150 451 149.556 451 149.008V130.992C451 130.455 451.445 130 451.993 130H468.004C468.552 130 468.997 130.444 468.997 130.992ZM457 141V137C457 136.448 457.448 136 458 136C458.552 136 459 136.448 459 137V141C459 141.552 459.448 142 460 142C460.552 142 461 141.552 461 141V137C461 135.343 459.657 134 458 134C456.343 134 455 135.343 455 137V141C455 143.761 457.239 146 460 146C462.761 146 465 143.761 465 141V136H463V141C463 142.657 461.657 144 460 144C458.343 144 457 142.657 457 141Z\" fill=\"black\"/><path d=\"M494 132V136H506V132H508.007C508.555 132 509 132.445 509 132.993V149.007C509 149.555 508.555 150 508.007 150H491.993C491.445 150 491 149.555 491 149.007V132.993C491 132.445 491.445 132 491.993 132H494ZM497 145H495V147H497V145ZM497 142H495V144H497V142ZM497 139H495V141H497V139ZM504 130V134H496V130H504Z\" fill=\"black\"/><path d=\"M28 170C28.5523 170 29 170.448 29 171V174.757L20.0012 183.756L19.995 187.995L24.2414 188.001L29 183.242V189C29 189.552 28.5523 190 28 190H12C11.4477 190 11 189.552 11 189V171C11 170.448 11.4477 170 12 170H28ZM29.7782 176.808L31.1924 178.222L23.4142 186L21.9979 185.998L22 184.586L29.7782 176.808ZM20 180H15V182H20V180ZM23 176H15V178H23V176Z\" fill=\"black\"/><path d=\"M51 171C60.9411 171 69 179.059 69 189H66C66 180.716 59.2843 174 51 174V171ZM51 178C57.0751 178 62 182.925 62 189H59C59 184.582 55.4183 181 51 181V178ZM51 185C53.2091 185 55 186.791 55 189H51V185Z\" fill=\"black\"/><path d=\"M100 180.999L106 189.999H94L100 180.999ZM98.9393 178.559C98.3536 177.974 98.3536 177.024 98.9393 176.438C99.5251 175.852 100.475 175.852 101.061 176.438C101.646 177.024 101.646 177.974 101.061 178.559C100.475 179.145 99.5251 179.145 98.9393 178.559ZM93.2825 170.781L94.6967 172.195C91.7678 175.124 91.7678 179.873 94.6967 182.802L93.2825 184.216C89.5725 180.506 89.5725 174.491 93.2825 170.781ZM106.718 170.781C110.428 174.491 110.428 180.506 106.718 184.216L105.303 182.802C108.232 179.873 108.232 175.124 105.303 172.195L106.718 170.781ZM96.1109 173.61L97.5251 175.024C96.1583 176.391 96.1583 178.607 97.5251 179.974L96.1109 181.388C93.963 179.24 93.963 175.758 96.1109 173.61ZM103.889 173.61C106.037 175.758 106.037 179.24 103.889 181.388L102.475 179.974C103.842 178.607 103.842 176.391 102.475 175.024L103.889 173.61Z\" fill=\"black\"/><path d=\"M146.031 184.617L150.314 188.899L148.899 190.314L144.617 186.031C143.077 187.263 141.124 188 139 188C134.032 188 130 183.968 130 179C130 174.032 134.032 170 139 170C143.968 170 148 174.032 148 179C148 181.124 147.263 183.077 146.031 184.617Z\" fill=\"black\"/><path d=\"M180.001 186.26L172.947 190.208L174.522 182.28L168.588 176.792L176.615 175.84L180.001 168.5L183.386 175.84L191.413 176.792L185.479 182.28L187.054 190.208L180.001 186.26Z\" fill=\"black\"/><path d=\"M225 177.2L230.213 173.551C230.44 173.392 230.751 173.447 230.91 173.674C230.968 173.758 231 173.858 231 173.96V186.04C231 186.316 230.776 186.54 230.5 186.54C230.397 186.54 230.297 186.508 230.213 186.449L225 182.8V187C225 187.552 224.552 188 224 188H210C209.448 188 209 187.552 209 187V173C209 172.448 209.448 172 210 172H224C224.552 172 225 172.448 225 173V177.2Z\" fill=\"black\"/><path d=\"M250 174.001C250 173.448 250.455 173 250.992 173H269.008C269.556 173 270 173.445 270 174.001V187.999C270 188.552 269.545 189 269.008 189H250.992C250.444 189 250 188.555 250 187.999V174.001ZM262 186C264.761 186 267 183.761 267 181C267 178.239 264.761 176 262 176C259.239 176 257 178.239 257 181C257 183.761 259.239 186 262 186ZM252 175V177H255V175H252ZM252 170H258V172H252V170Z\" fill=\"black\"/><path d=\"M292 170H308C308.552 170 309 170.448 309 171V189C309 189.552 308.552 190 308 190H292C291.448 190 291 189.552 291 189V171C291 170.448 291.448 170 292 170ZM300 188C302.761 188 305 185.761 305 183C305 180.239 302.761 178 300 178C297.239 178 295 180.239 295 183C295 185.761 297.239 188 300 188ZM300 176C300.828 176 301.5 175.328 301.5 174.5C301.5 173.672 300.828 173 300 173C299.172 173 298.5 173.672 298.5 174.5C298.5 175.328 299.172 176 300 176ZM300 186C298.343 186 297 184.657 297 183C297 181.343 298.343 180 300 180C301.657 180 303 181.343 303 183C303 184.657 301.657 186 300 186Z\" fill=\"black\"/><path d=\"M332 180H335C336.105 180 337 180.895 337 182V187C337 188.105 336.105 189 335 189H332C330.895 189 330 188.105 330 187V180C330 174.477 334.477 170 340 170C345.523 170 350 174.477 350 180V187C350 188.105 349.105 189 348 189H345C343.895 189 343 188.105 343 187V182C343 180.895 343.895 180 345 180H348C348 175.582 344.418 172 340 172C335.582 172 332 175.582 332 180Z\" fill=\"black\"/><path d=\"M388 185H390V187H370V185H372V178C372 173.582 375.582 170 380 170C384.418 170 388 173.582 388 178V185ZM377 189H383V191H377V189Z\" fill=\"black\"/><path d=\"M421 190C415.477 190 411 185.523 411 180C411 174.477 415.477 170 421 170C426.523 170 431 174.477 431 180C431 185.523 426.523 190 421 190ZM416 179.5L420 181L421.5 185.002L425 176L416 179.5Z\" fill=\"black\"/><path d=\"M469.902 178.598C469.444 178.533 468.976 178.5 468.5 178.5C465.24 178.5 462.346 180.06 460.521 182.471C460.35 182.489 460.176 182.498 460 182.498C458.719 182.498 457.552 182.017 456.667 181.225L455.333 182.715C456.419 183.687 457.811 184.325 459.347 184.468C458.802 185.702 458.5 187.066 458.5 188.5C458.5 188.976 458.533 189.444 458.598 189.902C453.739 189.22 450 185.047 450 180C450 174.477 454.477 170 460 170C465.047 170 469.22 173.739 469.902 178.598ZM469.871 180.617C469.425 180.54 468.967 180.5 468.5 180.5C465.766 180.5 463.351 181.871 461.907 183.967C461.019 185.256 460.5 186.816 460.5 188.5C460.5 188.967 460.54 189.425 460.617 189.871L469.871 180.617ZM456.5 179.5C457.328 179.5 458 178.828 458 178C458 177.172 457.328 176.5 456.5 176.5C455.672 176.5 455 177.172 455 178C455 178.828 455.672 179.5 456.5 179.5ZM463.5 179.5C464.328 179.5 465 178.828 465 178C465 177.172 464.328 176.5 463.5 176.5C462.672 176.5 462 177.172 462 178C462 178.828 462.672 179.5 463.5 179.5Z\" fill=\"black\"/><path d=\"M500 190C494.477 190 490 185.523 490 180C490 174.477 494.477 170 500 170C505.523 170 510 174.477 510 180C510 185.523 505.523 190 500 190ZM508 180C508 175.582 504.418 172 500 172C495.582 172 492 175.582 492 180C492 184.418 495.582 188 500 188C501.47 188 502.848 187.603 504.032 186.911L503.024 185.184C502.136 185.703 501.103 186 500 186C496.686 186 494 183.314 494 180C494 176.686 496.686 174 500 174C503.314 174 506 176.686 506 180V181C506 181.552 505.552 182 505 182C504.448 182 504 181.552 504 181V177H502.646C501.941 176.378 501.014 176 500 176C497.791 176 496 177.791 496 180C496 182.209 497.791 184 500 184C501.046 184 501.999 183.598 502.712 182.94C503.262 183.589 504.083 184 505 184C506.657 184 508 182.657 508 181V180ZM500 178C501.105 178 502 178.895 502 180C502 181.105 501.105 182 500 182C498.895 182 498 181.105 498 180C498 178.895 498.895 178 500 178Z\" fill=\"black\"/></svg>');
    }
    &.mautic-theme:before {
        background-image: url('data:image/svg+xml,<svg width=\"520\" height=\"200\" viewBox=\"0 0 520 200\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12.929 29.4825L18.775 23.6365C19.4423 23.8147 20.1837 23.642 20.7071 23.1186C21.4882 22.3375 21.4882 21.0712 20.7071 20.2902C19.9261 19.5091 18.6598 19.5091 17.8787 20.2902C17.3553 20.8136 17.1826 21.555 17.3608 22.2223L11.5148 28.0683L10.4541 27.0077C13.2825 23.7078 14.3432 20.0545 15.7574 13.9262L22.1214 13.2191L27.7783 18.876L27.0711 25.2399C20.9429 26.6541 17.2895 27.7148 13.9896 30.5432L12.929 29.4825ZM24.5962 10.0371L30.9428 16.3837C31.1381 16.579 31.1381 16.8956 30.9428 17.0908C30.8679 17.1658 30.7712 17.2149 30.6665 17.2313L29.1924 17.4618L23.5356 11.8049L23.7477 10.32C23.7868 10.0466 24.04 9.85666 24.3134 9.89571C24.4205 9.91101 24.5197 9.96063 24.5962 10.0371Z\" fill=\"black\"/><path d=\"M64 16.9961L68.3714 18.7446C68.751 18.8965 69 19.2642 69 19.6731V28.9961C69 29.5484 68.5523 29.9961 68 29.9961H52C51.4477 29.9961 51 29.5484 51 28.9961V19.6731C51 19.2642 51.2489 18.8965 51.6286 18.7446L56 16.9961H64ZM68 21.9961H56V26.9961H68V21.9961ZM64 10.9961C64.5523 10.9961 65 11.4438 65 11.9961V15.9961H55V11.9961C55 11.4438 55.4477 10.9961 56 10.9961H64Z\" fill=\"black\"/><path d=\"M103.95 10.3906L109.607 16.0474C109.997 16.4379 109.997 17.0711 109.607 17.4616L101.829 25.2398L99.7071 25.9469L98.2929 27.3611C97.9024 27.7517 97.2693 27.7517 96.8787 27.3611L92.6361 23.1185C92.2456 22.728 92.2456 22.0948 92.6361 21.7043L94.0503 20.2901L94.7574 18.1687L102.536 10.3906C102.926 10 103.559 10 103.95 10.3906ZM104.657 13.9261L98.2929 20.2901L99.7071 21.7043L106.071 15.3403L104.657 13.9261ZM92.2825 24.8863L95.111 27.7147L93.6967 29.1289L89.4541 27.7147L92.2825 24.8863Z\" fill=\"black\"/><path d=\"M140 29.9961C134.477 29.9961 130 25.5189 130 19.9961C130 14.4732 134.477 9.99609 140 9.99609C145.523 9.99609 150 14.4732 150 19.9961C150 25.5189 145.523 29.9961 140 29.9961ZM145.051 26.2002L144.189 22.7536C144.078 22.3084 143.678 21.9961 143.219 21.9961H136.781C136.322 21.9961 135.922 22.3084 135.811 22.7536L134.949 26.2002C136.326 27.3229 138.084 27.9961 140 27.9961C141.916 27.9961 143.674 27.3229 145.051 26.2002ZM138 19.9961H142V18.4961L140.962 14.8614C140.867 14.5292 140.607 14.2695 140.275 14.1746C139.744 14.0229 139.19 14.3304 139.038 14.8614L138 18.4961V19.9961Z\" fill=\"black\"/><path d=\"M185 16H175V18H179V25H181V18H185V16ZM172 11H188C188.552 11 189 11.4477 189 12V28C189 28.5523 188.552 29 188 29H172C171.448 29 171 28.5523 171 28V12C171 11.4477 171.448 11 172 11Z\" fill=\"black\"/><path d=\"M213 26V28H217V26H213ZM211 15L215 10L219 15V30H211V15ZM229 16H227V18H229V20H226V22H229V24H227V26H229V29C229 29.5523 228.552 30 228 30H222C221.448 30 221 29.5523 221 29V13C221 12.4477 221.448 12 222 12H228C228.552 12 229 12.4477 229 13V16Z\" fill=\"black\"/><path d=\"M253.636 14.6335L260 8.26953L266.364 14.6335C269.879 18.1482 269.879 23.8467 266.364 27.3614C262.849 30.8761 257.151 30.8761 253.636 27.3614C250.121 23.8467 250.121 18.1482 253.636 14.6335Z\" fill=\"black\"/><path d=\"M300 29.9961C294.477 29.9961 290 25.519 290 19.9961C290 14.4733 294.477 9.99609 300 9.99609C305.523 9.99609 310 14.4733 310 19.9961C310 25.519 305.523 29.9961 300 29.9961ZM293.329 24.4214C294.764 26.5669 297.209 27.9797 299.984 27.9797C304.402 27.9797 307.984 24.3979 307.984 19.9797C307.984 17.2047 306.571 14.7597 304.425 13.3249C305.271 16.3526 304.502 19.7363 302.121 22.1175C299.74 24.4987 296.357 25.2666 293.329 24.4214Z\" fill=\"black\"/><path d=\"M348 18.9961V15.9961H342V11.9961H338V15.9961H332V18.9961H348ZM349 20.9961V28.9961C349 29.5484 348.552 29.9961 348 29.9961H338V23.9961H336V29.9961H332C331.448 29.9961 331 29.5484 331 28.9961V20.9961H330V14.9961C330 14.4438 330.448 13.9961 331 13.9961H336V10.9961C336 10.4438 336.448 9.99609 337 9.99609H343C343.552 9.99609 344 10.4438 344 10.9961V13.9961H349C349.552 13.9961 350 14.4438 350 14.9961V20.9961H349Z\" fill=\"black\"/><path d=\"M381.96 14.5002L384.789 11.6718C385.179 11.2813 385.812 11.2813 386.203 11.6718L388.324 13.7931C388.715 14.1836 388.715 14.8168 388.324 15.2073L385.496 18.0357L387.264 19.8035L385.849 21.2177L378.778 14.1467L380.192 12.7325L381.96 14.5002ZM378.778 16.9751L383.021 21.2177L375.243 28.9959H371V24.7532L378.778 16.9751Z\" fill=\"black\"/><path d=\"M416.586 25H411V23H429V25H423.414L426.657 28.2426L425.243 29.6569L421 25.4142V28H419V25.4142L414.757 29.6569L413.343 28.2426L416.586 25ZM413 11H427C427.552 11 428 11.4477 428 12V22H412V12C412 11.4477 412.448 11 413 11Z\" fill=\"black\"/><path d=\"M467 25H470V27H467V30H465V27H454C453.448 27 453 26.5523 453 26V15H450V13H453V10H455V13H466C466.552 13 467 13.4477 467 14V25Z\" fill=\"black\"/><path d=\"M507.228 26.7307L508.995 24.9629L510.763 26.7307C511.739 27.707 511.739 29.2899 510.763 30.2662C509.787 31.2425 508.204 31.2425 507.228 30.2662C506.251 29.2899 506.251 27.707 507.228 26.7307ZM496.879 9.07812L508.192 20.3918C508.583 20.7823 508.583 21.4155 508.192 21.806L499.707 30.2913C499.316 30.6818 498.683 30.6818 498.293 30.2913L489.808 21.806C489.417 21.4155 489.417 20.7823 489.808 20.3918L497.586 12.6137L495.464 10.4923L496.879 9.07812ZM499 14.0279L491.929 21.0989H506.071L499 14.0279Z\" fill=\"black\"/><path d=\"M12.929 61.3136L15.0503 63.4349L16.4646 62.0207L14.3432 59.8994L16.4646 57.7781L19.293 60.6065L20.7072 59.1923L17.8788 56.3639L20.0001 54.2426L22.1214 56.3639L23.5356 54.9497L21.4143 52.8283L24.2427 49.9999C24.6332 49.6094 25.2664 49.6094 25.6569 49.9999L30.6067 54.9497C30.9972 55.3402 30.9972 55.9734 30.6067 56.3639L15.7574 71.2131C15.3669 71.6036 14.7338 71.6036 14.3432 71.2131L9.39348 66.2634C9.00295 65.8728 9.00295 65.2397 9.39348 64.8492L12.929 61.3136Z\" fill=\"black\"/><path d=\"M61.9999 66.9982H68.9999V68.9982H59.9999L56.0023 69.0007L49.5146 62.5129C49.124 62.1224 49.124 61.4893 49.5146 61.0987L60.1212 50.4921C60.5117 50.1016 61.1449 50.1016 61.5354 50.4921L69.3136 58.2703C69.7041 58.6608 69.7041 59.294 69.3136 59.6845L61.9999 66.9982ZM63.6567 62.5129L67.1922 58.9774L60.8283 52.6134L57.2928 56.149L63.6567 62.5129Z\" fill=\"black\"/><path d=\"M97.6835 55.5582L100 57.8748L106.374 51.5004C107.155 50.7194 108.422 50.7194 109.203 51.5004L109.91 52.2075L97.6835 64.434C97.8873 64.9139 98 65.4418 98 65.9961C98 68.2052 96.2091 69.9961 94 69.9961C91.7909 69.9961 90 68.2052 90 65.9961C90 63.787 91.7909 61.9961 94 61.9961C94.5543 61.9961 95.0822 62.1088 95.5622 62.3126L97.8787 59.9961L95.5622 57.6796C95.0822 57.8834 94.5543 57.9961 94 57.9961C91.7909 57.9961 90 56.2052 90 53.9961C90 51.787 91.7909 49.9961 94 49.9961C96.2091 49.9961 98 51.787 98 53.9961C98 54.5504 97.8873 55.0783 97.6835 55.5582ZM94 55.9961C95.1046 55.9961 96 55.1007 96 53.9961C96 52.8915 95.1046 51.9961 94 51.9961C92.8954 51.9961 92 52.8915 92 53.9961C92 55.1007 92.8954 55.9961 94 55.9961ZM94 67.9961C95.1046 67.9961 96 67.1007 96 65.9961C96 64.8915 95.1046 63.9961 94 63.9961C92.8954 63.9961 92 64.8915 92 65.9961C92 67.1007 92.8954 67.9961 94 67.9961ZM103.535 61.4094L109.91 67.7847L109.203 68.4918C108.422 69.2728 107.155 69.2728 106.374 68.4918L101.413 63.5307L103.535 61.4094Z\" fill=\"black\"/><path d=\"M144.33 61.4964C145.956 60.2145 147 58.2272 147 55.9961H149C149 58.9681 147.559 61.6037 145.338 63.2426L147.866 67.6205C148.418 68.577 148.091 69.8002 147.134 70.3525L143.607 64.2441C142.503 64.7277 141.283 64.9961 140 64.9961C138.717 64.9961 137.497 64.7277 136.393 64.2441L132.866 70.3525C131.909 69.8002 131.582 68.577 132.134 67.6205L137.198 58.8502C136.458 58.1244 136 57.1138 136 55.9961C136 54.1323 137.275 52.5662 139 52.1221V49.9961H141V52.1221C142.725 52.5662 144 54.1323 144 55.9961C144 57.1138 143.542 58.1244 142.802 58.8502L144.33 61.4964ZM142.599 62.4977L141.071 59.8511C140.73 59.9456 140.371 59.9961 140 59.9961C139.629 59.9961 139.27 59.9456 138.929 59.8511L137.401 62.4977C138.205 62.8192 139.082 62.9961 140 62.9961C140.918 62.9961 141.795 62.8192 142.599 62.4977ZM140 56.9961C140.552 56.9961 141 56.5484 141 55.9961C141 55.4438 140.552 54.9961 140 54.9961C139.448 54.9961 139 55.4438 139 55.9961C139 56.5484 139.448 56.9961 140 56.9961Z\" fill=\"black\"/><path d=\"M184.572 56.0275C184.847 55.4078 185 54.7218 185 54C185 51.2386 182.761 49 180 49C177.238 49 175 51.2386 175 54C175 56.5826 176.958 58.7079 179.47 58.9723C180.686 57.2403 182.576 56.2078 184.572 56.0275ZM181.154 65.9462C181.996 64.1276 182.047 61.9741 181.155 60.0554C182.64 58.0118 185.459 57.3788 187.696 58.6701C190.087 60.0509 190.906 63.1086 189.526 65.5C188.145 67.8915 185.087 68.7109 182.696 67.3302C182.071 66.9694 181.553 66.4942 181.154 65.9462ZM174.273 58.0269C175.427 59.6652 177.267 60.786 179.375 60.9726C180.402 63.2807 179.54 66.0388 177.304 67.3301C174.912 68.7108 171.854 67.8914 170.473 65.5C169.093 63.1085 169.912 60.0505 172.304 58.6698C172.929 58.309 173.599 58.0984 174.273 58.0269Z\" fill=\"black\"/><path d=\"M220 50C225.522 50 230 53.9778 230 58.8889C230 61.9556 227.511 64.4444 224.444 64.4444H222.478C221.556 64.4444 220.811 65.1889 220.811 66.1111C220.811 66.5333 220.978 66.9222 221.233 67.2111C221.5 67.5111 221.667 67.9 221.667 68.3333C221.667 69.2556 220.9 70 220 70C214.478 70 210 65.5222 210 60C210 54.4778 214.478 50 220 50ZM215.5 60C216.328 60 217 59.3284 217 58.5C217 57.6716 216.328 57 215.5 57C214.672 57 214 57.6716 214 58.5C214 59.3284 214.672 60 215.5 60ZM224.5 60C225.328 60 226 59.3284 226 58.5C226 57.6716 225.328 57 224.5 57C223.672 57 223 57.6716 223 58.5C223 59.3284 223.672 60 224.5 60ZM220 57C220.828 57 221.5 56.3284 221.5 55.5C221.5 54.6716 220.828 54 220 54C219.172 54 218.5 54.6716 218.5 55.5C218.5 56.3284 219.172 57 220 57Z\" fill=\"black\"/><path d=\"M259 50V70H261V50H259ZM255 54V66H252V54H255ZM252 52C250.895 52 250 52.8954 250 54V66C250 67.1046 250.895 68 252 68H255C256.105 68 257 67.1046 257 66V54C257 52.8954 256.105 52 255 52H252ZM263 54C263 52.8954 263.895 52 265 52H268C269.105 52 270 52.8954 270 54V66C270 67.1046 269.105 68 268 68H265C263.895 68 263 67.1046 263 66V54Z\" fill=\"black\"/><path d=\"M290 51C290 50.4477 290.448 50 291 50H305C305.552 50 306 50.4477 306 51V54H309C309.552 54 310 54.4477 310 55V69C310 69.5523 309.552 70 309 70H295C294.448 70 294 69.5523 294 69V66H291C290.448 66 290 65.5523 290 65V51ZM296 66V68H299.439L297.439 66H296ZM299.561 66L301.561 68H304.439L302.439 66H299.561ZM308 68V66.5607L306 64.5607V65C306 65.5523 305.552 66 305 66H304.561L306.561 68H308ZM308 61.5607L306 59.5607V62.4393L308 64.4393V61.5607ZM308 59.4393V56H306V57.4393L308 59.4393Z\" fill=\"black\"/><path d=\"M340 49L346 59H334L340 49ZM341 61.5H349V69.5H341V61.5ZM334.75 70C337.373 70 339.5 67.8734 339.5 65.25C339.5 62.6266 337.373 60.5 334.75 60.5C332.127 60.5 330 62.6266 330 65.25C330 67.8734 332.127 70 334.75 70Z\" fill=\"black\"/><path d=\"M379.189 61.2637L380.572 69.1055L372 69.1062C371.448 69.1062 371 68.6585 371 68.1062L371 62.7085L379.189 61.2637ZM388 51.1062C388.553 51.1062 389 51.5539 389 52.1062V68.1062C389 68.6585 388.553 69.1062 388 69.1062L382.603 69.1055L379.429 51.1055L388 51.1062ZM377.398 51.1055L378.842 59.294L371 60.6775L371 52.1062C371 51.5539 371.448 51.1062 372 51.1062L377.398 51.1055Z\" fill=\"black\"/><path d=\"M422 58V62H418V58H422ZM424 58H429V62H424V58ZM422 69H418V64H422V69ZM424 69V64H429V68C429 68.5523 428.552 69 428 69H424ZM422 51V56H418V51H422ZM424 51H428C428.552 51 429 51.4477 429 52V56H424V51ZM416 58V62H411V58H416ZM416 69H412C411.448 69 411 68.5523 411 68V64H416V69ZM416 51V56H411V52C411 51.4477 411.448 51 412 51H416Z\" fill=\"black\"/><path d=\"M469 51C469.552 51 470 51.4477 470 52V68C470 68.5523 469.552 69 469 69H451C450.448 69 450 68.5523 450 68V52C450 51.4477 450.448 51 451 51H469ZM467 54H465V66H467V54Z\" fill=\"black\"/><path d=\"M503 69H497V58H503V69ZM505 69V58H510V68C510 68.5523 509.552 69 509 69H505ZM495 69H491C490.448 69 490 68.5523 490 68V58H495V69ZM510 56H490V52C490 51.4477 490.448 51 491 51H509C509.552 51 510 51.4477 510 52V56Z\" fill=\"black\"/><path d=\"M22 94H24V96H29C29.5523 96 30 96.4477 30 97V104.5L24 101L24.0359 109.062L26.2592 106.913L28.041 110H17C16.4477 110 16 109.552 16 109V104H14V102H16V97C16 96.4477 16.4477 96 17 96H22V94ZM30 105.338V109C30 109.107 29.9832 109.21 29.9521 109.307L27.9913 105.913L30 105.338ZM12 102V104H10V102H12ZM12 98V100H10V98H12ZM12 94V96H10V94H12ZM12 90V92H10V90H12ZM16 90V92H14V90H16ZM20 90V92H18V90H20ZM24 90V92H22V90H24Z\" fill=\"black\"/><path d=\"M68 98H71L67 103L63 98H66V96C66 94.3432 64.6569 93 63 93H59V91H63C65.7614 91 68 93.2386 68 96V98ZM61 97C61.5523 97 62 97.4477 62 98V108C62 108.552 61.5523 109 61 109H51C50.4477 109 50 108.552 50 108V98C50 97.4477 50.4477 97 51 97H61Z\" fill=\"black\"/><path d=\"M93 96C91.3432 96 90 94.6568 90 93C90 91.3432 91.3432 90 93 90C94.6568 90 96 91.3432 96 93C96 94.6568 94.6568 96 93 96ZM107 96C105.343 96 104 94.6568 104 93C104 91.3432 105.343 90 107 90C108.657 90 110 91.3432 110 93C110 94.6568 108.657 96 107 96ZM107 110C105.343 110 104 108.657 104 107C104 105.343 105.343 104 107 104C108.657 104 110 105.343 110 107C110 108.657 108.657 110 107 110ZM93 110C91.3432 110 90 108.657 90 107C90 105.343 91.3432 104 93 104C94.6568 104 96 105.343 96 107C96 108.657 94.6568 110 93 110ZM97 92H103V94H97V92ZM97 106H103V108H97V106ZM92 97H94V103H92V97ZM106 97H108V103H106V97Z\" fill=\"black\"/><path d=\"M132 106.922L130.651 106.377C130.138 106.17 129.891 105.587 130.098 105.075L132 100.367V106.922ZM136.86 109H135C134.448 109 134 108.552 134 108V101.922L136.86 109ZM134.022 93.9676L143.294 90.2215C143.806 90.0146 144.389 90.262 144.596 90.7741L150.215 104.682C150.422 105.194 150.174 105.777 149.662 105.984L140.39 109.73C139.878 109.937 139.295 109.689 139.089 109.177L133.469 95.2694C133.263 94.7573 133.51 94.1745 134.022 93.9676ZM137 96.9999C137.552 96.9999 138 96.5522 138 95.9999C138 95.4476 137.552 94.9999 137 94.9999C136.448 94.9999 136 95.4476 136 95.9999C136 96.5522 136.448 96.9999 137 96.9999Z\" fill=\"black\"/><path d=\"M187.576 102.576L183.707 98.707C183.317 98.3164 182.684 98.3164 182.293 98.707L174.865 106.135C173.114 104.667 172 102.464 172 100C172 95.5817 175.582 92 180 92C184.418 92 188 95.5817 188 100C188 100.901 187.851 101.768 187.576 102.576ZM180 110C185.523 110 190 105.523 190 100C190 94.4771 185.523 90 180 90C174.477 90 170 94.4771 170 100C170 105.523 174.477 110 180 110ZM179 98C179 99.1046 178.105 100 177 100C175.895 100 175 99.1046 175 98C175 96.8954 175.895 96 177 96C178.105 96 179 96.8954 179 98Z\" fill=\"black\"/><path d=\"M225.409 107C224.633 104.601 223.132 103.115 221.143 101.398C223.024 99.8971 225.407 99 228 99V91H229.008C229.556 91 230 91.445 230 91.9934V108.007C230 108.555 229.545 109 229.008 109H210.992C210.444 109 210 108.555 210 108.007V91.9934C210 91.4448 210.455 91 210.992 91H214V89H216V93H212V100C217.22 100 221.662 102.462 223.313 107H225.409ZM226 89V93H218V91H224V89H226ZM224.5 98C223.672 98 223 97.3284 223 96.5C223 95.6716 223.672 95 224.5 95C225.328 95 226 95.6716 226 96.5C226 97.3284 225.328 98 224.5 98Z\" fill=\"black\"/><path d=\"M251 91.9934C251 91.4448 251.445 91 251.993 91H268.007C268.555 91 269 91.445 269 91.9934V108.007C269 108.555 268.555 109 268.007 109H251.993C251.445 109 251 108.555 251 108.007V91.9934ZM258.622 96.4146C258.556 96.3708 258.479 96.3474 258.4 96.3474C258.179 96.3474 258 96.5265 258 96.7474V103.253C258 103.332 258.023 103.409 258.067 103.474C258.19 103.658 258.438 103.708 258.622 103.585L263.501 100.333C263.545 100.303 263.582 100.266 263.612 100.222C263.734 100.038 263.685 99.7897 263.501 99.6672L258.622 96.4146Z\" fill=\"black\"/><path d=\"M306.001 108H308V110H300C294.477 110 290 105.523 290 100C290 94.4771 294.477 90 300 90C305.523 90 310 94.4771 310 100C310 103.271 308.429 106.176 306.001 108ZM300 98C301.105 98 302 97.1046 302 96C302 94.8954 301.105 94 300 94C298.895 94 298 94.8954 298 96C298 97.1046 298.895 98 300 98ZM296 102C297.105 102 298 101.105 298 100C298 98.8954 297.105 98 296 98C294.895 98 294 98.8954 294 100C294 101.105 294.895 102 296 102ZM304 102C305.105 102 306 101.105 306 100C306 98.8954 305.105 98 304 98C302.895 98 302 98.8954 302 100C302 101.105 302.895 102 304 102ZM300 106C301.105 106 302 105.105 302 104C302 102.895 301.105 102 300 102C298.895 102 298 102.895 298 104C298 105.105 298.895 106 300 106Z\" fill=\"black\"/><path d=\"M345.998 95L348.308 91H349.008C349.556 91 350 91.445 350 91.9934V108.007C350 108.555 349.545 109 349.008 109H330.992C330.444 109 330 108.555 330 108.007V91.9934C330 91.4448 330.455 91 330.992 91H333.998L331.689 95H333.998L336.307 91H339.998L337.689 95H339.998L342.307 91H345.998L343.689 95H345.998Z\" fill=\"black\"/><path d=\"M381 94V92H373V90H383V94H384C384.552 94 385 94.4477 385 95V97.2L390.213 93.5507C390.44 93.3924 390.751 93.4474 390.91 93.6736C390.968 93.7576 391 93.8577 391 93.9603V106.04C391 106.316 390.776 106.54 390.5 106.54C390.397 106.54 390.297 106.508 390.213 106.449L385 102.8V107C385 107.552 384.552 108 384 108H370C369.448 108 369 107.552 369 107V95C369 94.4477 369.448 94 370 94H381ZM373 98V100H375V98H373Z\" fill=\"black\"/><path d=\"M422.803 92C422.292 92.8825 422 93.9071 422 95C422 98.3137 424.686 101 428 101C429.093 101 430.118 100.708 431 100.197V106.999C431 107.552 430.56 108 429.997 108H410.002C409.449 108 409 107.555 409 106.999V93.0009C409 92.4481 409.439 92 410.002 92H422.803ZM428 99C425.791 99 424 97.2091 424 95C424 92.7909 425.791 91 428 91C430.209 91 432 92.7909 432 95C432 97.2091 430.209 99 428 99ZM428 97C429.105 97 430 96.1046 430 95C430 93.8954 429.105 93 428 93C426.895 93 426 93.8954 426 95C426 96.1046 426.895 97 428 97ZM427 103V106H429V103H427Z\" fill=\"black\"/><path d=\"M465 98H468V94H452V98H463V96H465V98ZM454 91V89H456V91H469.008C469.556 91 470 91.445 470 91.9934V108.007C470 108.555 469.545 109 469.008 109H450.992C450.444 109 450 108.555 450 108.007V91.9934C450 91.4448 450.455 91 450.992 91H454ZM455 107C456.657 107 458 105.657 458 104C458 102.343 456.657 101 455 101C453.343 101 452 102.343 452 104C452 105.657 453.343 107 455 107Z\" fill=\"black\"/><path d=\"M492 90H508C508.552 90 509 90.4477 509 91V109C509 109.552 508.552 110 508 110H492C491.448 110 491 109.552 491 109V91C491 90.4477 491.448 90 492 90ZM500 108C502.761 108 505 105.761 505 103C505 100.239 502.761 98 500 98C497.239 98 495 100.239 495 103C495 105.761 497.239 108 500 108ZM500 96C500.828 96 501.5 95.3284 501.5 94.5C501.5 93.6716 500.828 93 500 93C499.172 93 498.5 93.6716 498.5 94.5C498.5 95.3284 499.172 96 500 96ZM500 106C498.343 106 497 104.657 497 103C497 101.343 498.343 100 500 100C501.657 100 503 101.343 503 103C503 104.657 501.657 106 500 106Z\" fill=\"black\"/><path d=\"M27.376 140.415L16.7774 147.481C16.5476 147.634 16.2372 147.572 16.084 147.342C16.0292 147.26 16 147.164 16 147.065V132.934C16 132.657 16.2239 132.434 16.5 132.434C16.5987 132.434 16.6952 132.463 16.7774 132.518L27.376 139.583C27.6057 139.736 27.6678 140.047 27.5146 140.277C27.478 140.332 27.4309 140.379 27.376 140.415Z\" fill=\"black\"/><path d=\"M69 131C69.5523 131 70 131.448 70 132V148C70 148.552 69.5523 149 69 149H51C50.4477 149 50 148.552 50 148V132C50 131.448 50.4477 131 51 131H69ZM66 140H64V143H61V145H66V140ZM59 135H54V140H56V137H59V135Z\" fill=\"black\"/><path d=\"M100 150C94.4771 150 90 145.523 90 140C90 134.477 94.4771 130 100 130C105.523 130 110 134.477 110 140C110 145.523 105.523 150 100 150ZM96 141C96 143.209 97.7909 145 100 145C102.209 145 104 143.209 104 141H96ZM96 139C96.8284 139 97.5 138.328 97.5 137.5C97.5 136.672 96.8284 136 96 136C95.1716 136 94.5 136.672 94.5 137.5C94.5 138.328 95.1716 139 96 139ZM104 139C104.828 139 105.5 138.328 105.5 137.5C105.5 136.672 104.828 136 104 136C103.172 136 102.5 136.672 102.5 137.5C102.5 138.328 103.172 139 104 139Z\" fill=\"black\"/><path d=\"M141.5 130C141.5 130.444 141.307 130.843 141 131.118V133H146C147.657 133 149 134.343 149 136V146C149 147.657 147.657 149 146 149H134C132.343 149 131 147.657 131 146V136C131 134.343 132.343 133 134 133H139V131.118C138.693 130.843 138.5 130.444 138.5 130C138.5 129.172 139.172 128.5 140 128.5C140.828 128.5 141.5 129.172 141.5 130ZM128 138H130V144H128V138ZM152 138H150V144H152V138ZM137 142.5C137.828 142.5 138.5 141.828 138.5 141C138.5 140.172 137.828 139.5 137 139.5C136.172 139.5 135.5 140.172 135.5 141C135.5 141.828 136.172 142.5 137 142.5ZM144.5 141C144.5 140.172 143.828 139.5 143 139.5C142.172 139.5 141.5 140.172 141.5 141C141.5 141.828 142.172 142.5 143 142.5C143.828 142.5 144.5 141.828 144.5 141Z\" fill=\"black\"/><path d=\"M185.5 130C187.985 130 190 132.015 190 134.5C190 135.856 189.4 137.072 188.451 137.897C188.806 138.864 189 139.91 189 141C189 145.971 184.971 150 180 150C175.029 150 171 145.971 171 141C171 139.91 171.194 138.864 171.549 137.897C170.6 137.072 170 135.856 170 134.5C170 132.015 172.015 130 174.5 130C176.126 130 177.55 130.862 178.341 132.154C178.877 132.053 179.433 132 180 132C180.567 132 181.123 132.053 181.661 132.153C182.45 130.862 183.875 130 185.5 130ZM178 141H176C176 143.209 177.791 145 180 145C182.209 145 184 143.209 184 141H182C182 142.105 181.105 143 180 143C178.895 143 178 142.105 178 141Z\" fill=\"black\"/><path d=\"M226.5 130C228.985 130 231 132.015 231 134.5C231 136.683 229.445 138.503 227.383 138.913C227.78 139.862 228 140.906 228 142C228 146.418 224.418 150 220 150C215.582 150 212 146.418 212 142C212 140.906 212.22 139.862 212.618 138.912C210.555 138.503 209 136.683 209 134.5C209 132.015 211.015 130 213.5 130C215.903 130 217.866 131.883 217.993 134.254C218.635 134.088 219.307 134 220 134C220.693 134 221.365 134.088 222.006 134.254C222.134 131.883 224.097 130 226.5 130Z\" fill=\"black\"/><path d=\"M260 130C264.971 130 269 134.029 269 139V146.5C269 148.433 267.433 150 265.5 150C264.3 150 263.241 149.396 262.611 148.476C262.098 149.386 261.12 150 260 150C258.88 150 257.902 149.386 257.387 148.475C256.759 149.396 255.7 150 254.5 150C252.631 150 251.105 148.536 251.005 146.692L251 146.5V139C251 134.029 255.029 130 260 130ZM260 140C258.895 140 258 141.119 258 142.5C258 143.881 258.895 145 260 145C261.105 145 262 143.881 262 142.5C262 141.119 261.105 140 260 140ZM257.5 136C256.672 136 256 136.672 256 137.5C256 138.328 256.672 139 257.5 139C258.328 139 259 138.328 259 137.5C259 136.672 258.328 136 257.5 136ZM262.5 136C261.672 136 261 136.672 261 137.5C261 138.328 261.672 139 262.5 139C263.328 139 264 138.328 264 137.5C264 136.672 263.328 136 262.5 136Z\" fill=\"black\"/><path d=\"M305 141C307.209 141 309 142.791 309 145C309 147.209 307.209 149 305 149C302.858 149 301 147.21 301 145H299C299 147.209 297.209 149 295 149C292.791 149 291 147.209 291 145C291 142.791 292.791 141 295 141C296.481 141 297.773 141.804 298.465 143H301.535C302.227 141.804 303.52 141 305 141ZM290 140V138H292V135C292 132.791 293.791 131 296 131H304C306.209 131 308 132.791 308 135V138H310V140H290Z\" fill=\"black\"/><path d=\"M340 130C343.122 130 345.909 131.43 347.743 133.671L341.414 140L347.743 146.329C345.909 148.57 343.122 150 340 150C334.477 150 330 145.523 330 140C330 134.477 334.477 130 340 130ZM340 133C339.172 133 338.5 133.672 338.5 134.5C338.5 135.328 339.172 136 340 136C340.828 136 341.5 135.328 341.5 134.5C341.5 133.672 340.828 133 340 133Z\" fill=\"black\"/><path d=\"M380.998 130.049C386.051 130.551 389.998 134.815 389.998 140V141H380.998V147C380.998 148.105 381.893 149 382.998 149C384.103 149 384.998 148.105 384.998 147V146H386.998V147C386.998 149.209 385.207 151 382.998 151C380.789 151 378.998 149.209 378.998 147V141H369.998V140C369.998 134.815 373.945 130.551 378.998 130.049V130C378.998 129.448 379.446 129 379.998 129C380.55 129 380.998 129.448 380.998 130V130.049Z\" fill=\"black\"/><path d=\"M410 136.5C410 133.462 412.462 131 415.5 131C417.36 131 419.005 131.923 420 133.337C420.995 131.923 422.64 131 424.5 131C427.538 131 430 133.462 430 136.5C430 144 420 149.485 420 149.485C420 149.485 410 144 410 136.5Z\" fill=\"black\"/><path d=\"M455.291 148.824L450 150L451.176 144.709C450.425 143.306 450 141.702 450 140C450 134.477 454.477 130 460 130C465.523 130 470 134.477 470 140C470 145.523 465.523 150 460 150C458.298 150 456.694 149.575 455.291 148.824ZM455 140C455 142.761 457.239 145 460 145C462.761 145 465 142.761 465 140H463C463 141.657 461.657 143 460 143C458.343 143 457 141.657 457 140H455Z\" fill=\"black\"/><path d=\"M509.902 138.598C509.444 138.533 508.976 138.5 508.5 138.5C505.24 138.5 502.346 140.06 500.521 142.471C500.35 142.489 500.176 142.498 500 142.498C498.719 142.498 497.552 142.017 496.667 141.225L495.333 142.715C496.419 143.687 497.811 144.325 499.347 144.468C498.802 145.702 498.5 147.066 498.5 148.5C498.5 148.976 498.533 149.444 498.598 149.902C493.739 149.22 490 145.047 490 140C490 134.477 494.477 130 500 130C505.047 130 509.22 133.739 509.902 138.598ZM509.871 140.617C509.425 140.54 508.967 140.5 508.5 140.5C505.766 140.5 503.351 141.871 501.907 143.967C501.019 145.256 500.5 146.816 500.5 148.5C500.5 148.967 500.54 149.425 500.617 149.871L509.871 140.617ZM496.5 139.5C497.328 139.5 498 138.828 498 138C498 137.172 497.328 136.5 496.5 136.5C495.672 136.5 495 137.172 495 138C495 138.828 495.672 139.5 496.5 139.5ZM503.5 139.5C504.328 139.5 505 138.828 505 138C505 137.172 504.328 136.5 503.5 136.5C502.672 136.5 502 137.172 502 138C502 138.828 502.672 139.5 503.5 139.5Z\" fill=\"black\"/><path d=\"M13 171C12.5313 171 12.1255 171.326 12.0238 171.783L10.0238 180.783C10.008 180.854 10 180.927 10 181V188C10 188.552 10.4477 189 11 189H29C29.5523 189 30 188.552 30 188V181C30 180.927 29.992 180.854 29.9762 180.783L27.9762 171.783C27.8745 171.326 27.4687 171 27 171H13ZM27.7534 180H23C23 181.657 21.6569 183 20 183C18.3431 183 17 181.657 17 180H12.2466L13.8022 173H26.1978L27.7534 180Z\" fill=\"black\"/><path d=\"M68.997 170.992L68.9998 189.008C68.9998 189.545 68.5552 190 68.0066 190H51.9934C51.445 190 51 189.556 51 189.008V170.992C51 170.455 51.4447 170 51.9932 170H68.0036C68.5519 170 68.9969 170.444 68.997 170.992ZM57 181V177C57 176.448 57.4477 176 58 176C58.5523 176 59 176.448 59 177V181C59 181.552 59.4477 182 60 182C60.5523 182 61 181.552 61 181V177C61 175.343 59.6569 174 58 174C56.3432 174 55 175.343 55 177V181C55 183.761 57.2386 186 60 186C62.7614 186 65 183.761 65 181V176H63V181C63 182.657 61.6569 184 60 184C58.3431 184 57 182.657 57 181Z\" fill=\"black\"/><path d=\"M100 190C94.4771 190 90 185.523 90 180C90 174.477 94.4771 170 100 170C105.523 170 110 174.477 110 180C110 185.523 105.523 190 100 190ZM108 180C108 175.582 104.418 172 100 172C95.5817 172 92 175.582 92 180C92 184.418 95.5817 188 100 188C101.47 188 102.848 187.603 104.032 186.911L103.024 185.184C102.136 185.703 101.103 186 100 186C96.6863 186 94 183.314 94 180C94 176.686 96.6863 174 100 174C103.314 174 106 176.686 106 180V181C106 181.552 105.552 182 105 182C104.448 182 104 181.552 104 181V177H102.646C101.941 176.378 101.014 176 100 176C97.7909 176 96 177.791 96 180C96 182.209 97.7909 184 100 184C101.046 184 101.999 183.598 102.712 182.94C103.262 183.589 104.083 184 105 184C106.657 184 108 182.657 108 181V180ZM100 178C101.105 178 102 178.895 102 180C102 181.105 101.105 182 100 182C98.8954 182 98 181.105 98 180C98 178.895 98.8954 178 100 178Z\" fill=\"black\"/><path d=\"M140 176.5L142.116 181.587L147.609 182.028L143.424 185.612L144.702 190.972L140 188.1L135.298 190.972L136.576 185.612L132.392 182.028L137.884 181.587L140 176.5ZM136 170V179H134V170H136ZM146 170V179H144V170H146ZM141 170V175H139V170H141Z\" fill=\"black\"/><path d=\"M178.007 170.103C176.605 169.65 175.082 170.281 174.412 171.593L173.606 173.17C173.51 173.357 173.358 173.51 173.17 173.605L171.593 174.411C170.281 175.081 169.65 176.605 170.104 178.007L170.649 179.692C170.714 179.892 170.714 180.107 170.649 180.308L170.104 181.993C169.65 183.394 170.281 184.918 171.593 185.588L173.17 186.394C173.358 186.49 173.51 186.642 173.606 186.829L174.412 188.407C175.082 189.718 176.605 190.35 178.007 189.896L179.692 189.35C179.892 189.286 180.108 189.286 180.308 189.35L181.993 189.896C183.395 190.35 184.918 189.718 185.588 188.407L186.394 186.829C186.49 186.642 186.642 186.49 186.83 186.394L188.407 185.588C189.719 184.918 190.35 183.394 189.896 181.993L189.351 180.308C189.286 180.107 189.286 179.892 189.351 179.692L189.896 178.007C190.35 176.605 189.719 175.081 188.407 174.411L186.83 173.605C186.642 173.51 186.49 173.357 186.394 173.17L185.588 171.593C184.918 170.281 183.395 169.65 181.993 170.103L180.308 170.649C180.108 170.714 179.892 170.714 179.692 170.649L178.007 170.103ZM174.76 179.757L176.174 178.343L179.002 181.171L184.659 175.514L186.073 176.928L179.002 183.999L174.76 179.757Z\" fill=\"black\"/><path d=\"M224 184C225.657 184 227 185.343 227 187C227 188.657 225.657 190 224 190C222.343 190 221 188.657 221 187C221 185.343 222.343 184 224 184ZM214 180C216.209 180 218 181.791 218 184C218 186.209 216.209 188 214 188C211.791 188 210 186.209 210 184C210 181.791 211.791 180 214 180ZM222.5 170C225.538 170 228 172.462 228 175.5C228 178.538 225.538 181 222.5 181C219.462 181 217 178.538 217 175.5C217 172.462 219.462 170 222.5 170Z\" fill=\"black\"/><path d=\"M250 181H256V189H250V181ZM257 171H263V189H257V171ZM264 176H270V189H264V176Z\" fill=\"black\"/><path d=\"M293 171V187H309V189H291V171H293ZM307.939 173.939L310.061 176.061L304 182.121L301 179.121L297.061 183.061L294.939 180.939L301 174.879L304 177.879L307.939 173.939Z\" fill=\"black\"/><path d=\"M330.049 180.998H335.527C335.706 184.267 336.757 187.303 338.452 189.879C333.988 189.185 330.5 185.538 330.049 180.998ZM330.049 178.998C330.5 174.458 333.988 170.811 338.452 170.117C336.757 172.693 335.706 175.729 335.527 178.998H330.049ZM349.951 178.998H344.473C344.294 175.729 343.242 172.693 341.548 170.117C346.012 170.811 349.5 174.458 349.951 178.998ZM349.951 180.998C349.5 185.538 346.012 189.185 341.548 189.879C343.242 187.303 344.294 184.267 344.473 180.998H349.951ZM337.531 180.998H342.469C342.298 183.781 341.415 186.371 340 188.59C338.585 186.371 337.702 183.781 337.531 180.998ZM337.531 178.998C337.702 176.215 338.585 173.625 340 171.407C341.415 173.625 342.298 176.215 342.469 178.998H337.531Z\" fill=\"black\"/><path d=\"M371 171H380.382C380.761 171 381.107 171.214 381.276 171.553L382 173H388C388.552 173 389 173.448 389 174V185C389 185.552 388.552 186 388 186H381.618C381.239 186 380.893 185.786 380.724 185.447L380 184H373V190H371V171Z\" fill=\"black\"/><path d=\"M416 172C416 173.105 415.105 174 414 174C412.895 174 412 173.105 412 172C412 170.895 412.895 170 414 170C415.105 170 416 170.895 416 172ZM413 184V190H411V178C411 176.343 412.343 175 414 175C414.821 175 415.564 175.329 416.106 175.863L418.48 178.106L420.793 175.793L422.207 177.207L418.52 180.894L417 179.459V190H415V184H413ZM418 173H427V182H418V184H422.365L425.189 190H427.399L424.576 184H428C428.552 184 429 183.552 429 183V172C429 171.448 428.552 171 428 171H418V173Z\" fill=\"black\"/><path d=\"M462.121 178.481C461.731 178.09 461.098 178.09 460.707 178.481L460 179.188C459.219 179.969 457.953 179.969 457.172 179.188C456.39 178.407 456.39 177.14 457.172 176.359L462.802 170.727C464.906 170.251 467.201 170.832 468.839 172.47C471.258 174.89 471.372 178.742 469.179 181.295L467.071 183.43L462.121 178.481ZM451.161 172.47C453.335 170.297 456.664 169.984 459.17 171.533L455.757 174.945C454.195 176.507 454.195 179.04 455.757 180.602C457.272 182.117 459.699 182.163 461.269 180.74L461.414 180.602L465.657 184.845L461.414 189.087C460.633 189.868 459.367 189.868 458.586 189.087L451.161 181.663C448.623 179.124 448.623 175.009 451.161 172.47Z\" fill=\"black\"/><path d=\"M495.552 181L496.399 178.885L497.244 181H495.552ZM504 180H505V182H504C503.448 182 503 181.552 503 181C503 180.448 503.448 180 504 180ZM509 171H491C490.448 171 490 171.448 490 172V188C490 188.552 490.448 189 491 189H509C509.552 189 510 188.552 510 188V172C510 171.448 509.552 171 509 171ZM500.598 184H498.443L498.043 183H494.753L494.353 184H492.199L493.398 181.002L493.399 181L495.399 176H497.399L500.598 184ZM505 176H507V184H504C502.343 184 501 182.657 501 181C501 179.343 502.343 178 504 178H505V176Z\" fill=\"black\"/></svg>');
    }
}

@keyframes marketplacefadeIn {
    from {
        opacity: 0;
        transform: scale(1.04) rotate(-9deg);
    }
    to {
        opacity: var(--custom-bg-overlay-opacity);
        transform: scale(1) rotate(-10deg);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Assets/css/app/less/marketplace.less";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Assets/css/app/less/marketplace.less", "/home/mauticapp/client/app/bundles/CoreBundle/Assets/css/app/less/marketplace.less");
    }
}
