<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Twig/Helper/EntityHelper.php */
class __TwigTemplate_85d1c2db69dbdd19f9b091b34dff7f51 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CoreBundle\\Twig\\Helper;

use Doctrine\\ORM\\EntityManagerInterface;
use Twig\\Extension\\AbstractExtension;
use Twig\\TwigFunction;

class EntityHelper extends AbstractExtension
{
    public function __construct(private readonly EntityManagerInterface \$entityManager)
    {
    }

    /**
     * Registers the custom Twig functions.
     */
    public function getFunctions(): array
    {
        return [
            new TwigFunction('getEntity', [\$this, 'getEntity']),
            new TwigFunction('getEntities', [\$this, 'getEntities']),
        ];
    }

    /**
     * Retrieves an entity based on the provided class name and ID.
     *
     * @param class-string    \$entityName The fully qualified class name of the entity
     * @param int|string|null \$id         The ID of the entity to retrieve
     *
     * @return object|null The retrieved entity or null if not found
     */
    public function getEntity(string \$entityName, int|string|null \$id): ?object
    {
        return null !== \$id ? \$this->entityManager->getRepository(\$entityName)->find(\$id) : null;
    }

    /**
     * Retrieves multiple entities based on the provided class name and an array of IDs.
     *
     * @param class-string   \$entityName The fully qualified class name of the entity
     * @param int[]|string[] \$ids        An array of IDs to retrieve
     *
     * @return object[] The array of retrieved entities
     */
    public function getEntities(string \$entityName, array \$ids): array
    {
        return \$this->entityManager->getRepository(\$entityName)->findBy(['id' => \$ids]);
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Twig/Helper/EntityHelper.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Twig/Helper/EntityHelper.php", "/home/mauticapp/client/app/bundles/CoreBundle/Twig/Helper/EntityHelper.php");
    }
}
