<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Service/GlobalSearch.php */
class __TwigTemplate_38022fc2a6bae780eacac7b2386e5f9d extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CoreBundle\\Service;

use Doctrine\\ORM\\Tools\\Pagination\\Paginator;
use Mautic\\CoreBundle\\DTO\\GlobalSearchFilterDTO;
use Mautic\\CoreBundle\\Event\\GlobalSearchEvent;
use Mautic\\CoreBundle\\Model\\GlobalSearchInterface;
use Twig\\Environment;

class GlobalSearch
{
    public function __construct(
        private Environment \$twig,
    ) {
    }

    /**
     * @return array<int, string>
     */
    public function performSearch(
        GlobalSearchFilterDTO \$filterDTO,
        GlobalSearchInterface \$model,
        string \$template,
    ): array {
        if (empty(\$filterDTO->getSearchString()) || (!\$model->canViewOwnEntity() && !\$model->canViewOthersEntity())) {
            return [];
        }

        \$entities = \$model->getEntitiesForGlobalSearch(\$filterDTO);

        if (is_null(\$entities) || (\$entities instanceof Paginator && empty(\$entities->count()))) {
            return [];
        }

        return \$this->processResults(\$entities, \$filterDTO->getSearchString(), \$template);
    }

    /**
     * @return array<int|string, int|string>
     */
    private function processResults(Paginator \$entities, string \$searchString, string \$template): array
    {
        \$count           = \$entities->count();
        \$renderedResults = [];
        foreach (\$entities as \$entity) {
            \$renderedResults[] = \$this->twig->render(\$template, ['item' => \$entity]);
        }

        if (\$count > GlobalSearchEvent::RESULTS_LIMIT) {
            \$renderedResults[] = \$this->twig->render(\$template, [
                'searchString' => \$searchString,
                'showMore'     => true,
                'remaining'    => \$count - GlobalSearchEvent::RESULTS_LIMIT,
            ]);
        }

        \$renderedResults['count'] = \$count;

        return \$renderedResults;
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Service/GlobalSearch.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Service/GlobalSearch.php", "/home/mauticapp/client/app/bundles/CoreBundle/Service/GlobalSearch.php");
    }
}
