(function(window,document,undefined){if(!window){return}
var _MAP={8:'backspace',9:'tab',13:'enter',16:'shift',17:'ctrl',18:'alt',20:'capslock',27:'esc',32:'space',33:'pageup',34:'pagedown',35:'end',36:'home',37:'left',38:'up',39:'right',40:'down',45:'ins',46:'del',91:'meta',93:'meta',224:'meta'};var _KEYCODE_MAP={106:'*',107:'+',109:'-',110:'.',111:'/',186:';',187:'=',188:',',189:'-',190:'.',191:'/',192:'`',219:'[',220:'\\',221:']',222:'\''};var _SHIFT_MAP={'~':'`','!':'1','@':'2','#':'3','$':'4','%':'5','^':'6','&':'7','*':'8','(':'9',')':'0','_':'-','+':'=',':':';','\"':'\'','<':',','>':'.','?':'/','|':'\\'};var _SPECIAL_ALIASES={'option':'alt','command':'meta','return':'enter','escape':'esc','plus':'+','mod':/Mac|iPod|iPhone|iPad/.test(navigator.platform)?'meta':'ctrl'};var _REVERSE_MAP;for(var i=1;i<20;++i){_MAP[111+i]='f'+i}
for(i=0;i<=9;++i){_MAP[i+96]=i.toString()}
function _addEvent(object,type,callback){if(object.addEventListener){object.addEventListener(type,callback,!1);return}
object.attachEvent('on'+type,callback)}
function _characterFromEvent(e){if(e.type=='keypress'){var character=String.fromCharCode(e.which);if(!e.shiftKey){character=character.toLowerCase()}
return character}
if(_MAP[e.which]){return _MAP[e.which]}
if(_KEYCODE_MAP[e.which]){return _KEYCODE_MAP[e.which]}
return String.fromCharCode(e.which).toLowerCase()}
function _modifiersMatch(modifiers1,modifiers2){return modifiers1.sort().join(',')===modifiers2.sort().join(',')}
function _eventModifiers(e){var modifiers=[];if(e.shiftKey){modifiers.push('shift')}
if(e.altKey){modifiers.push('alt')}
if(e.ctrlKey){modifiers.push('ctrl')}
if(e.metaKey){modifiers.push('meta')}
return modifiers}
function _preventDefault(e){if(e.preventDefault){e.preventDefault();return}
e.returnValue=!1}
function _stopPropagation(e){if(e.stopPropagation){e.stopPropagation();return}
e.cancelBubble=!0}
function _isModifier(key){return key=='shift'||key=='ctrl'||key=='alt'||key=='meta'}
function _getReverseMap(){if(!_REVERSE_MAP){_REVERSE_MAP={};for(var key in _MAP){if(key>95&&key<112){continue}
if(_MAP.hasOwnProperty(key)){_REVERSE_MAP[_MAP[key]]=key}}}
return _REVERSE_MAP}
function _pickBestAction(key,modifiers,action){if(!action){action=_getReverseMap()[key]?'keydown':'keypress'}
if(action=='keypress'&&modifiers.length){action='keydown'}
return action}
function _keysFromString(combination){if(combination==='+'){return['+']}
combination=combination.replace(/\+{2}/g,'+plus');return combination.split('+')}
function _getKeyInfo(combination,action){var keys;var key;var i;var modifiers=[];keys=_keysFromString(combination);for(i=0;i<keys.length;++i){key=keys[i];if(_SPECIAL_ALIASES[key]){key=_SPECIAL_ALIASES[key]}
if(action&&action!='keypress'&&_SHIFT_MAP[key]){key=_SHIFT_MAP[key];modifiers.push('shift')}
if(_isModifier(key)){modifiers.push(key)}}
action=_pickBestAction(key,modifiers,action);return{key:key,modifiers:modifiers,action:action}}
function _belongsTo(element,ancestor){if(element===null||element===document){return!1}
if(element===ancestor){return!0}
return _belongsTo(element.parentNode,ancestor)}
function Mousetrap(targetElement){var self=this;targetElement=targetElement||document;if(!(self instanceof Mousetrap)){return new Mousetrap(targetElement)}
self.target=targetElement;self._callbacks={};self._directMap={};var _sequenceLevels={};var _resetTimer;var _ignoreNextKeyup=!1;var _ignoreNextKeypress=!1;var _nextExpectedAction=!1;function _resetSequences(doNotReset){doNotReset=doNotReset||{};var activeSequences=!1,key;for(key in _sequenceLevels){if(doNotReset[key]){activeSequences=!0;continue}
_sequenceLevels[key]=0}
if(!activeSequences){_nextExpectedAction=!1}}
function _getMatches(character,modifiers,e,sequenceName,combination,level){var i;var callback;var matches=[];var action=e.type;if(!self._callbacks[character]){return[]}
if(action=='keyup'&&_isModifier(character)){modifiers=[character]}
for(i=0;i<self._callbacks[character].length;++i){callback=self._callbacks[character][i];if(!sequenceName&&callback.seq&&_sequenceLevels[callback.seq]!=callback.level){continue}
if(action!=callback.action){continue}
if((action=='keypress'&&!e.metaKey&&!e.ctrlKey)||_modifiersMatch(modifiers,callback.modifiers)){var deleteCombo=!sequenceName&&callback.combo==combination;var deleteSequence=sequenceName&&callback.seq==sequenceName&&callback.level==level;if(deleteCombo||deleteSequence){self._callbacks[character].splice(i,1)}
matches.push(callback)}}
return matches}
function _fireCallback(callback,e,combo,sequence){if(self.stopCallback(e,e.target||e.srcElement,combo,sequence)){return}
if(callback(e,combo)===!1){_preventDefault(e);_stopPropagation(e)}}
self._handleKey=function(character,modifiers,e){var callbacks=_getMatches(character,modifiers,e);var i;var doNotReset={};var maxLevel=0;var processedSequenceCallback=!1;for(i=0;i<callbacks.length;++i){if(callbacks[i].seq){maxLevel=Math.max(maxLevel,callbacks[i].level)}}
for(i=0;i<callbacks.length;++i){if(callbacks[i].seq){if(callbacks[i].level!=maxLevel){continue}
processedSequenceCallback=!0;doNotReset[callbacks[i].seq]=1;_fireCallback(callbacks[i].callback,e,callbacks[i].combo,callbacks[i].seq);continue}
if(!processedSequenceCallback){_fireCallback(callbacks[i].callback,e,callbacks[i].combo)}}
var ignoreThisKeypress=e.type=='keypress'&&_ignoreNextKeypress;if(e.type==_nextExpectedAction&&!_isModifier(character)&&!ignoreThisKeypress){_resetSequences(doNotReset)}
_ignoreNextKeypress=processedSequenceCallback&&e.type=='keydown'};function _handleKeyEvent(e){if(typeof e.which!=='number'){e.which=e.keyCode}
var character=_characterFromEvent(e);if(!character){return}
if(e.type=='keyup'&&_ignoreNextKeyup===character){_ignoreNextKeyup=!1;return}
self.handleKey(character,_eventModifiers(e),e)}
function _resetSequenceTimer(){clearTimeout(_resetTimer);_resetTimer=setTimeout(_resetSequences,1000)}
function _bindSequence(combo,keys,callback,action){_sequenceLevels[combo]=0;function _increaseSequence(nextAction){return function(){_nextExpectedAction=nextAction;++_sequenceLevels[combo];_resetSequenceTimer()}}
function _callbackAndReset(e){_fireCallback(callback,e,combo);if(action!=='keyup'){_ignoreNextKeyup=_characterFromEvent(e)}
setTimeout(_resetSequences,10)}
for(var i=0;i<keys.length;++i){var isFinal=i+1===keys.length;var wrappedCallback=isFinal?_callbackAndReset:_increaseSequence(action||_getKeyInfo(keys[i+1]).action);_bindSingle(keys[i],wrappedCallback,action,combo,i)}}
function _bindSingle(combination,callback,action,sequenceName,level){self._directMap[combination+':'+action]=callback;combination=combination.replace(/\s+/g,' ');var sequence=combination.split(' ');var info;if(sequence.length>1){_bindSequence(combination,sequence,callback,action);return}
info=_getKeyInfo(combination,action);self._callbacks[info.key]=self._callbacks[info.key]||[];_getMatches(info.key,info.modifiers,{type:info.action},sequenceName,combination,level);self._callbacks[info.key][sequenceName?'unshift':'push']({callback:callback,modifiers:info.modifiers,action:info.action,seq:sequenceName,level:level,combo:combination})}
self._bindMultiple=function(combinations,callback,action){for(var i=0;i<combinations.length;++i){_bindSingle(combinations[i],callback,action)}};_addEvent(targetElement,'keypress',_handleKeyEvent);_addEvent(targetElement,'keydown',_handleKeyEvent);_addEvent(targetElement,'keyup',_handleKeyEvent)}
Mousetrap.prototype.bind=function(keys,callback,action){var self=this;keys=keys instanceof Array?keys:[keys];self._bindMultiple.call(self,keys,callback,action);return self};Mousetrap.prototype.unbind=function(keys,action){var self=this;return self.bind.call(self,keys,function(){},action)};Mousetrap.prototype.trigger=function(keys,action){var self=this;if(self._directMap[keys+':'+action]){self._directMap[keys+':'+action]({},keys)}
return self};Mousetrap.prototype.reset=function(){var self=this;self._callbacks={};self._directMap={};return self};Mousetrap.prototype.stopCallback=function(e,element){var self=this;if((' '+element.className+' ').indexOf(' mousetrap ')>-1){return!1}
if(_belongsTo(element,self.target)){return!1}
if('composedPath' in e&&typeof e.composedPath==='function'){var initialEventTarget=e.composedPath()[0];if(initialEventTarget!==e.target){element=initialEventTarget}}
return element.tagName=='INPUT'||element.tagName=='SELECT'||element.tagName=='TEXTAREA'||element.isContentEditable};Mousetrap.prototype.handleKey=function(){var self=this;return self._handleKey.apply(self,arguments)};Mousetrap.addKeycodes=function(object){for(var key in object){if(object.hasOwnProperty(key)){_MAP[key]=object[key]}}
_REVERSE_MAP=null};Mousetrap.init=function(){var documentMousetrap=Mousetrap(document);for(var method in documentMousetrap){if(method.charAt(0)!=='_'){Mousetrap[method]=(function(method){return function(){return documentMousetrap[method].apply(documentMousetrap,arguments)}}(method))}}};Mousetrap.init();window.Mousetrap=Mousetrap;if(typeof module!=='undefined'&&module.exports){module.exports=Mousetrap}
if(typeof define==='function'&&define.amd){define(function(){return Mousetrap})}})(typeof window!=='undefined'?window:null,typeof window!=='undefined'?document:null);/*!
 * jQuery JavaScript Library v3.7.1
 * https://jquery.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2023-08-28T13:37Z
 */
(function(global,factory){"use strict";if(typeof module==="object"&&typeof module.exports==="object"){module.exports=global.document?factory(global,!0):function(w){if(!w.document){throw new Error("jQuery requires a window with a document")}
return factory(w)}}else{factory(global)}})(typeof window!=="undefined"?window:this,function(window,noGlobal){"use strict";var arr=[];var getProto=Object.getPrototypeOf;var slice=arr.slice;var flat=arr.flat?function(array){return arr.flat.call(array)}:function(array){return arr.concat.apply([],array)};var push=arr.push;var indexOf=arr.indexOf;var class2type={};var toString=class2type.toString;var hasOwn=class2type.hasOwnProperty;var fnToString=hasOwn.toString;var ObjectFunctionString=fnToString.call(Object);var support={};var isFunction=function isFunction(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"&&typeof obj.item!=="function"};var isWindow=function isWindow(obj){return obj!=null&&obj===obj.window};var document=window.document;var preservedScriptAttributes={type:!0,src:!0,nonce:!0,noModule:!0};function DOMEval(code,node,doc){doc=doc||document;var i,val,script=doc.createElement("script");script.text=code;if(node){for(i in preservedScriptAttributes){val=node[i]||node.getAttribute&&node.getAttribute(i);if(val){script.setAttribute(i,val)}}}
doc.head.appendChild(script).parentNode.removeChild(script)}
function toType(obj){if(obj==null){return obj+""}
return typeof obj==="object"||typeof obj==="function"?class2type[toString.call(obj)]||"object":typeof obj}
var version="3.7.1",rhtmlSuffix=/HTML$/i,jQuery=function(selector,context){return new jQuery.fn.init(selector,context)};jQuery.fn=jQuery.prototype={jquery:version,constructor:jQuery,length:0,toArray:function(){return slice.call(this)},get:function(num){if(num==null){return slice.call(this)}
return num<0?this[num+this.length]:this[num]},pushStack:function(elems){var ret=jQuery.merge(this.constructor(),elems);ret.prevObject=this;return ret},each:function(callback){return jQuery.each(this,callback)},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem)}))},slice:function(){return this.pushStack(slice.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(jQuery.grep(this,function(_elem,i){return(i+1)%2}))},odd:function(){return this.pushStack(jQuery.grep(this,function(_elem,i){return i%2}))},eq:function(i){var len=this.length,j=+i+(i<0?len:0);return this.pushStack(j>=0&&j<len?[this[j]]:[])},end:function(){return this.prevObject||this.constructor()},push:push,sort:arr.sort,splice:arr.splice};jQuery.extend=jQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=!1;if(typeof target==="boolean"){deep=target;target=arguments[i]||{};i++}
if(typeof target!=="object"&&!isFunction(target)){target={}}
if(i===length){target=this;i--}
for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){copy=options[name];if(name==="__proto__"||target===copy){continue}
if(deep&&copy&&(jQuery.isPlainObject(copy)||(copyIsArray=Array.isArray(copy)))){src=target[name];if(copyIsArray&&!Array.isArray(src)){clone=[]}else if(!copyIsArray&&!jQuery.isPlainObject(src)){clone={}}else{clone=src}
copyIsArray=!1;target[name]=jQuery.extend(deep,clone,copy)}else if(copy!==undefined){target[name]=copy}}}}
return target};jQuery.extend({expando:"jQuery"+(version+Math.random()).replace(/\D/g,""),isReady:!0,error:function(msg){throw new Error(msg)},noop:function(){},isPlainObject:function(obj){var proto,Ctor;if(!obj||toString.call(obj)!=="[object Object]"){return!1}
proto=getProto(obj);if(!proto){return!0}
Ctor=hasOwn.call(proto,"constructor")&&proto.constructor;return typeof Ctor==="function"&&fnToString.call(Ctor)===ObjectFunctionString},isEmptyObject:function(obj){var name;for(name in obj){return!1}
return!0},globalEval:function(code,options,doc){DOMEval(code,{nonce:options&&options.nonce},doc)},each:function(obj,callback){var length,i=0;if(isArrayLike(obj)){length=obj.length;for(;i<length;i++){if(callback.call(obj[i],i,obj[i])===!1){break}}}else{for(i in obj){if(callback.call(obj[i],i,obj[i])===!1){break}}}
return obj},text:function(elem){var node,ret="",i=0,nodeType=elem.nodeType;if(!nodeType){while((node=elem[i++])){ret+=jQuery.text(node)}}
if(nodeType===1||nodeType===11){return elem.textContent}
if(nodeType===9){return elem.documentElement.textContent}
if(nodeType===3||nodeType===4){return elem.nodeValue}
return ret},makeArray:function(arr,results){var ret=results||[];if(arr!=null){if(isArrayLike(Object(arr))){jQuery.merge(ret,typeof arr==="string"?[arr]:arr)}else{push.call(ret,arr)}}
return ret},inArray:function(elem,arr,i){return arr==null?-1:indexOf.call(arr,elem,i)},isXMLDoc:function(elem){var namespace=elem&&elem.namespaceURI,docElem=elem&&(elem.ownerDocument||elem).documentElement;return!rhtmlSuffix.test(namespace||docElem&&docElem.nodeName||"HTML")},merge:function(first,second){var len=+second.length,j=0,i=first.length;for(;j<len;j++){first[i++]=second[j]}
first.length=i;return first},grep:function(elems,callback,invert){var callbackInverse,matches=[],i=0,length=elems.length,callbackExpect=!invert;for(;i<length;i++){callbackInverse=!callback(elems[i],i);if(callbackInverse!==callbackExpect){matches.push(elems[i])}}
return matches},map:function(elems,callback,arg){var length,value,i=0,ret=[];if(isArrayLike(elems)){length=elems.length;for(;i<length;i++){value=callback(elems[i],i,arg);if(value!=null){ret.push(value)}}}else{for(i in elems){value=callback(elems[i],i,arg);if(value!=null){ret.push(value)}}}
return flat(ret)},guid:1,support:support});if(typeof Symbol==="function"){jQuery.fn[Symbol.iterator]=arr[Symbol.iterator]}
jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(_i,name){class2type["[object "+name+"]"]=name.toLowerCase()});function isArrayLike(obj){var length=!!obj&&"length" in obj&&obj.length,type=toType(obj);if(isFunction(obj)||isWindow(obj)){return!1}
return type==="array"||length===0||typeof length==="number"&&length>0&&(length-1)in obj}
function nodeName(elem,name){return elem.nodeName&&elem.nodeName.toLowerCase()===name.toLowerCase()}
var pop=arr.pop;var sort=arr.sort;var splice=arr.splice;var whitespace="[\\x20\\t\\r\\n\\f]";var rtrimCSS=new RegExp("^"+whitespace+"+|((?:^|[^\\\\])(?:\\\\.)*)"+whitespace+"+$","g");jQuery.contains=function(a,b){var bup=b&&b.parentNode;return a===bup||!!(bup&&bup.nodeType===1&&(a.contains?a.contains(bup):a.compareDocumentPosition&&a.compareDocumentPosition(bup)&16))};var rcssescape=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;function fcssescape(ch,asCodePoint){if(asCodePoint){if(ch==="\0"){return"\uFFFD"}
return ch.slice(0,-1)+"\\"+ch.charCodeAt(ch.length-1).toString(16)+" "}
return"\\"+ch}
jQuery.escapeSelector=function(sel){return(sel+"").replace(rcssescape,fcssescape)};var preferredDoc=document,pushNative=push;(function(){var i,Expr,outermostContext,sortInput,hasDuplicate,push=pushNative,document,documentElement,documentIsHTML,rbuggyQSA,matches,expando=jQuery.expando,dirruns=0,done=0,classCache=createCache(),tokenCache=createCache(),compilerCache=createCache(),nonnativeSelectorCache=createCache(),sortOrder=function(a,b){if(a===b){hasDuplicate=!0}
return 0},booleans="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|"+"loop|multiple|open|readonly|required|scoped",identifier="(?:\\\\[\\da-fA-F]{1,6}"+whitespace+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",attributes="\\["+whitespace+"*("+identifier+")(?:"+whitespace+"*([*^$|!~]?=)"+whitespace+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+identifier+"))|)"+whitespace+"*\\]",pseudos=":("+identifier+")(?:\\(("+"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|"+"((?:\\\\.|[^\\\\()[\\]]|"+attributes+")*)|"+".*"+")\\)|)",rwhitespace=new RegExp(whitespace+"+","g"),rcomma=new RegExp("^"+whitespace+"*,"+whitespace+"*"),rleadingCombinator=new RegExp("^"+whitespace+"*([>+~]|"+whitespace+")"+whitespace+"*"),rdescend=new RegExp(whitespace+"|>"),rpseudo=new RegExp(pseudos),ridentifier=new RegExp("^"+identifier+"$"),matchExpr={ID:new RegExp("^#("+identifier+")"),CLASS:new RegExp("^\\.("+identifier+")"),TAG:new RegExp("^("+identifier+"|[*])"),ATTR:new RegExp("^"+attributes),PSEUDO:new RegExp("^"+pseudos),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+whitespace+"*(even|odd|(([+-]|)(\\d*)n|)"+whitespace+"*(?:([+-]|)"+whitespace+"*(\\d+)|))"+whitespace+"*\\)|)","i"),bool:new RegExp("^(?:"+booleans+")$","i"),needsContext:new RegExp("^"+whitespace+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+whitespace+"*((?:-\\d)?\\d*)"+whitespace+"*\\)|)(?=[^-]|$)","i")},rinputs=/^(?:input|select|textarea|button)$/i,rheader=/^h\d$/i,rquickExpr=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,rsibling=/[+~]/,runescape=new RegExp("\\\\[\\da-fA-F]{1,6}"+whitespace+"?|\\\\([^\\r\\n\\f])","g"),funescape=function(escape,nonHex){var high="0x"+escape.slice(1)-0x10000;if(nonHex){return nonHex}
return high<0?String.fromCharCode(high+0x10000):String.fromCharCode(high>>10|0xD800,high&0x3FF|0xDC00)},unloadHandler=function(){setDocument()},inDisabledFieldset=addCombinator(function(elem){return elem.disabled===!0&&nodeName(elem,"fieldset")},{dir:"parentNode",next:"legend"});function safeActiveElement(){try{return document.activeElement}catch(err){}}
try{push.apply((arr=slice.call(preferredDoc.childNodes)),preferredDoc.childNodes);arr[preferredDoc.childNodes.length].nodeType}catch(e){push={apply:function(target,els){pushNative.apply(target,slice.call(els))},call:function(target){pushNative.apply(target,slice.call(arguments,1))}}}
function find(selector,context,results,seed){var m,i,elem,nid,match,groups,newSelector,newContext=context&&context.ownerDocument,nodeType=context?context.nodeType:9;results=results||[];if(typeof selector!=="string"||!selector||nodeType!==1&&nodeType!==9&&nodeType!==11){return results}
if(!seed){setDocument(context);context=context||document;if(documentIsHTML){if(nodeType!==11&&(match=rquickExpr.exec(selector))){if((m=match[1])){if(nodeType===9){if((elem=context.getElementById(m))){if(elem.id===m){push.call(results,elem);return results}}else{return results}}else{if(newContext&&(elem=newContext.getElementById(m))&&find.contains(context,elem)&&elem.id===m){push.call(results,elem);return results}}}else if(match[2]){push.apply(results,context.getElementsByTagName(selector));return results}else if((m=match[3])&&context.getElementsByClassName){push.apply(results,context.getElementsByClassName(m));return results}}
if(!nonnativeSelectorCache[selector+" "]&&(!rbuggyQSA||!rbuggyQSA.test(selector))){newSelector=selector;newContext=context;if(nodeType===1&&(rdescend.test(selector)||rleadingCombinator.test(selector))){newContext=rsibling.test(selector)&&testContext(context.parentNode)||context;if(newContext!=context||!support.scope){if((nid=context.getAttribute("id"))){nid=jQuery.escapeSelector(nid)}else{context.setAttribute("id",(nid=expando))}}
groups=tokenize(selector);i=groups.length;while(i--){groups[i]=(nid?"#"+nid:":scope")+" "+toSelector(groups[i])}
newSelector=groups.join(",")}
try{push.apply(results,newContext.querySelectorAll(newSelector));return results}catch(qsaError){nonnativeSelectorCache(selector,!0)}finally{if(nid===expando){context.removeAttribute("id")}}}}}
return select(selector.replace(rtrimCSS,"$1"),context,results,seed)}
function createCache(){var keys=[];function cache(key,value){if(keys.push(key+" ")>Expr.cacheLength){delete cache[keys.shift()]}
return(cache[key+" "]=value)}
return cache}
function markFunction(fn){fn[expando]=!0;return fn}
function assert(fn){var el=document.createElement("fieldset");try{return!!fn(el)}catch(e){return!1}finally{if(el.parentNode){el.parentNode.removeChild(el)}
el=null}}
function createInputPseudo(type){return function(elem){return nodeName(elem,"input")&&elem.type===type}}
function createButtonPseudo(type){return function(elem){return(nodeName(elem,"input")||nodeName(elem,"button"))&&elem.type===type}}
function createDisabledPseudo(disabled){return function(elem){if("form" in elem){if(elem.parentNode&&elem.disabled===!1){if("label" in elem){if("label" in elem.parentNode){return elem.parentNode.disabled===disabled}else{return elem.disabled===disabled}}
return elem.isDisabled===disabled||elem.isDisabled!==!disabled&&inDisabledFieldset(elem)===disabled}
return elem.disabled===disabled}else if("label" in elem){return elem.disabled===disabled}
return!1}}
function createPositionalPseudo(fn){return markFunction(function(argument){argument=+argument;return markFunction(function(seed,matches){var j,matchIndexes=fn([],seed.length,argument),i=matchIndexes.length;while(i--){if(seed[(j=matchIndexes[i])]){seed[j]=!(matches[j]=seed[j])}}})})}
function testContext(context){return context&&typeof context.getElementsByTagName!=="undefined"&&context}
function setDocument(node){var subWindow,doc=node?node.ownerDocument||node:preferredDoc;if(doc==document||doc.nodeType!==9||!doc.documentElement){return document}
document=doc;documentElement=document.documentElement;documentIsHTML=!jQuery.isXMLDoc(document);matches=documentElement.matches||documentElement.webkitMatchesSelector||documentElement.msMatchesSelector;if(documentElement.msMatchesSelector&&preferredDoc!=document&&(subWindow=document.defaultView)&&subWindow.top!==subWindow){subWindow.addEventListener("unload",unloadHandler)}
support.getById=assert(function(el){documentElement.appendChild(el).id=jQuery.expando;return!document.getElementsByName||!document.getElementsByName(jQuery.expando).length});support.disconnectedMatch=assert(function(el){return matches.call(el,"*")});support.scope=assert(function(){return document.querySelectorAll(":scope")});support.cssHas=assert(function(){try{document.querySelector(":has(*,:jqfake)");return!1}catch(e){return!0}});if(support.getById){Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){return elem.getAttribute("id")===attrId}};Expr.find.ID=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var elem=context.getElementById(id);return elem?[elem]:[]}}}else{Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return node&&node.value===attrId}};Expr.find.ID=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var node,i,elems,elem=context.getElementById(id);if(elem){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem]}
elems=context.getElementsByName(id);i=0;while((elem=elems[i++])){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem]}}}
return[]}}}
Expr.find.TAG=function(tag,context){if(typeof context.getElementsByTagName!=="undefined"){return context.getElementsByTagName(tag)}else{return context.querySelectorAll(tag)}};Expr.find.CLASS=function(className,context){if(typeof context.getElementsByClassName!=="undefined"&&documentIsHTML){return context.getElementsByClassName(className)}};rbuggyQSA=[];assert(function(el){var input;documentElement.appendChild(el).innerHTML="<a id='"+expando+"' href='' disabled='disabled'></a>"+"<select id='"+expando+"-\r\\' disabled='disabled'>"+"<option selected=''></option></select>";if(!el.querySelectorAll("[selected]").length){rbuggyQSA.push("\\["+whitespace+"*(?:value|"+booleans+")")}
if(!el.querySelectorAll("[id~="+expando+"-]").length){rbuggyQSA.push("~=")}
if(!el.querySelectorAll("a#"+expando+"+*").length){rbuggyQSA.push(".#.+[+~]")}
if(!el.querySelectorAll(":checked").length){rbuggyQSA.push(":checked")}
input=document.createElement("input");input.setAttribute("type","hidden");el.appendChild(input).setAttribute("name","D");documentElement.appendChild(el).disabled=!0;if(el.querySelectorAll(":disabled").length!==2){rbuggyQSA.push(":enabled",":disabled")}
input=document.createElement("input");input.setAttribute("name","");el.appendChild(input);if(!el.querySelectorAll("[name='']").length){rbuggyQSA.push("\\["+whitespace+"*name"+whitespace+"*="+whitespace+"*(?:''|\"\")")}});if(!support.cssHas){rbuggyQSA.push(":has")}
rbuggyQSA=rbuggyQSA.length&&new RegExp(rbuggyQSA.join("|"));sortOrder=function(a,b){if(a===b){hasDuplicate=!0;return 0}
var compare=!a.compareDocumentPosition-!b.compareDocumentPosition;if(compare){return compare}
compare=(a.ownerDocument||a)==(b.ownerDocument||b)?a.compareDocumentPosition(b):1;if(compare&1||(!support.sortDetached&&b.compareDocumentPosition(a)===compare)){if(a===document||a.ownerDocument==preferredDoc&&find.contains(preferredDoc,a)){return-1}
if(b===document||b.ownerDocument==preferredDoc&&find.contains(preferredDoc,b)){return 1}
return sortInput?(indexOf.call(sortInput,a)-indexOf.call(sortInput,b)):0}
return compare&4?-1:1};return document}
find.matches=function(expr,elements){return find(expr,null,null,elements)};find.matchesSelector=function(elem,expr){setDocument(elem);if(documentIsHTML&&!nonnativeSelectorCache[expr+" "]&&(!rbuggyQSA||!rbuggyQSA.test(expr))){try{var ret=matches.call(elem,expr);if(ret||support.disconnectedMatch||elem.document&&elem.document.nodeType!==11){return ret}}catch(e){nonnativeSelectorCache(expr,!0)}}
return find(expr,document,null,[elem]).length>0};find.contains=function(context,elem){if((context.ownerDocument||context)!=document){setDocument(context)}
return jQuery.contains(context,elem)};find.attr=function(elem,name){if((elem.ownerDocument||elem)!=document){setDocument(elem)}
var fn=Expr.attrHandle[name.toLowerCase()],val=fn&&hasOwn.call(Expr.attrHandle,name.toLowerCase())?fn(elem,name,!documentIsHTML):undefined;if(val!==undefined){return val}
return elem.getAttribute(name)};find.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg)};jQuery.uniqueSort=function(results){var elem,duplicates=[],j=0,i=0;hasDuplicate=!support.sortStable;sortInput=!support.sortStable&&slice.call(results,0);sort.call(results,sortOrder);if(hasDuplicate){while((elem=results[i++])){if(elem===results[i]){j=duplicates.push(i)}}
while(j--){splice.call(results,duplicates[j],1)}}
sortInput=null;return results};jQuery.fn.uniqueSort=function(){return this.pushStack(jQuery.uniqueSort(slice.apply(this)))};Expr=jQuery.expr={cacheLength:50,createPseudo:markFunction,match:matchExpr,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(match){match[1]=match[1].replace(runescape,funescape);match[3]=(match[3]||match[4]||match[5]||"").replace(runescape,funescape);if(match[2]==="~="){match[3]=" "+match[3]+" "}
return match.slice(0,4)},CHILD:function(match){match[1]=match[1].toLowerCase();if(match[1].slice(0,3)==="nth"){if(!match[3]){find.error(match[0])}
match[4]=+(match[4]?match[5]+(match[6]||1):2*(match[3]==="even"||match[3]==="odd"));match[5]=+((match[7]+match[8])||match[3]==="odd")}else if(match[3]){find.error(match[0])}
return match},PSEUDO:function(match){var excess,unquoted=!match[6]&&match[2];if(matchExpr.CHILD.test(match[0])){return null}
if(match[3]){match[2]=match[4]||match[5]||""}else if(unquoted&&rpseudo.test(unquoted)&&(excess=tokenize(unquoted,!0))&&(excess=unquoted.indexOf(")",unquoted.length-excess)-unquoted.length)){match[0]=match[0].slice(0,excess);match[2]=unquoted.slice(0,excess)}
return match.slice(0,3)}},filter:{TAG:function(nodeNameSelector){var expectedNodeName=nodeNameSelector.replace(runescape,funescape).toLowerCase();return nodeNameSelector==="*"?function(){return!0}:function(elem){return nodeName(elem,expectedNodeName)}},CLASS:function(className){var pattern=classCache[className+" "];return pattern||(pattern=new RegExp("(^|"+whitespace+")"+className+"("+whitespace+"|$)"))&&classCache(className,function(elem){return pattern.test(typeof elem.className==="string"&&elem.className||typeof elem.getAttribute!=="undefined"&&elem.getAttribute("class")||"")})},ATTR:function(name,operator,check){return function(elem){var result=find.attr(elem,name);if(result==null){return operator==="!="}
if(!operator){return!0}
result+="";if(operator==="="){return result===check}
if(operator==="!="){return result!==check}
if(operator==="^="){return check&&result.indexOf(check)===0}
if(operator==="*="){return check&&result.indexOf(check)>-1}
if(operator==="$="){return check&&result.slice(-check.length)===check}
if(operator==="~="){return(" "+result.replace(rwhitespace," ")+" ").indexOf(check)>-1}
if(operator==="|="){return result===check||result.slice(0,check.length+1)===check+"-"}
return!1}},CHILD:function(type,what,_argument,first,last){var simple=type.slice(0,3)!=="nth",forward=type.slice(-4)!=="last",ofType=what==="of-type";return first===1&&last===0?function(elem){return!!elem.parentNode}:function(elem,_context,xml){var cache,outerCache,node,nodeIndex,start,dir=simple!==forward?"nextSibling":"previousSibling",parent=elem.parentNode,name=ofType&&elem.nodeName.toLowerCase(),useCache=!xml&&!ofType,diff=!1;if(parent){if(simple){while(dir){node=elem;while((node=node[dir])){if(ofType?nodeName(node,name):node.nodeType===1){return!1}}
start=dir=type==="only"&&!start&&"nextSibling"}
return!0}
start=[forward?parent.firstChild:parent.lastChild];if(forward&&useCache){outerCache=parent[expando]||(parent[expando]={});cache=outerCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex&&cache[2];node=nodeIndex&&parent.childNodes[nodeIndex];while((node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())){if(node.nodeType===1&&++diff&&node===elem){outerCache[type]=[dirruns,nodeIndex,diff];break}}}else{if(useCache){outerCache=elem[expando]||(elem[expando]={});cache=outerCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex}
if(diff===!1){while((node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())){if((ofType?nodeName(node,name):node.nodeType===1)&&++diff){if(useCache){outerCache=node[expando]||(node[expando]={});outerCache[type]=[dirruns,diff]}
if(node===elem){break}}}}}
diff-=last;return diff===first||(diff%first===0&&diff/first>=0)}}},PSEUDO:function(pseudo,argument){var args,fn=Expr.pseudos[pseudo]||Expr.setFilters[pseudo.toLowerCase()]||find.error("unsupported pseudo: "+pseudo);if(fn[expando]){return fn(argument)}
if(fn.length>1){args=[pseudo,pseudo,"",argument];return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase())?markFunction(function(seed,matches){var idx,matched=fn(seed,argument),i=matched.length;while(i--){idx=indexOf.call(seed,matched[i]);seed[idx]=!(matches[idx]=matched[i])}}):function(elem){return fn(elem,0,args)}}
return fn}},pseudos:{not:markFunction(function(selector){var input=[],results=[],matcher=compile(selector.replace(rtrimCSS,"$1"));return matcher[expando]?markFunction(function(seed,matches,_context,xml){var elem,unmatched=matcher(seed,null,xml,[]),i=seed.length;while(i--){if((elem=unmatched[i])){seed[i]=!(matches[i]=elem)}}}):function(elem,_context,xml){input[0]=elem;matcher(input,null,xml,results);input[0]=null;return!results.pop()}}),has:markFunction(function(selector){return function(elem){return find(selector,elem).length>0}}),contains:markFunction(function(text){text=text.replace(runescape,funescape);return function(elem){return(elem.textContent||jQuery.text(elem)).indexOf(text)>-1}}),lang:markFunction(function(lang){if(!ridentifier.test(lang||"")){find.error("unsupported lang: "+lang)}
lang=lang.replace(runescape,funescape).toLowerCase();return function(elem){var elemLang;do{if((elemLang=documentIsHTML?elem.lang:elem.getAttribute("xml:lang")||elem.getAttribute("lang"))){elemLang=elemLang.toLowerCase();return elemLang===lang||elemLang.indexOf(lang+"-")===0}}while((elem=elem.parentNode)&&elem.nodeType===1);return!1}}),target:function(elem){var hash=window.location&&window.location.hash;return hash&&hash.slice(1)===elem.id},root:function(elem){return elem===documentElement},focus:function(elem){return elem===safeActiveElement()&&document.hasFocus()&&!!(elem.type||elem.href||~elem.tabIndex)},enabled:createDisabledPseudo(!1),disabled:createDisabledPseudo(!0),checked:function(elem){return(nodeName(elem,"input")&&!!elem.checked)||(nodeName(elem,"option")&&!!elem.selected)},selected:function(elem){if(elem.parentNode){elem.parentNode.selectedIndex}
return elem.selected===!0},empty:function(elem){for(elem=elem.firstChild;elem;elem=elem.nextSibling){if(elem.nodeType<6){return!1}}
return!0},parent:function(elem){return!Expr.pseudos.empty(elem)},header:function(elem){return rheader.test(elem.nodeName)},input:function(elem){return rinputs.test(elem.nodeName)},button:function(elem){return nodeName(elem,"input")&&elem.type==="button"||nodeName(elem,"button")},text:function(elem){var attr;return nodeName(elem,"input")&&elem.type==="text"&&((attr=elem.getAttribute("type"))==null||attr.toLowerCase()==="text")},first:createPositionalPseudo(function(){return[0]}),last:createPositionalPseudo(function(_matchIndexes,length){return[length-1]}),eq:createPositionalPseudo(function(_matchIndexes,length,argument){return[argument<0?argument+length:argument]}),even:createPositionalPseudo(function(matchIndexes,length){var i=0;for(;i<length;i+=2){matchIndexes.push(i)}
return matchIndexes}),odd:createPositionalPseudo(function(matchIndexes,length){var i=1;for(;i<length;i+=2){matchIndexes.push(i)}
return matchIndexes}),lt:createPositionalPseudo(function(matchIndexes,length,argument){var i;if(argument<0){i=argument+length}else if(argument>length){i=length}else{i=argument}
for(;--i>=0;){matchIndexes.push(i)}
return matchIndexes}),gt:createPositionalPseudo(function(matchIndexes,length,argument){var i=argument<0?argument+length:argument;for(;++i<length;){matchIndexes.push(i)}
return matchIndexes})}};Expr.pseudos.nth=Expr.pseudos.eq;for(i in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0}){Expr.pseudos[i]=createInputPseudo(i)}
for(i in{submit:!0,reset:!0}){Expr.pseudos[i]=createButtonPseudo(i)}
function setFilters(){}
setFilters.prototype=Expr.filters=Expr.pseudos;Expr.setFilters=new setFilters();function tokenize(selector,parseOnly){var matched,match,tokens,type,soFar,groups,preFilters,cached=tokenCache[selector+" "];if(cached){return parseOnly?0:cached.slice(0)}
soFar=selector;groups=[];preFilters=Expr.preFilter;while(soFar){if(!matched||(match=rcomma.exec(soFar))){if(match){soFar=soFar.slice(match[0].length)||soFar}
groups.push((tokens=[]))}
matched=!1;if((match=rleadingCombinator.exec(soFar))){matched=match.shift();tokens.push({value:matched,type:match[0].replace(rtrimCSS," ")});soFar=soFar.slice(matched.length)}
for(type in Expr.filter){if((match=matchExpr[type].exec(soFar))&&(!preFilters[type]||(match=preFilters[type](match)))){matched=match.shift();tokens.push({value:matched,type:type,matches:match});soFar=soFar.slice(matched.length)}}
if(!matched){break}}
if(parseOnly){return soFar.length}
return soFar?find.error(selector):tokenCache(selector,groups).slice(0)}
function toSelector(tokens){var i=0,len=tokens.length,selector="";for(;i<len;i++){selector+=tokens[i].value}
return selector}
function addCombinator(matcher,combinator,base){var dir=combinator.dir,skip=combinator.next,key=skip||dir,checkNonElements=base&&key==="parentNode",doneName=done++;return combinator.first?function(elem,context,xml){while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){return matcher(elem,context,xml)}}
return!1}:function(elem,context,xml){var oldCache,outerCache,newCache=[dirruns,doneName];if(xml){while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){if(matcher(elem,context,xml)){return!0}}}}else{while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){outerCache=elem[expando]||(elem[expando]={});if(skip&&nodeName(elem,skip)){elem=elem[dir]||elem}else if((oldCache=outerCache[key])&&oldCache[0]===dirruns&&oldCache[1]===doneName){return(newCache[2]=oldCache[2])}else{outerCache[key]=newCache;if((newCache[2]=matcher(elem,context,xml))){return!0}}}}}
return!1}}
function elementMatcher(matchers){return matchers.length>1?function(elem,context,xml){var i=matchers.length;while(i--){if(!matchers[i](elem,context,xml)){return!1}}
return!0}:matchers[0]}
function multipleContexts(selector,contexts,results){var i=0,len=contexts.length;for(;i<len;i++){find(selector,contexts[i],results)}
return results}
function condense(unmatched,map,filter,context,xml){var elem,newUnmatched=[],i=0,len=unmatched.length,mapped=map!=null;for(;i<len;i++){if((elem=unmatched[i])){if(!filter||filter(elem,context,xml)){newUnmatched.push(elem);if(mapped){map.push(i)}}}}
return newUnmatched}
function setMatcher(preFilter,selector,matcher,postFilter,postFinder,postSelector){if(postFilter&&!postFilter[expando]){postFilter=setMatcher(postFilter)}
if(postFinder&&!postFinder[expando]){postFinder=setMatcher(postFinder,postSelector)}
return markFunction(function(seed,results,context,xml){var temp,i,elem,matcherOut,preMap=[],postMap=[],preexisting=results.length,elems=seed||multipleContexts(selector||"*",context.nodeType?[context]:context,[]),matcherIn=preFilter&&(seed||!selector)?condense(elems,preMap,preFilter,context,xml):elems;if(matcher){matcherOut=postFinder||(seed?preFilter:preexisting||postFilter)?[]:results;matcher(matcherIn,matcherOut,context,xml)}else{matcherOut=matcherIn}
if(postFilter){temp=condense(matcherOut,postMap);postFilter(temp,[],context,xml);i=temp.length;while(i--){if((elem=temp[i])){matcherOut[postMap[i]]=!(matcherIn[postMap[i]]=elem)}}}
if(seed){if(postFinder||preFilter){if(postFinder){temp=[];i=matcherOut.length;while(i--){if((elem=matcherOut[i])){temp.push((matcherIn[i]=elem))}}
postFinder(null,(matcherOut=[]),temp,xml)}
i=matcherOut.length;while(i--){if((elem=matcherOut[i])&&(temp=postFinder?indexOf.call(seed,elem):preMap[i])>-1){seed[temp]=!(results[temp]=elem)}}}}else{matcherOut=condense(matcherOut===results?matcherOut.splice(preexisting,matcherOut.length):matcherOut);if(postFinder){postFinder(null,results,matcherOut,xml)}else{push.apply(results,matcherOut)}}})}
function matcherFromTokens(tokens){var checkContext,matcher,j,len=tokens.length,leadingRelative=Expr.relative[tokens[0].type],implicitRelative=leadingRelative||Expr.relative[" "],i=leadingRelative?1:0,matchContext=addCombinator(function(elem){return elem===checkContext},implicitRelative,!0),matchAnyContext=addCombinator(function(elem){return indexOf.call(checkContext,elem)>-1},implicitRelative,!0),matchers=[function(elem,context,xml){var ret=(!leadingRelative&&(xml||context!=outermostContext))||((checkContext=context).nodeType?matchContext(elem,context,xml):matchAnyContext(elem,context,xml));checkContext=null;return ret}];for(;i<len;i++){if((matcher=Expr.relative[tokens[i].type])){matchers=[addCombinator(elementMatcher(matchers),matcher)]}else{matcher=Expr.filter[tokens[i].type].apply(null,tokens[i].matches);if(matcher[expando]){j=++i;for(;j<len;j++){if(Expr.relative[tokens[j].type]){break}}
return setMatcher(i>1&&elementMatcher(matchers),i>1&&toSelector(tokens.slice(0,i-1).concat({value:tokens[i-2].type===" "?"*":""})).replace(rtrimCSS,"$1"),matcher,i<j&&matcherFromTokens(tokens.slice(i,j)),j<len&&matcherFromTokens((tokens=tokens.slice(j))),j<len&&toSelector(tokens))}
matchers.push(matcher)}}
return elementMatcher(matchers)}
function matcherFromGroupMatchers(elementMatchers,setMatchers){var bySet=setMatchers.length>0,byElement=elementMatchers.length>0,superMatcher=function(seed,context,xml,results,outermost){var elem,j,matcher,matchedCount=0,i="0",unmatched=seed&&[],setMatched=[],contextBackup=outermostContext,elems=seed||byElement&&Expr.find.TAG("*",outermost),dirrunsUnique=(dirruns+=contextBackup==null?1:Math.random()||0.1),len=elems.length;if(outermost){outermostContext=context==document||context||outermost}
for(;i!==len&&(elem=elems[i])!=null;i++){if(byElement&&elem){j=0;if(!context&&elem.ownerDocument!=document){setDocument(elem);xml=!documentIsHTML}
while((matcher=elementMatchers[j++])){if(matcher(elem,context||document,xml)){push.call(results,elem);break}}
if(outermost){dirruns=dirrunsUnique}}
if(bySet){if((elem=!matcher&&elem)){matchedCount--}
if(seed){unmatched.push(elem)}}}
matchedCount+=i;if(bySet&&i!==matchedCount){j=0;while((matcher=setMatchers[j++])){matcher(unmatched,setMatched,context,xml)}
if(seed){if(matchedCount>0){while(i--){if(!(unmatched[i]||setMatched[i])){setMatched[i]=pop.call(results)}}}
setMatched=condense(setMatched)}
push.apply(results,setMatched);if(outermost&&!seed&&setMatched.length>0&&(matchedCount+setMatchers.length)>1){jQuery.uniqueSort(results)}}
if(outermost){dirruns=dirrunsUnique;outermostContext=contextBackup}
return unmatched};return bySet?markFunction(superMatcher):superMatcher}
function compile(selector,match){var i,setMatchers=[],elementMatchers=[],cached=compilerCache[selector+" "];if(!cached){if(!match){match=tokenize(selector)}
i=match.length;while(i--){cached=matcherFromTokens(match[i]);if(cached[expando]){setMatchers.push(cached)}else{elementMatchers.push(cached)}}
cached=compilerCache(selector,matcherFromGroupMatchers(elementMatchers,setMatchers));cached.selector=selector}
return cached}
function select(selector,context,results,seed){var i,tokens,token,type,find,compiled=typeof selector==="function"&&selector,match=!seed&&tokenize((selector=compiled.selector||selector));results=results||[];if(match.length===1){tokens=match[0]=match[0].slice(0);if(tokens.length>2&&(token=tokens[0]).type==="ID"&&context.nodeType===9&&documentIsHTML&&Expr.relative[tokens[1].type]){context=(Expr.find.ID(token.matches[0].replace(runescape,funescape),context)||[])[0];if(!context){return results}else if(compiled){context=context.parentNode}
selector=selector.slice(tokens.shift().value.length)}
i=matchExpr.needsContext.test(selector)?0:tokens.length;while(i--){token=tokens[i];if(Expr.relative[(type=token.type)]){break}
if((find=Expr.find[type])){if((seed=find(token.matches[0].replace(runescape,funescape),rsibling.test(tokens[0].type)&&testContext(context.parentNode)||context))){tokens.splice(i,1);selector=seed.length&&toSelector(tokens);if(!selector){push.apply(results,seed);return results}
break}}}}(compiled||compile(selector,match))(seed,context,!documentIsHTML,results,!context||rsibling.test(selector)&&testContext(context.parentNode)||context);return results}
support.sortStable=expando.split("").sort(sortOrder).join("")===expando;setDocument();support.sortDetached=assert(function(el){return el.compareDocumentPosition(document.createElement("fieldset"))&1});jQuery.find=find;jQuery.expr[":"]=jQuery.expr.pseudos;jQuery.unique=jQuery.uniqueSort;find.compile=compile;find.select=select;find.setDocument=setDocument;find.tokenize=tokenize;find.escape=jQuery.escapeSelector;find.getText=jQuery.text;find.isXML=jQuery.isXMLDoc;find.selectors=jQuery.expr;find.support=jQuery.support;find.uniqueSort=jQuery.uniqueSort})();var dir=function(elem,dir,until){var matched=[],truncate=until!==undefined;while((elem=elem[dir])&&elem.nodeType!==9){if(elem.nodeType===1){if(truncate&&jQuery(elem).is(until)){break}
matched.push(elem)}}
return matched};var siblings=function(n,elem){var matched=[];for(;n;n=n.nextSibling){if(n.nodeType===1&&n!==elem){matched.push(n)}}
return matched};var rneedsContext=jQuery.expr.match.needsContext;var rsingleTag=(/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i);function winnow(elements,qualifier,not){if(isFunction(qualifier)){return jQuery.grep(elements,function(elem,i){return!!qualifier.call(elem,i,elem)!==not})}
if(qualifier.nodeType){return jQuery.grep(elements,function(elem){return(elem===qualifier)!==not})}
if(typeof qualifier!=="string"){return jQuery.grep(elements,function(elem){return(indexOf.call(qualifier,elem)>-1)!==not})}
return jQuery.filter(qualifier,elements,not)}
jQuery.filter=function(expr,elems,not){var elem=elems[0];if(not){expr=":not("+expr+")"}
if(elems.length===1&&elem.nodeType===1){return jQuery.find.matchesSelector(elem,expr)?[elem]:[]}
return jQuery.find.matches(expr,jQuery.grep(elems,function(elem){return elem.nodeType===1}))};jQuery.fn.extend({find:function(selector){var i,ret,len=this.length,self=this;if(typeof selector!=="string"){return this.pushStack(jQuery(selector).filter(function(){for(i=0;i<len;i++){if(jQuery.contains(self[i],this)){return!0}}}))}
ret=this.pushStack([]);for(i=0;i<len;i++){jQuery.find(selector,self[i],ret)}
return len>1?jQuery.uniqueSort(ret):ret},filter:function(selector){return this.pushStack(winnow(this,selector||[],!1))},not:function(selector){return this.pushStack(winnow(this,selector||[],!0))},is:function(selector){return!!winnow(this,typeof selector==="string"&&rneedsContext.test(selector)?jQuery(selector):selector||[],!1).length}});var rootjQuery,rquickExpr=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,init=jQuery.fn.init=function(selector,context,root){var match,elem;if(!selector){return this}
root=root||rootjQuery;if(typeof selector==="string"){if(selector[0]==="<"&&selector[selector.length-1]===">"&&selector.length>=3){match=[null,selector,null]}else{match=rquickExpr.exec(selector)}
if(match&&(match[1]||!context)){if(match[1]){context=context instanceof jQuery?context[0]:context;jQuery.merge(this,jQuery.parseHTML(match[1],context&&context.nodeType?context.ownerDocument||context:document,!0));if(rsingleTag.test(match[1])&&jQuery.isPlainObject(context)){for(match in context){if(isFunction(this[match])){this[match](context[match])}else{this.attr(match,context[match])}}}
return this}else{elem=document.getElementById(match[2]);if(elem){this[0]=elem;this.length=1}
return this}}else if(!context||context.jquery){return(context||root).find(selector)}else{return this.constructor(context).find(selector)}}else if(selector.nodeType){this[0]=selector;this.length=1;return this}else if(isFunction(selector)){return root.ready!==undefined?root.ready(selector):selector(jQuery)}
return jQuery.makeArray(selector,this)};init.prototype=jQuery.fn;rootjQuery=jQuery(document);var rparentsprev=/^(?:parents|prev(?:Until|All))/,guaranteedUnique={children:!0,contents:!0,next:!0,prev:!0};jQuery.fn.extend({has:function(target){var targets=jQuery(target,this),l=targets.length;return this.filter(function(){var i=0;for(;i<l;i++){if(jQuery.contains(this,targets[i])){return!0}}})},closest:function(selectors,context){var cur,i=0,l=this.length,matched=[],targets=typeof selectors!=="string"&&jQuery(selectors);if(!rneedsContext.test(selectors)){for(;i<l;i++){for(cur=this[i];cur&&cur!==context;cur=cur.parentNode){if(cur.nodeType<11&&(targets?targets.index(cur)>-1:cur.nodeType===1&&jQuery.find.matchesSelector(cur,selectors))){matched.push(cur);break}}}}
return this.pushStack(matched.length>1?jQuery.uniqueSort(matched):matched)},index:function(elem){if(!elem){return(this[0]&&this[0].parentNode)?this.first().prevAll().length:-1}
if(typeof elem==="string"){return indexOf.call(jQuery(elem),this[0])}
return indexOf.call(this,elem.jquery?elem[0]:elem)},add:function(selector,context){return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(),jQuery(selector,context))))},addBack:function(selector){return this.add(selector==null?this.prevObject:this.prevObject.filter(selector))}});function sibling(cur,dir){while((cur=cur[dir])&&cur.nodeType!==1){}
return cur}
jQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&parent.nodeType!==11?parent:null},parents:function(elem){return dir(elem,"parentNode")},parentsUntil:function(elem,_i,until){return dir(elem,"parentNode",until)},next:function(elem){return sibling(elem,"nextSibling")},prev:function(elem){return sibling(elem,"previousSibling")},nextAll:function(elem){return dir(elem,"nextSibling")},prevAll:function(elem){return dir(elem,"previousSibling")},nextUntil:function(elem,_i,until){return dir(elem,"nextSibling",until)},prevUntil:function(elem,_i,until){return dir(elem,"previousSibling",until)},siblings:function(elem){return siblings((elem.parentNode||{}).firstChild,elem)},children:function(elem){return siblings(elem.firstChild)},contents:function(elem){if(elem.contentDocument!=null&&getProto(elem.contentDocument)){return elem.contentDocument}
if(nodeName(elem,"template")){elem=elem.content||elem}
return jQuery.merge([],elem.childNodes)}},function(name,fn){jQuery.fn[name]=function(until,selector){var matched=jQuery.map(this,fn,until);if(name.slice(-5)!=="Until"){selector=until}
if(selector&&typeof selector==="string"){matched=jQuery.filter(selector,matched)}
if(this.length>1){if(!guaranteedUnique[name]){jQuery.uniqueSort(matched)}
if(rparentsprev.test(name)){matched.reverse()}}
return this.pushStack(matched)}});var rnothtmlwhite=(/[^\x20\t\r\n\f]+/g);function createOptions(options){var object={};jQuery.each(options.match(rnothtmlwhite)||[],function(_,flag){object[flag]=!0});return object}
jQuery.Callbacks=function(options){options=typeof options==="string"?createOptions(options):jQuery.extend({},options);var firing,memory,fired,locked,list=[],queue=[],firingIndex=-1,fire=function(){locked=locked||options.once;fired=firing=!0;for(;queue.length;firingIndex=-1){memory=queue.shift();while(++firingIndex<list.length){if(list[firingIndex].apply(memory[0],memory[1])===!1&&options.stopOnFalse){firingIndex=list.length;memory=!1}}}
if(!options.memory){memory=!1}
firing=!1;if(locked){if(memory){list=[]}else{list=""}}},self={add:function(){if(list){if(memory&&!firing){firingIndex=list.length-1;queue.push(memory)}(function add(args){jQuery.each(args,function(_,arg){if(isFunction(arg)){if(!options.unique||!self.has(arg)){list.push(arg)}}else if(arg&&arg.length&&toType(arg)!=="string"){add(arg)}})})(arguments);if(memory&&!firing){fire()}}
return this},remove:function(){jQuery.each(arguments,function(_,arg){var index;while((index=jQuery.inArray(arg,list,index))>-1){list.splice(index,1);if(index<=firingIndex){firingIndex--}}});return this},has:function(fn){return fn?jQuery.inArray(fn,list)>-1:list.length>0},empty:function(){if(list){list=[]}
return this},disable:function(){locked=queue=[];list=memory="";return this},disabled:function(){return!list},lock:function(){locked=queue=[];if(!memory&&!firing){list=memory=""}
return this},locked:function(){return!!locked},fireWith:function(context,args){if(!locked){args=args||[];args=[context,args.slice?args.slice():args];queue.push(args);if(!firing){fire()}}
return this},fire:function(){self.fireWith(this,arguments);return this},fired:function(){return!!fired}};return self};function Identity(v){return v}
function Thrower(ex){throw ex}
function adoptValue(value,resolve,reject,noValue){var method;try{if(value&&isFunction((method=value.promise))){method.call(value).done(resolve).fail(reject)}else if(value&&isFunction((method=value.then))){method.call(value,resolve,reject)}else{resolve.apply(undefined,[value].slice(noValue))}}catch(value){reject.apply(undefined,[value])}}
jQuery.extend({Deferred:function(func){var tuples=[["notify","progress",jQuery.Callbacks("memory"),jQuery.Callbacks("memory"),2],["resolve","done",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),0,"resolved"],["reject","fail",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),1,"rejected"]],state="pending",promise={state:function(){return state},always:function(){deferred.done(arguments).fail(arguments);return this},"catch":function(fn){return promise.then(null,fn)},pipe:function(){var fns=arguments;return jQuery.Deferred(function(newDefer){jQuery.each(tuples,function(_i,tuple){var fn=isFunction(fns[tuple[4]])&&fns[tuple[4]];deferred[tuple[1]](function(){var returned=fn&&fn.apply(this,arguments);if(returned&&isFunction(returned.promise)){returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject)}else{newDefer[tuple[0]+"With"](this,fn?[returned]:arguments)}})});fns=null}).promise()},then:function(onFulfilled,onRejected,onProgress){var maxDepth=0;function resolve(depth,deferred,handler,special){return function(){var that=this,args=arguments,mightThrow=function(){var returned,then;if(depth<maxDepth){return}
returned=handler.apply(that,args);if(returned===deferred.promise()){throw new TypeError("Thenable self-resolution")}
then=returned&&(typeof returned==="object"||typeof returned==="function")&&returned.then;if(isFunction(then)){if(special){then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special))}else{maxDepth++;then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special),resolve(maxDepth,deferred,Identity,deferred.notifyWith))}}else{if(handler!==Identity){that=undefined;args=[returned]}(special||deferred.resolveWith)(that,args)}},process=special?mightThrow:function(){try{mightThrow()}catch(e){if(jQuery.Deferred.exceptionHook){jQuery.Deferred.exceptionHook(e,process.error)}
if(depth+1>=maxDepth){if(handler!==Thrower){that=undefined;args=[e]}
deferred.rejectWith(that,args)}}};if(depth){process()}else{if(jQuery.Deferred.getErrorHook){process.error=jQuery.Deferred.getErrorHook()}else if(jQuery.Deferred.getStackHook){process.error=jQuery.Deferred.getStackHook()}
window.setTimeout(process)}}}
return jQuery.Deferred(function(newDefer){tuples[0][3].add(resolve(0,newDefer,isFunction(onProgress)?onProgress:Identity,newDefer.notifyWith));tuples[1][3].add(resolve(0,newDefer,isFunction(onFulfilled)?onFulfilled:Identity));tuples[2][3].add(resolve(0,newDefer,isFunction(onRejected)?onRejected:Thrower))}).promise()},promise:function(obj){return obj!=null?jQuery.extend(obj,promise):promise}},deferred={};jQuery.each(tuples,function(i,tuple){var list=tuple[2],stateString=tuple[5];promise[tuple[1]]=list.add;if(stateString){list.add(function(){state=stateString},tuples[3-i][2].disable,tuples[3-i][3].disable,tuples[0][2].lock,tuples[0][3].lock)}
list.add(tuple[3].fire);deferred[tuple[0]]=function(){deferred[tuple[0]+"With"](this===deferred?undefined:this,arguments);return this};deferred[tuple[0]+"With"]=list.fireWith});promise.promise(deferred);if(func){func.call(deferred,deferred)}
return deferred},when:function(singleValue){var
remaining=arguments.length,i=remaining,resolveContexts=Array(i),resolveValues=slice.call(arguments),primary=jQuery.Deferred(),updateFunc=function(i){return function(value){resolveContexts[i]=this;resolveValues[i]=arguments.length>1?slice.call(arguments):value;if(!(--remaining)){primary.resolveWith(resolveContexts,resolveValues)}}};if(remaining<=1){adoptValue(singleValue,primary.done(updateFunc(i)).resolve,primary.reject,!remaining);if(primary.state()==="pending"||isFunction(resolveValues[i]&&resolveValues[i].then)){return primary.then()}}
while(i--){adoptValue(resolveValues[i],updateFunc(i),primary.reject)}
return primary.promise()}});var rerrorNames=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;jQuery.Deferred.exceptionHook=function(error,asyncError){if(window.console&&window.console.warn&&error&&rerrorNames.test(error.name)){window.console.warn("jQuery.Deferred exception: "+error.message,error.stack,asyncError)}};jQuery.readyException=function(error){window.setTimeout(function(){throw error})};var readyList=jQuery.Deferred();jQuery.fn.ready=function(fn){readyList.then(fn).catch(function(error){jQuery.readyException(error)});return this};jQuery.extend({isReady:!1,readyWait:1,ready:function(wait){if(wait===!0?--jQuery.readyWait:jQuery.isReady){return}
jQuery.isReady=!0;if(wait!==!0&&--jQuery.readyWait>0){return}
readyList.resolveWith(document,[jQuery])}});jQuery.ready.then=readyList.then;function completed(){document.removeEventListener("DOMContentLoaded",completed);window.removeEventListener("load",completed);jQuery.ready()}
if(document.readyState==="complete"||(document.readyState!=="loading"&&!document.documentElement.doScroll)){window.setTimeout(jQuery.ready)}else{document.addEventListener("DOMContentLoaded",completed);window.addEventListener("load",completed)}
var access=function(elems,fn,key,value,chainable,emptyGet,raw){var i=0,len=elems.length,bulk=key==null;if(toType(key)==="object"){chainable=!0;for(i in key){access(elems,fn,i,key[i],!0,emptyGet,raw)}}else if(value!==undefined){chainable=!0;if(!isFunction(value)){raw=!0}
if(bulk){if(raw){fn.call(elems,value);fn=null}else{bulk=fn;fn=function(elem,_key,value){return bulk.call(jQuery(elem),value)}}}
if(fn){for(;i<len;i++){fn(elems[i],key,raw?value:value.call(elems[i],i,fn(elems[i],key)))}}}
if(chainable){return elems}
if(bulk){return fn.call(elems)}
return len?fn(elems[0],key):emptyGet};var rmsPrefix=/^-ms-/,rdashAlpha=/-([a-z])/g;function fcamelCase(_all,letter){return letter.toUpperCase()}
function camelCase(string){return string.replace(rmsPrefix,"ms-").replace(rdashAlpha,fcamelCase)}
var acceptData=function(owner){return owner.nodeType===1||owner.nodeType===9||!(+owner.nodeType)};function Data(){this.expando=jQuery.expando+Data.uid++}
Data.uid=1;Data.prototype={cache:function(owner){var value=owner[this.expando];if(!value){value={};if(acceptData(owner)){if(owner.nodeType){owner[this.expando]=value}else{Object.defineProperty(owner,this.expando,{value:value,configurable:!0})}}}
return value},set:function(owner,data,value){var prop,cache=this.cache(owner);if(typeof data==="string"){cache[camelCase(data)]=value}else{for(prop in data){cache[camelCase(prop)]=data[prop]}}
return cache},get:function(owner,key){return key===undefined?this.cache(owner):owner[this.expando]&&owner[this.expando][camelCase(key)]},access:function(owner,key,value){if(key===undefined||((key&&typeof key==="string")&&value===undefined)){return this.get(owner,key)}
this.set(owner,key,value);return value!==undefined?value:key},remove:function(owner,key){var i,cache=owner[this.expando];if(cache===undefined){return}
if(key!==undefined){if(Array.isArray(key)){key=key.map(camelCase)}else{key=camelCase(key);key=key in cache?[key]:(key.match(rnothtmlwhite)||[])}
i=key.length;while(i--){delete cache[key[i]]}}
if(key===undefined||jQuery.isEmptyObject(cache)){if(owner.nodeType){owner[this.expando]=undefined}else{delete owner[this.expando]}}},hasData:function(owner){var cache=owner[this.expando];return cache!==undefined&&!jQuery.isEmptyObject(cache)}};var dataPriv=new Data();var dataUser=new Data();var rbrace=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,rmultiDash=/[A-Z]/g;function getData(data){if(data==="true"){return!0}
if(data==="false"){return!1}
if(data==="null"){return null}
if(data===+data+""){return+data}
if(rbrace.test(data)){return JSON.parse(data)}
return data}
function dataAttr(elem,key,data){var name;if(data===undefined&&elem.nodeType===1){name="data-"+key.replace(rmultiDash,"-$&").toLowerCase();data=elem.getAttribute(name);if(typeof data==="string"){try{data=getData(data)}catch(e){}
dataUser.set(elem,key,data)}else{data=undefined}}
return data}
jQuery.extend({hasData:function(elem){return dataUser.hasData(elem)||dataPriv.hasData(elem)},data:function(elem,name,data){return dataUser.access(elem,name,data)},removeData:function(elem,name){dataUser.remove(elem,name)},_data:function(elem,name,data){return dataPriv.access(elem,name,data)},_removeData:function(elem,name){dataPriv.remove(elem,name)}});jQuery.fn.extend({data:function(key,value){var i,name,data,elem=this[0],attrs=elem&&elem.attributes;if(key===undefined){if(this.length){data=dataUser.get(elem);if(elem.nodeType===1&&!dataPriv.get(elem,"hasDataAttrs")){i=attrs.length;while(i--){if(attrs[i]){name=attrs[i].name;if(name.indexOf("data-")===0){name=camelCase(name.slice(5));dataAttr(elem,name,data[name])}}}
dataPriv.set(elem,"hasDataAttrs",!0)}}
return data}
if(typeof key==="object"){return this.each(function(){dataUser.set(this,key)})}
return access(this,function(value){var data;if(elem&&value===undefined){data=dataUser.get(elem,key);if(data!==undefined){return data}
data=dataAttr(elem,key);if(data!==undefined){return data}
return}
this.each(function(){dataUser.set(this,key,value)})},null,value,arguments.length>1,null,!0)},removeData:function(key){return this.each(function(){dataUser.remove(this,key)})}});jQuery.extend({queue:function(elem,type,data){var queue;if(elem){type=(type||"fx")+"queue";queue=dataPriv.get(elem,type);if(data){if(!queue||Array.isArray(data)){queue=dataPriv.access(elem,type,jQuery.makeArray(data))}else{queue.push(data)}}
return queue||[]}},dequeue:function(elem,type){type=type||"fx";var queue=jQuery.queue(elem,type),startLength=queue.length,fn=queue.shift(),hooks=jQuery._queueHooks(elem,type),next=function(){jQuery.dequeue(elem,type)};if(fn==="inprogress"){fn=queue.shift();startLength--}
if(fn){if(type==="fx"){queue.unshift("inprogress")}
delete hooks.stop;fn.call(elem,next,hooks)}
if(!startLength&&hooks){hooks.empty.fire()}},_queueHooks:function(elem,type){var key=type+"queueHooks";return dataPriv.get(elem,key)||dataPriv.access(elem,key,{empty:jQuery.Callbacks("once memory").add(function(){dataPriv.remove(elem,[type+"queue",key])})})}});jQuery.fn.extend({queue:function(type,data){var setter=2;if(typeof type!=="string"){data=type;type="fx";setter--}
if(arguments.length<setter){return jQuery.queue(this[0],type)}
return data===undefined?this:this.each(function(){var queue=jQuery.queue(this,type,data);jQuery._queueHooks(this,type);if(type==="fx"&&queue[0]!=="inprogress"){jQuery.dequeue(this,type)}})},dequeue:function(type){return this.each(function(){jQuery.dequeue(this,type)})},clearQueue:function(type){return this.queue(type||"fx",[])},promise:function(type,obj){var tmp,count=1,defer=jQuery.Deferred(),elements=this,i=this.length,resolve=function(){if(!(--count)){defer.resolveWith(elements,[elements])}};if(typeof type!=="string"){obj=type;type=undefined}
type=type||"fx";while(i--){tmp=dataPriv.get(elements[i],type+"queueHooks");if(tmp&&tmp.empty){count++;tmp.empty.add(resolve)}}
resolve();return defer.promise(obj)}});var pnum=(/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/).source;var rcssNum=new RegExp("^(?:([+-])=|)("+pnum+")([a-z%]*)$","i");var cssExpand=["Top","Right","Bottom","Left"];var documentElement=document.documentElement;var isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem)},composed={composed:!0};if(documentElement.getRootNode){isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem)||elem.getRootNode(composed)===elem.ownerDocument}}
var isHiddenWithinTree=function(elem,el){elem=el||elem;return elem.style.display==="none"||elem.style.display===""&&isAttached(elem)&&jQuery.css(elem,"display")==="none"};function adjustCSS(elem,prop,valueParts,tween){var adjusted,scale,maxIterations=20,currentValue=tween?function(){return tween.cur()}:function(){return jQuery.css(elem,prop,"")},initial=currentValue(),unit=valueParts&&valueParts[3]||(jQuery.cssNumber[prop]?"":"px"),initialInUnit=elem.nodeType&&(jQuery.cssNumber[prop]||unit!=="px"&&+initial)&&rcssNum.exec(jQuery.css(elem,prop));if(initialInUnit&&initialInUnit[3]!==unit){initial=initial/2;unit=unit||initialInUnit[3];initialInUnit=+initial||1;while(maxIterations--){jQuery.style(elem,prop,initialInUnit+unit);if((1-scale)*(1-(scale=currentValue()/initial||0.5))<=0){maxIterations=0}
initialInUnit=initialInUnit/scale}
initialInUnit=initialInUnit*2;jQuery.style(elem,prop,initialInUnit+unit);valueParts=valueParts||[]}
if(valueParts){initialInUnit=+initialInUnit||+initial||0;adjusted=valueParts[1]?initialInUnit+(valueParts[1]+1)*valueParts[2]:+valueParts[2];if(tween){tween.unit=unit;tween.start=initialInUnit;tween.end=adjusted}}
return adjusted}
var defaultDisplayMap={};function getDefaultDisplay(elem){var temp,doc=elem.ownerDocument,nodeName=elem.nodeName,display=defaultDisplayMap[nodeName];if(display){return display}
temp=doc.body.appendChild(doc.createElement(nodeName));display=jQuery.css(temp,"display");temp.parentNode.removeChild(temp);if(display==="none"){display="block"}
defaultDisplayMap[nodeName]=display;return display}
function showHide(elements,show){var display,elem,values=[],index=0,length=elements.length;for(;index<length;index++){elem=elements[index];if(!elem.style){continue}
display=elem.style.display;if(show){if(display==="none"){values[index]=dataPriv.get(elem,"display")||null;if(!values[index]){elem.style.display=""}}
if(elem.style.display===""&&isHiddenWithinTree(elem)){values[index]=getDefaultDisplay(elem)}}else{if(display!=="none"){values[index]="none";dataPriv.set(elem,"display",display)}}}
for(index=0;index<length;index++){if(values[index]!=null){elements[index].style.display=values[index]}}
return elements}
jQuery.fn.extend({show:function(){return showHide(this,!0)},hide:function(){return showHide(this)},toggle:function(state){if(typeof state==="boolean"){return state?this.show():this.hide()}
return this.each(function(){if(isHiddenWithinTree(this)){jQuery(this).show()}else{jQuery(this).hide()}})}});var rcheckableType=(/^(?:checkbox|radio)$/i);var rtagName=(/<([a-z][^\/\0>\x20\t\r\n\f]*)/i);var rscriptType=(/^$|^module$|\/(?:java|ecma)script/i);(function(){var fragment=document.createDocumentFragment(),div=fragment.appendChild(document.createElement("div")),input=document.createElement("input");input.setAttribute("type","radio");input.setAttribute("checked","checked");input.setAttribute("name","t");div.appendChild(input);support.checkClone=div.cloneNode(!0).cloneNode(!0).lastChild.checked;div.innerHTML="<textarea>x</textarea>";support.noCloneChecked=!!div.cloneNode(!0).lastChild.defaultValue;div.innerHTML="<option></option>";support.option=!!div.lastChild})();var wrapMap={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead;wrapMap.th=wrapMap.td;if(!support.option){wrapMap.optgroup=wrapMap.option=[1,"<select multiple='multiple'>","</select>"]}
function getAll(context,tag){var ret;if(typeof context.getElementsByTagName!=="undefined"){ret=context.getElementsByTagName(tag||"*")}else if(typeof context.querySelectorAll!=="undefined"){ret=context.querySelectorAll(tag||"*")}else{ret=[]}
if(tag===undefined||tag&&nodeName(context,tag)){return jQuery.merge([context],ret)}
return ret}
function setGlobalEval(elems,refElements){var i=0,l=elems.length;for(;i<l;i++){dataPriv.set(elems[i],"globalEval",!refElements||dataPriv.get(refElements[i],"globalEval"))}}
var rhtml=/<|&#?\w+;/;function buildFragment(elems,context,scripts,selection,ignored){var elem,tmp,tag,wrap,attached,j,fragment=context.createDocumentFragment(),nodes=[],i=0,l=elems.length;for(;i<l;i++){elem=elems[i];if(elem||elem===0){if(toType(elem)==="object"){jQuery.merge(nodes,elem.nodeType?[elem]:elem)}else if(!rhtml.test(elem)){nodes.push(context.createTextNode(elem))}else{tmp=tmp||fragment.appendChild(context.createElement("div"));tag=(rtagName.exec(elem)||["",""])[1].toLowerCase();wrap=wrapMap[tag]||wrapMap._default;tmp.innerHTML=wrap[1]+jQuery.htmlPrefilter(elem)+wrap[2];j=wrap[0];while(j--){tmp=tmp.lastChild}
jQuery.merge(nodes,tmp.childNodes);tmp=fragment.firstChild;tmp.textContent=""}}}
fragment.textContent="";i=0;while((elem=nodes[i++])){if(selection&&jQuery.inArray(elem,selection)>-1){if(ignored){ignored.push(elem)}
continue}
attached=isAttached(elem);tmp=getAll(fragment.appendChild(elem),"script");if(attached){setGlobalEval(tmp)}
if(scripts){j=0;while((elem=tmp[j++])){if(rscriptType.test(elem.type||"")){scripts.push(elem)}}}}
return fragment}
var rtypenamespace=/^([^.]*)(?:\.(.+)|)/;function returnTrue(){return!0}
function returnFalse(){return!1}
function on(elem,types,selector,data,fn,one){var origFn,type;if(typeof types==="object"){if(typeof selector!=="string"){data=data||selector;selector=undefined}
for(type in types){on(elem,type,selector,data,types[type],one)}
return elem}
if(data==null&&fn==null){fn=selector;data=selector=undefined}else if(fn==null){if(typeof selector==="string"){fn=data;data=undefined}else{fn=data;data=selector;selector=undefined}}
if(fn===!1){fn=returnFalse}else if(!fn){return elem}
if(one===1){origFn=fn;fn=function(event){jQuery().off(event);return origFn.apply(this,arguments)};fn.guid=origFn.guid||(origFn.guid=jQuery.guid++)}
return elem.each(function(){jQuery.event.add(this,types,fn,data,selector)})}
jQuery.event={global:{},add:function(elem,types,handler,data,selector){var handleObjIn,eventHandle,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.get(elem);if(!acceptData(elem)){return}
if(handler.handler){handleObjIn=handler;handler=handleObjIn.handler;selector=handleObjIn.selector}
if(selector){jQuery.find.matchesSelector(documentElement,selector)}
if(!handler.guid){handler.guid=jQuery.guid++}
if(!(events=elemData.events)){events=elemData.events=Object.create(null)}
if(!(eventHandle=elemData.handle)){eventHandle=elemData.handle=function(e){return typeof jQuery!=="undefined"&&jQuery.event.triggered!==e.type?jQuery.event.dispatch.apply(elem,arguments):undefined}}
types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){continue}
special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;special=jQuery.event.special[type]||{};handleObj=jQuery.extend({type:type,origType:origType,data:data,handler:handler,guid:handler.guid,selector:selector,needsContext:selector&&jQuery.expr.match.needsContext.test(selector),namespace:namespaces.join(".")},handleObjIn);if(!(handlers=events[type])){handlers=events[type]=[];handlers.delegateCount=0;if(!special.setup||special.setup.call(elem,data,namespaces,eventHandle)===!1){if(elem.addEventListener){elem.addEventListener(type,eventHandle)}}}
if(special.add){special.add.call(elem,handleObj);if(!handleObj.handler.guid){handleObj.handler.guid=handler.guid}}
if(selector){handlers.splice(handlers.delegateCount++,0,handleObj)}else{handlers.push(handleObj)}
jQuery.event.global[type]=!0}},remove:function(elem,types,handler,selector,mappedTypes){var j,origCount,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.hasData(elem)&&dataPriv.get(elem);if(!elemData||!(events=elemData.events)){return}
types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){for(type in events){jQuery.event.remove(elem,type+types[t],handler,selector,!0)}
continue}
special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;handlers=events[type]||[];tmp=tmp[2]&&new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)");origCount=j=handlers.length;while(j--){handleObj=handlers[j];if((mappedTypes||origType===handleObj.origType)&&(!handler||handler.guid===handleObj.guid)&&(!tmp||tmp.test(handleObj.namespace))&&(!selector||selector===handleObj.selector||selector==="**"&&handleObj.selector)){handlers.splice(j,1);if(handleObj.selector){handlers.delegateCount--}
if(special.remove){special.remove.call(elem,handleObj)}}}
if(origCount&&!handlers.length){if(!special.teardown||special.teardown.call(elem,namespaces,elemData.handle)===!1){jQuery.removeEvent(elem,type,elemData.handle)}
delete events[type]}}
if(jQuery.isEmptyObject(events)){dataPriv.remove(elem,"handle events")}},dispatch:function(nativeEvent){var i,j,ret,matched,handleObj,handlerQueue,args=new Array(arguments.length),event=jQuery.event.fix(nativeEvent),handlers=(dataPriv.get(this,"events")||Object.create(null))[event.type]||[],special=jQuery.event.special[event.type]||{};args[0]=event;for(i=1;i<arguments.length;i++){args[i]=arguments[i]}
event.delegateTarget=this;if(special.preDispatch&&special.preDispatch.call(this,event)===!1){return}
handlerQueue=jQuery.event.handlers.call(this,event,handlers);i=0;while((matched=handlerQueue[i++])&&!event.isPropagationStopped()){event.currentTarget=matched.elem;j=0;while((handleObj=matched.handlers[j++])&&!event.isImmediatePropagationStopped()){if(!event.rnamespace||handleObj.namespace===!1||event.rnamespace.test(handleObj.namespace)){event.handleObj=handleObj;event.data=handleObj.data;ret=((jQuery.event.special[handleObj.origType]||{}).handle||handleObj.handler).apply(matched.elem,args);if(ret!==undefined){if((event.result=ret)===!1){event.preventDefault();event.stopPropagation()}}}}}
if(special.postDispatch){special.postDispatch.call(this,event)}
return event.result},handlers:function(event,handlers){var i,handleObj,sel,matchedHandlers,matchedSelectors,handlerQueue=[],delegateCount=handlers.delegateCount,cur=event.target;if(delegateCount&&cur.nodeType&&!(event.type==="click"&&event.button>=1)){for(;cur!==this;cur=cur.parentNode||this){if(cur.nodeType===1&&!(event.type==="click"&&cur.disabled===!0)){matchedHandlers=[];matchedSelectors={};for(i=0;i<delegateCount;i++){handleObj=handlers[i];sel=handleObj.selector+" ";if(matchedSelectors[sel]===undefined){matchedSelectors[sel]=handleObj.needsContext?jQuery(sel,this).index(cur)>-1:jQuery.find(sel,this,null,[cur]).length}
if(matchedSelectors[sel]){matchedHandlers.push(handleObj)}}
if(matchedHandlers.length){handlerQueue.push({elem:cur,handlers:matchedHandlers})}}}}
cur=this;if(delegateCount<handlers.length){handlerQueue.push({elem:cur,handlers:handlers.slice(delegateCount)})}
return handlerQueue},addProp:function(name,hook){Object.defineProperty(jQuery.Event.prototype,name,{enumerable:!0,configurable:!0,get:isFunction(hook)?function(){if(this.originalEvent){return hook(this.originalEvent)}}:function(){if(this.originalEvent){return this.originalEvent[name]}},set:function(value){Object.defineProperty(this,name,{enumerable:!0,configurable:!0,writable:!0,value:value})}})},fix:function(originalEvent){return originalEvent[jQuery.expando]?originalEvent:new jQuery.Event(originalEvent)},special:{load:{noBubble:!0},click:{setup:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click",!0)}
return!1},trigger:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click")}
return!0},_default:function(event){var target=event.target;return rcheckableType.test(target.type)&&target.click&&nodeName(target,"input")&&dataPriv.get(target,"click")||nodeName(target,"a")}},beforeunload:{postDispatch:function(event){if(event.result!==undefined&&event.originalEvent){event.originalEvent.returnValue=event.result}}}}};function leverageNative(el,type,isSetup){if(!isSetup){if(dataPriv.get(el,type)===undefined){jQuery.event.add(el,type,returnTrue)}
return}
dataPriv.set(el,type,!1);jQuery.event.add(el,type,{namespace:!1,handler:function(event){var result,saved=dataPriv.get(this,type);if((event.isTrigger&1)&&this[type]){if(!saved){saved=slice.call(arguments);dataPriv.set(this,type,saved);this[type]();result=dataPriv.get(this,type);dataPriv.set(this,type,!1);if(saved!==result){event.stopImmediatePropagation();event.preventDefault();return result}}else if((jQuery.event.special[type]||{}).delegateType){event.stopPropagation()}}else if(saved){dataPriv.set(this,type,jQuery.event.trigger(saved[0],saved.slice(1),this));event.stopPropagation();event.isImmediatePropagationStopped=returnTrue}}})}
jQuery.removeEvent=function(elem,type,handle){if(elem.removeEventListener){elem.removeEventListener(type,handle)}};jQuery.Event=function(src,props){if(!(this instanceof jQuery.Event)){return new jQuery.Event(src,props)}
if(src&&src.type){this.originalEvent=src;this.type=src.type;this.isDefaultPrevented=src.defaultPrevented||src.defaultPrevented===undefined&&src.returnValue===!1?returnTrue:returnFalse;this.target=(src.target&&src.target.nodeType===3)?src.target.parentNode:src.target;this.currentTarget=src.currentTarget;this.relatedTarget=src.relatedTarget}else{this.type=src}
if(props){jQuery.extend(this,props)}
this.timeStamp=src&&src.timeStamp||Date.now();this[jQuery.expando]=!0};jQuery.Event.prototype={constructor:jQuery.Event,isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=returnTrue;if(e&&!this.isSimulated){e.preventDefault()}},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopPropagation()}},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopImmediatePropagation()}
this.stopPropagation()}};jQuery.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:!0},jQuery.event.addProp);jQuery.each({focus:"focusin",blur:"focusout"},function(type,delegateType){function focusMappedHandler(nativeEvent){if(document.documentMode){var handle=dataPriv.get(this,"handle"),event=jQuery.event.fix(nativeEvent);event.type=nativeEvent.type==="focusin"?"focus":"blur";event.isSimulated=!0;handle(nativeEvent);if(event.target===event.currentTarget){handle(event)}}else{jQuery.event.simulate(delegateType,nativeEvent.target,jQuery.event.fix(nativeEvent))}}
jQuery.event.special[type]={setup:function(){var attaches;leverageNative(this,type,!0);if(document.documentMode){attaches=dataPriv.get(this,delegateType);if(!attaches){this.addEventListener(delegateType,focusMappedHandler)}
dataPriv.set(this,delegateType,(attaches||0)+1)}else{return!1}},trigger:function(){leverageNative(this,type);return!0},teardown:function(){var attaches;if(document.documentMode){attaches=dataPriv.get(this,delegateType)-1;if(!attaches){this.removeEventListener(delegateType,focusMappedHandler);dataPriv.remove(this,delegateType)}else{dataPriv.set(this,delegateType,attaches)}}else{return!1}},_default:function(event){return dataPriv.get(event.target,type)},delegateType:delegateType};jQuery.event.special[delegateType]={setup:function(){var doc=this.ownerDocument||this.document||this,dataHolder=document.documentMode?this:doc,attaches=dataPriv.get(dataHolder,delegateType);if(!attaches){if(document.documentMode){this.addEventListener(delegateType,focusMappedHandler)}else{doc.addEventListener(type,focusMappedHandler,!0)}}
dataPriv.set(dataHolder,delegateType,(attaches||0)+1)},teardown:function(){var doc=this.ownerDocument||this.document||this,dataHolder=document.documentMode?this:doc,attaches=dataPriv.get(dataHolder,delegateType)-1;if(!attaches){if(document.documentMode){this.removeEventListener(delegateType,focusMappedHandler)}else{doc.removeEventListener(type,focusMappedHandler,!0)}
dataPriv.remove(dataHolder,delegateType)}else{dataPriv.set(dataHolder,delegateType,attaches)}}}});jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(orig,fix){jQuery.event.special[orig]={delegateType:fix,bindType:fix,handle:function(event){var ret,target=this,related=event.relatedTarget,handleObj=event.handleObj;if(!related||(related!==target&&!jQuery.contains(target,related))){event.type=handleObj.origType;ret=handleObj.handler.apply(this,arguments);event.type=fix}
return ret}}});jQuery.fn.extend({on:function(types,selector,data,fn){return on(this,types,selector,data,fn)},one:function(types,selector,data,fn){return on(this,types,selector,data,fn,1)},off:function(types,selector,fn){var handleObj,type;if(types&&types.preventDefault&&types.handleObj){handleObj=types.handleObj;jQuery(types.delegateTarget).off(handleObj.namespace?handleObj.origType+"."+handleObj.namespace:handleObj.origType,handleObj.selector,handleObj.handler);return this}
if(typeof types==="object"){for(type in types){this.off(type,selector,types[type])}
return this}
if(selector===!1||typeof selector==="function"){fn=selector;selector=undefined}
if(fn===!1){fn=returnFalse}
return this.each(function(){jQuery.event.remove(this,types,fn,selector)})}});var rnoInnerhtml=/<script|<style|<link/i,rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,rcleanScript=/^\s*<!\[CDATA\[|\]\]>\s*$/g;function manipulationTarget(elem,content){if(nodeName(elem,"table")&&nodeName(content.nodeType!==11?content:content.firstChild,"tr")){return jQuery(elem).children("tbody")[0]||elem}
return elem}
function disableScript(elem){elem.type=(elem.getAttribute("type")!==null)+"/"+elem.type;return elem}
function restoreScript(elem){if((elem.type||"").slice(0,5)==="true/"){elem.type=elem.type.slice(5)}else{elem.removeAttribute("type")}
return elem}
function cloneCopyEvent(src,dest){var i,l,type,pdataOld,udataOld,udataCur,events;if(dest.nodeType!==1){return}
if(dataPriv.hasData(src)){pdataOld=dataPriv.get(src);events=pdataOld.events;if(events){dataPriv.remove(dest,"handle events");for(type in events){for(i=0,l=events[type].length;i<l;i++){jQuery.event.add(dest,type,events[type][i])}}}}
if(dataUser.hasData(src)){udataOld=dataUser.access(src);udataCur=jQuery.extend({},udataOld);dataUser.set(dest,udataCur)}}
function fixInput(src,dest){var nodeName=dest.nodeName.toLowerCase();if(nodeName==="input"&&rcheckableType.test(src.type)){dest.checked=src.checked}else if(nodeName==="input"||nodeName==="textarea"){dest.defaultValue=src.defaultValue}}
function domManip(collection,args,callback,ignored){args=flat(args);var fragment,first,scripts,hasScripts,node,doc,i=0,l=collection.length,iNoClone=l-1,value=args[0],valueIsFunction=isFunction(value);if(valueIsFunction||(l>1&&typeof value==="string"&&!support.checkClone&&rchecked.test(value))){return collection.each(function(index){var self=collection.eq(index);if(valueIsFunction){args[0]=value.call(this,index,self.html())}
domManip(self,args,callback,ignored)})}
if(l){fragment=buildFragment(args,collection[0].ownerDocument,!1,collection,ignored);first=fragment.firstChild;if(fragment.childNodes.length===1){fragment=first}
if(first||ignored){scripts=jQuery.map(getAll(fragment,"script"),disableScript);hasScripts=scripts.length;for(;i<l;i++){node=fragment;if(i!==iNoClone){node=jQuery.clone(node,!0,!0);if(hasScripts){jQuery.merge(scripts,getAll(node,"script"))}}
callback.call(collection[i],node,i)}
if(hasScripts){doc=scripts[scripts.length-1].ownerDocument;jQuery.map(scripts,restoreScript);for(i=0;i<hasScripts;i++){node=scripts[i];if(rscriptType.test(node.type||"")&&!dataPriv.access(node,"globalEval")&&jQuery.contains(doc,node)){if(node.src&&(node.type||"").toLowerCase()!=="module"){if(jQuery._evalUrl&&!node.noModule){jQuery._evalUrl(node.src,{nonce:node.nonce||node.getAttribute("nonce")},doc)}}else{DOMEval(node.textContent.replace(rcleanScript,""),node,doc)}}}}}}
return collection}
function remove(elem,selector,keepData){var node,nodes=selector?jQuery.filter(selector,elem):elem,i=0;for(;(node=nodes[i])!=null;i++){if(!keepData&&node.nodeType===1){jQuery.cleanData(getAll(node))}
if(node.parentNode){if(keepData&&isAttached(node)){setGlobalEval(getAll(node,"script"))}
node.parentNode.removeChild(node)}}
return elem}
jQuery.extend({htmlPrefilter:function(html){return html},clone:function(elem,dataAndEvents,deepDataAndEvents){var i,l,srcElements,destElements,clone=elem.cloneNode(!0),inPage=isAttached(elem);if(!support.noCloneChecked&&(elem.nodeType===1||elem.nodeType===11)&&!jQuery.isXMLDoc(elem)){destElements=getAll(clone);srcElements=getAll(elem);for(i=0,l=srcElements.length;i<l;i++){fixInput(srcElements[i],destElements[i])}}
if(dataAndEvents){if(deepDataAndEvents){srcElements=srcElements||getAll(elem);destElements=destElements||getAll(clone);for(i=0,l=srcElements.length;i<l;i++){cloneCopyEvent(srcElements[i],destElements[i])}}else{cloneCopyEvent(elem,clone)}}
destElements=getAll(clone,"script");if(destElements.length>0){setGlobalEval(destElements,!inPage&&getAll(elem,"script"))}
return clone},cleanData:function(elems){var data,elem,type,special=jQuery.event.special,i=0;for(;(elem=elems[i])!==undefined;i++){if(acceptData(elem)){if((data=elem[dataPriv.expando])){if(data.events){for(type in data.events){if(special[type]){jQuery.event.remove(elem,type)}else{jQuery.removeEvent(elem,type,data.handle)}}}
elem[dataPriv.expando]=undefined}
if(elem[dataUser.expando]){elem[dataUser.expando]=undefined}}}}});jQuery.fn.extend({detach:function(selector){return remove(this,selector,!0)},remove:function(selector){return remove(this,selector)},text:function(value){return access(this,function(value){return value===undefined?jQuery.text(this):this.empty().each(function(){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){this.textContent=value}})},null,value,arguments.length)},append:function(){return domManip(this,arguments,function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.appendChild(elem)}})},prepend:function(){return domManip(this,arguments,function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.insertBefore(elem,target.firstChild)}})},before:function(){return domManip(this,arguments,function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this)}})},after:function(){return domManip(this,arguments,function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this.nextSibling)}})},empty:function(){var elem,i=0;for(;(elem=this[i])!=null;i++){if(elem.nodeType===1){jQuery.cleanData(getAll(elem,!1));elem.textContent=""}}
return this},clone:function(dataAndEvents,deepDataAndEvents){dataAndEvents=dataAndEvents==null?!1:dataAndEvents;deepDataAndEvents=deepDataAndEvents==null?dataAndEvents:deepDataAndEvents;return this.map(function(){return jQuery.clone(this,dataAndEvents,deepDataAndEvents)})},html:function(value){return access(this,function(value){var elem=this[0]||{},i=0,l=this.length;if(value===undefined&&elem.nodeType===1){return elem.innerHTML}
if(typeof value==="string"&&!rnoInnerhtml.test(value)&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=jQuery.htmlPrefilter(value);try{for(;i<l;i++){elem=this[i]||{};if(elem.nodeType===1){jQuery.cleanData(getAll(elem,!1));elem.innerHTML=value}}
elem=0}catch(e){}}
if(elem){this.empty().append(value)}},null,value,arguments.length)},replaceWith:function(){var ignored=[];return domManip(this,arguments,function(elem){var parent=this.parentNode;if(jQuery.inArray(this,ignored)<0){jQuery.cleanData(getAll(this));if(parent){parent.replaceChild(elem,this)}}},ignored)}});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(selector){var elems,ret=[],insert=jQuery(selector),last=insert.length-1,i=0;for(;i<=last;i++){elems=i===last?this:this.clone(!0);jQuery(insert[i])[original](elems);push.apply(ret,elems.get())}
return this.pushStack(ret)}});var rnumnonpx=new RegExp("^("+pnum+")(?!px)[a-z%]+$","i");var rcustomProp=/^--/;var getStyles=function(elem){var view=elem.ownerDocument.defaultView;if(!view||!view.opener){view=window}
return view.getComputedStyle(elem)};var swap=function(elem,options,callback){var ret,name,old={};for(name in options){old[name]=elem.style[name];elem.style[name]=options[name]}
ret=callback.call(elem);for(name in options){elem.style[name]=old[name]}
return ret};var rboxStyle=new RegExp(cssExpand.join("|"),"i");(function(){function computeStyleTests(){if(!div){return}
container.style.cssText="position:absolute;left:-11111px;width:60px;"+"margin-top:1px;padding:0;border:0";div.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;"+"margin:auto;border:1px;padding:1px;"+"width:60%;top:1%";documentElement.appendChild(container).appendChild(div);var divStyle=window.getComputedStyle(div);pixelPositionVal=divStyle.top!=="1%";reliableMarginLeftVal=roundPixelMeasures(divStyle.marginLeft)===12;div.style.right="60%";pixelBoxStylesVal=roundPixelMeasures(divStyle.right)===36;boxSizingReliableVal=roundPixelMeasures(divStyle.width)===36;div.style.position="absolute";scrollboxSizeVal=roundPixelMeasures(div.offsetWidth/3)===12;documentElement.removeChild(container);div=null}
function roundPixelMeasures(measure){return Math.round(parseFloat(measure))}
var pixelPositionVal,boxSizingReliableVal,scrollboxSizeVal,pixelBoxStylesVal,reliableTrDimensionsVal,reliableMarginLeftVal,container=document.createElement("div"),div=document.createElement("div");if(!div.style){return}
div.style.backgroundClip="content-box";div.cloneNode(!0).style.backgroundClip="";support.clearCloneStyle=div.style.backgroundClip==="content-box";jQuery.extend(support,{boxSizingReliable:function(){computeStyleTests();return boxSizingReliableVal},pixelBoxStyles:function(){computeStyleTests();return pixelBoxStylesVal},pixelPosition:function(){computeStyleTests();return pixelPositionVal},reliableMarginLeft:function(){computeStyleTests();return reliableMarginLeftVal},scrollboxSize:function(){computeStyleTests();return scrollboxSizeVal},reliableTrDimensions:function(){var table,tr,trChild,trStyle;if(reliableTrDimensionsVal==null){table=document.createElement("table");tr=document.createElement("tr");trChild=document.createElement("div");table.style.cssText="position:absolute;left:-11111px;border-collapse:separate";tr.style.cssText="box-sizing:content-box;border:1px solid";tr.style.height="1px";trChild.style.height="9px";trChild.style.display="block";documentElement.appendChild(table).appendChild(tr).appendChild(trChild);trStyle=window.getComputedStyle(tr);reliableTrDimensionsVal=(parseInt(trStyle.height,10)+parseInt(trStyle.borderTopWidth,10)+parseInt(trStyle.borderBottomWidth,10))===tr.offsetHeight;documentElement.removeChild(table)}
return reliableTrDimensionsVal}})})();function curCSS(elem,name,computed){var width,minWidth,maxWidth,ret,isCustomProp=rcustomProp.test(name),style=elem.style;computed=computed||getStyles(elem);if(computed){ret=computed.getPropertyValue(name)||computed[name];if(isCustomProp&&ret){ret=ret.replace(rtrimCSS,"$1")||undefined}
if(ret===""&&!isAttached(elem)){ret=jQuery.style(elem,name)}
if(!support.pixelBoxStyles()&&rnumnonpx.test(ret)&&rboxStyle.test(name)){width=style.width;minWidth=style.minWidth;maxWidth=style.maxWidth;style.minWidth=style.maxWidth=style.width=ret;ret=computed.width;style.width=width;style.minWidth=minWidth;style.maxWidth=maxWidth}}
return ret!==undefined?ret+"":ret}
function addGetHookIf(conditionFn,hookFn){return{get:function(){if(conditionFn()){delete this.get;return}
return(this.get=hookFn).apply(this,arguments)}}}
var cssPrefixes=["Webkit","Moz","ms"],emptyStyle=document.createElement("div").style,vendorProps={};function vendorPropName(name){var capName=name[0].toUpperCase()+name.slice(1),i=cssPrefixes.length;while(i--){name=cssPrefixes[i]+capName;if(name in emptyStyle){return name}}}
function finalPropName(name){var final=jQuery.cssProps[name]||vendorProps[name];if(final){return final}
if(name in emptyStyle){return name}
return vendorProps[name]=vendorPropName(name)||name}
var rdisplayswap=/^(none|table(?!-c[ea]).+)/,cssShow={position:"absolute",visibility:"hidden",display:"block"},cssNormalTransform={letterSpacing:"0",fontWeight:"400"};function setPositiveNumber(_elem,value,subtract){var matches=rcssNum.exec(value);return matches?Math.max(0,matches[2]-(subtract||0))+(matches[3]||"px"):value}
function boxModelAdjustment(elem,dimension,box,isBorderBox,styles,computedVal){var i=dimension==="width"?1:0,extra=0,delta=0,marginDelta=0;if(box===(isBorderBox?"border":"content")){return 0}
for(;i<4;i+=2){if(box==="margin"){marginDelta+=jQuery.css(elem,box+cssExpand[i],!0,styles)}
if(!isBorderBox){delta+=jQuery.css(elem,"padding"+cssExpand[i],!0,styles);if(box!=="padding"){delta+=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles)}else{extra+=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles)}}else{if(box==="content"){delta-=jQuery.css(elem,"padding"+cssExpand[i],!0,styles)}
if(box!=="margin"){delta-=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles)}}}
if(!isBorderBox&&computedVal>=0){delta+=Math.max(0,Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-computedVal-delta-extra-0.5))||0}
return delta+marginDelta}
function getWidthOrHeight(elem,dimension,extra){var styles=getStyles(elem),boxSizingNeeded=!support.boxSizingReliable()||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",!1,styles)==="border-box",valueIsBorderBox=isBorderBox,val=curCSS(elem,dimension,styles),offsetProp="offset"+dimension[0].toUpperCase()+dimension.slice(1);if(rnumnonpx.test(val)){if(!extra){return val}
val="auto"}
if((!support.boxSizingReliable()&&isBorderBox||!support.reliableTrDimensions()&&nodeName(elem,"tr")||val==="auto"||!parseFloat(val)&&jQuery.css(elem,"display",!1,styles)==="inline")&&elem.getClientRects().length){isBorderBox=jQuery.css(elem,"boxSizing",!1,styles)==="border-box";valueIsBorderBox=offsetProp in elem;if(valueIsBorderBox){val=elem[offsetProp]}}
val=parseFloat(val)||0;return(val+boxModelAdjustment(elem,dimension,extra||(isBorderBox?"border":"content"),valueIsBorderBox,styles,val))+"px"}
jQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity");return ret===""?"1":ret}}}},cssNumber:{animationIterationCount:!0,aspectRatio:!0,borderImageSlice:!0,columnCount:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,scale:!0,widows:!0,zIndex:!0,zoom:!0,fillOpacity:!0,floodOpacity:!0,stopOpacity:!0,strokeMiterlimit:!0,strokeOpacity:!0},cssProps:{},style:function(elem,name,value,extra){if(!elem||elem.nodeType===3||elem.nodeType===8||!elem.style){return}
var ret,type,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name),style=elem.style;if(!isCustomProp){name=finalPropName(origName)}
hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(value!==undefined){type=typeof value;if(type==="string"&&(ret=rcssNum.exec(value))&&ret[1]){value=adjustCSS(elem,name,ret);type="number"}
if(value==null||value!==value){return}
if(type==="number"&&!isCustomProp){value+=ret&&ret[3]||(jQuery.cssNumber[origName]?"":"px")}
if(!support.clearCloneStyle&&value===""&&name.indexOf("background")===0){style[name]="inherit"}
if(!hooks||!("set" in hooks)||(value=hooks.set(elem,value,extra))!==undefined){if(isCustomProp){style.setProperty(name,value)}else{style[name]=value}}}else{if(hooks&&"get" in hooks&&(ret=hooks.get(elem,!1,extra))!==undefined){return ret}
return style[name]}},css:function(elem,name,extra,styles){var val,num,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name);if(!isCustomProp){name=finalPropName(origName)}
hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(hooks&&"get" in hooks){val=hooks.get(elem,!0,extra)}
if(val===undefined){val=curCSS(elem,name,styles)}
if(val==="normal"&&name in cssNormalTransform){val=cssNormalTransform[name]}
if(extra===""||extra){num=parseFloat(val);return extra===!0||isFinite(num)?num||0:val}
return val}});jQuery.each(["height","width"],function(_i,dimension){jQuery.cssHooks[dimension]={get:function(elem,computed,extra){if(computed){return rdisplayswap.test(jQuery.css(elem,"display"))&&(!elem.getClientRects().length||!elem.getBoundingClientRect().width)?swap(elem,cssShow,function(){return getWidthOrHeight(elem,dimension,extra)}):getWidthOrHeight(elem,dimension,extra)}},set:function(elem,value,extra){var matches,styles=getStyles(elem),scrollboxSizeBuggy=!support.scrollboxSize()&&styles.position==="absolute",boxSizingNeeded=scrollboxSizeBuggy||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",!1,styles)==="border-box",subtract=extra?boxModelAdjustment(elem,dimension,extra,isBorderBox,styles):0;if(isBorderBox&&scrollboxSizeBuggy){subtract-=Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-parseFloat(styles[dimension])-boxModelAdjustment(elem,dimension,"border",!1,styles)-0.5)}
if(subtract&&(matches=rcssNum.exec(value))&&(matches[3]||"px")!=="px"){elem.style[dimension]=value;value=jQuery.css(elem,dimension)}
return setPositiveNumber(elem,value,subtract)}}});jQuery.cssHooks.marginLeft=addGetHookIf(support.reliableMarginLeft,function(elem,computed){if(computed){return(parseFloat(curCSS(elem,"marginLeft"))||elem.getBoundingClientRect().left-swap(elem,{marginLeft:0},function(){return elem.getBoundingClientRect().left}))+"px"}});jQuery.each({margin:"",padding:"",border:"Width"},function(prefix,suffix){jQuery.cssHooks[prefix+suffix]={expand:function(value){var i=0,expanded={},parts=typeof value==="string"?value.split(" "):[value];for(;i<4;i++){expanded[prefix+cssExpand[i]+suffix]=parts[i]||parts[i-2]||parts[0]}
return expanded}};if(prefix!=="margin"){jQuery.cssHooks[prefix+suffix].set=setPositiveNumber}});jQuery.fn.extend({css:function(name,value){return access(this,function(elem,name,value){var styles,len,map={},i=0;if(Array.isArray(name)){styles=getStyles(elem);len=name.length;for(;i<len;i++){map[name[i]]=jQuery.css(elem,name[i],!1,styles)}
return map}
return value!==undefined?jQuery.style(elem,name,value):jQuery.css(elem,name)},name,value,arguments.length>1)}});function Tween(elem,options,prop,end,easing){return new Tween.prototype.init(elem,options,prop,end,easing)}
jQuery.Tween=Tween;Tween.prototype={constructor:Tween,init:function(elem,options,prop,end,easing,unit){this.elem=elem;this.prop=prop;this.easing=easing||jQuery.easing._default;this.options=options;this.start=this.now=this.cur();this.end=end;this.unit=unit||(jQuery.cssNumber[prop]?"":"px")},cur:function(){var hooks=Tween.propHooks[this.prop];return hooks&&hooks.get?hooks.get(this):Tween.propHooks._default.get(this)},run:function(percent){var eased,hooks=Tween.propHooks[this.prop];if(this.options.duration){this.pos=eased=jQuery.easing[this.easing](percent,this.options.duration*percent,0,1,this.options.duration)}else{this.pos=eased=percent}
this.now=(this.end-this.start)*eased+this.start;if(this.options.step){this.options.step.call(this.elem,this.now,this)}
if(hooks&&hooks.set){hooks.set(this)}else{Tween.propHooks._default.set(this)}
return this}};Tween.prototype.init.prototype=Tween.prototype;Tween.propHooks={_default:{get:function(tween){var result;if(tween.elem.nodeType!==1||tween.elem[tween.prop]!=null&&tween.elem.style[tween.prop]==null){return tween.elem[tween.prop]}
result=jQuery.css(tween.elem,tween.prop,"");return!result||result==="auto"?0:result},set:function(tween){if(jQuery.fx.step[tween.prop]){jQuery.fx.step[tween.prop](tween)}else if(tween.elem.nodeType===1&&(jQuery.cssHooks[tween.prop]||tween.elem.style[finalPropName(tween.prop)]!=null)){jQuery.style(tween.elem,tween.prop,tween.now+tween.unit)}else{tween.elem[tween.prop]=tween.now}}}};Tween.propHooks.scrollTop=Tween.propHooks.scrollLeft={set:function(tween){if(tween.elem.nodeType&&tween.elem.parentNode){tween.elem[tween.prop]=tween.now}}};jQuery.easing={linear:function(p){return p},swing:function(p){return 0.5-Math.cos(p*Math.PI)/2},_default:"swing"};jQuery.fx=Tween.prototype.init;jQuery.fx.step={};var fxNow,inProgress,rfxtypes=/^(?:toggle|show|hide)$/,rrun=/queueHooks$/;function schedule(){if(inProgress){if(document.hidden===!1&&window.requestAnimationFrame){window.requestAnimationFrame(schedule)}else{window.setTimeout(schedule,jQuery.fx.interval)}
jQuery.fx.tick()}}
function createFxNow(){window.setTimeout(function(){fxNow=undefined});return(fxNow=Date.now())}
function genFx(type,includeWidth){var which,i=0,attrs={height:type};includeWidth=includeWidth?1:0;for(;i<4;i+=2-includeWidth){which=cssExpand[i];attrs["margin"+which]=attrs["padding"+which]=type}
if(includeWidth){attrs.opacity=attrs.width=type}
return attrs}
function createTween(value,prop,animation){var tween,collection=(Animation.tweeners[prop]||[]).concat(Animation.tweeners["*"]),index=0,length=collection.length;for(;index<length;index++){if((tween=collection[index].call(animation,prop,value))){return tween}}}
function defaultPrefilter(elem,props,opts){var prop,value,toggle,hooks,oldfire,propTween,restoreDisplay,display,isBox="width" in props||"height" in props,anim=this,orig={},style=elem.style,hidden=elem.nodeType&&isHiddenWithinTree(elem),dataShow=dataPriv.get(elem,"fxshow");if(!opts.queue){hooks=jQuery._queueHooks(elem,"fx");if(hooks.unqueued==null){hooks.unqueued=0;oldfire=hooks.empty.fire;hooks.empty.fire=function(){if(!hooks.unqueued){oldfire()}}}
hooks.unqueued++;anim.always(function(){anim.always(function(){hooks.unqueued--;if(!jQuery.queue(elem,"fx").length){hooks.empty.fire()}})})}
for(prop in props){value=props[prop];if(rfxtypes.test(value)){delete props[prop];toggle=toggle||value==="toggle";if(value===(hidden?"hide":"show")){if(value==="show"&&dataShow&&dataShow[prop]!==undefined){hidden=!0}else{continue}}
orig[prop]=dataShow&&dataShow[prop]||jQuery.style(elem,prop)}}
propTween=!jQuery.isEmptyObject(props);if(!propTween&&jQuery.isEmptyObject(orig)){return}
if(isBox&&elem.nodeType===1){opts.overflow=[style.overflow,style.overflowX,style.overflowY];restoreDisplay=dataShow&&dataShow.display;if(restoreDisplay==null){restoreDisplay=dataPriv.get(elem,"display")}
display=jQuery.css(elem,"display");if(display==="none"){if(restoreDisplay){display=restoreDisplay}else{showHide([elem],!0);restoreDisplay=elem.style.display||restoreDisplay;display=jQuery.css(elem,"display");showHide([elem])}}
if(display==="inline"||display==="inline-block"&&restoreDisplay!=null){if(jQuery.css(elem,"float")==="none"){if(!propTween){anim.done(function(){style.display=restoreDisplay});if(restoreDisplay==null){display=style.display;restoreDisplay=display==="none"?"":display}}
style.display="inline-block"}}}
if(opts.overflow){style.overflow="hidden";anim.always(function(){style.overflow=opts.overflow[0];style.overflowX=opts.overflow[1];style.overflowY=opts.overflow[2]})}
propTween=!1;for(prop in orig){if(!propTween){if(dataShow){if("hidden" in dataShow){hidden=dataShow.hidden}}else{dataShow=dataPriv.access(elem,"fxshow",{display:restoreDisplay})}
if(toggle){dataShow.hidden=!hidden}
if(hidden){showHide([elem],!0)}
anim.done(function(){if(!hidden){showHide([elem])}
dataPriv.remove(elem,"fxshow");for(prop in orig){jQuery.style(elem,prop,orig[prop])}})}
propTween=createTween(hidden?dataShow[prop]:0,prop,anim);if(!(prop in dataShow)){dataShow[prop]=propTween.start;if(hidden){propTween.end=propTween.start;propTween.start=0}}}}
function propFilter(props,specialEasing){var index,name,easing,value,hooks;for(index in props){name=camelCase(index);easing=specialEasing[name];value=props[index];if(Array.isArray(value)){easing=value[1];value=props[index]=value[0]}
if(index!==name){props[name]=value;delete props[index]}
hooks=jQuery.cssHooks[name];if(hooks&&"expand" in hooks){value=hooks.expand(value);delete props[name];for(index in value){if(!(index in props)){props[index]=value[index];specialEasing[index]=easing}}}else{specialEasing[name]=easing}}}
function Animation(elem,properties,options){var result,stopped,index=0,length=Animation.prefilters.length,deferred=jQuery.Deferred().always(function(){delete tick.elem}),tick=function(){if(stopped){return!1}
var currentTime=fxNow||createFxNow(),remaining=Math.max(0,animation.startTime+animation.duration-currentTime),temp=remaining/animation.duration||0,percent=1-temp,index=0,length=animation.tweens.length;for(;index<length;index++){animation.tweens[index].run(percent)}
deferred.notifyWith(elem,[animation,percent,remaining]);if(percent<1&&length){return remaining}
if(!length){deferred.notifyWith(elem,[animation,1,0])}
deferred.resolveWith(elem,[animation]);return!1},animation=deferred.promise({elem:elem,props:jQuery.extend({},properties),opts:jQuery.extend(!0,{specialEasing:{},easing:jQuery.easing._default},options),originalProperties:properties,originalOptions:options,startTime:fxNow||createFxNow(),duration:options.duration,tweens:[],createTween:function(prop,end){var tween=jQuery.Tween(elem,animation.opts,prop,end,animation.opts.specialEasing[prop]||animation.opts.easing);animation.tweens.push(tween);return tween},stop:function(gotoEnd){var index=0,length=gotoEnd?animation.tweens.length:0;if(stopped){return this}
stopped=!0;for(;index<length;index++){animation.tweens[index].run(1)}
if(gotoEnd){deferred.notifyWith(elem,[animation,1,0]);deferred.resolveWith(elem,[animation,gotoEnd])}else{deferred.rejectWith(elem,[animation,gotoEnd])}
return this}}),props=animation.props;propFilter(props,animation.opts.specialEasing);for(;index<length;index++){result=Animation.prefilters[index].call(animation,elem,props,animation.opts);if(result){if(isFunction(result.stop)){jQuery._queueHooks(animation.elem,animation.opts.queue).stop=result.stop.bind(result)}
return result}}
jQuery.map(props,createTween,animation);if(isFunction(animation.opts.start)){animation.opts.start.call(elem,animation)}
animation.progress(animation.opts.progress).done(animation.opts.done,animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always);jQuery.fx.timer(jQuery.extend(tick,{elem:elem,anim:animation,queue:animation.opts.queue}));return animation}
jQuery.Animation=jQuery.extend(Animation,{tweeners:{"*":[function(prop,value){var tween=this.createTween(prop,value);adjustCSS(tween.elem,prop,rcssNum.exec(value),tween);return tween}]},tweener:function(props,callback){if(isFunction(props)){callback=props;props=["*"]}else{props=props.match(rnothtmlwhite)}
var prop,index=0,length=props.length;for(;index<length;index++){prop=props[index];Animation.tweeners[prop]=Animation.tweeners[prop]||[];Animation.tweeners[prop].unshift(callback)}},prefilters:[defaultPrefilter],prefilter:function(callback,prepend){if(prepend){Animation.prefilters.unshift(callback)}else{Animation.prefilters.push(callback)}}});jQuery.speed=function(speed,easing,fn){var opt=speed&&typeof speed==="object"?jQuery.extend({},speed):{complete:fn||!fn&&easing||isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!isFunction(easing)&&easing};if(jQuery.fx.off){opt.duration=0}else{if(typeof opt.duration!=="number"){if(opt.duration in jQuery.fx.speeds){opt.duration=jQuery.fx.speeds[opt.duration]}else{opt.duration=jQuery.fx.speeds._default}}}
if(opt.queue==null||opt.queue===!0){opt.queue="fx"}
opt.old=opt.complete;opt.complete=function(){if(isFunction(opt.old)){opt.old.call(this)}
if(opt.queue){jQuery.dequeue(this,opt.queue)}};return opt};jQuery.fn.extend({fadeTo:function(speed,to,easing,callback){return this.filter(isHiddenWithinTree).css("opacity",0).show().end().animate({opacity:to},speed,easing,callback)},animate:function(prop,speed,easing,callback){var empty=jQuery.isEmptyObject(prop),optall=jQuery.speed(speed,easing,callback),doAnimation=function(){var anim=Animation(this,jQuery.extend({},prop),optall);if(empty||dataPriv.get(this,"finish")){anim.stop(!0)}};doAnimation.finish=doAnimation;return empty||optall.queue===!1?this.each(doAnimation):this.queue(optall.queue,doAnimation)},stop:function(type,clearQueue,gotoEnd){var stopQueue=function(hooks){var stop=hooks.stop;delete hooks.stop;stop(gotoEnd)};if(typeof type!=="string"){gotoEnd=clearQueue;clearQueue=type;type=undefined}
if(clearQueue){this.queue(type||"fx",[])}
return this.each(function(){var dequeue=!0,index=type!=null&&type+"queueHooks",timers=jQuery.timers,data=dataPriv.get(this);if(index){if(data[index]&&data[index].stop){stopQueue(data[index])}}else{for(index in data){if(data[index]&&data[index].stop&&rrun.test(index)){stopQueue(data[index])}}}
for(index=timers.length;index--;){if(timers[index].elem===this&&(type==null||timers[index].queue===type)){timers[index].anim.stop(gotoEnd);dequeue=!1;timers.splice(index,1)}}
if(dequeue||!gotoEnd){jQuery.dequeue(this,type)}})},finish:function(type){if(type!==!1){type=type||"fx"}
return this.each(function(){var index,data=dataPriv.get(this),queue=data[type+"queue"],hooks=data[type+"queueHooks"],timers=jQuery.timers,length=queue?queue.length:0;data.finish=!0;jQuery.queue(this,type,[]);if(hooks&&hooks.stop){hooks.stop.call(this,!0)}
for(index=timers.length;index--;){if(timers[index].elem===this&&timers[index].queue===type){timers[index].anim.stop(!0);timers.splice(index,1)}}
for(index=0;index<length;index++){if(queue[index]&&queue[index].finish){queue[index].finish.call(this)}}
delete data.finish})}});jQuery.each(["toggle","show","hide"],function(_i,name){var cssFn=jQuery.fn[name];jQuery.fn[name]=function(speed,easing,callback){return speed==null||typeof speed==="boolean"?cssFn.apply(this,arguments):this.animate(genFx(name,!0),speed,easing,callback)}});jQuery.each({slideDown:genFx("show"),slideUp:genFx("hide"),slideToggle:genFx("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(name,props){jQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback)}});jQuery.timers=[];jQuery.fx.tick=function(){var timer,i=0,timers=jQuery.timers;fxNow=Date.now();for(;i<timers.length;i++){timer=timers[i];if(!timer()&&timers[i]===timer){timers.splice(i--,1)}}
if(!timers.length){jQuery.fx.stop()}
fxNow=undefined};jQuery.fx.timer=function(timer){jQuery.timers.push(timer);jQuery.fx.start()};jQuery.fx.interval=13;jQuery.fx.start=function(){if(inProgress){return}
inProgress=!0;schedule()};jQuery.fx.stop=function(){inProgress=null};jQuery.fx.speeds={slow:600,fast:200,_default:400};jQuery.fn.delay=function(time,type){time=jQuery.fx?jQuery.fx.speeds[time]||time:time;type=type||"fx";return this.queue(type,function(next,hooks){var timeout=window.setTimeout(next,time);hooks.stop=function(){window.clearTimeout(timeout)}})};(function(){var input=document.createElement("input"),select=document.createElement("select"),opt=select.appendChild(document.createElement("option"));input.type="checkbox";support.checkOn=input.value!=="";support.optSelected=opt.selected;input=document.createElement("input");input.value="t";input.type="radio";support.radioValue=input.value==="t"})();var boolHook,attrHandle=jQuery.expr.attrHandle;jQuery.fn.extend({attr:function(name,value){return access(this,jQuery.attr,name,value,arguments.length>1)},removeAttr:function(name){return this.each(function(){jQuery.removeAttr(this,name)})}});jQuery.extend({attr:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return}
if(typeof elem.getAttribute==="undefined"){return jQuery.prop(elem,name,value)}
if(nType!==1||!jQuery.isXMLDoc(elem)){hooks=jQuery.attrHooks[name.toLowerCase()]||(jQuery.expr.match.bool.test(name)?boolHook:undefined)}
if(value!==undefined){if(value===null){jQuery.removeAttr(elem,name);return}
if(hooks&&"set" in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret}
elem.setAttribute(name,value+"");return value}
if(hooks&&"get" in hooks&&(ret=hooks.get(elem,name))!==null){return ret}
ret=jQuery.find.attr(elem,name);return ret==null?undefined:ret},attrHooks:{type:{set:function(elem,value){if(!support.radioValue&&value==="radio"&&nodeName(elem,"input")){var val=elem.value;elem.setAttribute("type",value);if(val){elem.value=val}
return value}}}},removeAttr:function(elem,value){var name,i=0,attrNames=value&&value.match(rnothtmlwhite);if(attrNames&&elem.nodeType===1){while((name=attrNames[i++])){elem.removeAttribute(name)}}}});boolHook={set:function(elem,value,name){if(value===!1){jQuery.removeAttr(elem,name)}else{elem.setAttribute(name,name)}
return name}};jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g),function(_i,name){var getter=attrHandle[name]||jQuery.find.attr;attrHandle[name]=function(elem,name,isXML){var ret,handle,lowercaseName=name.toLowerCase();if(!isXML){handle=attrHandle[lowercaseName];attrHandle[lowercaseName]=ret;ret=getter(elem,name,isXML)!=null?lowercaseName:null;attrHandle[lowercaseName]=handle}
return ret}});var rfocusable=/^(?:input|select|textarea|button)$/i,rclickable=/^(?:a|area)$/i;jQuery.fn.extend({prop:function(name,value){return access(this,jQuery.prop,name,value,arguments.length>1)},removeProp:function(name){return this.each(function(){delete this[jQuery.propFix[name]||name]})}});jQuery.extend({prop:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return}
if(nType!==1||!jQuery.isXMLDoc(elem)){name=jQuery.propFix[name]||name;hooks=jQuery.propHooks[name]}
if(value!==undefined){if(hooks&&"set" in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret}
return(elem[name]=value)}
if(hooks&&"get" in hooks&&(ret=hooks.get(elem,name))!==null){return ret}
return elem[name]},propHooks:{tabIndex:{get:function(elem){var tabindex=jQuery.find.attr(elem,"tabindex");if(tabindex){return parseInt(tabindex,10)}
if(rfocusable.test(elem.nodeName)||rclickable.test(elem.nodeName)&&elem.href){return 0}
return-1}}},propFix:{"for":"htmlFor","class":"className"}});if(!support.optSelected){jQuery.propHooks.selected={get:function(elem){var parent=elem.parentNode;if(parent&&parent.parentNode){parent.parentNode.selectedIndex}
return null},set:function(elem){var parent=elem.parentNode;if(parent){parent.selectedIndex;if(parent.parentNode){parent.parentNode.selectedIndex}}}}}
jQuery.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){jQuery.propFix[this.toLowerCase()]=this});function stripAndCollapse(value){var tokens=value.match(rnothtmlwhite)||[];return tokens.join(" ")}
function getClass(elem){return elem.getAttribute&&elem.getAttribute("class")||""}
function classesToArray(value){if(Array.isArray(value)){return value}
if(typeof value==="string"){return value.match(rnothtmlwhite)||[]}
return[]}
jQuery.fn.extend({addClass:function(value){var classNames,cur,curValue,className,i,finalValue;if(isFunction(value)){return this.each(function(j){jQuery(this).addClass(value.call(this,j,getClass(this)))})}
classNames=classesToArray(value);if(classNames.length){return this.each(function(){curValue=getClass(this);cur=this.nodeType===1&&(" "+stripAndCollapse(curValue)+" ");if(cur){for(i=0;i<classNames.length;i++){className=classNames[i];if(cur.indexOf(" "+className+" ")<0){cur+=className+" "}}
finalValue=stripAndCollapse(cur);if(curValue!==finalValue){this.setAttribute("class",finalValue)}}})}
return this},removeClass:function(value){var classNames,cur,curValue,className,i,finalValue;if(isFunction(value)){return this.each(function(j){jQuery(this).removeClass(value.call(this,j,getClass(this)))})}
if(!arguments.length){return this.attr("class","")}
classNames=classesToArray(value);if(classNames.length){return this.each(function(){curValue=getClass(this);cur=this.nodeType===1&&(" "+stripAndCollapse(curValue)+" ");if(cur){for(i=0;i<classNames.length;i++){className=classNames[i];while(cur.indexOf(" "+className+" ")>-1){cur=cur.replace(" "+className+" "," ")}}
finalValue=stripAndCollapse(cur);if(curValue!==finalValue){this.setAttribute("class",finalValue)}}})}
return this},toggleClass:function(value,stateVal){var classNames,className,i,self,type=typeof value,isValidValue=type==="string"||Array.isArray(value);if(isFunction(value)){return this.each(function(i){jQuery(this).toggleClass(value.call(this,i,getClass(this),stateVal),stateVal)})}
if(typeof stateVal==="boolean"&&isValidValue){return stateVal?this.addClass(value):this.removeClass(value)}
classNames=classesToArray(value);return this.each(function(){if(isValidValue){self=jQuery(this);for(i=0;i<classNames.length;i++){className=classNames[i];if(self.hasClass(className)){self.removeClass(className)}else{self.addClass(className)}}}else if(value===undefined||type==="boolean"){className=getClass(this);if(className){dataPriv.set(this,"__className__",className)}
if(this.setAttribute){this.setAttribute("class",className||value===!1?"":dataPriv.get(this,"__className__")||"")}}})},hasClass:function(selector){var className,elem,i=0;className=" "+selector+" ";while((elem=this[i++])){if(elem.nodeType===1&&(" "+stripAndCollapse(getClass(elem))+" ").indexOf(className)>-1){return!0}}
return!1}});var rreturn=/\r/g;jQuery.fn.extend({val:function(value){var hooks,ret,valueIsFunction,elem=this[0];if(!arguments.length){if(elem){hooks=jQuery.valHooks[elem.type]||jQuery.valHooks[elem.nodeName.toLowerCase()];if(hooks&&"get" in hooks&&(ret=hooks.get(elem,"value"))!==undefined){return ret}
ret=elem.value;if(typeof ret==="string"){return ret.replace(rreturn,"")}
return ret==null?"":ret}
return}
valueIsFunction=isFunction(value);return this.each(function(i){var val;if(this.nodeType!==1){return}
if(valueIsFunction){val=value.call(this,i,jQuery(this).val())}else{val=value}
if(val==null){val=""}else if(typeof val==="number"){val+=""}else if(Array.isArray(val)){val=jQuery.map(val,function(value){return value==null?"":value+""})}
hooks=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()];if(!hooks||!("set" in hooks)||hooks.set(this,val,"value")===undefined){this.value=val}})}});jQuery.extend({valHooks:{option:{get:function(elem){var val=jQuery.find.attr(elem,"value");return val!=null?val:stripAndCollapse(jQuery.text(elem))}},select:{get:function(elem){var value,option,i,options=elem.options,index=elem.selectedIndex,one=elem.type==="select-one",values=one?null:[],max=one?index+1:options.length;if(index<0){i=max}else{i=one?index:0}
for(;i<max;i++){option=options[i];if((option.selected||i===index)&&!option.disabled&&(!option.parentNode.disabled||!nodeName(option.parentNode,"optgroup"))){value=jQuery(option).val();if(one){return value}
values.push(value)}}
return values},set:function(elem,value){var optionSet,option,options=elem.options,values=jQuery.makeArray(value),i=options.length;while(i--){option=options[i];if(option.selected=jQuery.inArray(jQuery.valHooks.option.get(option),values)>-1){optionSet=!0}}
if(!optionSet){elem.selectedIndex=-1}
return values}}}});jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]={set:function(elem,value){if(Array.isArray(value)){return(elem.checked=jQuery.inArray(jQuery(elem).val(),value)>-1)}}};if(!support.checkOn){jQuery.valHooks[this].get=function(elem){return elem.getAttribute("value")===null?"on":elem.value}}});var location=window.location;var nonce={guid:Date.now()};var rquery=(/\?/);jQuery.parseXML=function(data){var xml,parserErrorElem;if(!data||typeof data!=="string"){return null}
try{xml=(new window.DOMParser()).parseFromString(data,"text/xml")}catch(e){}
parserErrorElem=xml&&xml.getElementsByTagName("parsererror")[0];if(!xml||parserErrorElem){jQuery.error("Invalid XML: "+(parserErrorElem?jQuery.map(parserErrorElem.childNodes,function(el){return el.textContent}).join("\n"):data))}
return xml};var rfocusMorph=/^(?:focusinfocus|focusoutblur)$/,stopPropagationCallback=function(e){e.stopPropagation()};jQuery.extend(jQuery.event,{trigger:function(event,data,elem,onlyHandlers){var i,cur,tmp,bubbleType,ontype,handle,special,lastElement,eventPath=[elem||document],type=hasOwn.call(event,"type")?event.type:event,namespaces=hasOwn.call(event,"namespace")?event.namespace.split("."):[];cur=lastElement=tmp=elem=elem||document;if(elem.nodeType===3||elem.nodeType===8){return}
if(rfocusMorph.test(type+jQuery.event.triggered)){return}
if(type.indexOf(".")>-1){namespaces=type.split(".");type=namespaces.shift();namespaces.sort()}
ontype=type.indexOf(":")<0&&"on"+type;event=event[jQuery.expando]?event:new jQuery.Event(type,typeof event==="object"&&event);event.isTrigger=onlyHandlers?2:3;event.namespace=namespaces.join(".");event.rnamespace=event.namespace?new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)"):null;event.result=undefined;if(!event.target){event.target=elem}
data=data==null?[event]:jQuery.makeArray(data,[event]);special=jQuery.event.special[type]||{};if(!onlyHandlers&&special.trigger&&special.trigger.apply(elem,data)===!1){return}
if(!onlyHandlers&&!special.noBubble&&!isWindow(elem)){bubbleType=special.delegateType||type;if(!rfocusMorph.test(bubbleType+type)){cur=cur.parentNode}
for(;cur;cur=cur.parentNode){eventPath.push(cur);tmp=cur}
if(tmp===(elem.ownerDocument||document)){eventPath.push(tmp.defaultView||tmp.parentWindow||window)}}
i=0;while((cur=eventPath[i++])&&!event.isPropagationStopped()){lastElement=cur;event.type=i>1?bubbleType:special.bindType||type;handle=(dataPriv.get(cur,"events")||Object.create(null))[event.type]&&dataPriv.get(cur,"handle");if(handle){handle.apply(cur,data)}
handle=ontype&&cur[ontype];if(handle&&handle.apply&&acceptData(cur)){event.result=handle.apply(cur,data);if(event.result===!1){event.preventDefault()}}}
event.type=type;if(!onlyHandlers&&!event.isDefaultPrevented()){if((!special._default||special._default.apply(eventPath.pop(),data)===!1)&&acceptData(elem)){if(ontype&&isFunction(elem[type])&&!isWindow(elem)){tmp=elem[ontype];if(tmp){elem[ontype]=null}
jQuery.event.triggered=type;if(event.isPropagationStopped()){lastElement.addEventListener(type,stopPropagationCallback)}
elem[type]();if(event.isPropagationStopped()){lastElement.removeEventListener(type,stopPropagationCallback)}
jQuery.event.triggered=undefined;if(tmp){elem[ontype]=tmp}}}}
return event.result},simulate:function(type,elem,event){var e=jQuery.extend(new jQuery.Event(),event,{type:type,isSimulated:!0});jQuery.event.trigger(e,null,elem)}});jQuery.fn.extend({trigger:function(type,data){return this.each(function(){jQuery.event.trigger(type,data,this)})},triggerHandler:function(type,data){var elem=this[0];if(elem){return jQuery.event.trigger(type,data,elem,!0)}}});var rbracket=/\[\]$/,rCRLF=/\r?\n/g,rsubmitterTypes=/^(?:submit|button|image|reset|file)$/i,rsubmittable=/^(?:input|select|textarea|keygen)/i;function buildParams(prefix,obj,traditional,add){var name;if(Array.isArray(obj)){jQuery.each(obj,function(i,v){if(traditional||rbracket.test(prefix)){add(prefix,v)}else{buildParams(prefix+"["+(typeof v==="object"&&v!=null?i:"")+"]",v,traditional,add)}})}else if(!traditional&&toType(obj)==="object"){for(name in obj){buildParams(prefix+"["+name+"]",obj[name],traditional,add)}}else{add(prefix,obj)}}
jQuery.param=function(a,traditional){var prefix,s=[],add=function(key,valueOrFunction){var value=isFunction(valueOrFunction)?valueOrFunction():valueOrFunction;s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value==null?"":value)};if(a==null){return""}
if(Array.isArray(a)||(a.jquery&&!jQuery.isPlainObject(a))){jQuery.each(a,function(){add(this.name,this.value)})}else{for(prefix in a){buildParams(prefix,a[prefix],traditional,add)}}
return s.join("&")};jQuery.fn.extend({serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var elements=jQuery.prop(this,"elements");return elements?jQuery.makeArray(elements):this}).filter(function(){var type=this.type;return this.name&&!jQuery(this).is(":disabled")&&rsubmittable.test(this.nodeName)&&!rsubmitterTypes.test(type)&&(this.checked||!rcheckableType.test(type))}).map(function(_i,elem){var val=jQuery(this).val();if(val==null){return null}
if(Array.isArray(val)){return jQuery.map(val,function(val){return{name:elem.name,value:val.replace(rCRLF,"\r\n")}})}
return{name:elem.name,value:val.replace(rCRLF,"\r\n")}}).get()}});var r20=/%20/g,rhash=/#.*$/,rantiCache=/([?&])_=[^&]*/,rheaders=/^(.*?):[ \t]*([^\r\n]*)$/mg,rlocalProtocol=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,prefilters={},transports={},allTypes="*/".concat("*"),originAnchor=document.createElement("a");originAnchor.href=location.href;function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){if(typeof dataTypeExpression!=="string"){func=dataTypeExpression;dataTypeExpression="*"}
var dataType,i=0,dataTypes=dataTypeExpression.toLowerCase().match(rnothtmlwhite)||[];if(isFunction(func)){while((dataType=dataTypes[i++])){if(dataType[0]==="+"){dataType=dataType.slice(1)||"*";(structure[dataType]=structure[dataType]||[]).unshift(func)}else{(structure[dataType]=structure[dataType]||[]).push(func)}}}}}
function inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR){var inspected={},seekingTransport=(structure===transports);function inspect(dataType){var selected;inspected[dataType]=!0;jQuery.each(structure[dataType]||[],function(_,prefilterOrFactory){var dataTypeOrTransport=prefilterOrFactory(options,originalOptions,jqXHR);if(typeof dataTypeOrTransport==="string"&&!seekingTransport&&!inspected[dataTypeOrTransport]){options.dataTypes.unshift(dataTypeOrTransport);inspect(dataTypeOrTransport);return!1}else if(seekingTransport){return!(selected=dataTypeOrTransport)}});return selected}
return inspect(options.dataTypes[0])||!inspected["*"]&&inspect("*")}
function ajaxExtend(target,src){var key,deep,flatOptions=jQuery.ajaxSettings.flatOptions||{};for(key in src){if(src[key]!==undefined){(flatOptions[key]?target:(deep||(deep={})))[key]=src[key]}}
if(deep){jQuery.extend(!0,target,deep)}
return target}
function ajaxHandleResponses(s,jqXHR,responses){var ct,type,finalDataType,firstDataType,contents=s.contents,dataTypes=s.dataTypes;while(dataTypes[0]==="*"){dataTypes.shift();if(ct===undefined){ct=s.mimeType||jqXHR.getResponseHeader("Content-Type")}}
if(ct){for(type in contents){if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break}}}
if(dataTypes[0]in responses){finalDataType=dataTypes[0]}else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break}
if(!firstDataType){firstDataType=type}}
finalDataType=finalDataType||firstDataType}
if(finalDataType){if(finalDataType!==dataTypes[0]){dataTypes.unshift(finalDataType)}
return responses[finalDataType]}}
function ajaxConvert(s,response,jqXHR,isSuccess){var conv2,current,conv,tmp,prev,converters={},dataTypes=s.dataTypes.slice();if(dataTypes[1]){for(conv in s.converters){converters[conv.toLowerCase()]=s.converters[conv]}}
current=dataTypes.shift();while(current){if(s.responseFields[current]){jqXHR[s.responseFields[current]]=response}
if(!prev&&isSuccess&&s.dataFilter){response=s.dataFilter(response,s.dataType)}
prev=current;current=dataTypes.shift();if(current){if(current==="*"){current=prev}else if(prev!=="*"&&prev!==current){conv=converters[prev+" "+current]||converters["* "+current];if(!conv){for(conv2 in converters){tmp=conv2.split(" ");if(tmp[1]===current){conv=converters[prev+" "+tmp[0]]||converters["* "+tmp[0]];if(conv){if(conv===!0){conv=converters[conv2]}else if(converters[conv2]!==!0){current=tmp[0];dataTypes.unshift(tmp[1])}
break}}}}
if(conv!==!0){if(conv&&s.throws){response=conv(response)}else{try{response=conv(response)}catch(e){return{state:"parsererror",error:conv?e:"No conversion from "+prev+" to "+current}}}}}}}
return{state:"success",data:response}}
jQuery.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:location.href,type:"GET",isLocal:rlocalProtocol.test(location.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":allTypes,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":jQuery.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(target,settings){return settings?ajaxExtend(ajaxExtend(target,jQuery.ajaxSettings),settings):ajaxExtend(jQuery.ajaxSettings,target)},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){if(typeof url==="object"){options=url;url=undefined}
options=options||{};var transport,cacheURL,responseHeadersString,responseHeaders,timeoutTimer,urlAnchor,completed,fireGlobals,i,uncached,s=jQuery.ajaxSetup({},options),callbackContext=s.context||s,globalEventContext=s.context&&(callbackContext.nodeType||callbackContext.jquery)?jQuery(callbackContext):jQuery.event,deferred=jQuery.Deferred(),completeDeferred=jQuery.Callbacks("once memory"),statusCode=s.statusCode||{},requestHeaders={},requestHeadersNames={},strAbort="canceled",jqXHR={readyState:0,getResponseHeader:function(key){var match;if(completed){if(!responseHeaders){responseHeaders={};while((match=rheaders.exec(responseHeadersString))){responseHeaders[match[1].toLowerCase()+" "]=(responseHeaders[match[1].toLowerCase()+" "]||[]).concat(match[2])}}
match=responseHeaders[key.toLowerCase()+" "]}
return match==null?null:match.join(", ")},getAllResponseHeaders:function(){return completed?responseHeadersString:null},setRequestHeader:function(name,value){if(completed==null){name=requestHeadersNames[name.toLowerCase()]=requestHeadersNames[name.toLowerCase()]||name;requestHeaders[name]=value}
return this},overrideMimeType:function(type){if(completed==null){s.mimeType=type}
return this},statusCode:function(map){var code;if(map){if(completed){jqXHR.always(map[jqXHR.status])}else{for(code in map){statusCode[code]=[statusCode[code],map[code]]}}}
return this},abort:function(statusText){var finalText=statusText||strAbort;if(transport){transport.abort(finalText)}
done(0,finalText);return this}};deferred.promise(jqXHR);s.url=((url||s.url||location.href)+"").replace(rprotocol,location.protocol+"//");s.type=options.method||options.type||s.method||s.type;s.dataTypes=(s.dataType||"*").toLowerCase().match(rnothtmlwhite)||[""];if(s.crossDomain==null){urlAnchor=document.createElement("a");try{urlAnchor.href=s.url;urlAnchor.href=urlAnchor.href;s.crossDomain=originAnchor.protocol+"//"+originAnchor.host!==urlAnchor.protocol+"//"+urlAnchor.host}catch(e){s.crossDomain=!0}}
if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data,s.traditional)}
inspectPrefiltersOrTransports(prefilters,s,options,jqXHR);if(completed){return jqXHR}
fireGlobals=jQuery.event&&s.global;if(fireGlobals&&jQuery.active++===0){jQuery.event.trigger("ajaxStart")}
s.type=s.type.toUpperCase();s.hasContent=!rnoContent.test(s.type);cacheURL=s.url.replace(rhash,"");if(!s.hasContent){uncached=s.url.slice(cacheURL.length);if(s.data&&(s.processData||typeof s.data==="string")){cacheURL+=(rquery.test(cacheURL)?"&":"?")+s.data;delete s.data}
if(s.cache===!1){cacheURL=cacheURL.replace(rantiCache,"$1");uncached=(rquery.test(cacheURL)?"&":"?")+"_="+(nonce.guid++)+uncached}
s.url=cacheURL+uncached}else if(s.data&&s.processData&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0){s.data=s.data.replace(r20,"+")}
if(s.ifModified){if(jQuery.lastModified[cacheURL]){jqXHR.setRequestHeader("If-Modified-Since",jQuery.lastModified[cacheURL])}
if(jQuery.etag[cacheURL]){jqXHR.setRequestHeader("If-None-Match",jQuery.etag[cacheURL])}}
if(s.data&&s.hasContent&&s.contentType!==!1||options.contentType){jqXHR.setRequestHeader("Content-Type",s.contentType)}
jqXHR.setRequestHeader("Accept",s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+(s.dataTypes[0]!=="*"?", "+allTypes+"; q=0.01":""):s.accepts["*"]);for(i in s.headers){jqXHR.setRequestHeader(i,s.headers[i])}
if(s.beforeSend&&(s.beforeSend.call(callbackContext,jqXHR,s)===!1||completed)){return jqXHR.abort()}
strAbort="abort";completeDeferred.add(s.complete);jqXHR.done(s.success);jqXHR.fail(s.error);transport=inspectPrefiltersOrTransports(transports,s,options,jqXHR);if(!transport){done(-1,"No Transport")}else{jqXHR.readyState=1;if(fireGlobals){globalEventContext.trigger("ajaxSend",[jqXHR,s])}
if(completed){return jqXHR}
if(s.async&&s.timeout>0){timeoutTimer=window.setTimeout(function(){jqXHR.abort("timeout")},s.timeout)}
try{completed=!1;transport.send(requestHeaders,done)}catch(e){if(completed){throw e}
done(-1,e)}}
function done(status,nativeStatusText,responses,headers){var isSuccess,success,error,response,modified,statusText=nativeStatusText;if(completed){return}
completed=!0;if(timeoutTimer){window.clearTimeout(timeoutTimer)}
transport=undefined;responseHeadersString=headers||"";jqXHR.readyState=status>0?4:0;isSuccess=status>=200&&status<300||status===304;if(responses){response=ajaxHandleResponses(s,jqXHR,responses)}
if(!isSuccess&&jQuery.inArray("script",s.dataTypes)>-1&&jQuery.inArray("json",s.dataTypes)<0){s.converters["text script"]=function(){}}
response=ajaxConvert(s,response,jqXHR,isSuccess);if(isSuccess){if(s.ifModified){modified=jqXHR.getResponseHeader("Last-Modified");if(modified){jQuery.lastModified[cacheURL]=modified}
modified=jqXHR.getResponseHeader("etag");if(modified){jQuery.etag[cacheURL]=modified}}
if(status===204||s.type==="HEAD"){statusText="nocontent"}else if(status===304){statusText="notmodified"}else{statusText=response.state;success=response.data;error=response.error;isSuccess=!error}}else{error=statusText;if(status||!statusText){statusText="error";if(status<0){status=0}}}
jqXHR.status=status;jqXHR.statusText=(nativeStatusText||statusText)+"";if(isSuccess){deferred.resolveWith(callbackContext,[success,statusText,jqXHR])}else{deferred.rejectWith(callbackContext,[jqXHR,statusText,error])}
jqXHR.statusCode(statusCode);statusCode=undefined;if(fireGlobals){globalEventContext.trigger(isSuccess?"ajaxSuccess":"ajaxError",[jqXHR,s,isSuccess?success:error])}
completeDeferred.fireWith(callbackContext,[jqXHR,statusText]);if(fireGlobals){globalEventContext.trigger("ajaxComplete",[jqXHR,s]);if(!(--jQuery.active)){jQuery.event.trigger("ajaxStop")}}}
return jqXHR},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json")},getScript:function(url,callback){return jQuery.get(url,undefined,callback,"script")}});jQuery.each(["get","post"],function(_i,method){jQuery[method]=function(url,data,callback,type){if(isFunction(data)){type=type||callback;callback=data;data=undefined}
return jQuery.ajax(jQuery.extend({url:url,type:method,dataType:type,data:data,success:callback},jQuery.isPlainObject(url)&&url))}});jQuery.ajaxPrefilter(function(s){var i;for(i in s.headers){if(i.toLowerCase()==="content-type"){s.contentType=s.headers[i]||""}}});jQuery._evalUrl=function(url,options,doc){return jQuery.ajax({url:url,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(response){jQuery.globalEval(response,options,doc)}})};jQuery.fn.extend({wrapAll:function(html){var wrap;if(this[0]){if(isFunction(html)){html=html.call(this[0])}
wrap=jQuery(html,this[0].ownerDocument).eq(0).clone(!0);if(this[0].parentNode){wrap.insertBefore(this[0])}
wrap.map(function(){var elem=this;while(elem.firstElementChild){elem=elem.firstElementChild}
return elem}).append(this)}
return this},wrapInner:function(html){if(isFunction(html)){return this.each(function(i){jQuery(this).wrapInner(html.call(this,i))})}
return this.each(function(){var self=jQuery(this),contents=self.contents();if(contents.length){contents.wrapAll(html)}else{self.append(html)}})},wrap:function(html){var htmlIsFunction=isFunction(html);return this.each(function(i){jQuery(this).wrapAll(htmlIsFunction?html.call(this,i):html)})},unwrap:function(selector){this.parent(selector).not("body").each(function(){jQuery(this).replaceWith(this.childNodes)});return this}});jQuery.expr.pseudos.hidden=function(elem){return!jQuery.expr.pseudos.visible(elem)};jQuery.expr.pseudos.visible=function(elem){return!!(elem.offsetWidth||elem.offsetHeight||elem.getClientRects().length)};jQuery.ajaxSettings.xhr=function(){try{return new window.XMLHttpRequest()}catch(e){}};var xhrSuccessStatus={0:200,1223:204},xhrSupported=jQuery.ajaxSettings.xhr();support.cors=!!xhrSupported&&("withCredentials" in xhrSupported);support.ajax=xhrSupported=!!xhrSupported;jQuery.ajaxTransport(function(options){var callback,errorCallback;if(support.cors||xhrSupported&&!options.crossDomain){return{send:function(headers,complete){var i,xhr=options.xhr();xhr.open(options.type,options.url,options.async,options.username,options.password);if(options.xhrFields){for(i in options.xhrFields){xhr[i]=options.xhrFields[i]}}
if(options.mimeType&&xhr.overrideMimeType){xhr.overrideMimeType(options.mimeType)}
if(!options.crossDomain&&!headers["X-Requested-With"]){headers["X-Requested-With"]="XMLHttpRequest"}
for(i in headers){xhr.setRequestHeader(i,headers[i])}
callback=function(type){return function(){if(callback){callback=errorCallback=xhr.onload=xhr.onerror=xhr.onabort=xhr.ontimeout=xhr.onreadystatechange=null;if(type==="abort"){xhr.abort()}else if(type==="error"){if(typeof xhr.status!=="number"){complete(0,"error")}else{complete(xhr.status,xhr.statusText)}}else{complete(xhrSuccessStatus[xhr.status]||xhr.status,xhr.statusText,(xhr.responseType||"text")!=="text"||typeof xhr.responseText!=="string"?{binary:xhr.response}:{text:xhr.responseText},xhr.getAllResponseHeaders())}}}};xhr.onload=callback();errorCallback=xhr.onerror=xhr.ontimeout=callback("error");if(xhr.onabort!==undefined){xhr.onabort=errorCallback}else{xhr.onreadystatechange=function(){if(xhr.readyState===4){window.setTimeout(function(){if(callback){errorCallback()}})}}}
callback=callback("abort");try{xhr.send(options.hasContent&&options.data||null)}catch(e){if(callback){throw e}}},abort:function(){if(callback){callback()}}}}});jQuery.ajaxPrefilter(function(s){if(s.crossDomain){s.contents.script=!1}});jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, "+"application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(text){jQuery.globalEval(text);return text}}});jQuery.ajaxPrefilter("script",function(s){if(s.cache===undefined){s.cache=!1}
if(s.crossDomain){s.type="GET"}});jQuery.ajaxTransport("script",function(s){if(s.crossDomain||s.scriptAttrs){var script,callback;return{send:function(_,complete){script=jQuery("<script>").attr(s.scriptAttrs||{}).prop({charset:s.scriptCharset,src:s.url}).on("load error",callback=function(evt){script.remove();callback=null;if(evt){complete(evt.type==="error"?404:200,evt.type)}});document.head.appendChild(script[0])},abort:function(){if(callback){callback()}}}}});var oldCallbacks=[],rjsonp=/(=)\?(?=&|$)|\?\?/;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var callback=oldCallbacks.pop()||(jQuery.expando+"_"+(nonce.guid++));this[callback]=!0;return callback}});jQuery.ajaxPrefilter("json jsonp",function(s,originalSettings,jqXHR){var callbackName,overwritten,responseContainer,jsonProp=s.jsonp!==!1&&(rjsonp.test(s.url)?"url":typeof s.data==="string"&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0&&rjsonp.test(s.data)&&"data");if(jsonProp||s.dataTypes[0]==="jsonp"){callbackName=s.jsonpCallback=isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback;if(jsonProp){s[jsonProp]=s[jsonProp].replace(rjsonp,"$1"+callbackName)}else if(s.jsonp!==!1){s.url+=(rquery.test(s.url)?"&":"?")+s.jsonp+"="+callbackName}
s.converters["script json"]=function(){if(!responseContainer){jQuery.error(callbackName+" was not called")}
return responseContainer[0]};s.dataTypes[0]="json";overwritten=window[callbackName];window[callbackName]=function(){responseContainer=arguments};jqXHR.always(function(){if(overwritten===undefined){jQuery(window).removeProp(callbackName)}else{window[callbackName]=overwritten}
if(s[callbackName]){s.jsonpCallback=originalSettings.jsonpCallback;oldCallbacks.push(callbackName)}
if(responseContainer&&isFunction(overwritten)){overwritten(responseContainer[0])}
responseContainer=overwritten=undefined});return"script"}});support.createHTMLDocument=(function(){var body=document.implementation.createHTMLDocument("").body;body.innerHTML="<form></form><form></form>";return body.childNodes.length===2})();jQuery.parseHTML=function(data,context,keepScripts){if(typeof data!=="string"){return[]}
if(typeof context==="boolean"){keepScripts=context;context=!1}
var base,parsed,scripts;if(!context){if(support.createHTMLDocument){context=document.implementation.createHTMLDocument("");base=context.createElement("base");base.href=document.location.href;context.head.appendChild(base)}else{context=document}}
parsed=rsingleTag.exec(data);scripts=!keepScripts&&[];if(parsed){return[context.createElement(parsed[1])]}
parsed=buildFragment([data],context,scripts);if(scripts&&scripts.length){jQuery(scripts).remove()}
return jQuery.merge([],parsed.childNodes)};jQuery.fn.load=function(url,params,callback){var selector,type,response,self=this,off=url.indexOf(" ");if(off>-1){selector=stripAndCollapse(url.slice(off));url=url.slice(0,off)}
if(isFunction(params)){callback=params;params=undefined}else if(params&&typeof params==="object"){type="POST"}
if(self.length>0){jQuery.ajax({url:url,type:type||"GET",dataType:"html",data:params}).done(function(responseText){response=arguments;self.html(selector?jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector):responseText)}).always(callback&&function(jqXHR,status){self.each(function(){callback.apply(this,response||[jqXHR.responseText,status,jqXHR])})})}
return this};jQuery.expr.pseudos.animated=function(elem){return jQuery.grep(jQuery.timers,function(fn){return elem===fn.elem}).length};jQuery.offset={setOffset:function(elem,options,i){var curPosition,curLeft,curCSSTop,curTop,curOffset,curCSSLeft,calculatePosition,position=jQuery.css(elem,"position"),curElem=jQuery(elem),props={};if(position==="static"){elem.style.position="relative"}
curOffset=curElem.offset();curCSSTop=jQuery.css(elem,"top");curCSSLeft=jQuery.css(elem,"left");calculatePosition=(position==="absolute"||position==="fixed")&&(curCSSTop+curCSSLeft).indexOf("auto")>-1;if(calculatePosition){curPosition=curElem.position();curTop=curPosition.top;curLeft=curPosition.left}else{curTop=parseFloat(curCSSTop)||0;curLeft=parseFloat(curCSSLeft)||0}
if(isFunction(options)){options=options.call(elem,i,jQuery.extend({},curOffset))}
if(options.top!=null){props.top=(options.top-curOffset.top)+curTop}
if(options.left!=null){props.left=(options.left-curOffset.left)+curLeft}
if("using" in options){options.using.call(elem,props)}else{curElem.css(props)}}};jQuery.fn.extend({offset:function(options){if(arguments.length){return options===undefined?this:this.each(function(i){jQuery.offset.setOffset(this,options,i)})}
var rect,win,elem=this[0];if(!elem){return}
if(!elem.getClientRects().length){return{top:0,left:0}}
rect=elem.getBoundingClientRect();win=elem.ownerDocument.defaultView;return{top:rect.top+win.pageYOffset,left:rect.left+win.pageXOffset}},position:function(){if(!this[0]){return}
var offsetParent,offset,doc,elem=this[0],parentOffset={top:0,left:0};if(jQuery.css(elem,"position")==="fixed"){offset=elem.getBoundingClientRect()}else{offset=this.offset();doc=elem.ownerDocument;offsetParent=elem.offsetParent||doc.documentElement;while(offsetParent&&(offsetParent===doc.body||offsetParent===doc.documentElement)&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.parentNode}
if(offsetParent&&offsetParent!==elem&&offsetParent.nodeType===1){parentOffset=jQuery(offsetParent).offset();parentOffset.top+=jQuery.css(offsetParent,"borderTopWidth",!0);parentOffset.left+=jQuery.css(offsetParent,"borderLeftWidth",!0)}}
return{top:offset.top-parentOffset.top-jQuery.css(elem,"marginTop",!0),left:offset.left-parentOffset.left-jQuery.css(elem,"marginLeft",!0)}},offsetParent:function(){return this.map(function(){var offsetParent=this.offsetParent;while(offsetParent&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.offsetParent}
return offsetParent||documentElement})}});jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(method,prop){var top="pageYOffset"===prop;jQuery.fn[method]=function(val){return access(this,function(elem,method,val){var win;if(isWindow(elem)){win=elem}else if(elem.nodeType===9){win=elem.defaultView}
if(val===undefined){return win?win[prop]:elem[method]}
if(win){win.scrollTo(!top?val:win.pageXOffset,top?val:win.pageYOffset)}else{elem[method]=val}},method,val,arguments.length)}});jQuery.each(["top","left"],function(_i,prop){jQuery.cssHooks[prop]=addGetHookIf(support.pixelPosition,function(elem,computed){if(computed){computed=curCSS(elem,prop);return rnumnonpx.test(computed)?jQuery(elem).position()[prop]+"px":computed}})});jQuery.each({Height:"height",Width:"width"},function(name,type){jQuery.each({padding:"inner"+name,content:type,"":"outer"+name},function(defaultExtra,funcName){jQuery.fn[funcName]=function(margin,value){var chainable=arguments.length&&(defaultExtra||typeof margin!=="boolean"),extra=defaultExtra||(margin===!0||value===!0?"margin":"border");return access(this,function(elem,type,value){var doc;if(isWindow(elem)){return funcName.indexOf("outer")===0?elem["inner"+name]:elem.document.documentElement["client"+name]}
if(elem.nodeType===9){doc=elem.documentElement;return Math.max(elem.body["scroll"+name],doc["scroll"+name],elem.body["offset"+name],doc["offset"+name],doc["client"+name])}
return value===undefined?jQuery.css(elem,type,extra):jQuery.style(elem,type,value,extra)},type,chainable?margin:undefined,chainable)}})});jQuery.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(_i,type){jQuery.fn[type]=function(fn){return this.on(type,fn)}});jQuery.fn.extend({bind:function(types,data,fn){return this.on(types,null,data,fn)},unbind:function(types,fn){return this.off(types,null,fn)},delegate:function(selector,types,data,fn){return this.on(types,selector,data,fn)},undelegate:function(selector,types,fn){return arguments.length===1?this.off(selector,"**"):this.off(types,selector||"**",fn)},hover:function(fnOver,fnOut){return this.on("mouseenter",fnOver).on("mouseleave",fnOut||fnOver)}});jQuery.each(("blur focus focusin focusout resize scroll click dblclick "+"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+"change select submit keydown keypress keyup contextmenu").split(" "),function(_i,name){jQuery.fn[name]=function(data,fn){return arguments.length>0?this.on(name,null,data,fn):this.trigger(name)}});var rtrim=/^[\s\uFEFF\xA0]+|([^\s\uFEFF\xA0])[\s\uFEFF\xA0]+$/g;jQuery.proxy=function(fn,context){var tmp,args,proxy;if(typeof context==="string"){tmp=fn[context];context=fn;fn=tmp}
if(!isFunction(fn)){return undefined}
args=slice.call(arguments,2);proxy=function(){return fn.apply(context||this,args.concat(slice.call(arguments)))};proxy.guid=fn.guid=fn.guid||jQuery.guid++;return proxy};jQuery.holdReady=function(hold){if(hold){jQuery.readyWait++}else{jQuery.ready(!0)}};jQuery.isArray=Array.isArray;jQuery.parseJSON=JSON.parse;jQuery.nodeName=nodeName;jQuery.isFunction=isFunction;jQuery.isWindow=isWindow;jQuery.camelCase=camelCase;jQuery.type=toType;jQuery.now=Date.now;jQuery.isNumeric=function(obj){var type=jQuery.type(obj);return(type==="number"||type==="string")&&!isNaN(obj-parseFloat(obj))};jQuery.trim=function(text){return text==null?"":(text+"").replace(rtrim,"$1")};if(typeof define==="function"&&define.amd){define("jquery",[],function(){return jQuery})}
var _jQuery=window.jQuery,_$=window.$;jQuery.noConflict=function(deep){if(window.$===jQuery){window.$=_$}
if(deep&&window.jQuery===jQuery){window.jQuery=_jQuery}
return jQuery};if(typeof noGlobal==="undefined"){window.jQuery=window.$=jQuery}
return jQuery});/*!
 * JavaScript Cookie v2.2.1
 * https://github.com/js-cookie/js-cookie
 *
 * Copyright 2006, 2015 Klaus Hartl & Fagner Brack
 * Released under the MIT license
 */
;(function(factory){var registeredInModuleLoader;if(typeof define==='function'&&define.amd){define(factory);registeredInModuleLoader=!0}
if(typeof exports==='object'){module.exports=factory();registeredInModuleLoader=!0}
if(!registeredInModuleLoader){var OldCookies=window.Cookies;var api=window.Cookies=factory();api.noConflict=function(){window.Cookies=OldCookies;return api}}}(function(){function extend(){var i=0;var result={};for(;i<arguments.length;i++){var attributes=arguments[i];for(var key in attributes){result[key]=attributes[key]}}
return result}
function decode(s){return s.replace(/(%[0-9A-Z]{2})+/g,decodeURIComponent)}
function init(converter){function api(){}
function set(key,value,attributes){if(typeof document==='undefined'){return}
attributes=extend({path:'/'},api.defaults,attributes);if(typeof attributes.expires==='number'){attributes.expires=new Date(new Date()*1+attributes.expires*864e+5)}
attributes.expires=attributes.expires?attributes.expires.toUTCString():'';try{var result=JSON.stringify(value);if(/^[\{\[]/.test(result)){value=result}}catch(e){}
value=converter.write?converter.write(value,key):encodeURIComponent(String(value)).replace(/%(23|24|26|2B|3A|3C|3E|3D|2F|3F|40|5B|5D|5E|60|7B|7D|7C)/g,decodeURIComponent);key=encodeURIComponent(String(key)).replace(/%(23|24|26|2B|5E|60|7C)/g,decodeURIComponent).replace(/[\(\)]/g,escape);var stringifiedAttributes='';for(var attributeName in attributes){if(!attributes[attributeName]){continue}
stringifiedAttributes+='; '+attributeName;if(attributes[attributeName]===!0){continue}
stringifiedAttributes+='='+attributes[attributeName].split(';')[0]}
return(document.cookie=key+'='+value+stringifiedAttributes)}
function get(key,json){if(typeof document==='undefined'){return}
var jar={};var cookies=document.cookie?document.cookie.split('; '):[];var i=0;for(;i<cookies.length;i++){var parts=cookies[i].split('=');var cookie=parts.slice(1).join('=');if(!json&&cookie.charAt(0)==='"'){cookie=cookie.slice(1,-1)}
try{var name=decode(parts[0]);cookie=(converter.read||converter)(cookie,name)||decode(cookie);if(json){try{cookie=JSON.parse(cookie)}catch(e){}}
jar[name]=cookie;if(key===name){break}}catch(e){}}
return key?jar[key]:jar}
api.set=set;api.get=function(key){return get(key,!1)};api.getJSON=function(key){return get(key,!0)};api.remove=function(key,attributes){set(key,'',extend(attributes,{expires:-1}))};api.defaults={};api.withConverter=init;return api}
return init(function(){})}));/*!
 * Bootstrap v3.4.1 (https://getbootstrap.com/)
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under the MIT license
 */
if(typeof jQuery==='undefined'){throw new Error('Bootstrap\'s JavaScript requires jQuery')}+function($){'use strict';var version=$.fn.jquery.split(' ')[0].split('.')
if((version[0]<2&&version[1]<9)||(version[0]==1&&version[1]==9&&version[2]<1)||(version[0]>3)){throw new Error('Bootstrap\'s JavaScript requires jQuery version 1.9.1 or higher, but lower than version 4')}}(jQuery);+function($){'use strict';function transitionEnd(){var el=document.createElement('bootstrap')
var transEndEventNames={WebkitTransition:'webkitTransitionEnd',MozTransition:'transitionend',OTransition:'oTransitionEnd otransitionend',transition:'transitionend'}
for(var name in transEndEventNames){if(el.style[name]!==undefined){return{end:transEndEventNames[name]}}}
return!1}
$.fn.emulateTransitionEnd=function(duration){var called=!1
var $el=this
$(this).one('bsTransitionEnd',function(){called=!0})
var callback=function(){if(!called)$($el).trigger($.support.transition.end)}
setTimeout(callback,duration)
return this}
$(function(){$.support.transition=transitionEnd()
if(!$.support.transition)return
$.event.special.bsTransitionEnd={bindType:$.support.transition.end,delegateType:$.support.transition.end,handle:function(e){if($(e.target).is(this))return e.handleObj.handler.apply(this,arguments)}}})}(jQuery);+function($){'use strict';var dismiss='[data-dismiss="alert"]'
var Alert=function(el){$(el).on('click',dismiss,this.close)}
Alert.VERSION='3.4.1'
Alert.TRANSITION_DURATION=150
Alert.prototype.close=function(e){var $this=$(this)
var selector=$this.attr('data-target')
if(!selector){selector=$this.attr('href')
selector=selector&&selector.replace(/.*(?=#[^\s]*$)/,'')}
selector=selector==='#'?[]:selector
var $parent=$(document).find(selector)
if(e)e.preventDefault()
if(!$parent.length){$parent=$this.closest('.alert')}
$parent.trigger(e=$.Event('close.bs.alert'))
if(e.isDefaultPrevented())return
$parent.removeClass('in')
function removeElement(){$parent.detach().trigger('closed.bs.alert').remove()}
$.support.transition&&$parent.hasClass('fade')?$parent.one('bsTransitionEnd',removeElement).emulateTransitionEnd(Alert.TRANSITION_DURATION):removeElement()}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.alert')
if(!data)$this.data('bs.alert',(data=new Alert(this)))
if(typeof option=='string')data[option].call($this)})}
var old=$.fn.alert
$.fn.alert=Plugin
$.fn.alert.Constructor=Alert
$.fn.alert.noConflict=function(){$.fn.alert=old
return this}
$(document).on('click.bs.alert.data-api',dismiss,Alert.prototype.close)}(jQuery);+function($){'use strict';var Button=function(element,options){this.$element=$(element)
this.options=$.extend({},Button.DEFAULTS,options)
this.isLoading=!1}
Button.VERSION='3.4.1'
Button.DEFAULTS={loadingText:'loading...'}
Button.prototype.setState=function(state){var d='disabled'
var $el=this.$element
var val=$el.is('input')?'val':'html'
var data=$el.data()
state+='Text'
if(data.resetText==null)$el.data('resetText',$el[val]())
setTimeout($.proxy(function(){$el[val](data[state]==null?this.options[state]:data[state])
if(state=='loadingText'){this.isLoading=!0
$el.addClass(d).attr(d,d).prop(d,!0)}else if(this.isLoading){this.isLoading=!1
$el.removeClass(d).removeAttr(d).prop(d,!1)}},this),0)}
Button.prototype.toggle=function(){var changed=!0
var $parent=this.$element.closest('[data-toggle="buttons"]')
if($parent.length){var $input=this.$element.find('input')
if($input.prop('type')=='radio'){if($input.prop('checked'))changed=!1
$parent.find('.active').removeClass('active')
this.$element.addClass('active')}else if($input.prop('type')=='checkbox'){if(($input.prop('checked'))!==this.$element.hasClass('active'))changed=!1
this.$element.toggleClass('active')}
$input.prop('checked',this.$element.hasClass('active'))
if(changed)$input.trigger('change')}else{this.$element.attr('aria-pressed',!this.$element.hasClass('active'))
this.$element.toggleClass('active')}}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.button')
var options=typeof option=='object'&&option
if(!data)$this.data('bs.button',(data=new Button(this,options)))
if(option=='toggle')data.toggle()
else if(option)data.setState(option)})}
var old=$.fn.button
$.fn.button=Plugin
$.fn.button.Constructor=Button
$.fn.button.noConflict=function(){$.fn.button=old
return this}
$(document).on('click.bs.button.data-api','[data-toggle^="button"]',function(e){var $btn=$(e.target).closest('.btn')
Plugin.call($btn,'toggle')
if(!($(e.target).is('input[type="radio"], input[type="checkbox"]'))){e.preventDefault()
if($btn.is('input,button'))$btn.trigger('focus')
else $btn.find('input:visible,button:visible').first().trigger('focus')}}).on('focus.bs.button.data-api blur.bs.button.data-api','[data-toggle^="button"]',function(e){$(e.target).closest('.btn').toggleClass('focus',/^focus(in)?$/.test(e.type))})}(jQuery);+function($){'use strict';var Carousel=function(element,options){this.$element=$(element)
this.$indicators=this.$element.find('.carousel-indicators')
this.options=options
this.paused=null
this.sliding=null
this.interval=null
this.$active=null
this.$items=null
this.options.keyboard&&this.$element.on('keydown.bs.carousel',$.proxy(this.keydown,this))
this.options.pause=='hover'&&!('ontouchstart' in document.documentElement)&&this.$element.on('mouseenter.bs.carousel',$.proxy(this.pause,this)).on('mouseleave.bs.carousel',$.proxy(this.cycle,this))}
Carousel.VERSION='3.4.1'
Carousel.TRANSITION_DURATION=600
Carousel.DEFAULTS={interval:5000,pause:'hover',wrap:!0,keyboard:!0}
Carousel.prototype.keydown=function(e){if(/input|textarea/i.test(e.target.tagName))return
switch(e.which){case 37:this.prev();break
case 39:this.next();break
default:return}
e.preventDefault()}
Carousel.prototype.cycle=function(e){e||(this.paused=!1)
this.interval&&clearInterval(this.interval)
this.options.interval&&!this.paused&&(this.interval=setInterval($.proxy(this.next,this),this.options.interval))
return this}
Carousel.prototype.getItemIndex=function(item){this.$items=item.parent().children('.item')
return this.$items.index(item||this.$active)}
Carousel.prototype.getItemForDirection=function(direction,active){var activeIndex=this.getItemIndex(active)
var willWrap=(direction=='prev'&&activeIndex===0)||(direction=='next'&&activeIndex==(this.$items.length-1))
if(willWrap&&!this.options.wrap)return active
var delta=direction=='prev'?-1:1
var itemIndex=(activeIndex+delta)%this.$items.length
return this.$items.eq(itemIndex)}
Carousel.prototype.to=function(pos){var that=this
var activeIndex=this.getItemIndex(this.$active=this.$element.find('.item.active'))
if(pos>(this.$items.length-1)||pos<0)return
if(this.sliding)return this.$element.one('slid.bs.carousel',function(){that.to(pos)})
if(activeIndex==pos)return this.pause().cycle()
return this.slide(pos>activeIndex?'next':'prev',this.$items.eq(pos))}
Carousel.prototype.pause=function(e){e||(this.paused=!0)
if(this.$element.find('.next, .prev').length&&$.support.transition){this.$element.trigger($.support.transition.end)
this.cycle(!0)}
this.interval=clearInterval(this.interval)
return this}
Carousel.prototype.next=function(){if(this.sliding)return
return this.slide('next')}
Carousel.prototype.prev=function(){if(this.sliding)return
return this.slide('prev')}
Carousel.prototype.slide=function(type,next){var $active=this.$element.find('.item.active')
var $next=next||this.getItemForDirection(type,$active)
var isCycling=this.interval
var direction=type=='next'?'left':'right'
var that=this
if($next.hasClass('active'))return(this.sliding=!1)
var relatedTarget=$next[0]
var slideEvent=$.Event('slide.bs.carousel',{relatedTarget:relatedTarget,direction:direction})
this.$element.trigger(slideEvent)
if(slideEvent.isDefaultPrevented())return
this.sliding=!0
isCycling&&this.pause()
if(this.$indicators.length){this.$indicators.find('.active').removeClass('active')
var $nextIndicator=$(this.$indicators.children()[this.getItemIndex($next)])
$nextIndicator&&$nextIndicator.addClass('active')}
var slidEvent=$.Event('slid.bs.carousel',{relatedTarget:relatedTarget,direction:direction})
if($.support.transition&&this.$element.hasClass('slide')){$next.addClass(type)
if(typeof $next==='object'&&$next.length){$next[0].offsetWidth}
$active.addClass(direction)
$next.addClass(direction)
$active.one('bsTransitionEnd',function(){$next.removeClass([type,direction].join(' ')).addClass('active')
$active.removeClass(['active',direction].join(' '))
that.sliding=!1
setTimeout(function(){that.$element.trigger(slidEvent)},0)}).emulateTransitionEnd(Carousel.TRANSITION_DURATION)}else{$active.removeClass('active')
$next.addClass('active')
this.sliding=!1
this.$element.trigger(slidEvent)}
isCycling&&this.cycle()
return this}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.carousel')
var options=$.extend({},Carousel.DEFAULTS,$this.data(),typeof option=='object'&&option)
var action=typeof option=='string'?option:options.slide
if(!data)$this.data('bs.carousel',(data=new Carousel(this,options)))
if(typeof option=='number')data.to(option)
else if(action)data[action]()
else if(options.interval)data.pause().cycle()})}
var old=$.fn.carousel
$.fn.carousel=Plugin
$.fn.carousel.Constructor=Carousel
$.fn.carousel.noConflict=function(){$.fn.carousel=old
return this}
var clickHandler=function(e){var $this=$(this)
var href=$this.attr('href')
if(href){href=href.replace(/.*(?=#[^\s]+$)/,'')}
var target=$this.attr('data-target')||href
var $target=$(document).find(target)
if(!$target.hasClass('carousel'))return
var options=$.extend({},$target.data(),$this.data())
var slideIndex=$this.attr('data-slide-to')
if(slideIndex)options.interval=!1
Plugin.call($target,options)
if(slideIndex){$target.data('bs.carousel').to(slideIndex)}
e.preventDefault()}
$(document).on('click.bs.carousel.data-api','[data-slide]',clickHandler).on('click.bs.carousel.data-api','[data-slide-to]',clickHandler)
$(window).on('load',function(){$('[data-ride="carousel"]').each(function(){var $carousel=$(this)
Plugin.call($carousel,$carousel.data())})})}(jQuery);+function($){'use strict';var Collapse=function(element,options){this.$element=$(element)
this.options=$.extend({},Collapse.DEFAULTS,options)
this.$trigger=$('[data-toggle="collapse"][href="#'+element.id+'"],'+'[data-toggle="collapse"][data-target="#'+element.id+'"]')
this.transitioning=null
if(this.options.parent){this.$parent=this.getParent()}else{this.addAriaAndCollapsedClass(this.$element,this.$trigger)}
if(this.options.toggle)this.toggle()}
Collapse.VERSION='3.4.1'
Collapse.TRANSITION_DURATION=350
Collapse.DEFAULTS={toggle:!0}
Collapse.prototype.dimension=function(){var hasWidth=this.$element.hasClass('width')
return hasWidth?'width':'height'}
Collapse.prototype.show=function(){if(this.transitioning||this.$element.hasClass('in'))return
var activesData
var actives=this.$parent&&this.$parent.children('.panel').children('.in, .collapsing')
if(actives&&actives.length){activesData=actives.data('bs.collapse')
if(activesData&&activesData.transitioning)return}
var startEvent=$.Event('show.bs.collapse')
this.$element.trigger(startEvent)
if(startEvent.isDefaultPrevented())return
if(actives&&actives.length){Plugin.call(actives,'hide')
activesData||actives.data('bs.collapse',null)}
var dimension=this.dimension()
this.$element.removeClass('collapse').addClass('collapsing')[dimension](0).attr('aria-expanded',!0)
this.$trigger.removeClass('collapsed').attr('aria-expanded',!0)
this.transitioning=1
var complete=function(){this.$element.removeClass('collapsing').addClass('collapse in')[dimension]('')
this.transitioning=0
this.$element.trigger('shown.bs.collapse')}
if(!$.support.transition)return complete.call(this)
var scrollSize=$.camelCase(['scroll',dimension].join('-'))
this.$element.one('bsTransitionEnd',$.proxy(complete,this)).emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])}
Collapse.prototype.hide=function(){if(this.transitioning||!this.$element.hasClass('in'))return
var startEvent=$.Event('hide.bs.collapse')
this.$element.trigger(startEvent)
if(startEvent.isDefaultPrevented())return
var dimension=this.dimension()
this.$element[dimension](this.$element[dimension]())[0].offsetHeight
this.$element.addClass('collapsing').removeClass('collapse in').attr('aria-expanded',!1)
this.$trigger.addClass('collapsed').attr('aria-expanded',!1)
this.transitioning=1
var complete=function(){this.transitioning=0
this.$element.removeClass('collapsing').addClass('collapse').trigger('hidden.bs.collapse')}
if(!$.support.transition)return complete.call(this)
this.$element[dimension](0).one('bsTransitionEnd',$.proxy(complete,this)).emulateTransitionEnd(Collapse.TRANSITION_DURATION)}
Collapse.prototype.toggle=function(){this[this.$element.hasClass('in')?'hide':'show']()}
Collapse.prototype.getParent=function(){return $(document).find(this.options.parent).find('[data-toggle="collapse"][data-parent="'+this.options.parent+'"]').each($.proxy(function(i,element){var $element=$(element)
this.addAriaAndCollapsedClass(getTargetFromTrigger($element),$element)},this)).end()}
Collapse.prototype.addAriaAndCollapsedClass=function($element,$trigger){var isOpen=$element.hasClass('in')
$element.attr('aria-expanded',isOpen)
$trigger.toggleClass('collapsed',!isOpen).attr('aria-expanded',isOpen)}
function getTargetFromTrigger($trigger){var href
var target=$trigger.attr('data-target')||(href=$trigger.attr('href'))&&href.replace(/.*(?=#[^\s]+$)/,'')
return $(document).find(target)}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.collapse')
var options=$.extend({},Collapse.DEFAULTS,$this.data(),typeof option=='object'&&option)
if(!data&&options.toggle&&/show|hide/.test(option))options.toggle=!1
if(!data)$this.data('bs.collapse',(data=new Collapse(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.collapse
$.fn.collapse=Plugin
$.fn.collapse.Constructor=Collapse
$.fn.collapse.noConflict=function(){$.fn.collapse=old
return this}
$(document).on('click.bs.collapse.data-api','[data-toggle="collapse"]',function(e){var $this=$(this)
if(!$this.attr('data-target'))e.preventDefault()
var $target=getTargetFromTrigger($this)
var data=$target.data('bs.collapse')
var option=data?'toggle':$this.data()
Plugin.call($target,option)})}(jQuery);+function($){'use strict';var backdrop='.dropdown-backdrop'
var toggle='[data-toggle="dropdown"]'
var Dropdown=function(element){$(element).on('click.bs.dropdown',this.toggle)}
Dropdown.VERSION='3.4.1'
function getParent($this){var selector=$this.attr('data-target')
if(!selector){selector=$this.attr('href')
selector=selector&&/#[A-Za-z]/.test(selector)&&selector.replace(/.*(?=#[^\s]*$)/,'')}
var $parent=selector!=='#'?$(document).find(selector):null
return $parent&&$parent.length?$parent:$this.parent()}
function clearMenus(e){if(e&&e.which===3)return
$(backdrop).remove()
$(toggle).each(function(){var $this=$(this)
var $parent=getParent($this)
var relatedTarget={relatedTarget:this}
if(!$parent.hasClass('open'))return
if(e&&e.type=='click'&&/input|textarea/i.test(e.target.tagName)&&$.contains($parent[0],e.target))return
$parent.trigger(e=$.Event('hide.bs.dropdown',relatedTarget))
if(e.isDefaultPrevented())return
$this.attr('aria-expanded','false')
$parent.removeClass('open').trigger($.Event('hidden.bs.dropdown',relatedTarget))})}
Dropdown.prototype.toggle=function(e){var $this=$(this)
if($this.is('.disabled, :disabled'))return
var $parent=getParent($this)
var isActive=$parent.hasClass('open')
clearMenus()
if(!isActive){if('ontouchstart' in document.documentElement&&!$parent.closest('.navbar-nav').length){$(document.createElement('div')).addClass('dropdown-backdrop').insertAfter($(this)).on('click',clearMenus)}
var relatedTarget={relatedTarget:this}
$parent.trigger(e=$.Event('show.bs.dropdown',relatedTarget))
if(e.isDefaultPrevented())return
$this.trigger('focus').attr('aria-expanded','true')
$parent.toggleClass('open').trigger($.Event('shown.bs.dropdown',relatedTarget))}
return!1}
Dropdown.prototype.keydown=function(e){if(!/(38|40|27|32)/.test(e.which)||/input|textarea/i.test(e.target.tagName))return
var $this=$(this)
e.preventDefault()
e.stopPropagation()
if($this.is('.disabled, :disabled'))return
var $parent=getParent($this)
var isActive=$parent.hasClass('open')
if(!isActive&&e.which!=27||isActive&&e.which==27){if(e.which==27)$parent.find(toggle).trigger('focus')
return $this.trigger('click')}
var desc=' li:not(.disabled):visible a'
var $items=$parent.find('.dropdown-menu'+desc)
if(!$items.length)return
var index=$items.index(e.target)
if(e.which==38&&index>0)index--
if(e.which==40&&index<$items.length-1)index++
if(!~index)index=0
$items.eq(index).trigger('focus')}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.dropdown')
if(!data)$this.data('bs.dropdown',(data=new Dropdown(this)))
if(typeof option=='string')data[option].call($this)})}
var old=$.fn.dropdown
$.fn.dropdown=Plugin
$.fn.dropdown.Constructor=Dropdown
$.fn.dropdown.noConflict=function(){$.fn.dropdown=old
return this}
$(document).on('click.bs.dropdown.data-api',clearMenus).on('click.bs.dropdown.data-api','.dropdown form',function(e){e.stopPropagation()}).on('click.bs.dropdown.data-api',toggle,Dropdown.prototype.toggle).on('keydown.bs.dropdown.data-api',toggle,Dropdown.prototype.keydown).on('keydown.bs.dropdown.data-api','.dropdown-menu',Dropdown.prototype.keydown)}(jQuery);+function($){'use strict';var Modal=function(element,options){this.options=options
this.$body=$(document.body)
this.$element=$(element)
this.$dialog=this.$element.find('.modal-dialog')
this.$backdrop=null
this.isShown=null
this.originalBodyPad=null
this.scrollbarWidth=0
this.ignoreBackdropClick=!1
this.fixedContent='.navbar-fixed-top, .navbar-fixed-bottom'
if(this.options.remote){this.$element.find('.modal-content').load(this.options.remote,$.proxy(function(){this.$element.trigger('loaded.bs.modal')},this))}}
Modal.VERSION='3.4.1'
Modal.TRANSITION_DURATION=300
Modal.BACKDROP_TRANSITION_DURATION=150
Modal.DEFAULTS={backdrop:!0,keyboard:!0,show:!0}
Modal.prototype.toggle=function(_relatedTarget){return this.isShown?this.hide():this.show(_relatedTarget)}
Modal.prototype.show=function(_relatedTarget){var that=this
var e=$.Event('show.bs.modal',{relatedTarget:_relatedTarget})
this.$element.trigger(e)
if(this.isShown||e.isDefaultPrevented())return
this.isShown=!0
this.checkScrollbar()
this.setScrollbar()
this.$body.addClass('modal-open')
this.escape()
this.resize()
this.$element.on('click.dismiss.bs.modal','[data-dismiss="modal"]',$.proxy(this.hide,this))
this.$dialog.on('mousedown.dismiss.bs.modal',function(){that.$element.one('mouseup.dismiss.bs.modal',function(e){if($(e.target).is(that.$element))that.ignoreBackdropClick=!0})})
this.backdrop(function(){var transition=$.support.transition&&that.$element.hasClass('fade')
if(!that.$element.parent().length){that.$element.appendTo(that.$body)}
that.$element.show().scrollTop(0)
that.adjustDialog()
if(transition){that.$element[0].offsetWidth}
that.$element.addClass('in')
that.enforceFocus()
var e=$.Event('shown.bs.modal',{relatedTarget:_relatedTarget})
transition?that.$dialog.one('bsTransitionEnd',function(){that.$element.trigger('focus').trigger(e)}).emulateTransitionEnd(Modal.TRANSITION_DURATION):that.$element.trigger('focus').trigger(e)})}
Modal.prototype.hide=function(e){if(e)e.preventDefault()
e=$.Event('hide.bs.modal')
this.$element.trigger(e)
if(!this.isShown||e.isDefaultPrevented())return
this.isShown=!1
this.escape()
this.resize()
$(document).off('focusin.bs.modal')
this.$element.removeClass('in').off('click.dismiss.bs.modal').off('mouseup.dismiss.bs.modal')
this.$dialog.off('mousedown.dismiss.bs.modal')
$.support.transition&&this.$element.hasClass('fade')?this.$element.one('bsTransitionEnd',$.proxy(this.hideModal,this)).emulateTransitionEnd(Modal.TRANSITION_DURATION):this.hideModal()}
Modal.prototype.enforceFocus=function(){$(document).off('focusin.bs.modal').on('focusin.bs.modal',$.proxy(function(e){if(document!==e.target&&this.$element[0]!==e.target&&!this.$element.has(e.target).length){this.$element.trigger('focus')}},this))}
Modal.prototype.escape=function(){if(this.isShown&&this.options.keyboard){this.$element.on('keydown.dismiss.bs.modal',$.proxy(function(e){e.which==27&&this.hide()},this))}else if(!this.isShown){this.$element.off('keydown.dismiss.bs.modal')}}
Modal.prototype.resize=function(){if(this.isShown){$(window).on('resize.bs.modal',$.proxy(this.handleUpdate,this))}else{$(window).off('resize.bs.modal')}}
Modal.prototype.hideModal=function(){var that=this
this.$element.hide()
this.backdrop(function(){that.$body.removeClass('modal-open')
that.resetAdjustments()
that.resetScrollbar()
that.$element.trigger('hidden.bs.modal')})}
Modal.prototype.removeBackdrop=function(){this.$backdrop&&this.$backdrop.remove()
this.$backdrop=null}
Modal.prototype.backdrop=function(callback){var that=this
var animate=this.$element.hasClass('fade')?'fade':''
if(this.isShown&&this.options.backdrop){var doAnimate=$.support.transition&&animate
this.$backdrop=$(document.createElement('div')).addClass('modal-backdrop '+animate).appendTo(this.$body)
this.$element.on('click.dismiss.bs.modal',$.proxy(function(e){if(this.ignoreBackdropClick){this.ignoreBackdropClick=!1
return}
if(e.target!==e.currentTarget)return
this.options.backdrop=='static'?this.$element[0].focus():this.hide()},this))
if(doAnimate)this.$backdrop[0].offsetWidth
this.$backdrop.addClass('in')
if(!callback)return
doAnimate?this.$backdrop.one('bsTransitionEnd',callback).emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION):callback()}else if(!this.isShown&&this.$backdrop){this.$backdrop.removeClass('in')
var callbackRemove=function(){that.removeBackdrop()
callback&&callback()}
$.support.transition&&this.$element.hasClass('fade')?this.$backdrop.one('bsTransitionEnd',callbackRemove).emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION):callbackRemove()}else if(callback){callback()}}
Modal.prototype.handleUpdate=function(){this.adjustDialog()}
Modal.prototype.adjustDialog=function(){var modalIsOverflowing=this.$element[0].scrollHeight>document.documentElement.clientHeight
this.$element.css({paddingLeft:!this.bodyIsOverflowing&&modalIsOverflowing?this.scrollbarWidth:'',paddingRight:this.bodyIsOverflowing&&!modalIsOverflowing?this.scrollbarWidth:''})}
Modal.prototype.resetAdjustments=function(){this.$element.css({paddingLeft:'',paddingRight:''})}
Modal.prototype.checkScrollbar=function(){var fullWindowWidth=window.innerWidth
if(!fullWindowWidth){var documentElementRect=document.documentElement.getBoundingClientRect()
fullWindowWidth=documentElementRect.right-Math.abs(documentElementRect.left)}
this.bodyIsOverflowing=document.body.clientWidth<fullWindowWidth
this.scrollbarWidth=this.measureScrollbar()}
Modal.prototype.setScrollbar=function(){var bodyPad=parseInt((this.$body.css('padding-right')||0),10)
this.originalBodyPad=document.body.style.paddingRight||''
var scrollbarWidth=this.scrollbarWidth
if(this.bodyIsOverflowing){this.$body.css('padding-right',bodyPad+scrollbarWidth)
$(this.fixedContent).each(function(index,element){var actualPadding=element.style.paddingRight
var calculatedPadding=$(element).css('padding-right')
$(element).data('padding-right',actualPadding).css('padding-right',parseFloat(calculatedPadding)+scrollbarWidth+'px')})}}
Modal.prototype.resetScrollbar=function(){this.$body.css('padding-right',this.originalBodyPad)
$(this.fixedContent).each(function(index,element){var padding=$(element).data('padding-right')
$(element).removeData('padding-right')
element.style.paddingRight=padding?padding:''})}
Modal.prototype.measureScrollbar=function(){var scrollDiv=document.createElement('div')
scrollDiv.className='modal-scrollbar-measure'
this.$body.append(scrollDiv)
var scrollbarWidth=scrollDiv.offsetWidth-scrollDiv.clientWidth
this.$body[0].removeChild(scrollDiv)
return scrollbarWidth}
function Plugin(option,_relatedTarget){return this.each(function(){var $this=$(this)
var data=$this.data('bs.modal')
var options=$.extend({},Modal.DEFAULTS,$this.data(),typeof option=='object'&&option)
if(!data)$this.data('bs.modal',(data=new Modal(this,options)))
if(typeof option=='string')data[option](_relatedTarget)
else if(options.show)data.show(_relatedTarget)})}
var old=$.fn.modal
$.fn.modal=Plugin
$.fn.modal.Constructor=Modal
$.fn.modal.noConflict=function(){$.fn.modal=old
return this}
$(document).on('click.bs.modal.data-api','[data-toggle="modal"]',function(e){var $this=$(this)
var href=$this.attr('href')
var target=$this.attr('data-target')||(href&&href.replace(/.*(?=#[^\s]+$)/,''))
var $target=$(document).find(target)
var option=$target.data('bs.modal')?'toggle':$.extend({remote:!/#/.test(href)&&href},$target.data(),$this.data())
if($this.is('a'))e.preventDefault()
$target.one('show.bs.modal',function(showEvent){if(showEvent.isDefaultPrevented())return
$target.one('hidden.bs.modal',function(){$this.is(':visible')&&$this.trigger('focus')})})
Plugin.call($target,option,this)})}(jQuery);+function($){'use strict';var DISALLOWED_ATTRIBUTES=['sanitize','whiteList','sanitizeFn']
var uriAttrs=['background','cite','href','itemtype','longdesc','poster','src','xlink:href']
var ARIA_ATTRIBUTE_PATTERN=/^aria-[\w-]*$/i
var DefaultWhitelist={'*':['class','dir','id','lang','role',ARIA_ATTRIBUTE_PATTERN],a:['target','href','title','rel'],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:['src','alt','title','width','height'],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]}
var SAFE_URL_PATTERN=/^(?:(?:https?|mailto|ftp|tel|file):|[^&:/?#]*(?:[/?#]|$))/gi
var DATA_URL_PATTERN=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[a-z0-9+/]+=*$/i
function allowedAttribute(attr,allowedAttributeList){var attrName=attr.nodeName.toLowerCase()
if($.inArray(attrName,allowedAttributeList)!==-1){if($.inArray(attrName,uriAttrs)!==-1){return Boolean(attr.nodeValue.match(SAFE_URL_PATTERN)||attr.nodeValue.match(DATA_URL_PATTERN))}
return!0}
var regExp=$(allowedAttributeList).filter(function(index,value){return value instanceof RegExp})
for(var i=0,l=regExp.length;i<l;i++){if(attrName.match(regExp[i])){return!0}}
return!1}
function sanitizeHtml(unsafeHtml,whiteList,sanitizeFn){if(unsafeHtml.length===0){return unsafeHtml}
if(sanitizeFn&&typeof sanitizeFn==='function'){return sanitizeFn(unsafeHtml)}
if(!document.implementation||!document.implementation.createHTMLDocument){return unsafeHtml}
var createdDocument=document.implementation.createHTMLDocument('sanitization')
createdDocument.body.innerHTML=unsafeHtml
var whitelistKeys=$.map(whiteList,function(el,i){return i})
var elements=$(createdDocument.body).find('*')
for(var i=0,len=elements.length;i<len;i++){var el=elements[i]
var elName=el.nodeName.toLowerCase()
if($.inArray(elName,whitelistKeys)===-1){el.parentNode.removeChild(el)
continue}
var attributeList=$.map(el.attributes,function(el){return el})
var whitelistedAttributes=[].concat(whiteList['*']||[],whiteList[elName]||[])
for(var j=0,len2=attributeList.length;j<len2;j++){if(!allowedAttribute(attributeList[j],whitelistedAttributes)){el.removeAttribute(attributeList[j].nodeName)}}}
return createdDocument.body.innerHTML}
var Tooltip=function(element,options){this.type=null
this.options=null
this.enabled=null
this.timeout=null
this.hoverState=null
this.$element=null
this.inState=null
this.init('tooltip',element,options)}
Tooltip.VERSION='3.4.1'
Tooltip.TRANSITION_DURATION=150
Tooltip.DEFAULTS={animation:!0,placement:'top',selector:!1,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:'hover focus',title:'',delay:0,html:!1,container:!1,viewport:{selector:'body',padding:0},sanitize:!0,sanitizeFn:null,whiteList:DefaultWhitelist}
Tooltip.prototype.init=function(type,element,options){this.enabled=!0
this.type=type
this.$element=$(element)
this.options=this.getOptions(options)
this.$viewport=this.options.viewport&&$(document).find($.isFunction(this.options.viewport)?this.options.viewport.call(this,this.$element):(this.options.viewport.selector||this.options.viewport))
this.inState={click:!1,hover:!1,focus:!1}
if(this.$element[0]instanceof document.constructor&&!this.options.selector){throw new Error('`selector` option must be specified when initializing '+this.type+' on the window.document object!')}
var triggers=this.options.trigger.split(' ')
for(var i=triggers.length;i--;){var trigger=triggers[i]
if(trigger=='click'){this.$element.on('click.'+this.type,this.options.selector,$.proxy(this.toggle,this))}else if(trigger!='manual'){var eventIn=trigger=='hover'?'mouseenter':'focusin'
var eventOut=trigger=='hover'?'mouseleave':'focusout'
this.$element.on(eventIn+'.'+this.type,this.options.selector,$.proxy(this.enter,this))
this.$element.on(eventOut+'.'+this.type,this.options.selector,$.proxy(this.leave,this))}}
this.options.selector?(this._options=$.extend({},this.options,{trigger:'manual',selector:''})):this.fixTitle()}
Tooltip.prototype.getDefaults=function(){return Tooltip.DEFAULTS}
Tooltip.prototype.getOptions=function(options){var dataAttributes=this.$element.data()
for(var dataAttr in dataAttributes){if(dataAttributes.hasOwnProperty(dataAttr)&&$.inArray(dataAttr,DISALLOWED_ATTRIBUTES)!==-1){delete dataAttributes[dataAttr]}}
options=$.extend({},this.getDefaults(),dataAttributes,options)
if(options.delay&&typeof options.delay=='number'){options.delay={show:options.delay,hide:options.delay}}
if(options.sanitize){options.template=sanitizeHtml(options.template,options.whiteList,options.sanitizeFn)}
return options}
Tooltip.prototype.getDelegateOptions=function(){var options={}
var defaults=this.getDefaults()
this._options&&$.each(this._options,function(key,value){if(defaults[key]!=value)options[key]=value})
return options}
Tooltip.prototype.enter=function(obj){var self=obj instanceof this.constructor?obj:$(obj.currentTarget).data('bs.'+this.type)
if(!self){self=new this.constructor(obj.currentTarget,this.getDelegateOptions())
$(obj.currentTarget).data('bs.'+this.type,self)}
if(obj instanceof $.Event){self.inState[obj.type=='focusin'?'focus':'hover']=!0}
if(self.tip().hasClass('in')||self.hoverState=='in'){self.hoverState='in'
return}
clearTimeout(self.timeout)
self.hoverState='in'
if(!self.options.delay||!self.options.delay.show)return self.show()
self.timeout=setTimeout(function(){if(self.hoverState=='in')self.show()},self.options.delay.show)}
Tooltip.prototype.isInStateTrue=function(){for(var key in this.inState){if(this.inState[key])return!0}
return!1}
Tooltip.prototype.leave=function(obj){var self=obj instanceof this.constructor?obj:$(obj.currentTarget).data('bs.'+this.type)
if(!self){self=new this.constructor(obj.currentTarget,this.getDelegateOptions())
$(obj.currentTarget).data('bs.'+this.type,self)}
if(obj instanceof $.Event){self.inState[obj.type=='focusout'?'focus':'hover']=!1}
if(self.isInStateTrue())return
clearTimeout(self.timeout)
self.hoverState='out'
if(!self.options.delay||!self.options.delay.hide)return self.hide()
self.timeout=setTimeout(function(){if(self.hoverState=='out')self.hide()},self.options.delay.hide)}
Tooltip.prototype.show=function(){var e=$.Event('show.bs.'+this.type)
if(this.hasContent()&&this.enabled){this.$element.trigger(e)
var inDom=$.contains(this.$element[0].ownerDocument.documentElement,this.$element[0])
if(e.isDefaultPrevented()||!inDom)return
var that=this
var $tip=this.tip()
var tipId=this.getUID(this.type)
this.setContent()
$tip.attr('id',tipId)
this.$element.attr('aria-describedby',tipId)
if(this.options.animation)$tip.addClass('fade')
var placement=typeof this.options.placement=='function'?this.options.placement.call(this,$tip[0],this.$element[0]):this.options.placement
var autoToken=/\s?auto?\s?/i
var autoPlace=autoToken.test(placement)
if(autoPlace)placement=placement.replace(autoToken,'')||'top'
$tip.detach().css({top:0,left:0,display:'block'}).addClass(placement).data('bs.'+this.type,this)
this.options.container?$tip.appendTo($(document).find(this.options.container)):$tip.insertAfter(this.$element)
this.$element.trigger('inserted.bs.'+this.type)
var pos=this.getPosition()
var actualWidth=$tip[0].offsetWidth
var actualHeight=$tip[0].offsetHeight
if(autoPlace){var orgPlacement=placement
var viewportDim=this.getPosition(this.$viewport)
placement=placement=='bottom'&&pos.bottom+actualHeight>viewportDim.bottom?'top':placement=='top'&&pos.top-actualHeight<viewportDim.top?'bottom':placement=='right'&&pos.right+actualWidth>viewportDim.width?'left':placement=='left'&&pos.left-actualWidth<viewportDim.left?'right':placement
$tip.removeClass(orgPlacement).addClass(placement)}
var calculatedOffset=this.getCalculatedOffset(placement,pos,actualWidth,actualHeight)
this.applyPlacement(calculatedOffset,placement)
var complete=function(){var prevHoverState=that.hoverState
that.$element.trigger('shown.bs.'+that.type)
that.hoverState=null
if(prevHoverState=='out')that.leave(that)}
$.support.transition&&this.$tip.hasClass('fade')?$tip.one('bsTransitionEnd',complete).emulateTransitionEnd(Tooltip.TRANSITION_DURATION):complete()}}
Tooltip.prototype.applyPlacement=function(offset,placement){var $tip=this.tip()
var width=$tip[0].offsetWidth
var height=$tip[0].offsetHeight
var marginTop=parseInt($tip.css('margin-top'),10)
var marginLeft=parseInt($tip.css('margin-left'),10)
if(isNaN(marginTop))marginTop=0
if(isNaN(marginLeft))marginLeft=0
offset.top+=marginTop
offset.left+=marginLeft
$.offset.setOffset($tip[0],$.extend({using:function(props){$tip.css({top:Math.round(props.top),left:Math.round(props.left)})}},offset),0)
$tip.addClass('in')
var actualWidth=$tip[0].offsetWidth
var actualHeight=$tip[0].offsetHeight
if(placement=='top'&&actualHeight!=height){offset.top=offset.top+height-actualHeight}
var delta=this.getViewportAdjustedDelta(placement,offset,actualWidth,actualHeight)
if(delta.left)offset.left+=delta.left
else offset.top+=delta.top
var isVertical=/top|bottom/.test(placement)
var arrowDelta=isVertical?delta.left*2-width+actualWidth:delta.top*2-height+actualHeight
var arrowOffsetPosition=isVertical?'offsetWidth':'offsetHeight'
$tip.offset(offset)
this.replaceArrow(arrowDelta,$tip[0][arrowOffsetPosition],isVertical)}
Tooltip.prototype.replaceArrow=function(delta,dimension,isVertical){this.arrow().css(isVertical?'left':'top',50*(1-delta/dimension)+'%').css(isVertical?'top':'left','')}
Tooltip.prototype.setContent=function(){var $tip=this.tip()
var title=this.getTitle()
if(this.options.html){if(this.options.sanitize){title=sanitizeHtml(title,this.options.whiteList,this.options.sanitizeFn)}
$tip.find('.tooltip-inner').html(title)}else{$tip.find('.tooltip-inner').text(title)}
$tip.removeClass('fade in top bottom left right')}
Tooltip.prototype.hide=function(callback){var that=this
var $tip=$(this.$tip)
var e=$.Event('hide.bs.'+this.type)
function complete(){if(that.hoverState!='in')$tip.detach()
if(that.$element){that.$element.removeAttr('aria-describedby').trigger('hidden.bs.'+that.type)}
callback&&callback()}
this.$element.trigger(e)
if(e.isDefaultPrevented())return
$tip.removeClass('in')
$.support.transition&&$tip.hasClass('fade')?$tip.one('bsTransitionEnd',complete).emulateTransitionEnd(Tooltip.TRANSITION_DURATION):complete()
this.hoverState=null
return this}
Tooltip.prototype.fixTitle=function(){var $e=this.$element
if($e.attr('title')||typeof $e.attr('data-original-title')!='string'){$e.attr('data-original-title',$e.attr('title')||'').attr('title','')}}
Tooltip.prototype.hasContent=function(){return this.getTitle()}
Tooltip.prototype.getPosition=function($element){$element=$element||this.$element
var el=$element[0]
var isBody=el.tagName=='BODY'
var elRect=el.getBoundingClientRect()
if(elRect.width==null){elRect=$.extend({},elRect,{width:elRect.right-elRect.left,height:elRect.bottom-elRect.top})}
var isSvg=window.SVGElement&&el instanceof window.SVGElement
var elOffset=isBody?{top:0,left:0}:(isSvg?null:$element.offset())
var scroll={scroll:isBody?document.documentElement.scrollTop||document.body.scrollTop:$element.scrollTop()}
var outerDims=isBody?{width:$(window).width(),height:$(window).height()}:null
return $.extend({},elRect,scroll,outerDims,elOffset)}
Tooltip.prototype.getCalculatedOffset=function(placement,pos,actualWidth,actualHeight){return placement=='bottom'?{top:pos.top+pos.height,left:pos.left+pos.width/2-actualWidth/2}:placement=='top'?{top:pos.top-actualHeight,left:pos.left+pos.width/2-actualWidth/2}:placement=='left'?{top:pos.top+pos.height/2-actualHeight/2,left:pos.left-actualWidth}:{top:pos.top+pos.height/2-actualHeight/2,left:pos.left+pos.width}}
Tooltip.prototype.getViewportAdjustedDelta=function(placement,pos,actualWidth,actualHeight){var delta={top:0,left:0}
if(!this.$viewport)return delta
var viewportPadding=this.options.viewport&&this.options.viewport.padding||0
var viewportDimensions=this.getPosition(this.$viewport)
if(/right|left/.test(placement)){var topEdgeOffset=pos.top-viewportPadding-viewportDimensions.scroll
var bottomEdgeOffset=pos.top+viewportPadding-viewportDimensions.scroll+actualHeight
if(topEdgeOffset<viewportDimensions.top){delta.top=viewportDimensions.top-topEdgeOffset}else if(bottomEdgeOffset>viewportDimensions.top+viewportDimensions.height){delta.top=viewportDimensions.top+viewportDimensions.height-bottomEdgeOffset}}else{var leftEdgeOffset=pos.left-viewportPadding
var rightEdgeOffset=pos.left+viewportPadding+actualWidth
if(leftEdgeOffset<viewportDimensions.left){delta.left=viewportDimensions.left-leftEdgeOffset}else if(rightEdgeOffset>viewportDimensions.right){delta.left=viewportDimensions.left+viewportDimensions.width-rightEdgeOffset}}
return delta}
Tooltip.prototype.getTitle=function(){var title
var $e=this.$element
var o=this.options
title=$e.attr('data-original-title')||(typeof o.title=='function'?o.title.call($e[0]):o.title)
return title}
Tooltip.prototype.getUID=function(prefix){do prefix+=~~(Math.random()*1000000)
while(document.getElementById(prefix))
return prefix}
Tooltip.prototype.tip=function(){if(!this.$tip){this.$tip=$(this.options.template)
if(this.$tip.length!=1){throw new Error(this.type+' `template` option must consist of exactly 1 top-level element!')}}
return this.$tip}
Tooltip.prototype.arrow=function(){return(this.$arrow=this.$arrow||this.tip().find('.tooltip-arrow'))}
Tooltip.prototype.enable=function(){this.enabled=!0}
Tooltip.prototype.disable=function(){this.enabled=!1}
Tooltip.prototype.toggleEnabled=function(){this.enabled=!this.enabled}
Tooltip.prototype.toggle=function(e){var self=this
if(e){self=$(e.currentTarget).data('bs.'+this.type)
if(!self){self=new this.constructor(e.currentTarget,this.getDelegateOptions())
$(e.currentTarget).data('bs.'+this.type,self)}}
if(e){self.inState.click=!self.inState.click
if(self.isInStateTrue())self.enter(self)
else self.leave(self)}else{self.tip().hasClass('in')?self.leave(self):self.enter(self)}}
Tooltip.prototype.destroy=function(){var that=this
clearTimeout(this.timeout)
this.hide(function(){that.$element.off('.'+that.type).removeData('bs.'+that.type)
if(that.$tip){that.$tip.detach()}
that.$tip=null
that.$arrow=null
that.$viewport=null
that.$element=null})}
Tooltip.prototype.sanitizeHtml=function(unsafeHtml){return sanitizeHtml(unsafeHtml,this.options.whiteList,this.options.sanitizeFn)}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.tooltip')
var options=typeof option=='object'&&option
if(!data&&/destroy|hide/.test(option))return
if(!data)$this.data('bs.tooltip',(data=new Tooltip(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.tooltip
$.fn.tooltip=Plugin
$.fn.tooltip.Constructor=Tooltip
$.fn.tooltip.noConflict=function(){$.fn.tooltip=old
return this}}(jQuery);+function($){'use strict';var Popover=function(element,options){this.init('popover',element,options)}
if(!$.fn.tooltip)throw new Error('Popover requires tooltip.js')
Popover.VERSION='3.4.1'
Popover.DEFAULTS=$.extend({},$.fn.tooltip.Constructor.DEFAULTS,{placement:'right',trigger:'click',content:'',template:'<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'})
Popover.prototype=$.extend({},$.fn.tooltip.Constructor.prototype)
Popover.prototype.constructor=Popover
Popover.prototype.getDefaults=function(){return Popover.DEFAULTS}
Popover.prototype.setContent=function(){var $tip=this.tip()
var title=this.getTitle()
var content=this.getContent()
if(this.options.html){var typeContent=typeof content
if(this.options.sanitize){title=this.sanitizeHtml(title)
if(typeContent==='string'){content=this.sanitizeHtml(content)}}
$tip.find('.popover-title').html(title)
$tip.find('.popover-content').children().detach().end()[typeContent==='string'?'html':'append'](content)}else{$tip.find('.popover-title').text(title)
$tip.find('.popover-content').children().detach().end().text(content)}
$tip.removeClass('fade top bottom left right in')
if(!$tip.find('.popover-title').html())$tip.find('.popover-title').hide()}
Popover.prototype.hasContent=function(){return this.getTitle()||this.getContent()}
Popover.prototype.getContent=function(){var $e=this.$element
var o=this.options
return $e.attr('data-content')||(typeof o.content=='function'?o.content.call($e[0]):o.content)}
Popover.prototype.arrow=function(){return(this.$arrow=this.$arrow||this.tip().find('.arrow'))}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.popover')
var options=typeof option=='object'&&option
if(!data&&/destroy|hide/.test(option))return
if(!data)$this.data('bs.popover',(data=new Popover(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.popover
$.fn.popover=Plugin
$.fn.popover.Constructor=Popover
$.fn.popover.noConflict=function(){$.fn.popover=old
return this}}(jQuery);+function($){'use strict';function ScrollSpy(element,options){this.$body=$(document.body)
this.$scrollElement=$(element).is(document.body)?$(window):$(element)
this.options=$.extend({},ScrollSpy.DEFAULTS,options)
this.selector=(this.options.target||'')+' .nav li > a'
this.offsets=[]
this.targets=[]
this.activeTarget=null
this.scrollHeight=0
this.$scrollElement.on('scroll.bs.scrollspy',$.proxy(this.process,this))
this.refresh()
this.process()}
ScrollSpy.VERSION='3.4.1'
ScrollSpy.DEFAULTS={offset:10}
ScrollSpy.prototype.getScrollHeight=function(){return this.$scrollElement[0].scrollHeight||Math.max(this.$body[0].scrollHeight,document.documentElement.scrollHeight)}
ScrollSpy.prototype.refresh=function(){var that=this
var offsetMethod='offset'
var offsetBase=0
this.offsets=[]
this.targets=[]
this.scrollHeight=this.getScrollHeight()
if(!$.isWindow(this.$scrollElement[0])){offsetMethod='position'
offsetBase=this.$scrollElement.scrollTop()}
this.$body.find(this.selector).map(function(){var $el=$(this)
var href=$el.data('target')||$el.attr('href')
var $href=/^#./.test(href)&&$(href)
return($href&&$href.length&&$href.is(':visible')&&[[$href[offsetMethod]().top+offsetBase,href]])||null}).sort(function(a,b){return a[0]-b[0]}).each(function(){that.offsets.push(this[0])
that.targets.push(this[1])})}
ScrollSpy.prototype.process=function(){var scrollTop=this.$scrollElement.scrollTop()+this.options.offset
var scrollHeight=this.getScrollHeight()
var maxScroll=this.options.offset+scrollHeight-this.$scrollElement.height()
var offsets=this.offsets
var targets=this.targets
var activeTarget=this.activeTarget
var i
if(this.scrollHeight!=scrollHeight){this.refresh()}
if(scrollTop>=maxScroll){return activeTarget!=(i=targets[targets.length-1])&&this.activate(i)}
if(activeTarget&&scrollTop<offsets[0]){this.activeTarget=null
return this.clear()}
for(i=offsets.length;i--;){activeTarget!=targets[i]&&scrollTop>=offsets[i]&&(offsets[i+1]===undefined||scrollTop<offsets[i+1])&&this.activate(targets[i])}}
ScrollSpy.prototype.activate=function(target){this.activeTarget=target
this.clear()
var selector=this.selector+'[data-target="'+target+'"],'+this.selector+'[href="'+target+'"]'
var active=$(selector).parents('li').addClass('active')
if(active.parent('.dropdown-menu').length){active=active.closest('li.dropdown').addClass('active')}
active.trigger('activate.bs.scrollspy')}
ScrollSpy.prototype.clear=function(){$(this.selector).parentsUntil(this.options.target,'.active').removeClass('active')}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.scrollspy')
var options=typeof option=='object'&&option
if(!data)$this.data('bs.scrollspy',(data=new ScrollSpy(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.scrollspy
$.fn.scrollspy=Plugin
$.fn.scrollspy.Constructor=ScrollSpy
$.fn.scrollspy.noConflict=function(){$.fn.scrollspy=old
return this}
$(window).on('load.bs.scrollspy.data-api',function(){$('[data-spy="scroll"]').each(function(){var $spy=$(this)
Plugin.call($spy,$spy.data())})})}(jQuery);+function($){'use strict';var Tab=function(element){this.element=$(element)}
Tab.VERSION='3.4.1'
Tab.TRANSITION_DURATION=150
Tab.prototype.show=function(){var $this=this.element
var $ul=$this.closest('ul:not(.dropdown-menu)')
var selector=$this.data('target')
if(!selector){selector=$this.attr('href')
selector=selector&&selector.replace(/.*(?=#[^\s]*$)/,'')}
if($this.parent('li').hasClass('active'))return
var $previous=$ul.find('.active:last a')
var hideEvent=$.Event('hide.bs.tab',{relatedTarget:$this[0]})
var showEvent=$.Event('show.bs.tab',{relatedTarget:$previous[0]})
$previous.trigger(hideEvent)
$this.trigger(showEvent)
if(showEvent.isDefaultPrevented()||hideEvent.isDefaultPrevented())return
var $target=$(document).find(selector)
this.activate($this.closest('li'),$ul)
this.activate($target,$target.parent(),function(){$previous.trigger({type:'hidden.bs.tab',relatedTarget:$this[0]})
$this.trigger({type:'shown.bs.tab',relatedTarget:$previous[0]})})}
Tab.prototype.activate=function(element,container,callback){var $active=container.find('> .active')
var transition=callback&&$.support.transition&&($active.length&&$active.hasClass('fade')||!!container.find('> .fade').length)
function next(){$active.removeClass('active').find('> .dropdown-menu > .active').removeClass('active').end().find('[data-toggle="tab"]').attr('aria-expanded',!1)
element.addClass('active').find('[data-toggle="tab"]').attr('aria-expanded',!0)
if(transition){element[0].offsetWidth
element.addClass('in')}else{element.removeClass('fade')}
if(element.parent('.dropdown-menu').length){element.closest('li.dropdown').addClass('active').end().find('[data-toggle="tab"]').attr('aria-expanded',!0)}
callback&&callback()}
$active.length&&transition?$active.one('bsTransitionEnd',next).emulateTransitionEnd(Tab.TRANSITION_DURATION):next()
$active.removeClass('in')}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.tab')
if(!data)$this.data('bs.tab',(data=new Tab(this)))
if(typeof option=='string')data[option]()})}
var old=$.fn.tab
$.fn.tab=Plugin
$.fn.tab.Constructor=Tab
$.fn.tab.noConflict=function(){$.fn.tab=old
return this}
var clickHandler=function(e){e.preventDefault()
Plugin.call($(this),'show')}
$(document).on('click.bs.tab.data-api','[data-toggle="tab"]',clickHandler).on('click.bs.tab.data-api','[data-toggle="pill"]',clickHandler)}(jQuery);+function($){'use strict';var Affix=function(element,options){this.options=$.extend({},Affix.DEFAULTS,options)
var target=this.options.target===Affix.DEFAULTS.target?$(this.options.target):$(document).find(this.options.target)
this.$target=target.on('scroll.bs.affix.data-api',$.proxy(this.checkPosition,this)).on('click.bs.affix.data-api',$.proxy(this.checkPositionWithEventLoop,this))
this.$element=$(element)
this.affixed=null
this.unpin=null
this.pinnedOffset=null
this.checkPosition()}
Affix.VERSION='3.4.1'
Affix.RESET='affix affix-top affix-bottom'
Affix.DEFAULTS={offset:0,target:window}
Affix.prototype.getState=function(scrollHeight,height,offsetTop,offsetBottom){var scrollTop=this.$target.scrollTop()
var position=this.$element.offset()
var targetHeight=this.$target.height()
if(offsetTop!=null&&this.affixed=='top')return scrollTop<offsetTop?'top':!1
if(this.affixed=='bottom'){if(offsetTop!=null)return(scrollTop+this.unpin<=position.top)?!1:'bottom'
return(scrollTop+targetHeight<=scrollHeight-offsetBottom)?!1:'bottom'}
var initializing=this.affixed==null
var colliderTop=initializing?scrollTop:position.top
var colliderHeight=initializing?targetHeight:height
if(offsetTop!=null&&scrollTop<=offsetTop)return'top'
if(offsetBottom!=null&&(colliderTop+colliderHeight>=scrollHeight-offsetBottom))return'bottom'
return!1}
Affix.prototype.getPinnedOffset=function(){if(this.pinnedOffset)return this.pinnedOffset
this.$element.removeClass(Affix.RESET).addClass('affix')
var scrollTop=this.$target.scrollTop()
var position=this.$element.offset()
return(this.pinnedOffset=position.top-scrollTop)}
Affix.prototype.checkPositionWithEventLoop=function(){setTimeout($.proxy(this.checkPosition,this),1)}
Affix.prototype.checkPosition=function(){if(!this.$element.is(':visible'))return
var height=this.$element.height()
var offset=this.options.offset
var offsetTop=offset.top
var offsetBottom=offset.bottom
var scrollHeight=Math.max($(document).height(),$(document.body).height())
if(typeof offset!='object')offsetBottom=offsetTop=offset
if(typeof offsetTop=='function')offsetTop=offset.top(this.$element)
if(typeof offsetBottom=='function')offsetBottom=offset.bottom(this.$element)
var affix=this.getState(scrollHeight,height,offsetTop,offsetBottom)
if(this.affixed!=affix){if(this.unpin!=null)this.$element.css('top','')
var affixType='affix'+(affix?'-'+affix:'')
var e=$.Event(affixType+'.bs.affix')
this.$element.trigger(e)
if(e.isDefaultPrevented())return
this.affixed=affix
this.unpin=affix=='bottom'?this.getPinnedOffset():null
this.$element.removeClass(Affix.RESET).addClass(affixType).trigger(affixType.replace('affix','affixed')+'.bs.affix')}
if(affix=='bottom'){this.$element.offset({top:scrollHeight-height-offsetBottom})}}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.affix')
var options=typeof option=='object'&&option
if(!data)$this.data('bs.affix',(data=new Affix(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.affix
$.fn.affix=Plugin
$.fn.affix.Constructor=Affix
$.fn.affix.noConflict=function(){$.fn.affix=old
return this}
$(window).on('load',function(){$('[data-spy="affix"]').each(function(){var $spy=$(this)
var data=$spy.data()
data.offset=data.offset||{}
if(data.offsetBottom!=null)data.offset.bottom=data.offsetBottom
if(data.offsetTop!=null)data.offset.top=data.offsetTop
Plugin.call($spy,data)})})}(jQuery);/*!
 * jQuery Form Plugin
 * version: 4.3.0
 * Requires jQuery v1.7.2 or later
 * Project repository: https://github.com/jquery-form/form

 * Copyright 2017 Kevin Morris
 * Copyright 2006 M. Alsup

 * Dual licensed under the LGPL-2.1+ or MIT licenses
 * https://github.com/jquery-form/form#license

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 */
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof module==='object'&&module.exports){module.exports=function(root,jQuery){if(typeof jQuery==='undefined'){if(typeof window!=='undefined'){jQuery=require('jquery')}else{jQuery=require('jquery')(root)}}
factory(jQuery);return jQuery}}else{factory(jQuery)}}(function($){'use strict';var rCRLF=/\r?\n/g;var feature={};feature.fileapi=$('<input type="file">').get(0).files!==undefined;feature.formdata=(typeof window.FormData!=='undefined');var hasProp=!!$.fn.prop;$.fn.attr2=function(){if(!hasProp){return this.attr.apply(this,arguments)}
var val=this.prop.apply(this,arguments);if((val&&val.jquery)||typeof val==='string'){return val}
return this.attr.apply(this,arguments)};$.fn.ajaxSubmit=function(options,data,dataType,onSuccess){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this}
var method,action,url,isMsie,iframeSrc,$form=this;if(typeof options==='function'){options={success:options}}else if(typeof options==='string'||(options===!1&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function'){options.success=onSuccess}}else if(typeof options==='undefined'){options={}}
method=options.method||options.type||this.attr2('method');action=options.url||this.attr2('action');url=(typeof action==='string')?$.trim(action):'';url=url||window.location.href||'';if(url){url=(url.match(/^([^#]+)/)||[])[1]}
isMsie=/(MSIE|Trident)/.test(navigator.userAgent||'');iframeSrc=(isMsie&&/^https/i.test(window.location.href||''))?'javascript:false':'about:blank';options=$.extend(!0,{url:url,success:$.ajaxSettings.success,type:method||$.ajaxSettings.type,iframeSrc:iframeSrc},options);var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this}
if(options.beforeSerialize&&options.beforeSerialize(this,options)===!1){log('ajaxSubmit: submit aborted via beforeSerialize callback');return this}
var traditional=options.traditional;if(typeof traditional==='undefined'){traditional=$.ajaxSettings.traditional}
var elements=[];var qx,a=this.formToArray(options.semantic,elements,options.filtering);if(options.data){var optionsData=$.isFunction(options.data)?options.data(a):options.data;options.extraData=optionsData;qx=$.param(optionsData,traditional)}
if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===!1){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this}
this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this}
var q=$.param(a,traditional);if(qx){q=(q?(q+'&'+qx):qx)}
if(options.type.toUpperCase()==='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null}else{options.data=q}
var callbacks=[];if(options.resetForm){callbacks.push(function(){$form.resetForm()})}
if(options.clearForm){callbacks.push(function(){$form.clearForm(options.includeHidden)})}
if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data,textStatus,jqXHR){var successArguments=arguments,fn=options.replaceTarget?'replaceWith':'html';$(options.target)[fn](data).each(function(){oldSuccess.apply(this,successArguments)})})}else if(options.success){if($.isArray(options.success)){$.merge(callbacks,options.success)}else{callbacks.push(options.success)}}
options.success=function(data,status,xhr){var context=options.context||this;for(var i=0,max=callbacks.length;i<max;i++){callbacks[i].apply(context,[data,status,xhr||$form,$form])}};if(options.error){var oldError=options.error;options.error=function(xhr,status,error){var context=options.context||this;oldError.apply(context,[xhr,status,error,$form])}}
if(options.complete){var oldComplete=options.complete;options.complete=function(xhr,status){var context=options.context||this;oldComplete.apply(context,[xhr,status,$form])}}
var fileInputs=$('input[type=file]:enabled',this).filter(function(){return $(this).val()!==''});var hasFileInputs=fileInputs.length>0;var mp='multipart/form-data';var multipart=($form.attr('enctype')===mp||$form.attr('encoding')===mp);var fileAPI=feature.fileapi&&feature.formdata;log('fileAPI :'+fileAPI);var shouldUseFrame=(hasFileInputs||multipart)&&!fileAPI;var jqxhr;if(options.iframe!==!1&&(options.iframe||shouldUseFrame)){if(options.closeKeepAlive){$.get(options.closeKeepAlive,function(){jqxhr=fileUploadIframe(a)})}else{jqxhr=fileUploadIframe(a)}}else if((hasFileInputs||multipart)&&fileAPI){jqxhr=fileUploadXhr(a)}else{jqxhr=$.ajax(options)}
$form.removeData('jqxhr').data('jqxhr',jqxhr);for(var k=0;k<elements.length;k++){elements[k]=null}
this.trigger('form-submit-notify',[this,options]);return this;function deepSerialize(extraData){var serialized=$.param(extraData,options.traditional).split('&');var len=serialized.length;var result=[];var i,part;for(i=0;i<len;i++){serialized[i]=serialized[i].replace(/\+/g,' ');part=serialized[i].split('=');result.push([decodeURIComponent(part[0]),decodeURIComponent(part[1])])}
return result}
function fileUploadXhr(a){var formdata=new FormData();for(var i=0;i<a.length;i++){formdata.append(a[i].name,a[i].value)}
if(options.extraData){var serializedData=deepSerialize(options.extraData);for(i=0;i<serializedData.length;i++){if(serializedData[i]){formdata.append(serializedData[i][0],serializedData[i][1])}}}
options.data=null;var s=$.extend(!0,{},$.ajaxSettings,options,{contentType:!1,processData:!1,cache:!1,type:method||'POST'});if(options.uploadProgress){s.xhr=function(){var xhr=$.ajaxSettings.xhr();if(xhr.upload){xhr.upload.addEventListener('progress',function(event){var percent=0;var position=event.loaded||event.position;var total=event.total;if(event.lengthComputable){percent=Math.ceil(position/total*100)}
options.uploadProgress(event,position,total,percent)},!1)}
return xhr}}
s.data=null;var beforeSend=s.beforeSend;s.beforeSend=function(xhr,o){if(options.formData){o.data=options.formData}else{o.data=formdata}
if(beforeSend){beforeSend.call(this,xhr,o)}};return $.ajax(s)}
function fileUploadIframe(a){var form=$form[0],el,i,s,g,id,$io,io,xhr,sub,n,timedOut,timeoutHandle;var deferred=$.Deferred();deferred.abort=function(status){xhr.abort(status)};if(a){for(i=0;i<elements.length;i++){el=$(elements[i]);if(hasProp){el.prop('disabled',!1)}else{el.removeAttr('disabled')}}}
s=$.extend(!0,{},$.ajaxSettings,options);s.context=s.context||s;id='jqFormIO'+new Date().getTime();var ownerDocument=form.ownerDocument;var $body=$form.closest('body');if(s.iframeTarget){$io=$(s.iframeTarget,ownerDocument);n=$io.attr2('name');if(!n){$io.attr2('name',id)}else{id=n}}else{$io=$('<iframe name="'+id+'" src="'+s.iframeSrc+'" />',ownerDocument);$io.css({position:'absolute',top:'-1000px',left:'-1000px'})}
io=$io[0];xhr={aborted:0,responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(status){var e=(status==='timeout'?'timeout':'aborted');log('aborting upload... '+e);this.aborted=1;try{if(io.contentWindow.document.execCommand){io.contentWindow.document.execCommand('Stop')}}catch(ignore){}
$io.attr('src',s.iframeSrc);xhr.error=e;if(s.error){s.error.call(s.context,xhr,e,status)}
if(g){$.event.trigger('ajaxError',[xhr,s,e])}
if(s.complete){s.complete.call(s.context,xhr,e)}}};g=s.global;if(g&&$.active++===0){$.event.trigger('ajaxStart')}
if(g){$.event.trigger('ajaxSend',[xhr,s])}
if(s.beforeSend&&s.beforeSend.call(s.context,xhr,s)===!1){if(s.global){$.active--}
deferred.reject();return deferred}
if(xhr.aborted){deferred.reject();return deferred}
sub=form.clk;if(sub){n=sub.name;if(n&&!sub.disabled){s.extraData=s.extraData||{};s.extraData[n]=sub.value;if(sub.type==='image'){s.extraData[n+'.x']=form.clk_x;s.extraData[n+'.y']=form.clk_y}}}
var CLIENT_TIMEOUT_ABORT=1;var SERVER_ABORT=2;function getDoc(frame){var doc=null;try{if(frame.contentWindow){doc=frame.contentWindow.document}}catch(err){log('cannot get iframe.contentWindow document: '+err)}
if(doc){return doc}
try{doc=frame.contentDocument?frame.contentDocument:frame.document}catch(err){log('cannot get iframe.contentDocument: '+err);doc=frame.document}
return doc}
var csrf_token=$('meta[name=csrf-token]').attr('content');var csrf_param=$('meta[name=csrf-param]').attr('content');if(csrf_param&&csrf_token){s.extraData=s.extraData||{};s.extraData[csrf_param]=csrf_token}
function doSubmit(){var t=$form.attr2('target'),a=$form.attr2('action'),mp='multipart/form-data',et=$form.attr('enctype')||$form.attr('encoding')||mp;form.setAttribute('target',id);if(!method||/post/i.test(method)){form.setAttribute('method','POST')}
if(a!==s.url){form.setAttribute('action',s.url)}
if(!s.skipEncodingOverride&&(!method||/post/i.test(method))){$form.attr({encoding:'multipart/form-data',enctype:'multipart/form-data'})}
if(s.timeout){timeoutHandle=setTimeout(function(){timedOut=!0;cb(CLIENT_TIMEOUT_ABORT)},s.timeout)}
function checkState(){try{var state=getDoc(io).readyState;log('state = '+state);if(state&&state.toLowerCase()==='uninitialized'){setTimeout(checkState,50)}}catch(e){log('Server abort: ',e,' (',e.name,')');cb(SERVER_ABORT);if(timeoutHandle){clearTimeout(timeoutHandle)}
timeoutHandle=undefined}}
var extraInputs=[];try{if(s.extraData){for(var n in s.extraData){if(s.extraData.hasOwnProperty(n)){if($.isPlainObject(s.extraData[n])&&s.extraData[n].hasOwnProperty('name')&&s.extraData[n].hasOwnProperty('value')){extraInputs.push($('<input type="hidden" name="'+s.extraData[n].name+'">',ownerDocument).val(s.extraData[n].value).appendTo(form)[0])}else{extraInputs.push($('<input type="hidden" name="'+n+'">',ownerDocument).val(s.extraData[n]).appendTo(form)[0])}}}}
if(!s.iframeTarget){$io.appendTo($body)}
if(io.attachEvent){io.attachEvent('onload',cb)}else{io.addEventListener('load',cb,!1)}
setTimeout(checkState,15);try{form.submit()}catch(err){var submitFn=document.createElement('form').submit;submitFn.apply(form)}}finally{form.setAttribute('action',a);form.setAttribute('enctype',et);if(t){form.setAttribute('target',t)}else{$form.removeAttr('target')}
$(extraInputs).remove()}}
if(s.forceSync){doSubmit()}else{setTimeout(doSubmit,10)}
var data,doc,domCheckCount=50,callbackProcessed;function cb(e){if(xhr.aborted||callbackProcessed){return}
doc=getDoc(io);if(!doc){log('cannot access response document');e=SERVER_ABORT}
if(e===CLIENT_TIMEOUT_ABORT&&xhr){xhr.abort('timeout');deferred.reject(xhr,'timeout');return}
if(e===SERVER_ABORT&&xhr){xhr.abort('server abort');deferred.reject(xhr,'error','server abort');return}
if(!doc||doc.location.href===s.iframeSrc){if(!timedOut){return}}
if(io.detachEvent){io.detachEvent('onload',cb)}else{io.removeEventListener('load',cb,!1)}
var status='success',errMsg;try{if(timedOut){throw 'timeout'}
var isXml=s.dataType==='xml'||doc.XMLDocument||$.isXMLDoc(doc);log('isXml='+isXml);if(!isXml&&window.opera&&(doc.body===null||!doc.body.innerHTML)){if(--domCheckCount){log('requeing onLoad callback, DOM not available');setTimeout(cb,250);return}}
var docRoot=doc.body?doc.body:doc.documentElement;xhr.responseText=docRoot?docRoot.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;if(isXml){s.dataType='xml'}
xhr.getResponseHeader=function(header){var headers={'content-type':s.dataType};return headers[header.toLowerCase()]};if(docRoot){xhr.status=Number(docRoot.getAttribute('status'))||xhr.status;xhr.statusText=docRoot.getAttribute('statusText')||xhr.statusText}
var dt=(s.dataType||'').toLowerCase();var scr=/(json|script|text)/.test(dt);if(scr||s.textarea){var ta=doc.getElementsByTagName('textarea')[0];if(ta){xhr.responseText=ta.value;xhr.status=Number(ta.getAttribute('status'))||xhr.status;xhr.statusText=ta.getAttribute('statusText')||xhr.statusText}else if(scr){var pre=doc.getElementsByTagName('pre')[0];var b=doc.getElementsByTagName('body')[0];if(pre){xhr.responseText=pre.textContent?pre.textContent:pre.innerText}else if(b){xhr.responseText=b.textContent?b.textContent:b.innerText}}}else if(dt==='xml'&&!xhr.responseXML&&xhr.responseText){xhr.responseXML=toXml(xhr.responseText)}
try{data=httpData(xhr,dt,s)}catch(err){status='parsererror';xhr.error=errMsg=(err||status)}}catch(err){log('error caught: ',err);status='error';xhr.error=errMsg=(err||status)}
if(xhr.aborted){log('upload aborted');status=null}
if(xhr.status){status=((xhr.status>=200&&xhr.status<300)||xhr.status===304)?'success':'error'}
if(status==='success'){if(s.success){s.success.call(s.context,data,'success',xhr)}
deferred.resolve(xhr.responseText,'success',xhr);if(g){$.event.trigger('ajaxSuccess',[xhr,s])}}else if(status){if(typeof errMsg==='undefined'){errMsg=xhr.statusText}
if(s.error){s.error.call(s.context,xhr,status,errMsg)}
deferred.reject(xhr,'error',errMsg);if(g){$.event.trigger('ajaxError',[xhr,s,errMsg])}}
if(g){$.event.trigger('ajaxComplete',[xhr,s])}
if(g&&!--$.active){$.event.trigger('ajaxStop')}
if(s.complete){s.complete.call(s.context,xhr,status)}
callbackProcessed=!0;if(s.timeout){clearTimeout(timeoutHandle)}
setTimeout(function(){if(!s.iframeTarget){$io.remove()}else{$io.attr('src',s.iframeSrc)}
xhr.responseXML=null},100)}
var toXml=$.parseXML||function(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s)}else{doc=(new DOMParser()).parseFromString(s,'text/xml')}
return(doc&&doc.documentElement&&doc.documentElement.nodeName!=='parsererror')?doc:null};var parseJSON=$.parseJSON||function(s){return window['eval']('('+s+')')};var httpData=function(xhr,type,s){var ct=xhr.getResponseHeader('content-type')||'',xml=((type==='xml'||!type)&&ct.indexOf('xml')>=0),data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.nodeName==='parsererror'){if($.error){$.error('parsererror')}}
if(s&&s.dataFilter){data=s.dataFilter(data,type)}
if(typeof data==='string'){if((type==='json'||!type)&&ct.indexOf('json')>=0){data=parseJSON(data)}else if((type==='script'||!type)&&ct.indexOf('javascript')>=0){$.globalEval(data)}}
return data};return deferred}};$.fn.ajaxForm=function(options,data,dataType,onSuccess){if(typeof options==='string'||(options===!1&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function'){options.success=onSuccess}}
options=options||{};options.delegation=options.delegation&&$.isFunction($.fn.on);if(!options.delegation&&this.length===0){var o={s:this.selector,c:this.context};if(!$.isReady&&o.s){log('DOM not ready, queuing ajaxForm');$(function(){$(o.s,o.c).ajaxForm(options)});return this}
log('terminating; zero elements found by selector'+($.isReady?'':' (DOM not ready)'));return this}
if(options.delegation){$(document).off('submit.form-plugin',this.selector,doAjaxSubmit).off('click.form-plugin',this.selector,captureSubmittingElement).on('submit.form-plugin',this.selector,options,doAjaxSubmit).on('click.form-plugin',this.selector,options,captureSubmittingElement);return this}
if(options.beforeFormUnbind){options.beforeFormUnbind(this,options)}
return this.ajaxFormUnbind().on('submit.form-plugin',options,doAjaxSubmit).on('click.form-plugin',options,captureSubmittingElement)};function doAjaxSubmit(e){var options=e.data;if(!e.isDefaultPrevented()){e.preventDefault();$(e.target).closest('form').ajaxSubmit(options)}}
function captureSubmittingElement(e){var target=e.target;var $el=$(target);if(!$el.is('[type=submit],[type=image]')){var t=$el.closest('[type=submit]');if(t.length===0){return}
target=t[0]}
var form=target.form;form.clk=target;if(target.type==='image'){if(typeof e.offsetX!=='undefined'){form.clk_x=e.offsetX;form.clk_y=e.offsetY}else if(typeof $.fn.offset==='function'){var offset=$el.offset();form.clk_x=e.pageX-offset.left;form.clk_y=e.pageY-offset.top}else{form.clk_x=e.pageX-target.offsetLeft;form.clk_y=e.pageY-target.offsetTop}}
setTimeout(function(){form.clk=form.clk_x=form.clk_y=null},100)}
$.fn.ajaxFormUnbind=function(){return this.off('submit.form-plugin click.form-plugin')};$.fn.formToArray=function(semantic,elements,filtering){var a=[];if(this.length===0){return a}
var form=this[0];var formId=this.attr('id');var els=(semantic||typeof form.elements==='undefined')?form.getElementsByTagName('*'):form.elements;var els2;if(els){els=$.makeArray(els)}
if(formId&&(semantic||/(Edge|Trident)\//.test(navigator.userAgent))){els2=$(':input[form="'+formId+'"]').get();if(els2.length){els=(els||[]).concat(els2)}}
if(!els||!els.length){return a}
if($.isFunction(filtering)){els=$.map(els,filtering)}
var i,j,n,v,el,max,jmax;for(i=0,max=els.length;i<max;i++){el=els[i];n=el.name;if(!n||el.disabled){continue}
if(semantic&&form.clk&&el.type==='image'){if(form.clk===el){a.push({name:n,value:$(el).val(),type:el.type});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y})}
continue}
v=$.fieldValue(el,!0);if(v&&v.constructor===Array){if(elements){elements.push(el)}
for(j=0,jmax=v.length;j<jmax;j++){a.push({name:n,value:v[j]})}}else if(feature.fileapi&&el.type==='file'){if(elements){elements.push(el)}
var files=el.files;if(files.length){for(j=0;j<files.length;j++){a.push({name:n,value:files[j],type:el.type})}}else{a.push({name:n,value:'',type:el.type})}}else if(v!==null&&typeof v!=='undefined'){if(elements){elements.push(el)}
a.push({name:n,value:v,type:el.type,required:el.required})}}
if(!semantic&&form.clk){var $input=$(form.clk),input=$input[0];n=input.name;if(n&&!input.disabled&&input.type==='image'){a.push({name:n,value:$input.val()});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y})}}
return a};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic))};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n){return}
var v=$.fieldValue(this,successful);if(v&&v.constructor===Array){for(var i=0,max=v.length;i<max;i++){a.push({name:n,value:v[i]})}}else if(v!==null&&typeof v!=='undefined'){a.push({name:this.name,value:v})}});return $.param(a)};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v==='undefined'||(v.constructor===Array&&!v.length)){continue}
if(v.constructor===Array){$.merge(val,v)}else{val.push(v)}}
return val};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(typeof successful==='undefined'){successful=!0}
if(successful&&(!n||el.disabled||t==='reset'||t==='button'||(t==='checkbox'||t==='radio')&&!el.checked||(t==='submit'||t==='image')&&el.form&&el.form.clk!==el||tag==='select'&&el.selectedIndex===-1)){return null}
if(tag==='select'){var index=el.selectedIndex;if(index<0){return null}
var a=[],ops=el.options;var one=(t==='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected&&!op.disabled){var v=op.value;if(!v){v=(op.attributes&&op.attributes.value&&!(op.attributes.value.specified))?op.text:op.value}
if(one){return v}
a.push(v)}}
return a}
return $(el).val().replace(rCRLF,'\r\n')};$.fn.clearForm=function(includeHidden){return this.each(function(){$('input,select,textarea',this).clearFields(includeHidden)})};$.fn.clearFields=$.fn.clearInputs=function(includeHidden){var re=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(re.test(t)||tag==='textarea'){this.value=''}else if(t==='checkbox'||t==='radio'){this.checked=!1}else if(tag==='select'){this.selectedIndex=-1}else if(t==='file'){if(/MSIE/.test(navigator.userAgent)){$(this).replaceWith($(this).clone(!0))}else{$(this).val('')}}else if(includeHidden){if((includeHidden===!0&&/hidden/.test(t))||(typeof includeHidden==='string'&&$(this).is(includeHidden))){this.value=''}}})};$.fn.resetForm=function(){return this.each(function(){var el=$(this);var tag=this.tagName.toLowerCase();switch(tag){case 'input':this.checked=this.defaultChecked;case 'textarea':this.value=this.defaultValue;return!0;case 'option':case 'optgroup':var select=el.parents('select');if(select.length&&select[0].multiple){if(tag==='option'){this.selected=this.defaultSelected}else{el.find('option').resetForm()}}else{select.resetForm()}
return!0;case 'select':el.find('option').each(function(i){this.selected=this.defaultSelected;if(this.defaultSelected&&!el[0].multiple){el[0].selectedIndex=i;return!1}});return!0;case 'label':var forEl=$(el.attr('for'));var list=el.find('input,select,textarea');if(forEl[0]){list.unshift(forEl[0])}
list.resetForm();return!0;case 'form':if(typeof this.reset==='function'||(typeof this.reset==='object'&&!this.reset.nodeType)){this.reset()}
return!0;default:el.find('form,input,label,select,textarea').resetForm();return!0}})};$.fn.enable=function(b){if(typeof b==='undefined'){b=!0}
return this.each(function(){this.disabled=!b})};$.fn.selected=function(select){if(typeof select==='undefined'){select=!0}
return this.each(function(){var t=this.type;if(t==='checkbox'||t==='radio'){this.checked=select}else if(this.tagName.toLowerCase()==='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type==='select-one'){$sel.find('option').selected(!1)}
this.selected=select}})};$.fn.ajaxSubmit.debug=!1;function log(){if(!$.fn.ajaxSubmit.debug){return}
var msg='[jquery.form] '+Array.prototype.join.call(arguments,'');if(window.console&&window.console.log){window.console.log(msg)}else if(window.opera&&window.opera.postError){window.opera.postError(msg)}}}));!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):e.moment=t()}(this,function(){"use strict";var H;function _(){return H.apply(null,arguments)}function y(e){return e instanceof Array||"[object Array]"===Object.prototype.toString.call(e)}function F(e){return null!=e&&"[object Object]"===Object.prototype.toString.call(e)}function c(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function L(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;for(var t in e)if(c(e,t))return;return 1}function g(e){return void 0===e}function w(e){return"number"==typeof e||"[object Number]"===Object.prototype.toString.call(e)}function V(e){return e instanceof Date||"[object Date]"===Object.prototype.toString.call(e)}function G(e,t){for(var n=[],s=e.length,i=0;i<s;++i)n.push(t(e[i],i));return n}function E(e,t){for(var n in t)c(t,n)&&(e[n]=t[n]);return c(t,"toString")&&(e.toString=t.toString),c(t,"valueOf")&&(e.valueOf=t.valueOf),e}function l(e,t,n,s){return Wt(e,t,n,s,!0).utc()}function p(e){return null==e._pf&&(e._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}),e._pf}function A(e){var t,n,s=e._d&&!isNaN(e._d.getTime());return s&&(t=p(e),n=j.call(t.parsedDateParts,function(e){return null!=e}),s=t.overflow<0&&!t.empty&&!t.invalidEra&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&n),e._strict)&&(s=s&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour),null!=Object.isFrozen&&Object.isFrozen(e)?s:(e._isValid=s,e._isValid)}function I(e){var t=l(NaN);return null!=e?E(p(t),e):p(t).userInvalidated=!0,t}var j=Array.prototype.some||function(e){for(var t=Object(this),n=t.length>>>0,s=0;s<n;s++)if(s in t&&e.call(this,t[s],s,t))return!0;return!1},Z=_.momentProperties=[],z=!1;function q(e,t){var n,s,i,r=Z.length;if(g(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),g(t._i)||(e._i=t._i),g(t._f)||(e._f=t._f),g(t._l)||(e._l=t._l),g(t._strict)||(e._strict=t._strict),g(t._tzm)||(e._tzm=t._tzm),g(t._isUTC)||(e._isUTC=t._isUTC),g(t._offset)||(e._offset=t._offset),g(t._pf)||(e._pf=p(t)),g(t._locale)||(e._locale=t._locale),0<r)for(n=0;n<r;n++)g(i=t[s=Z[n]])||(e[s]=i);return e}function $(e){q(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===z&&(z=!0,_.updateOffset(this),z=!1)}function k(e){return e instanceof $||null!=e&&null!=e._isAMomentObject}function B(e){!1===_.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+e)}function e(r,a){var o=!0;return E(function(){if(null!=_.deprecationHandler&&_.deprecationHandler(null,r),o){for(var e,t,n=[],s=arguments.length,i=0;i<s;i++){if(e="","object"==typeof arguments[i]){for(t in e+="\n["+i+"] ",arguments[0])c(arguments[0],t)&&(e+=t+": "+arguments[0][t]+", ");e=e.slice(0,-2)}else e=arguments[i];n.push(e)}B(r+"\nArguments: "+Array.prototype.slice.call(n).join("")+"\n"+(new Error).stack),o=!1}return a.apply(this,arguments)},a)}var J={};function Q(e,t){null!=_.deprecationHandler&&_.deprecationHandler(e,t),J[e]||(B(t),J[e]=!0)}function a(e){return"undefined"!=typeof Function&&e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}function X(e,t){var n,s=E({},e);for(n in t)c(t,n)&&(F(e[n])&&F(t[n])?(s[n]={},E(s[n],e[n]),E(s[n],t[n])):null!=t[n]?s[n]=t[n]:delete s[n]);for(n in e)c(e,n)&&!c(t,n)&&F(e[n])&&(s[n]=E({},s[n]));return s}function K(e){null!=e&&this.set(e)}_.suppressDeprecationWarnings=!1,_.deprecationHandler=null;var ee=Object.keys||function(e){var t,n=[];for(t in e)c(e,t)&&n.push(t);return n};function r(e,t,n){var s=""+Math.abs(e);return(0<=e?n?"+":"":"-")+Math.pow(10,Math.max(0,t-s.length)).toString().substr(1)+s}var te=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,ne=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,se={},ie={};function s(e,t,n,s){var i="string"==typeof s?function(){return this[s]()}:s;e&&(ie[e]=i),t&&(ie[t[0]]=function(){return r(i.apply(this,arguments),t[1],t[2])}),n&&(ie[n]=function(){return this.localeData().ordinal(i.apply(this,arguments),e)})}function re(e,t){return e.isValid()?(t=ae(t,e.localeData()),se[t]=se[t]||function(s){for(var e,i=s.match(te),t=0,r=i.length;t<r;t++)ie[i[t]]?i[t]=ie[i[t]]:i[t]=(e=i[t]).match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"");return function(e){for(var t="",n=0;n<r;n++)t+=a(i[n])?i[n].call(e,s):i[n];return t}}(t),se[t](e)):e.localeData().invalidDate()}function ae(e,t){var n=5;function s(e){return t.longDateFormat(e)||e}for(ne.lastIndex=0;0<=n&&ne.test(e);)e=e.replace(ne,s),ne.lastIndex=0,--n;return e}var oe={D:"date",dates:"date",date:"date",d:"day",days:"day",day:"day",e:"weekday",weekdays:"weekday",weekday:"weekday",E:"isoWeekday",isoweekdays:"isoWeekday",isoweekday:"isoWeekday",DDD:"dayOfYear",dayofyears:"dayOfYear",dayofyear:"dayOfYear",h:"hour",hours:"hour",hour:"hour",ms:"millisecond",milliseconds:"millisecond",millisecond:"millisecond",m:"minute",minutes:"minute",minute:"minute",M:"month",months:"month",month:"month",Q:"quarter",quarters:"quarter",quarter:"quarter",s:"second",seconds:"second",second:"second",gg:"weekYear",weekyears:"weekYear",weekyear:"weekYear",GG:"isoWeekYear",isoweekyears:"isoWeekYear",isoweekyear:"isoWeekYear",w:"week",weeks:"week",week:"week",W:"isoWeek",isoweeks:"isoWeek",isoweek:"isoWeek",y:"year",years:"year",year:"year"};function o(e){return"string"==typeof e?oe[e]||oe[e.toLowerCase()]:void 0}function ue(e){var t,n,s={};for(n in e)c(e,n)&&(t=o(n))&&(s[t]=e[n]);return s}var le={date:9,day:11,weekday:11,isoWeekday:11,dayOfYear:4,hour:13,millisecond:16,minute:14,month:8,quarter:7,second:15,weekYear:1,isoWeekYear:1,week:5,isoWeek:5,year:1};var de=/\d/,t=/\d\d/,he=/\d{3}/,ce=/\d{4}/,fe=/[+-]?\d{6}/,n=/\d\d?/,me=/\d\d\d\d?/,_e=/\d\d\d\d\d\d?/,ye=/\d{1,3}/,ge=/\d{1,4}/,we=/[+-]?\d{1,6}/,pe=/\d+/,ke=/[+-]?\d+/,Me=/Z|[+-]\d\d:?\d\d/gi,ve=/Z|[+-]\d\d(?::?\d\d)?/gi,i=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,u=/^[1-9]\d?/,d=/^([1-9]\d|\d)/;function h(e,n,s){Ye[e]=a(n)?n:function(e,t){return e&&s?s:n}}function De(e,t){return c(Ye,e)?Ye[e](t._strict,t._locale):new RegExp(f(e.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(e,t,n,s,i){return t||n||s||i})))}function f(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function m(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function M(e){var e=+e,t=0;return t=0!=e&&isFinite(e)?m(e):t}var Ye={},Se={};function v(e,n){var t,s,i=n;for("string"==typeof e&&(e=[e]),w(n)&&(i=function(e,t){t[n]=M(e)}),s=e.length,t=0;t<s;t++)Se[e[t]]=i}function Oe(e,i){v(e,function(e,t,n,s){n._w=n._w||{},i(e,n._w,n,s)})}function be(e){return e%4==0&&e%100!=0||e%400==0}var D=0,Y=1,S=2,O=3,b=4,T=5,Te=6,xe=7,Ne=8;function We(e){return be(e)?366:365}s("Y",0,0,function(){var e=this.year();return e<=9999?r(e,4):"+"+e}),s(0,["YY",2],0,function(){return this.year()%100}),s(0,["YYYY",4],0,"year"),s(0,["YYYYY",5],0,"year"),s(0,["YYYYYY",6,!0],0,"year"),h("Y",ke),h("YY",n,t),h("YYYY",ge,ce),h("YYYYY",we,fe),h("YYYYYY",we,fe),v(["YYYYY","YYYYYY"],D),v("YYYY",function(e,t){t[D]=2===e.length?_.parseTwoDigitYear(e):M(e)}),v("YY",function(e,t){t[D]=_.parseTwoDigitYear(e)}),v("Y",function(e,t){t[D]=parseInt(e,10)}),_.parseTwoDigitYear=function(e){return M(e)+(68<M(e)?1900:2e3)};var x,Pe=Re("FullYear",!0);function Re(t,n){return function(e){return null!=e?(Ue(this,t,e),_.updateOffset(this,n),this):Ce(this,t)}}function Ce(e,t){if(!e.isValid())return NaN;var n=e._d,s=e._isUTC;switch(t){case"Milliseconds":return s?n.getUTCMilliseconds():n.getMilliseconds();case"Seconds":return s?n.getUTCSeconds():n.getSeconds();case"Minutes":return s?n.getUTCMinutes():n.getMinutes();case"Hours":return s?n.getUTCHours():n.getHours();case"Date":return s?n.getUTCDate():n.getDate();case"Day":return s?n.getUTCDay():n.getDay();case"Month":return s?n.getUTCMonth():n.getMonth();case"FullYear":return s?n.getUTCFullYear():n.getFullYear();default:return NaN}}function Ue(e,t,n){var s,i,r;if(e.isValid()&&!isNaN(n)){switch(s=e._d,i=e._isUTC,t){case"Milliseconds":return i?s.setUTCMilliseconds(n):s.setMilliseconds(n);case"Seconds":return i?s.setUTCSeconds(n):s.setSeconds(n);case"Minutes":return i?s.setUTCMinutes(n):s.setMinutes(n);case"Hours":return i?s.setUTCHours(n):s.setHours(n);case"Date":return i?s.setUTCDate(n):s.setDate(n);case"FullYear":break;default:return}t=n,r=e.month(),e=29!==(e=e.date())||1!==r||be(t)?e:28,i?s.setUTCFullYear(t,r,e):s.setFullYear(t,r,e)}}function He(e,t){var n;return isNaN(e)||isNaN(t)?NaN:(n=(t%(n=12)+n)%n,e+=(t-n)/12,1==n?be(e)?29:28:31-n%7%2)}x=Array.prototype.indexOf||function(e){for(var t=0;t<this.length;++t)if(this[t]===e)return t;return-1},s("M",["MM",2],"Mo",function(){return this.month()+1}),s("MMM",0,0,function(e){return this.localeData().monthsShort(this,e)}),s("MMMM",0,0,function(e){return this.localeData().months(this,e)}),h("M",n,u),h("MM",n,t),h("MMM",function(e,t){return t.monthsShortRegex(e)}),h("MMMM",function(e,t){return t.monthsRegex(e)}),v(["M","MM"],function(e,t){t[Y]=M(e)-1}),v(["MMM","MMMM"],function(e,t,n,s){s=n._locale.monthsParse(e,s,n._strict);null!=s?t[Y]=s:p(n).invalidMonth=e});var Fe="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),Le="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),Ve=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,Ge=i,Ee=i;function Ae(e,t){if(e.isValid()){if("string"==typeof t)if(/^\d+$/.test(t))t=M(t);else if(!w(t=e.localeData().monthsParse(t)))return;var n=(n=e.date())<29?n:Math.min(n,He(e.year(),t));e._isUTC?e._d.setUTCMonth(t,n):e._d.setMonth(t,n)}}function Ie(e){return null!=e?(Ae(this,e),_.updateOffset(this,!0),this):Ce(this,"Month")}function je(){function e(e,t){return t.length-e.length}for(var t,n,s=[],i=[],r=[],a=0;a<12;a++)n=l([2e3,a]),t=f(this.monthsShort(n,"")),n=f(this.months(n,"")),s.push(t),i.push(n),r.push(n),r.push(t);s.sort(e),i.sort(e),r.sort(e),this._monthsRegex=new RegExp("^("+r.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+i.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+s.join("|")+")","i")}function Ze(e,t,n,s,i,r,a){var o;return e<100&&0<=e?(o=new Date(e+400,t,n,s,i,r,a),isFinite(o.getFullYear())&&o.setFullYear(e)):o=new Date(e,t,n,s,i,r,a),o}function ze(e){var t;return e<100&&0<=e?((t=Array.prototype.slice.call(arguments))[0]=e+400,t=new Date(Date.UTC.apply(null,t)),isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e)):t=new Date(Date.UTC.apply(null,arguments)),t}function qe(e,t,n){n=7+t-n;return n-(7+ze(e,0,n).getUTCDay()-t)%7-1}function $e(e,t,n,s,i){var r,t=1+7*(t-1)+(7+n-s)%7+qe(e,s,i),n=t<=0?We(r=e-1)+t:t>We(e)?(r=e+1,t-We(e)):(r=e,t);return{year:r,dayOfYear:n}}function Be(e,t,n){var s,i,r=qe(e.year(),t,n),r=Math.floor((e.dayOfYear()-r-1)/7)+1;return r<1?s=r+N(i=e.year()-1,t,n):r>N(e.year(),t,n)?(s=r-N(e.year(),t,n),i=e.year()+1):(i=e.year(),s=r),{week:s,year:i}}function N(e,t,n){var s=qe(e,t,n),t=qe(e+1,t,n);return(We(e)-s+t)/7}s("w",["ww",2],"wo","week"),s("W",["WW",2],"Wo","isoWeek"),h("w",n,u),h("ww",n,t),h("W",n,u),h("WW",n,t),Oe(["w","ww","W","WW"],function(e,t,n,s){t[s.substr(0,1)]=M(e)});function Je(e,t){return e.slice(t,7).concat(e.slice(0,t))}s("d",0,"do","day"),s("dd",0,0,function(e){return this.localeData().weekdaysMin(this,e)}),s("ddd",0,0,function(e){return this.localeData().weekdaysShort(this,e)}),s("dddd",0,0,function(e){return this.localeData().weekdays(this,e)}),s("e",0,0,"weekday"),s("E",0,0,"isoWeekday"),h("d",n),h("e",n),h("E",n),h("dd",function(e,t){return t.weekdaysMinRegex(e)}),h("ddd",function(e,t){return t.weekdaysShortRegex(e)}),h("dddd",function(e,t){return t.weekdaysRegex(e)}),Oe(["dd","ddd","dddd"],function(e,t,n,s){s=n._locale.weekdaysParse(e,s,n._strict);null!=s?t.d=s:p(n).invalidWeekday=e}),Oe(["d","e","E"],function(e,t,n,s){t[s]=M(e)});var Qe="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Xe="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),Ke="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),et=i,tt=i,nt=i;function st(){function e(e,t){return t.length-e.length}for(var t,n,s,i=[],r=[],a=[],o=[],u=0;u<7;u++)s=l([2e3,1]).day(u),t=f(this.weekdaysMin(s,"")),n=f(this.weekdaysShort(s,"")),s=f(this.weekdays(s,"")),i.push(t),r.push(n),a.push(s),o.push(t),o.push(n),o.push(s);i.sort(e),r.sort(e),a.sort(e),o.sort(e),this._weekdaysRegex=new RegExp("^("+o.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+r.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+i.join("|")+")","i")}function it(){return this.hours()%12||12}function rt(e,t){s(e,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)})}function at(e,t){return t._meridiemParse}s("H",["HH",2],0,"hour"),s("h",["hh",2],0,it),s("k",["kk",2],0,function(){return this.hours()||24}),s("hmm",0,0,function(){return""+it.apply(this)+r(this.minutes(),2)}),s("hmmss",0,0,function(){return""+it.apply(this)+r(this.minutes(),2)+r(this.seconds(),2)}),s("Hmm",0,0,function(){return""+this.hours()+r(this.minutes(),2)}),s("Hmmss",0,0,function(){return""+this.hours()+r(this.minutes(),2)+r(this.seconds(),2)}),rt("a",!0),rt("A",!1),h("a",at),h("A",at),h("H",n,d),h("h",n,u),h("k",n,u),h("HH",n,t),h("hh",n,t),h("kk",n,t),h("hmm",me),h("hmmss",_e),h("Hmm",me),h("Hmmss",_e),v(["H","HH"],O),v(["k","kk"],function(e,t,n){e=M(e);t[O]=24===e?0:e}),v(["a","A"],function(e,t,n){n._isPm=n._locale.isPM(e),n._meridiem=e}),v(["h","hh"],function(e,t,n){t[O]=M(e),p(n).bigHour=!0}),v("hmm",function(e,t,n){var s=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s)),p(n).bigHour=!0}),v("hmmss",function(e,t,n){var s=e.length-4,i=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s,2)),t[T]=M(e.substr(i)),p(n).bigHour=!0}),v("Hmm",function(e,t,n){var s=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s))}),v("Hmmss",function(e,t,n){var s=e.length-4,i=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s,2)),t[T]=M(e.substr(i))});i=Re("Hours",!0);var ot,ut={calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},longDateFormat:{LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},invalidDate:"Invalid date",ordinal:"%d",dayOfMonthOrdinalParse:/\d{1,2}/,relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",w:"a week",ww:"%d weeks",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},months:Fe,monthsShort:Le,week:{dow:0,doy:6},weekdays:Qe,weekdaysMin:Ke,weekdaysShort:Xe,meridiemParse:/[ap]\.?m?\.?/i},W={},lt={};function dt(e){return e&&e.toLowerCase().replace("_","-")}function ht(e){for(var t,n,s,i,r=0;r<e.length;){for(t=(i=dt(e[r]).split("-")).length,n=(n=dt(e[r+1]))?n.split("-"):null;0<t;){if(s=ct(i.slice(0,t).join("-")))return s;if(n&&n.length>=t&&function(e,t){for(var n=Math.min(e.length,t.length),s=0;s<n;s+=1)if(e[s]!==t[s])return s;return n}(i,n)>=t-1)break;t--}r++}return ot}function ct(t){var e,n;if(void 0===W[t]&&"undefined"!=typeof module&&module&&module.exports&&(n=t)&&n.match("^[^/\\\\]*$"))try{e=ot._abbr,require("./locale/"+t),ft(e)}catch(e){W[t]=null}return W[t]}function ft(e,t){return e&&((t=g(t)?P(e):mt(e,t))?ot=t:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+e+" not found. Did you forget to load it?")),ot._abbr}function mt(e,t){if(null===t)return delete W[e],null;var n,s=ut;if(t.abbr=e,null!=W[e])Q("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),s=W[e]._config;else if(null!=t.parentLocale)if(null!=W[t.parentLocale])s=W[t.parentLocale]._config;else{if(null==(n=ct(t.parentLocale)))return lt[t.parentLocale]||(lt[t.parentLocale]=[]),lt[t.parentLocale].push({name:e,config:t}),null;s=n._config}return W[e]=new K(X(s,t)),lt[e]&&lt[e].forEach(function(e){mt(e.name,e.config)}),ft(e),W[e]}function P(e){var t;if(!(e=e&&e._locale&&e._locale._abbr?e._locale._abbr:e))return ot;if(!y(e)){if(t=ct(e))return t;e=[e]}return ht(e)}function _t(e){var t=e._a;return t&&-2===p(e).overflow&&(t=t[Y]<0||11<t[Y]?Y:t[S]<1||t[S]>He(t[D],t[Y])?S:t[O]<0||24<t[O]||24===t[O]&&(0!==t[b]||0!==t[T]||0!==t[Te])?O:t[b]<0||59<t[b]?b:t[T]<0||59<t[T]?T:t[Te]<0||999<t[Te]?Te:-1,p(e)._overflowDayOfYear&&(t<D||S<t)&&(t=S),p(e)._overflowWeeks&&-1===t&&(t=xe),p(e)._overflowWeekday&&-1===t&&(t=Ne),p(e).overflow=t),e}var yt=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,gt=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,wt=/Z|[+-]\d\d(?::?\d\d)?/,pt=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/],["YYYYMM",/\d{6}/,!1],["YYYY",/\d{4}/,!1]],kt=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Mt=/^\/?Date\((-?\d+)/i,vt=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,Dt={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function Yt(e){var t,n,s,i,r,a,o=e._i,u=yt.exec(o)||gt.exec(o),o=pt.length,l=kt.length;if(u){for(p(e).iso=!0,t=0,n=o;t<n;t++)if(pt[t][1].exec(u[1])){i=pt[t][0],s=!1!==pt[t][2];break}if(null==i)e._isValid=!1;else{if(u[3]){for(t=0,n=l;t<n;t++)if(kt[t][1].exec(u[3])){r=(u[2]||" ")+kt[t][0];break}if(null==r)return void(e._isValid=!1)}if(s||null==r){if(u[4]){if(!wt.exec(u[4]))return void(e._isValid=!1);a="Z"}e._f=i+(r||"")+(a||""),xt(e)}else e._isValid=!1}}else e._isValid=!1}function St(e,t,n,s,i,r){e=[function(e){e=parseInt(e,10);{if(e<=49)return 2e3+e;if(e<=999)return 1900+e}return e}(e),Le.indexOf(t),parseInt(n,10),parseInt(s,10),parseInt(i,10)];return r&&e.push(parseInt(r,10)),e}function Ot(e){var t,n,s=vt.exec(e._i.replace(/\([^()]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,""));s?(t=St(s[4],s[3],s[2],s[5],s[6],s[7]),function(e,t,n){if(!e||Xe.indexOf(e)===new Date(t[0],t[1],t[2]).getDay())return 1;p(n).weekdayMismatch=!0,n._isValid=!1}(s[1],t,e)&&(e._a=t,e._tzm=(t=s[8],n=s[9],s=s[10],t?Dt[t]:n?0:60*(((t=parseInt(s,10))-(n=t%100))/100)+n),e._d=ze.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),p(e).rfc2822=!0)):e._isValid=!1}function bt(e,t,n){return null!=e?e:null!=t?t:n}function Tt(e){var t,n,s,i,r,a,o,u,l,d,h,c=[];if(!e._d){for(s=e,i=new Date(_.now()),n=s._useUTC?[i.getUTCFullYear(),i.getUTCMonth(),i.getUTCDate()]:[i.getFullYear(),i.getMonth(),i.getDate()],e._w&&null==e._a[S]&&null==e._a[Y]&&(null!=(i=(s=e)._w).GG||null!=i.W||null!=i.E?(u=1,l=4,r=bt(i.GG,s._a[D],Be(R(),1,4).year),a=bt(i.W,1),((o=bt(i.E,1))<1||7<o)&&(d=!0)):(u=s._locale._week.dow,l=s._locale._week.doy,h=Be(R(),u,l),r=bt(i.gg,s._a[D],h.year),a=bt(i.w,h.week),null!=i.d?((o=i.d)<0||6<o)&&(d=!0):null!=i.e?(o=i.e+u,(i.e<0||6<i.e)&&(d=!0)):o=u),a<1||a>N(r,u,l)?p(s)._overflowWeeks=!0:null!=d?p(s)._overflowWeekday=!0:(h=$e(r,a,o,u,l),s._a[D]=h.year,s._dayOfYear=h.dayOfYear)),null!=e._dayOfYear&&(i=bt(e._a[D],n[D]),(e._dayOfYear>We(i)||0===e._dayOfYear)&&(p(e)._overflowDayOfYear=!0),d=ze(i,0,e._dayOfYear),e._a[Y]=d.getUTCMonth(),e._a[S]=d.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=c[t]=n[t];for(;t<7;t++)e._a[t]=c[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[O]&&0===e._a[b]&&0===e._a[T]&&0===e._a[Te]&&(e._nextDay=!0,e._a[O]=0),e._d=(e._useUTC?ze:Ze).apply(null,c),r=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[O]=24),e._w&&void 0!==e._w.d&&e._w.d!==r&&(p(e).weekdayMismatch=!0)}}function xt(e){if(e._f===_.ISO_8601)Yt(e);else if(e._f===_.RFC_2822)Ot(e);else{e._a=[],p(e).empty=!0;for(var t,n,s,i,r,a=""+e._i,o=a.length,u=0,l=ae(e._f,e._locale).match(te)||[],d=l.length,h=0;h<d;h++)n=l[h],(t=(a.match(De(n,e))||[])[0])&&(0<(s=a.substr(0,a.indexOf(t))).length&&p(e).unusedInput.push(s),a=a.slice(a.indexOf(t)+t.length),u+=t.length),ie[n]?(t?p(e).empty=!1:p(e).unusedTokens.push(n),s=n,r=e,null!=(i=t)&&c(Se,s)&&Se[s](i,r._a,r,s)):e._strict&&!t&&p(e).unusedTokens.push(n);p(e).charsLeftOver=o-u,0<a.length&&p(e).unusedInput.push(a),e._a[O]<=12&&!0===p(e).bigHour&&0<e._a[O]&&(p(e).bigHour=void 0),p(e).parsedDateParts=e._a.slice(0),p(e).meridiem=e._meridiem,e._a[O]=function(e,t,n){if(null==n)return t;return null!=e.meridiemHour?e.meridiemHour(t,n):null!=e.isPM?((e=e.isPM(n))&&t<12&&(t+=12),t=e||12!==t?t:0):t}(e._locale,e._a[O],e._meridiem),null!==(o=p(e).era)&&(e._a[D]=e._locale.erasConvertYear(o,e._a[D])),Tt(e),_t(e)}}function Nt(e){var t,n,s,i=e._i,r=e._f;if(e._locale=e._locale||P(e._l),null===i||void 0===r&&""===i)return I({nullInput:!0});if("string"==typeof i&&(e._i=i=e._locale.preparse(i)),k(i))return new $(_t(i));if(V(i))e._d=i;else if(y(r)){var a,o,u,l,d,h,c=e,f=!1,m=c._f.length;if(0===m)p(c).invalidFormat=!0,c._d=new Date(NaN);else{for(l=0;l<m;l++)d=0,h=!1,a=q({},c),null!=c._useUTC&&(a._useUTC=c._useUTC),a._f=c._f[l],xt(a),A(a)&&(h=!0),d=(d+=p(a).charsLeftOver)+10*p(a).unusedTokens.length,p(a).score=d,f?d<u&&(u=d,o=a):(null==u||d<u||h)&&(u=d,o=a,h)&&(f=!0);E(c,o||a)}}else if(r)xt(e);else if(g(r=(i=e)._i))i._d=new Date(_.now());else V(r)?i._d=new Date(r.valueOf()):"string"==typeof r?(n=i,null!==(t=Mt.exec(n._i))?n._d=new Date(+t[1]):(Yt(n),!1===n._isValid&&(delete n._isValid,Ot(n),!1===n._isValid)&&(delete n._isValid,n._strict?n._isValid=!1:_.createFromInputFallback(n)))):y(r)?(i._a=G(r.slice(0),function(e){return parseInt(e,10)}),Tt(i)):F(r)?(t=i)._d||(s=void 0===(n=ue(t._i)).day?n.date:n.day,t._a=G([n.year,n.month,s,n.hour,n.minute,n.second,n.millisecond],function(e){return e&&parseInt(e,10)}),Tt(t)):w(r)?i._d=new Date(r):_.createFromInputFallback(i);return A(e)||(e._d=null),e}function Wt(e,t,n,s,i){var r={};return!0!==t&&!1!==t||(s=t,t=void 0),!0!==n&&!1!==n||(s=n,n=void 0),(F(e)&&L(e)||y(e)&&0===e.length)&&(e=void 0),r._isAMomentObject=!0,r._useUTC=r._isUTC=i,r._l=n,r._i=e,r._f=t,r._strict=s,(i=new $(_t(Nt(i=r))))._nextDay&&(i.add(1,"d"),i._nextDay=void 0),i}function R(e,t,n,s){return Wt(e,t,n,s,!1)}_.createFromInputFallback=e("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(e){e._d=new Date(e._i+(e._useUTC?" UTC":""))}),_.ISO_8601=function(){},_.RFC_2822=function(){};me=e("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var e=R.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:I()}),_e=e("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var e=R.apply(null,arguments);return this.isValid()&&e.isValid()?this<e?this:e:I()});function Pt(e,t){var n,s;if(!(t=1===t.length&&y(t[0])?t[0]:t).length)return R();for(n=t[0],s=1;s<t.length;++s)t[s].isValid()&&!t[s][e](n)||(n=t[s]);return n}var Rt=["year","quarter","month","week","day","hour","minute","second","millisecond"];function Ct(e){var e=ue(e),t=e.year||0,n=e.quarter||0,s=e.month||0,i=e.week||e.isoWeek||0,r=e.day||0,a=e.hour||0,o=e.minute||0,u=e.second||0,l=e.millisecond||0;this._isValid=function(e){var t,n,s=!1,i=Rt.length;for(t in e)if(c(e,t)&&(-1===x.call(Rt,t)||null!=e[t]&&isNaN(e[t])))return!1;for(n=0;n<i;++n)if(e[Rt[n]]){if(s)return!1;parseFloat(e[Rt[n]])!==M(e[Rt[n]])&&(s=!0)}return!0}(e),this._milliseconds=+l+1e3*u+6e4*o+1e3*a*60*60,this._days=+r+7*i,this._months=+s+3*n+12*t,this._data={},this._locale=P(),this._bubble()}function Ut(e){return e instanceof Ct}function Ht(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function Ft(e,n){s(e,0,0,function(){var e=this.utcOffset(),t="+";return e<0&&(e=-e,t="-"),t+r(~~(e/60),2)+n+r(~~e%60,2)})}Ft("Z",":"),Ft("ZZ",""),h("Z",ve),h("ZZ",ve),v(["Z","ZZ"],function(e,t,n){n._useUTC=!0,n._tzm=Vt(ve,e)});var Lt=/([\+\-]|\d\d)/gi;function Vt(e,t){var t=(t||"").match(e);return null===t?null:0===(t=60*(e=((t[t.length-1]||[])+"").match(Lt)||["-",0,0])[1]+M(e[2]))?0:"+"===e[0]?t:-t}function Gt(e,t){var n;return t._isUTC?(t=t.clone(),n=(k(e)||V(e)?e:R(e)).valueOf()-t.valueOf(),t._d.setTime(t._d.valueOf()+n),_.updateOffset(t,!1),t):R(e).local()}function Et(e){return-Math.round(e._d.getTimezoneOffset())}function At(){return!!this.isValid()&&this._isUTC&&0===this._offset}_.updateOffset=function(){};var It=/^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,jt=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function C(e,t){var n,s=e;return Ut(e)?s={ms:e._milliseconds,d:e._days,M:e._months}:w(e)||!isNaN(+e)?(s={},t?s[t]=+e:s.milliseconds=+e):(t=It.exec(e))?(n="-"===t[1]?-1:1,s={y:0,d:M(t[S])*n,h:M(t[O])*n,m:M(t[b])*n,s:M(t[T])*n,ms:M(Ht(1e3*t[Te]))*n}):(t=jt.exec(e))?(n="-"===t[1]?-1:1,s={y:Zt(t[2],n),M:Zt(t[3],n),w:Zt(t[4],n),d:Zt(t[5],n),h:Zt(t[6],n),m:Zt(t[7],n),s:Zt(t[8],n)}):null==s?s={}:"object"==typeof s&&("from"in s||"to"in s)&&(t=function(e,t){var n;if(!e.isValid()||!t.isValid())return{milliseconds:0,months:0};t=Gt(t,e),e.isBefore(t)?n=zt(e,t):((n=zt(t,e)).milliseconds=-n.milliseconds,n.months=-n.months);return n}(R(s.from),R(s.to)),(s={}).ms=t.milliseconds,s.M=t.months),n=new Ct(s),Ut(e)&&c(e,"_locale")&&(n._locale=e._locale),Ut(e)&&c(e,"_isValid")&&(n._isValid=e._isValid),n}function Zt(e,t){e=e&&parseFloat(e.replace(",","."));return(isNaN(e)?0:e)*t}function zt(e,t){var n={};return n.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(n.months,"M").isAfter(t)&&--n.months,n.milliseconds=+t-+e.clone().add(n.months,"M"),n}function qt(s,i){return function(e,t){var n;return null===t||isNaN(+t)||(Q(i,"moment()."+i+"(period, number) is deprecated. Please use moment()."+i+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),n=e,e=t,t=n),$t(this,C(e,t),s),this}}function $t(e,t,n,s){var i=t._milliseconds,r=Ht(t._days),t=Ht(t._months);e.isValid()&&(s=null==s||s,t&&Ae(e,Ce(e,"Month")+t*n),r&&Ue(e,"Date",Ce(e,"Date")+r*n),i&&e._d.setTime(e._d.valueOf()+i*n),s)&&_.updateOffset(e,r||t)}C.fn=Ct.prototype,C.invalid=function(){return C(NaN)};Fe=qt(1,"add"),Qe=qt(-1,"subtract");function Bt(e){return"string"==typeof e||e instanceof String}function Jt(e){return k(e)||V(e)||Bt(e)||w(e)||function(t){var e=y(t),n=!1;e&&(n=0===t.filter(function(e){return!w(e)&&Bt(t)}).length);return e&&n}(e)||function(e){var t,n,s=F(e)&&!L(e),i=!1,r=["years","year","y","months","month","M","days","day","d","dates","date","D","hours","hour","h","minutes","minute","m","seconds","second","s","milliseconds","millisecond","ms"],a=r.length;for(t=0;t<a;t+=1)n=r[t],i=i||c(e,n);return s&&i}(e)||null==e}function Qt(e,t){var n,s;return e.date()<t.date()?-Qt(t,e):-((n=12*(t.year()-e.year())+(t.month()-e.month()))+(t-(s=e.clone().add(n,"months"))<0?(t-s)/(s-e.clone().add(n-1,"months")):(t-s)/(e.clone().add(1+n,"months")-s)))||0}function Xt(e){return void 0===e?this._locale._abbr:(null!=(e=P(e))&&(this._locale=e),this)}_.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",_.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";Ke=e("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(e){return void 0===e?this.localeData():this.locale(e)});function Kt(){return this._locale}var en=126227808e5;function tn(e,t){return(e%t+t)%t}function nn(e,t,n){return e<100&&0<=e?new Date(e+400,t,n)-en:new Date(e,t,n).valueOf()}function sn(e,t,n){return e<100&&0<=e?Date.UTC(e+400,t,n)-en:Date.UTC(e,t,n)}function rn(e,t){return t.erasAbbrRegex(e)}function an(){for(var e,t,n,s=[],i=[],r=[],a=[],o=this.eras(),u=0,l=o.length;u<l;++u)e=f(o[u].name),t=f(o[u].abbr),n=f(o[u].narrow),i.push(e),s.push(t),r.push(n),a.push(e),a.push(t),a.push(n);this._erasRegex=new RegExp("^("+a.join("|")+")","i"),this._erasNameRegex=new RegExp("^("+i.join("|")+")","i"),this._erasAbbrRegex=new RegExp("^("+s.join("|")+")","i"),this._erasNarrowRegex=new RegExp("^("+r.join("|")+")","i")}function on(e,t){s(0,[e,e.length],0,t)}function un(e,t,n,s,i){var r;return null==e?Be(this,s,i).year:(r=N(e,s,i),function(e,t,n,s,i){e=$e(e,t,n,s,i),t=ze(e.year,0,e.dayOfYear);return this.year(t.getUTCFullYear()),this.month(t.getUTCMonth()),this.date(t.getUTCDate()),this}.call(this,e,t=r<t?r:t,n,s,i))}s("N",0,0,"eraAbbr"),s("NN",0,0,"eraAbbr"),s("NNN",0,0,"eraAbbr"),s("NNNN",0,0,"eraName"),s("NNNNN",0,0,"eraNarrow"),s("y",["y",1],"yo","eraYear"),s("y",["yy",2],0,"eraYear"),s("y",["yyy",3],0,"eraYear"),s("y",["yyyy",4],0,"eraYear"),h("N",rn),h("NN",rn),h("NNN",rn),h("NNNN",function(e,t){return t.erasNameRegex(e)}),h("NNNNN",function(e,t){return t.erasNarrowRegex(e)}),v(["N","NN","NNN","NNNN","NNNNN"],function(e,t,n,s){s=n._locale.erasParse(e,s,n._strict);s?p(n).era=s:p(n).invalidEra=e}),h("y",pe),h("yy",pe),h("yyy",pe),h("yyyy",pe),h("yo",function(e,t){return t._eraYearOrdinalRegex||pe}),v(["y","yy","yyy","yyyy"],D),v(["yo"],function(e,t,n,s){var i;n._locale._eraYearOrdinalRegex&&(i=e.match(n._locale._eraYearOrdinalRegex)),n._locale.eraYearOrdinalParse?t[D]=n._locale.eraYearOrdinalParse(e,i):t[D]=parseInt(e,10)}),s(0,["gg",2],0,function(){return this.weekYear()%100}),s(0,["GG",2],0,function(){return this.isoWeekYear()%100}),on("gggg","weekYear"),on("ggggg","weekYear"),on("GGGG","isoWeekYear"),on("GGGGG","isoWeekYear"),h("G",ke),h("g",ke),h("GG",n,t),h("gg",n,t),h("GGGG",ge,ce),h("gggg",ge,ce),h("GGGGG",we,fe),h("ggggg",we,fe),Oe(["gggg","ggggg","GGGG","GGGGG"],function(e,t,n,s){t[s.substr(0,2)]=M(e)}),Oe(["gg","GG"],function(e,t,n,s){t[s]=_.parseTwoDigitYear(e)}),s("Q",0,"Qo","quarter"),h("Q",de),v("Q",function(e,t){t[Y]=3*(M(e)-1)}),s("D",["DD",2],"Do","date"),h("D",n,u),h("DD",n,t),h("Do",function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient}),v(["D","DD"],S),v("Do",function(e,t){t[S]=M(e.match(n)[0])});ge=Re("Date",!0);s("DDD",["DDDD",3],"DDDo","dayOfYear"),h("DDD",ye),h("DDDD",he),v(["DDD","DDDD"],function(e,t,n){n._dayOfYear=M(e)}),s("m",["mm",2],0,"minute"),h("m",n,d),h("mm",n,t),v(["m","mm"],b);var ln,ce=Re("Minutes",!1),we=(s("s",["ss",2],0,"second"),h("s",n,d),h("ss",n,t),v(["s","ss"],T),Re("Seconds",!1));for(s("S",0,0,function(){return~~(this.millisecond()/100)}),s(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),s(0,["SSS",3],0,"millisecond"),s(0,["SSSS",4],0,function(){return 10*this.millisecond()}),s(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),s(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),s(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),s(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),s(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),h("S",ye,de),h("SS",ye,t),h("SSS",ye,he),ln="SSSS";ln.length<=9;ln+="S")h(ln,pe);function dn(e,t){t[Te]=M(1e3*("0."+e))}for(ln="S";ln.length<=9;ln+="S")v(ln,dn);fe=Re("Milliseconds",!1),s("z",0,0,"zoneAbbr"),s("zz",0,0,"zoneName");u=$.prototype;function hn(e){return e}u.add=Fe,u.calendar=function(e,t){1===arguments.length&&(arguments[0]?Jt(arguments[0])?(e=arguments[0],t=void 0):function(e){for(var t=F(e)&&!L(e),n=!1,s=["sameDay","nextDay","lastDay","nextWeek","lastWeek","sameElse"],i=0;i<s.length;i+=1)n=n||c(e,s[i]);return t&&n}(arguments[0])&&(t=arguments[0],e=void 0):t=e=void 0);var e=e||R(),n=Gt(e,this).startOf("day"),n=_.calendarFormat(this,n)||"sameElse",t=t&&(a(t[n])?t[n].call(this,e):t[n]);return this.format(t||this.localeData().calendar(n,this,R(e)))},u.clone=function(){return new $(this)},u.diff=function(e,t,n){var s,i,r;if(!this.isValid())return NaN;if(!(s=Gt(e,this)).isValid())return NaN;switch(i=6e4*(s.utcOffset()-this.utcOffset()),t=o(t)){case"year":r=Qt(this,s)/12;break;case"month":r=Qt(this,s);break;case"quarter":r=Qt(this,s)/3;break;case"second":r=(this-s)/1e3;break;case"minute":r=(this-s)/6e4;break;case"hour":r=(this-s)/36e5;break;case"day":r=(this-s-i)/864e5;break;case"week":r=(this-s-i)/6048e5;break;default:r=this-s}return n?r:m(r)},u.endOf=function(e){var t,n;if(void 0!==(e=o(e))&&"millisecond"!==e&&this.isValid()){switch(n=this._isUTC?sn:nn,e){case"year":t=n(this.year()+1,0,1)-1;break;case"quarter":t=n(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":t=n(this.year(),this.month()+1,1)-1;break;case"week":t=n(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":t=n(this.year(),this.month(),this.date()+1)-1;break;case"hour":t=this._d.valueOf(),t+=36e5-tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5)-1;break;case"minute":t=this._d.valueOf(),t+=6e4-tn(t,6e4)-1;break;case"second":t=this._d.valueOf(),t+=1e3-tn(t,1e3)-1;break}this._d.setTime(t),_.updateOffset(this,!0)}return this},u.format=function(e){return e=e||(this.isUtc()?_.defaultFormatUtc:_.defaultFormat),e=re(this,e),this.localeData().postformat(e)},u.from=function(e,t){return this.isValid()&&(k(e)&&e.isValid()||R(e).isValid())?C({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},u.fromNow=function(e){return this.from(R(),e)},u.to=function(e,t){return this.isValid()&&(k(e)&&e.isValid()||R(e).isValid())?C({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},u.toNow=function(e){return this.to(R(),e)},u.get=function(e){return a(this[e=o(e)])?this[e]():this},u.invalidAt=function(){return p(this).overflow},u.isAfter=function(e,t){return e=k(e)?e:R(e),!(!this.isValid()||!e.isValid())&&("millisecond"===(t=o(t)||"millisecond")?this.valueOf()>e.valueOf():e.valueOf()<this.clone().startOf(t).valueOf())},u.isBefore=function(e,t){return e=k(e)?e:R(e),!(!this.isValid()||!e.isValid())&&("millisecond"===(t=o(t)||"millisecond")?this.valueOf()<e.valueOf():this.clone().endOf(t).valueOf()<e.valueOf())},u.isBetween=function(e,t,n,s){return e=k(e)?e:R(e),t=k(t)?t:R(t),!!(this.isValid()&&e.isValid()&&t.isValid())&&("("===(s=s||"()")[0]?this.isAfter(e,n):!this.isBefore(e,n))&&(")"===s[1]?this.isBefore(t,n):!this.isAfter(t,n))},u.isSame=function(e,t){var e=k(e)?e:R(e);return!(!this.isValid()||!e.isValid())&&("millisecond"===(t=o(t)||"millisecond")?this.valueOf()===e.valueOf():(e=e.valueOf(),this.clone().startOf(t).valueOf()<=e&&e<=this.clone().endOf(t).valueOf()))},u.isSameOrAfter=function(e,t){return this.isSame(e,t)||this.isAfter(e,t)},u.isSameOrBefore=function(e,t){return this.isSame(e,t)||this.isBefore(e,t)},u.isValid=function(){return A(this)},u.lang=Ke,u.locale=Xt,u.localeData=Kt,u.max=_e,u.min=me,u.parsingFlags=function(){return E({},p(this))},u.set=function(e,t){if("object"==typeof e)for(var n=function(e){var t,n=[];for(t in e)c(e,t)&&n.push({unit:t,priority:le[t]});return n.sort(function(e,t){return e.priority-t.priority}),n}(e=ue(e)),s=n.length,i=0;i<s;i++)this[n[i].unit](e[n[i].unit]);else if(a(this[e=o(e)]))return this[e](t);return this},u.startOf=function(e){var t,n;if(void 0!==(e=o(e))&&"millisecond"!==e&&this.isValid()){switch(n=this._isUTC?sn:nn,e){case"year":t=n(this.year(),0,1);break;case"quarter":t=n(this.year(),this.month()-this.month()%3,1);break;case"month":t=n(this.year(),this.month(),1);break;case"week":t=n(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":t=n(this.year(),this.month(),this.date());break;case"hour":t=this._d.valueOf(),t-=tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5);break;case"minute":t=this._d.valueOf(),t-=tn(t,6e4);break;case"second":t=this._d.valueOf(),t-=tn(t,1e3);break}this._d.setTime(t),_.updateOffset(this,!0)}return this},u.subtract=Qe,u.toArray=function(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]},u.toObject=function(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}},u.toDate=function(){return new Date(this.valueOf())},u.toISOString=function(e){var t;return this.isValid()?(t=(e=!0!==e)?this.clone().utc():this).year()<0||9999<t.year()?re(t,e?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):a(Date.prototype.toISOString)?e?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",re(t,"Z")):re(t,e?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ"):null},u.inspect=function(){var e,t,n;return this.isValid()?(t="moment",e="",this.isLocal()||(t=0===this.utcOffset()?"moment.utc":"moment.parseZone",e="Z"),t="["+t+'("]',n=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",this.format(t+n+"-MM-DD[T]HH:mm:ss.SSS"+(e+'[")]'))):"moment.invalid(/* "+this._i+" */)"},"undefined"!=typeof Symbol&&null!=Symbol.for&&(u[Symbol.for("nodejs.util.inspect.custom")]=function(){return"Moment<"+this.format()+">"}),u.toJSON=function(){return this.isValid()?this.toISOString():null},u.toString=function(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")},u.unix=function(){return Math.floor(this.valueOf()/1e3)},u.valueOf=function(){return this._d.valueOf()-6e4*(this._offset||0)},u.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}},u.eraName=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf("day").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].name;if(t[n].until<=e&&e<=t[n].since)return t[n].name}return""},u.eraNarrow=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf("day").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].narrow;if(t[n].until<=e&&e<=t[n].since)return t[n].narrow}return""},u.eraAbbr=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf("day").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].abbr;if(t[n].until<=e&&e<=t[n].since)return t[n].abbr}return""},u.eraYear=function(){for(var e,t,n=this.localeData().eras(),s=0,i=n.length;s<i;++s)if(e=n[s].since<=n[s].until?1:-1,t=this.clone().startOf("day").valueOf(),n[s].since<=t&&t<=n[s].until||n[s].until<=t&&t<=n[s].since)return(this.year()-_(n[s].since).year())*e+n[s].offset;return this.year()},u.year=Pe,u.isLeapYear=function(){return be(this.year())},u.weekYear=function(e){return un.call(this,e,this.week(),this.weekday()+this.localeData()._week.dow,this.localeData()._week.dow,this.localeData()._week.doy)},u.isoWeekYear=function(e){return un.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)},u.quarter=u.quarters=function(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)},u.month=Ie,u.daysInMonth=function(){return He(this.year(),this.month())},u.week=u.weeks=function(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),"d")},u.isoWeek=u.isoWeeks=function(e){var t=Be(this,1,4).week;return null==e?t:this.add(7*(e-t),"d")},u.weeksInYear=function(){var e=this.localeData()._week;return N(this.year(),e.dow,e.doy)},u.weeksInWeekYear=function(){var e=this.localeData()._week;return N(this.weekYear(),e.dow,e.doy)},u.isoWeeksInYear=function(){return N(this.year(),1,4)},u.isoWeeksInISOWeekYear=function(){return N(this.isoWeekYear(),1,4)},u.date=ge,u.day=u.days=function(e){var t,n,s;return this.isValid()?(t=Ce(this,"Day"),null!=e?(n=e,s=this.localeData(),e="string"!=typeof n?n:isNaN(n)?"number"==typeof(n=s.weekdaysParse(n))?n:null:parseInt(n,10),this.add(e-t,"d")):t):null!=e?this:NaN},u.weekday=function(e){var t;return this.isValid()?(t=(this.day()+7-this.localeData()._week.dow)%7,null==e?t:this.add(e-t,"d")):null!=e?this:NaN},u.isoWeekday=function(e){var t,n;return this.isValid()?null!=e?(t=e,n=this.localeData(),n="string"==typeof t?n.weekdaysParse(t)%7||7:isNaN(t)?null:t,this.day(this.day()%7?n:n-7)):this.day()||7:null!=e?this:NaN},u.dayOfYear=function(e){var t=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==e?t:this.add(e-t,"d")},u.hour=u.hours=i,u.minute=u.minutes=ce,u.second=u.seconds=we,u.millisecond=u.milliseconds=fe,u.utcOffset=function(e,t,n){var s,i=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null==e)return this._isUTC?i:Et(this);if("string"==typeof e){if(null===(e=Vt(ve,e)))return this}else Math.abs(e)<16&&!n&&(e*=60);return!this._isUTC&&t&&(s=Et(this)),this._offset=e,this._isUTC=!0,null!=s&&this.add(s,"m"),i!==e&&(!t||this._changeInProgress?$t(this,C(e-i,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,_.updateOffset(this,!0),this._changeInProgress=null)),this},u.utc=function(e){return this.utcOffset(0,e)},u.local=function(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e)&&this.subtract(Et(this),"m"),this},u.parseZone=function(){var e;return null!=this._tzm?this.utcOffset(this._tzm,!1,!0):"string"==typeof this._i&&(null!=(e=Vt(Me,this._i))?this.utcOffset(e):this.utcOffset(0,!0)),this},u.hasAlignedHourOffset=function(e){return!!this.isValid()&&(e=e?R(e).utcOffset():0,(this.utcOffset()-e)%60==0)},u.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},u.isLocal=function(){return!!this.isValid()&&!this._isUTC},u.isUtcOffset=function(){return!!this.isValid()&&this._isUTC},u.isUtc=At,u.isUTC=At,u.zoneAbbr=function(){return this._isUTC?"UTC":""},u.zoneName=function(){return this._isUTC?"Coordinated Universal Time":""},u.dates=e("dates accessor is deprecated. Use date instead.",ge),u.months=e("months accessor is deprecated. Use month instead",Ie),u.years=e("years accessor is deprecated. Use year instead",Pe),u.zone=e("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",function(e,t){return null!=e?(this.utcOffset(e="string"!=typeof e?-e:e,t),this):-this.utcOffset()}),u.isDSTShifted=e("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",function(){var e,t;return g(this._isDSTShifted)&&(q(e={},this),(e=Nt(e))._a?(t=(e._isUTC?l:R)(e._a),this._isDSTShifted=this.isValid()&&0<function(e,t,n){for(var s=Math.min(e.length,t.length),i=Math.abs(e.length-t.length),r=0,a=0;a<s;a++)(n&&e[a]!==t[a]||!n&&M(e[a])!==M(t[a]))&&r++;return r+i}(e._a,t.toArray())):this._isDSTShifted=!1),this._isDSTShifted});d=K.prototype;function cn(e,t,n,s){var i=P(),s=l().set(s,t);return i[n](s,e)}function fn(e,t,n){if(w(e)&&(t=e,e=void 0),e=e||"",null!=t)return cn(e,t,n,"month");for(var s=[],i=0;i<12;i++)s[i]=cn(e,i,n,"month");return s}function mn(e,t,n,s){t=("boolean"==typeof e?w(t)&&(n=t,t=void 0):(t=e,e=!1,w(n=t)&&(n=t,t=void 0)),t||"");var i,r=P(),a=e?r._week.dow:0,o=[];if(null!=n)return cn(t,(n+a)%7,s,"day");for(i=0;i<7;i++)o[i]=cn(t,(i+a)%7,s,"day");return o}d.calendar=function(e,t,n){return a(e=this._calendar[e]||this._calendar.sameElse)?e.call(t,n):e},d.longDateFormat=function(e){var t=this._longDateFormat[e],n=this._longDateFormat[e.toUpperCase()];return t||!n?t:(this._longDateFormat[e]=n.match(te).map(function(e){return"MMMM"===e||"MM"===e||"DD"===e||"dddd"===e?e.slice(1):e}).join(""),this._longDateFormat[e])},d.invalidDate=function(){return this._invalidDate},d.ordinal=function(e){return this._ordinal.replace("%d",e)},d.preparse=hn,d.postformat=hn,d.relativeTime=function(e,t,n,s){var i=this._relativeTime[n];return a(i)?i(e,t,n,s):i.replace(/%d/i,e)},d.pastFuture=function(e,t){return a(e=this._relativeTime[0<e?"future":"past"])?e(t):e.replace(/%s/i,t)},d.set=function(e){var t,n;for(n in e)c(e,n)&&(a(t=e[n])?this[n]=t:this["_"+n]=t);this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)},d.eras=function(e,t){for(var n,s=this._eras||P("en")._eras,i=0,r=s.length;i<r;++i){switch(typeof s[i].since){case"string":n=_(s[i].since).startOf("day"),s[i].since=n.valueOf();break}switch(typeof s[i].until){case"undefined":s[i].until=1/0;break;case"string":n=_(s[i].until).startOf("day").valueOf(),s[i].until=n.valueOf();break}}return s},d.erasParse=function(e,t,n){var s,i,r,a,o,u=this.eras();for(e=e.toUpperCase(),s=0,i=u.length;s<i;++s)if(r=u[s].name.toUpperCase(),a=u[s].abbr.toUpperCase(),o=u[s].narrow.toUpperCase(),n)switch(t){case"N":case"NN":case"NNN":if(a===e)return u[s];break;case"NNNN":if(r===e)return u[s];break;case"NNNNN":if(o===e)return u[s];break}else if(0<=[r,a,o].indexOf(e))return u[s]},d.erasConvertYear=function(e,t){var n=e.since<=e.until?1:-1;return void 0===t?_(e.since).year():_(e.since).year()+(t-e.offset)*n},d.erasAbbrRegex=function(e){return c(this,"_erasAbbrRegex")||an.call(this),e?this._erasAbbrRegex:this._erasRegex},d.erasNameRegex=function(e){return c(this,"_erasNameRegex")||an.call(this),e?this._erasNameRegex:this._erasRegex},d.erasNarrowRegex=function(e){return c(this,"_erasNarrowRegex")||an.call(this),e?this._erasNarrowRegex:this._erasRegex},d.months=function(e,t){return e?(y(this._months)?this._months:this._months[(this._months.isFormat||Ve).test(t)?"format":"standalone"])[e.month()]:y(this._months)?this._months:this._months.standalone},d.monthsShort=function(e,t){return e?(y(this._monthsShort)?this._monthsShort:this._monthsShort[Ve.test(t)?"format":"standalone"])[e.month()]:y(this._monthsShort)?this._monthsShort:this._monthsShort.standalone},d.monthsParse=function(e,t,n){var s,i;if(this._monthsParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],s=0;s<12;++s)r=l([2e3,s]),this._shortMonthsParse[s]=this.monthsShort(r,"").toLocaleLowerCase(),this._longMonthsParse[s]=this.months(r,"").toLocaleLowerCase();return n?"MMM"===t?-1!==(i=x.call(this._shortMonthsParse,e))?i:null:-1!==(i=x.call(this._longMonthsParse,e))?i:null:"MMM"===t?-1!==(i=x.call(this._shortMonthsParse,e))||-1!==(i=x.call(this._longMonthsParse,e))?i:null:-1!==(i=x.call(this._longMonthsParse,e))||-1!==(i=x.call(this._shortMonthsParse,e))?i:null}.call(this,e,t,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),s=0;s<12;s++){if(i=l([2e3,s]),n&&!this._longMonthsParse[s]&&(this._longMonthsParse[s]=new RegExp("^"+this.months(i,"").replace(".","")+"$","i"),this._shortMonthsParse[s]=new RegExp("^"+this.monthsShort(i,"").replace(".","")+"$","i")),n||this._monthsParse[s]||(i="^"+this.months(i,"")+"|^"+this.monthsShort(i,""),this._monthsParse[s]=new RegExp(i.replace(".",""),"i")),n&&"MMMM"===t&&this._longMonthsParse[s].test(e))return s;if(n&&"MMM"===t&&this._shortMonthsParse[s].test(e))return s;if(!n&&this._monthsParse[s].test(e))return s}},d.monthsRegex=function(e){return this._monthsParseExact?(c(this,"_monthsRegex")||je.call(this),e?this._monthsStrictRegex:this._monthsRegex):(c(this,"_monthsRegex")||(this._monthsRegex=Ee),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)},d.monthsShortRegex=function(e){return this._monthsParseExact?(c(this,"_monthsRegex")||je.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(c(this,"_monthsShortRegex")||(this._monthsShortRegex=Ge),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)},d.week=function(e){return Be(e,this._week.dow,this._week.doy).week},d.firstDayOfYear=function(){return this._week.doy},d.firstDayOfWeek=function(){return this._week.dow},d.weekdays=function(e,t){return t=y(this._weekdays)?this._weekdays:this._weekdays[e&&!0!==e&&this._weekdays.isFormat.test(t)?"format":"standalone"],!0===e?Je(t,this._week.dow):e?t[e.day()]:t},d.weekdaysMin=function(e){return!0===e?Je(this._weekdaysMin,this._week.dow):e?this._weekdaysMin[e.day()]:this._weekdaysMin},d.weekdaysShort=function(e){return!0===e?Je(this._weekdaysShort,this._week.dow):e?this._weekdaysShort[e.day()]:this._weekdaysShort},d.weekdaysParse=function(e,t,n){var s,i;if(this._weekdaysParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],s=0;s<7;++s)r=l([2e3,1]).day(s),this._minWeekdaysParse[s]=this.weekdaysMin(r,"").toLocaleLowerCase(),this._shortWeekdaysParse[s]=this.weekdaysShort(r,"").toLocaleLowerCase(),this._weekdaysParse[s]=this.weekdays(r,"").toLocaleLowerCase();return n?"dddd"===t?-1!==(i=x.call(this._weekdaysParse,e))?i:null:"ddd"===t?-1!==(i=x.call(this._shortWeekdaysParse,e))?i:null:-1!==(i=x.call(this._minWeekdaysParse,e))?i:null:"dddd"===t?-1!==(i=x.call(this._weekdaysParse,e))||-1!==(i=x.call(this._shortWeekdaysParse,e))||-1!==(i=x.call(this._minWeekdaysParse,e))?i:null:"ddd"===t?-1!==(i=x.call(this._shortWeekdaysParse,e))||-1!==(i=x.call(this._weekdaysParse,e))||-1!==(i=x.call(this._minWeekdaysParse,e))?i:null:-1!==(i=x.call(this._minWeekdaysParse,e))||-1!==(i=x.call(this._weekdaysParse,e))||-1!==(i=x.call(this._shortWeekdaysParse,e))?i:null}.call(this,e,t,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),s=0;s<7;s++){if(i=l([2e3,1]).day(s),n&&!this._fullWeekdaysParse[s]&&(this._fullWeekdaysParse[s]=new RegExp("^"+this.weekdays(i,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[s]=new RegExp("^"+this.weekdaysShort(i,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[s]=new RegExp("^"+this.weekdaysMin(i,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[s]||(i="^"+this.weekdays(i,"")+"|^"+this.weekdaysShort(i,"")+"|^"+this.weekdaysMin(i,""),this._weekdaysParse[s]=new RegExp(i.replace(".",""),"i")),n&&"dddd"===t&&this._fullWeekdaysParse[s].test(e))return s;if(n&&"ddd"===t&&this._shortWeekdaysParse[s].test(e))return s;if(n&&"dd"===t&&this._minWeekdaysParse[s].test(e))return s;if(!n&&this._weekdaysParse[s].test(e))return s}},d.weekdaysRegex=function(e){return this._weekdaysParseExact?(c(this,"_weekdaysRegex")||st.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(c(this,"_weekdaysRegex")||(this._weekdaysRegex=et),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)},d.weekdaysShortRegex=function(e){return this._weekdaysParseExact?(c(this,"_weekdaysRegex")||st.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(c(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=tt),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)},d.weekdaysMinRegex=function(e){return this._weekdaysParseExact?(c(this,"_weekdaysRegex")||st.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(c(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=nt),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)},d.isPM=function(e){return"p"===(e+"").toLowerCase().charAt(0)},d.meridiem=function(e,t,n){return 11<e?n?"pm":"PM":n?"am":"AM"},ft("en",{eras:[{since:"0001-01-01",until:1/0,offset:1,name:"Anno Domini",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"Before Christ",narrow:"BC",abbr:"BC"}],dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===M(e%100/10)?"th":1==t?"st":2==t?"nd":3==t?"rd":"th")}}),_.lang=e("moment.lang is deprecated. Use moment.locale instead.",ft),_.langData=e("moment.langData is deprecated. Use moment.localeData instead.",P);var _n=Math.abs;function yn(e,t,n,s){t=C(t,n);return e._milliseconds+=s*t._milliseconds,e._days+=s*t._days,e._months+=s*t._months,e._bubble()}function gn(e){return e<0?Math.floor(e):Math.ceil(e)}function wn(e){return 4800*e/146097}function pn(e){return 146097*e/4800}function kn(e){return function(){return this.as(e)}}de=kn("ms"),t=kn("s"),ye=kn("m"),he=kn("h"),Fe=kn("d"),_e=kn("w"),me=kn("M"),Qe=kn("Q"),i=kn("y"),ce=de;function Mn(e){return function(){return this.isValid()?this._data[e]:NaN}}var we=Mn("milliseconds"),fe=Mn("seconds"),ge=Mn("minutes"),Pe=Mn("hours"),d=Mn("days"),vn=Mn("months"),Dn=Mn("years");var Yn=Math.round,Sn={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function On(e,t,n,s){var i=C(e).abs(),r=Yn(i.as("s")),a=Yn(i.as("m")),o=Yn(i.as("h")),u=Yn(i.as("d")),l=Yn(i.as("M")),d=Yn(i.as("w")),i=Yn(i.as("y")),r=(r<=n.ss?["s",r]:r<n.s&&["ss",r])||(a<=1?["m"]:a<n.m&&["mm",a])||(o<=1?["h"]:o<n.h&&["hh",o])||(u<=1?["d"]:u<n.d&&["dd",u]);return(r=(r=null!=n.w?r||(d<=1?["w"]:d<n.w&&["ww",d]):r)||(l<=1?["M"]:l<n.M&&["MM",l])||(i<=1?["y"]:["yy",i]))[2]=t,r[3]=0<+e,r[4]=s,function(e,t,n,s,i){return i.relativeTime(t||1,!!n,e,s)}.apply(null,r)}var bn=Math.abs;function Tn(e){return(0<e)-(e<0)||+e}function xn(){var e,t,n,s,i,r,a,o,u,l,d;return this.isValid()?(e=bn(this._milliseconds)/1e3,t=bn(this._days),n=bn(this._months),(o=this.asSeconds())?(s=m(e/60),i=m(s/60),e%=60,s%=60,r=m(n/12),n%=12,a=e?e.toFixed(3).replace(/\.?0+$/,""):"",u=Tn(this._months)!==Tn(o)?"-":"",l=Tn(this._days)!==Tn(o)?"-":"",d=Tn(this._milliseconds)!==Tn(o)?"-":"",(o<0?"-":"")+"P"+(r?u+r+"Y":"")+(n?u+n+"M":"")+(t?l+t+"D":"")+(i||s||e?"T":"")+(i?d+i+"H":"")+(s?d+s+"M":"")+(e?d+a+"S":"")):"P0D"):this.localeData().invalidDate()}var U=Ct.prototype;return U.isValid=function(){return this._isValid},U.abs=function(){var e=this._data;return this._milliseconds=_n(this._milliseconds),this._days=_n(this._days),this._months=_n(this._months),e.milliseconds=_n(e.milliseconds),e.seconds=_n(e.seconds),e.minutes=_n(e.minutes),e.hours=_n(e.hours),e.months=_n(e.months),e.years=_n(e.years),this},U.add=function(e,t){return yn(this,e,t,1)},U.subtract=function(e,t){return yn(this,e,t,-1)},U.as=function(e){if(!this.isValid())return NaN;var t,n,s=this._milliseconds;if("month"===(e=o(e))||"quarter"===e||"year"===e)switch(t=this._days+s/864e5,n=this._months+wn(t),e){case"month":return n;case"quarter":return n/3;case"year":return n/12}else switch(t=this._days+Math.round(pn(this._months)),e){case"week":return t/7+s/6048e5;case"day":return t+s/864e5;case"hour":return 24*t+s/36e5;case"minute":return 1440*t+s/6e4;case"second":return 86400*t+s/1e3;case"millisecond":return Math.floor(864e5*t)+s;default:throw new Error("Unknown unit "+e)}},U.asMilliseconds=de,U.asSeconds=t,U.asMinutes=ye,U.asHours=he,U.asDays=Fe,U.asWeeks=_e,U.asMonths=me,U.asQuarters=Qe,U.asYears=i,U.valueOf=ce,U._bubble=function(){var e=this._milliseconds,t=this._days,n=this._months,s=this._data;return 0<=e&&0<=t&&0<=n||e<=0&&t<=0&&n<=0||(e+=864e5*gn(pn(n)+t),n=t=0),s.milliseconds=e%1e3,e=m(e/1e3),s.seconds=e%60,e=m(e/60),s.minutes=e%60,e=m(e/60),s.hours=e%24,t+=m(e/24),n+=e=m(wn(t)),t-=gn(pn(e)),e=m(n/12),n%=12,s.days=t,s.months=n,s.years=e,this},U.clone=function(){return C(this)},U.get=function(e){return e=o(e),this.isValid()?this[e+"s"]():NaN},U.milliseconds=we,U.seconds=fe,U.minutes=ge,U.hours=Pe,U.days=d,U.weeks=function(){return m(this.days()/7)},U.months=vn,U.years=Dn,U.humanize=function(e,t){var n,s;return this.isValid()?(n=!1,s=Sn,"object"==typeof e&&(t=e,e=!1),"boolean"==typeof e&&(n=e),"object"==typeof t&&(s=Object.assign({},Sn,t),null!=t.s)&&null==t.ss&&(s.ss=t.s-1),e=this.localeData(),t=On(this,!n,s,e),n&&(t=e.pastFuture(+this,t)),e.postformat(t)):this.localeData().invalidDate()},U.toISOString=xn,U.toString=xn,U.toJSON=xn,U.locale=Xt,U.localeData=Kt,U.toIsoString=e("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",xn),U.lang=Ke,s("X",0,0,"unix"),s("x",0,0,"valueOf"),h("x",ke),h("X",/[+-]?\d+(\.\d{1,3})?/),v("X",function(e,t,n){n._d=new Date(1e3*parseFloat(e))}),v("x",function(e,t,n){n._d=new Date(M(e))}),_.version="2.30.1",H=R,_.fn=u,_.min=function(){return Pt("isBefore",[].slice.call(arguments,0))},_.max=function(){return Pt("isAfter",[].slice.call(arguments,0))},_.now=function(){return Date.now?Date.now():+new Date},_.utc=l,_.unix=function(e){return R(1e3*e)},_.months=function(e,t){return fn(e,t,"months")},_.isDate=V,_.locale=ft,_.invalid=I,_.duration=C,_.isMoment=k,_.weekdays=function(e,t,n){return mn(e,t,n,"weekdays")},_.parseZone=function(){return R.apply(null,arguments).parseZone()},_.localeData=P,_.isDuration=Ut,_.monthsShort=function(e,t){return fn(e,t,"monthsShort")},_.weekdaysMin=function(e,t,n){return mn(e,t,n,"weekdaysMin")},_.defineLocale=mt,_.updateLocale=function(e,t){var n,s;return null!=t?(s=ut,null!=W[e]&&null!=W[e].parentLocale?W[e].set(X(W[e]._config,t)):(t=X(s=null!=(n=ct(e))?n._config:s,t),null==n&&(t.abbr=e),(s=new K(t)).parentLocale=W[e],W[e]=s),ft(e)):null!=W[e]&&(null!=W[e].parentLocale?(W[e]=W[e].parentLocale,e===ft()&&ft(e)):null!=W[e]&&delete W[e]),W[e]},_.locales=function(){return ee(W)},_.weekdaysShort=function(e,t,n){return mn(e,t,n,"weekdaysShort")},_.normalizeUnits=o,_.relativeTimeRounding=function(e){return void 0===e?Yn:"function"==typeof e&&(Yn=e,!0)},_.relativeTimeThreshold=function(e,t){return void 0!==Sn[e]&&(void 0===t?Sn[e]:(Sn[e]=t,"s"===e&&(Sn.ss=t-1),!0))},_.calendarFormat=function(e,t){return(e=e.diff(t,"days",!0))<-6?"sameElse":e<-1?"lastWeek":e<0?"lastDay":e<1?"sameDay":e<2?"nextDay":e<7?"nextWeek":"sameElse"},_.prototype=u,_.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},_});(function(root,factory){if(typeof define==='function'&&define.amd){define(["jquery"],function($){return(root.returnExportsGlobal=factory($))})}else if(typeof exports==='object'){module.exports=factory(require("jquery"))}else{factory(jQuery)}}(this,function($){"use strict";var EditableCaret,InputCaret,Mirror,Utils,discoveryIframeOf,methods,oDocument,oFrame,oWindow,pluginName,setContextBy;pluginName='caret';EditableCaret=(function(){function EditableCaret($inputor){this.$inputor=$inputor;this.domInputor=this.$inputor[0]}
EditableCaret.prototype.setPos=function(pos){var fn,found,offset,sel;if(sel=oWindow.getSelection()){offset=0;found=!1;(fn=function(pos,parent){var node,range,_i,_len,_ref,_results;_ref=parent.childNodes;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){node=_ref[_i];if(found){break}
if(node.nodeType===3){if(offset+node.length>=pos){found=!0;range=oDocument.createRange();range.setStart(node,pos-offset);sel.removeAllRanges();sel.addRange(range);break}else{_results.push(offset+=node.length)}}else{_results.push(fn(pos,node))}}
return _results})(pos,this.domInputor)}
return this.domInputor};EditableCaret.prototype.getIEPosition=function(){return this.getPosition()};EditableCaret.prototype.getPosition=function(){var inputor_offset,offset;offset=this.getOffset();inputor_offset=this.$inputor.offset();offset.left-=inputor_offset.left;offset.top-=inputor_offset.top;return offset};EditableCaret.prototype.getOldIEPos=function(){var preCaretTextRange,textRange;textRange=oDocument.selection.createRange();preCaretTextRange=oDocument.body.createTextRange();preCaretTextRange.moveToElementText(this.domInputor);preCaretTextRange.setEndPoint("EndToEnd",textRange);return preCaretTextRange.text.length};EditableCaret.prototype.getPos=function(){var clonedRange,pos,range;if(range=this.range()){clonedRange=range.cloneRange();clonedRange.selectNodeContents(this.domInputor);clonedRange.setEnd(range.endContainer,range.endOffset);pos=clonedRange.toString().length;clonedRange.detach();return pos}else if(oDocument.selection){return this.getOldIEPos()}};EditableCaret.prototype.getOldIEOffset=function(){var range,rect;range=oDocument.selection.createRange().duplicate();range.moveStart("character",-1);rect=range.getBoundingClientRect();return{height:rect.bottom-rect.top,left:rect.left,top:rect.top}};EditableCaret.prototype.getOffset=function(pos){var clonedRange,offset,range,rect,shadowCaret;if(oWindow.getSelection&&(range=this.range())){if(range.endOffset-1>0&&range.endContainer!==this.domInputor){clonedRange=range.cloneRange();clonedRange.setStart(range.endContainer,range.endOffset-1);clonedRange.setEnd(range.endContainer,range.endOffset);rect=clonedRange.getBoundingClientRect();offset={height:rect.height,left:rect.left+rect.width,top:rect.top};clonedRange.detach()}
if(!offset||(offset!=null?offset.height:void 0)===0){clonedRange=range.cloneRange();shadowCaret=$(oDocument.createTextNode("|"));clonedRange.insertNode(shadowCaret[0]);clonedRange.selectNode(shadowCaret[0]);rect=clonedRange.getBoundingClientRect();offset={height:rect.height,left:rect.left,top:rect.top};shadowCaret.remove();clonedRange.detach()}}else if(oDocument.selection){offset=this.getOldIEOffset()}
if(offset){offset.top+=$(oWindow).scrollTop();offset.left+=$(oWindow).scrollLeft()}
return offset};EditableCaret.prototype.range=function(){var sel;if(!oWindow.getSelection){return}
sel=oWindow.getSelection();if(sel.rangeCount>0){return sel.getRangeAt(0)}else{return null}};return EditableCaret})();InputCaret=(function(){function InputCaret($inputor){this.$inputor=$inputor;this.domInputor=this.$inputor[0]}
InputCaret.prototype.getIEPos=function(){var endRange,inputor,len,normalizedValue,pos,range,textInputRange;inputor=this.domInputor;range=oDocument.selection.createRange();pos=0;if(range&&range.parentElement()===inputor){normalizedValue=inputor.value.replace(/\r\n/g,"\n");len=normalizedValue.length;textInputRange=inputor.createTextRange();textInputRange.moveToBookmark(range.getBookmark());endRange=inputor.createTextRange();endRange.collapse(!1);if(textInputRange.compareEndPoints("StartToEnd",endRange)>-1){pos=len}else{pos=-textInputRange.moveStart("character",-len)}}
return pos};InputCaret.prototype.getPos=function(){if(oDocument.selection){return this.getIEPos()}else{return this.domInputor.selectionStart}};InputCaret.prototype.setPos=function(pos){var inputor,range;inputor=this.domInputor;if(oDocument.selection){range=inputor.createTextRange();range.move("character",pos);range.select()}else if(inputor.setSelectionRange){inputor.setSelectionRange(pos,pos)}
return inputor};InputCaret.prototype.getIEOffset=function(pos){var h,textRange,x,y;textRange=this.domInputor.createTextRange();pos||(pos=this.getPos());textRange.move('character',pos);x=textRange.boundingLeft;y=textRange.boundingTop;h=textRange.boundingHeight;return{left:x,top:y,height:h}};InputCaret.prototype.getOffset=function(pos){var $inputor,offset,position;$inputor=this.$inputor;if(oDocument.selection){offset=this.getIEOffset(pos);offset.top+=$(oWindow).scrollTop()+$inputor.scrollTop();offset.left+=$(oWindow).scrollLeft()+$inputor.scrollLeft();return offset}else{offset=$inputor.offset();position=this.getPosition(pos);return offset={left:offset.left+position.left-$inputor.scrollLeft(),top:offset.top+position.top-$inputor.scrollTop(),height:position.height}}};InputCaret.prototype.getPosition=function(pos){var $inputor,at_rect,end_range,format,html,mirror,start_range;$inputor=this.$inputor;format=function(value){value=value.replace(/<|>|`|"|&/g,'?').replace(/\r\n|\r|\n/g,"<br/>");if(/firefox/i.test(navigator.userAgent)){value=value.replace(/\s/g,'&nbsp;')}
return value};if(pos===void 0){pos=this.getPos()}
start_range=$inputor.val().slice(0,pos);end_range=$inputor.val().slice(pos);html="<span style='position: relative; display: inline;'>"+format(start_range)+"</span>";html+="<span id='caret' style='position: relative; display: inline;'>|</span>";html+="<span style='position: relative; display: inline;'>"+format(end_range)+"</span>";mirror=new Mirror($inputor);return at_rect=mirror.create(html).rect()};InputCaret.prototype.getIEPosition=function(pos){var h,inputorOffset,offset,x,y;offset=this.getIEOffset(pos);inputorOffset=this.$inputor.offset();x=offset.left-inputorOffset.left;y=offset.top-inputorOffset.top;h=offset.height;return{left:x,top:y,height:h}};return InputCaret})();Mirror=(function(){Mirror.prototype.css_attr=["borderBottomWidth","borderLeftWidth","borderRightWidth","borderTopStyle","borderRightStyle","borderBottomStyle","borderLeftStyle","borderTopWidth","boxSizing","fontFamily","fontSize","fontWeight","height","letterSpacing","lineHeight","marginBottom","marginLeft","marginRight","marginTop","outlineWidth","overflow","overflowX","overflowY","paddingBottom","paddingLeft","paddingRight","paddingTop","textAlign","textOverflow","textTransform","whiteSpace","wordBreak","wordWrap"];function Mirror($inputor){this.$inputor=$inputor}
Mirror.prototype.mirrorCss=function(){var css,_this=this;css={position:'absolute',left:-9999,top:0,zIndex:-20000};if(this.$inputor.prop('tagName')==='TEXTAREA'){this.css_attr.push('width')}
$.each(this.css_attr,function(i,p){return css[p]=_this.$inputor.css(p)});return css};Mirror.prototype.create=function(html){this.$mirror=$('<div></div>');this.$mirror.css(this.mirrorCss());this.$mirror.html(html);this.$inputor.after(this.$mirror);return this};Mirror.prototype.rect=function(){var $flag,pos,rect;$flag=this.$mirror.find("#caret");pos=$flag.position();rect={left:pos.left,top:pos.top,height:$flag.height()};this.$mirror.remove();return rect};return Mirror})();Utils={contentEditable:function($inputor){return!!($inputor[0].contentEditable&&$inputor[0].contentEditable==='true')}};methods={pos:function(pos){if(pos||pos===0){return this.setPos(pos)}else{return this.getPos()}},position:function(pos){if(oDocument.selection){return this.getIEPosition(pos)}else{return this.getPosition(pos)}},offset:function(pos){var offset;offset=this.getOffset(pos);return offset}};oDocument=null;oWindow=null;oFrame=null;setContextBy=function(settings){var iframe;if(iframe=settings!=null?settings.iframe:void 0){oFrame=iframe;oWindow=iframe.contentWindow;return oDocument=iframe.contentDocument||oWindow.document}else{oFrame=void 0;oWindow=window;return oDocument=document}};discoveryIframeOf=function($dom){var error;oDocument=$dom[0].ownerDocument;oWindow=oDocument.defaultView||oDocument.parentWindow;try{return oFrame=oWindow.frameElement}catch(_error){error=_error}};$.fn.caret=function(method,value,settings){var caret;if(methods[method]){if($.isPlainObject(value)){setContextBy(value);value=void 0}else{setContextBy(settings)}
caret=Utils.contentEditable(this)?new EditableCaret(this):new InputCaret(this);return methods[method].apply(caret,[value])}else{return $.error("Method "+method+" does not exist on jQuery.caret")}};$.fn.caret.EditableCaret=EditableCaret;$.fn.caret.InputCaret=InputCaret;$.fn.caret.Utils=Utils;$.fn.caret.apis=methods}));/*!
 * jQuery Cookie Plugin v1.4.1
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2013 Klaus Hartl
 * Released under the MIT license
 */
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof exports==='object'){factory(require('jquery'))}else{factory(jQuery)}}(function($){var pluses=/\+/g;function encode(s){return config.raw?s:encodeURIComponent(s)}
function decode(s){return config.raw?s:decodeURIComponent(s)}
function stringifyCookieValue(value){return encode(config.json?JSON.stringify(value):String(value))}
function parseCookieValue(s){if(s.indexOf('"')===0){s=s.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,'\\')}
try{s=decodeURIComponent(s.replace(pluses,' '));return config.json?JSON.parse(s):s}catch(e){}}
function read(s,converter){var value=config.raw?s:parseCookieValue(s);return $.isFunction(converter)?converter(value):value}
var config=$.cookie=function(key,value,options){if(value!==undefined&&!$.isFunction(value)){options=$.extend({},config.defaults,options);if(typeof options.expires==='number'){var days=options.expires,t=options.expires=new Date();t.setTime(+t+days*864e+5)}
return(document.cookie=[encode(key),'=',stringifyCookieValue(value),options.expires?'; expires='+options.expires.toUTCString():'',options.path?'; path='+options.path:'',options.domain?'; domain='+options.domain:'',options.secure?'; secure':''].join(''))}
var result=key?undefined:{};var cookies=document.cookie?document.cookie.split('; '):[];for(var i=0,l=cookies.length;i<l;i++){var parts=cookies[i].split('=');var name=decode(parts.shift());var cookie=parts.join('=');if(key&&key===name){result=read(cookie,value);break}
if(!key&&(cookie=read(cookie))!==undefined){result[name]=cookie}}
return result};config.defaults={};$.removeCookie=function(key,options){if($.cookie(key)===undefined){return!1}
$.cookie(key,'',$.extend({},options,{expires:-1}));return!$.cookie(key)}}));(function(){var root=this;if(typeof Math.sgn=="undefined"){Math.sgn=function(x){return x==0?0:x>0?1:-1}}
var Vectors={subtract:function(v1,v2){return{x:v1.x-v2.x,y:v1.y-v2.y}},dotProduct:function(v1,v2){return(v1.x*v2.x)+(v1.y*v2.y)},square:function(v){return Math.sqrt((v.x*v.x)+(v.y*v.y))},scale:function(v,s){return{x:v.x*s,y:v.y*s}}},maxRecursion=64,flatnessTolerance=Math.pow(2.0,-maxRecursion-1);var _distanceFromCurve=function(point,curve){var candidates=[],w=_convertToBezier(point,curve),degree=curve.length-1,higherDegree=(2*degree)-1,numSolutions=_findRoots(w,higherDegree,candidates,0),v=Vectors.subtract(point,curve[0]),dist=Vectors.square(v),t=0.0;for(var i=0;i<numSolutions;i++){v=Vectors.subtract(point,_bezier(curve,degree,candidates[i],null,null));var newDist=Vectors.square(v);if(newDist<dist){dist=newDist;t=candidates[i]}}
v=Vectors.subtract(point,curve[degree]);newDist=Vectors.square(v);if(newDist<dist){dist=newDist;t=1.0}
return{location:t,distance:dist}};var _nearestPointOnCurve=function(point,curve){var td=_distanceFromCurve(point,curve);return{point:_bezier(curve,curve.length-1,td.location,null,null),location:td.location}};var _convertToBezier=function(point,curve){var degree=curve.length-1,higherDegree=(2*degree)-1,c=[],d=[],cdTable=[],w=[],z=[[1.0,0.6,0.3,0.1],[0.4,0.6,0.6,0.4],[0.1,0.3,0.6,1.0]];for(var i=0;i<=degree;i++)c[i]=Vectors.subtract(curve[i],point);for(var i=0;i<=degree-1;i++){d[i]=Vectors.subtract(curve[i+1],curve[i]);d[i]=Vectors.scale(d[i],3.0)}
for(var row=0;row<=degree-1;row++){for(var column=0;column<=degree;column++){if(!cdTable[row])cdTable[row]=[];cdTable[row][column]=Vectors.dotProduct(d[row],c[column])}}
for(i=0;i<=higherDegree;i++){if(!w[i])w[i]=[];w[i].y=0.0;w[i].x=parseFloat(i)/higherDegree}
var n=degree,m=degree-1;for(var k=0;k<=n+m;k++){var lb=Math.max(0,k-m),ub=Math.min(k,n);for(i=lb;i<=ub;i++){var j=k-i;w[i+j].y+=cdTable[j][i]*z[j][i]}}
return w};var _findRoots=function(w,degree,t,depth){var left=[],right=[],left_count,right_count,left_t=[],right_t=[];switch(_getCrossingCount(w,degree)){case 0:{return 0}
case 1:{if(depth>=maxRecursion){t[0]=(w[0].x+w[degree].x)/2.0;return 1}
if(_isFlatEnough(w,degree)){t[0]=_computeXIntercept(w,degree);return 1}
break}}
_bezier(w,degree,0.5,left,right);left_count=_findRoots(left,degree,left_t,depth+1);right_count=_findRoots(right,degree,right_t,depth+1);for(var i=0;i<left_count;i++)t[i]=left_t[i];for(var i=0;i<right_count;i++)t[i+left_count]=right_t[i];return(left_count+right_count)};var _getCrossingCount=function(curve,degree){var n_crossings=0,sign,old_sign;sign=old_sign=Math.sgn(curve[0].y);for(var i=1;i<=degree;i++){sign=Math.sgn(curve[i].y);if(sign!=old_sign)n_crossings++;old_sign=sign}
return n_crossings};var _isFlatEnough=function(curve,degree){var error,intercept_1,intercept_2,left_intercept,right_intercept,a,b,c,det,dInv,a1,b1,c1,a2,b2,c2;a=curve[0].y-curve[degree].y;b=curve[degree].x-curve[0].x;c=curve[0].x*curve[degree].y-curve[degree].x*curve[0].y;var max_distance_above,max_distance_below;max_distance_above=max_distance_below=0.0;for(var i=1;i<degree;i++){var value=a*curve[i].x+b*curve[i].y+c;if(value>max_distance_above)
max_distance_above=value;else if(value<max_distance_below)
max_distance_below=value}
a1=0.0;b1=1.0;c1=0.0;a2=a;b2=b;c2=c-max_distance_above;det=a1*b2-a2*b1;dInv=1.0/det;intercept_1=(b1*c2-b2*c1)*dInv;a2=a;b2=b;c2=c-max_distance_below;det=a1*b2-a2*b1;dInv=1.0/det;intercept_2=(b1*c2-b2*c1)*dInv;left_intercept=Math.min(intercept_1,intercept_2);right_intercept=Math.max(intercept_1,intercept_2);error=right_intercept-left_intercept;return(error<flatnessTolerance)?1:0};var _computeXIntercept=function(curve,degree){var XLK=1.0,YLK=0.0,XNM=curve[degree].x-curve[0].x,YNM=curve[degree].y-curve[0].y,XMK=curve[0].x-0.0,YMK=curve[0].y-0.0,det=XNM*YLK-YNM*XLK,detInv=1.0/det,S=(XNM*YMK-YNM*XMK)*detInv;return 0.0+XLK*S};var _bezier=function(curve,degree,t,left,right){var temp=[[]];for(var j=0;j<=degree;j++)temp[0][j]=curve[j];for(var i=1;i<=degree;i++){for(var j=0;j<=degree-i;j++){if(!temp[i])temp[i]=[];if(!temp[i][j])temp[i][j]={};temp[i][j].x=(1.0-t)*temp[i-1][j].x+t*temp[i-1][j+1].x;temp[i][j].y=(1.0-t)*temp[i-1][j].y+t*temp[i-1][j+1].y}}
if(left!=null)
for(j=0;j<=degree;j++)left[j]=temp[j][0];if(right!=null)
for(j=0;j<=degree;j++)right[j]=temp[degree-j][j];return(temp[degree][0])};var _curveFunctionCache={};var _getCurveFunctions=function(order){var fns=_curveFunctionCache[order];if(!fns){fns=[];var f_term=function(){return function(t){return Math.pow(t,order)}},l_term=function(){return function(t){return Math.pow((1-t),order)}},c_term=function(c){return function(t){return c}},t_term=function(){return function(t){return t}},one_minus_t_term=function(){return function(t){return 1-t}},_termFunc=function(terms){return function(t){var p=1;for(var i=0;i<terms.length;i++)p=p*terms[i](t);return p}};fns.push(new f_term());for(var i=1;i<order;i++){var terms=[new c_term(order)];for(var j=0;j<(order-i);j++)terms.push(new t_term());for(var j=0;j<i;j++)terms.push(new one_minus_t_term());fns.push(new _termFunc(terms))}
fns.push(new l_term());_curveFunctionCache[order]=fns}
return fns};var _pointOnPath=function(curve,location){var cc=_getCurveFunctions(curve.length-1),_x=0,_y=0;for(var i=0;i<curve.length;i++){_x=_x+(curve[i].x*cc[i](location));_y=_y+(curve[i].y*cc[i](location))}
return{x:_x,y:_y}};var _dist=function(p1,p2){return Math.sqrt(Math.pow(p1.x-p2.x,2)+Math.pow(p1.y-p2.y,2))};var _isPoint=function(curve){return curve[0].x===curve[1].x&&curve[0].y===curve[1].y};var _pointAlongPath=function(curve,location,distance){if(_isPoint(curve)){return{point:curve[0],location:location}}
var prev=_pointOnPath(curve,location),tally=0,curLoc=location,direction=distance>0?1:-1,cur=null;while(tally<Math.abs(distance)){curLoc+=(0.005*direction);cur=_pointOnPath(curve,curLoc);tally+=_dist(cur,prev);prev=cur}
return{point:cur,location:curLoc}};var _length=function(curve){var d=new Date().getTime();if(_isPoint(curve))return 0;var prev=_pointOnPath(curve,0),tally=0,curLoc=0,direction=1,cur=null;while(curLoc<1){curLoc+=(0.005*direction);cur=_pointOnPath(curve,curLoc);tally+=_dist(cur,prev);prev=cur}
console.log("length",new Date().getTime()-d);return tally};var _pointAlongPathFrom=function(curve,location,distance){return _pointAlongPath(curve,location,distance).point};var _locationAlongPathFrom=function(curve,location,distance){return _pointAlongPath(curve,location,distance).location};var _gradientAtPoint=function(curve,location){var p1=_pointOnPath(curve,location),p2=_pointOnPath(curve.slice(0,curve.length-1),location),dy=p2.y-p1.y,dx=p2.x-p1.x;return dy===0?Infinity:Math.atan(dy/dx)};var _gradientAtPointAlongPathFrom=function(curve,location,distance){var p=_pointAlongPath(curve,location,distance);if(p.location>1)p.location=1;if(p.location<0)p.location=0;return _gradientAtPoint(curve,p.location)};var _perpendicularToPathAt=function(curve,location,length,distance){distance=distance==null?0:distance;var p=_pointAlongPath(curve,location,distance),m=_gradientAtPoint(curve,p.location),_theta2=Math.atan(-1/m),y=length/2*Math.sin(_theta2),x=length/2*Math.cos(_theta2);return[{x:p.point.x+x,y:p.point.y+y},{x:p.point.x-x,y:p.point.y-y}]};var _lineIntersection=function(x1,y1,x2,y2,curve){var a=y2-y1,b=x1-x2,c=(x1*(y1-y2))+(y1*(x2-x1)),coeffs=_computeCoefficients(curve),p=[(a*coeffs[0][0])+(b*coeffs[1][0]),(a*coeffs[0][1])+(b*coeffs[1][1]),(a*coeffs[0][2])+(b*coeffs[1][2]),(a*coeffs[0][3])+(b*coeffs[1][3])+c],r=_cubicRoots.apply(null,p),intersections=[];if(r!=null){for(var i=0;i<3;i++){var t=r[i],t2=Math.pow(t,2),t3=Math.pow(t,3),x=[(coeffs[0][0]*t3)+(coeffs[0][1]*t2)+(coeffs[0][2]*t)+coeffs[0][3],(coeffs[1][0]*t3)+(coeffs[1][1]*t2)+(coeffs[1][2]*t)+coeffs[1][3]];var s;if((x2-x1)!==0){s=(x[0]-x1)/(x2-x1)}else{s=(x[1]-y1)/(y2-y1)}
if(t>=0&&t<=1.0&&s>=0&&s<=1.0){intersections.push(x)}}}
return intersections};var _boxIntersection=function(x,y,w,h,curve){var i=[];i.push.apply(i,_lineIntersection(x,y,x+w,y,curve));i.push.apply(i,_lineIntersection(x+w,y,x+w,y+h,curve));i.push.apply(i,_lineIntersection(x+w,y+h,x,y+h,curve));i.push.apply(i,_lineIntersection(x,y+h,x,y,curve));return i};var _boundingBoxIntersection=function(boundingBox,curve){var i=[];i.push.apply(i,_lineIntersection(boundingBox.x,boundingBox.y,boundingBox.x+boundingBox.w,boundingBox.y,curve));i.push.apply(i,_lineIntersection(boundingBox.x+boundingBox.w,boundingBox.y,boundingBox.x+boundingBox.w,boundingBox.y+boundingBox.h,curve));i.push.apply(i,_lineIntersection(boundingBox.x+boundingBox.w,boundingBox.y+boundingBox.h,boundingBox.x,boundingBox.y+boundingBox.h,curve));i.push.apply(i,_lineIntersection(boundingBox.x,boundingBox.y+boundingBox.h,boundingBox.x,boundingBox.y,curve));return i};function _computeCoefficientsForAxis(curve,axis){return[-(curve[0][axis])+(3*curve[1][axis])+(-3*curve[2][axis])+curve[3][axis],(3*(curve[0][axis]))-(6*(curve[1][axis]))+(3*(curve[2][axis])),-3*curve[0][axis]+3*curve[1][axis],curve[0][axis]]}
function _computeCoefficients(curve){return[_computeCoefficientsForAxis(curve,"x"),_computeCoefficientsForAxis(curve,"y")]}
function sgn(x){return x<0?-1:x>0?1:0}
function _cubicRoots(a,b,c,d){var A=b/a,B=c/a,C=d/a,Q=(3*B-Math.pow(A,2))/9,R=(9*A*B-27*C-2*Math.pow(A,3))/54,D=Math.pow(Q,3)+Math.pow(R,2),S,T,t=[];if(D>=0){S=sgn(R+Math.sqrt(D))*Math.pow(Math.abs(R+Math.sqrt(D)),(1/3));T=sgn(R-Math.sqrt(D))*Math.pow(Math.abs(R-Math.sqrt(D)),(1/3));t[0]=-A/3+(S+T);t[1]=-A/3-(S+T)/2;t[2]=-A/3-(S+T)/2;if(Math.abs(Math.sqrt(3)*(S-T)/2)!==0){t[1]=-1;t[2]=-1}}else{var th=Math.acos(R/Math.sqrt(-Math.pow(Q,3)));t[0]=2*Math.sqrt(-Q)*Math.cos(th/3)-A/3;t[1]=2*Math.sqrt(-Q)*Math.cos((th+2*Math.PI)/3)-A/3;t[2]=2*Math.sqrt(-Q)*Math.cos((th+4*Math.PI)/3)-A/3}
for(var i=0;i<3;i++){if(t[i]<0||t[i]>1.0){t[i]=-1}}
return t}
var jsBezier=this.jsBezier={distanceFromCurve:_distanceFromCurve,gradientAtPoint:_gradientAtPoint,gradientAtPointAlongCurveFrom:_gradientAtPointAlongPathFrom,nearestPointOnCurve:_nearestPointOnCurve,pointOnCurve:_pointOnPath,pointAlongCurveFrom:_pointAlongPathFrom,perpendicularToCurveAt:_perpendicularToPathAt,locationAlongCurveFrom:_locationAlongPathFrom,getLength:_length,lineIntersection:_lineIntersection,boxIntersection:_boxIntersection,boundingBoxIntersection:_boundingBoxIntersection,version:"0.9.0"};if(typeof exports!=="undefined"){exports.jsBezier=jsBezier}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this;var Biltong=root.Biltong={version:"0.4.0"};if(typeof exports!=="undefined"){exports.Biltong=Biltong}
var _isa=function(a){return Object.prototype.toString.call(a)==="[object Array]"},_pointHelper=function(p1,p2,fn){p1=_isa(p1)?p1:[p1.x,p1.y];p2=_isa(p2)?p2:[p2.x,p2.y];return fn(p1,p2)},_gradient=Biltong.gradient=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){if(_p2[0]==_p1[0])
return _p2[1]>_p1[1]?Infinity:-Infinity;else if(_p2[1]==_p1[1])
return _p2[0]>_p1[0]?0:-0;else return(_p2[1]-_p1[1])/(_p2[0]-_p1[0])})},_normal=Biltong.normal=function(p1,p2){return-1/_gradient(p1,p2)},_lineLength=Biltong.lineLength=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){return Math.sqrt(Math.pow(_p2[1]-_p1[1],2)+Math.pow(_p2[0]-_p1[0],2))})},_quadrant=Biltong.quadrant=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){if(_p2[0]>_p1[0]){return(_p2[1]>_p1[1])?2:1}else if(_p2[0]==_p1[0]){return _p2[1]>_p1[1]?2:1}else{return(_p2[1]>_p1[1])?3:4}})},_theta=Biltong.theta=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){var m=_gradient(_p1,_p2),t=Math.atan(m),s=_quadrant(_p1,_p2);if((s==4||s==3))t+=Math.PI;if(t<0)t+=(2*Math.PI);return t})},_intersects=Biltong.intersects=function(r1,r2){var x1=r1.x,x2=r1.x+r1.w,y1=r1.y,y2=r1.y+r1.h,a1=r2.x,a2=r2.x+r2.w,b1=r2.y,b2=r2.y+r2.h;return((x1<=a1&&a1<=x2)&&(y1<=b1&&b1<=y2))||((x1<=a2&&a2<=x2)&&(y1<=b1&&b1<=y2))||((x1<=a1&&a1<=x2)&&(y1<=b2&&b2<=y2))||((x1<=a2&&a1<=x2)&&(y1<=b2&&b2<=y2))||((a1<=x1&&x1<=a2)&&(b1<=y1&&y1<=b2))||((a1<=x2&&x2<=a2)&&(b1<=y1&&y1<=b2))||((a1<=x1&&x1<=a2)&&(b1<=y2&&y2<=b2))||((a1<=x2&&x1<=a2)&&(b1<=y2&&y2<=b2))},_encloses=Biltong.encloses=function(r1,r2,allowSharedEdges){var x1=r1.x,x2=r1.x+r1.w,y1=r1.y,y2=r1.y+r1.h,a1=r2.x,a2=r2.x+r2.w,b1=r2.y,b2=r2.y+r2.h,c=function(v1,v2,v3,v4){return allowSharedEdges?v1<=v2&&v3>=v4:v1<v2&&v3>v4};return c(x1,a1,x2,a2)&&c(y1,b1,y2,b2)},_segmentMultipliers=[null,[1,-1],[1,1],[-1,1],[-1,-1]],_inverseSegmentMultipliers=[null,[-1,-1],[-1,1],[1,1],[1,-1]],_pointOnLine=Biltong.pointOnLine=function(fromPoint,toPoint,distance){var m=_gradient(fromPoint,toPoint),s=_quadrant(fromPoint,toPoint),segmentMultiplier=distance>0?_segmentMultipliers[s]:_inverseSegmentMultipliers[s],theta=Math.atan(m),y=Math.abs(distance*Math.sin(theta))*segmentMultiplier[1],x=Math.abs(distance*Math.cos(theta))*segmentMultiplier[0];return{x:fromPoint.x+x,y:fromPoint.y+y}},_perpendicularLineTo=Biltong.perpendicularLineTo=function(fromPoint,toPoint,length){var m=_gradient(fromPoint,toPoint),theta2=Math.atan(-1/m),y=length/2*Math.sin(theta2),x=length/2*Math.cos(theta2);return[{x:toPoint.x+x,y:toPoint.y+y},{x:toPoint.x-x,y:toPoint.y-y}]}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";function _touch(view,target,pageX,pageY,screenX,screenY,clientX,clientY){return new Touch({target:target,identifier:_uuid(),pageX:pageX,pageY:pageY,screenX:screenX,screenY:screenY,clientX:clientX||screenX,clientY:clientY||screenY})}
function _touchList(){var list=[];Array.prototype.push.apply(list,arguments);list.item=function(index){return this[index]};return list}
function _touchAndList(view,target,pageX,pageY,screenX,screenY,clientX,clientY){return _touchList(_touch.apply(null,arguments))}
var root=this,matchesSelector=function(el,selector,ctx){ctx=ctx||el.parentNode;var possibles=ctx.querySelectorAll(selector);for(var i=0;i<possibles.length;i++){if(possibles[i]===el){return!0}}
return!1},_gel=function(el){return(typeof el=="string"||el.constructor===String)?document.getElementById(el):el},_t=function(e){return e.srcElement||e.target},_pi=function(e,target,obj,doCompute){if(!doCompute)return{path:[target],end:1};else if(typeof e.path!=="undefined"&&e.path.indexOf){return{path:e.path,end:e.path.indexOf(obj)}}else{var out={path:[],end:-1},_one=function(el){out.path.push(el);if(el===obj){out.end=out.path.length-1}else if(el.parentNode!=null){_one(el.parentNode)}};_one(target);return out}},_d=function(l,fn){for(var i=0,j=l.length;i<j;i++){if(l[i]==fn)break}
if(i<l.length)l.splice(i,1);},guid=1,_store=function(obj,event,fn){var g=guid++;obj.__ta=obj.__ta||{};obj.__ta[event]=obj.__ta[event]||{};obj.__ta[event][g]=fn;fn.__tauid=g;return g},_unstore=function(obj,event,fn){obj.__ta&&obj.__ta[event]&&delete obj.__ta[event][fn.__tauid];if(fn.__taExtra){for(var i=0;i<fn.__taExtra.length;i++){_unbind(obj,fn.__taExtra[i][0],fn.__taExtra[i][1])}
fn.__taExtra.length=0}
fn.__taUnstore&&fn.__taUnstore()},_curryChildFilter=function(children,obj,fn,evt){if(children==null)return fn;else{var c=children.split(","),_fn=function(e){_fn.__tauid=fn.__tauid;var t=_t(e),target=t;var pathInfo=_pi(e,t,obj,children!=null)
if(pathInfo.end!=-1){for(var p=0;p<pathInfo.end;p++){target=pathInfo.path[p];for(var i=0;i<c.length;i++){if(matchesSelector(target,c[i],obj)){fn.apply(target,arguments)}}}}};registerExtraFunction(fn,evt,_fn);return _fn}},registerExtraFunction=function(fn,evt,newFn){fn.__taExtra=fn.__taExtra||[];fn.__taExtra.push([evt,newFn])},DefaultHandler=function(obj,evt,fn,children){if(isTouchDevice&&touchMap[evt]){var tfn=_curryChildFilter(children,obj,fn,touchMap[evt]);_bind(obj,touchMap[evt],tfn,fn)}
if(evt==="focus"&&obj.getAttribute("tabindex")==null){obj.setAttribute("tabindex","1")}
_bind(obj,evt,_curryChildFilter(children,obj,fn,evt),fn)},SmartClickHandler=function(obj,evt,fn,children){if(obj.__taSmartClicks==null){var down=function(e){obj.__tad=_pageLocation(e)},up=function(e){obj.__tau=_pageLocation(e)},click=function(e){if(obj.__tad&&obj.__tau&&obj.__tad[0]===obj.__tau[0]&&obj.__tad[1]===obj.__tau[1]){for(var i=0;i<obj.__taSmartClicks.length;i++)
obj.__taSmartClicks[i].apply(_t(e),[e]);}};DefaultHandler(obj,"mousedown",down,children);DefaultHandler(obj,"mouseup",up,children);DefaultHandler(obj,"click",click,children);obj.__taSmartClicks=[]}
obj.__taSmartClicks.push(fn);fn.__taUnstore=function(){_d(obj.__taSmartClicks,fn)}},_tapProfiles={"tap":{touches:1,taps:1},"dbltap":{touches:1,taps:2},"contextmenu":{touches:2,taps:1}},TapHandler=function(clickThreshold,dblClickThreshold){return function(obj,evt,fn,children){if(evt=="contextmenu"&&isMouseDevice)
DefaultHandler(obj,evt,fn,children);else{if(obj.__taTapHandler==null){var tt=obj.__taTapHandler={tap:[],dbltap:[],contextmenu:[],down:!1,taps:0,downSelectors:[]};var down=function(e){var target=_t(e),pathInfo=_pi(e,target,obj,children!=null),finished=!1;for(var p=0;p<pathInfo.end;p++){if(finished)return;target=pathInfo.path[p];for(var i=0;i<tt.downSelectors.length;i++){if(tt.downSelectors[i]==null||matchesSelector(target,tt.downSelectors[i],obj)){tt.down=!0;setTimeout(clearSingle,clickThreshold);setTimeout(clearDouble,dblClickThreshold);finished=!0;break}}}},up=function(e){if(tt.down){var target=_t(e),currentTarget,pathInfo;tt.taps++;var tc=_touchCount(e);for(var eventId in _tapProfiles){if(_tapProfiles.hasOwnProperty(eventId)){var p=_tapProfiles[eventId];if(p.touches===tc&&(p.taps===1||p.taps===tt.taps)){for(var i=0;i<tt[eventId].length;i++){pathInfo=_pi(e,target,obj,tt[eventId][i][1]!=null);for(var pLoop=0;pLoop<pathInfo.end;pLoop++){currentTarget=pathInfo.path[pLoop];if(tt[eventId][i][1]==null||matchesSelector(currentTarget,tt[eventId][i][1],obj)){tt[eventId][i][0].apply(currentTarget,[e]);break}}}}}}}},clearSingle=function(){tt.down=!1},clearDouble=function(){tt.taps=0};DefaultHandler(obj,"mousedown",down);DefaultHandler(obj,"mouseup",up)}
obj.__taTapHandler.downSelectors.push(children);obj.__taTapHandler[evt].push([fn,children]);fn.__taUnstore=function(){_d(obj.__taTapHandler[evt],fn)}}}},meeHelper=function(type,evt,obj,target){for(var i in obj.__tamee[type]){if(obj.__tamee[type].hasOwnProperty(i)){obj.__tamee[type][i].apply(target,[evt])}}},MouseEnterExitHandler=function(){var activeElements=[];return function(obj,evt,fn,children){if(!obj.__tamee){obj.__tamee={over:!1,mouseenter:[],mouseexit:[]};var over=function(e){var t=_t(e);if((children==null&&(t==obj&&!obj.__tamee.over))||(matchesSelector(t,children,obj)&&(t.__tamee==null||!t.__tamee.over))){meeHelper("mouseenter",e,obj,t);t.__tamee=t.__tamee||{};t.__tamee.over=!0;activeElements.push(t)}},out=function(e){var t=_t(e);for(var i=0;i<activeElements.length;i++){if(t==activeElements[i]&&!matchesSelector((e.relatedTarget||e.toElement),"*",t)){t.__tamee.over=!1;activeElements.splice(i,1);meeHelper("mouseexit",e,obj,t)}}};_bind(obj,"mouseover",_curryChildFilter(children,obj,over,"mouseover"),over);_bind(obj,"mouseout",_curryChildFilter(children,obj,out,"mouseout"),out)}
fn.__taUnstore=function(){delete obj.__tamee[evt][fn.__tauid]};_store(obj,evt,fn);obj.__tamee[evt][fn.__tauid]=fn}},isTouchDevice="ontouchstart" in document.documentElement||navigator.maxTouchPoints,isMouseDevice="onmousedown" in document.documentElement,touchMap={"mousedown":"touchstart","mouseup":"touchend","mousemove":"touchmove"},touchstart="touchstart",touchend="touchend",touchmove="touchmove",iev=(function(){var rv=-1;if(navigator.appName=='Microsoft Internet Explorer'){var ua=navigator.userAgent,re=new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");if(re.exec(ua)!=null)
rv=parseFloat(RegExp.$1);}
return rv})(),isIELT9=iev>-1&&iev<9,_genLoc=function(e,prefix){if(e==null)return[0,0];var ts=_touches(e),t=_getTouch(ts,0);return[t[prefix+"X"],t[prefix+"Y"]]},_pageLocation=function(e){if(e==null)return[0,0];if(isIELT9){return[e.clientX+document.documentElement.scrollLeft,e.clientY+document.documentElement.scrollTop]}else{return _genLoc(e,"page")}},_screenLocation=function(e){return _genLoc(e,"screen")},_clientLocation=function(e){return _genLoc(e,"client")},_getTouch=function(touches,idx){return touches.item?touches.item(idx):touches[idx]},_touches=function(e){return e.touches&&e.touches.length>0?e.touches:e.changedTouches&&e.changedTouches.length>0?e.changedTouches:e.targetTouches&&e.targetTouches.length>0?e.targetTouches:[e]},_touchCount=function(e){return _touches(e).length},_bind=function(obj,type,fn,originalFn){_store(obj,type,fn);originalFn.__tauid=fn.__tauid;if(obj.addEventListener)
obj.addEventListener(type,fn,!1);else if(obj.attachEvent){var key=type+fn.__tauid;obj["e"+key]=fn;obj[key]=function(){obj["e"+key]&&obj["e"+key](window.event)};obj.attachEvent("on"+type,obj[key])}},_unbind=function(obj,type,fn){if(fn==null)return;_each(obj,function(){var _el=_gel(this);_unstore(_el,type,fn);if(fn.__tauid!=null){if(_el.removeEventListener){_el.removeEventListener(type,fn,!1);if(isTouchDevice&&touchMap[type])_el.removeEventListener(touchMap[type],fn,!1);}else if(this.detachEvent){var key=type+fn.__tauid;_el[key]&&_el.detachEvent("on"+type,_el[key]);_el[key]=null;_el["e"+key]=null}}
if(fn.__taTouchProxy){_unbind(obj,fn.__taTouchProxy[1],fn.__taTouchProxy[0])}})},_each=function(obj,fn){if(obj==null)return;obj=(typeof Window!=="undefined"&&(typeof obj.top!=="unknown"&&obj==obj.top))?[obj]:(typeof obj!=="string")&&(obj.tagName==null&&obj.length!=null)?obj:typeof obj==="string"?document.querySelectorAll(obj):[obj];for(var i=0;i<obj.length;i++)
fn.apply(obj[i]);},_uuid=function(){return('xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=Math.random()*16|0,v=c=='x'?r:(r&0x3|0x8);return v.toString(16)}))};root.Mottle=function(params){params=params||{};var clickThreshold=params.clickThreshold||250,dblClickThreshold=params.dblClickThreshold||450,mouseEnterExitHandler=new MouseEnterExitHandler(),tapHandler=new TapHandler(clickThreshold,dblClickThreshold),_smartClicks=params.smartClicks,_doBind=function(obj,evt,fn,children){if(fn==null)return;_each(obj,function(){var _el=_gel(this);if(_smartClicks&&evt==="click")
SmartClickHandler(_el,evt,fn,children);else if(evt==="tap"||evt==="dbltap"||evt==="contextmenu"){tapHandler(_el,evt,fn,children)}else if(evt==="mouseenter"||evt=="mouseexit")
mouseEnterExitHandler(_el,evt,fn,children);else DefaultHandler(_el,evt,fn,children)})};this.remove=function(el){_each(el,function(){var _el=_gel(this);if(_el.__ta){for(var evt in _el.__ta){if(_el.__ta.hasOwnProperty(evt)){for(var h in _el.__ta[evt]){if(_el.__ta[evt].hasOwnProperty(h))
_unbind(_el,evt,_el.__ta[evt][h]);}}}}
_el.parentNode&&_el.parentNode.removeChild(_el)});return this};this.on=function(el,event,children,fn){var _el=arguments[0],_c=arguments.length==4?arguments[2]:null,_e=arguments[1],_f=arguments[arguments.length-1];_doBind(_el,_e,_f,_c);return this};this.off=function(el,event,fn){_unbind(el,event,fn);return this};this.trigger=function(el,event,originalEvent,payload){var originalIsMouse=isMouseDevice&&(typeof MouseEvent==="undefined"||originalEvent==null||originalEvent.constructor===MouseEvent);var eventToBind=(isTouchDevice&&!isMouseDevice&&touchMap[event])?touchMap[event]:event,bindingAMouseEvent=!(isTouchDevice&&!isMouseDevice&&touchMap[event]);var pl=_pageLocation(originalEvent),sl=_screenLocation(originalEvent),cl=_clientLocation(originalEvent);_each(el,function(){var _el=_gel(this),evt;originalEvent=originalEvent||{screenX:sl[0],screenY:sl[1],clientX:cl[0],clientY:cl[1]};var _decorate=function(_evt){if(payload)_evt.payload=payload};var eventGenerators={"TouchEvent":function(evt){var touchList=_touchAndList(window,_el,0,pl[0],pl[1],sl[0],sl[1],cl[0],cl[1]),init=evt.initTouchEvent||evt.initEvent;init(eventToBind,!0,!0,window,null,sl[0],sl[1],cl[0],cl[1],!1,!1,!1,!1,touchList,touchList,touchList,1,0)},"MouseEvents":function(evt){evt.initMouseEvent(eventToBind,!0,!0,window,0,sl[0],sl[1],cl[0],cl[1],!1,!1,!1,!1,1,_el)}};if(document.createEvent){var ite=!bindingAMouseEvent&&!originalIsMouse&&(isTouchDevice&&touchMap[event]),evtName=ite?"TouchEvent":"MouseEvents";evt=document.createEvent(evtName);eventGenerators[evtName](evt);_decorate(evt);_el.dispatchEvent(evt)}else if(document.createEventObject){evt=document.createEventObject();evt.eventType=evt.eventName=eventToBind;evt.screenX=sl[0];evt.screenY=sl[1];evt.clientX=cl[0];evt.clientY=cl[1];_decorate(evt);_el.fireEvent('on'+eventToBind,evt)}});return this}};root.Mottle.consume=function(e,doNotPreventDefault){if(e.stopPropagation)
e.stopPropagation();else e.returnValue=!1;if(!doNotPreventDefault&&e.preventDefault)
e.preventDefault();};root.Mottle.pageLocation=_pageLocation;root.Mottle.setForceTouchEvents=function(value){isTouchDevice=value};root.Mottle.setForceMouseEvents=function(value){isMouseDevice=value};root.Mottle.version="0.8.0";if(typeof exports!=="undefined"){exports.Mottle=root.Mottle}}).call(typeof window==="undefined"?this:window);(function(){"use strict";var root=this;var _suggest=function(list,item,head){if(list.indexOf(item)===-1){head?list.unshift(item):list.push(item);return!0}
return!1};var _vanquish=function(list,item){var idx=list.indexOf(item);if(idx!==-1)list.splice(idx,1);};var _difference=function(l1,l2){var d=[];for(var i=0;i<l1.length;i++){if(l2.indexOf(l1[i])===-1)
d.push(l1[i]);}
return d};var _isString=function(f){return f==null?!1:(typeof f==="string"||f.constructor===String)};var getOffsetRect=function(elem){var box=elem.getBoundingClientRect(),body=document.body,docElem=document.documentElement,scrollTop=window.pageYOffset||docElem.scrollTop||body.scrollTop,scrollLeft=window.pageXOffset||docElem.scrollLeft||body.scrollLeft,clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,top=box.top+scrollTop-clientTop,left=box.left+scrollLeft-clientLeft;return{top:Math.round(top),left:Math.round(left)}};var matchesSelector=function(el,selector,ctx){ctx=ctx||el.parentNode;var possibles=ctx.querySelectorAll(selector);for(var i=0;i<possibles.length;i++){if(possibles[i]===el)
return!0}
return!1};var findDelegateElement=function(parentElement,childElement,selector){if(matchesSelector(childElement,selector,parentElement)){return childElement}else{var currentParent=childElement.parentNode;while(currentParent!=null&&currentParent!==parentElement){if(matchesSelector(currentParent,selector,parentElement)){return currentParent}else{currentParent=currentParent.parentNode}}}};var findMatchingSelector=function(availableSelectors,parentElement,childElement){var el=null;var draggableId=parentElement.getAttribute("katavorio-draggable"),prefix=draggableId!=null?"[katavorio-draggable='"+draggableId+"'] ":"";for(var i=0;i<availableSelectors.length;i++){el=findDelegateElement(parentElement,childElement,prefix+availableSelectors[i].selector);if(el!=null){if(availableSelectors[i].filter){var matches=matchesSelector(childElement,availableSelectors[i].filter,el),exclude=availableSelectors[i].filterExclude===!0;if((exclude&&!matches)||matches){return null}}
return[availableSelectors[i],el]}}
return null};var iev=(function(){var rv=-1;if(navigator.appName==='Microsoft Internet Explorer'){var ua=navigator.userAgent,re=new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");if(re.exec(ua)!=null)
rv=parseFloat(RegExp.$1);}
return rv})(),DEFAULT_GRID_X=10,DEFAULT_GRID_Y=10,isIELT9=iev>-1&&iev<9,isIE9=iev===9,_pl=function(e){if(isIELT9){return[e.clientX+document.documentElement.scrollLeft,e.clientY+document.documentElement.scrollTop]}else{var ts=_touches(e),t=_getTouch(ts,0);return isIE9?[t.pageX||t.clientX,t.pageY||t.clientY]:[t.pageX,t.pageY]}},_getTouch=function(touches,idx){return touches.item?touches.item(idx):touches[idx]},_touches=function(e){return e.touches&&e.touches.length>0?e.touches:e.changedTouches&&e.changedTouches.length>0?e.changedTouches:e.targetTouches&&e.targetTouches.length>0?e.targetTouches:[e]},_classes={delegatedDraggable:"katavorio-delegated-draggable",draggable:"katavorio-draggable",droppable:"katavorio-droppable",drag:"katavorio-drag",selected:"katavorio-drag-selected",active:"katavorio-drag-active",hover:"katavorio-drag-hover",noSelect:"katavorio-drag-no-select",ghostProxy:"katavorio-ghost-proxy",clonedDrag:"katavorio-clone-drag"},_defaultScope="katavorio-drag-scope",_events=["stop","start","drag","drop","over","out","beforeStart"],_devNull=function(){},_true=function(){return!0},_foreach=function(l,fn,from){for(var i=0;i<l.length;i++){if(l[i]!=from)
fn(l[i]);}},_setDroppablesActive=function(dd,val,andHover,drag){_foreach(dd,function(e){e.setActive(val);if(val)e.updatePosition();if(andHover)e.setHover(drag,val);})},_each=function(obj,fn){if(obj==null)return;obj=!_isString(obj)&&(obj.tagName==null&&obj.length!=null)?obj:[obj];for(var i=0;i<obj.length;i++)
fn.apply(obj[i],[obj[i]]);},_consume=function(e){if(e.stopPropagation){e.stopPropagation();e.preventDefault()}else{e.returnValue=!1}},_defaultInputFilterSelector="input,textarea,select,button,option",_inputFilter=function(e,el,_katavorio){var t=e.srcElement||e.target;return!matchesSelector(t,_katavorio.getInputFilterSelector(),el)};var Super=function(el,params,css,scope){this.params=params||{};this.el=el;this.params.addClass(this.el,this._class);this.uuid=_uuid();var enabled=!0;this.setEnabled=function(e){enabled=e};this.isEnabled=function(){return enabled};this.toggleEnabled=function(){enabled=!enabled};this.setScope=function(scopes){this.scopes=scopes?scopes.split(/\s+/):[scope]};this.addScope=function(scopes){var m={};_each(this.scopes,function(s){m[s]=!0});_each(scopes?scopes.split(/\s+/):[],function(s){m[s]=!0});this.scopes=[];for(var i in m)this.scopes.push(i);};this.removeScope=function(scopes){var m={};_each(this.scopes,function(s){m[s]=!0});_each(scopes?scopes.split(/\s+/):[],function(s){delete m[s]});this.scopes=[];for(var i in m)this.scopes.push(i);};this.toggleScope=function(scopes){var m={};_each(this.scopes,function(s){m[s]=!0});_each(scopes?scopes.split(/\s+/):[],function(s){if(m[s])delete m[s];else m[s]=!0});this.scopes=[];for(var i in m)this.scopes.push(i);};this.setScope(params.scope);this.k=params.katavorio;return params.katavorio};var TRUE=function(){return!0};var FALSE=function(){return!1};var Drag=function(el,params,css,scope){this._class=css.draggable;var k=Super.apply(this,arguments);this.rightButtonCanDrag=this.params.rightButtonCanDrag;var downAt=[0,0],posAtDown=null,pagePosAtDown=null,pageDelta=[0,0],moving=!1,initialScroll=[0,0],consumeStartEvent=this.params.consumeStartEvent!==!1,dragEl=this.el,clone=this.params.clone,scroll=this.params.scroll,_multipleDrop=params.multipleDrop!==!1,isConstrained=!1,useGhostProxy,ghostProxy,elementToDrag=null,availableSelectors=[],activeSelectorParams=null,ghostProxyParent=params.ghostProxyParent,currentParentPosition,ghostParentPosition,ghostDx,ghostDy;if(params.ghostProxy===!0){useGhostProxy=TRUE}else{if(params.ghostProxy&&typeof params.ghostProxy==="function"){useGhostProxy=params.ghostProxy}else{useGhostProxy=function(container,dragEl){if(activeSelectorParams&&activeSelectorParams.useGhostProxy){return activeSelectorParams.useGhostProxy(container,dragEl)}else{return!1}}}}
if(params.makeGhostProxy){ghostProxy=params.makeGhostProxy}else{ghostProxy=function(el){if(activeSelectorParams&&activeSelectorParams.makeGhostProxy){return activeSelectorParams.makeGhostProxy(el)}else{return el.cloneNode(!0)}}}
if(params.selector){var draggableId=el.getAttribute("katavorio-draggable");if(draggableId==null){draggableId=""+new Date().getTime();el.setAttribute("katavorio-draggable",draggableId)}
availableSelectors.push(params)}
var snapThreshold=params.snapThreshold,_snap=function(pos,gridX,gridY,thresholdX,thresholdY){var _dx=Math.floor(pos[0]/gridX),_dxl=gridX*_dx,_dxt=_dxl+gridX,_x=Math.abs(pos[0]-_dxl)<=thresholdX?_dxl:Math.abs(_dxt-pos[0])<=thresholdX?_dxt:pos[0];var _dy=Math.floor(pos[1]/gridY),_dyl=gridY*_dy,_dyt=_dyl+gridY,_y=Math.abs(pos[1]-_dyl)<=thresholdY?_dyl:Math.abs(_dyt-pos[1])<=thresholdY?_dyt:pos[1];return[_x,_y]};this.posses=[];this.posseRoles={};this.toGrid=function(pos){if(this.params.grid==null){return pos}else{var tx=this.params.grid?this.params.grid[0]/2:snapThreshold?snapThreshold:DEFAULT_GRID_X/2,ty=this.params.grid?this.params.grid[1]/2:snapThreshold?snapThreshold:DEFAULT_GRID_Y/2;return _snap(pos,this.params.grid[0],this.params.grid[1],tx,ty)}};this.snap=function(x,y){if(dragEl==null)return;x=x||(this.params.grid?this.params.grid[0]:DEFAULT_GRID_X);y=y||(this.params.grid?this.params.grid[1]:DEFAULT_GRID_Y);var p=this.params.getPosition(dragEl),tx=this.params.grid?this.params.grid[0]/2:snapThreshold,ty=this.params.grid?this.params.grid[1]/2:snapThreshold,snapped=_snap(p,x,y,tx,ty);this.params.setPosition(dragEl,snapped);return snapped};this.setUseGhostProxy=function(val){useGhostProxy=val?TRUE:FALSE};var constrain;var negativeFilter=function(pos){return(params.allowNegative===!1)?[Math.max(0,pos[0]),Math.max(0,pos[1])]:pos};var _setConstrain=function(value){constrain=typeof value==="function"?value:value?function(pos,dragEl,_constrainRect,_size){return negativeFilter([Math.max(0,Math.min(_constrainRect.w-_size[0],pos[0])),Math.max(0,Math.min(_constrainRect.h-_size[1],pos[1]))])}.bind(this):function(pos){return negativeFilter(pos)}}.bind(this);_setConstrain(typeof this.params.constrain==="function"?this.params.constrain:(this.params.constrain||this.params.containment));this.setConstrain=function(value){_setConstrain(value)};var _doConstrain=function(pos,dragEl,_constrainRect,_size){if(activeSelectorParams!=null&&activeSelectorParams.constrain&&typeof activeSelectorParams.constrain==="function"){return activeSelectorParams.constrain(pos,dragEl,_constrainRect,_size)}else{return constrain(pos,dragEl,_constrainRect,_size)}};var revertFunction;this.setRevert=function(fn){revertFunction=fn};if(this.params.revert){revertFunction=this.params.revert}
var _assignId=function(obj){if(typeof obj==="function"){obj._katavorioId=_uuid();return obj._katavorioId}else{return obj}},_filters={},_testFilter=function(e){for(var key in _filters){var f=_filters[key];var rv=f[0](e);if(f[1])rv=!rv;if(!rv)return!1}
return!0},_setFilter=this.setFilter=function(f,_exclude){if(f){var key=_assignId(f);_filters[key]=[function(e){var t=e.srcElement||e.target,m;if(_isString(f)){m=matchesSelector(t,f,el)}else if(typeof f==="function"){m=f(e,el)}
return m},_exclude!==!1]}},_addFilter=this.addFilter=_setFilter,_removeFilter=this.removeFilter=function(f){var key=typeof f==="function"?f._katavorioId:f;delete _filters[key]};this.clearAllFilters=function(){_filters={}};this.canDrag=this.params.canDrag||_true;var constrainRect,matchingDroppables=[],intersectingDroppables=[];this.addSelector=function(params){if(params.selector){availableSelectors.push(params)}};this.downListener=function(e){if(e.defaultPrevented){return}
var isNotRightClick=this.rightButtonCanDrag||(e.which!==3&&e.button!==2);if(isNotRightClick&&this.isEnabled()&&this.canDrag()){var _f=_testFilter(e)&&_inputFilter(e,this.el,this.k);if(_f){activeSelectorParams=null;elementToDrag=null;if(availableSelectors.length>0){var match=findMatchingSelector(availableSelectors,this.el,e.target||e.srcElement);if(match!=null){activeSelectorParams=match[0];elementToDrag=match[1]}
if(elementToDrag==null){return}}else{elementToDrag=this.el}
if(clone){dragEl=elementToDrag.cloneNode(!0);this.params.addClass(dragEl,_classes.clonedDrag);dragEl.setAttribute("id",null);dragEl.style.position="absolute";if(this.params.parent!=null){var p=this.params.getPosition(this.el);dragEl.style.left=p[0]+"px";dragEl.style.top=p[1]+"px";this.params.parent.appendChild(dragEl)}else{var b=getOffsetRect(elementToDrag);dragEl.style.left=b.left+"px";dragEl.style.top=b.top+"px";document.body.appendChild(dragEl)}}else{dragEl=elementToDrag}
consumeStartEvent&&_consume(e);downAt=_pl(e);if(dragEl&&dragEl.parentNode){initialScroll=[dragEl.parentNode.scrollLeft,dragEl.parentNode.scrollTop]}
this.params.bind(document,"mousemove",this.moveListener);this.params.bind(document,"mouseup",this.upListener);k.markSelection(this);k.markPosses(this);this.params.addClass(document.body,css.noSelect);_dispatch("beforeStart",{el:this.el,pos:posAtDown,e:e,drag:this})}else if(this.params.consumeFilteredEvents){_consume(e)}}}.bind(this);this.moveListener=function(e){if(downAt){if(!moving){var _continue=_dispatch("start",{el:this.el,pos:posAtDown,e:e,drag:this});if(_continue!==!1){if(!downAt){return}
this.mark(!0);moving=!0}else{this.abort()}}
if(downAt){intersectingDroppables.length=0;var pos=_pl(e),dx=pos[0]-downAt[0],dy=pos[1]-downAt[1],z=this.params.ignoreZoom?1:k.getZoom();if(dragEl&&dragEl.parentNode){dx+=dragEl.parentNode.scrollLeft-initialScroll[0];dy+=dragEl.parentNode.scrollTop-initialScroll[1]}
dx/=z;dy/=z;this.moveBy(dx,dy,e);k.updateSelection(dx,dy,this);k.updatePosses(dx,dy,this)}}}.bind(this);this.upListener=function(e){if(downAt){downAt=null;this.params.unbind(document,"mousemove",this.moveListener);this.params.unbind(document,"mouseup",this.upListener);this.params.removeClass(document.body,css.noSelect);this.unmark(e);k.unmarkSelection(this,e);k.unmarkPosses(this,e);this.stop(e);k.notifyPosseDragStop(this,e);moving=!1;intersectingDroppables.length=0;if(clone){dragEl&&dragEl.parentNode&&dragEl.parentNode.removeChild(dragEl);dragEl=null}else{if(revertFunction&&revertFunction(dragEl,this.params.getPosition(dragEl))===!0){this.params.setPosition(dragEl,posAtDown);_dispatch("revert",dragEl)}}}}.bind(this);this.getFilters=function(){return _filters};this.abort=function(){if(downAt!=null){this.upListener()}};this.getDragElement=function(retrieveOriginalElement){return retrieveOriginalElement?elementToDrag||this.el:dragEl||this.el};var listeners={"start":[],"drag":[],"stop":[],"over":[],"out":[],"beforeStart":[],"revert":[]};if(params.events.start)listeners.start.push(params.events.start);if(params.events.beforeStart)listeners.beforeStart.push(params.events.beforeStart);if(params.events.stop)listeners.stop.push(params.events.stop);if(params.events.drag)listeners.drag.push(params.events.drag);if(params.events.revert)listeners.revert.push(params.events.revert);this.on=function(evt,fn){if(listeners[evt])listeners[evt].push(fn);};this.off=function(evt,fn){if(listeners[evt]){var l=[];for(var i=0;i<listeners[evt].length;i++){if(listeners[evt][i]!==fn)l.push(listeners[evt][i]);}
listeners[evt]=l}};var _dispatch=function(evt,value){var result=null;if(activeSelectorParams&&activeSelectorParams[evt]){result=activeSelectorParams[evt](value)}else if(listeners[evt]){for(var i=0;i<listeners[evt].length;i++){try{var v=listeners[evt][i](value);if(v!=null){result=v}}catch(e){}}}
return result};this.notifyStart=function(e){_dispatch("start",{el:this.el,pos:this.params.getPosition(dragEl),e:e,drag:this})};this.stop=function(e,force){if(force||moving){var positions=[],sel=k.getSelection(),dPos=this.params.getPosition(dragEl);if(sel.length>0){for(var i=0;i<sel.length;i++){var p=this.params.getPosition(sel[i].el);positions.push([sel[i].el,{left:p[0],top:p[1]},sel[i]])}}else{positions.push([dragEl,{left:dPos[0],top:dPos[1]},this])}
_dispatch("stop",{el:dragEl,pos:ghostProxyOffsets||dPos,finalPos:dPos,e:e,drag:this,selection:positions})}};this.mark=function(andNotify){posAtDown=this.params.getPosition(dragEl);pagePosAtDown=this.params.getPosition(dragEl,!0);pageDelta=[pagePosAtDown[0]-posAtDown[0],pagePosAtDown[1]-posAtDown[1]];this.size=this.params.getSize(dragEl);matchingDroppables=k.getMatchingDroppables(this);_setDroppablesActive(matchingDroppables,!0,!1,this);this.params.addClass(dragEl,this.params.dragClass||css.drag);var cs;if(this.params.getConstrainingRectangle){cs=this.params.getConstrainingRectangle(dragEl)}else{cs=this.params.getSize(dragEl.parentNode)}
constrainRect={w:cs[0],h:cs[1]};ghostDx=0;ghostDy=0;if(andNotify){k.notifySelectionDragStart(this)}};var ghostProxyOffsets;this.unmark=function(e,doNotCheckDroppables){_setDroppablesActive(matchingDroppables,!1,!0,this);if(isConstrained&&useGhostProxy(elementToDrag,dragEl)){ghostProxyOffsets=[dragEl.offsetLeft-ghostDx,dragEl.offsetTop-ghostDy];dragEl.parentNode.removeChild(dragEl);dragEl=elementToDrag}else{ghostProxyOffsets=null}
this.params.removeClass(dragEl,this.params.dragClass||css.drag);matchingDroppables.length=0;isConstrained=!1;if(!doNotCheckDroppables){if(intersectingDroppables.length>0&&ghostProxyOffsets){params.setPosition(elementToDrag,ghostProxyOffsets)}
intersectingDroppables.sort(_rankSort);for(var i=0;i<intersectingDroppables.length;i++){var retVal=intersectingDroppables[i].drop(this,e);if(retVal===!0)break}}};this.moveBy=function(dx,dy,e){intersectingDroppables.length=0;var desiredLoc=this.toGrid([posAtDown[0]+dx,posAtDown[1]+dy]),cPos=_doConstrain(desiredLoc,dragEl,constrainRect,this.size);if(useGhostProxy(this.el,dragEl)){if(desiredLoc[0]!==cPos[0]||desiredLoc[1]!==cPos[1]){if(!isConstrained){var gp=ghostProxy(elementToDrag);params.addClass(gp,_classes.ghostProxy);if(ghostProxyParent){ghostProxyParent.appendChild(gp);currentParentPosition=params.getPosition(elementToDrag.parentNode,!0);ghostParentPosition=params.getPosition(params.ghostProxyParent,!0);ghostDx=currentParentPosition[0]-ghostParentPosition[0];ghostDy=currentParentPosition[1]-ghostParentPosition[1]}else{elementToDrag.parentNode.appendChild(gp)}
dragEl=gp;isConstrained=!0}
cPos=desiredLoc}else{if(isConstrained){dragEl.parentNode.removeChild(dragEl);dragEl=elementToDrag;isConstrained=!1;currentParentPosition=null;ghostParentPosition=null;ghostDx=0;ghostDy=0}}}
var rect={x:cPos[0],y:cPos[1],w:this.size[0],h:this.size[1]},pageRect={x:rect.x+pageDelta[0],y:rect.y+pageDelta[1],w:rect.w,h:rect.h},focusDropElement=null;this.params.setPosition(dragEl,[cPos[0]+ghostDx,cPos[1]+ghostDy]);for(var i=0;i<matchingDroppables.length;i++){var r2={x:matchingDroppables[i].pagePosition[0],y:matchingDroppables[i].pagePosition[1],w:matchingDroppables[i].size[0],h:matchingDroppables[i].size[1]};if(this.params.intersects(pageRect,r2)&&(_multipleDrop||focusDropElement==null||focusDropElement===matchingDroppables[i].el)&&matchingDroppables[i].canDrop(this)){if(!focusDropElement)focusDropElement=matchingDroppables[i].el;intersectingDroppables.push(matchingDroppables[i]);matchingDroppables[i].setHover(this,!0,e)}else if(matchingDroppables[i].isHover()){matchingDroppables[i].setHover(this,!1,e)}}
_dispatch("drag",{el:this.el,pos:cPos,e:e,drag:this})};this.destroy=function(){this.params.unbind(this.el,"mousedown",this.downListener);this.params.unbind(document,"mousemove",this.moveListener);this.params.unbind(document,"mouseup",this.upListener);this.downListener=null;this.upListener=null;this.moveListener=null};this.params.bind(this.el,"mousedown",this.downListener);if(this.params.handle)
_setFilter(this.params.handle,!1);else _setFilter(this.params.filter,this.params.filterExclude)};var Drop=function(el,params,css,scope){this._class=css.droppable;this.params=params||{};this.rank=params.rank||0;this._activeClass=this.params.activeClass||css.active;this._hoverClass=this.params.hoverClass||css.hover;Super.apply(this,arguments);var hover=!1;this.allowLoopback=this.params.allowLoopback!==!1;this.setActive=function(val){this.params[val?"addClass":"removeClass"](this.el,this._activeClass)};this.updatePosition=function(){this.position=this.params.getPosition(this.el);this.pagePosition=this.params.getPosition(this.el,!0);this.size=this.params.getSize(this.el)};this.canDrop=this.params.canDrop||function(drag){return!0};this.isHover=function(){return hover};this.setHover=function(drag,val,e){if(val||this.el._katavorioDragHover==null||this.el._katavorioDragHover===drag.el._katavorio){this.params[val?"addClass":"removeClass"](this.el,this._hoverClass);this.el._katavorioDragHover=val?drag.el._katavorio:null;if(hover!==val){this.params.events[val?"over":"out"]({el:this.el,e:e,drag:drag,drop:this})}
hover=val}};this.drop=function(drag,event){return this.params.events.drop({drag:drag,e:event,drop:this})};this.destroy=function(){this._class=null;this._activeClass=null;this._hoverClass=null;hover=null}};var _uuid=function(){return('xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=Math.random()*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16)}))};var _rankSort=function(a,b){return a.rank<b.rank?1:a.rank>b.rank?-1:0};var _gel=function(el){if(el==null)return null;el=(typeof el==="string"||el.constructor===String)?document.getElementById(el):el;if(el==null)return null;el._katavorio=el._katavorio||_uuid();return el};root.Katavorio=function(katavorioParams){var _selection=[],_selectionMap={};this._dragsByScope={};this._dropsByScope={};var _zoom=1,_reg=function(obj,map){_each(obj,function(_obj){for(var i=0;i<_obj.scopes.length;i++){map[_obj.scopes[i]]=map[_obj.scopes[i]]||[];map[_obj.scopes[i]].push(_obj)}})},_unreg=function(obj,map){var c=0;_each(obj,function(_obj){for(var i=0;i<_obj.scopes.length;i++){if(map[_obj.scopes[i]]){var idx=katavorioParams.indexOf(map[_obj.scopes[i]],_obj);if(idx!==-1){map[_obj.scopes[i]].splice(idx,1);c++}}}});return c>0},_getMatchingDroppables=this.getMatchingDroppables=function(drag){var dd=[],_m={};for(var i=0;i<drag.scopes.length;i++){var _dd=this._dropsByScope[drag.scopes[i]];if(_dd){for(var j=0;j<_dd.length;j++){if(_dd[j].canDrop(drag)&&!_m[_dd[j].uuid]&&(_dd[j].allowLoopback||_dd[j].el!==drag.el)){_m[_dd[j].uuid]=!0;dd.push(_dd[j])}}}}
dd.sort(_rankSort);return dd},_prepareParams=function(p){p=p||{};var _p={events:{}},i;for(i in katavorioParams)_p[i]=katavorioParams[i];for(i in p)_p[i]=p[i];for(i=0;i<_events.length;i++){_p.events[_events[i]]=p[_events[i]]||_devNull}
_p.katavorio=this;return _p}.bind(this),_mistletoe=function(existingDrag,params){for(var i=0;i<_events.length;i++){if(params[_events[i]]){existingDrag.on(_events[i],params[_events[i]])}}}.bind(this),_css={},overrideCss=katavorioParams.css||{},_scope=katavorioParams.scope||_defaultScope;for(var i in _classes)_css[i]=_classes[i];for(var i in overrideCss)_css[i]=overrideCss[i];var inputFilterSelector=katavorioParams.inputFilterSelector||_defaultInputFilterSelector;this.getInputFilterSelector=function(){return inputFilterSelector};this.setInputFilterSelector=function(selector){inputFilterSelector=selector;return this};this.draggable=function(el,params){var o=[];_each(el,function(_el){_el=_gel(_el);if(_el!=null){if(_el._katavorioDrag==null){var p=_prepareParams(params);_el._katavorioDrag=new Drag(_el,p,_css,_scope);_reg(_el._katavorioDrag,this._dragsByScope);o.push(_el._katavorioDrag);katavorioParams.addClass(_el,p.selector?_css.delegatedDraggable:_css.draggable)}else{_mistletoe(_el._katavorioDrag,params)}}}.bind(this));return o};this.droppable=function(el,params){var o=[];_each(el,function(_el){_el=_gel(_el);if(_el!=null){var drop=new Drop(_el,_prepareParams(params),_css,_scope);_el._katavorioDrop=_el._katavorioDrop||[];_el._katavorioDrop.push(drop);_reg(drop,this._dropsByScope);o.push(drop);katavorioParams.addClass(_el,_css.droppable)}}.bind(this));return o};this.select=function(el){_each(el,function(){var _el=_gel(this);if(_el&&_el._katavorioDrag){if(!_selectionMap[_el._katavorio]){_selection.push(_el._katavorioDrag);_selectionMap[_el._katavorio]=[_el,_selection.length-1];katavorioParams.addClass(_el,_css.selected)}}});return this};this.deselect=function(el){_each(el,function(){var _el=_gel(this);if(_el&&_el._katavorio){var e=_selectionMap[_el._katavorio];if(e){var _s=[];for(var i=0;i<_selection.length;i++)
if(_selection[i].el!==_el)_s.push(_selection[i]);_selection=_s;delete _selectionMap[_el._katavorio];katavorioParams.removeClass(_el,_css.selected)}}});return this};this.deselectAll=function(){for(var i in _selectionMap){var d=_selectionMap[i];katavorioParams.removeClass(d[0],_css.selected)}
_selection.length=0;_selectionMap={}};this.markSelection=function(drag){_foreach(_selection,function(e){e.mark()},drag)};this.markPosses=function(drag){if(drag.posses){_each(drag.posses,function(p){if(drag.posseRoles[p]&&_posses[p]){_foreach(_posses[p].members,function(d){d.mark()},drag)}})}};this.unmarkSelection=function(drag,event){_foreach(_selection,function(e){e.unmark(event)},drag)};this.unmarkPosses=function(drag,event){if(drag.posses){_each(drag.posses,function(p){if(drag.posseRoles[p]&&_posses[p]){_foreach(_posses[p].members,function(d){d.unmark(event,!0)},drag)}})}};this.getSelection=function(){return _selection.slice(0)};this.updateSelection=function(dx,dy,drag){_foreach(_selection,function(e){e.moveBy(dx,dy)},drag)};var _posseAction=function(fn,drag){if(drag.posses){_each(drag.posses,function(p){if(drag.posseRoles[p]&&_posses[p]){_foreach(_posses[p].members,function(e){fn(e)},drag)}})}};this.updatePosses=function(dx,dy,drag){_posseAction(function(e){e.moveBy(dx,dy)},drag)};this.notifyPosseDragStop=function(drag,evt){_posseAction(function(e){e.stop(evt,!0)},drag)};this.notifySelectionDragStop=function(drag,evt){_foreach(_selection,function(e){e.stop(evt,!0)},drag)};this.notifySelectionDragStart=function(drag,evt){_foreach(_selection,function(e){e.notifyStart(evt)},drag)};this.setZoom=function(z){_zoom=z};this.getZoom=function(){return _zoom};var _scopeManip=function(kObj,scopes,map,fn){_each(kObj,function(_kObj){_unreg(_kObj,map);_kObj[fn](scopes);_reg(_kObj,map)})};_each(["set","add","remove","toggle"],function(v){this[v+"Scope"]=function(el,scopes){_scopeManip(el._katavorioDrag,scopes,this._dragsByScope,v+"Scope");_scopeManip(el._katavorioDrop,scopes,this._dropsByScope,v+"Scope")}.bind(this);this[v+"DragScope"]=function(el,scopes){_scopeManip(el.constructor===Drag?el:el._katavorioDrag,scopes,this._dragsByScope,v+"Scope")}.bind(this);this[v+"DropScope"]=function(el,scopes){_scopeManip(el.constructor===Drop?el:el._katavorioDrop,scopes,this._dropsByScope,v+"Scope")}.bind(this)}.bind(this));this.snapToGrid=function(x,y){for(var s in this._dragsByScope){_foreach(this._dragsByScope[s],function(d){d.snap(x,y)})}};this.getDragsForScope=function(s){return this._dragsByScope[s]};this.getDropsForScope=function(s){return this._dropsByScope[s]};var _destroy=function(el,type,map){el=_gel(el);if(el[type]){var selIdx=_selection.indexOf(el[type]);if(selIdx>=0){_selection.splice(selIdx,1)}
if(_unreg(el[type],map)){_each(el[type],function(kObj){kObj.destroy()})}
delete el[type]}};var _removeListener=function(el,type,evt,fn){el=_gel(el);if(el[type]){el[type].off(evt,fn)}};this.elementRemoved=function(el){if(el._katavorioDrag){this.destroyDraggable(el)}
if(el._katavorioDrop){this.destroyDroppable(el)}};this.destroyDraggable=function(el,evt,fn){if(arguments.length===1){_destroy(el,"_katavorioDrag",this._dragsByScope)}else{_removeListener(el,"_katavorioDrag",evt,fn)}};this.destroyDroppable=function(el,evt,fn){if(arguments.length===1){_destroy(el,"_katavorioDrop",this._dropsByScope)}else{_removeListener(el,"_katavorioDrop",evt,fn)}};this.reset=function(){this._dragsByScope={};this._dropsByScope={};_selection=[];_selectionMap={};_posses={}};var _posses={};var _processOneSpec=function(el,_spec,dontAddExisting){var posseId=_isString(_spec)?_spec:_spec.id;var active=_isString(_spec)?!0:_spec.active!==!1;var posse=_posses[posseId]||(function(){var g={name:posseId,members:[]};_posses[posseId]=g;return g})();_each(el,function(_el){if(_el._katavorioDrag){if(dontAddExisting&&_el._katavorioDrag.posseRoles[posse.name]!=null)return;_suggest(posse.members,_el._katavorioDrag);_suggest(_el._katavorioDrag.posses,posse.name);_el._katavorioDrag.posseRoles[posse.name]=active}});return posse};this.addToPosse=function(el,spec){var posses=[];for(var i=1;i<arguments.length;i++){posses.push(_processOneSpec(el,arguments[i]))}
return posses.length===1?posses[0]:posses};this.setPosse=function(el,spec){var posses=[];for(var i=1;i<arguments.length;i++){posses.push(_processOneSpec(el,arguments[i],!0).name)}
_each(el,function(_el){if(_el._katavorioDrag){var diff=_difference(_el._katavorioDrag.posses,posses);var p=[];Array.prototype.push.apply(p,_el._katavorioDrag.posses);for(var i=0;i<diff.length;i++){this.removeFromPosse(_el,diff[i])}}}.bind(this));return posses.length===1?posses[0]:posses};this.removeFromPosse=function(el,posseId){if(arguments.length<2)throw new TypeError("No posse id provided for remove operation");for(var i=1;i<arguments.length;i++){posseId=arguments[i];_each(el,function(_el){if(_el._katavorioDrag&&_el._katavorioDrag.posses){var d=_el._katavorioDrag;_each(posseId,function(p){_vanquish(_posses[p].members,d);_vanquish(d.posses,p);delete d.posseRoles[p]})}})}};this.removeFromAllPosses=function(el){_each(el,function(_el){if(_el._katavorioDrag&&_el._katavorioDrag.posses){var d=_el._katavorioDrag;_each(d.posses,function(p){_vanquish(_posses[p].members,d)});d.posses.length=0;d.posseRoles={}}})};this.setPosseState=function(el,posseId,state){var posse=_posses[posseId];if(posse){_each(el,function(_el){if(_el._katavorioDrag&&_el._katavorioDrag.posses){_el._katavorioDrag.posseRoles[posse.name]=state}})}}};root.Katavorio.version="1.0.0";if(typeof exports!=="undefined"){exports.Katavorio=root.Katavorio}}).call(typeof window!=='undefined'?window:this);(function(){var root=this;root.jsPlumbUtil=root.jsPlumbUtil||{};var jsPlumbUtil=root.jsPlumbUtil;if(typeof exports!=='undefined'){exports.jsPlumbUtil=jsPlumbUtil}
function isArray(a){return Object.prototype.toString.call(a)==="[object Array]"}
jsPlumbUtil.isArray=isArray;function isNumber(n){return Object.prototype.toString.call(n)==="[object Number]"}
jsPlumbUtil.isNumber=isNumber;function isString(s){return typeof s==="string"}
jsPlumbUtil.isString=isString;function isBoolean(s){return typeof s==="boolean"}
jsPlumbUtil.isBoolean=isBoolean;function isNull(s){return s==null}
jsPlumbUtil.isNull=isNull;function isObject(o){return o==null?!1:Object.prototype.toString.call(o)==="[object Object]"}
jsPlumbUtil.isObject=isObject;function isDate(o){return Object.prototype.toString.call(o)==="[object Date]"}
jsPlumbUtil.isDate=isDate;function isFunction(o){return Object.prototype.toString.call(o)==="[object Function]"}
jsPlumbUtil.isFunction=isFunction;function isNamedFunction(o){return isFunction(o)&&o.name!=null&&o.name.length>0}
jsPlumbUtil.isNamedFunction=isNamedFunction;function isEmpty(o){for(var i in o){if(o.hasOwnProperty(i)){return!1}}
return!0}
jsPlumbUtil.isEmpty=isEmpty;function clone(a){if(isString(a)){return""+a}else if(isBoolean(a)){return!!a}else if(isDate(a)){return new Date(a.getTime())}else if(isFunction(a)){return a}else if(isArray(a)){var b=[];for(var i=0;i<a.length;i++){b.push(clone(a[i]))}
return b}else if(isObject(a)){var c={};for(var j in a){c[j]=clone(a[j])}
return c}else{return a}}
jsPlumbUtil.clone=clone;function merge(a,b,collations,overwrites){var cMap={},ar,i,oMap={};collations=collations||[];overwrites=overwrites||[];for(i=0;i<collations.length;i++){cMap[collations[i]]=!0}
for(i=0;i<overwrites.length;i++){oMap[overwrites[i]]=!0}
var c=clone(a);for(i in b){if(c[i]==null||oMap[i]){c[i]=b[i]}else if(isString(b[i])||isBoolean(b[i])){if(!cMap[i]){c[i]=b[i]}else{ar=[];ar.push.apply(ar,isArray(c[i])?c[i]:[c[i]]);ar.push.apply(ar,isBoolean(b[i])?b[i]:[b[i]]);c[i]=ar}}else{if(isArray(b[i])){ar=[];if(isArray(c[i])){ar.push.apply(ar,c[i])}
ar.push.apply(ar,b[i]);c[i]=ar}else if(isObject(b[i])){if(!isObject(c[i])){c[i]={}}
for(var j in b[i]){c[i][j]=b[i][j]}}}}
return c}
jsPlumbUtil.merge=merge;function replace(inObj,path,value){if(inObj==null){return}
var q=inObj,t=q;path.replace(/([^\.])+/g,function(term,lc,pos,str){var array=term.match(/([^\[0-9]+){1}(\[)([0-9+])/),last=pos+term.length>=str.length,_getArray=function(){return t[array[1]]||(function(){t[array[1]]=[];return t[array[1]]})()};if(last){if(array){_getArray()[array[3]]=value}else{t[term]=value}}else{if(array){var a_1=_getArray();t=a_1[array[3]]||(function(){a_1[array[3]]={};return a_1[array[3]]})()}else{t=t[term]||(function(){t[term]={};return t[term]})()}}
return""});return inObj}
jsPlumbUtil.replace=replace;function functionChain(successValue,failValue,fns){for(var i=0;i<fns.length;i++){var o=fns[i][0][fns[i][1]].apply(fns[i][0],fns[i][2]);if(o===failValue){return o}}
return successValue}
jsPlumbUtil.functionChain=functionChain;function populate(model,values,functionPrefix,doNotExpandFunctions){var getValue=function(fromString){var matches=fromString.match(/(\${.*?})/g);if(matches!=null){for(var i=0;i<matches.length;i++){var val=values[matches[i].substring(2,matches[i].length-1)]||"";if(val!=null){fromString=fromString.replace(matches[i],val)}}}
return fromString};var _one=function(d){if(d!=null){if(isString(d)){return getValue(d)}else if(isFunction(d)&&!doNotExpandFunctions&&(functionPrefix==null||(d.name||"").indexOf(functionPrefix)===0)){return d(values)}else if(isArray(d)){var r=[];for(var i=0;i<d.length;i++){r.push(_one(d[i]))}
return r}else if(isObject(d)){var s={};for(var j in d){s[j]=_one(d[j])}
return s}else{return d}}};return _one(model)}
jsPlumbUtil.populate=populate;function findWithFunction(a,f){if(a){for(var i=0;i<a.length;i++){if(f(a[i])){return i}}}
return-1}
jsPlumbUtil.findWithFunction=findWithFunction;function removeWithFunction(a,f){var idx=findWithFunction(a,f);if(idx>-1){a.splice(idx,1)}
return idx!==-1}
jsPlumbUtil.removeWithFunction=removeWithFunction;function remove(l,v){var idx=l.indexOf(v);if(idx>-1){l.splice(idx,1)}
return idx!==-1}
jsPlumbUtil.remove=remove;function addWithFunction(list,item,hashFunction){if(findWithFunction(list,hashFunction)===-1){list.push(item)}}
jsPlumbUtil.addWithFunction=addWithFunction;function addToList(map,key,value,insertAtStart){var l=map[key];if(l==null){l=[];map[key]=l}
l[insertAtStart?"unshift":"push"](value);return l}
jsPlumbUtil.addToList=addToList;function suggest(list,item,insertAtHead){if(list.indexOf(item)===-1){if(insertAtHead){list.unshift(item)}else{list.push(item)}
return!0}
return!1}
jsPlumbUtil.suggest=suggest;function extend(child,parent,_protoFn){var i;parent=isArray(parent)?parent:[parent];var _copyProtoChain=function(focus){var proto=focus.__proto__;while(proto!=null){if(proto.prototype!=null){for(var j in proto.prototype){if(proto.prototype.hasOwnProperty(j)&&!child.prototype.hasOwnProperty(j)){child.prototype[j]=proto.prototype[j]}}
proto=proto.prototype.__proto__}else{proto=null}}};for(i=0;i<parent.length;i++){for(var j in parent[i].prototype){if(parent[i].prototype.hasOwnProperty(j)&&!child.prototype.hasOwnProperty(j)){child.prototype[j]=parent[i].prototype[j]}}
_copyProtoChain(parent[i])}
var _makeFn=function(name,protoFn){return function(){for(i=0;i<parent.length;i++){if(parent[i].prototype[name]){parent[i].prototype[name].apply(this,arguments)}}
return protoFn.apply(this,arguments)}};var _oneSet=function(fns){for(var k in fns){child.prototype[k]=_makeFn(k,fns[k])}};if(arguments.length>2){for(i=2;i<arguments.length;i++){_oneSet(arguments[i])}}
return child}
jsPlumbUtil.extend=extend;var lut=[];for(var i=0;i<256;i++){lut[i]=(i<16?'0':'')+(i).toString(16)}
function uuid(){var d0=Math.random()*0xffffffff|0;var d1=Math.random()*0xffffffff|0;var d2=Math.random()*0xffffffff|0;var d3=Math.random()*0xffffffff|0;return lut[d0&0xff]+lut[d0>>8&0xff]+lut[d0>>16&0xff]+lut[d0>>24&0xff]+'-'+lut[d1&0xff]+lut[d1>>8&0xff]+'-'+lut[d1>>16&0x0f|0x40]+lut[d1>>24&0xff]+'-'+lut[d2&0x3f|0x80]+lut[d2>>8&0xff]+'-'+lut[d2>>16&0xff]+lut[d2>>24&0xff]+lut[d3&0xff]+lut[d3>>8&0xff]+lut[d3>>16&0xff]+lut[d3>>24&0xff]}
jsPlumbUtil.uuid=uuid;function fastTrim(s){if(s==null){return null}
var str=s.replace(/^\s\s*/,''),ws=/\s/,i=str.length;while(ws.test(str.charAt(--i))){}
return str.slice(0,i+1)}
jsPlumbUtil.fastTrim=fastTrim;function each(obj,fn){obj=obj.length==null||typeof obj==="string"?[obj]:obj;for(var i=0;i<obj.length;i++){fn(obj[i])}}
jsPlumbUtil.each=each;function map(obj,fn){var o=[];for(var i=0;i<obj.length;i++){o.push(fn(obj[i]))}
return o}
jsPlumbUtil.map=map;function mergeWithParents(type,map,parentAttribute){parentAttribute=parentAttribute||"parent";var _def=function(id){return id?map[id]:null};var _parent=function(def){return def?_def(def[parentAttribute]):null};var _one=function(parent,def){if(parent==null){return def}else{var overrides=["anchor","anchors","cssClass","connector","paintStyle","hoverPaintStyle","endpoint","endpoints"];if(def.mergeStrategy==="override"){Array.prototype.push.apply(overrides,["events","overlays"])}
var d_1=merge(parent,def,[],overrides);return _one(_parent(parent),d_1)}};var _getDef=function(t){if(t==null){return{}}
if(typeof t==="string"){return _def(t)}else if(t.length){var done=!1,i=0,_dd=void 0;while(!done&&i<t.length){_dd=_getDef(t[i]);if(_dd){done=!0}else{i++}}
return _dd}};var d=_getDef(type);if(d){return _one(_parent(d),d)}else{return{}}}
jsPlumbUtil.mergeWithParents=mergeWithParents;jsPlumbUtil.logEnabled=!0;function log(){var args=[];for(var _i=0;_i<arguments.length;_i++){args[_i]=arguments[_i]}
if(jsPlumbUtil.logEnabled&&typeof console!=="undefined"){try{var msg=arguments[arguments.length-1];console.log(msg)}catch(e){}}}
jsPlumbUtil.log=log;function wrap(wrappedFunction,newFunction,returnOnThisValue){return function(){var r=null;try{if(newFunction!=null){r=newFunction.apply(this,arguments)}}catch(e){log("jsPlumb function failed : "+e)}
if((wrappedFunction!=null)&&(returnOnThisValue==null||(r!==returnOnThisValue))){try{r=wrappedFunction.apply(this,arguments)}catch(e){log("wrapped function failed : "+e)}}
return r}}
jsPlumbUtil.wrap=wrap;var EventGenerator=(function(){function EventGenerator(){var _this=this;this._listeners={};this.eventsSuspended=!1;this.tick=!1;this.eventsToDieOn={"ready":!0};this.queue=[];this.bind=function(event,listener,insertAtStart){var _one=function(evt){addToList(_this._listeners,evt,listener,insertAtStart);listener.__jsPlumb=listener.__jsPlumb||{};listener.__jsPlumb[uuid()]=evt};if(typeof event==="string"){_one(event)}else if(event.length!=null){for(var i=0;i<event.length;i++){_one(event[i])}}
return _this};this.fire=function(event,value,originalEvent){if(!this.tick){this.tick=!0;if(!this.eventsSuspended&&this._listeners[event]){var l=this._listeners[event].length,i=0,_gone=!1,ret=null;if(!this.shouldFireEvent||this.shouldFireEvent(event,value,originalEvent)){while(!_gone&&i<l&&ret!==!1){if(this.eventsToDieOn[event]){this._listeners[event][i].apply(this,[value,originalEvent])}else{try{ret=this._listeners[event][i].apply(this,[value,originalEvent])}catch(e){log("jsPlumb: fire failed for event "+event+" : "+e)}}
i++;if(this._listeners==null||this._listeners[event]==null){_gone=!0}}}}
this.tick=!1;this._drain()}else{this.queue.unshift(arguments)}
return this};this._drain=function(){var n=_this.queue.pop();if(n){_this.fire.apply(_this,n)}};this.unbind=function(eventOrListener,listener){if(arguments.length===0){this._listeners={}}else if(arguments.length===1){if(typeof eventOrListener==="string"){delete this._listeners[eventOrListener]}else if(eventOrListener.__jsPlumb){var evt=void 0;for(var i in eventOrListener.__jsPlumb){evt=eventOrListener.__jsPlumb[i];remove(this._listeners[evt]||[],eventOrListener)}}}else if(arguments.length===2){remove(this._listeners[eventOrListener]||[],listener)}
return this};this.getListener=function(forEvent){return _this._listeners[forEvent]};this.setSuspendEvents=function(val){_this.eventsSuspended=val};this.isSuspendEvents=function(){return _this.eventsSuspended};this.silently=function(fn){_this.setSuspendEvents(!0);try{fn()}catch(e){log("Cannot execute silent function "+e)}
_this.setSuspendEvents(!1)};this.cleanupListeners=function(){for(var i in _this._listeners){_this._listeners[i]=null}}}
return EventGenerator}());jsPlumbUtil.EventGenerator=EventGenerator;function rotatePoint(point,center,rotation){var radial=[point[0]-center[0],point[1]-center[1]],cr=Math.cos(rotation/360*Math.PI*2),sr=Math.sin(rotation/360*Math.PI*2);return[(radial[0]*cr)-(radial[1]*sr)+center[0],(radial[1]*cr)+(radial[0]*sr)+center[1],cr,sr]}
jsPlumbUtil.rotatePoint=rotatePoint;function rotateAnchorOrientation(orientation,rotation){var r=rotatePoint(orientation,[0,0],rotation);return[Math.round(r[0]),Math.round(r[1])]}
jsPlumbUtil.rotateAnchorOrientation=rotateAnchorOrientation}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this;root.jsPlumbUtil.matchesSelector=function(el,selector,ctx){ctx=ctx||el.parentNode;var possibles=ctx.querySelectorAll(selector);for(var i=0;i<possibles.length;i++){if(possibles[i]===el){return!0}}
return!1};root.jsPlumbUtil.consume=function(e,doNotPreventDefault){if(e.stopPropagation){e.stopPropagation()}else{e.returnValue=!1}
if(!doNotPreventDefault&&e.preventDefault){e.preventDefault()}};root.jsPlumbUtil.sizeElement=function(el,x,y,w,h){if(el){el.style.height=h+"px";el.height=h;el.style.width=w+"px";el.width=w;el.style.left=x+"px";el.style.top=y+"px"}}}).call(typeof window!=='undefined'?window:this);(function(){var DEFAULT_OPTIONS={deriveAnchor:function(edge,index,ep,conn){return{top:["TopRight","TopLeft"],bottom:["BottomRight","BottomLeft"]}[edge][index]}};var root=this;var ListManager=function(jsPlumbInstance,params){this.count=0;this.instance=jsPlumbInstance;this.lists={};this.options=params||{};this.instance.addList=function(el,options){return this.listManager.addList(el,options)};this.instance.removeList=function(el){this.listManager.removeList(el)};this.instance.bind("manageElement",function(p){var scrollableLists=this.instance.getSelector(p.el,"[jtk-scrollable-list]");for(var i=0;i<scrollableLists.length;i++){this.addList(scrollableLists[i])}}.bind(this));this.instance.bind("unmanageElement",function(p){this.removeList(p.el)});this.instance.bind("connection",function(c,evt){if(evt==null){this._maybeUpdateParentList(c.source);this._maybeUpdateParentList(c.target)}}.bind(this))};root.jsPlumbListManager=ListManager;ListManager.prototype={addList:function(el,options){var dp=this.instance.extend({},DEFAULT_OPTIONS);this.instance.extend(dp,this.options);options=this.instance.extend(dp,options||{});var id=[this.instance.getInstanceIndex(),this.count++].join("_");this.lists[id]=new List(this.instance,el,options,id)},removeList:function(el){var list=this.lists[el._jsPlumbList];if(list){list.destroy();delete this.lists[el._jsPlumbList]}},_maybeUpdateParentList:function(el){var parent=el.parentNode,container=this.instance.getContainer();while(parent!=null&&parent!==container){if(parent._jsPlumbList!=null&&this.lists[parent._jsPlumbList]!=null){parent._jsPlumbScrollHandler();return}
parent=parent.parentNode}}};var List=function(instance,el,options,id){el._jsPlumbList=id;function deriveAnchor(edge,index,ep,conn){return options.anchor?options.anchor:options.deriveAnchor(edge,index,ep,conn)}
function deriveEndpoint(edge,index,ep,conn){return options.deriveEndpoint?options.deriveEndpoint(edge,index,ep,conn):options.endpoint?options.endpoint:ep.type}
function _maybeUpdateDraggable(el){var parent=el.parentNode,container=instance.getContainer();while(parent!=null&&parent!==container){if(instance.hasClass(parent,"jtk-managed")){instance.recalculateOffsets(parent);return}
parent=parent.parentNode}}
var scrollHandler=function(e){var children=instance.getSelector(el,".jtk-managed");var elId=instance.getId(el);for(var i=0;i<children.length;i++){if(children[i].offsetTop<el.scrollTop){if(!children[i]._jsPlumbProxies){children[i]._jsPlumbProxies=children[i]._jsPlumbProxies||[];instance.select({source:children[i]}).each(function(c){instance.proxyConnection(c,0,el,elId,function(){return deriveEndpoint("top",0,c.endpoints[0],c)},function(){return deriveAnchor("top",0,c.endpoints[0],c)});children[i]._jsPlumbProxies.push([c,0])});instance.select({target:children[i]}).each(function(c){instance.proxyConnection(c,1,el,elId,function(){return deriveEndpoint("top",1,c.endpoints[1],c)},function(){return deriveAnchor("top",1,c.endpoints[1],c)});children[i]._jsPlumbProxies.push([c,1])})}}else if(children[i].offsetTop+children[i].offsetHeight>el.scrollTop+el.offsetHeight){if(!children[i]._jsPlumbProxies){children[i]._jsPlumbProxies=children[i]._jsPlumbProxies||[];instance.select({source:children[i]}).each(function(c){instance.proxyConnection(c,0,el,elId,function(){return deriveEndpoint("bottom",0,c.endpoints[0],c)},function(){return deriveAnchor("bottom",0,c.endpoints[0],c)});children[i]._jsPlumbProxies.push([c,0])});instance.select({target:children[i]}).each(function(c){instance.proxyConnection(c,1,el,elId,function(){return deriveEndpoint("bottom",1,c.endpoints[1],c)},function(){return deriveAnchor("bottom",1,c.endpoints[1],c)});children[i]._jsPlumbProxies.push([c,1])})}}else if(children[i]._jsPlumbProxies){for(var j=0;j<children[i]._jsPlumbProxies.length;j++){instance.unproxyConnection(children[i]._jsPlumbProxies[j][0],children[i]._jsPlumbProxies[j][1],elId)}
delete children[i]._jsPlumbProxies}
instance.revalidate(children[i])}
_maybeUpdateDraggable(el)};instance.setAttribute(el,"jtk-scrollable-list","true");el._jsPlumbScrollHandler=scrollHandler;instance.on(el,"scroll",scrollHandler);scrollHandler();this.destroy=function(){instance.off(el,"scroll",scrollHandler);delete el._jsPlumbScrollHandler;var children=instance.getSelector(el,".jtk-managed");var elId=instance.getId(el);for(var i=0;i<children.length;i++){if(children[i]._jsPlumbProxies){for(var j=0;j<children[i]._jsPlumbProxies.length;j++){instance.unproxyConnection(children[i]._jsPlumbProxies[j][0],children[i]._jsPlumbProxies[j][1],elId)}
delete children[i]._jsPlumbProxies}}}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this;var _ju=root.jsPlumbUtil,_updateHoverStyle=function(component){if(component._jsPlumb.paintStyle&&component._jsPlumb.hoverPaintStyle){var mergedHoverStyle={};jsPlumb.extend(mergedHoverStyle,component._jsPlumb.paintStyle);jsPlumb.extend(mergedHoverStyle,component._jsPlumb.hoverPaintStyle);delete component._jsPlumb.hoverPaintStyle;if(mergedHoverStyle.gradient&&component._jsPlumb.paintStyle.fill){delete mergedHoverStyle.gradient}
component._jsPlumb.hoverPaintStyle=mergedHoverStyle}},events=["tap","dbltap","click","dblclick","mouseover","mouseout","mousemove","mousedown","mouseup","contextmenu"],eventFilters={"mouseout":"mouseleave","mouseexit":"mouseleave"},_updateAttachedElements=function(component,state,timestamp,sourceElement){var affectedElements=component.getAttachedElements();if(affectedElements){for(var i=0,j=affectedElements.length;i<j;i++){if(!sourceElement||sourceElement!==affectedElements[i]){affectedElements[i].setHover(state,!0,timestamp)}}}},_splitType=function(t){return t==null?null:t.split(" ")},_mapType=function(map,obj,typeId){for(var i in obj){map[i]=typeId}},_each=function(fn,obj){obj=_ju.isArray(obj)||(obj.length!=null&&!_ju.isString(obj))?obj:[obj];for(var i=0;i<obj.length;i++){try{fn.apply(obj[i],[obj[i]])}catch(e){_ju.log(".each iteration failed : "+e)}}},_applyTypes=function(component,params,doNotRepaint){if(component.getDefaultType){var td=component.getTypeDescriptor(),map={};var defType=component.getDefaultType();var o=_ju.merge({},defType);_mapType(map,defType,"__default");for(var i=0,j=component._jsPlumb.types.length;i<j;i++){var tid=component._jsPlumb.types[i];if(tid!=="__default"){var _t=component._jsPlumb.instance.getType(tid,td);if(_t!=null){var overrides=["anchor","anchors","connector","paintStyle","hoverPaintStyle","endpoint","endpoints","connectorOverlays","connectorStyle","connectorHoverStyle","endpointStyle","endpointHoverStyle"];var collations=[];if(_t.mergeStrategy==="override"){Array.prototype.push.apply(overrides,["events","overlays","cssClass"])}else{collations.push("cssClass")}
o=_ju.merge(o,_t,collations,overrides);_mapType(map,_t,tid)}}}
if(params){o=_ju.populate(o,params,"_")}
component.applyType(o,doNotRepaint,map);if(!doNotRepaint){component.repaint()}}},jsPlumbUIComponent=root.jsPlumbUIComponent=function(params){_ju.EventGenerator.apply(this,arguments);var self=this,a=arguments,idPrefix=self.idPrefix,id=idPrefix+(new Date()).getTime();this._jsPlumb={instance:params._jsPlumb,parameters:params.parameters||{},paintStyle:null,hoverPaintStyle:null,paintStyleInUse:null,hover:!1,beforeDetach:params.beforeDetach,beforeDrop:params.beforeDrop,overlayPlacements:[],hoverClass:params.hoverClass||params._jsPlumb.Defaults.HoverClass,types:[],typeCache:{}};this.cacheTypeItem=function(key,item,typeId){this._jsPlumb.typeCache[typeId]=this._jsPlumb.typeCache[typeId]||{};this._jsPlumb.typeCache[typeId][key]=item};this.getCachedTypeItem=function(key,typeId){return this._jsPlumb.typeCache[typeId]?this._jsPlumb.typeCache[typeId][key]:null};this.getId=function(){return id};var o=params.overlays||[],oo={};if(this.defaultOverlayKeys){for(var i=0;i<this.defaultOverlayKeys.length;i++){Array.prototype.push.apply(o,this._jsPlumb.instance.Defaults[this.defaultOverlayKeys[i]]||[])}
for(i=0;i<o.length;i++){var fo=jsPlumb.convertToFullOverlaySpec(o[i]);oo[fo[1].id]=fo}}
var _defaultType={overlays:oo,parameters:params.parameters||{},scope:params.scope||this._jsPlumb.instance.getDefaultScope()};this.getDefaultType=function(){return _defaultType};this.appendToDefaultType=function(obj){for(var i in obj){_defaultType[i]=obj[i]}};if(params.events){for(var evtName in params.events){self.bind(evtName,params.events[evtName])}}
this.clone=function(){var o=Object.create(this.constructor.prototype);this.constructor.apply(o,a);return o}.bind(this);this.isDetachAllowed=function(connection){var r=!0;if(this._jsPlumb.beforeDetach){try{r=this._jsPlumb.beforeDetach(connection)}catch(e){_ju.log("jsPlumb: beforeDetach callback failed",e)}}
return r};this.isDropAllowed=function(sourceId,targetId,scope,connection,dropEndpoint,source,target){var r=this._jsPlumb.instance.checkCondition("beforeDrop",{sourceId:sourceId,targetId:targetId,scope:scope,connection:connection,dropEndpoint:dropEndpoint,source:source,target:target});if(this._jsPlumb.beforeDrop){try{r=this._jsPlumb.beforeDrop({sourceId:sourceId,targetId:targetId,scope:scope,connection:connection,dropEndpoint:dropEndpoint,source:source,target:target})}catch(e){_ju.log("jsPlumb: beforeDrop callback failed",e)}}
return r};var domListeners=[];this.setListenerComponent=function(c){for(var i=0;i<domListeners.length;i++){domListeners[i][3]=c}}};var _removeTypeCssHelper=function(component,typeIndex){var typeId=component._jsPlumb.types[typeIndex],type=component._jsPlumb.instance.getType(typeId,component.getTypeDescriptor());if(type!=null&&type.cssClass&&component.canvas){component._jsPlumb.instance.removeClass(component.canvas,type.cssClass)}};_ju.extend(root.jsPlumbUIComponent,_ju.EventGenerator,{getParameter:function(name){return this._jsPlumb.parameters[name]},setParameter:function(name,value){this._jsPlumb.parameters[name]=value},getParameters:function(){return this._jsPlumb.parameters},setParameters:function(p){this._jsPlumb.parameters=p},getClass:function(){return jsPlumb.getClass(this.canvas)},hasClass:function(clazz){return jsPlumb.hasClass(this.canvas,clazz)},addClass:function(clazz){jsPlumb.addClass(this.canvas,clazz)},removeClass:function(clazz){jsPlumb.removeClass(this.canvas,clazz)},updateClasses:function(classesToAdd,classesToRemove){jsPlumb.updateClasses(this.canvas,classesToAdd,classesToRemove)},setType:function(typeId,params,doNotRepaint){this.clearTypes();this._jsPlumb.types=_splitType(typeId)||[];_applyTypes(this,params,doNotRepaint)},getType:function(){return this._jsPlumb.types},reapplyTypes:function(params,doNotRepaint){_applyTypes(this,params,doNotRepaint)},hasType:function(typeId){return this._jsPlumb.types.indexOf(typeId)!==-1},addType:function(typeId,params,doNotRepaint){var t=_splitType(typeId),_cont=!1;if(t!=null){for(var i=0,j=t.length;i<j;i++){if(!this.hasType(t[i])){this._jsPlumb.types.push(t[i]);_cont=!0}}
if(_cont){_applyTypes(this,params,doNotRepaint)}}},removeType:function(typeId,params,doNotRepaint){var t=_splitType(typeId),_cont=!1,_one=function(tt){var idx=this._jsPlumb.types.indexOf(tt);if(idx!==-1){_removeTypeCssHelper(this,idx);this._jsPlumb.types.splice(idx,1);return!0}
return!1}.bind(this);if(t!=null){for(var i=0,j=t.length;i<j;i++){_cont=_one(t[i])||_cont}
if(_cont){_applyTypes(this,params,doNotRepaint)}}},clearTypes:function(params,doNotRepaint){var i=this._jsPlumb.types.length;for(var j=0;j<i;j++){_removeTypeCssHelper(this,0);this._jsPlumb.types.splice(0,1)}
_applyTypes(this,params,doNotRepaint)},toggleType:function(typeId,params,doNotRepaint){var t=_splitType(typeId);if(t!=null){for(var i=0,j=t.length;i<j;i++){var idx=this._jsPlumb.types.indexOf(t[i]);if(idx!==-1){_removeTypeCssHelper(this,idx);this._jsPlumb.types.splice(idx,1)}else{this._jsPlumb.types.push(t[i])}}
_applyTypes(this,params,doNotRepaint)}},applyType:function(t,doNotRepaint){this.setPaintStyle(t.paintStyle,doNotRepaint);this.setHoverPaintStyle(t.hoverPaintStyle,doNotRepaint);if(t.parameters){for(var i in t.parameters){this.setParameter(i,t.parameters[i])}}
this._jsPlumb.paintStyleInUse=this.getPaintStyle()},setPaintStyle:function(style,doNotRepaint){this._jsPlumb.paintStyle=style;this._jsPlumb.paintStyleInUse=this._jsPlumb.paintStyle;_updateHoverStyle(this);if(!doNotRepaint){this.repaint()}},getPaintStyle:function(){return this._jsPlumb.paintStyle},setHoverPaintStyle:function(style,doNotRepaint){this._jsPlumb.hoverPaintStyle=style;_updateHoverStyle(this);if(!doNotRepaint){this.repaint()}},getHoverPaintStyle:function(){return this._jsPlumb.hoverPaintStyle},destroy:function(force){if(force||this.typeId==null){this.cleanupListeners();this.clone=null;this._jsPlumb=null}},isHover:function(){return this._jsPlumb.hover},setHover:function(hover,ignoreAttachedElements,timestamp){if(this._jsPlumb&&!this._jsPlumb.instance.currentlyDragging&&!this._jsPlumb.instance.isHoverSuspended()){this._jsPlumb.hover=hover;var method=hover?"addClass":"removeClass";if(this.canvas!=null){if(this._jsPlumb.instance.hoverClass!=null){this._jsPlumb.instance[method](this.canvas,this._jsPlumb.instance.hoverClass)}
if(this._jsPlumb.hoverClass!=null){this._jsPlumb.instance[method](this.canvas,this._jsPlumb.hoverClass)}}
if(this._jsPlumb.hoverPaintStyle!=null){this._jsPlumb.paintStyleInUse=hover?this._jsPlumb.hoverPaintStyle:this._jsPlumb.paintStyle;if(!this._jsPlumb.instance.isSuspendDrawing()){timestamp=timestamp||jsPlumbUtil.uuid();this.repaint({timestamp:timestamp,recalc:!1})}}
if(this.getAttachedElements&&!ignoreAttachedElements){_updateAttachedElements(this,hover,jsPlumbUtil.uuid(),this)}}}});var _jsPlumbInstanceIndex=0,getInstanceIndex=function(){var i=_jsPlumbInstanceIndex+1;_jsPlumbInstanceIndex++;return i};var jsPlumbInstance=root.jsPlumbInstance=function(_defaults){this.version="2.15.6";this.Defaults={Anchor:"Bottom",Anchors:[null,null],ConnectionsDetachable:!0,ConnectionOverlays:[],Connector:"Bezier",Container:null,DoNotThrowErrors:!1,DragOptions:{},DropOptions:{},Endpoint:"Dot",EndpointOverlays:[],Endpoints:[null,null],EndpointStyle:{fill:"#456"},EndpointStyles:[null,null],EndpointHoverStyle:null,EndpointHoverStyles:[null,null],HoverPaintStyle:null,LabelStyle:{color:"black"},ListStyle:{},LogEnabled:!1,Overlays:[],MaxConnections:1,PaintStyle:{"stroke-width":4,stroke:"#456"},ReattachConnections:!1,RenderMode:"svg",Scope:"jsPlumb_DefaultScope"};if(_defaults){jsPlumb.extend(this.Defaults,_defaults)}
this.logEnabled=this.Defaults.LogEnabled;this._connectionTypes={};this._endpointTypes={};_ju.EventGenerator.apply(this);var _currentInstance=this,_instanceIndex=getInstanceIndex(),_bb=_currentInstance.bind,_initialDefaults={},_zoom=1,_info=function(el){if(el==null){return null}else if(el.nodeType===3||el.nodeType===8){return{el:el,text:!0}}else{var _el=_currentInstance.getElement(el);return{el:_el,id:(_ju.isString(el)&&_el==null)?el:_getId(_el)}}};this.getInstanceIndex=function(){return _instanceIndex};this.setZoom=function(z,repaintEverything){_zoom=z;_currentInstance.fire("zoom",_zoom);if(repaintEverything){_currentInstance.repaintEverything()}
return!0};this.getZoom=function(){return _zoom};for(var i in this.Defaults){_initialDefaults[i]=this.Defaults[i]}
var _container,_containerDelegations=[];this.unbindContainer=function(){if(_container!=null&&_containerDelegations.length>0){for(var i=0;i<_containerDelegations.length;i++){_currentInstance.off(_container,_containerDelegations[i][0],_containerDelegations[i][1])}}};this.setContainer=function(c){this.unbindContainer();c=this.getElement(c);this.select().each(function(conn){conn.moveParent(c)});this.selectEndpoints().each(function(ep){ep.moveParent(c)});var previousContainer=_container;_container=c;_containerDelegations.length=0;var eventAliases={"endpointclick":"endpointClick","endpointdblclick":"endpointDblClick"};var _oneDelegateHandler=function(id,e,componentType){var t=e.srcElement||e.target,jp=(t&&t.parentNode?t.parentNode._jsPlumb:null)||(t?t._jsPlumb:null)||(t&&t.parentNode&&t.parentNode.parentNode?t.parentNode.parentNode._jsPlumb:null);if(jp){jp.fire(id,jp,e);var alias=componentType?eventAliases[componentType+id]||id:id;_currentInstance.fire(alias,jp.component||jp,e)}};var _addOneDelegate=function(eventId,selector,fn){_containerDelegations.push([eventId,fn]);_currentInstance.on(_container,eventId,selector,fn)};var _oneDelegate=function(id){_addOneDelegate(id,".jtk-connector",function(e){_oneDelegateHandler(id,e)});_addOneDelegate(id,".jtk-endpoint",function(e){_oneDelegateHandler(id,e,"endpoint")});_addOneDelegate(id,".jtk-overlay",function(e){_oneDelegateHandler(id,e)})};for(var i=0;i<events.length;i++){_oneDelegate(events[i])}
for(var elId in managedElements){var el=managedElements[elId].el;if(el.parentNode===previousContainer){previousContainer.removeChild(el);_container.appendChild(el)}}};this.getContainer=function(){return _container};this.bind=function(event,fn){if("ready"===event&&initialized){fn()}else{_bb.apply(_currentInstance,[event,fn])}};_currentInstance.importDefaults=function(d){for(var i in d){_currentInstance.Defaults[i]=d[i]}
if(d.Container){_currentInstance.setContainer(d.Container)}
return _currentInstance};_currentInstance.restoreDefaults=function(){_currentInstance.Defaults=jsPlumb.extend({},_initialDefaults);return _currentInstance};var log=null,initialized=!1,connections=[],endpointsByElement={},endpointsByUUID={},managedElements={},offsets={},offsetTimestamps={},draggableStates={},connectionBeingDragged=!1,sizes=[],_suspendDrawing=!1,_suspendedAt=null,DEFAULT_SCOPE=this.Defaults.Scope,_curIdStamp=1,_idstamp=function(){return""+_curIdStamp++},_appendElement=function(el,parent){if(_container){_container.appendChild(el)}else if(!parent){this.appendToRoot(el)}else{this.getElement(parent).appendChild(el)}}.bind(this),_draw=function(element,ui,timestamp,clearEdits){var drawResult={c:[],e:[]};if(!_suspendDrawing){element=_currentInstance.getElement(element);if(element!=null){var id=_getId(element),repaintEls=element.querySelectorAll(".jtk-managed");if(timestamp==null){timestamp=jsPlumbUtil.uuid()}
var o=_updateOffset({elId:id,offset:ui,recalc:!1,timestamp:timestamp});for(var i=0;i<repaintEls.length;i++){_updateOffset({elId:repaintEls[i].getAttribute("id"),recalc:!0,timestamp:timestamp})}
var d2=_currentInstance.router.redraw(id,ui,timestamp,null,clearEdits);Array.prototype.push.apply(drawResult.c,d2.c);Array.prototype.push.apply(drawResult.e,d2.e);if(repaintEls){for(var j=0;j<repaintEls.length;j++){d2=_currentInstance.router.redraw(repaintEls[j].getAttribute("id"),null,timestamp,null,clearEdits,!0);Array.prototype.push.apply(drawResult.c,d2.c);Array.prototype.push.apply(drawResult.e,d2.e)}}}}
return drawResult},_getEndpoint=function(uuid){return endpointsByUUID[uuid]},_scopeMatch=function(e1,e2){var s1=e1.scope.split(/\s/),s2=e2.scope.split(/\s/);for(var i=0;i<s1.length;i++){for(var j=0;j<s2.length;j++){if(s2[j]===s1[i]){return!0}}}
return!1},_mergeOverrides=function(def,values){var m=jsPlumb.extend({},def);for(var i in values){if(values[i]){m[i]=values[i]}}
return m},_prepareConnectionParams=function(params,referenceParams){var _p=jsPlumb.extend({},params);if(referenceParams){jsPlumb.extend(_p,referenceParams)}
if(_p.source){if(_p.source.endpoint){_p.sourceEndpoint=_p.source}else{_p.source=_currentInstance.getElement(_p.source)}}
if(_p.target){if(_p.target.endpoint){_p.targetEndpoint=_p.target}else{_p.target=_currentInstance.getElement(_p.target)}}
if(params.uuids){_p.sourceEndpoint=_getEndpoint(params.uuids[0]);_p.targetEndpoint=_getEndpoint(params.uuids[1])}
if(_p.sourceEndpoint&&_p.sourceEndpoint.isFull()){_ju.log(_currentInstance,"could not add connection; source endpoint is full");return}
if(_p.targetEndpoint&&_p.targetEndpoint.isFull()){_ju.log(_currentInstance,"could not add connection; target endpoint is full");return}
if(!_p.type&&_p.sourceEndpoint){_p.type=_p.sourceEndpoint.connectionType}
if(_p.sourceEndpoint&&_p.sourceEndpoint.connectorOverlays){_p.overlays=_p.overlays||[];for(var i=0,j=_p.sourceEndpoint.connectorOverlays.length;i<j;i++){_p.overlays.push(_p.sourceEndpoint.connectorOverlays[i])}}
if(_p.sourceEndpoint&&_p.sourceEndpoint.scope){_p.scope=_p.sourceEndpoint.scope}
if(!_p["pointer-events"]&&_p.sourceEndpoint&&_p.sourceEndpoint.connectorPointerEvents){_p["pointer-events"]=_p.sourceEndpoint.connectorPointerEvents}
var _addEndpoint=function(el,def,idx){var params=_mergeOverrides(def,{anchor:_p.anchors?_p.anchors[idx]:_p.anchor,endpoint:_p.endpoints?_p.endpoints[idx]:_p.endpoint,paintStyle:_p.endpointStyles?_p.endpointStyles[idx]:_p.endpointStyle,hoverPaintStyle:_p.endpointHoverStyles?_p.endpointHoverStyles[idx]:_p.endpointHoverStyle});return _currentInstance.addEndpoint(el,params)};var _oneElementDef=function(type,idx,defs,matchType){if(_p[type]&&!_p[type].endpoint&&!_p[type+"Endpoint"]&&!_p.newConnection){var tid=_getId(_p[type]),tep=defs[tid];tep=tep?tep[matchType]:null;if(tep){if(!tep.enabled){return!1}
var epDef=jsPlumb.extend({},tep.def);delete epDef.label;var newEndpoint=tep.endpoint!=null&&tep.endpoint._jsPlumb?tep.endpoint:_addEndpoint(_p[type],epDef,idx);if(newEndpoint.isFull()){return!1}
_p[type+"Endpoint"]=newEndpoint;if(!_p.scope&&epDef.scope){_p.scope=epDef.scope}
if(tep.uniqueEndpoint){if(!tep.endpoint){tep.endpoint=newEndpoint;newEndpoint.setDeleteOnEmpty(!1)}else{newEndpoint.finalEndpoint=tep.endpoint}}else{newEndpoint.setDeleteOnEmpty(!0)}
if(idx===0&&tep.def.connectorOverlays){_p.overlays=_p.overlays||[];Array.prototype.push.apply(_p.overlays,tep.def.connectorOverlays)}}}};if(_oneElementDef("source",0,this.sourceEndpointDefinitions,_p.type||"default")===!1){return}
if(_oneElementDef("target",1,this.targetEndpointDefinitions,_p.type||"default")===!1){return}
if(_p.sourceEndpoint&&_p.targetEndpoint){if(!_scopeMatch(_p.sourceEndpoint,_p.targetEndpoint)){_p=null}}
return _p}.bind(_currentInstance),_newConnection=function(params){var connectionFunc=_currentInstance.Defaults.ConnectionType||_currentInstance.getDefaultConnectionType();params._jsPlumb=_currentInstance;params.newConnection=_newConnection;params.newEndpoint=_newEndpoint;params.endpointsByUUID=endpointsByUUID;params.endpointsByElement=endpointsByElement;params.finaliseConnection=_finaliseConnection;params.id="con_"+_idstamp();var con=new connectionFunc(params);if(con.isDetachable()){con.endpoints[0].initDraggable("_jsPlumbSource");con.endpoints[1].initDraggable("_jsPlumbTarget")}
return con},_finaliseConnection=_currentInstance.finaliseConnection=function(jpc,params,originalEvent,doInformAnchorManager){params=params||{};if(!jpc.suspendedEndpoint){connections.push(jpc)}
jpc.pending=null;jpc.endpoints[0].isTemporarySource=!1;if(doInformAnchorManager!==!1){_currentInstance.router.newConnection(jpc)}
_draw(jpc.source);if(!params.doNotFireConnectionEvent&&params.fireEvent!==!1){var eventArgs={connection:jpc,source:jpc.source,target:jpc.target,sourceId:jpc.sourceId,targetId:jpc.targetId,sourceEndpoint:jpc.endpoints[0],targetEndpoint:jpc.endpoints[1]};_currentInstance.fire("connection",eventArgs,originalEvent)}},_newEndpoint=function(params,id){var endpointFunc=_currentInstance.Defaults.EndpointType||jsPlumb.Endpoint;var _p=jsPlumb.extend({},params);_p._jsPlumb=_currentInstance;_p.newConnection=_newConnection;_p.newEndpoint=_newEndpoint;_p.endpointsByUUID=endpointsByUUID;_p.endpointsByElement=endpointsByElement;_p.fireDetachEvent=fireDetachEvent;_p.elementId=id||_getId(_p.source);var ep=new endpointFunc(_p);ep.id="ep_"+_idstamp();_manage(_p.elementId,_p.source);if(!jsPlumb.headless){_currentInstance.getDragManager().endpointAdded(_p.source,id)}
return ep},_operation=function(elId,func,endpointFunc){var endpoints=endpointsByElement[elId];if(endpoints&&endpoints.length){for(var i=0,ii=endpoints.length;i<ii;i++){for(var j=0,jj=endpoints[i].connections.length;j<jj;j++){var retVal=func(endpoints[i].connections[j]);if(retVal){return}}
if(endpointFunc){endpointFunc(endpoints[i])}}}},_setDraggable=function(element,draggable){return jsPlumb.each(element,function(el){if(_currentInstance.isDragSupported(el)){draggableStates[_currentInstance.getAttribute(el,"id")]=draggable;_currentInstance.setElementDraggable(el,draggable)}})},_setVisible=function(el,state,alsoChangeEndpoints){state=state==="block";var endpointFunc=null;if(alsoChangeEndpoints){endpointFunc=function(ep){ep.setVisible(state,!0,!0)}}
var info=_info(el);_operation(info.id,function(jpc){if(state&&alsoChangeEndpoints){var oidx=jpc.sourceId===info.id?1:0;if(jpc.endpoints[oidx].isVisible()){jpc.setVisible(!0)}}else{jpc.setVisible(state)}},endpointFunc)},_toggleVisible=function(elId,changeEndpoints){var endpointFunc=null;if(changeEndpoints){endpointFunc=function(ep){var state=ep.isVisible();ep.setVisible(!state)}}
_operation(elId,function(jpc){var state=jpc.isVisible();jpc.setVisible(!state)},endpointFunc)},_getCachedData=function(elId){var o=offsets[elId];if(!o){return _updateOffset({elId:elId})}else{return{o:o,s:sizes[elId]}}},_getId=function(element,uuid,doNotCreateIfNotFound){if(_ju.isString(element)){return element}
if(element==null){return null}
var id=_currentInstance.getAttribute(element,"id");if(!id||id==="undefined"){if(arguments.length===2&&arguments[1]!==undefined){id=uuid}else if(arguments.length===1||(arguments.length===3&&!arguments[2])){id="jsPlumb_"+_instanceIndex+"_"+_idstamp()}
if(!doNotCreateIfNotFound){_currentInstance.setAttribute(element,"id",id)}}
return id};this.setConnectionBeingDragged=function(v){connectionBeingDragged=v};this.isConnectionBeingDragged=function(){return connectionBeingDragged};this.getManagedElements=function(){return managedElements};this.connectorClass="jtk-connector";this.connectorOutlineClass="jtk-connector-outline";this.connectedClass="jtk-connected";this.hoverClass="jtk-hover";this.endpointClass="jtk-endpoint";this.endpointConnectedClass="jtk-endpoint-connected";this.endpointFullClass="jtk-endpoint-full";this.endpointDropAllowedClass="jtk-endpoint-drop-allowed";this.endpointDropForbiddenClass="jtk-endpoint-drop-forbidden";this.overlayClass="jtk-overlay";this.draggingClass="jtk-dragging";this.elementDraggingClass="jtk-element-dragging";this.sourceElementDraggingClass="jtk-source-element-dragging";this.targetElementDraggingClass="jtk-target-element-dragging";this.endpointAnchorClassPrefix="jtk-endpoint-anchor";this.hoverSourceClass="jtk-source-hover";this.hoverTargetClass="jtk-target-hover";this.dragSelectClass="jtk-drag-select";this.Anchors={};this.Connectors={"svg":{}};this.Endpoints={"svg":{}};this.Overlays={"svg":{}};this.ConnectorRenderers={};this.SVG="svg";this.addEndpoint=function(el,params,referenceParams){referenceParams=referenceParams||{};var p=jsPlumb.extend({},referenceParams);jsPlumb.extend(p,params);p.endpoint=p.endpoint||_currentInstance.Defaults.Endpoint;p.paintStyle=p.paintStyle||_currentInstance.Defaults.EndpointStyle;var results=[],inputs=(_ju.isArray(el)||(el.length!=null&&!_ju.isString(el)))?el:[el];for(var i=0,j=inputs.length;i<j;i++){p.source=_currentInstance.getElement(inputs[i]);_ensureContainer(p.source);var id=_getId(p.source),e=_newEndpoint(p,id);var myOffset=_manage(id,p.source,null,!_suspendDrawing).info.o;_ju.addToList(endpointsByElement,id,e);if(!_suspendDrawing){e.paint({anchorLoc:e.anchor.compute({xy:[myOffset.left,myOffset.top],wh:sizes[id],element:e,timestamp:_suspendedAt,rotation:this.getRotation(id)}),timestamp:_suspendedAt})}
results.push(e)}
return results.length===1?results[0]:results};this.addEndpoints=function(el,endpoints,referenceParams){var results=[];for(var i=0,j=endpoints.length;i<j;i++){var e=_currentInstance.addEndpoint(el,endpoints[i],referenceParams);if(_ju.isArray(e)){Array.prototype.push.apply(results,e)}else{results.push(e)}}
return results};this.animate=function(el,properties,options){if(!this.animationSupported){return!1}
options=options||{};var del=_currentInstance.getElement(el),id=_getId(del),stepFunction=jsPlumb.animEvents.step,completeFunction=jsPlumb.animEvents.complete;options[stepFunction]=_ju.wrap(options[stepFunction],function(){_currentInstance.revalidate(id)});options[completeFunction]=_ju.wrap(options[completeFunction],function(){_currentInstance.revalidate(id)});_currentInstance.doAnimate(del,properties,options)};this.checkCondition=function(conditionName,args){var l=_currentInstance.getListener(conditionName),r=!0;if(l&&l.length>0){var values=Array.prototype.slice.call(arguments,1);try{for(var i=0,j=l.length;i<j;i++){r=r&&l[i].apply(l[i],values)}}catch(e){_ju.log(_currentInstance,"cannot check condition ["+conditionName+"]"+e)}}
return r};this.connect=function(params,referenceParams){var _p=_prepareConnectionParams(params,referenceParams),jpc;if(_p){if(_p.source==null&&_p.sourceEndpoint==null){_ju.log("Cannot establish connection - source does not exist");return}
if(_p.target==null&&_p.targetEndpoint==null){_ju.log("Cannot establish connection - target does not exist");return}
_ensureContainer(_p.source);jpc=_newConnection(_p);_finaliseConnection(jpc,_p)}
return jpc};var stTypes=[{el:"source",elId:"sourceId",epDefs:"sourceEndpointDefinitions"},{el:"target",elId:"targetId",epDefs:"targetEndpointDefinitions"}];var _set=function(c,el,idx,doNotRepaint){var ep,_st=stTypes[idx],cId=c[_st.elId],cEl=c[_st.el],sid,sep,oldEndpoint=c.endpoints[idx];var evtParams={index:idx,originalSourceId:idx===0?cId:c.sourceId,newSourceId:c.sourceId,originalTargetId:idx===1?cId:c.targetId,newTargetId:c.targetId,connection:c};if(el.constructor===jsPlumb.Endpoint){ep=el;ep.addConnection(c);el=ep.element}else{sid=_getId(el);sep=this[_st.epDefs][sid];if(sid===c[_st.elId]){ep=null}else if(sep){for(var t in sep){if(!sep[t].enabled){return}
ep=sep[t].endpoint!=null&&sep[t].endpoint._jsPlumb?sep[t].endpoint:this.addEndpoint(el,sep[t].def);if(sep[t].uniqueEndpoint){sep[t].endpoint=ep}
ep.addConnection(c)}}else{ep=c.makeEndpoint(idx===0,el,sid)}}
if(ep!=null){oldEndpoint.detachFromConnection(c);c.endpoints[idx]=ep;c[_st.el]=ep.element;c[_st.elId]=ep.elementId;evtParams[idx===0?"newSourceId":"newTargetId"]=ep.elementId;fireMoveEvent(evtParams);if(!doNotRepaint){c.repaint()}}
evtParams.element=el;return evtParams}.bind(this);this.setSource=function(connection,el,doNotRepaint){var p=_set(connection,el,0,doNotRepaint);this.router.sourceOrTargetChanged(p.originalSourceId,p.newSourceId,connection,p.el,0)};this.setTarget=function(connection,el,doNotRepaint){var p=_set(connection,el,1,doNotRepaint);this.router.sourceOrTargetChanged(p.originalTargetId,p.newTargetId,connection,p.el,1)};this.deleteEndpoint=function(object,dontUpdateHover,deleteAttachedObjects){var endpoint=(typeof object==="string")?endpointsByUUID[object]:object;if(endpoint){_currentInstance.deleteObject({endpoint:endpoint,dontUpdateHover:dontUpdateHover,deleteAttachedObjects:deleteAttachedObjects})}
return _currentInstance};this.deleteEveryEndpoint=function(){var _is=_currentInstance.setSuspendDrawing(!0);for(var id in endpointsByElement){var endpoints=endpointsByElement[id];if(endpoints&&endpoints.length){for(var i=0,j=endpoints.length;i<j;i++){_currentInstance.deleteEndpoint(endpoints[i],!0)}}}
endpointsByElement={};managedElements={};endpointsByUUID={};offsets={};offsetTimestamps={};_currentInstance.router.reset();var dm=_currentInstance.getDragManager();if(dm){dm.reset()}
if(!_is){_currentInstance.setSuspendDrawing(!1)}
return _currentInstance};var fireDetachEvent=function(jpc,doFireEvent,originalEvent){var connType=_currentInstance.Defaults.ConnectionType||_currentInstance.getDefaultConnectionType(),argIsConnection=jpc.constructor===connType,params=argIsConnection?{connection:jpc,source:jpc.source,target:jpc.target,sourceId:jpc.sourceId,targetId:jpc.targetId,sourceEndpoint:jpc.endpoints[0],targetEndpoint:jpc.endpoints[1]}:jpc;if(doFireEvent){_currentInstance.fire("connectionDetached",params,originalEvent)}
_currentInstance.fire("internal.connectionDetached",params,originalEvent);_currentInstance.router.connectionDetached(params)};var fireMoveEvent=_currentInstance.fireMoveEvent=function(params,evt){_currentInstance.fire("connectionMoved",params,evt)};this.unregisterEndpoint=function(endpoint){if(endpoint._jsPlumb.uuid){endpointsByUUID[endpoint._jsPlumb.uuid]=null}
_currentInstance.router.deleteEndpoint(endpoint);for(var e in endpointsByElement){var endpoints=endpointsByElement[e];if(endpoints){var newEndpoints=[];for(var i=0,j=endpoints.length;i<j;i++){if(endpoints[i]!==endpoint){newEndpoints.push(endpoints[i])}}
endpointsByElement[e]=newEndpoints}
if(endpointsByElement[e].length<1){delete endpointsByElement[e]}}};var IS_DETACH_ALLOWED="isDetachAllowed";var BEFORE_DETACH="beforeDetach";var CHECK_CONDITION="checkCondition";this.deleteConnection=function(connection,params){if(connection!=null){params=params||{};if(params.force||_ju.functionChain(!0,!1,[[connection.endpoints[0],IS_DETACH_ALLOWED,[connection]],[connection.endpoints[1],IS_DETACH_ALLOWED,[connection]],[connection,IS_DETACH_ALLOWED,[connection]],[_currentInstance,CHECK_CONDITION,[BEFORE_DETACH,connection]]])){connection.setHover(!1);fireDetachEvent(connection,!connection.pending&&params.fireEvent!==!1,params.originalEvent);connection.endpoints[0].detachFromConnection(connection);connection.endpoints[1].detachFromConnection(connection);_ju.removeWithFunction(connections,function(_c){return connection.id===_c.id});connection.cleanup();connection.destroy();return!0}}
return!1};this.deleteEveryConnection=function(params){params=params||{};var count=connections.length,deletedCount=0;_currentInstance.batch(function(){for(var i=0;i<count;i++){deletedCount+=_currentInstance.deleteConnection(connections[0],params)?1:0}});return deletedCount};this.deleteConnectionsForElement=function(el,params){params=params||{};el=_currentInstance.getElement(el);var id=_getId(el),endpoints=endpointsByElement[id];if(endpoints&&endpoints.length){for(var i=0,j=endpoints.length;i<j;i++){endpoints[i].deleteEveryConnection(params)}}
return _currentInstance};this.deleteObject=function(params){var result={endpoints:{},connections:{},endpointCount:0,connectionCount:0},deleteAttachedObjects=params.deleteAttachedObjects!==!1;var unravelConnection=function(connection){if(connection!=null&&result.connections[connection.id]==null){if(!params.dontUpdateHover&&connection._jsPlumb!=null){connection.setHover(!1)}
result.connections[connection.id]=connection;result.connectionCount++}};var unravelEndpoint=function(endpoint){if(endpoint!=null&&result.endpoints[endpoint.id]==null){if(!params.dontUpdateHover&&endpoint._jsPlumb!=null){endpoint.setHover(!1)}
result.endpoints[endpoint.id]=endpoint;result.endpointCount++;if(deleteAttachedObjects){for(var i=0;i<endpoint.connections.length;i++){var c=endpoint.connections[i];unravelConnection(c)}}}};if(params.connection){unravelConnection(params.connection)}else{unravelEndpoint(params.endpoint)}
for(var i in result.connections){var c=result.connections[i];if(c._jsPlumb){_ju.removeWithFunction(connections,function(_c){return c.id===_c.id});fireDetachEvent(c,params.fireEvent===!1?!1:!c.pending,params.originalEvent);var doNotCleanup=params.deleteAttachedObjects==null?null:!params.deleteAttachedObjects;c.endpoints[0].detachFromConnection(c,null,doNotCleanup);c.endpoints[1].detachFromConnection(c,null,doNotCleanup);c.cleanup(!0);c.destroy(!0)}}
for(var j in result.endpoints){var e=result.endpoints[j];if(e._jsPlumb){_currentInstance.unregisterEndpoint(e);e.cleanup(!0);e.destroy(!0)}}
return result};var _setOperation=function(list,func,args,selector){for(var i=0,j=list.length;i<j;i++){list[i][func].apply(list[i],args)}
return selector(list)},_getOperation=function(list,func,args){var out=[];for(var i=0,j=list.length;i<j;i++){out.push([list[i][func].apply(list[i],args),list[i]])}
return out},setter=function(list,func,selector){return function(){return _setOperation(list,func,arguments,selector)}},getter=function(list,func){return function(){return _getOperation(list,func,arguments)}},prepareList=function(input,doNotGetIds){var r=[];if(input){if(typeof input==='string'){if(input==="*"){return input}
r.push(input)}else{if(doNotGetIds){r=input}else{if(input.length){for(var i=0,j=input.length;i<j;i++){r.push(_info(input[i]).id)}}else{r.push(_info(input).id)}}}}
return r},filterList=function(list,value,missingIsFalse){if(list==="*"){return!0}
return list.length>0?list.indexOf(value)!==-1:!missingIsFalse};this.getConnections=function(options,flat){if(!options){options={}}else if(options.constructor===String){options={"scope":options}}
var scope=options.scope||_currentInstance.getDefaultScope(),scopes=prepareList(scope,!0),sources=prepareList(options.source),targets=prepareList(options.target),results=(!flat&&scopes.length>1)?{}:[],_addOne=function(scope,obj){if(!flat&&scopes.length>1){var ss=results[scope];if(ss==null){ss=results[scope]=[]}
ss.push(obj)}else{results.push(obj)}};for(var j=0,jj=connections.length;j<jj;j++){var c=connections[j],sourceId=c.proxies&&c.proxies[0]?c.proxies[0].originalEp.elementId:c.sourceId,targetId=c.proxies&&c.proxies[1]?c.proxies[1].originalEp.elementId:c.targetId;if(filterList(scopes,c.scope)&&filterList(sources,sourceId)&&filterList(targets,targetId)){_addOne(c.scope,c)}}
return results};var _curryEach=function(list,executor){return function(f){for(var i=0,ii=list.length;i<ii;i++){f(list[i])}
return executor(list)}},_curryGet=function(list){return function(idx){return list[idx]}};var _makeCommonSelectHandler=function(list,executor){var out={length:list.length,each:_curryEach(list,executor),get:_curryGet(list)},setters=["setHover","removeAllOverlays","setLabel","addClass","addOverlay","removeOverlay","removeOverlays","showOverlay","hideOverlay","showOverlays","hideOverlays","setPaintStyle","setHoverPaintStyle","setSuspendEvents","setParameter","setParameters","setVisible","repaint","addType","toggleType","removeType","removeClass","setType","bind","unbind"],getters=["getLabel","getOverlay","isHover","getParameter","getParameters","getPaintStyle","getHoverPaintStyle","isVisible","hasType","getType","isSuspendEvents"],i,ii;for(i=0,ii=setters.length;i<ii;i++){out[setters[i]]=setter(list,setters[i],executor)}
for(i=0,ii=getters.length;i<ii;i++){out[getters[i]]=getter(list,getters[i])}
return out};var _makeConnectionSelectHandler=function(list){var common=_makeCommonSelectHandler(list,_makeConnectionSelectHandler);return jsPlumb.extend(common,{setDetachable:setter(list,"setDetachable",_makeConnectionSelectHandler),setReattach:setter(list,"setReattach",_makeConnectionSelectHandler),setConnector:setter(list,"setConnector",_makeConnectionSelectHandler),delete:function(){for(var i=0,ii=list.length;i<ii;i++){_currentInstance.deleteConnection(list[i])}},isDetachable:getter(list,"isDetachable"),isReattach:getter(list,"isReattach")})};var _makeEndpointSelectHandler=function(list){var common=_makeCommonSelectHandler(list,_makeEndpointSelectHandler);return jsPlumb.extend(common,{setEnabled:setter(list,"setEnabled",_makeEndpointSelectHandler),setAnchor:setter(list,"setAnchor",_makeEndpointSelectHandler),isEnabled:getter(list,"isEnabled"),deleteEveryConnection:function(){for(var i=0,ii=list.length;i<ii;i++){list[i].deleteEveryConnection()}},"delete":function(){for(var i=0,ii=list.length;i<ii;i++){_currentInstance.deleteEndpoint(list[i])}}})};this.select=function(params){params=params||{};params.scope=params.scope||"*";return _makeConnectionSelectHandler(params.connections||_currentInstance.getConnections(params,!0))};this.selectEndpoints=function(params){params=params||{};params.scope=params.scope||"*";var noElementFilters=!params.element&&!params.source&&!params.target,elements=noElementFilters?"*":prepareList(params.element),sources=noElementFilters?"*":prepareList(params.source),targets=noElementFilters?"*":prepareList(params.target),scopes=prepareList(params.scope,!0);var ep=[];for(var el in endpointsByElement){var either=filterList(elements,el,!0),source=filterList(sources,el,!0),sourceMatchExact=sources!=="*",target=filterList(targets,el,!0),targetMatchExact=targets!=="*";if(either||source||target){inner:for(var i=0,ii=endpointsByElement[el].length;i<ii;i++){var _ep=endpointsByElement[el][i];if(filterList(scopes,_ep.scope,!0)){var noMatchSource=(sourceMatchExact&&sources.length>0&&!_ep.isSource),noMatchTarget=(targetMatchExact&&targets.length>0&&!_ep.isTarget);if(noMatchSource||noMatchTarget){continue inner}
ep.push(_ep)}}}}
return _makeEndpointSelectHandler(ep)};this.getAllConnections=function(){return connections};this.getDefaultScope=function(){return DEFAULT_SCOPE};this.getEndpoint=_getEndpoint;this.getEndpoints=function(el){return endpointsByElement[_info(el).id]||[]};this.getDefaultEndpointType=function(){return jsPlumb.Endpoint};this.getDefaultConnectionType=function(){return jsPlumb.Connection};this.getId=_getId;this.draw=_draw;this.info=_info;this.appendElement=_appendElement;var _hoverSuspended=!1;this.isHoverSuspended=function(){return _hoverSuspended};this.setHoverSuspended=function(s){_hoverSuspended=s};this.hide=function(el,changeEndpoints){_setVisible(el,"none",changeEndpoints);return _currentInstance};this.idstamp=_idstamp;var _ensureContainer=function(candidate){if(!_container&&candidate){var can=_currentInstance.getElement(candidate);if(can.offsetParent){_currentInstance.setContainer(can.offsetParent)}}};var _getContainerFromDefaults=function(){if(_currentInstance.Defaults.Container){_currentInstance.setContainer(_currentInstance.Defaults.Container)}};var _manage=_currentInstance.manage=function(id,element,_transient,_recalc){if(!managedElements[id]){managedElements[id]={el:element,endpoints:[],connections:[],rotation:0};managedElements[id].info=_updateOffset({elId:id,timestamp:_suspendedAt});_currentInstance.addClass(element,"jtk-managed");if(!_transient){_currentInstance.fire("manageElement",{id:id,info:managedElements[id].info,el:element})}}else{if(_recalc){managedElements[id].info=_updateOffset({elId:id,timestamp:_suspendedAt,recalc:!0})}}
return managedElements[id]};this.unmanage=function(id){if(managedElements[id]){var el=managedElements[id].el;_currentInstance.removeClass(el,"jtk-managed");delete managedElements[id];_currentInstance.fire("unmanageElement",{id:id,el:el})}};this.rotate=function(elId,amountInDegrees,doNotRedraw){if(managedElements[elId]){managedElements[elId].rotation=amountInDegrees;managedElements[elId].el.style.transform="rotate("+amountInDegrees+"deg)";managedElements[elId].el.style.transformOrigin="center center";if(doNotRedraw!==!0){return this.revalidate(elId)}}
return{c:[],e:[]}};this.getRotation=function(elementId){return managedElements[elementId]?managedElements[elementId].rotation||0:0};var _updateOffset=function(params){var timestamp=params.timestamp,recalc=params.recalc,offset=params.offset,elId=params.elId,s;if(_suspendDrawing&&!timestamp){timestamp=_suspendedAt}
if(!recalc){if(timestamp&&timestamp===offsetTimestamps[elId]){return{o:params.offset||offsets[elId],s:sizes[elId]}}}
if(recalc||(!offset&&offsets[elId]==null)){s=managedElements[elId]?managedElements[elId].el:null;if(s!=null){sizes[elId]=_currentInstance.getSize(s);offsets[elId]=_currentInstance.getOffset(s);offsetTimestamps[elId]=timestamp}}else{offsets[elId]=offset||offsets[elId];if(sizes[elId]==null){s=managedElements[elId].el;if(s!=null){sizes[elId]=_currentInstance.getSize(s)}}
offsetTimestamps[elId]=timestamp}
if(offsets[elId]&&!offsets[elId].right){offsets[elId].right=offsets[elId].left+sizes[elId][0];offsets[elId].bottom=offsets[elId].top+sizes[elId][1];offsets[elId].width=sizes[elId][0];offsets[elId].height=sizes[elId][1];offsets[elId].centerx=offsets[elId].left+(offsets[elId].width/2);offsets[elId].centery=offsets[elId].top+(offsets[elId].height/2)}
return{o:offsets[elId],s:sizes[elId]}};this.updateOffset=_updateOffset;this.init=function(){if(!initialized){_getContainerFromDefaults();_currentInstance.router=new root.jsPlumb.DefaultRouter(_currentInstance);_currentInstance.anchorManager=_currentInstance.router.anchorManager;initialized=!0;_currentInstance.fire("ready",_currentInstance)}}.bind(this);this.log=log;this.jsPlumbUIComponent=jsPlumbUIComponent;this.makeAnchor=function(){var pp,_a=function(t,p){if(root.jsPlumb.Anchors[t]){return new root.jsPlumb.Anchors[t](p)}
if(!_currentInstance.Defaults.DoNotThrowErrors){throw{msg:"jsPlumb: unknown anchor type '"+t+"'"}}};if(arguments.length===0){return null}
var specimen=arguments[0],elementId=arguments[1],jsPlumbInstance=arguments[2],newAnchor=null;if(specimen.compute&&specimen.getOrientation){return specimen}else if(typeof specimen==="string"){newAnchor=_a(arguments[0],{elementId:elementId,jsPlumbInstance:_currentInstance})}else if(_ju.isArray(specimen)){if(_ju.isArray(specimen[0])||_ju.isString(specimen[0])){if(specimen.length===2&&_ju.isObject(specimen[1])){if(_ju.isString(specimen[0])){pp=root.jsPlumb.extend({elementId:elementId,jsPlumbInstance:_currentInstance},specimen[1]);newAnchor=_a(specimen[0],pp)}else{pp=root.jsPlumb.extend({elementId:elementId,jsPlumbInstance:_currentInstance,anchors:specimen[0]},specimen[1]);newAnchor=new root.jsPlumb.DynamicAnchor(pp)}}else{newAnchor=new jsPlumb.DynamicAnchor({anchors:specimen,selector:null,elementId:elementId,jsPlumbInstance:_currentInstance})}}else{var anchorParams={x:specimen[0],y:specimen[1],orientation:(specimen.length>=4)?[specimen[2],specimen[3]]:[0,0],offsets:(specimen.length>=6)?[specimen[4],specimen[5]]:[0,0],elementId:elementId,jsPlumbInstance:_currentInstance,cssClass:specimen.length===7?specimen[6]:null};newAnchor=new root.jsPlumb.Anchor(anchorParams);newAnchor.clone=function(){return new root.jsPlumb.Anchor(anchorParams)}}}
if(!newAnchor.id){newAnchor.id="anchor_"+_idstamp()}
return newAnchor};this.makeAnchors=function(types,elementId,jsPlumbInstance){var r=[];for(var i=0,ii=types.length;i<ii;i++){if(typeof types[i]==="string"){r.push(root.jsPlumb.Anchors[types[i]]({elementId:elementId,jsPlumbInstance:jsPlumbInstance}))}else if(_ju.isArray(types[i])){r.push(_currentInstance.makeAnchor(types[i],elementId,jsPlumbInstance))}}
return r};this.makeDynamicAnchor=function(anchors,anchorSelector){return new root.jsPlumb.DynamicAnchor({anchors:anchors,selector:anchorSelector,elementId:null,jsPlumbInstance:_currentInstance})};this.targetEndpointDefinitions={};this.sourceEndpointDefinitions={};var selectorFilter=function(evt,_el,selector,_instance,negate){var t=evt.target||evt.srcElement,ok=!1,sel=_instance.getSelector(_el,selector);for(var j=0;j<sel.length;j++){if(sel[j]===t){ok=!0;break}}
return negate?!ok:ok};var _makeElementDropHandler=function(elInfo,p,dropOptions,isSource,isTarget){var proxyComponent=new jsPlumbUIComponent(p);var _drop=p._jsPlumb.EndpointDropHandler({jsPlumb:_currentInstance,enabled:function(){return elInfo.def.enabled},isFull:function(){var targetCount=_currentInstance.select({target:elInfo.id}).length;return elInfo.def.maxConnections>0&&targetCount>=elInfo.def.maxConnections},element:elInfo.el,elementId:elInfo.id,isSource:isSource,isTarget:isTarget,addClass:function(clazz){_currentInstance.addClass(elInfo.el,clazz)},removeClass:function(clazz){_currentInstance.removeClass(elInfo.el,clazz)},onDrop:function(jpc){var source=jpc.endpoints[0];source.anchor.locked=!1},isDropAllowed:function(){return proxyComponent.isDropAllowed.apply(proxyComponent,arguments)},isRedrop:function(jpc){return(jpc.suspendedElement!=null&&jpc.suspendedEndpoint!=null&&jpc.suspendedEndpoint.element===elInfo.el)},getEndpoint:function(jpc){var newEndpoint=elInfo.def.endpoint;if(newEndpoint==null||newEndpoint._jsPlumb==null){var eps=_currentInstance.deriveEndpointAndAnchorSpec(jpc.getType().join(" "),!0);var pp=eps.endpoints?root.jsPlumb.extend(p,{endpoint:elInfo.def.def.endpoint||eps.endpoints[1]}):p;if(eps.anchors){pp=root.jsPlumb.extend(pp,{anchor:elInfo.def.def.anchor||eps.anchors[1]})}
newEndpoint=_currentInstance.addEndpoint(elInfo.el,pp);newEndpoint._mtNew=!0}
if(p.uniqueEndpoint){elInfo.def.endpoint=newEndpoint}
newEndpoint.setDeleteOnEmpty(!0);if(jpc.isDetachable()){newEndpoint.initDraggable()}
if(newEndpoint.anchor.positionFinder!=null){var dropPosition=_currentInstance.getUIPosition(arguments,_currentInstance.getZoom()),elPosition=_currentInstance.getOffset(elInfo.el),elSize=_currentInstance.getSize(elInfo.el),ap=dropPosition==null?[0,0]:newEndpoint.anchor.positionFinder(dropPosition,elPosition,elSize,newEndpoint.anchor.constructorParams);newEndpoint.anchor.x=ap[0];newEndpoint.anchor.y=ap[1]}
return newEndpoint},maybeCleanup:function(ep){if(ep._mtNew&&ep.connections.length===0){_currentInstance.deleteObject({endpoint:ep})}else{delete ep._mtNew}}});var dropEvent=root.jsPlumb.dragEvents.drop;dropOptions.scope=dropOptions.scope||(p.scope||_currentInstance.Defaults.Scope);dropOptions[dropEvent]=_ju.wrap(dropOptions[dropEvent],_drop,!0);dropOptions.rank=p.rank||0;if(isTarget){dropOptions[root.jsPlumb.dragEvents.over]=function(){return!0}}
if(p.allowLoopback===!1){dropOptions.canDrop=function(_drag){var de=_drag.getDragElement()._jsPlumbRelatedElement;return de!==elInfo.el}}
_currentInstance.initDroppable(elInfo.el,dropOptions,"internal");return _drop};this.makeTarget=function(el,params,referenceParams){var p=root.jsPlumb.extend({_jsPlumb:this},referenceParams);root.jsPlumb.extend(p,params);var maxConnections=p.maxConnections||-1,_doOne=function(el){var elInfo=_info(el),elid=elInfo.id,dropOptions=root.jsPlumb.extend({},p.dropOptions||{}),type=p.connectionType||"default";this.targetEndpointDefinitions[elid]=this.targetEndpointDefinitions[elid]||{};_ensureContainer(elid);if(elInfo.el._isJsPlumbGroup&&dropOptions.rank==null){dropOptions.rank=-1}
var _def={def:root.jsPlumb.extend({},p),uniqueEndpoint:p.uniqueEndpoint,maxConnections:maxConnections,enabled:!0};if(p.createEndpoint){_def.uniqueEndpoint=!0;_def.endpoint=_currentInstance.addEndpoint(el,_def.def);_def.endpoint.setDeleteOnEmpty(!1)}
elInfo.def=_def;this.targetEndpointDefinitions[elid][type]=_def;_makeElementDropHandler(elInfo,p,dropOptions,p.isSource===!0,!0);elInfo.el._katavorioDrop[elInfo.el._katavorioDrop.length-1].targetDef=_def}.bind(this);var inputs=el.length&&el.constructor!==String?el:[el];for(var i=0,ii=inputs.length;i<ii;i++){_doOne(inputs[i])}
return this};this.unmakeTarget=function(el,doNotClearArrays){var info=_info(el);_currentInstance.destroyDroppable(info.el,"internal");if(!doNotClearArrays){delete this.targetEndpointDefinitions[info.id]}
return this};this.makeSource=function(el,params,referenceParams){var p=root.jsPlumb.extend({_jsPlumb:this},referenceParams);root.jsPlumb.extend(p,params);var type=p.connectionType||"default";var aae=_currentInstance.deriveEndpointAndAnchorSpec(type);p.endpoint=p.endpoint||aae.endpoints[0];p.anchor=p.anchor||aae.anchors[0];var maxConnections=p.maxConnections||-1,onMaxConnections=p.onMaxConnections,_doOne=function(elInfo){var elid=elInfo.id,_del=this.getElement(elInfo.el);this.sourceEndpointDefinitions[elid]=this.sourceEndpointDefinitions[elid]||{};_ensureContainer(elid);var _def={def:root.jsPlumb.extend({},p),uniqueEndpoint:p.uniqueEndpoint,maxConnections:maxConnections,enabled:!0};if(p.createEndpoint){_def.uniqueEndpoint=!0;_def.endpoint=_currentInstance.addEndpoint(el,_def.def);_def.endpoint.setDeleteOnEmpty(!1)}
this.sourceEndpointDefinitions[elid][type]=_def;elInfo.def=_def;var stopEvent=root.jsPlumb.dragEvents.stop,dragEvent=root.jsPlumb.dragEvents.drag,dragOptions=root.jsPlumb.extend({},p.dragOptions||{}),existingDrag=dragOptions.drag,existingStop=dragOptions.stop,ep=null,endpointAddedButNoDragYet=!1;dragOptions.scope=dragOptions.scope||p.scope;dragOptions[dragEvent]=_ju.wrap(dragOptions[dragEvent],function(){if(existingDrag){existingDrag.apply(this,arguments)}
endpointAddedButNoDragYet=!1});dragOptions[stopEvent]=_ju.wrap(dragOptions[stopEvent],function(){if(existingStop){existingStop.apply(this,arguments)}
this.currentlyDragging=!1;if(ep._jsPlumb!=null){var anchorDef=p.anchor||this.Defaults.Anchor,oldAnchor=ep.anchor,oldConnection=ep.connections[0];var newAnchor=this.makeAnchor(anchorDef,elid,this),_el=ep.element;if(newAnchor.positionFinder!=null){var elPosition=_currentInstance.getOffset(_el),elSize=this.getSize(_el),dropPosition={left:elPosition.left+(oldAnchor.x*elSize[0]),top:elPosition.top+(oldAnchor.y*elSize[1])},ap=newAnchor.positionFinder(dropPosition,elPosition,elSize,newAnchor.constructorParams);newAnchor.x=ap[0];newAnchor.y=ap[1]}
ep.setAnchor(newAnchor,!0);ep.repaint();this.repaint(ep.elementId);if(oldConnection!=null){this.repaint(oldConnection.targetId)}}}.bind(this));var mouseDownListener=function(e){if(e.which===3||e.button===2){return}
elid=this.getId(this.getElement(elInfo.el));var def=this.sourceEndpointDefinitions[elid][type];if(!def.enabled){return}
if(p.filter){var r=_ju.isString(p.filter)?selectorFilter(e,elInfo.el,p.filter,this,p.filterExclude):p.filter(e,elInfo.el);if(r===!1){return}}
var sourceCount=this.select({source:elid}).length;if(def.maxConnections>=0&&(sourceCount>=def.maxConnections)){if(onMaxConnections){onMaxConnections({element:elInfo.el,maxConnections:maxConnections},e)}
return!1}
var elxy=root.jsPlumb.getPositionOnElement(e,_del,_zoom);var tempEndpointParams={};root.jsPlumb.extend(tempEndpointParams,def.def);tempEndpointParams.isTemporarySource=!0;tempEndpointParams.anchor=[elxy[0],elxy[1],0,0];tempEndpointParams.dragOptions=dragOptions;if(def.def.scope){tempEndpointParams.scope=def.def.scope}
ep=this.addEndpoint(elid,tempEndpointParams);endpointAddedButNoDragYet=!0;ep.setDeleteOnEmpty(!0);if(def.uniqueEndpoint){if(!def.endpoint){def.endpoint=ep;ep.setDeleteOnEmpty(!1)}else{ep.finalEndpoint=def.endpoint}}
var _delTempEndpoint=function(){_currentInstance.off(ep.canvas,"mouseup",_delTempEndpoint);_currentInstance.off(elInfo.el,"mouseup",_delTempEndpoint);if(endpointAddedButNoDragYet){endpointAddedButNoDragYet=!1;_currentInstance.deleteEndpoint(ep)}};_currentInstance.on(ep.canvas,"mouseup",_delTempEndpoint);_currentInstance.on(elInfo.el,"mouseup",_delTempEndpoint);var payload={};if(def.def.extract){for(var att in def.def.extract){var v=(e.srcElement||e.target).getAttribute(att);if(v){payload[def.def.extract[att]]=v}}}
_currentInstance.trigger(ep.canvas,"mousedown",e,payload);_ju.consume(e)}.bind(this);this.on(elInfo.el,"mousedown",mouseDownListener);_def.trigger=mouseDownListener;if(p.filter&&(_ju.isString(p.filter)||_ju.isFunction(p.filter))){_currentInstance.setDragFilter(elInfo.el,p.filter)}
var dropOptions=root.jsPlumb.extend({},p.dropOptions||{});_makeElementDropHandler(elInfo,p,dropOptions,!0,p.isTarget===!0)}.bind(this);var inputs=el.length&&el.constructor!==String?el:[el];for(var i=0,ii=inputs.length;i<ii;i++){_doOne(_info(inputs[i]))}
return this};this.unmakeSource=function(el,connectionType,doNotClearArrays){var info=_info(el);_currentInstance.destroyDroppable(info.el,"internal");var eldefs=this.sourceEndpointDefinitions[info.id];if(eldefs){for(var def in eldefs){if(connectionType==null||connectionType===def){var mouseDownListener=eldefs[def].trigger;if(mouseDownListener){_currentInstance.off(info.el,"mousedown",mouseDownListener)}
if(!doNotClearArrays){delete this.sourceEndpointDefinitions[info.id][def]}}}}
return this};this.unmakeEverySource=function(){for(var i in this.sourceEndpointDefinitions){_currentInstance.unmakeSource(i,null,!0)}
this.sourceEndpointDefinitions={};return this};var _getScope=function(el,types,connectionType){types=_ju.isArray(types)?types:[types];var id=_getId(el);connectionType=connectionType||"default";for(var i=0;i<types.length;i++){var eldefs=this[types[i]][id];if(eldefs&&eldefs[connectionType]){return eldefs[connectionType].def.scope||this.Defaults.Scope}}}.bind(this);var _setScope=function(el,scope,types,connectionType){types=_ju.isArray(types)?types:[types];var id=_getId(el);connectionType=connectionType||"default";for(var i=0;i<types.length;i++){var eldefs=this[types[i]][id];if(eldefs&&eldefs[connectionType]){eldefs[connectionType].def.scope=scope}}}.bind(this);this.getScope=function(el,scope){return _getScope(el,["sourceEndpointDefinitions","targetEndpointDefinitions"])};this.getSourceScope=function(el){return _getScope(el,"sourceEndpointDefinitions")};this.getTargetScope=function(el){return _getScope(el,"targetEndpointDefinitions")};this.setScope=function(el,scope,connectionType){this.setSourceScope(el,scope,connectionType);this.setTargetScope(el,scope,connectionType)};this.setSourceScope=function(el,scope,connectionType){_setScope(el,scope,"sourceEndpointDefinitions",connectionType);this.setDragScope(el,scope)};this.setTargetScope=function(el,scope,connectionType){_setScope(el,scope,"targetEndpointDefinitions",connectionType);this.setDropScope(el,scope)};this.unmakeEveryTarget=function(){for(var i in this.targetEndpointDefinitions){_currentInstance.unmakeTarget(i,!0)}
this.targetEndpointDefinitions={};return this};var _setEnabled=function(type,el,state,toggle,connectionType){var a=type==="source"?this.sourceEndpointDefinitions:this.targetEndpointDefinitions,originalState,info,newState;connectionType=connectionType||"default";if(el.length&&!_ju.isString(el)){originalState=[];for(var i=0,ii=el.length;i<ii;i++){info=_info(el[i]);if(a[info.id]&&a[info.id][connectionType]){originalState[i]=a[info.id][connectionType].enabled;newState=toggle?!originalState[i]:state;a[info.id][connectionType].enabled=newState;_currentInstance[newState?"removeClass":"addClass"](info.el,"jtk-"+type+"-disabled")}}}else{info=_info(el);var id=info.id;if(a[id]&&a[id][connectionType]){originalState=a[id][connectionType].enabled;newState=toggle?!originalState:state;a[id][connectionType].enabled=newState;_currentInstance[newState?"removeClass":"addClass"](info.el,"jtk-"+type+"-disabled")}}
return originalState}.bind(this);var _first=function(el,fn){if(el!=null){if(_ju.isString(el)||!el.length){return fn.apply(this,[el])}else if(el.length){return fn.apply(this,[el[0]])}}}.bind(this);this.toggleSourceEnabled=function(el,connectionType){_setEnabled("source",el,null,!0,connectionType);return this.isSourceEnabled(el,connectionType)};this.setSourceEnabled=function(el,state,connectionType){return _setEnabled("source",el,state,null,connectionType)};this.isSource=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var eldefs=this.sourceEndpointDefinitions[_info(_el).id];return eldefs!=null&&eldefs[connectionType]!=null}.bind(this))};this.isSourceEnabled=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var sep=this.sourceEndpointDefinitions[_info(_el).id];return sep&&sep[connectionType]&&sep[connectionType].enabled===!0}.bind(this))};this.toggleTargetEnabled=function(el,connectionType){_setEnabled("target",el,null,!0,connectionType);return this.isTargetEnabled(el,connectionType)};this.isTarget=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var eldefs=this.targetEndpointDefinitions[_info(_el).id];return eldefs!=null&&eldefs[connectionType]!=null}.bind(this))};this.isTargetEnabled=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var tep=this.targetEndpointDefinitions[_info(_el).id];return tep&&tep[connectionType]&&tep[connectionType].enabled===!0}.bind(this))};this.setTargetEnabled=function(el,state,connectionType){return _setEnabled("target",el,state,null,connectionType)};this.ready=function(fn){_currentInstance.bind("ready",fn)};var _elEach=function(el,fn){if(typeof el==='object'&&el.length){for(var i=0,ii=el.length;i<ii;i++){fn(el[i])}}else{fn(el)}
return _currentInstance};this.repaint=function(el,ui,timestamp){return _elEach(el,function(_el){_draw(_el,ui,timestamp)})};this.revalidate=function(el,timestamp,isIdAlready){var elId=isIdAlready?el:_currentInstance.getId(el);_currentInstance.updateOffset({elId:elId,recalc:!0,timestamp:timestamp});var dm=_currentInstance.getDragManager();if(dm){dm.updateOffsets(elId)}
return _draw(el,null,timestamp)};this.repaintEverything=function(){var timestamp=jsPlumbUtil.uuid(),elId;for(elId in endpointsByElement){_currentInstance.updateOffset({elId:elId,recalc:!0,timestamp:timestamp})}
for(elId in endpointsByElement){_draw(elId,null,timestamp)}
return this};this.removeAllEndpoints=function(el,recurse,affectedElements){affectedElements=affectedElements||[];var _one=function(_el){var info=_info(_el),ebe=endpointsByElement[info.id],i,ii;if(ebe){affectedElements.push(info);for(i=0,ii=ebe.length;i<ii;i++){_currentInstance.deleteEndpoint(ebe[i],!1)}}
delete endpointsByElement[info.id];if(recurse){if(info.el&&info.el.nodeType!==3&&info.el.nodeType!==8){for(i=0,ii=info.el.childNodes.length;i<ii;i++){_one(info.el.childNodes[i])}}}};_one(el);return this};var _doRemove=function(info,affectedElements){_currentInstance.removeAllEndpoints(info.id,!0,affectedElements);var dm=_currentInstance.getDragManager();var _one=function(_info){if(dm){dm.elementRemoved(_info.id)}
_currentInstance.router.elementRemoved(_info.id);if(_currentInstance.isSource(_info.el)){_currentInstance.unmakeSource(_info.el)}
if(_currentInstance.isTarget(_info.el)){_currentInstance.unmakeTarget(_info.el)}
_currentInstance.destroyDraggable(_info.el);_currentInstance.destroyDroppable(_info.el);delete _currentInstance.floatingConnections[_info.id];delete managedElements[_info.id];delete offsets[_info.id];if(_info.el){_currentInstance.removeElement(_info.el);_info.el._jsPlumb=null}};for(var ae=1;ae<affectedElements.length;ae++){_one(affectedElements[ae])}
_one(info)};this.remove=function(el,doNotRepaint){var info=_info(el),affectedElements=[];if(info.text&&info.el.parentNode){info.el.parentNode.removeChild(info.el)}else if(info.id){_currentInstance.batch(function(){_doRemove(info,affectedElements)},doNotRepaint===!0)}
return _currentInstance};this.empty=function(el,doNotRepaint){var affectedElements=[];var _one=function(el,dontRemoveFocus){var info=_info(el);if(info.text){info.el.parentNode.removeChild(info.el)}else if(info.el){while(info.el.childNodes.length>0){_one(info.el.childNodes[0])}
if(!dontRemoveFocus){_doRemove(info,affectedElements)}}};_currentInstance.batch(function(){_one(el,!0)},doNotRepaint===!1);return _currentInstance};this.reset=function(doNotUnbindInstanceEventListeners){_currentInstance.silently(function(){_hoverSuspended=!1;_currentInstance.removeAllGroups();_currentInstance.removeGroupManager();_currentInstance.deleteEveryEndpoint();if(!doNotUnbindInstanceEventListeners){_currentInstance.unbind()}
this.targetEndpointDefinitions={};this.sourceEndpointDefinitions={};connections.length=0;if(this.doReset){this.doReset()}}.bind(this))};this.destroy=function(){this.reset();_container=null;_containerDelegations=null};var _clearObject=function(obj){if(obj.canvas&&obj.canvas.parentNode){obj.canvas.parentNode.removeChild(obj.canvas)}
obj.cleanup();obj.destroy()};this.clear=function(){_currentInstance.select().each(_clearObject);_currentInstance.selectEndpoints().each(_clearObject);endpointsByElement={};endpointsByUUID={}};this.setDefaultScope=function(scope){DEFAULT_SCOPE=scope;return _currentInstance};this.deriveEndpointAndAnchorSpec=function(type,dontPrependDefault){var bits=((dontPrependDefault?"":"default ")+type).split(/[\s]/),eps=null,ep=null,a=null,as=null;for(var i=0;i<bits.length;i++){var _t=_currentInstance.getType(bits[i],"connection");if(_t){if(_t.endpoints){eps=_t.endpoints}
if(_t.endpoint){ep=_t.endpoint}
if(_t.anchors){as=_t.anchors}
if(_t.anchor){a=_t.anchor}}}
return{endpoints:eps?eps:[ep,ep],anchors:as?as:[a,a]}};this.setId=function(el,newId,doNotSetAttribute){var id;if(_ju.isString(el)){id=el}else{el=this.getElement(el);id=this.getId(el)}
var sConns=this.getConnections({source:id,scope:'*'},!0),tConns=this.getConnections({target:id,scope:'*'},!0);newId=""+newId;if(!doNotSetAttribute){el=this.getElement(id);this.setAttribute(el,"id",newId)}else{el=this.getElement(newId)}
endpointsByElement[newId]=endpointsByElement[id]||[];for(var i=0,ii=endpointsByElement[newId].length;i<ii;i++){endpointsByElement[newId][i].setElementId(newId);endpointsByElement[newId][i].setReferenceElement(el)}
delete endpointsByElement[id];this.sourceEndpointDefinitions[newId]=this.sourceEndpointDefinitions[id];delete this.sourceEndpointDefinitions[id];this.targetEndpointDefinitions[newId]=this.targetEndpointDefinitions[id];delete this.targetEndpointDefinitions[id];this.router.changeId(id,newId);var dm=this.getDragManager();if(dm){dm.changeId(id,newId)}
managedElements[newId]=managedElements[id];delete managedElements[id];var _conns=function(list,epIdx,type){for(var i=0,ii=list.length;i<ii;i++){list[i].endpoints[epIdx].setElementId(newId);list[i].endpoints[epIdx].setReferenceElement(el);list[i][type+"Id"]=newId;list[i][type]=el}};_conns(sConns,0,"source");_conns(tConns,1,"target");this.repaint(newId)};this.setDebugLog=function(debugLog){log=debugLog};this.setSuspendDrawing=function(val,repaintAfterwards){var curVal=_suspendDrawing;_suspendDrawing=val;if(val){_suspendedAt=new Date().getTime()}else{_suspendedAt=null}
if(repaintAfterwards){this.repaintEverything()}
return curVal};this.isSuspendDrawing=function(){return _suspendDrawing};this.getSuspendedAt=function(){return _suspendedAt};this.batch=function(fn,doNotRepaintAfterwards){var _wasSuspended=this.isSuspendDrawing();if(!_wasSuspended){this.setSuspendDrawing(!0)}
try{fn()}catch(e){_ju.log("Function run while suspended failed",e)}
if(!_wasSuspended){this.setSuspendDrawing(!1,!doNotRepaintAfterwards)}};this.doWhileSuspended=this.batch;this.getCachedData=_getCachedData;this.show=function(el,changeEndpoints){_setVisible(el,"block",changeEndpoints);return _currentInstance};this.toggleVisible=_toggleVisible;this.addListener=this.bind;var floatingConnections=[];this.registerFloatingConnection=function(info,conn,ep){floatingConnections[info.id]=conn;_ju.addToList(endpointsByElement,info.id,ep)};this.getFloatingConnectionFor=function(id){return floatingConnections[id]};this.listManager=new root.jsPlumbListManager(this,this.Defaults.ListStyle)};_ju.extend(root.jsPlumbInstance,_ju.EventGenerator,{setAttribute:function(el,a,v){this.setAttribute(el,a,v)},getAttribute:function(el,a){return this.getAttribute(root.jsPlumb.getElement(el),a)},convertToFullOverlaySpec:function(spec){if(_ju.isString(spec)){spec=[spec,{}]}
spec[1].id=spec[1].id||_ju.uuid();return spec},registerConnectionType:function(id,type){this._connectionTypes[id]=root.jsPlumb.extend({},type);if(type.overlays){var to={};for(var i=0;i<type.overlays.length;i++){var fo=this.convertToFullOverlaySpec(type.overlays[i]);to[fo[1].id]=fo}
this._connectionTypes[id].overlays=to}},registerConnectionTypes:function(types){for(var i in types){this.registerConnectionType(i,types[i])}},registerEndpointType:function(id,type){this._endpointTypes[id]=root.jsPlumb.extend({},type);if(type.overlays){var to={};for(var i=0;i<type.overlays.length;i++){var fo=this.convertToFullOverlaySpec(type.overlays[i]);to[fo[1].id]=fo}
this._endpointTypes[id].overlays=to}},registerEndpointTypes:function(types){for(var i in types){this.registerEndpointType(i,types[i])}},getType:function(id,typeDescriptor){return typeDescriptor==="connection"?this._connectionTypes[id]:this._endpointTypes[id]},setIdChanged:function(oldId,newId){this.setId(oldId,newId,!0)},setParent:function(el,newParent){var _dom=this.getElement(el),_id=this.getId(_dom),_pdom=this.getElement(newParent),_pid=this.getId(_pdom),dm=this.getDragManager();_dom.parentNode.removeChild(_dom);_pdom.appendChild(_dom);if(dm){dm.setParent(_dom,_id,_pdom,_pid)}},extend:function(o1,o2,names){var i;if(names){for(i=0;i<names.length;i++){o1[names[i]]=o2[names[i]]}}else{for(i in o2){o1[i]=o2[i]}}
return o1},floatingConnections:{},getFloatingAnchorIndex:function(jpc){return jpc.endpoints[0].isFloating()?0:jpc.endpoints[1].isFloating()?1:-1},proxyConnection:function(connection,index,proxyEl,proxyElId,endpointGenerator,anchorGenerator){var proxyEp,originalElementId=connection.endpoints[index].elementId,originalEndpoint=connection.endpoints[index];connection.proxies=connection.proxies||[];if(connection.proxies[index]){proxyEp=connection.proxies[index].ep}else{proxyEp=this.addEndpoint(proxyEl,{endpoint:endpointGenerator(connection,index),anchor:anchorGenerator(connection,index),parameters:{isProxyEndpoint:!0}})}
proxyEp.setDeleteOnEmpty(!0);connection.proxies[index]={ep:proxyEp,originalEp:originalEndpoint};if(index===0){this.router.sourceOrTargetChanged(originalElementId,proxyElId,connection,proxyEl,0)}else{this.router.sourceOrTargetChanged(originalElementId,proxyElId,connection,proxyEl,1)}
originalEndpoint.detachFromConnection(connection,null,!0);proxyEp.connections=[connection];connection.endpoints[index]=proxyEp;originalEndpoint.setVisible(!1);connection.setVisible(!0);this.revalidate(proxyEl)},unproxyConnection:function(connection,index,proxyElId){if(connection._jsPlumb==null||connection.proxies==null||connection.proxies[index]==null){return}
var originalElement=connection.proxies[index].originalEp.element,originalElementId=connection.proxies[index].originalEp.elementId;connection.endpoints[index]=connection.proxies[index].originalEp;if(index===0){this.router.sourceOrTargetChanged(proxyElId,originalElementId,connection,originalElement,0)}else{this.router.sourceOrTargetChanged(proxyElId,originalElementId,connection,originalElement,1)}
connection.proxies[index].ep.detachFromConnection(connection,null);connection.proxies[index].originalEp.addConnection(connection);if(connection.isVisible()){connection.proxies[index].originalEp.setVisible(!0)}
delete connection.proxies[index]}});var jsPlumb=new jsPlumbInstance();root.jsPlumb=jsPlumb;jsPlumb.getInstance=function(_defaults,overrideFns){var j=new jsPlumbInstance(_defaults);if(overrideFns){for(var ovf in overrideFns){j[ovf]=overrideFns[ovf]}}
j.init();return j};jsPlumb.each=function(spec,fn){if(spec==null){return}
if(typeof spec==="string"){fn(jsPlumb.getElement(spec))}else if(spec.length!=null){for(var i=0;i<spec.length;i++){fn(jsPlumb.getElement(spec[i]))}}else{fn(spec)}};if(typeof exports!=='undefined'){exports.jsPlumb=jsPlumb}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var _internalLabelOverlayId="__label",_makeLabelOverlay=function(component,params){var _params={cssClass:params.cssClass,labelStyle:component.labelStyle,id:_internalLabelOverlayId,component:component,_jsPlumb:component._jsPlumb.instance},mergedParams=_jp.extend(_params,params);return new _jp.Overlays[component._jsPlumb.instance.getRenderMode()].Label(mergedParams)},_processOverlay=function(component,o){var _newOverlay=null;if(_ju.isArray(o)){var type=o[0],p=_jp.extend({component:component,_jsPlumb:component._jsPlumb.instance},o[1]);if(o.length===3){_jp.extend(p,o[2])}
_newOverlay=new _jp.Overlays[component._jsPlumb.instance.getRenderMode()][type](p)}else if(o.constructor===String){_newOverlay=new _jp.Overlays[component._jsPlumb.instance.getRenderMode()][o]({component:component,_jsPlumb:component._jsPlumb.instance})}else{_newOverlay=o}
_newOverlay.id=_newOverlay.id||_ju.uuid();component.cacheTypeItem("overlay",_newOverlay,_newOverlay.id);component._jsPlumb.overlays[_newOverlay.id]=_newOverlay;return _newOverlay};_jp.OverlayCapableJsPlumbUIComponent=function(params){root.jsPlumbUIComponent.apply(this,arguments);this._jsPlumb.overlays={};this._jsPlumb.overlayPositions={};if(params.label){this.getDefaultType().overlays[_internalLabelOverlayId]=["Label",{label:params.label,location:params.labelLocation||this.defaultLabelLocation||0.5,labelStyle:params.labelStyle||this._jsPlumb.instance.Defaults.LabelStyle,id:_internalLabelOverlayId}]}
this.setListenerComponent=function(c){if(this._jsPlumb){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].setListenerComponent(c)}}}};_jp.OverlayCapableJsPlumbUIComponent.applyType=function(component,t){if(t.overlays){var keep={},i;for(i in t.overlays){var existing=component._jsPlumb.overlays[t.overlays[i][1].id];if(existing){existing.updateFrom(t.overlays[i][1]);keep[t.overlays[i][1].id]=!0;existing.reattach(component._jsPlumb.instance,component)}else{var c=component.getCachedTypeItem("overlay",t.overlays[i][1].id);if(c!=null){c.reattach(component._jsPlumb.instance,component);c.setVisible(!0);c.updateFrom(t.overlays[i][1]);component._jsPlumb.overlays[c.id]=c}else{c=component.addOverlay(t.overlays[i],!0)}
keep[c.id]=!0}}
for(i in component._jsPlumb.overlays){if(keep[component._jsPlumb.overlays[i].id]==null){component.removeOverlay(component._jsPlumb.overlays[i].id,!0)}}}};_ju.extend(_jp.OverlayCapableJsPlumbUIComponent,root.jsPlumbUIComponent,{setHover:function(hover,ignoreAttachedElements){if(this._jsPlumb&&!this._jsPlumb.instance.isConnectionBeingDragged()){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i][hover?"addClass":"removeClass"](this._jsPlumb.instance.hoverClass)}}},addOverlay:function(overlay,doNotRepaint){var o=_processOverlay(this,overlay);if(this.getData&&o.type==="Label"&&_ju.isArray(overlay)){var d=this.getData(),p=overlay[1];if(d){var locationAttribute=p.labelLocationAttribute||"labelLocation";var loc=d?d[locationAttribute]:null;if(loc){o.loc=loc}}}
if(!doNotRepaint){this.repaint()}
return o},getOverlay:function(id){return this._jsPlumb.overlays[id]},getOverlays:function(){return this._jsPlumb.overlays},hideOverlay:function(id){var o=this.getOverlay(id);if(o){o.hide()}},hideOverlays:function(){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].hide()}},showOverlay:function(id){var o=this.getOverlay(id);if(o){o.show()}},showOverlays:function(){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].show()}},removeAllOverlays:function(doNotRepaint){for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays[i].cleanup){this._jsPlumb.overlays[i].cleanup()}}
this._jsPlumb.overlays={};this._jsPlumb.overlayPositions=null;this._jsPlumb.overlayPlacements={};if(!doNotRepaint){this.repaint()}},removeOverlay:function(overlayId,dontCleanup){var o=this._jsPlumb.overlays[overlayId];if(o){o.setVisible(!1);if(!dontCleanup&&o.cleanup){o.cleanup()}
delete this._jsPlumb.overlays[overlayId];if(this._jsPlumb.overlayPositions){delete this._jsPlumb.overlayPositions[overlayId]}
if(this._jsPlumb.overlayPlacements){delete this._jsPlumb.overlayPlacements[overlayId]}}},removeOverlays:function(){for(var i=0,j=arguments.length;i<j;i++){this.removeOverlay(arguments[i])}},moveParent:function(newParent){if(this.bgCanvas){this.bgCanvas.parentNode.removeChild(this.bgCanvas);newParent.appendChild(this.bgCanvas)}
if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas);newParent.appendChild(this.canvas);for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays[i].isAppendedAtTopLevel){var el=this._jsPlumb.overlays[i].getElement();el.parentNode.removeChild(el);newParent.appendChild(el)}}}},getLabel:function(){var lo=this.getOverlay(_internalLabelOverlayId);return lo!=null?lo.getLabel():null},getLabelOverlay:function(){return this.getOverlay(_internalLabelOverlayId)},setLabel:function(l){var lo=this.getOverlay(_internalLabelOverlayId);if(!lo){var params=l.constructor===String||l.constructor===Function?{label:l}:l;lo=_makeLabelOverlay(this,params);this._jsPlumb.overlays[_internalLabelOverlayId]=lo}else{if(l.constructor===String||l.constructor===Function){lo.setLabel(l)}else{if(l.label){lo.setLabel(l.label)}
if(l.location){lo.setLocation(l.location)}}}
if(!this._jsPlumb.instance.isSuspendDrawing()){this.repaint()}},cleanup:function(force){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].cleanup(force);this._jsPlumb.overlays[i].destroy(force)}
if(force){this._jsPlumb.overlays={};this._jsPlumb.overlayPositions=null}},setVisible:function(v){this[v?"showOverlays":"hideOverlays"]()},setAbsoluteOverlayPosition:function(overlay,xy){this._jsPlumb.overlayPositions[overlay.id]=xy},getAbsoluteOverlayPosition:function(overlay){return this._jsPlumb.overlayPositions?this._jsPlumb.overlayPositions[overlay.id]:null},_clazzManip:function(action,clazz,dontUpdateOverlays){if(!dontUpdateOverlays){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i][action+"Class"](clazz)}}},addClass:function(clazz,dontUpdateOverlays){this._clazzManip("add",clazz,dontUpdateOverlays)},removeClass:function(clazz,dontUpdateOverlays){this._clazzManip("remove",clazz,dontUpdateOverlays)}})}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var _makeConnectionDragHandler=function(endpoint,placeholder,_jsPlumb){var stopped=!1;return{drag:function(){if(stopped){stopped=!1;return!0}
if(placeholder.element){var _ui=_jsPlumb.getUIPosition(arguments,_jsPlumb.getZoom());if(_ui!=null){_jsPlumb.setPosition(placeholder.element,_ui)}
_jsPlumb.repaint(placeholder.element,_ui);endpoint.paint({anchorPoint:endpoint.anchor.getCurrentLocation({element:endpoint})})}},stopDrag:function(){stopped=!0}}};var _makeDraggablePlaceholder=function(placeholder,_jsPlumb,ipco,ips){var n=_jsPlumb.createElement("div",{position:"absolute"});_jsPlumb.appendElement(n);var id=_jsPlumb.getId(n);_jsPlumb.setPosition(n,ipco);n.style.width=ips[0]+"px";n.style.height=ips[1]+"px";_jsPlumb.manage(id,n,!0);placeholder.id=id;placeholder.element=n};var _makeFloatingEndpoint=function(paintStyle,referenceAnchor,endpoint,referenceCanvas,sourceElement,_jsPlumb,_newEndpoint,scope){var floatingAnchor=new _jp.FloatingAnchor({reference:referenceAnchor,referenceCanvas:referenceCanvas,jsPlumbInstance:_jsPlumb});return _newEndpoint({paintStyle:paintStyle,endpoint:endpoint,anchor:floatingAnchor,source:sourceElement,scope:scope})};var typeParameters=["connectorStyle","connectorHoverStyle","connectorOverlays","connector","connectionType","connectorClass","connectorHoverClass"];var findConnectionToUseForDynamicAnchor=function(ep,elementWithPrecedence){var idx=0;if(elementWithPrecedence!=null){for(var i=0;i<ep.connections.length;i++){if(ep.connections[i].sourceId===elementWithPrecedence||ep.connections[i].targetId===elementWithPrecedence){idx=i;break}}}
return ep.connections[idx]};_jp.Endpoint=function(params){var _jsPlumb=params._jsPlumb,_newConnection=params.newConnection,_newEndpoint=params.newEndpoint;this.idPrefix="_jsplumb_e_";this.defaultLabelLocation=[0.5,0.5];this.defaultOverlayKeys=["Overlays","EndpointOverlays"];_jp.OverlayCapableJsPlumbUIComponent.apply(this,arguments);this.appendToDefaultType({connectionType:params.connectionType,maxConnections:params.maxConnections==null?this._jsPlumb.instance.Defaults.MaxConnections:params.maxConnections,paintStyle:params.endpointStyle||params.paintStyle||params.style||this._jsPlumb.instance.Defaults.EndpointStyle||_jp.Defaults.EndpointStyle,hoverPaintStyle:params.endpointHoverStyle||params.hoverPaintStyle||this._jsPlumb.instance.Defaults.EndpointHoverStyle||_jp.Defaults.EndpointHoverStyle,connectorStyle:params.connectorStyle,connectorHoverStyle:params.connectorHoverStyle,connectorClass:params.connectorClass,connectorHoverClass:params.connectorHoverClass,connectorOverlays:params.connectorOverlays,connector:params.connector,connectorTooltip:params.connectorTooltip});this._jsPlumb.enabled=!(params.enabled===!1);this._jsPlumb.visible=!0;this.element=_jp.getElement(params.source);this._jsPlumb.uuid=params.uuid;this._jsPlumb.floatingEndpoint=null;var inPlaceCopy=null;if(this._jsPlumb.uuid){params.endpointsByUUID[this._jsPlumb.uuid]=this}
this.elementId=params.elementId;this.dragProxy=params.dragProxy;this._jsPlumb.connectionCost=params.connectionCost;this._jsPlumb.connectionsDirected=params.connectionsDirected;this._jsPlumb.currentAnchorClass="";this._jsPlumb.events={};var deleteOnEmpty=params.deleteOnEmpty===!0;this.setDeleteOnEmpty=function(d){deleteOnEmpty=d};var _updateAnchorClass=function(){var oldAnchorClass=_jsPlumb.endpointAnchorClassPrefix+"-"+this._jsPlumb.currentAnchorClass;this._jsPlumb.currentAnchorClass=this.anchor.getCssClass();var anchorClass=_jsPlumb.endpointAnchorClassPrefix+(this._jsPlumb.currentAnchorClass?"-"+this._jsPlumb.currentAnchorClass:"");this.removeClass(oldAnchorClass);this.addClass(anchorClass);_jp.updateClasses(this.element,anchorClass,oldAnchorClass)}.bind(this);this.prepareAnchor=function(anchorParams){var a=this._jsPlumb.instance.makeAnchor(anchorParams,this.elementId,_jsPlumb);a.bind("anchorChanged",function(currentAnchor){this.fire("anchorChanged",{endpoint:this,anchor:currentAnchor});_updateAnchorClass()}.bind(this));return a};this.setPreparedAnchor=function(anchor,doNotRepaint){this._jsPlumb.instance.continuousAnchorFactory.clear(this.elementId);this.anchor=anchor;_updateAnchorClass();if(!doNotRepaint){this._jsPlumb.instance.repaint(this.elementId)}
return this};this.setAnchor=function(anchorParams,doNotRepaint){var a=this.prepareAnchor(anchorParams);this.setPreparedAnchor(a,doNotRepaint);return this};var internalHover=function(state){if(this.connections.length>0){for(var i=0;i<this.connections.length;i++){this.connections[i].setHover(state,!1)}}else{this.setHover(state)}}.bind(this);this.bind("mouseover",function(){internalHover(!0)});this.bind("mouseout",function(){internalHover(!1)});if(!params._transient){this._jsPlumb.instance.router.addEndpoint(this,this.elementId)}
this.prepareEndpoint=function(ep,typeId){var _e=function(t,p){var rm=_jsPlumb.getRenderMode();if(_jp.Endpoints[rm][t]){return new _jp.Endpoints[rm][t](p)}
if(!_jsPlumb.Defaults.DoNotThrowErrors){throw{msg:"jsPlumb: unknown endpoint type '"+t+"'"}}};var endpointArgs={_jsPlumb:this._jsPlumb.instance,cssClass:params.cssClass,container:params.container,tooltip:params.tooltip,connectorTooltip:params.connectorTooltip,endpoint:this};var endpoint;if(_ju.isString(ep)){endpoint=_e(ep,endpointArgs)}else if(_ju.isArray(ep)){endpointArgs=_ju.merge(ep[1],endpointArgs);endpoint=_e(ep[0],endpointArgs)}else{endpoint=ep.clone()}
endpoint.clone=function(){if(_ju.isString(ep)){return _e(ep,endpointArgs)}else if(_ju.isArray(ep)){endpointArgs=_ju.merge(ep[1],endpointArgs);return _e(ep[0],endpointArgs)}}.bind(this);endpoint.typeId=typeId;return endpoint};this.setEndpoint=function(ep,doNotRepaint){var _ep=this.prepareEndpoint(ep);this.setPreparedEndpoint(_ep,!0)};this.setPreparedEndpoint=function(ep,doNotRepaint){if(this.endpoint!=null){this.endpoint.cleanup();this.endpoint.destroy()}
this.endpoint=ep;this.type=this.endpoint.type;this.canvas=this.endpoint.canvas};_jp.extend(this,params,typeParameters);this.isSource=params.isSource||!1;this.isTemporarySource=params.isTemporarySource||!1;this.isTarget=params.isTarget||!1;this.connections=params.connections||[];this.connectorPointerEvents=params["connector-pointer-events"];this.scope=params.scope||_jsPlumb.getDefaultScope();this.timestamp=null;this.reattachConnections=params.reattach||_jsPlumb.Defaults.ReattachConnections;this.connectionsDetachable=_jsPlumb.Defaults.ConnectionsDetachable;if(params.connectionsDetachable===!1||params.detachable===!1){this.connectionsDetachable=!1}
this.dragAllowedWhenFull=params.dragAllowedWhenFull!==!1;if(params.onMaxConnections){this.bind("maxConnections",params.onMaxConnections)}
this.addConnection=function(connection){this.connections.push(connection);this[(this.connections.length>0?"add":"remove")+"Class"](_jsPlumb.endpointConnectedClass);this[(this.isFull()?"add":"remove")+"Class"](_jsPlumb.endpointFullClass)};this.detachFromConnection=function(connection,idx,doNotCleanup){idx=idx==null?this.connections.indexOf(connection):idx;if(idx>=0){this.connections.splice(idx,1);this[(this.connections.length>0?"add":"remove")+"Class"](_jsPlumb.endpointConnectedClass);this[(this.isFull()?"add":"remove")+"Class"](_jsPlumb.endpointFullClass)}
if(!doNotCleanup&&deleteOnEmpty&&this.connections.length===0){_jsPlumb.deleteObject({endpoint:this,fireEvent:!1,deleteAttachedObjects:doNotCleanup!==!0})}};this.deleteEveryConnection=function(params){var c=this.connections.length;for(var i=0;i<c;i++){_jsPlumb.deleteConnection(this.connections[0],params)}};this.detachFrom=function(targetEndpoint,fireEvent,originalEvent){var c=[];for(var i=0;i<this.connections.length;i++){if(this.connections[i].endpoints[1]===targetEndpoint||this.connections[i].endpoints[0]===targetEndpoint){c.push(this.connections[i])}}
for(var j=0,count=c.length;j<count;j++){_jsPlumb.deleteConnection(c[0])}
return this};this.getElement=function(){return this.element};this.setElement=function(el){var parentId=this._jsPlumb.instance.getId(el),curId=this.elementId;_ju.removeWithFunction(params.endpointsByElement[this.elementId],function(e){return e.id===this.id}.bind(this));this.element=_jp.getElement(el);this.elementId=_jsPlumb.getId(this.element);_jsPlumb.router.rehomeEndpoint(this,curId,this.element);_jsPlumb.dragManager.endpointAdded(this.element);_ju.addToList(params.endpointsByElement,parentId,this);return this};this.makeInPlaceCopy=function(){var loc=this.anchor.getCurrentLocation({element:this}),o=this.anchor.getOrientation(this),acc=this.anchor.getCssClass(),inPlaceAnchor={bind:function(){},compute:function(){return[loc[0],loc[1]]},getCurrentLocation:function(){return[loc[0],loc[1]]},getOrientation:function(){return o},getCssClass:function(){return acc}};return _newEndpoint({dropOptions:params.dropOptions,anchor:inPlaceAnchor,source:this.element,paintStyle:this.getPaintStyle(),endpoint:params.hideOnDrag?"Blank":this.endpoint,_transient:!0,scope:this.scope,reference:this})};this.connectorSelector=function(){return this.connections[0]};this.setStyle=this.setPaintStyle;this.paint=function(params){params=params||{};var timestamp=params.timestamp,recalc=!(params.recalc===!1);if(!timestamp||this.timestamp!==timestamp){var info=_jsPlumb.updateOffset({elId:this.elementId,timestamp:timestamp});var xy=params.offset?params.offset.o:info.o;if(xy!=null){var ap=params.anchorPoint,connectorPaintStyle=params.connectorPaintStyle;if(ap==null){var wh=params.dimensions||info.s,anchorParams={xy:[xy.left,xy.top],wh:wh,element:this,timestamp:timestamp};if(recalc&&this.anchor.isDynamic&&this.connections.length>0){var c=findConnectionToUseForDynamicAnchor(this,params.elementWithPrecedence),oIdx=c.endpoints[0]===this?1:0,oId=oIdx===0?c.sourceId:c.targetId,oInfo=_jsPlumb.getCachedData(oId),oOffset=oInfo.o,oWH=oInfo.s;anchorParams.index=oIdx===0?1:0;anchorParams.connection=c;anchorParams.txy=[oOffset.left,oOffset.top];anchorParams.twh=oWH;anchorParams.tElement=c.endpoints[oIdx];anchorParams.tRotation=_jsPlumb.getRotation(oId)}else if(this.connections.length>0){anchorParams.connection=this.connections[0]}
anchorParams.rotation=_jsPlumb.getRotation(this.elementId);ap=this.anchor.compute(anchorParams)}
this.endpoint.compute(ap,this.anchor.getOrientation(this),this._jsPlumb.paintStyleInUse,connectorPaintStyle||this.paintStyleInUse);this.endpoint.paint(this._jsPlumb.paintStyleInUse,this.anchor);this.timestamp=timestamp;for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays.hasOwnProperty(i)){var o=this._jsPlumb.overlays[i];if(o.isVisible()){this._jsPlumb.overlayPlacements[i]=o.draw(this.endpoint,this._jsPlumb.paintStyleInUse);o.paint(this._jsPlumb.overlayPlacements[i])}}}}}};this.getTypeDescriptor=function(){return"endpoint"};this.isVisible=function(){return this._jsPlumb.visible};this.repaint=this.paint;var draggingInitialised=!1;this.initDraggable=function(){if(!draggingInitialised&&_jp.isDragSupported(this.element)){var placeholderInfo={id:null,element:null},jpc=null,existingJpc=!1,existingJpcParams=null,_dragHandler=_makeConnectionDragHandler(this,placeholderInfo,_jsPlumb),dragOptions=params.dragOptions||{},defaultOpts={},startEvent=_jp.dragEvents.start,stopEvent=_jp.dragEvents.stop,dragEvent=_jp.dragEvents.drag,beforeStartEvent=_jp.dragEvents.beforeStart,payload;var beforeStart=function(beforeStartParams){payload=beforeStartParams.e.payload||{}};var start=function(startParams){jpc=this.connectorSelector();var _continue=!0;if(!this.isEnabled()){_continue=!1}
if(jpc==null&&!this.isSource&&!this.isTemporarySource){_continue=!1}
if(this.isSource&&this.isFull()&&!(jpc!=null&&this.dragAllowedWhenFull)){_continue=!1}
if(jpc!=null&&!jpc.isDetachable(this)){if(this.isFull()){_continue=!1}else{jpc=null}}
var beforeDrag=_jsPlumb.checkCondition(jpc==null?"beforeDrag":"beforeStartDetach",{endpoint:this,source:this.element,sourceId:this.elementId,connection:jpc});if(beforeDrag===!1){_continue=!1}else if(typeof beforeDrag==="object"){_jp.extend(beforeDrag,payload||{})}else{beforeDrag=payload||{}}
if(_continue===!1){if(_jsPlumb.stopDrag){_jsPlumb.stopDrag(this.canvas)}
_dragHandler.stopDrag();return!1}
for(var i=0;i<this.connections.length;i++){this.connections[i].setHover(!1)}
this.addClass("endpointDrag");_jsPlumb.setConnectionBeingDragged(!0);if(jpc&&!this.isFull()&&this.isSource){jpc=null}
_jsPlumb.updateOffset({elId:this.elementId});var ipco=this._jsPlumb.instance.getOffset(this.canvas),canvasElement=this.canvas,ips=this._jsPlumb.instance.getSize(this.canvas);_makeDraggablePlaceholder(placeholderInfo,_jsPlumb,ipco,ips);_jsPlumb.setAttributes(this.canvas,{"dragId":placeholderInfo.id,"elId":this.elementId});var endpointToFloat=this.dragProxy||this.endpoint;if(this.dragProxy==null&&this.connectionType!=null){var aae=this._jsPlumb.instance.deriveEndpointAndAnchorSpec(this.connectionType);if(aae.endpoints[1]){endpointToFloat=aae.endpoints[1]}}
var centerAnchor=this._jsPlumb.instance.makeAnchor("Center");centerAnchor.isFloating=!0;this._jsPlumb.floatingEndpoint=_makeFloatingEndpoint(this.getPaintStyle(),centerAnchor,endpointToFloat,this.canvas,placeholderInfo.element,_jsPlumb,_newEndpoint,this.scope);var _savedAnchor=this._jsPlumb.floatingEndpoint.anchor;if(jpc==null){this.setHover(!1,!1);jpc=_newConnection({sourceEndpoint:this,targetEndpoint:this._jsPlumb.floatingEndpoint,source:this.element,target:placeholderInfo.element,anchors:[this.anchor,this._jsPlumb.floatingEndpoint.anchor],paintStyle:params.connectorStyle,hoverPaintStyle:params.connectorHoverStyle,connector:params.connector,overlays:params.connectorOverlays,type:this.connectionType,cssClass:this.connectorClass,hoverClass:this.connectorHoverClass,scope:params.scope,data:beforeDrag});jpc.pending=!0;jpc.addClass(_jsPlumb.draggingClass);this._jsPlumb.floatingEndpoint.addClass(_jsPlumb.draggingClass);this._jsPlumb.floatingEndpoint.anchor=_savedAnchor;_jsPlumb.fire("connectionDrag",jpc);_jsPlumb.router.newConnection(jpc)}else{existingJpc=!0;jpc.setHover(!1);var anchorIdx=jpc.endpoints[0].id===this.id?0:1;this.detachFromConnection(jpc,null,!0);var dragScope=_jsPlumb.getDragScope(canvasElement);_jsPlumb.setAttribute(this.canvas,"originalScope",dragScope);_jsPlumb.fire("connectionDrag",jpc);if(anchorIdx===0){existingJpcParams=[jpc.source,jpc.sourceId,canvasElement,dragScope];_jsPlumb.router.sourceOrTargetChanged(jpc.endpoints[anchorIdx].elementId,placeholderInfo.id,jpc,placeholderInfo.element,0)}else{existingJpcParams=[jpc.target,jpc.targetId,canvasElement,dragScope];_jsPlumb.router.sourceOrTargetChanged(jpc.endpoints[anchorIdx].elementId,placeholderInfo.id,jpc,placeholderInfo.element,1)}
jpc.suspendedEndpoint=jpc.endpoints[anchorIdx];jpc.suspendedElement=jpc.endpoints[anchorIdx].getElement();jpc.suspendedElementId=jpc.endpoints[anchorIdx].elementId;jpc.suspendedElementType=anchorIdx===0?"source":"target";jpc.suspendedEndpoint.setHover(!1);this._jsPlumb.floatingEndpoint.referenceEndpoint=jpc.suspendedEndpoint;jpc.endpoints[anchorIdx]=this._jsPlumb.floatingEndpoint;jpc.addClass(_jsPlumb.draggingClass);this._jsPlumb.floatingEndpoint.addClass(_jsPlumb.draggingClass)}
_jsPlumb.registerFloatingConnection(placeholderInfo,jpc,this._jsPlumb.floatingEndpoint);_jsPlumb.currentlyDragging=!0}.bind(this);var stop=function(){_jsPlumb.setConnectionBeingDragged(!1);if(jpc&&jpc.endpoints!=null){var originalEvent=_jsPlumb.getDropEvent(arguments);var idx=_jsPlumb.getFloatingAnchorIndex(jpc);jpc.endpoints[idx===0?1:0].anchor.locked=!1;jpc.removeClass(_jsPlumb.draggingClass);if(this._jsPlumb&&(jpc.deleteConnectionNow||jpc.endpoints[idx]===this._jsPlumb.floatingEndpoint)){if(existingJpc&&jpc.suspendedEndpoint){if(idx===0){jpc.floatingElement=jpc.source;jpc.floatingId=jpc.sourceId;jpc.floatingEndpoint=jpc.endpoints[0];jpc.floatingIndex=0;jpc.source=existingJpcParams[0];jpc.sourceId=existingJpcParams[1]}else{jpc.floatingElement=jpc.target;jpc.floatingId=jpc.targetId;jpc.floatingEndpoint=jpc.endpoints[1];jpc.floatingIndex=1;jpc.target=existingJpcParams[0];jpc.targetId=existingJpcParams[1]}
var fe=this._jsPlumb.floatingEndpoint;_jsPlumb.setDragScope(existingJpcParams[2],existingJpcParams[3]);jpc.endpoints[idx]=jpc.suspendedEndpoint;if(jpc.isReattach()||jpc._forceReattach||jpc._forceDetach||!_jsPlumb.deleteConnection(jpc,{originalEvent:originalEvent})){jpc.setHover(!1);jpc._forceDetach=null;jpc._forceReattach=null;this._jsPlumb.floatingEndpoint.detachFromConnection(jpc);jpc.suspendedEndpoint.addConnection(jpc);if(idx===1){_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.targetId,jpc,jpc.target,idx)}else{_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.sourceId,jpc,jpc.source,idx)}
_jsPlumb.repaint(existingJpcParams[1])}else{_jsPlumb.deleteObject({endpoint:fe})}}}
if(this.deleteAfterDragStop){_jsPlumb.deleteObject({endpoint:this})}else{if(this._jsPlumb){this.paint({recalc:!1})}}
_jsPlumb.fire("connectionDragStop",jpc,originalEvent);if(jpc.pending){_jsPlumb.fire("connectionAborted",jpc,originalEvent)}
_jsPlumb.currentlyDragging=!1;jpc.suspendedElement=null;jpc.suspendedEndpoint=null;jpc=null}
if(placeholderInfo&&placeholderInfo.element){_jsPlumb.remove(placeholderInfo.element,!1,!1)}
if(inPlaceCopy){_jsPlumb.deleteObject({endpoint:inPlaceCopy})}
if(this._jsPlumb){this.canvas.style.visibility="visible";this.anchor.locked=!1;this._jsPlumb.floatingEndpoint=null}}.bind(this);dragOptions=_jp.extend(defaultOpts,dragOptions);dragOptions.scope=this.scope||dragOptions.scope;dragOptions[beforeStartEvent]=_ju.wrap(dragOptions[beforeStartEvent],beforeStart,!1);dragOptions[startEvent]=_ju.wrap(dragOptions[startEvent],start,!1);dragOptions[dragEvent]=_ju.wrap(dragOptions[dragEvent],_dragHandler.drag);dragOptions[stopEvent]=_ju.wrap(dragOptions[stopEvent],stop);dragOptions.multipleDrop=!1;dragOptions.canDrag=function(){return this.isSource||this.isTemporarySource||(this.connections.length>0&&this.connectionsDetachable!==!1)}.bind(this);_jsPlumb.initDraggable(this.canvas,dragOptions,"internal");this.canvas._jsPlumbRelatedElement=this.element;draggingInitialised=!0}};var ep=params.endpoint||this._jsPlumb.instance.Defaults.Endpoint||_jp.Defaults.Endpoint;this.setEndpoint(ep,!0);var anchorParamsToUse=params.anchor?params.anchor:params.anchors?params.anchors:(_jsPlumb.Defaults.Anchor||"Top");this.setAnchor(anchorParamsToUse,!0);var type=["default",(params.type||"")].join(" ");this.addType(type,params.data,!0);this.canvas=this.endpoint.canvas;this.canvas._jsPlumb=this;this.initDraggable();var _initDropTarget=function(canvas,isTransient,endpoint,referenceEndpoint){if(_jp.isDropSupported(this.element)){var dropOptions=params.dropOptions||_jsPlumb.Defaults.DropOptions||_jp.Defaults.DropOptions;dropOptions=_jp.extend({},dropOptions);dropOptions.scope=dropOptions.scope||this.scope;var dropEvent=_jp.dragEvents.drop,overEvent=_jp.dragEvents.over,outEvent=_jp.dragEvents.out,_ep=this,drop=_jsPlumb.EndpointDropHandler({getEndpoint:function(){return _ep},jsPlumb:_jsPlumb,enabled:function(){return endpoint!=null?endpoint.isEnabled():!0},isFull:function(){return endpoint.isFull()},element:this.element,elementId:this.elementId,isSource:this.isSource,isTarget:this.isTarget,addClass:function(clazz){_ep.addClass(clazz)},removeClass:function(clazz){_ep.removeClass(clazz)},isDropAllowed:function(){return _ep.isDropAllowed.apply(_ep,arguments)},reference:referenceEndpoint,isRedrop:function(jpc,dhParams){return jpc.suspendedEndpoint&&dhParams.reference&&(jpc.suspendedEndpoint.id===dhParams.reference.id)}});dropOptions[dropEvent]=_ju.wrap(dropOptions[dropEvent],drop,!0);dropOptions[overEvent]=_ju.wrap(dropOptions[overEvent],function(){var draggable=_jp.getDragObject(arguments),id=_jsPlumb.getAttribute(_jp.getElement(draggable),"dragId"),_jpc=_jsPlumb.getFloatingConnectionFor(id);if(_jpc!=null){var idx=_jsPlumb.getFloatingAnchorIndex(_jpc);var _cont=(this.isTarget&&idx!==0)||(_jpc.suspendedEndpoint&&this.referenceEndpoint&&this.referenceEndpoint.id===_jpc.suspendedEndpoint.id);if(_cont){var bb=_jsPlumb.checkCondition("checkDropAllowed",{sourceEndpoint:_jpc.endpoints[idx],targetEndpoint:this,connection:_jpc});this[(bb?"add":"remove")+"Class"](_jsPlumb.endpointDropAllowedClass);this[(bb?"remove":"add")+"Class"](_jsPlumb.endpointDropForbiddenClass);_jpc.endpoints[idx].anchor.over(this.anchor,this)}}}.bind(this));dropOptions[outEvent]=_ju.wrap(dropOptions[outEvent],function(){var draggable=_jp.getDragObject(arguments),id=draggable==null?null:_jsPlumb.getAttribute(_jp.getElement(draggable),"dragId"),_jpc=id?_jsPlumb.getFloatingConnectionFor(id):null;if(_jpc!=null){var idx=_jsPlumb.getFloatingAnchorIndex(_jpc);var _cont=(this.isTarget&&idx!==0)||(_jpc.suspendedEndpoint&&this.referenceEndpoint&&this.referenceEndpoint.id===_jpc.suspendedEndpoint.id);if(_cont){this.removeClass(_jsPlumb.endpointDropAllowedClass);this.removeClass(_jsPlumb.endpointDropForbiddenClass);_jpc.endpoints[idx].anchor.out()}}}.bind(this));_jsPlumb.initDroppable(canvas,dropOptions,"internal",isTransient)}}.bind(this);if(!this.anchor.isFloating){_initDropTarget(this.canvas,!(params._transient||this.anchor.isFloating),this,params.reference)}
return this};_ju.extend(_jp.Endpoint,_jp.OverlayCapableJsPlumbUIComponent,{setVisible:function(v,doNotChangeConnections,doNotNotifyOtherEndpoint){this._jsPlumb.visible=v;if(this.canvas){this.canvas.style.display=v?"block":"none"}
this[v?"showOverlays":"hideOverlays"]();if(!doNotChangeConnections){for(var i=0;i<this.connections.length;i++){this.connections[i].setVisible(v);if(!doNotNotifyOtherEndpoint){var oIdx=this===this.connections[i].endpoints[0]?1:0;if(this.connections[i].endpoints[oIdx].connections.length===1){this.connections[i].endpoints[oIdx].setVisible(v,!0,!0)}}}}},getAttachedElements:function(){return this.connections},applyType:function(t,doNotRepaint){this.setPaintStyle(t.endpointStyle||t.paintStyle,doNotRepaint);this.setHoverPaintStyle(t.endpointHoverStyle||t.hoverPaintStyle,doNotRepaint);if(t.maxConnections!=null){this._jsPlumb.maxConnections=t.maxConnections}
if(t.scope){this.scope=t.scope}
_jp.extend(this,t,typeParameters);if(t.cssClass!=null&&this.canvas){this._jsPlumb.instance.addClass(this.canvas,t.cssClass)}
_jp.OverlayCapableJsPlumbUIComponent.applyType(this,t)},isEnabled:function(){return this._jsPlumb.enabled},setEnabled:function(e){this._jsPlumb.enabled=e},cleanup:function(){var anchorClass=this._jsPlumb.instance.endpointAnchorClassPrefix+(this._jsPlumb.currentAnchorClass?"-"+this._jsPlumb.currentAnchorClass:"");_jp.removeClass(this.element,anchorClass);this.anchor=null;this.endpoint.cleanup(!0);this.endpoint.destroy();this.endpoint=null;this._jsPlumb.instance.destroyDraggable(this.canvas,"internal");this._jsPlumb.instance.destroyDroppable(this.canvas,"internal")},setHover:function(h){if(this.endpoint&&this._jsPlumb&&!this._jsPlumb.instance.isConnectionBeingDragged()){this.endpoint.setHover(h)}},isFull:function(){return this._jsPlumb.maxConnections===0?!0:!(this.isFloating()||this._jsPlumb.maxConnections<0||this.connections.length<this._jsPlumb.maxConnections)},isFloating:function(){return this.anchor!=null&&this.anchor.isFloating},isConnectedTo:function(endpoint){var found=!1;if(endpoint){for(var i=0;i<this.connections.length;i++){if(this.connections[i].endpoints[1]===endpoint||this.connections[i].endpoints[0]===endpoint){found=!0;break}}}
return found},getConnectionCost:function(){return this._jsPlumb.connectionCost},setConnectionCost:function(c){this._jsPlumb.connectionCost=c},areConnectionsDirected:function(){return this._jsPlumb.connectionsDirected},setConnectionsDirected:function(b){this._jsPlumb.connectionsDirected=b},setElementId:function(_elId){this.elementId=_elId;this.anchor.elementId=_elId},setReferenceElement:function(_el){this.element=_jp.getElement(_el)},setDragAllowedWhenFull:function(allowed){this.dragAllowedWhenFull=allowed},equals:function(endpoint){return this.anchor.equals(endpoint.anchor)},getUuid:function(){return this._jsPlumb.uuid},computeAnchor:function(params){return this.anchor.compute(params)}});root.jsPlumbInstance.prototype.EndpointDropHandler=function(dhParams){return function(e){var _jsPlumb=dhParams.jsPlumb;dhParams.removeClass(_jsPlumb.endpointDropAllowedClass);dhParams.removeClass(_jsPlumb.endpointDropForbiddenClass);var originalEvent=_jsPlumb.getDropEvent(arguments),draggable=_jsPlumb.getDragObject(arguments),id=_jsPlumb.getAttribute(draggable,"dragId"),elId=_jsPlumb.getAttribute(draggable,"elId"),scope=_jsPlumb.getAttribute(draggable,"originalScope"),jpc=_jsPlumb.getFloatingConnectionFor(id);if(jpc==null){return}
var existingConnection=jpc.suspendedEndpoint!=null;if(existingConnection&&jpc.suspendedEndpoint._jsPlumb==null){return}
var _ep=dhParams.getEndpoint(jpc);if(_ep==null){return}
if(dhParams.isRedrop(jpc,dhParams)){jpc._forceReattach=!0;jpc.setHover(!1);if(dhParams.maybeCleanup){dhParams.maybeCleanup(_ep)}
return}
var idx=_jsPlumb.getFloatingAnchorIndex(jpc);if((idx===0&&!dhParams.isSource)||(idx===1&&!dhParams.isTarget)){if(dhParams.maybeCleanup){dhParams.maybeCleanup(_ep)}
return}
if(dhParams.onDrop){dhParams.onDrop(jpc)}
if(scope){_jsPlumb.setDragScope(draggable,scope)}
var isFull=dhParams.isFull(e);if(isFull){_ep.fire("maxConnections",{endpoint:this,connection:jpc,maxConnections:_ep._jsPlumb.maxConnections},originalEvent)}
if(!isFull&&dhParams.enabled()){var _doContinue=!0;if(idx===0){jpc.floatingElement=jpc.source;jpc.floatingId=jpc.sourceId;jpc.floatingEndpoint=jpc.endpoints[0];jpc.floatingIndex=0;jpc.source=dhParams.element;jpc.sourceId=_jsPlumb.getId(dhParams.element)}else{jpc.floatingElement=jpc.target;jpc.floatingId=jpc.targetId;jpc.floatingEndpoint=jpc.endpoints[1];jpc.floatingIndex=1;jpc.target=dhParams.element;jpc.targetId=_jsPlumb.getId(dhParams.element)}
if(existingConnection&&jpc.suspendedEndpoint.id!==_ep.id){if(!jpc.isDetachAllowed(jpc)||!jpc.endpoints[idx].isDetachAllowed(jpc)||!jpc.suspendedEndpoint.isDetachAllowed(jpc)||!_jsPlumb.checkCondition("beforeDetach",jpc)){_doContinue=!1}}
var continueFunction=function(optionalData){jpc.endpoints[idx].detachFromConnection(jpc);if(jpc.suspendedEndpoint){jpc.suspendedEndpoint.detachFromConnection(jpc)}
jpc.endpoints[idx]=_ep;_ep.addConnection(jpc);var params=_ep.getParameters();for(var aParam in params){jpc.setParameter(aParam,params[aParam])}
if(!existingConnection){if(params.draggable){_jsPlumb.initDraggable(this.element,dhParams.dragOptions,"internal",_jsPlumb)}}else{var suspendedElementId=jpc.suspendedEndpoint.elementId;_jsPlumb.fireMoveEvent({index:idx,originalSourceId:idx===0?suspendedElementId:jpc.sourceId,newSourceId:idx===0?_ep.elementId:jpc.sourceId,originalTargetId:idx===1?suspendedElementId:jpc.targetId,newTargetId:idx===1?_ep.elementId:jpc.targetId,originalSourceEndpoint:idx===0?jpc.suspendedEndpoint:jpc.endpoints[0],newSourceEndpoint:idx===0?_ep:jpc.endpoints[0],originalTargetEndpoint:idx===1?jpc.suspendedEndpoint:jpc.endpoints[1],newTargetEndpoint:idx===1?_ep:jpc.endpoints[1],connection:jpc},originalEvent)}
if(idx===1){_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.targetId,jpc,jpc.target,1)}else{_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.sourceId,jpc,jpc.source,0)}
if(jpc.endpoints[0].finalEndpoint){var _toDelete=jpc.endpoints[0];_toDelete.detachFromConnection(jpc);jpc.endpoints[0]=jpc.endpoints[0].finalEndpoint;jpc.endpoints[0].addConnection(jpc)}
if(_ju.isObject(optionalData)){jpc.mergeData(optionalData)}
_jsPlumb.finaliseConnection(jpc,null,originalEvent,!1);jpc.setHover(!1);_jsPlumb.revalidate(jpc.endpoints[0].element)}.bind(this);var dontContinueFunction=function(){if(jpc.suspendedEndpoint){jpc.endpoints[idx]=jpc.suspendedEndpoint;jpc.setHover(!1);jpc._forceDetach=!0;if(idx===0){jpc.source=jpc.suspendedEndpoint.element;jpc.sourceId=jpc.suspendedEndpoint.elementId}else{jpc.target=jpc.suspendedEndpoint.element;jpc.targetId=jpc.suspendedEndpoint.elementId}
jpc.suspendedEndpoint.addConnection(jpc);if(idx===1){_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.targetId,jpc,jpc.target,1)}else{_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.sourceId,jpc,jpc.source,0)}
_jsPlumb.repaint(jpc.sourceId);jpc._forceDetach=!1}};_doContinue=_doContinue&&dhParams.isDropAllowed(jpc.sourceId,jpc.targetId,jpc.scope,jpc,_ep);if(_doContinue){continueFunction(_doContinue);return!0}else{dontContinueFunction()}}
if(dhParams.maybeCleanup){dhParams.maybeCleanup(_ep)}
_jsPlumb.currentlyDragging=!1}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var makeConnector=function(_jsPlumb,renderMode,connectorName,connectorArgs,forComponent){_jp.Connectors[renderMode]=_jp.Connectors[renderMode]||{};if(_jp.Connectors[renderMode][connectorName]==null){if(_jp.Connectors[connectorName]==null){if(!_jsPlumb.Defaults.DoNotThrowErrors){throw new TypeError("jsPlumb: unknown connector type '"+connectorName+"'")}else{return null}}
_jp.Connectors[renderMode][connectorName]=function(){_jp.Connectors[connectorName].apply(this,arguments);_jp.ConnectorRenderers[renderMode].apply(this,arguments)};_ju.extend(_jp.Connectors[renderMode][connectorName],[_jp.Connectors[connectorName],_jp.ConnectorRenderers[renderMode]])}
return new _jp.Connectors[renderMode][connectorName](connectorArgs,forComponent)},_makeAnchor=function(anchorParams,elementId,_jsPlumb){return(anchorParams)?_jsPlumb.makeAnchor(anchorParams,elementId,_jsPlumb):null},_updateConnectedClass=function(conn,element,_jsPlumb,remove){if(element!=null){element._jsPlumbConnections=element._jsPlumbConnections||{};if(remove){delete element._jsPlumbConnections[conn.id]}else{element._jsPlumbConnections[conn.id]=!0}
if(_ju.isEmpty(element._jsPlumbConnections)){_jsPlumb.removeClass(element,_jsPlumb.connectedClass)}else{_jsPlumb.addClass(element,_jsPlumb.connectedClass)}}};_jp.Connection=function(params){var _newEndpoint=params.newEndpoint;this.id=params.id;this.connector=null;this.idPrefix="_jsplumb_c_";this.defaultLabelLocation=0.5;this.defaultOverlayKeys=["Overlays","ConnectionOverlays"];this.previousConnection=params.previousConnection;this.source=_jp.getElement(params.source);this.target=_jp.getElement(params.target);_jp.OverlayCapableJsPlumbUIComponent.apply(this,arguments);if(params.sourceEndpoint){this.source=params.sourceEndpoint.getElement();this.sourceId=params.sourceEndpoint.elementId}else{this.sourceId=this._jsPlumb.instance.getId(this.source)}
if(params.targetEndpoint){this.target=params.targetEndpoint.getElement();this.targetId=params.targetEndpoint.elementId}else{this.targetId=this._jsPlumb.instance.getId(this.target)}
this.scope=params.scope;this.endpoints=[];this.endpointStyles=[];var _jsPlumb=this._jsPlumb.instance;_jsPlumb.manage(this.sourceId,this.source);_jsPlumb.manage(this.targetId,this.target);this._jsPlumb.visible=!0;this._jsPlumb.params={cssClass:params.cssClass,container:params.container,"pointer-events":params["pointer-events"],editorParams:params.editorParams,overlays:params.overlays};this._jsPlumb.lastPaintedAt=null;this.bind("mouseover",function(){this.setHover(!0)}.bind(this));this.bind("mouseout",function(){this.setHover(!1)}.bind(this));this.makeEndpoint=function(isSource,el,elId,ep,definition){elId=elId||this._jsPlumb.instance.getId(el);return this.prepareEndpoint(_jsPlumb,_newEndpoint,this,ep,isSource?0:1,params,el,elId,definition)};if(params.type){params.endpoints=params.endpoints||this._jsPlumb.instance.deriveEndpointAndAnchorSpec(params.type).endpoints}
var eS=this.makeEndpoint(!0,this.source,this.sourceId,params.sourceEndpoint),eT=this.makeEndpoint(!1,this.target,this.targetId,params.targetEndpoint);if(eS){_ju.addToList(params.endpointsByElement,this.sourceId,eS)}
if(eT){_ju.addToList(params.endpointsByElement,this.targetId,eT)}
if(!this.scope){this.scope=this.endpoints[0].scope}
if(params.deleteEndpointsOnEmpty!=null){this.endpoints[0].setDeleteOnEmpty(params.deleteEndpointsOnEmpty);this.endpoints[1].setDeleteOnEmpty(params.deleteEndpointsOnEmpty)}
var _detachable=_jsPlumb.Defaults.ConnectionsDetachable;if(params.detachable===!1){_detachable=!1}
if(this.endpoints[0].connectionsDetachable===!1){_detachable=!1}
if(this.endpoints[1].connectionsDetachable===!1){_detachable=!1}
var _reattach=params.reattach||this.endpoints[0].reattachConnections||this.endpoints[1].reattachConnections||_jsPlumb.Defaults.ReattachConnections;this.appendToDefaultType({detachable:_detachable,reattach:_reattach,paintStyle:this.endpoints[0].connectorStyle||this.endpoints[1].connectorStyle||params.paintStyle||_jsPlumb.Defaults.PaintStyle||_jp.Defaults.PaintStyle,hoverPaintStyle:this.endpoints[0].connectorHoverStyle||this.endpoints[1].connectorHoverStyle||params.hoverPaintStyle||_jsPlumb.Defaults.HoverPaintStyle||_jp.Defaults.HoverPaintStyle});var _suspendedAt=_jsPlumb.getSuspendedAt();if(!_jsPlumb.isSuspendDrawing()){var myInfo=_jsPlumb.getCachedData(this.sourceId),myOffset=myInfo.o,myWH=myInfo.s,otherInfo=_jsPlumb.getCachedData(this.targetId),otherOffset=otherInfo.o,otherWH=otherInfo.s,initialTimestamp=_suspendedAt||jsPlumbUtil.uuid(),anchorLoc=this.endpoints[0].anchor.compute({xy:[myOffset.left,myOffset.top],wh:myWH,element:this.endpoints[0],elementId:this.endpoints[0].elementId,txy:[otherOffset.left,otherOffset.top],twh:otherWH,tElement:this.endpoints[1],timestamp:initialTimestamp,rotation:_jsPlumb.getRotation(this.endpoints[0].elementId)});this.endpoints[0].paint({anchorLoc:anchorLoc,timestamp:initialTimestamp});anchorLoc=this.endpoints[1].anchor.compute({xy:[otherOffset.left,otherOffset.top],wh:otherWH,element:this.endpoints[1],elementId:this.endpoints[1].elementId,txy:[myOffset.left,myOffset.top],twh:myWH,tElement:this.endpoints[0],timestamp:initialTimestamp,rotation:_jsPlumb.getRotation(this.endpoints[1].elementId)});this.endpoints[1].paint({anchorLoc:anchorLoc,timestamp:initialTimestamp})}
this.getTypeDescriptor=function(){return"connection"};this.getAttachedElements=function(){return this.endpoints};this.isDetachable=function(ep){return this._jsPlumb.detachable===!1?!1:ep!=null?ep.connectionsDetachable===!0:this._jsPlumb.detachable===!0};this.setDetachable=function(detachable){this._jsPlumb.detachable=detachable===!0};this.isReattach=function(){return this._jsPlumb.reattach===!0||this.endpoints[0].reattachConnections===!0||this.endpoints[1].reattachConnections===!0};this.setReattach=function(reattach){this._jsPlumb.reattach=reattach===!0};this._jsPlumb.cost=params.cost||this.endpoints[0].getConnectionCost();this._jsPlumb.directed=params.directed;if(params.directed==null){this._jsPlumb.directed=this.endpoints[0].areConnectionsDirected()}
var _p=_jp.extend({},this.endpoints[1].getParameters());_jp.extend(_p,this.endpoints[0].getParameters());_jp.extend(_p,this.getParameters());this.setParameters(_p);this.setConnector(this.endpoints[0].connector||this.endpoints[1].connector||params.connector||_jsPlumb.Defaults.Connector||_jp.Defaults.Connector,!0);var data=params.data==null||!_ju.isObject(params.data)?{}:params.data;this.getData=function(){return data};this.setData=function(d){data=d||{}};this.mergeData=function(d){data=_jp.extend(data,d)};var _types=["default",this.endpoints[0].connectionType,this.endpoints[1].connectionType,params.type].join(" ");if(/[^\s]/.test(_types)){this.addType(_types,params.data,!0)}
this.updateConnectedClass()};_ju.extend(_jp.Connection,_jp.OverlayCapableJsPlumbUIComponent,{applyType:function(t,doNotRepaint,typeMap){var _connector=null;if(t.connector!=null){_connector=this.getCachedTypeItem("connector",typeMap.connector);if(_connector==null){_connector=this.prepareConnector(t.connector,typeMap.connector);this.cacheTypeItem("connector",_connector,typeMap.connector)}
this.setPreparedConnector(_connector)}
if(t.detachable!=null){this.setDetachable(t.detachable)}
if(t.reattach!=null){this.setReattach(t.reattach)}
if(t.scope){this.scope=t.scope}
if(t.cssClass!=null&&this.canvas){this._jsPlumb.instance.addClass(this.canvas,t.cssClass)}
var _anchors=null;if(t.anchor){_anchors=this.getCachedTypeItem("anchors",typeMap.anchor);if(_anchors==null){_anchors=[this._jsPlumb.instance.makeAnchor(t.anchor),this._jsPlumb.instance.makeAnchor(t.anchor)];this.cacheTypeItem("anchors",_anchors,typeMap.anchor)}}else if(t.anchors){_anchors=this.getCachedTypeItem("anchors",typeMap.anchors);if(_anchors==null){_anchors=[this._jsPlumb.instance.makeAnchor(t.anchors[0]),this._jsPlumb.instance.makeAnchor(t.anchors[1])];this.cacheTypeItem("anchors",_anchors,typeMap.anchors)}}
if(_anchors!=null){this.endpoints[0].anchor=_anchors[0];this.endpoints[1].anchor=_anchors[1];if(this.endpoints[1].anchor.isDynamic){this._jsPlumb.instance.repaint(this.endpoints[1].elementId)}}
_jp.OverlayCapableJsPlumbUIComponent.applyType(this,t)},addClass:function(c,informEndpoints){if(informEndpoints){this.endpoints[0].addClass(c);this.endpoints[1].addClass(c);if(this.suspendedEndpoint){this.suspendedEndpoint.addClass(c)}}
if(this.connector){this.connector.addClass(c)}},removeClass:function(c,informEndpoints){if(informEndpoints){this.endpoints[0].removeClass(c);this.endpoints[1].removeClass(c);if(this.suspendedEndpoint){this.suspendedEndpoint.removeClass(c)}}
if(this.connector){this.connector.removeClass(c)}},isVisible:function(){return this._jsPlumb.visible},setVisible:function(v){this._jsPlumb.visible=v;if(this.connector){this.connector.setVisible(v)}
this.repaint()},cleanup:function(){this.updateConnectedClass(!0);this.endpoints=null;this.source=null;this.target=null;if(this.connector!=null){this.connector.cleanup(!0);this.connector.destroy(!0)}
this.connector=null},updateConnectedClass:function(remove){if(this._jsPlumb){_updateConnectedClass(this,this.source,this._jsPlumb.instance,remove);_updateConnectedClass(this,this.target,this._jsPlumb.instance,remove)}},setHover:function(state){if(this.connector&&this._jsPlumb&&!this._jsPlumb.instance.isConnectionBeingDragged()){this.connector.setHover(state);root.jsPlumb[state?"addClass":"removeClass"](this.source,this._jsPlumb.instance.hoverSourceClass);root.jsPlumb[state?"addClass":"removeClass"](this.target,this._jsPlumb.instance.hoverTargetClass)}},getUuids:function(){return[this.endpoints[0].getUuid(),this.endpoints[1].getUuid()]},getCost:function(){return this._jsPlumb?this._jsPlumb.cost:-Infinity},setCost:function(c){this._jsPlumb.cost=c},isDirected:function(){return this._jsPlumb.directed},getConnector:function(){return this.connector},prepareConnector:function(connectorSpec,typeId){var connectorArgs={_jsPlumb:this._jsPlumb.instance,cssClass:this._jsPlumb.params.cssClass,container:this._jsPlumb.params.container,"pointer-events":this._jsPlumb.params["pointer-events"]},renderMode=this._jsPlumb.instance.getRenderMode(),connector;if(_ju.isString(connectorSpec)){connector=makeConnector(this._jsPlumb.instance,renderMode,connectorSpec,connectorArgs,this)}else if(_ju.isArray(connectorSpec)){if(connectorSpec.length===1){connector=makeConnector(this._jsPlumb.instance,renderMode,connectorSpec[0],connectorArgs,this)}else{connector=makeConnector(this._jsPlumb.instance,renderMode,connectorSpec[0],_ju.merge(connectorSpec[1],connectorArgs),this)}}
if(typeId!=null){connector.typeId=typeId}
return connector},setPreparedConnector:function(connector,doNotRepaint,doNotChangeListenerComponent,typeId){if(this.connector!==connector){var previous,previousClasses="";if(this.connector!=null){previous=this.connector;previousClasses=previous.getClass();this.connector.cleanup();this.connector.destroy()}
this.connector=connector;if(typeId){this.cacheTypeItem("connector",connector,typeId)}
this.canvas=this.connector.canvas;this.bgCanvas=this.connector.bgCanvas;this.connector.reattach(this._jsPlumb.instance);this.addClass(previousClasses);if(this.canvas){this.canvas._jsPlumb=this}
if(this.bgCanvas){this.bgCanvas._jsPlumb=this}
if(previous!=null){var o=this.getOverlays();for(var i=0;i<o.length;i++){if(o[i].transfer){o[i].transfer(this.connector)}}}
if(!doNotChangeListenerComponent){this.setListenerComponent(this.connector)}
if(!doNotRepaint){this.repaint()}}},setConnector:function(connectorSpec,doNotRepaint,doNotChangeListenerComponent,typeId){var connector=this.prepareConnector(connectorSpec,typeId);this.setPreparedConnector(connector,doNotRepaint,doNotChangeListenerComponent,typeId)},paint:function(params){if(!this._jsPlumb.instance.isSuspendDrawing()&&this._jsPlumb.visible){params=params||{};var timestamp=params.timestamp,swap=!1,tId=swap?this.sourceId:this.targetId,sId=swap?this.targetId:this.sourceId,tIdx=swap?0:1,sIdx=swap?1:0;if(timestamp==null||timestamp!==this._jsPlumb.lastPaintedAt){var sourceInfo=this._jsPlumb.instance.updateOffset({elId:sId}).o,targetInfo=this._jsPlumb.instance.updateOffset({elId:tId}).o,sE=this.endpoints[sIdx],tE=this.endpoints[tIdx];var sAnchorP=sE.anchor.getCurrentLocation({xy:[sourceInfo.left,sourceInfo.top],wh:[sourceInfo.width,sourceInfo.height],element:sE,timestamp:timestamp,rotation:this._jsPlumb.instance.getRotation(this.sourceId)}),tAnchorP=tE.anchor.getCurrentLocation({xy:[targetInfo.left,targetInfo.top],wh:[targetInfo.width,targetInfo.height],element:tE,timestamp:timestamp,rotation:this._jsPlumb.instance.getRotation(this.targetId)});this.connector.resetBounds();this.connector.compute({sourcePos:sAnchorP,targetPos:tAnchorP,sourceOrientation:sE.anchor.getOrientation(sE),targetOrientation:tE.anchor.getOrientation(tE),sourceEndpoint:this.endpoints[sIdx],targetEndpoint:this.endpoints[tIdx],"stroke-width":this._jsPlumb.paintStyleInUse.strokeWidth,sourceInfo:sourceInfo,targetInfo:targetInfo});var overlayExtents={minX:Infinity,minY:Infinity,maxX:-Infinity,maxY:-Infinity};for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays.hasOwnProperty(i)){var o=this._jsPlumb.overlays[i];if(o.isVisible()){this._jsPlumb.overlayPlacements[i]=o.draw(this.connector,this._jsPlumb.paintStyleInUse,this.getAbsoluteOverlayPosition(o));overlayExtents.minX=Math.min(overlayExtents.minX,this._jsPlumb.overlayPlacements[i].minX);overlayExtents.maxX=Math.max(overlayExtents.maxX,this._jsPlumb.overlayPlacements[i].maxX);overlayExtents.minY=Math.min(overlayExtents.minY,this._jsPlumb.overlayPlacements[i].minY);overlayExtents.maxY=Math.max(overlayExtents.maxY,this._jsPlumb.overlayPlacements[i].maxY)}}}
var lineWidth=parseFloat(this._jsPlumb.paintStyleInUse.strokeWidth||1)/2,outlineWidth=parseFloat(this._jsPlumb.paintStyleInUse.strokeWidth||0),extents={xmin:Math.min(this.connector.bounds.minX-(lineWidth+outlineWidth),overlayExtents.minX),ymin:Math.min(this.connector.bounds.minY-(lineWidth+outlineWidth),overlayExtents.minY),xmax:Math.max(this.connector.bounds.maxX+(lineWidth+outlineWidth),overlayExtents.maxX),ymax:Math.max(this.connector.bounds.maxY+(lineWidth+outlineWidth),overlayExtents.maxY)};this.connector.paintExtents=extents;this.connector.paint(this._jsPlumb.paintStyleInUse,null,extents);for(var j in this._jsPlumb.overlays){if(this._jsPlumb.overlays.hasOwnProperty(j)){var p=this._jsPlumb.overlays[j];if(p.isVisible()){p.paint(this._jsPlumb.overlayPlacements[j],extents)}}}}
this._jsPlumb.lastPaintedAt=timestamp}},repaint:function(params){var p=jsPlumb.extend(params||{},{});p.elId=this.sourceId;this.paint(p)},prepareEndpoint:function(_jsPlumb,_newEndpoint,conn,existing,index,params,element,elementId,definition){var e;if(existing){conn.endpoints[index]=existing;existing.addConnection(conn)}else{if(!params.endpoints){params.endpoints=[null,null]}
var ep=definition||params.endpoints[index]||params.endpoint||_jsPlumb.Defaults.Endpoints[index]||_jp.Defaults.Endpoints[index]||_jsPlumb.Defaults.Endpoint||_jp.Defaults.Endpoint;if(!params.endpointStyles){params.endpointStyles=[null,null]}
if(!params.endpointHoverStyles){params.endpointHoverStyles=[null,null]}
var es=params.endpointStyles[index]||params.endpointStyle||_jsPlumb.Defaults.EndpointStyles[index]||_jp.Defaults.EndpointStyles[index]||_jsPlumb.Defaults.EndpointStyle||_jp.Defaults.EndpointStyle;if(es.fill==null&&params.paintStyle!=null){es.fill=params.paintStyle.stroke}
if(es.outlineStroke==null&&params.paintStyle!=null){es.outlineStroke=params.paintStyle.outlineStroke}
if(es.outlineWidth==null&&params.paintStyle!=null){es.outlineWidth=params.paintStyle.outlineWidth}
var ehs=params.endpointHoverStyles[index]||params.endpointHoverStyle||_jsPlumb.Defaults.EndpointHoverStyles[index]||_jp.Defaults.EndpointHoverStyles[index]||_jsPlumb.Defaults.EndpointHoverStyle||_jp.Defaults.EndpointHoverStyle;if(params.hoverPaintStyle!=null){if(ehs==null){ehs={}}
if(ehs.fill==null){ehs.fill=params.hoverPaintStyle.stroke}}
var a=params.anchors?params.anchors[index]:params.anchor?params.anchor:_makeAnchor(_jsPlumb.Defaults.Anchors[index],elementId,_jsPlumb)||_makeAnchor(_jp.Defaults.Anchors[index],elementId,_jsPlumb)||_makeAnchor(_jsPlumb.Defaults.Anchor,elementId,_jsPlumb)||_makeAnchor(_jp.Defaults.Anchor,elementId,_jsPlumb),u=params.uuids?params.uuids[index]:null;e=_newEndpoint({paintStyle:es,hoverPaintStyle:ehs,endpoint:ep,connections:[conn],uuid:u,anchor:a,source:element,scope:params.scope,reattach:params.reattach||_jsPlumb.Defaults.ReattachConnections,detachable:params.detachable||_jsPlumb.Defaults.ConnectionsDetachable});if(existing==null){e.setDeleteOnEmpty(!0)}
conn.endpoints[index]=e;if(params.drawEndpoints===!1){e.setVisible(!1,!0,!0)}}
return e},replaceEndpoint:function(idx,endpointDef){var current=this.endpoints[idx],elId=current.elementId,ebe=this._jsPlumb.instance.getEndpoints(elId),_idx=ebe.indexOf(current),_new=this.makeEndpoint(idx===0,current.element,elId,null,endpointDef);this.endpoints[idx]=_new;ebe.splice(_idx,1,_new);this._jsPlumb.instance.deleteObject({endpoint:current,deleteAttachedObjects:!1});this._jsPlumb.instance.fire("endpointReplaced",{previous:current,current:_new});this._jsPlumb.instance.router.sourceOrTargetChanged(this.endpoints[1].elementId,this.endpoints[1].elementId,this,this.endpoints[1].element,1)}})}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_ju=root.jsPlumbUtil,_jp=root.jsPlumb;_jp.AnchorManager=function(params){var _amEndpoints={},continuousAnchorLocations={},continuousAnchorOrientations={},connectionsByElementId={},self=this,anchorLists={},jsPlumbInstance=params.jsPlumbInstance,floatingConnections={},placeAnchorsOnLine=function(desc,elementDimensions,elementPosition,connections,horizontal,otherMultiplier,reverse,rotation){var a=[],step=elementDimensions[horizontal?0:1]/(connections.length+1);for(var i=0;i<connections.length;i++){var val=(i+1)*step,other=otherMultiplier*elementDimensions[horizontal?1:0];if(reverse){val=elementDimensions[horizontal?0:1]-val}
var dx=(horizontal?val:other),x=elementPosition.left+dx,xp=dx/elementDimensions[0],dy=(horizontal?other:val),y=elementPosition.top+dy,yp=dy/elementDimensions[1];if(rotation!==0){var rotated=jsPlumbUtil.rotatePoint([x,y],[elementPosition.centerx,elementPosition.centery],rotation);x=rotated[0];y=rotated[1]}
a.push([x,y,xp,yp,connections[i][1],connections[i][2]])}
return a},rightAndBottomSort=function(a,b){return b[0][0]-a[0][0]},leftAndTopSort=function(a,b){var p1=a[0][0]<0?-Math.PI-a[0][0]:Math.PI-a[0][0],p2=b[0][0]<0?-Math.PI-b[0][0]:Math.PI-b[0][0];return p1-p2},edgeSortFunctions={"top":leftAndTopSort,"right":rightAndBottomSort,"bottom":rightAndBottomSort,"left":leftAndTopSort},_sortHelper=function(_array,_fn){return _array.sort(_fn)},placeAnchors=function(elementId,_anchorLists){var cd=jsPlumbInstance.getCachedData(elementId),sS=cd.s,sO=cd.o,placeSomeAnchors=function(desc,elementDimensions,elementPosition,unsortedConnections,isHorizontal,otherMultiplier,orientation){if(unsortedConnections.length>0){var sc=_sortHelper(unsortedConnections,edgeSortFunctions[desc]),reverse=desc==="right"||desc==="top",rotation=jsPlumbInstance.getRotation(elementId),anchors=placeAnchorsOnLine(desc,elementDimensions,elementPosition,sc,isHorizontal,otherMultiplier,reverse,rotation);var _setAnchorLocation=function(endpoint,anchorPos){continuousAnchorLocations[endpoint.id]=[anchorPos[0],anchorPos[1],anchorPos[2],anchorPos[3]];continuousAnchorOrientations[endpoint.id]=orientation};for(var i=0;i<anchors.length;i++){var c=anchors[i][4],weAreSource=c.endpoints[0].elementId===elementId,weAreTarget=c.endpoints[1].elementId===elementId;if(weAreSource){_setAnchorLocation(c.endpoints[0],anchors[i])}
if(weAreTarget){_setAnchorLocation(c.endpoints[1],anchors[i])}}}};placeSomeAnchors("bottom",sS,sO,_anchorLists.bottom,!0,1,[0,1]);placeSomeAnchors("top",sS,sO,_anchorLists.top,!0,0,[0,-1]);placeSomeAnchors("left",sS,sO,_anchorLists.left,!1,0,[-1,0]);placeSomeAnchors("right",sS,sO,_anchorLists.right,!1,1,[1,0])};this.reset=function(){_amEndpoints={};connectionsByElementId={};anchorLists={}};this.addFloatingConnection=function(key,conn){floatingConnections[key]=conn};this.newConnection=function(conn){var sourceId=conn.sourceId,targetId=conn.targetId,ep=conn.endpoints,doRegisterTarget=!0,registerConnection=function(otherIndex,otherEndpoint,otherAnchor,elId,c){if((sourceId===targetId)&&otherAnchor.isContinuous){conn._jsPlumb.instance.removeElement(ep[1].canvas);doRegisterTarget=!1}
_ju.addToList(connectionsByElementId,elId,[c,otherEndpoint,otherAnchor.constructor===_jp.DynamicAnchor])};registerConnection(0,ep[0],ep[0].anchor,targetId,conn);if(doRegisterTarget){registerConnection(1,ep[1],ep[1].anchor,sourceId,conn)}};var removeEndpointFromAnchorLists=function(endpoint){(function(list,eId){if(list){var f=function(e){return e[4]===eId};_ju.removeWithFunction(list.top,f);_ju.removeWithFunction(list.left,f);_ju.removeWithFunction(list.bottom,f);_ju.removeWithFunction(list.right,f)}})(anchorLists[endpoint.elementId],endpoint.id)};this.connectionDetached=function(connInfo,doNotRedraw){var connection=connInfo.connection||connInfo,sourceId=connInfo.sourceId,targetId=connInfo.targetId,ep=connection.endpoints,removeConnection=function(otherIndex,otherEndpoint,otherAnchor,elId,c){_ju.removeWithFunction(connectionsByElementId[elId],function(_c){return _c[0].id===c.id})};removeConnection(1,ep[1],ep[1].anchor,sourceId,connection);removeConnection(0,ep[0],ep[0].anchor,targetId,connection);if(connection.floatingId){removeConnection(connection.floatingIndex,connection.floatingEndpoint,connection.floatingEndpoint.anchor,connection.floatingId,connection);removeEndpointFromAnchorLists(connection.floatingEndpoint)}
removeEndpointFromAnchorLists(connection.endpoints[0]);removeEndpointFromAnchorLists(connection.endpoints[1]);if(!doNotRedraw){self.redraw(connection.sourceId);if(connection.targetId!==connection.sourceId){self.redraw(connection.targetId)}}};this.addEndpoint=function(endpoint,elementId){_ju.addToList(_amEndpoints,elementId,endpoint)};this.changeId=function(oldId,newId){connectionsByElementId[newId]=connectionsByElementId[oldId];_amEndpoints[newId]=_amEndpoints[oldId];delete connectionsByElementId[oldId];delete _amEndpoints[oldId]};this.getConnectionsFor=function(elementId){return connectionsByElementId[elementId]||[]};this.getEndpointsFor=function(elementId){return _amEndpoints[elementId]||[]};this.deleteEndpoint=function(endpoint){_ju.removeWithFunction(_amEndpoints[endpoint.elementId],function(e){return e.id===endpoint.id});removeEndpointFromAnchorLists(endpoint)};this.elementRemoved=function(elementId){delete floatingConnections[elementId];delete _amEndpoints[elementId];_amEndpoints[elementId]=[]};var _updateAnchorList=function(lists,theta,order,conn,aBoolean,otherElId,idx,reverse,edgeId,elId,connsToPaint,endpointsToPaint){var exactIdx=-1,firstMatchingElIdx=-1,endpoint=conn.endpoints[idx],endpointId=endpoint.id,oIdx=[1,0][idx],values=[[theta,order],conn,aBoolean,otherElId,endpointId],listToAddTo=lists[edgeId],listToRemoveFrom=endpoint._continuousAnchorEdge?lists[endpoint._continuousAnchorEdge]:null,i,candidate;if(listToRemoveFrom){var rIdx=_ju.findWithFunction(listToRemoveFrom,function(e){return e[4]===endpointId});if(rIdx!==-1){listToRemoveFrom.splice(rIdx,1);for(i=0;i<listToRemoveFrom.length;i++){candidate=listToRemoveFrom[i][1];_ju.addWithFunction(connsToPaint,candidate,function(c){return c.id===candidate.id});_ju.addWithFunction(endpointsToPaint,listToRemoveFrom[i][1].endpoints[idx],function(e){return e.id===candidate.endpoints[idx].id});_ju.addWithFunction(endpointsToPaint,listToRemoveFrom[i][1].endpoints[oIdx],function(e){return e.id===candidate.endpoints[oIdx].id})}}}
for(i=0;i<listToAddTo.length;i++){candidate=listToAddTo[i][1];if(params.idx===1&&listToAddTo[i][3]===otherElId&&firstMatchingElIdx===-1){firstMatchingElIdx=i}
_ju.addWithFunction(connsToPaint,candidate,function(c){return c.id===candidate.id});_ju.addWithFunction(endpointsToPaint,listToAddTo[i][1].endpoints[idx],function(e){return e.id===candidate.endpoints[idx].id});_ju.addWithFunction(endpointsToPaint,listToAddTo[i][1].endpoints[oIdx],function(e){return e.id===candidate.endpoints[oIdx].id})}
if(exactIdx!==-1){listToAddTo[exactIdx]=values}else{var insertIdx=reverse?firstMatchingElIdx!==-1?firstMatchingElIdx:0:listToAddTo.length;listToAddTo.splice(insertIdx,0,values)}
endpoint._continuousAnchorEdge=edgeId};this.sourceOrTargetChanged=function(originalId,newId,connection,newElement,anchorIndex){if(anchorIndex===0){if(originalId!==newId){connection.sourceId=newId;connection.source=newElement;_ju.removeWithFunction(connectionsByElementId[originalId],function(info){return info[0].id===connection.id});var tIdx=_ju.findWithFunction(connectionsByElementId[connection.targetId],function(i){return i[0].id===connection.id});if(tIdx>-1){connectionsByElementId[connection.targetId][tIdx][0]=connection;connectionsByElementId[connection.targetId][tIdx][1]=connection.endpoints[0];connectionsByElementId[connection.targetId][tIdx][2]=connection.endpoints[0].anchor.constructor===_jp.DynamicAnchor}
_ju.addToList(connectionsByElementId,newId,[connection,connection.endpoints[1],connection.endpoints[1].anchor.constructor===_jp.DynamicAnchor]);if(connection.endpoints[1].anchor.isContinuous){if(connection.source===connection.target){connection._jsPlumb.instance.removeElement(connection.endpoints[1].canvas)}else{if(connection.endpoints[1].canvas.parentNode==null){connection._jsPlumb.instance.appendElement(connection.endpoints[1].canvas)}}}
connection.updateConnectedClass()}}else if(anchorIndex===1){var sourceElId=connection.endpoints[0].elementId;connection.target=newElement;connection.targetId=newId;var sIndex=_ju.findWithFunction(connectionsByElementId[sourceElId],function(i){return i[0].id===connection.id}),tIndex=_ju.findWithFunction(connectionsByElementId[originalId],function(i){return i[0].id===connection.id});if(sIndex!==-1){connectionsByElementId[sourceElId][sIndex][0]=connection;connectionsByElementId[sourceElId][sIndex][1]=connection.endpoints[1];connectionsByElementId[sourceElId][sIndex][2]=connection.endpoints[1].anchor.constructor===_jp.DynamicAnchor}
if(tIndex>-1){connectionsByElementId[originalId].splice(tIndex,1);_ju.addToList(connectionsByElementId,newId,[connection,connection.endpoints[0],connection.endpoints[0].anchor.constructor===_jp.DynamicAnchor])}
connection.updateConnectedClass()}};this.rehomeEndpoint=function(ep,currentId,element){var eps=_amEndpoints[currentId]||[],elementId=jsPlumbInstance.getId(element);if(elementId!==currentId){var idx=eps.indexOf(ep);if(idx>-1){var _ep=eps.splice(idx,1)[0];self.add(_ep,elementId)}}
for(var i=0;i<ep.connections.length;i++){if(ep.connections[i].sourceId===currentId){self.sourceOrTargetChanged(currentId,ep.elementId,ep.connections[i],ep.element,0)}else if(ep.connections[i].targetId===currentId){self.sourceOrTargetChanged(currentId,ep.elementId,ep.connections[i],ep.element,1)}}};this.redraw=function(elementId,ui,timestamp,offsetToUI,clearEdits,doNotRecalcEndpoint){var connectionsToPaint=[],endpointsToPaint=[],anchorsToUpdate=[];if(!jsPlumbInstance.isSuspendDrawing()){var ep=_amEndpoints[elementId]||[],endpointConnections=connectionsByElementId[elementId]||[];timestamp=timestamp||jsPlumbUtil.uuid();offsetToUI=offsetToUI||{left:0,top:0};if(ui){ui={left:ui.left+offsetToUI.left,top:ui.top+offsetToUI.top}}
var myOffset=jsPlumbInstance.updateOffset({elId:elementId,offset:ui,recalc:!1,timestamp:timestamp}),orientationCache={};for(var i=0;i<endpointConnections.length;i++){var conn=endpointConnections[i][0],sourceId=conn.sourceId,targetId=conn.targetId,sourceContinuous=conn.endpoints[0].anchor.isContinuous,targetContinuous=conn.endpoints[1].anchor.isContinuous;if(sourceContinuous||targetContinuous){var oKey=sourceId+"_"+targetId,o=orientationCache[oKey],oIdx=conn.sourceId===elementId?1:0,targetRotation=jsPlumbInstance.getRotation(targetId),sourceRotation=jsPlumbInstance.getRotation(sourceId);if(sourceContinuous&&!anchorLists[sourceId]){anchorLists[sourceId]={top:[],right:[],bottom:[],left:[]}}
if(targetContinuous&&!anchorLists[targetId]){anchorLists[targetId]={top:[],right:[],bottom:[],left:[]}}
if(elementId!==targetId){jsPlumbInstance.updateOffset({elId:targetId,timestamp:timestamp})}
if(elementId!==sourceId){jsPlumbInstance.updateOffset({elId:sourceId,timestamp:timestamp})}
var td=jsPlumbInstance.getCachedData(targetId),sd=jsPlumbInstance.getCachedData(sourceId);if(targetId===sourceId&&(sourceContinuous||targetContinuous)){_updateAnchorList(anchorLists[sourceId],-Math.PI/2,0,conn,!1,targetId,0,!1,"top",sourceId,connectionsToPaint,endpointsToPaint);_updateAnchorList(anchorLists[targetId],-Math.PI/2,0,conn,!1,sourceId,1,!1,"top",targetId,connectionsToPaint,endpointsToPaint)}else{if(!o){o=this.calculateOrientation(sourceId,targetId,sd.o,td.o,conn.endpoints[0].anchor,conn.endpoints[1].anchor,conn,sourceRotation,targetRotation);orientationCache[oKey]=o}
if(sourceContinuous){_updateAnchorList(anchorLists[sourceId],o.theta,0,conn,!1,targetId,0,!1,o.a[0],sourceId,connectionsToPaint,endpointsToPaint)}
if(targetContinuous){_updateAnchorList(anchorLists[targetId],o.theta2,-1,conn,!0,sourceId,1,!0,o.a[1],targetId,connectionsToPaint,endpointsToPaint)}}
if(sourceContinuous){_ju.addWithFunction(anchorsToUpdate,sourceId,function(a){return a===sourceId})}
if(targetContinuous){_ju.addWithFunction(anchorsToUpdate,targetId,function(a){return a===targetId})}
_ju.addWithFunction(connectionsToPaint,conn,function(c){return c.id===conn.id});if((sourceContinuous&&oIdx===0)||(targetContinuous&&oIdx===1)){_ju.addWithFunction(endpointsToPaint,conn.endpoints[oIdx],function(e){return e.id===conn.endpoints[oIdx].id})}}}
for(i=0;i<ep.length;i++){if(ep[i].connections.length===0&&ep[i].anchor.isContinuous){if(!anchorLists[elementId]){anchorLists[elementId]={top:[],right:[],bottom:[],left:[]}}
_updateAnchorList(anchorLists[elementId],-Math.PI/2,0,{endpoints:[ep[i],ep[i]],paint:function(){}},!1,elementId,0,!1,ep[i].anchor.getDefaultFace(),elementId,connectionsToPaint,endpointsToPaint);_ju.addWithFunction(anchorsToUpdate,elementId,function(a){return a===elementId})}}
for(i=0;i<anchorsToUpdate.length;i++){placeAnchors(anchorsToUpdate[i],anchorLists[anchorsToUpdate[i]])}
for(i=0;i<ep.length;i++){ep[i].paint({timestamp:timestamp,offset:myOffset,dimensions:myOffset.s,recalc:doNotRecalcEndpoint!==!0})}
for(i=0;i<endpointsToPaint.length;i++){var cd=jsPlumbInstance.getCachedData(endpointsToPaint[i].elementId);endpointsToPaint[i].paint({timestamp:null,offset:cd,dimensions:cd.s})}
for(i=0;i<endpointConnections.length;i++){var otherEndpoint=endpointConnections[i][1];if(otherEndpoint.anchor.constructor===_jp.DynamicAnchor){otherEndpoint.paint({elementWithPrecedence:elementId,timestamp:timestamp});_ju.addWithFunction(connectionsToPaint,endpointConnections[i][0],function(c){return c.id===endpointConnections[i][0].id});for(var k=0;k<otherEndpoint.connections.length;k++){if(otherEndpoint.connections[k]!==endpointConnections[i][0]){_ju.addWithFunction(connectionsToPaint,otherEndpoint.connections[k],function(c){return c.id===otherEndpoint.connections[k].id})}}}else{_ju.addWithFunction(connectionsToPaint,endpointConnections[i][0],function(c){return c.id===endpointConnections[i][0].id})}}
var fc=floatingConnections[elementId];if(fc){fc.paint({timestamp:timestamp,recalc:!1,elId:elementId})}
for(i=0;i<connectionsToPaint.length;i++){connectionsToPaint[i].paint({elId:elementId,timestamp:null,recalc:!1,clearEdits:clearEdits})}}
return{c:connectionsToPaint,e:endpointsToPaint}};var ContinuousAnchor=function(anchorParams){_ju.EventGenerator.apply(this);this.type="Continuous";this.isDynamic=!0;this.isContinuous=!0;var faces=anchorParams.faces||["top","right","bottom","left"],clockwise=!(anchorParams.clockwise===!1),availableFaces={},opposites={"top":"bottom","right":"left","left":"right","bottom":"top"},clockwiseOptions={"top":"right","right":"bottom","left":"top","bottom":"left"},antiClockwiseOptions={"top":"left","right":"top","left":"bottom","bottom":"right"},secondBest=clockwise?clockwiseOptions:antiClockwiseOptions,lastChoice=clockwise?antiClockwiseOptions:clockwiseOptions,cssClass=anchorParams.cssClass||"",_currentFace=null,_lockedFace=null,X_AXIS_FACES=["left","right"],Y_AXIS_FACES=["top","bottom"],_lockedAxis=null;for(var i=0;i<faces.length;i++){availableFaces[faces[i]]=!0}
this.getDefaultFace=function(){return faces.length===0?"top":faces[0]};this.isRelocatable=function(){return!0};this.isSnapOnRelocate=function(){return!0};this.verifyEdge=function(edge){if(availableFaces[edge]){return edge}else if(availableFaces[opposites[edge]]){return opposites[edge]}else if(availableFaces[secondBest[edge]]){return secondBest[edge]}else if(availableFaces[lastChoice[edge]]){return lastChoice[edge]}
return edge};this.isEdgeSupported=function(edge){return _lockedAxis==null?(_lockedFace==null?availableFaces[edge]===!0:_lockedFace===edge):_lockedAxis.indexOf(edge)!==-1};this.setCurrentFace=function(face,overrideLock){_currentFace=face;if(overrideLock&&_lockedFace!=null){_lockedFace=_currentFace}};this.getCurrentFace=function(){return _currentFace};this.getSupportedFaces=function(){var af=[];for(var k in availableFaces){if(availableFaces[k]){af.push(k)}}
return af};this.lock=function(){_lockedFace=_currentFace};this.unlock=function(){_lockedFace=null};this.isLocked=function(){return _lockedFace!=null};this.lockCurrentAxis=function(){if(_currentFace!=null){_lockedAxis=(_currentFace==="left"||_currentFace==="right")?X_AXIS_FACES:Y_AXIS_FACES}};this.unlockCurrentAxis=function(){_lockedAxis=null};this.compute=function(params){return continuousAnchorLocations[params.element.id]||[0,0]};this.getCurrentLocation=function(params){return continuousAnchorLocations[params.element.id]||[0,0]};this.getOrientation=function(endpoint){return continuousAnchorOrientations[endpoint.id]||[0,0]};this.getCssClass=function(){return cssClass}};jsPlumbInstance.continuousAnchorFactory={get:function(params){return new ContinuousAnchor(params)},clear:function(elementId){delete continuousAnchorLocations[elementId]}}};_jp.AnchorManager.prototype.calculateOrientation=function(sourceId,targetId,sd,td,sourceAnchor,targetAnchor,connection,sourceRotation,targetRotation){var Orientation={HORIZONTAL:"horizontal",VERTICAL:"vertical",DIAGONAL:"diagonal",IDENTITY:"identity"},axes=["left","top","right","bottom"];if(sourceId===targetId){return{orientation:Orientation.IDENTITY,a:["top","top"]}}
var theta=Math.atan2((td.centery-sd.centery),(td.centerx-sd.centerx)),theta2=Math.atan2((sd.centery-td.centery),(sd.centerx-td.centerx));var candidates=[],midpoints={};(function(types,dim){for(var i=0;i<types.length;i++){midpoints[types[i]]={"left":[dim[i][0].left,dim[i][0].centery],"right":[dim[i][0].right,dim[i][0].centery],"top":[dim[i][0].centerx,dim[i][0].top],"bottom":[dim[i][0].centerx,dim[i][0].bottom]};if(dim[i][1]!==0){for(var axis in midpoints[types[i]]){midpoints[types[i]][axis]=jsPlumbUtil.rotatePoint(midpoints[types[i]][axis],[dim[i][0].centerx,dim[i][0].centery],dim[i][1])}}}})(["source","target"],[[sd,sourceRotation],[td,targetRotation]]);for(var sf=0;sf<axes.length;sf++){for(var tf=0;tf<axes.length;tf++){candidates.push({source:axes[sf],target:axes[tf],dist:Biltong.lineLength(midpoints.source[axes[sf]],midpoints.target[axes[tf]])})}}
candidates.sort(function(a,b){return a.dist<b.dist?-1:a.dist>b.dist?1:0});var sourceEdge=candidates[0].source,targetEdge=candidates[0].target;for(var i=0;i<candidates.length;i++){if(sourceAnchor.isContinuous&&sourceAnchor.locked){sourceEdge=sourceAnchor.getCurrentFace()}else if(!sourceAnchor.isContinuous||sourceAnchor.isEdgeSupported(candidates[i].source)){sourceEdge=candidates[i].source}else{sourceEdge=null}
if(targetAnchor.isContinuous&&targetAnchor.locked){targetEdge=targetAnchor.getCurrentFace()}else if(!targetAnchor.isContinuous||targetAnchor.isEdgeSupported(candidates[i].target)){targetEdge=candidates[i].target}else{targetEdge=null}
if(sourceEdge!=null&&targetEdge!=null){break}}
if(sourceAnchor.isContinuous){sourceAnchor.setCurrentFace(sourceEdge)}
if(targetAnchor.isContinuous){targetAnchor.setCurrentFace(targetEdge)}
return{a:[sourceEdge,targetEdge],theta:theta,theta2:theta2}};_jp.Anchor=function(params){this.x=params.x||0;this.y=params.y||0;this.elementId=params.elementId;this.cssClass=params.cssClass||"";this.orientation=params.orientation||[0,0];this.lastReturnValue=null;this.offsets=params.offsets||[0,0];this.timestamp=null;this._unrotatedOrientation=[this.orientation[0],this.orientation[1]];this.relocatable=params.relocatable!==!1;this.snapOnRelocate=params.snapOnRelocate!==!1;this.locked=!1;_ju.EventGenerator.apply(this);this.compute=function(params){var xy=params.xy,wh=params.wh,timestamp=params.timestamp;if(timestamp&&timestamp===this.timestamp){return this.lastReturnValue}
var candidate=[xy[0]+(this.x*wh[0])+this.offsets[0],xy[1]+(this.y*wh[1])+this.offsets[1],this.x,this.y];var rotation=params.rotation;if(rotation!=null&&rotation!==0){var c2=jsPlumbUtil.rotatePoint(candidate,[xy[0]+(wh[0]/2),xy[1]+(wh[1]/2)],rotation);this.orientation[0]=Math.round((this._unrotatedOrientation[0]*c2[2])-(this._unrotatedOrientation[1]*c2[3]));this.orientation[1]=Math.round((this._unrotatedOrientation[1]*c2[2])+(this._unrotatedOrientation[0]*c2[3]));this.lastReturnValue=[c2[0],c2[1],this.x,this.y]}else{this.orientation[0]=this._unrotatedOrientation[0];this.orientation[1]=this._unrotatedOrientation[1];this.lastReturnValue=candidate}
this.timestamp=timestamp;return this.lastReturnValue};this.getCurrentLocation=function(params){params=params||{};return(this.lastReturnValue==null||(params.timestamp!=null&&this.timestamp!==params.timestamp))?this.compute(params):this.lastReturnValue};this.setPosition=function(x,y,ox,oy,overrideLock){if(!this.locked||overrideLock){this.x=x;this.y=y;this.orientation=[ox,oy];this.lastReturnValue=null}}};_ju.extend(_jp.Anchor,_ju.EventGenerator,{equals:function(anchor){if(!anchor){return!1}
var ao=anchor.getOrientation(),o=this.getOrientation();return this.x===anchor.x&&this.y===anchor.y&&this.offsets[0]===anchor.offsets[0]&&this.offsets[1]===anchor.offsets[1]&&o[0]===ao[0]&&o[1]===ao[1]},getOrientation:function(){return this.orientation},getCssClass:function(){return this.cssClass}});_jp.FloatingAnchor=function(params){_jp.Anchor.apply(this,arguments);var ref=params.reference,refCanvas=params.referenceCanvas,size=_jp.getSize(refCanvas),xDir=0,yDir=0,orientation=null,_lastResult=null;this.orientation=null;this.x=0;this.y=0;this.isFloating=!0;this.compute=function(params){var xy=params.xy,result=[xy[0]+(size[0]/2),xy[1]+(size[1]/2)];_lastResult=result;return result};this.getOrientation=function(_endpoint){if(orientation){return orientation}else{var o=ref.getOrientation(_endpoint);return[Math.abs(o[0])*xDir*-1,Math.abs(o[1])*yDir*-1]}};this.over=function(anchor,endpoint){orientation=anchor.getOrientation(endpoint)};this.out=function(){orientation=null};this.getCurrentLocation=function(params){return _lastResult==null?this.compute(params):_lastResult}};_ju.extend(_jp.FloatingAnchor,_jp.Anchor);var _convertAnchor=function(anchor,jsPlumbInstance,elementId){return anchor.constructor===_jp.Anchor?anchor:jsPlumbInstance.makeAnchor(anchor,elementId,jsPlumbInstance)};_jp.DynamicAnchor=function(params){_jp.Anchor.apply(this,arguments);this.isDynamic=!0;this.anchors=[];this.elementId=params.elementId;this.jsPlumbInstance=params.jsPlumbInstance;for(var i=0;i<params.anchors.length;i++){this.anchors[i]=_convertAnchor(params.anchors[i],this.jsPlumbInstance,this.elementId)}
this.getAnchors=function(){return this.anchors};var _curAnchor=this.anchors.length>0?this.anchors[0]:null,_lastAnchor=_curAnchor,self=this,_distance=function(anchor,cx,cy,xy,wh,r,tr){var ax=xy[0]+(anchor.x*wh[0]),ay=xy[1]+(anchor.y*wh[1]),acx=xy[0]+(wh[0]/2),acy=xy[1]+(wh[1]/2);if(r!=null&&r!==0){var rotated=jsPlumbUtil.rotatePoint([ax,ay],[acx,acy],r);ax=rotated[0];ay=rotated[1]}
return(Math.sqrt(Math.pow(cx-ax,2)+Math.pow(cy-ay,2))+Math.sqrt(Math.pow(acx-ax,2)+Math.pow(acy-ay,2)))},_anchorSelector=params.selector||function(xy,wh,txy,twh,r,tr,anchors){var cx=txy[0]+(twh[0]/2),cy=txy[1]+(twh[1]/2);var minIdx=-1,minDist=Infinity;for(var i=0;i<anchors.length;i++){var d=_distance(anchors[i],cx,cy,xy,wh,r,tr);if(d<minDist){minIdx=i+0;minDist=d}}
return anchors[minIdx]};this.compute=function(params){var xy=params.xy,wh=params.wh,txy=params.txy,twh=params.twh,r=params.rotation,tr=params.tRotation;this.timestamp=params.timestamp;if(this.locked||txy==null||twh==null){this.lastReturnValue=_curAnchor.compute(params);return this.lastReturnValue}else{params.timestamp=null}
_curAnchor=_anchorSelector(xy,wh,txy,twh,r,tr,this.anchors);this.x=_curAnchor.x;this.y=_curAnchor.y;if(_curAnchor!==_lastAnchor){this.fire("anchorChanged",_curAnchor)}
_lastAnchor=_curAnchor;this.lastReturnValue=_curAnchor.compute(params);return this.lastReturnValue};this.getCurrentLocation=function(params){return _curAnchor!=null?_curAnchor.getCurrentLocation(params):null};this.getOrientation=function(_endpoint){return _curAnchor!=null?_curAnchor.getOrientation(_endpoint):[0,0]};this.over=function(anchor,endpoint){if(_curAnchor!=null){_curAnchor.over(anchor,endpoint)}};this.out=function(){if(_curAnchor!=null){_curAnchor.out()}};this.setAnchor=function(a){_curAnchor=a};this.getCssClass=function(){return(_curAnchor&&_curAnchor.getCssClass())||""};this.setAnchorCoordinates=function(coords){var idx=jsPlumbUtil.findWithFunction(this.anchors,function(a){return a.x===coords[0]&&a.y===coords[1]});if(idx!==-1){this.setAnchor(this.anchors[idx]);return!0}else{return!1}}};_ju.extend(_jp.DynamicAnchor,_jp.Anchor);var _curryAnchor=function(x,y,ox,oy,type,fnInit){_jp.Anchors[type]=function(params){var a=params.jsPlumbInstance.makeAnchor([x,y,ox,oy,0,0],params.elementId,params.jsPlumbInstance);a.type=type;if(fnInit){fnInit(a,params)}
return a}};_curryAnchor(0.5,0,0,-1,"TopCenter");_curryAnchor(0.5,1,0,1,"BottomCenter");_curryAnchor(0,0.5,-1,0,"LeftMiddle");_curryAnchor(1,0.5,1,0,"RightMiddle");_curryAnchor(0.5,0,0,-1,"Top");_curryAnchor(0.5,1,0,1,"Bottom");_curryAnchor(0,0.5,-1,0,"Left");_curryAnchor(1,0.5,1,0,"Right");_curryAnchor(0.5,0.5,0,0,"Center");_curryAnchor(1,0,0,-1,"TopRight");_curryAnchor(1,1,0,1,"BottomRight");_curryAnchor(0,0,0,-1,"TopLeft");_curryAnchor(0,1,0,1,"BottomLeft");_jp.Defaults.DynamicAnchors=function(params){return params.jsPlumbInstance.makeAnchors(["TopCenter","RightMiddle","BottomCenter","LeftMiddle"],params.elementId,params.jsPlumbInstance)};_jp.Anchors.AutoDefault=function(params){var a=params.jsPlumbInstance.makeDynamicAnchor(_jp.Defaults.DynamicAnchors(params));a.type="AutoDefault";return a};var _curryContinuousAnchor=function(type,faces){_jp.Anchors[type]=function(params){var a=params.jsPlumbInstance.makeAnchor(["Continuous",{faces:faces}],params.elementId,params.jsPlumbInstance);a.type=type;return a}};_jp.Anchors.Continuous=function(params){return params.jsPlumbInstance.continuousAnchorFactory.get(params)};_curryContinuousAnchor("ContinuousLeft",["left"]);_curryContinuousAnchor("ContinuousTop",["top"]);_curryContinuousAnchor("ContinuousBottom",["bottom"]);_curryContinuousAnchor("ContinuousRight",["right"]);_curryAnchor(0,0,0,0,"Assign",function(anchor,params){var pf=params.position||"Fixed";anchor.positionFinder=pf.constructor===String?params.jsPlumbInstance.AnchorPositionFinders[pf]:pf;anchor.constructorParams=params});root.jsPlumbInstance.prototype.AnchorPositionFinders={"Fixed":function(dp,ep,es){return[(dp.left-ep.left)/es[0],(dp.top-ep.top)/es[1]]},"Grid":function(dp,ep,es,params){var dx=dp.left-ep.left,dy=dp.top-ep.top,gx=es[0]/(params.grid[0]),gy=es[1]/(params.grid[1]),mx=Math.floor(dx/gx),my=Math.floor(dy/gy);return[((mx*gx)+(gx/2))/es[0],((my*gy)+(gy/2))/es[1]]}};_jp.Anchors.Perimeter=function(params){params=params||{};var anchorCount=params.anchorCount||60,shape=params.shape;if(!shape){throw new Error("no shape supplied to Perimeter Anchor type")}
var _circle=function(){var r=0.5,step=Math.PI*2/anchorCount,current=0,a=[];for(var i=0;i<anchorCount;i++){var x=r+(r*Math.sin(current)),y=r+(r*Math.cos(current));a.push([x,y,0,0]);current+=step}
return a},_path=function(segments){var anchorsPerFace=anchorCount/segments.length,a=[],_computeFace=function(x1,y1,x2,y2,fractionalLength,ox,oy){anchorsPerFace=anchorCount*fractionalLength;var dx=(x2-x1)/anchorsPerFace,dy=(y2-y1)/anchorsPerFace;for(var i=0;i<anchorsPerFace;i++){a.push([x1+(dx*i),y1+(dy*i),ox==null?0:ox,oy==null?0:oy])}};for(var i=0;i<segments.length;i++){_computeFace.apply(null,segments[i])}
return a},_shape=function(faces){var s=[];for(var i=0;i<faces.length;i++){s.push([faces[i][0],faces[i][1],faces[i][2],faces[i][3],1/faces.length,faces[i][4],faces[i][5]])}
return _path(s)},_rectangle=function(){return _shape([[0,0,1,0,0,-1],[1,0,1,1,1,0],[1,1,0,1,0,1],[0,1,0,0,-1,0]])};var _shapes={"Circle":_circle,"Ellipse":_circle,"Diamond":function(){return _shape([[0.5,0,1,0.5],[1,0.5,0.5,1],[0.5,1,0,0.5],[0,0.5,0.5,0]])},"Rectangle":_rectangle,"Square":_rectangle,"Triangle":function(){return _shape([[0.5,0,1,1],[1,1,0,1],[0,1,0.5,0]])},"Path":function(params){var points=params.points,p=[],tl=0;for(var i=0;i<points.length-1;i++){var l=Math.sqrt(Math.pow(points[i][2]-points[i][0])+Math.pow(points[i][3]-points[i][1]));tl+=l;p.push([points[i][0],points[i][1],points[i+1][0],points[i+1][1],l])}
for(var j=0;j<p.length;j++){p[j][4]=p[j][4]/tl}
return _path(p)}},_rotate=function(points,amountInDegrees){var o=[],theta=amountInDegrees/180*Math.PI;for(var i=0;i<points.length;i++){var _x=points[i][0]-0.5,_y=points[i][1]-0.5;o.push([0.5+((_x*Math.cos(theta))-(_y*Math.sin(theta))),0.5+((_x*Math.sin(theta))+(_y*Math.cos(theta))),points[i][2],points[i][3]])}
return o};if(!_shapes[shape]){throw new Error("Shape ["+shape+"] is unknown by Perimeter Anchor type")}
var da=_shapes[shape](params);if(params.rotation){da=_rotate(da,params.rotation)}
var a=params.jsPlumbInstance.makeDynamicAnchor(da);a.type="Perimeter";return a}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_ju=root.jsPlumbUtil,_jp=root.jsPlumb;_jp.DefaultRouter=function(jsPlumbInstance){this.jsPlumbInstance=jsPlumbInstance;this.anchorManager=new _jp.AnchorManager({jsPlumbInstance:jsPlumbInstance});this.sourceOrTargetChanged=function(originalId,newId,connection,newElement,anchorIndex){this.anchorManager.sourceOrTargetChanged(originalId,newId,connection,newElement,anchorIndex)};this.reset=function(){this.anchorManager.reset()};this.changeId=function(oldId,newId){this.anchorManager.changeId(oldId,newId)};this.elementRemoved=function(elementId){this.anchorManager.elementRemoved(elementId)};this.newConnection=function(conn){this.anchorManager.newConnection(conn)};this.connectionDetached=function(connInfo,doNotRedraw){this.anchorManager.connectionDetached(connInfo,doNotRedraw)};this.redraw=function(elementId,ui,timestamp,offsetToUI,clearEdits,doNotRecalcEndpoint){return this.anchorManager.redraw(elementId,ui,timestamp,offsetToUI,clearEdits,doNotRecalcEndpoint)};this.deleteEndpoint=function(endpoint){this.anchorManager.deleteEndpoint(endpoint)};this.rehomeEndpoint=function(ep,currentId,element){this.anchorManager.rehomeEndpoint(ep,currentId,element)};this.addEndpoint=function(endpoint,elementId){this.anchorManager.addEndpoint(endpoint,elementId)}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil,_jg=root.Biltong;_jp.Segments={AbstractSegment:function(params){this.params=params;this.findClosestPointOnPath=function(x,y){return{d:Infinity,x:null,y:null,l:null}};this.getBounds=function(){return{minX:Math.min(params.x1,params.x2),minY:Math.min(params.y1,params.y2),maxX:Math.max(params.x1,params.x2),maxY:Math.max(params.y1,params.y2)}};this.lineIntersection=function(x1,y1,x2,y2){return[]};this.boxIntersection=function(x,y,w,h){var a=[];a.push.apply(a,this.lineIntersection(x,y,x+w,y));a.push.apply(a,this.lineIntersection(x+w,y,x+w,y+h));a.push.apply(a,this.lineIntersection(x+w,y+h,x,y+h));a.push.apply(a,this.lineIntersection(x,y+h,x,y));return a};this.boundingBoxIntersection=function(box){return this.boxIntersection(box.x,box.y,box.w,box.y)}},Straight:function(params){var _super=_jp.Segments.AbstractSegment.apply(this,arguments),length,m,m2,x1,x2,y1,y2,_recalc=function(){length=Math.sqrt(Math.pow(x2-x1,2)+Math.pow(y2-y1,2));m=_jg.gradient({x:x1,y:y1},{x:x2,y:y2});m2=-1/m};this.type="Straight";this.getLength=function(){return length};this.getGradient=function(){return m};this.getCoordinates=function(){return{x1:x1,y1:y1,x2:x2,y2:y2}};this.setCoordinates=function(coords){x1=coords.x1;y1=coords.y1;x2=coords.x2;y2=coords.y2;_recalc()};this.setCoordinates({x1:params.x1,y1:params.y1,x2:params.x2,y2:params.y2});this.getBounds=function(){return{minX:Math.min(x1,x2),minY:Math.min(y1,y2),maxX:Math.max(x1,x2),maxY:Math.max(y1,y2)}};this.pointOnPath=function(location,absolute){if(location===0&&!absolute){return{x:x1,y:y1}}else if(location===1&&!absolute){return{x:x2,y:y2}}else{var l=absolute?location>0?location:length+location:location*length;return _jg.pointOnLine({x:x1,y:y1},{x:x2,y:y2},l)}};this.gradientAtPoint=function(_){return m};this.pointAlongPathFrom=function(location,distance,absolute){var p=this.pointOnPath(location,absolute),farAwayPoint=distance<=0?{x:x1,y:y1}:{x:x2,y:y2};if(distance<=0&&Math.abs(distance)>1){distance*=-1}
return _jg.pointOnLine(p,farAwayPoint,distance)};var within=function(a,b,c){return c>=Math.min(a,b)&&c<=Math.max(a,b)};var closest=function(a,b,c){return Math.abs(c-a)<Math.abs(c-b)?a:b};this.findClosestPointOnPath=function(x,y){var out={d:Infinity,x:null,y:null,l:null,x1:x1,x2:x2,y1:y1,y2:y2};if(m===0){out.y=y1;out.x=within(x1,x2,x)?x:closest(x1,x2,x)}else if(m===Infinity||m===-Infinity){out.x=x1;out.y=within(y1,y2,y)?y:closest(y1,y2,y)}else{var b=y1-(m*x1),b2=y-(m2*x),_x1=(b2-b)/(m-m2),_y1=(m*_x1)+b;out.x=within(x1,x2,_x1)?_x1:closest(x1,x2,_x1);out.y=within(y1,y2,_y1)?_y1:closest(y1,y2,_y1)}
var fractionInSegment=_jg.lineLength([out.x,out.y],[x1,y1]);out.d=_jg.lineLength([x,y],[out.x,out.y]);out.l=fractionInSegment/length;return out};var _pointLiesBetween=function(q,p1,p2){return(p2>p1)?(p1<=q&&q<=p2):(p1>=q&&q>=p2)},_plb=_pointLiesBetween;this.lineIntersection=function(_x1,_y1,_x2,_y2){var m2=Math.abs(_jg.gradient({x:_x1,y:_y1},{x:_x2,y:_y2})),m1=Math.abs(m),b=m1===Infinity?x1:y1-(m1*x1),out=[],b2=m2===Infinity?_x1:_y1-(m2*_x1);if(m2!==m1){if(m2===Infinity&&m1===0){if(_plb(_x1,x1,x2)&&_plb(y1,_y1,_y2)){out=[_x1,y1]}}else if(m2===0&&m1===Infinity){if(_plb(_y1,y1,y2)&&_plb(x1,_x1,_x2)){out=[x1,_y1]}}else{var X,Y;if(m2===Infinity){X=_x1;if(_plb(X,x1,x2)){Y=(m1*_x1)+b;if(_plb(Y,_y1,_y2)){out=[X,Y]}}}else if(m2===0){Y=_y1;if(_plb(Y,y1,y2)){X=(_y1-b)/m1;if(_plb(X,_x1,_x2)){out=[X,Y]}}}else{X=(b2-b)/(m1-m2);Y=(m1*X)+b;if(_plb(X,x1,x2)&&_plb(Y,y1,y2)){out=[X,Y]}}}}
return out};this.boxIntersection=function(x,y,w,h){var a=[];a.push.apply(a,this.lineIntersection(x,y,x+w,y));a.push.apply(a,this.lineIntersection(x+w,y,x+w,y+h));a.push.apply(a,this.lineIntersection(x+w,y+h,x,y+h));a.push.apply(a,this.lineIntersection(x,y+h,x,y));return a};this.boundingBoxIntersection=function(box){return this.boxIntersection(box.x,box.y,box.w,box.h)}},Arc:function(params){var _super=_jp.Segments.AbstractSegment.apply(this,arguments),_calcAngle=function(_x,_y){return _jg.theta([params.cx,params.cy],[_x,_y])},_calcAngleForLocation=function(segment,location){if(segment.anticlockwise){var sa=segment.startAngle<segment.endAngle?segment.startAngle+TWO_PI:segment.startAngle,s=Math.abs(sa-segment.endAngle);return sa-(s*location)}else{var ea=segment.endAngle<segment.startAngle?segment.endAngle+TWO_PI:segment.endAngle,ss=Math.abs(ea-segment.startAngle);return segment.startAngle+(ss*location)}},TWO_PI=2*Math.PI;this.radius=params.r;this.anticlockwise=params.ac;this.type="Arc";if(params.startAngle&&params.endAngle){this.startAngle=params.startAngle;this.endAngle=params.endAngle;this.x1=params.cx+(this.radius*Math.cos(params.startAngle));this.y1=params.cy+(this.radius*Math.sin(params.startAngle));this.x2=params.cx+(this.radius*Math.cos(params.endAngle));this.y2=params.cy+(this.radius*Math.sin(params.endAngle))}else{this.startAngle=_calcAngle(params.x1,params.y1);this.endAngle=_calcAngle(params.x2,params.y2);this.x1=params.x1;this.y1=params.y1;this.x2=params.x2;this.y2=params.y2}
if(this.endAngle<0){this.endAngle+=TWO_PI}
if(this.startAngle<0){this.startAngle+=TWO_PI}
var ea=this.endAngle<this.startAngle?this.endAngle+TWO_PI:this.endAngle;this.sweep=Math.abs(ea-this.startAngle);if(this.anticlockwise){this.sweep=TWO_PI-this.sweep}
var circumference=2*Math.PI*this.radius,frac=this.sweep/TWO_PI,length=circumference*frac;this.getLength=function(){return length};this.getBounds=function(){return{minX:params.cx-params.r,maxX:params.cx+params.r,minY:params.cy-params.r,maxY:params.cy+params.r}};var VERY_SMALL_VALUE=0.0000000001,gentleRound=function(n){var f=Math.floor(n),r=Math.ceil(n);if(n-f<VERY_SMALL_VALUE){return f}else if(r-n<VERY_SMALL_VALUE){return r}
return n};this.pointOnPath=function(location,absolute){if(location===0){return{x:this.x1,y:this.y1,theta:this.startAngle}}else if(location===1){return{x:this.x2,y:this.y2,theta:this.endAngle}}
if(absolute){location=location/length}
var angle=_calcAngleForLocation(this,location),_x=params.cx+(params.r*Math.cos(angle)),_y=params.cy+(params.r*Math.sin(angle));return{x:gentleRound(_x),y:gentleRound(_y),theta:angle}};this.gradientAtPoint=function(location,absolute){var p=this.pointOnPath(location,absolute);var m=_jg.normal([params.cx,params.cy],[p.x,p.y]);if(!this.anticlockwise&&(m===Infinity||m===-Infinity)){m*=-1}
return m};this.pointAlongPathFrom=function(location,distance,absolute){var p=this.pointOnPath(location,absolute),arcSpan=distance/circumference*2*Math.PI,dir=this.anticlockwise?-1:1,startAngle=p.theta+(dir*arcSpan),startX=params.cx+(this.radius*Math.cos(startAngle)),startY=params.cy+(this.radius*Math.sin(startAngle));return{x:startX,y:startY}}},Bezier:function(params){this.curve=[{x:params.x1,y:params.y1},{x:params.cp1x,y:params.cp1y},{x:params.cp2x,y:params.cp2y},{x:params.x2,y:params.y2}];var _isPoint=function(c){return c[0].x===c[1].x&&c[0].y===c[1].y};var _dist=function(p1,p2){return Math.sqrt(Math.pow(p1.x-p2.x,2)+Math.pow(p1.y-p2.y,2))};var _compute=function(loc){var EMPTY_POINT={x:0,y:0};if(loc===0){return this.curve[0]}
var degree=this.curve.length-1;if(loc===1){return this.curve[degree]}
var o=this.curve;var s=1-loc;if(degree===0){return this.curve[0]}
if(degree===1){return{x:s*o[0].x+loc*o[1].x,y:s*o[0].y+loc*o[1].y}}
if(degree<4){var l=s*s,h=loc*loc,u=0,m,g,f;if(degree===2){o=[o[0],o[1],o[2],EMPTY_POINT];m=l;g=2*(s*loc);f=h}else if(degree===3){m=l*s;g=3*(l*loc);f=3*(s*h);u=loc*h}
return{x:m*o[0].x+g*o[1].x+f*o[2].x+u*o[3].x,y:m*o[0].y+g*o[1].y+f*o[2].y+u*o[3].y}}else{return EMPTY_POINT}}.bind(this);var _getLUT=function(steps){var out=[];steps--;for(var n=0;n<=steps;n++){out.push(_compute(n/steps))}
return out};var _computeLength=function(){if(_isPoint(this.curve)){this.length=0}
var steps=16;var lut=_getLUT(steps);this.length=0;for(var i=0;i<steps-1;i++){var a=lut[i],b=lut[i+1];this.length+=_dist(a,b)}}.bind(this);var _super=_jp.Segments.AbstractSegment.apply(this,arguments);this.bounds={minX:Math.min(params.x1,params.x2,params.cp1x,params.cp2x),minY:Math.min(params.y1,params.y2,params.cp1y,params.cp2y),maxX:Math.max(params.x1,params.x2,params.cp1x,params.cp2x),maxY:Math.max(params.y1,params.y2,params.cp1y,params.cp2y)};this.type="Bezier";_computeLength();var _translateLocation=function(_curve,location,absolute){if(absolute){location=root.jsBezier.locationAlongCurveFrom(_curve,location>0?0:1,location)}
return location};this.pointOnPath=function(location,absolute){location=_translateLocation(this.curve,location,absolute);return root.jsBezier.pointOnCurve(this.curve,location)};this.gradientAtPoint=function(location,absolute){location=_translateLocation(this.curve,location,absolute);return root.jsBezier.gradientAtPoint(this.curve,location)};this.pointAlongPathFrom=function(location,distance,absolute){location=_translateLocation(this.curve,location,absolute);return root.jsBezier.pointAlongCurveFrom(this.curve,location,distance)};this.getLength=function(){return this.length};this.getBounds=function(){return this.bounds};this.findClosestPointOnPath=function(x,y){var p=root.jsBezier.nearestPointOnCurve({x:x,y:y},this.curve);return{d:Math.sqrt(Math.pow(p.point.x-x,2)+Math.pow(p.point.y-y,2)),x:p.point.x,y:p.point.y,l:1-p.location,s:this}};this.lineIntersection=function(x1,y1,x2,y2){return root.jsBezier.lineIntersection(x1,y1,x2,y2,this.curve)}}};_jp.SegmentRenderer={getPath:function(segment,isFirstSegment){return({"Straight":function(isFirstSegment){var d=segment.getCoordinates();return(isFirstSegment?"M "+d.x1+" "+d.y1+" ":"")+"L "+d.x2+" "+d.y2},"Bezier":function(isFirstSegment){var d=segment.params;return(isFirstSegment?"M "+d.x2+" "+d.y2+" ":"")+"C "+d.cp2x+" "+d.cp2y+" "+d.cp1x+" "+d.cp1y+" "+d.x1+" "+d.y1},"Arc":function(isFirstSegment){var d=segment.params,laf=segment.sweep>Math.PI?1:0,sf=segment.anticlockwise?0:1;return(isFirstSegment?"M"+segment.x1+" "+segment.y1+" ":"")+"A "+segment.radius+" "+d.r+" 0 "+laf+","+sf+" "+segment.x2+" "+segment.y2}})[segment.type](isFirstSegment)}};var AbstractComponent=function(){this.resetBounds=function(){this.bounds={minX:Infinity,minY:Infinity,maxX:-Infinity,maxY:-Infinity}};this.resetBounds()};_jp.Connectors.AbstractConnector=function(params){AbstractComponent.apply(this,arguments);var segments=[],totalLength=0,segmentProportions=[],segmentProportionalLengths=[],stub=params.stub||0,sourceStub=_ju.isArray(stub)?stub[0]:stub,targetStub=_ju.isArray(stub)?stub[1]:stub,gap=params.gap||0,sourceGap=_ju.isArray(gap)?gap[0]:gap,targetGap=_ju.isArray(gap)?gap[1]:gap,userProvidedSegments=null,paintInfo=null;this.getPathData=function(){var p="";for(var i=0;i<segments.length;i++){p+=_jp.SegmentRenderer.getPath(segments[i],i===0);p+=" "}
return p};this.findSegmentForPoint=function(x,y){var out={d:Infinity,s:null,x:null,y:null,l:null};for(var i=0;i<segments.length;i++){var _s=segments[i].findClosestPointOnPath(x,y);if(_s.d<out.d){out.d=_s.d;out.l=_s.l;out.x=_s.x;out.y=_s.y;out.s=segments[i];out.x1=_s.x1;out.x2=_s.x2;out.y1=_s.y1;out.y2=_s.y2;out.index=i;out.connectorLocation=segmentProportions[i][0]+(_s.l*(segmentProportions[i][1]-segmentProportions[i][0]))}}
return out};this.lineIntersection=function(x1,y1,x2,y2){var out=[];for(var i=0;i<segments.length;i++){out.push.apply(out,segments[i].lineIntersection(x1,y1,x2,y2))}
return out};this.boxIntersection=function(x,y,w,h){var out=[];for(var i=0;i<segments.length;i++){out.push.apply(out,segments[i].boxIntersection(x,y,w,h))}
return out};this.boundingBoxIntersection=function(box){var out=[];for(var i=0;i<segments.length;i++){out.push.apply(out,segments[i].boundingBoxIntersection(box))}
return out};var _updateSegmentProportions=function(){var curLoc=0;for(var i=0;i<segments.length;i++){var sl=segments[i].getLength();segmentProportionalLengths[i]=sl/totalLength;segmentProportions[i]=[curLoc,(curLoc+=(sl/totalLength))]}},_findSegmentForLocation=function(location,absolute){var idx,i,inSegmentProportion;if(absolute){location=location>0?location/totalLength:(totalLength+location)/totalLength}
if(location===1){idx=segments.length-1;inSegmentProportion=1}else if(location===0){inSegmentProportion=0;idx=0}else{if(location>=0.5){idx=0;inSegmentProportion=0;for(i=segmentProportions.length-1;i>-1;i--){if(segmentProportions[i][1]>=location&&segmentProportions[i][0]<=location){idx=i;inSegmentProportion=(location-segmentProportions[i][0])/segmentProportionalLengths[i];break}}}else{idx=segmentProportions.length-1;inSegmentProportion=1;for(i=0;i<segmentProportions.length;i++){if(segmentProportions[i][1]>=location){idx=i;inSegmentProportion=(location-segmentProportions[i][0])/segmentProportionalLengths[i];break}}}}
return{segment:segments[idx],proportion:inSegmentProportion,index:idx}},_addSegment=function(conn,type,params){if(params.x1===params.x2&&params.y1===params.y2){return}
var s=new _jp.Segments[type](params);segments.push(s);totalLength+=s.getLength();conn.updateBounds(s)},_clearSegments=function(){totalLength=segments.length=segmentProportions.length=segmentProportionalLengths.length=0};this.setSegments=function(_segs){userProvidedSegments=[];totalLength=0;for(var i=0;i<_segs.length;i++){userProvidedSegments.push(_segs[i]);totalLength+=_segs[i].getLength()}};this.getLength=function(){return totalLength};var _prepareCompute=function(params){this.strokeWidth=params.strokeWidth;var segment=_jg.quadrant(params.sourcePos,params.targetPos),swapX=params.targetPos[0]<params.sourcePos[0],swapY=params.targetPos[1]<params.sourcePos[1],lw=params.strokeWidth||1,so=params.sourceEndpoint.anchor.getOrientation(params.sourceEndpoint),to=params.targetEndpoint.anchor.getOrientation(params.targetEndpoint),x=swapX?params.targetPos[0]:params.sourcePos[0],y=swapY?params.targetPos[1]:params.sourcePos[1],w=Math.abs(params.targetPos[0]-params.sourcePos[0]),h=Math.abs(params.targetPos[1]-params.sourcePos[1]);if(so[0]===0&&so[1]===0||to[0]===0&&to[1]===0){var index=w>h?0:1,oIndex=[1,0][index];so=[];to=[];so[index]=params.sourcePos[index]>params.targetPos[index]?-1:1;to[index]=params.sourcePos[index]>params.targetPos[index]?1:-1;so[oIndex]=0;to[oIndex]=0}
var sx=swapX?w+(sourceGap*so[0]):sourceGap*so[0],sy=swapY?h+(sourceGap*so[1]):sourceGap*so[1],tx=swapX?targetGap*to[0]:w+(targetGap*to[0]),ty=swapY?targetGap*to[1]:h+(targetGap*to[1]),oProduct=((so[0]*to[0])+(so[1]*to[1]));var result={sx:sx,sy:sy,tx:tx,ty:ty,lw:lw,xSpan:Math.abs(tx-sx),ySpan:Math.abs(ty-sy),mx:(sx+tx)/2,my:(sy+ty)/2,so:so,to:to,x:x,y:y,w:w,h:h,segment:segment,startStubX:sx+(so[0]*sourceStub),startStubY:sy+(so[1]*sourceStub),endStubX:tx+(to[0]*targetStub),endStubY:ty+(to[1]*targetStub),isXGreaterThanStubTimes2:Math.abs(sx-tx)>(sourceStub+targetStub),isYGreaterThanStubTimes2:Math.abs(sy-ty)>(sourceStub+targetStub),opposite:oProduct===-1,perpendicular:oProduct===0,orthogonal:oProduct===1,sourceAxis:so[0]===0?"y":"x",points:[x,y,w,h,sx,sy,tx,ty],stubs:[sourceStub,targetStub]};result.anchorOrientation=result.opposite?"opposite":result.orthogonal?"orthogonal":"perpendicular";return result};this.getSegments=function(){return segments};this.updateBounds=function(segment){var segBounds=segment.getBounds();this.bounds.minX=Math.min(this.bounds.minX,segBounds.minX);this.bounds.maxX=Math.max(this.bounds.maxX,segBounds.maxX);this.bounds.minY=Math.min(this.bounds.minY,segBounds.minY);this.bounds.maxY=Math.max(this.bounds.maxY,segBounds.maxY)};var dumpSegmentsToConsole=function(){console.log("SEGMENTS:");for(var i=0;i<segments.length;i++){console.log(segments[i].type,segments[i].getLength(),segmentProportions[i])}};this.pointOnPath=function(location,absolute){var seg=_findSegmentForLocation(location,absolute);return seg.segment&&seg.segment.pointOnPath(seg.proportion,!1)||[0,0]};this.gradientAtPoint=function(location,absolute){var seg=_findSegmentForLocation(location,absolute);return seg.segment&&seg.segment.gradientAtPoint(seg.proportion,!1)||0};this.pointAlongPathFrom=function(location,distance,absolute){var seg=_findSegmentForLocation(location,absolute);return seg.segment&&seg.segment.pointAlongPathFrom(seg.proportion,distance,!1)||[0,0]};this.compute=function(params){paintInfo=_prepareCompute.call(this,params);_clearSegments();this._compute(paintInfo,params);this.x=paintInfo.points[0];this.y=paintInfo.points[1];this.w=paintInfo.points[2];this.h=paintInfo.points[3];this.segment=paintInfo.segment;_updateSegmentProportions()};return{addSegment:_addSegment,prepareCompute:_prepareCompute,sourceStub:sourceStub,targetStub:targetStub,maxStub:Math.max(sourceStub,targetStub),sourceGap:sourceGap,targetGap:targetGap,maxGap:Math.max(sourceGap,targetGap)}};_ju.extend(_jp.Connectors.AbstractConnector,AbstractComponent);_jp.Endpoints.AbstractEndpoint=function(params){AbstractComponent.apply(this,arguments);var compute=this.compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){var out=this._compute.apply(this,arguments);this.x=out[0];this.y=out[1];this.w=out[2];this.h=out[3];this.bounds.minX=this.x;this.bounds.minY=this.y;this.bounds.maxX=this.x+this.w;this.bounds.maxY=this.y+this.h;return out};return{compute:compute,cssClass:params.cssClass}};_ju.extend(_jp.Endpoints.AbstractEndpoint,AbstractComponent);_jp.Endpoints.Dot=function(params){this.type="Dot";var _super=_jp.Endpoints.AbstractEndpoint.apply(this,arguments);params=params||{};this.radius=params.radius||10;this.defaultOffset=0.5*this.radius;this.defaultInnerRadius=this.radius/3;this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){this.radius=endpointStyle.radius||this.radius;var x=anchorPoint[0]-this.radius,y=anchorPoint[1]-this.radius,w=this.radius*2,h=this.radius*2;if(endpointStyle.stroke){var lw=endpointStyle.strokeWidth||1;x-=lw;y-=lw;w+=(lw*2);h+=(lw*2)}
return[x,y,w,h,this.radius]}};_ju.extend(_jp.Endpoints.Dot,_jp.Endpoints.AbstractEndpoint);_jp.Endpoints.Rectangle=function(params){this.type="Rectangle";var _super=_jp.Endpoints.AbstractEndpoint.apply(this,arguments);params=params||{};this.width=params.width||20;this.height=params.height||20;this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){var width=endpointStyle.width||this.width,height=endpointStyle.height||this.height,x=anchorPoint[0]-(width/2),y=anchorPoint[1]-(height/2);return[x,y,width,height]}};_ju.extend(_jp.Endpoints.Rectangle,_jp.Endpoints.AbstractEndpoint);var DOMElementEndpoint=function(params){_jp.jsPlumbUIComponent.apply(this,arguments);this._jsPlumb.displayElements=[]};_ju.extend(DOMElementEndpoint,_jp.jsPlumbUIComponent,{getDisplayElements:function(){return this._jsPlumb.displayElements},appendDisplayElement:function(el){this._jsPlumb.displayElements.push(el)}});_jp.Endpoints.Image=function(params){this.type="Image";DOMElementEndpoint.apply(this,arguments);_jp.Endpoints.AbstractEndpoint.apply(this,arguments);var _onload=params.onload,src=params.src||params.url,clazz=params.cssClass?" "+params.cssClass:"";this._jsPlumb.img=new Image();this._jsPlumb.ready=!1;this._jsPlumb.initialized=!1;this._jsPlumb.deleted=!1;this._jsPlumb.widthToUse=params.width;this._jsPlumb.heightToUse=params.height;this._jsPlumb.endpoint=params.endpoint;this._jsPlumb.img.onload=function(){if(this._jsPlumb!=null){this._jsPlumb.ready=!0;this._jsPlumb.widthToUse=this._jsPlumb.widthToUse||this._jsPlumb.img.width;this._jsPlumb.heightToUse=this._jsPlumb.heightToUse||this._jsPlumb.img.height;if(_onload){_onload(this)}}}.bind(this);this._jsPlumb.endpoint.setImage=function(_img,onload){var s=_img.constructor===String?_img:_img.src;_onload=onload;this._jsPlumb.img.src=s;if(this.canvas!=null){this.canvas.setAttribute("src",this._jsPlumb.img.src)}}.bind(this);this._jsPlumb.endpoint.setImage(src,_onload);this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){this.anchorPoint=anchorPoint;if(this._jsPlumb.ready){return[anchorPoint[0]-this._jsPlumb.widthToUse/2,anchorPoint[1]-this._jsPlumb.heightToUse/2,this._jsPlumb.widthToUse,this._jsPlumb.heightToUse]}else{return[0,0,0,0]}};this.canvas=_jp.createElement("img",{position:"absolute",margin:0,padding:0,outline:0},this._jsPlumb.instance.endpointClass+clazz);if(this._jsPlumb.widthToUse){this.canvas.setAttribute("width",this._jsPlumb.widthToUse)}
if(this._jsPlumb.heightToUse){this.canvas.setAttribute("height",this._jsPlumb.heightToUse)}
this._jsPlumb.instance.appendElement(this.canvas);this.actuallyPaint=function(d,style,anchor){if(!this._jsPlumb.deleted){if(!this._jsPlumb.initialized){this.canvas.setAttribute("src",this._jsPlumb.img.src);this.appendDisplayElement(this.canvas);this._jsPlumb.initialized=!0}
var x=this.anchorPoint[0]-(this._jsPlumb.widthToUse/2),y=this.anchorPoint[1]-(this._jsPlumb.heightToUse/2);_ju.sizeElement(this.canvas,x,y,this._jsPlumb.widthToUse,this._jsPlumb.heightToUse)}};this.paint=function(style,anchor){if(this._jsPlumb!=null){if(this._jsPlumb.ready){this.actuallyPaint(style,anchor)}else{root.setTimeout(function(){this.paint(style,anchor)}.bind(this),200)}}}};_ju.extend(_jp.Endpoints.Image,[DOMElementEndpoint,_jp.Endpoints.AbstractEndpoint],{cleanup:function(force){if(force){this._jsPlumb.deleted=!0;if(this.canvas){this.canvas.parentNode.removeChild(this.canvas)}
this.canvas=null}}});_jp.Endpoints.Blank=function(params){var _super=_jp.Endpoints.AbstractEndpoint.apply(this,arguments);this.type="Blank";DOMElementEndpoint.apply(this,arguments);this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){return[anchorPoint[0],anchorPoint[1],10,0]};var clazz=params.cssClass?" "+params.cssClass:"";this.canvas=_jp.createElement("div",{display:"block",width:"1px",height:"1px",background:"transparent",position:"absolute"},this._jsPlumb.instance.endpointClass+clazz);this._jsPlumb.instance.appendElement(this.canvas);this.paint=function(style,anchor){_ju.sizeElement(this.canvas,this.x,this.y,this.w,this.h)}};_ju.extend(_jp.Endpoints.Blank,[_jp.Endpoints.AbstractEndpoint,DOMElementEndpoint],{cleanup:function(){if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}}});_jp.Endpoints.Triangle=function(params){this.type="Triangle";_jp.Endpoints.AbstractEndpoint.apply(this,arguments);var self=this;params=params||{};params.width=params.width||55;params.height=params.height||55;this.width=params.width;this.height=params.height;this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){var width=endpointStyle.width||self.width,height=endpointStyle.height||self.height,x=anchorPoint[0]-(width/2),y=anchorPoint[1]-(height/2);return[x,y,width,height]}};var AbstractOverlay=_jp.Overlays.AbstractOverlay=function(params){this.visible=!0;this.isAppendedAtTopLevel=!0;this.component=params.component;this.loc=params.location==null?0.5:params.location;this.endpointLoc=params.endpointLocation==null?[0.5,0.5]:params.endpointLocation;this.visible=params.visible!==!1};AbstractOverlay.prototype={cleanup:function(force){if(force){this.component=null;this.canvas=null;this.endpointLoc=null}},reattach:function(instance,component){},setVisible:function(val){this.visible=val;this.component.repaint()},isVisible:function(){return this.visible},hide:function(){this.setVisible(!1)},show:function(){this.setVisible(!0)},incrementLocation:function(amount){this.loc+=amount;this.component.repaint()},setLocation:function(l){this.loc=l;this.component.repaint()},getLocation:function(){return this.loc},updateFrom:function(){}};_jp.Overlays.Arrow=function(params){this.type="Arrow";AbstractOverlay.apply(this,arguments);this.isAppendedAtTopLevel=!1;params=params||{};var self=this;this.length=params.length||20;this.width=params.width||20;this.id=params.id;this.direction=(params.direction||1)<0?-1:1;var paintStyle=params.paintStyle||{"stroke-width":1},foldback=params.foldback||0.623;this.computeMaxSize=function(){return self.width*1.5};this.elementCreated=function(p,component){this.path=p;if(params.events){for(var i in params.events){_jp.on(p,i,params.events[i])}}};this.draw=function(component,currentConnectionPaintStyle){var hxy,mid,txy,tail,cxy;if(component.pointAlongPathFrom){if(_ju.isString(this.loc)||this.loc>1||this.loc<0){var l=parseInt(this.loc,10),fromLoc=this.loc<0?1:0;hxy=component.pointAlongPathFrom(fromLoc,l,!1);mid=component.pointAlongPathFrom(fromLoc,l-(this.direction*this.length/2),!1);txy=_jg.pointOnLine(hxy,mid,this.length)}else if(this.loc===1){hxy=component.pointOnPath(this.loc);mid=component.pointAlongPathFrom(this.loc,-(this.length));txy=_jg.pointOnLine(hxy,mid,this.length);if(this.direction===-1){var _=txy;txy=hxy;hxy=_}}else if(this.loc===0){txy=component.pointOnPath(this.loc);mid=component.pointAlongPathFrom(this.loc,this.length);hxy=_jg.pointOnLine(txy,mid,this.length);if(this.direction===-1){var __=txy;txy=hxy;hxy=__}}else{hxy=component.pointAlongPathFrom(this.loc,this.direction*this.length/2);mid=component.pointOnPath(this.loc);txy=_jg.pointOnLine(hxy,mid,this.length)}
tail=_jg.perpendicularLineTo(hxy,txy,this.width);cxy=_jg.pointOnLine(hxy,txy,foldback*this.length);var d={hxy:hxy,tail:tail,cxy:cxy},stroke=paintStyle.stroke||currentConnectionPaintStyle.stroke,fill=paintStyle.fill||currentConnectionPaintStyle.stroke,lineWidth=paintStyle.strokeWidth||currentConnectionPaintStyle.strokeWidth;return{component:component,d:d,"stroke-width":lineWidth,stroke:stroke,fill:fill,minX:Math.min(hxy.x,tail[0].x,tail[1].x),maxX:Math.max(hxy.x,tail[0].x,tail[1].x),minY:Math.min(hxy.y,tail[0].y,tail[1].y),maxY:Math.max(hxy.y,tail[0].y,tail[1].y)}}else{return{component:component,minX:0,maxX:0,minY:0,maxY:0}}}};_ju.extend(_jp.Overlays.Arrow,AbstractOverlay,{updateFrom:function(d){this.length=d.length||this.length;this.width=d.width||this.width;this.direction=d.direction!=null?d.direction:this.direction;this.foldback=d.foldback||this.foldback},cleanup:function(){if(this.path&&this.path.parentNode){this.path.parentNode.removeChild(this.path)}}});_jp.Overlays.PlainArrow=function(params){params=params||{};var p=_jp.extend(params,{foldback:1});_jp.Overlays.Arrow.call(this,p);this.type="PlainArrow"};_ju.extend(_jp.Overlays.PlainArrow,_jp.Overlays.Arrow);_jp.Overlays.Diamond=function(params){params=params||{};var l=params.length||40,p=_jp.extend(params,{length:l/2,foldback:2});_jp.Overlays.Arrow.call(this,p);this.type="Diamond"};_ju.extend(_jp.Overlays.Diamond,_jp.Overlays.Arrow);var _getDimensions=function(component,forceRefresh){if(component._jsPlumb.cachedDimensions==null||forceRefresh){component._jsPlumb.cachedDimensions=component.getDimensions()}
return component._jsPlumb.cachedDimensions};var AbstractDOMOverlay=function(params){_jp.jsPlumbUIComponent.apply(this,arguments);AbstractOverlay.apply(this,arguments);var _f=this.fire;this.fire=function(){_f.apply(this,arguments);if(this.component){this.component.fire.apply(this.component,arguments)}};this.detached=!1;this.id=params.id;this._jsPlumb.div=null;this._jsPlumb.initialised=!1;this._jsPlumb.component=params.component;this._jsPlumb.cachedDimensions=null;this._jsPlumb.create=params.create;this._jsPlumb.initiallyInvisible=params.visible===!1;this.getElement=function(){if(this._jsPlumb.div==null){var div=this._jsPlumb.div=_jp.getElement(this._jsPlumb.create(this._jsPlumb.component));div.style.position="absolute";jsPlumb.addClass(div,this._jsPlumb.instance.overlayClass+" "+(this.cssClass?this.cssClass:params.cssClass?params.cssClass:""));this._jsPlumb.instance.appendElement(div);this._jsPlumb.instance.getId(div);this.canvas=div;var ts="translate(-50%, -50%)";div.style.webkitTransform=ts;div.style.mozTransform=ts;div.style.msTransform=ts;div.style.oTransform=ts;div.style.transform=ts;div._jsPlumb=this;if(params.visible===!1){div.style.display="none"}}
return this._jsPlumb.div};this.draw=function(component,currentConnectionPaintStyle,absolutePosition){var td=_getDimensions(this);if(td!=null&&td.length===2){var cxy={x:0,y:0};if(absolutePosition){cxy={x:absolutePosition[0],y:absolutePosition[1]}}else if(component.pointOnPath){var loc=this.loc,absolute=!1;if(_ju.isString(this.loc)||this.loc<0||this.loc>1){loc=parseInt(this.loc,10);absolute=!0}
cxy=component.pointOnPath(loc,absolute)}else{var locToUse=this.loc.constructor===Array?this.loc:this.endpointLoc;cxy={x:locToUse[0]*component.w,y:locToUse[1]*component.h}}
var minx=cxy.x-(td[0]/2),miny=cxy.y-(td[1]/2);return{component:component,d:{minx:minx,miny:miny,td:td,cxy:cxy},minX:minx,maxX:minx+td[0],minY:miny,maxY:miny+td[1]}}else{return{minX:0,maxX:0,minY:0,maxY:0}}}};_ju.extend(AbstractDOMOverlay,[_jp.jsPlumbUIComponent,AbstractOverlay],{getDimensions:function(){return[1,1]},setVisible:function(state){if(this._jsPlumb.div){this._jsPlumb.div.style.display=state?"block":"none";if(state&&this._jsPlumb.initiallyInvisible){_getDimensions(this,!0);this.component.repaint();this._jsPlumb.initiallyInvisible=!1}}},clearCachedDimensions:function(){this._jsPlumb.cachedDimensions=null},cleanup:function(force){if(force){if(this._jsPlumb.div!=null){this._jsPlumb.div._jsPlumb=null;this._jsPlumb.instance.removeElement(this._jsPlumb.div)}}else{if(this._jsPlumb&&this._jsPlumb.div&&this._jsPlumb.div.parentNode){this._jsPlumb.div.parentNode.removeChild(this._jsPlumb.div)}
this.detached=!0}},reattach:function(instance,component){if(this._jsPlumb.div!=null){instance.getContainer().appendChild(this._jsPlumb.div)}
this.detached=!1},computeMaxSize:function(){var td=_getDimensions(this);return Math.max(td[0],td[1])},paint:function(p,containerExtents){if(!this._jsPlumb.initialised){this.getElement();p.component.appendDisplayElement(this._jsPlumb.div);this._jsPlumb.initialised=!0;if(this.detached){this._jsPlumb.div.parentNode.removeChild(this._jsPlumb.div)}}
this._jsPlumb.div.style.left=(p.component.x+p.d.minx)+"px";this._jsPlumb.div.style.top=(p.component.y+p.d.miny)+"px"}});_jp.Overlays.Custom=function(params){this.type="Custom";AbstractDOMOverlay.apply(this,arguments)};_ju.extend(_jp.Overlays.Custom,AbstractDOMOverlay);_jp.Overlays.GuideLines=function(){var self=this;self.length=50;self.strokeWidth=5;this.type="GuideLines";AbstractOverlay.apply(this,arguments);_jp.jsPlumbUIComponent.apply(this,arguments);this.draw=function(connector,currentConnectionPaintStyle){var head=connector.pointAlongPathFrom(self.loc,self.length/2),mid=connector.pointOnPath(self.loc),tail=_jg.pointOnLine(head,mid,self.length),tailLine=_jg.perpendicularLineTo(head,tail,40),headLine=_jg.perpendicularLineTo(tail,head,20);return{connector:connector,head:head,tail:tail,headLine:headLine,tailLine:tailLine,minX:Math.min(head.x,tail.x,headLine[0].x,headLine[1].x),minY:Math.min(head.y,tail.y,headLine[0].y,headLine[1].y),maxX:Math.max(head.x,tail.x,headLine[0].x,headLine[1].x),maxY:Math.max(head.y,tail.y,headLine[0].y,headLine[1].y)}}};_jp.Overlays.Label=function(params){this.labelStyle=params.labelStyle;var labelWidth=null,labelHeight=null,labelText=null,labelPadding=null;this.cssClass=this.labelStyle!=null?this.labelStyle.cssClass:null;var p=_jp.extend({create:function(){return _jp.createElement("div")}},params);_jp.Overlays.Custom.call(this,p);this.type="Label";this.label=params.label||"";this.labelText=null;if(this.labelStyle){var el=this.getElement();this.labelStyle.font=this.labelStyle.font||"12px sans-serif";el.style.font=this.labelStyle.font;el.style.color=this.labelStyle.color||"black";if(this.labelStyle.fill){el.style.background=this.labelStyle.fill}
if(this.labelStyle.borderWidth>0){var dStyle=this.labelStyle.borderStyle?this.labelStyle.borderStyle:"black";el.style.border=this.labelStyle.borderWidth+"px solid "+dStyle}
if(this.labelStyle.padding){el.style.padding=this.labelStyle.padding}}};_ju.extend(_jp.Overlays.Label,_jp.Overlays.Custom,{cleanup:function(force){if(force){this.div=null;this.label=null;this.labelText=null;this.cssClass=null;this.labelStyle=null}},getLabel:function(){return this.label},setLabel:function(l){this.label=l;this.labelText=null;this.clearCachedDimensions();this.update();this.component.repaint()},getDimensions:function(){this.update();return AbstractDOMOverlay.prototype.getDimensions.apply(this,arguments)},update:function(){if(typeof this.label==="function"){var lt=this.label(this);this.getElement().innerHTML=lt.replace(/\r\n/g,"<br/>")}else{if(this.labelText==null){this.labelText=this.label;this.getElement().innerHTML=this.labelText.replace(/\r\n/g,"<br/>")}}},updateFrom:function(d){if(d.label!=null){this.setLabel(d.label)}}})}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_ju=root.jsPlumbUtil,_jpi=root.jsPlumbInstance;var GROUP_COLLAPSED_CLASS="jtk-group-collapsed";var GROUP_EXPANDED_CLASS="jtk-group-expanded";var GROUP_CONTAINER_SELECTOR="[jtk-group-content]";var ELEMENT_DRAGGABLE_EVENT="elementDraggable";var STOP="stop";var REVERT="revert";var GROUP_MANAGER="_groupManager";var GROUP="_jsPlumbGroup";var GROUP_DRAG_SCOPE="_jsPlumbGroupDrag";var EVT_CHILD_ADDED="group:addMember";var EVT_CHILD_REMOVED="group:removeMember";var EVT_GROUP_ADDED="group:add";var EVT_GROUP_REMOVED="group:remove";var EVT_EXPAND="group:expand";var EVT_COLLAPSE="group:collapse";var EVT_GROUP_DRAG_STOP="groupDragStop";var EVT_CONNECTION_MOVED="connectionMoved";var EVT_INTERNAL_CONNECTION_DETACHED="internal.connectionDetached";var CMD_REMOVE_ALL="removeAll";var CMD_ORPHAN_ALL="orphanAll";var CMD_SHOW="show";var CMD_HIDE="hide";var GroupManager=function(_jsPlumb){var _managedGroups={},_connectionSourceMap={},_connectionTargetMap={},self=this;function isDescendant(el,parentEl){var c=_jsPlumb.getContainer();var abort=!1,g=null,child=null;while(!abort){if(el==null||el===c){return!1}else{if(el===parentEl){return!0}else{el=el.parentNode}}}}
_jsPlumb.bind("connection",function(p){var sourceGroup=_jsPlumb.getGroupFor(p.source);var targetGroup=_jsPlumb.getGroupFor(p.target);if(sourceGroup!=null&&targetGroup!=null&&sourceGroup===targetGroup){_connectionSourceMap[p.connection.id]=sourceGroup;_connectionTargetMap[p.connection.id]=sourceGroup}else{if(sourceGroup!=null){_ju.suggest(sourceGroup.connections.source,p.connection);_connectionSourceMap[p.connection.id]=sourceGroup}
if(targetGroup!=null){_ju.suggest(targetGroup.connections.target,p.connection);_connectionTargetMap[p.connection.id]=targetGroup}}});function _cleanupDetachedConnection(conn){delete conn.proxies;var group=_connectionSourceMap[conn.id],f;if(group!=null){f=function(c){return c.id===conn.id};_ju.removeWithFunction(group.connections.source,f);_ju.removeWithFunction(group.connections.target,f);delete _connectionSourceMap[conn.id]}
group=_connectionTargetMap[conn.id];if(group!=null){f=function(c){return c.id===conn.id};_ju.removeWithFunction(group.connections.source,f);_ju.removeWithFunction(group.connections.target,f);delete _connectionTargetMap[conn.id]}}
_jsPlumb.bind(EVT_INTERNAL_CONNECTION_DETACHED,function(p){_cleanupDetachedConnection(p.connection)});_jsPlumb.bind(EVT_CONNECTION_MOVED,function(p){var connMap=p.index===0?_connectionSourceMap:_connectionTargetMap;var group=connMap[p.connection.id];if(group){var list=group.connections[p.index===0?"source":"target"];var idx=list.indexOf(p.connection);if(idx!==-1){list.splice(idx,1)}}});this.addGroup=function(group){_jsPlumb.addClass(group.getEl(),GROUP_EXPANDED_CLASS);_managedGroups[group.id]=group;group.manager=this;_updateConnectionsForGroup(group);_jsPlumb.fire(EVT_GROUP_ADDED,{group:group})};this.addToGroup=function(group,el,doNotFireEvent){group=this.getGroup(group);if(group){var groupEl=group.getEl();if(el._isJsPlumbGroup){return}
var currentGroup=el._jsPlumbGroup;if(currentGroup!==group){_jsPlumb.removeFromDragSelection(el);var elpos=_jsPlumb.getOffset(el,!0);var cpos=group.collapsed?_jsPlumb.getOffset(groupEl,!0):_jsPlumb.getOffset(group.getDragArea(),!0);if(currentGroup!=null){currentGroup.remove(el,!1,doNotFireEvent,!1,group);self.updateConnectionsForGroup(currentGroup)}
group.add(el,doNotFireEvent);var handleDroppedConnections=function(list,index){var oidx=index===0?1:0;list.each(function(c){c.setVisible(!1);if(c.endpoints[oidx].element._jsPlumbGroup===group){c.endpoints[oidx].setVisible(!1);_expandConnection(c,oidx,group)}else{c.endpoints[index].setVisible(!1);_collapseConnection(c,index,group)}})};if(group.collapsed){handleDroppedConnections(_jsPlumb.select({source:el}),0);handleDroppedConnections(_jsPlumb.select({target:el}),1)}
var elId=_jsPlumb.getId(el);_jsPlumb.dragManager.setParent(el,elId,groupEl,_jsPlumb.getId(groupEl),elpos);var newPosition={left:elpos.left-cpos.left,top:elpos.top-cpos.top};_jsPlumb.setPosition(el,newPosition);_jsPlumb.dragManager.revalidateParent(el,elId,elpos);self.updateConnectionsForGroup(group);_jsPlumb.revalidate(elId);if(!doNotFireEvent){var p={group:group,el:el,pos:newPosition};if(currentGroup){p.sourceGroup=currentGroup}
_jsPlumb.fire(EVT_CHILD_ADDED,p)}}}};this.removeFromGroup=function(group,el,doNotFireEvent){group=this.getGroup(group);if(group){if(group.collapsed){var _expandSet=function(conns,index){for(var i=0;i<conns.length;i++){var c=conns[i];if(c.proxies){for(var j=0;j<c.proxies.length;j++){if(c.proxies[j]!=null){var proxiedElement=c.proxies[j].originalEp.element;if(proxiedElement===el||isDescendant(proxiedElement,el)){_expandConnection(c,index,group)}}}}}};_expandSet(group.connections.source.slice(),0);_expandSet(group.connections.target.slice(),1)}
group.remove(el,null,doNotFireEvent)}};this.getGroup=function(groupId){var group=groupId;if(_ju.isString(groupId)){group=_managedGroups[groupId];if(group==null){throw new TypeError("No such group ["+groupId+"]")}}
return group};this.getGroups=function(){var o=[];for(var g in _managedGroups){o.push(_managedGroups[g])}
return o};this.removeGroup=function(group,deleteMembers,manipulateDOM,doNotFireEvent){group=this.getGroup(group);this.expandGroup(group,!0);var newPositions=group[deleteMembers?CMD_REMOVE_ALL:CMD_ORPHAN_ALL](manipulateDOM,doNotFireEvent);_jsPlumb.remove(group.getEl());delete _managedGroups[group.id];delete _jsPlumb._groups[group.id];_jsPlumb.fire(EVT_GROUP_REMOVED,{group:group});return newPositions};this.removeAllGroups=function(deleteMembers,manipulateDOM,doNotFireEvent){for(var g in _managedGroups){this.removeGroup(_managedGroups[g],deleteMembers,manipulateDOM,doNotFireEvent)}};function _setVisible(group,state){var m=group.getEl().querySelectorAll(".jtk-managed");for(var i=0;i<m.length;i++){_jsPlumb[state?CMD_SHOW:CMD_HIDE](m[i],!0)}}
var _collapseConnection=function(c,index,group){var otherEl=c.endpoints[index===0?1:0].element;if(otherEl[GROUP]&&(!otherEl[GROUP].shouldProxy()&&otherEl[GROUP].collapsed)){return}
var groupEl=group.getEl(),groupElId=_jsPlumb.getId(groupEl);_jsPlumb.proxyConnection(c,index,groupEl,groupElId,function(c,index){return group.getEndpoint(c,index)},function(c,index){return group.getAnchor(c,index)})};this.collapseGroup=function(group){group=this.getGroup(group);if(group==null||group.collapsed){return}
var groupEl=group.getEl();_setVisible(group,!1);if(group.shouldProxy()){var _collapseSet=function(conns,index){for(var i=0;i<conns.length;i++){var c=conns[i];_collapseConnection(c,index,group)}};_collapseSet(group.connections.source,0);_collapseSet(group.connections.target,1)}
group.collapsed=!0;_jsPlumb.removeClass(groupEl,GROUP_EXPANDED_CLASS);_jsPlumb.addClass(groupEl,GROUP_COLLAPSED_CLASS);_jsPlumb.revalidate(groupEl);_jsPlumb.fire(EVT_COLLAPSE,{group:group})};var _expandConnection=function(c,index,group){_jsPlumb.unproxyConnection(c,index,_jsPlumb.getId(group.getEl()))};this.expandGroup=function(group,doNotFireEvent){group=this.getGroup(group);if(group==null||!group.collapsed){return}
var groupEl=group.getEl();_setVisible(group,!0);if(group.shouldProxy()){var _expandSet=function(conns,index){for(var i=0;i<conns.length;i++){var c=conns[i];_expandConnection(c,index,group)}};_expandSet(group.connections.source,0);_expandSet(group.connections.target,1)}
group.collapsed=!1;_jsPlumb.addClass(groupEl,GROUP_EXPANDED_CLASS);_jsPlumb.removeClass(groupEl,GROUP_COLLAPSED_CLASS);_jsPlumb.revalidate(groupEl);this.repaintGroup(group);if(!doNotFireEvent){_jsPlumb.fire(EVT_EXPAND,{group:group})}};this.repaintGroup=function(group){group=this.getGroup(group);var m=group.getMembers();for(var i=0;i<m.length;i++){_jsPlumb.revalidate(m[i])}};function _updateConnectionsForGroup(group){var members=group.getMembers().slice();var childMembers=[];for(var i=0;i<members.length;i++){Array.prototype.push.apply(childMembers,members[i].querySelectorAll(".jtk-managed"))}
Array.prototype.push.apply(members,childMembers);var c1=_jsPlumb.getConnections({source:members,scope:"*"},!0);var c2=_jsPlumb.getConnections({target:members,scope:"*"},!0);var processed={};group.connections.source.length=0;group.connections.target.length=0;var oneSet=function(c){for(var i=0;i<c.length;i++){if(processed[c[i].id]){continue}
processed[c[i].id]=!0;var gs=_jsPlumb.getGroupFor(c[i].source),gt=_jsPlumb.getGroupFor(c[i].target);if(gs===group){if(gt!==group){group.connections.source.push(c[i])}
_connectionSourceMap[c[i].id]=group}else if(gt===group){group.connections.target.push(c[i]);_connectionTargetMap[c[i].id]=group}}};oneSet(c1);oneSet(c2)}
this.updateConnectionsForGroup=_updateConnectionsForGroup;this.refreshAllGroups=function(){for(var g in _managedGroups){_updateConnectionsForGroup(_managedGroups[g]);_jsPlumb.dragManager.updateOffsets(_jsPlumb.getId(_managedGroups[g].getEl()))}}};var Group=function(_jsPlumb,params){var self=this;var el=params.el;this.getEl=function(){return el};this.id=params.id||_ju.uuid();el._isJsPlumbGroup=!0;var getDragArea=this.getDragArea=function(){var da=_jsPlumb.getSelector(el,GROUP_CONTAINER_SELECTOR);return da&&da.length>0?da[0]:el};var ghost=params.ghost===!0;var constrain=ghost||(params.constrain===!0);var revert=params.revert!==!1;var orphan=params.orphan===!0;var prune=params.prune===!0;var dropOverride=params.dropOverride===!0;var proxied=params.proxied!==!1;var elements=[];this.connections={source:[],target:[],internal:[]};this.getAnchor=function(conn,endpointIndex){return params.anchor||"Continuous"};this.getEndpoint=function(conn,endpointIndex){return params.endpoint||["Dot",{radius:10}]};this.collapsed=!1;if(params.draggable!==!1){var opts={drag:function(){for(var i=0;i<elements.length;i++){_jsPlumb.draw(elements[i])}},stop:function(params){_jsPlumb.fire(EVT_GROUP_DRAG_STOP,jsPlumb.extend(params,{group:self}))},scope:GROUP_DRAG_SCOPE};if(params.dragOptions){root.jsPlumb.extend(opts,params.dragOptions)}
_jsPlumb.draggable(params.el,opts)}
if(params.droppable!==!1){_jsPlumb.droppable(params.el,{drop:function(p){var el=p.drag.el;if(el._isJsPlumbGroup){return}
var currentGroup=el._jsPlumbGroup;if(currentGroup!==self){if(currentGroup!=null){if(currentGroup.overrideDrop(el,self)){return}}
_jsPlumb.getGroupManager().addToGroup(self,el,!1)}}})}
var _each=function(_el,fn){var els=_el.nodeType==null?_el:[_el];for(var i=0;i<els.length;i++){fn(els[i])}};this.overrideDrop=function(_el,targetGroup){return dropOverride&&(revert||prune||orphan)};this.add=function(_el,doNotFireEvent){var dragArea=getDragArea();_each(_el,function(__el){if(__el._jsPlumbGroup!=null){if(__el._jsPlumbGroup===self){return}else{__el._jsPlumbGroup.remove(__el,!0,doNotFireEvent,!1)}}
__el._jsPlumbGroup=self;elements.push(__el);if(_jsPlumb.isAlreadyDraggable(__el)){_bindDragHandlers(__el)}
if(__el.parentNode!==dragArea){dragArea.appendChild(__el)}});_jsPlumb.getGroupManager().updateConnectionsForGroup(self)};this.remove=function(el,manipulateDOM,doNotFireEvent,doNotUpdateConnections,targetGroup){_each(el,function(__el){if(__el._jsPlumbGroup===self){delete __el._jsPlumbGroup;_ju.removeWithFunction(elements,function(e){return e===__el});if(manipulateDOM){try{self.getDragArea().removeChild(__el)}catch(e){jsPlumbUtil.log("Could not remove element from Group "+e)}}
_unbindDragHandlers(__el);if(!doNotFireEvent){var p={group:self,el:__el};if(targetGroup){p.targetGroup=targetGroup}
_jsPlumb.fire(EVT_CHILD_REMOVED,p)}}});if(!doNotUpdateConnections){_jsPlumb.getGroupManager().updateConnectionsForGroup(self)}};this.removeAll=function(manipulateDOM,doNotFireEvent){for(var i=0,l=elements.length;i<l;i++){var el=elements[0];self.remove(el,manipulateDOM,doNotFireEvent,!0);_jsPlumb.remove(el,!0)}
elements.length=0;_jsPlumb.getGroupManager().updateConnectionsForGroup(self)};this.orphanAll=function(){var orphanedPositions={};for(var i=0;i<elements.length;i++){var newPosition=_orphan(elements[i]);orphanedPositions[newPosition[0]]=newPosition[1]}
elements.length=0;return orphanedPositions};this.getMembers=function(){return elements};el[GROUP]=this;_jsPlumb.bind(ELEMENT_DRAGGABLE_EVENT,function(dragParams){if(dragParams.el._jsPlumbGroup===this){_bindDragHandlers(dragParams.el)}}.bind(this));function _findParent(_el){return _el.offsetParent}
function _isInsideParent(_el,pos){var p=_findParent(_el),s=_jsPlumb.getSize(p),ss=_jsPlumb.getSize(_el),leftEdge=pos[0],rightEdge=leftEdge+ss[0],topEdge=pos[1],bottomEdge=topEdge+ss[1];return rightEdge>0&&leftEdge<s[0]&&bottomEdge>0&&topEdge<s[1]}
function _orphan(_el){var id=_jsPlumb.getId(_el);var pos=_jsPlumb.getOffset(_el);_el.parentNode.removeChild(_el);_jsPlumb.getContainer().appendChild(_el);_jsPlumb.setPosition(_el,pos);_unbindDragHandlers(_el);_jsPlumb.dragManager.clearParent(_el,id);return[id,pos]}
function _pruneOrOrphan(p){var out=[];function _one(el,left,top){var orphanedPosition=null;if(!_isInsideParent(el,[left,top])){var group=el._jsPlumbGroup;if(prune){_jsPlumb.remove(el)}else{orphanedPosition=_orphan(el)}
group.remove(el)}
return orphanedPosition}
for(var i=0;i<p.selection.length;i++){out.push(_one(p.selection[i][0],p.selection[i][1].left,p.selection[i][1].top))}
return out.length===1?out[0]:out}
function _revalidate(_el){var id=_jsPlumb.getId(_el);_jsPlumb.revalidate(_el);_jsPlumb.dragManager.revalidateParent(_el,id)}
function _unbindDragHandlers(_el){if(!_el._katavorioDrag){return}
if(prune||orphan){_el._katavorioDrag.off(STOP,_pruneOrOrphan)}
if(!prune&&!orphan&&revert){_el._katavorioDrag.off(REVERT,_revalidate);_el._katavorioDrag.setRevert(null)}}
function _bindDragHandlers(_el){if(!_el._katavorioDrag){return}
if(prune||orphan){_el._katavorioDrag.on(STOP,_pruneOrOrphan)}
if(constrain){_el._katavorioDrag.setConstrain(!0)}
if(ghost){_el._katavorioDrag.setUseGhostProxy(!0)}
if(!prune&&!orphan&&revert){_el._katavorioDrag.on(REVERT,_revalidate);_el._katavorioDrag.setRevert(function(__el,pos){return!_isInsideParent(__el,pos)})}}
this.shouldProxy=function(){return proxied};_jsPlumb.getGroupManager().addGroup(this)};_jpi.prototype.addGroup=function(params){var j=this;j._groups=j._groups||{};if(j._groups[params.id]!=null){throw new TypeError("cannot create Group ["+params.id+"]; a Group with that ID exists")}
if(params.el[GROUP]!=null){throw new TypeError("cannot create Group ["+params.id+"]; the given element is already a Group")}
var group=new Group(j,params);j._groups[group.id]=group;if(params.collapsed){this.collapseGroup(group)}
return group};_jpi.prototype.addToGroup=function(group,el,doNotFireEvent){var _one=function(_el){var id=this.getId(_el);this.manage(id,_el);this.getGroupManager().addToGroup(group,_el,doNotFireEvent)}.bind(this);if(Array.isArray(el)){for(var i=0;i<el.length;i++){_one(el[i])}}else{_one(el)}};_jpi.prototype.removeFromGroup=function(group,el,doNotFireEvent){this.getGroupManager().removeFromGroup(group,el,doNotFireEvent);this.getContainer().appendChild(el)};_jpi.prototype.removeGroup=function(group,deleteMembers,manipulateDOM,doNotFireEvent){return this.getGroupManager().removeGroup(group,deleteMembers,manipulateDOM,doNotFireEvent)};_jpi.prototype.removeAllGroups=function(deleteMembers,manipulateDOM,doNotFireEvent){this.getGroupManager().removeAllGroups(deleteMembers,manipulateDOM,doNotFireEvent)};_jpi.prototype.getGroup=function(groupId){return this.getGroupManager().getGroup(groupId)};_jpi.prototype.getGroups=function(){return this.getGroupManager().getGroups()};_jpi.prototype.expandGroup=function(group){this.getGroupManager().expandGroup(group)};_jpi.prototype.collapseGroup=function(groupId){this.getGroupManager().collapseGroup(groupId)};_jpi.prototype.repaintGroup=function(group){this.getGroupManager().repaintGroup(group)};_jpi.prototype.toggleGroup=function(group){group=this.getGroupManager().getGroup(group);if(group!=null){this.getGroupManager()[group.collapsed?"expandGroup":"collapseGroup"](group)}};_jpi.prototype.getGroupManager=function(){var mgr=this[GROUP_MANAGER];if(mgr==null){mgr=this[GROUP_MANAGER]=new GroupManager(this)}
return mgr};_jpi.prototype.removeGroupManager=function(){delete this[GROUP_MANAGER]};_jpi.prototype.getGroupFor=function(el){el=this.getElement(el);if(el){var c=this.getContainer();var abort=!1,g=null,child=null;while(!abort){if(el==null||el===c){abort=!0}else{if(el[GROUP]){g=el[GROUP];child=el;abort=!0}else{el=el.parentNode}}}
return g}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var STRAIGHT="Straight";var ARC="Arc";var Flowchart=function(params){this.type="Flowchart";params=params||{};params.stub=params.stub==null?30:params.stub;var segments,_super=_jp.Connectors.AbstractConnector.apply(this,arguments),midpoint=params.midpoint==null||isNaN(params.midpoint)?0.5:params.midpoint,alwaysRespectStubs=params.alwaysRespectStubs===!0,lastx=null,lasty=null,lastOrientation,cornerRadius=params.cornerRadius!=null?params.cornerRadius:0,loopbackRadius=params.loopbackRadius||25,isLoopbackCurrently=!1,sgn=function(n){return n<0?-1:n===0?0:1},segmentDirections=function(segment){return[sgn(segment[2]-segment[0]),sgn(segment[3]-segment[1])]},addSegment=function(segments,x,y,paintInfo){if(lastx===x&&lasty===y){return}
var lx=lastx==null?paintInfo.sx:lastx,ly=lasty==null?paintInfo.sy:lasty,o=lx===x?"v":"h";lastx=x;lasty=y;segments.push([lx,ly,x,y,o])},segLength=function(s){return Math.sqrt(Math.pow(s[0]-s[2],2)+Math.pow(s[1]-s[3],2))},_cloneArray=function(a){var _a=[];_a.push.apply(_a,a);return _a},writeSegments=function(conn,segments,paintInfo){var current=null,next,currentDirection,nextDirection;for(var i=0;i<segments.length-1;i++){current=current||_cloneArray(segments[i]);next=_cloneArray(segments[i+1]);currentDirection=segmentDirections(current);nextDirection=segmentDirections(next);if(cornerRadius>0&&current[4]!==next[4]){var minSegLength=Math.min(segLength(current),segLength(next));var radiusToUse=Math.min(cornerRadius,minSegLength/2);current[2]-=currentDirection[0]*radiusToUse;current[3]-=currentDirection[1]*radiusToUse;next[0]+=nextDirection[0]*radiusToUse;next[1]+=nextDirection[1]*radiusToUse;var ac=(currentDirection[1]===nextDirection[0]&&nextDirection[0]===1)||((currentDirection[1]===nextDirection[0]&&nextDirection[0]===0)&&currentDirection[0]!==nextDirection[1])||(currentDirection[1]===nextDirection[0]&&nextDirection[0]===-1),sgny=next[1]>current[3]?1:-1,sgnx=next[0]>current[2]?1:-1,sgnEqual=sgny===sgnx,cx=(sgnEqual&&ac||(!sgnEqual&&!ac))?next[0]:current[2],cy=(sgnEqual&&ac||(!sgnEqual&&!ac))?current[3]:next[1];_super.addSegment(conn,STRAIGHT,{x1:current[0],y1:current[1],x2:current[2],y2:current[3]});_super.addSegment(conn,ARC,{r:radiusToUse,x1:current[2],y1:current[3],x2:next[0],y2:next[1],cx:cx,cy:cy,ac:ac})}else{var dx=(current[2]===current[0])?0:(current[2]>current[0])?(paintInfo.lw/2):-(paintInfo.lw/2),dy=(current[3]===current[1])?0:(current[3]>current[1])?(paintInfo.lw/2):-(paintInfo.lw/2);_super.addSegment(conn,STRAIGHT,{x1:current[0]-dx,y1:current[1]-dy,x2:current[2]+dx,y2:current[3]+dy})}
current=next}
if(next!=null){_super.addSegment(conn,STRAIGHT,{x1:next[0],y1:next[1],x2:next[2],y2:next[3]})}};this.midpoint=midpoint;this._compute=function(paintInfo,params){segments=[];lastx=null;lasty=null;lastOrientation=null;var commonStubCalculator=function(){return[paintInfo.startStubX,paintInfo.startStubY,paintInfo.endStubX,paintInfo.endStubY]},stubCalculators={perpendicular:commonStubCalculator,orthogonal:commonStubCalculator,opposite:function(axis){var pi=paintInfo,idx=axis==="x"?0:1,areInProximity={"x":function(){return((pi.so[idx]===1&&(((pi.startStubX>pi.endStubX)&&(pi.tx>pi.startStubX))||((pi.sx>pi.endStubX)&&(pi.tx>pi.sx)))))||((pi.so[idx]===-1&&(((pi.startStubX<pi.endStubX)&&(pi.tx<pi.startStubX))||((pi.sx<pi.endStubX)&&(pi.tx<pi.sx)))))},"y":function(){return((pi.so[idx]===1&&(((pi.startStubY>pi.endStubY)&&(pi.ty>pi.startStubY))||((pi.sy>pi.endStubY)&&(pi.ty>pi.sy)))))||((pi.so[idx]===-1&&(((pi.startStubY<pi.endStubY)&&(pi.ty<pi.startStubY))||((pi.sy<pi.endStubY)&&(pi.ty<pi.sy)))))}};if(!alwaysRespectStubs&&areInProximity[axis]()){return{"x":[(paintInfo.sx+paintInfo.tx)/2,paintInfo.startStubY,(paintInfo.sx+paintInfo.tx)/2,paintInfo.endStubY],"y":[paintInfo.startStubX,(paintInfo.sy+paintInfo.ty)/2,paintInfo.endStubX,(paintInfo.sy+paintInfo.ty)/2]}[axis]}else{return[paintInfo.startStubX,paintInfo.startStubY,paintInfo.endStubX,paintInfo.endStubY]}}};var stubs=stubCalculators[paintInfo.anchorOrientation](paintInfo.sourceAxis),idx=paintInfo.sourceAxis==="x"?0:1,oidx=paintInfo.sourceAxis==="x"?1:0,ss=stubs[idx],oss=stubs[oidx],es=stubs[idx+2],oes=stubs[oidx+2];addSegment(segments,stubs[0],stubs[1],paintInfo);var midx=paintInfo.startStubX+((paintInfo.endStubX-paintInfo.startStubX)*midpoint),midy=paintInfo.startStubY+((paintInfo.endStubY-paintInfo.startStubY)*midpoint);var orientations={x:[0,1],y:[1,0]},lineCalculators={perpendicular:function(axis){var pi=paintInfo,sis={x:[[[1,2,3,4],null,[2,1,4,3]],null,[[4,3,2,1],null,[3,4,1,2]]],y:[[[3,2,1,4],null,[2,3,4,1]],null,[[4,1,2,3],null,[1,4,3,2]]]},stubs={x:[[pi.startStubX,pi.endStubX],null,[pi.endStubX,pi.startStubX]],y:[[pi.startStubY,pi.endStubY],null,[pi.endStubY,pi.startStubY]]},midLines={x:[[midx,pi.startStubY],[midx,pi.endStubY]],y:[[pi.startStubX,midy],[pi.endStubX,midy]]},linesToEnd={x:[[pi.endStubX,pi.startStubY]],y:[[pi.startStubX,pi.endStubY]]},startToEnd={x:[[pi.startStubX,pi.endStubY],[pi.endStubX,pi.endStubY]],y:[[pi.endStubX,pi.startStubY],[pi.endStubX,pi.endStubY]]},startToMidToEnd={x:[[pi.startStubX,midy],[pi.endStubX,midy],[pi.endStubX,pi.endStubY]],y:[[midx,pi.startStubY],[midx,pi.endStubY],[pi.endStubX,pi.endStubY]]},otherStubs={x:[pi.startStubY,pi.endStubY],y:[pi.startStubX,pi.endStubX]},soIdx=orientations[axis][0],toIdx=orientations[axis][1],_so=pi.so[soIdx]+1,_to=pi.to[toIdx]+1,otherFlipped=(pi.to[toIdx]===-1&&(otherStubs[axis][1]<otherStubs[axis][0]))||(pi.to[toIdx]===1&&(otherStubs[axis][1]>otherStubs[axis][0])),stub1=stubs[axis][_so][0],stub2=stubs[axis][_so][1],segmentIndexes=sis[axis][_so][_to];if(pi.segment===segmentIndexes[3]||(pi.segment===segmentIndexes[2]&&otherFlipped)){return midLines[axis]}else if(pi.segment===segmentIndexes[2]&&stub2<stub1){return linesToEnd[axis]}else if((pi.segment===segmentIndexes[2]&&stub2>=stub1)||(pi.segment===segmentIndexes[1]&&!otherFlipped)){return startToMidToEnd[axis]}else if(pi.segment===segmentIndexes[0]||(pi.segment===segmentIndexes[1]&&otherFlipped)){return startToEnd[axis]}},orthogonal:function(axis,startStub,otherStartStub,endStub,otherEndStub){var pi=paintInfo,extent={"x":pi.so[0]===-1?Math.min(startStub,endStub):Math.max(startStub,endStub),"y":pi.so[1]===-1?Math.min(startStub,endStub):Math.max(startStub,endStub)}[axis];return{"x":[[extent,otherStartStub],[extent,otherEndStub],[endStub,otherEndStub]],"y":[[otherStartStub,extent],[otherEndStub,extent],[otherEndStub,endStub]]}[axis]},opposite:function(axis,ss,oss,es){var pi=paintInfo,otherAxis={"x":"y","y":"x"}[axis],dim={"x":"height","y":"width"}[axis],comparator=pi["is"+axis.toUpperCase()+"GreaterThanStubTimes2"];if(params.sourceEndpoint.elementId===params.targetEndpoint.elementId){var _val=oss+((1-params.sourceEndpoint.anchor[otherAxis])*params.sourceInfo[dim])+_super.maxStub;return{"x":[[ss,_val],[es,_val]],"y":[[_val,ss],[_val,es]]}[axis]}else if(!comparator||(pi.so[idx]===1&&ss>es)||(pi.so[idx]===-1&&ss<es)){return{"x":[[ss,midy],[es,midy]],"y":[[midx,ss],[midx,es]]}[axis]}else if((pi.so[idx]===1&&ss<es)||(pi.so[idx]===-1&&ss>es)){return{"x":[[midx,pi.sy],[midx,pi.ty]],"y":[[pi.sx,midy],[pi.tx,midy]]}[axis]}}};var p=lineCalculators[paintInfo.anchorOrientation](paintInfo.sourceAxis,ss,oss,es,oes);if(p){for(var i=0;i<p.length;i++){addSegment(segments,p[i][0],p[i][1],paintInfo)}}
addSegment(segments,stubs[2],stubs[3],paintInfo);addSegment(segments,paintInfo.tx,paintInfo.ty,paintInfo);writeSegments(this,segments,paintInfo)}};_jp.Connectors.Flowchart=Flowchart;_ju.extend(_jp.Connectors.Flowchart,_jp.Connectors.AbstractConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;_jp.Connectors.AbstractBezierConnector=function(params){params=params||{};var showLoopback=params.showLoopback!==!1,curviness=params.curviness||10,margin=params.margin||5,proximityLimit=params.proximityLimit||80,clockwise=params.orientation&&params.orientation==="clockwise",loopbackRadius=params.loopbackRadius||25,isLoopbackCurrently=!1,_super;this._compute=function(paintInfo,p){var sp=p.sourcePos,tp=p.targetPos,_w=Math.abs(sp[0]-tp[0]),_h=Math.abs(sp[1]-tp[1]);if(!showLoopback||(p.sourceEndpoint.elementId!==p.targetEndpoint.elementId)){isLoopbackCurrently=!1;this._computeBezier(paintInfo,p,sp,tp,_w,_h)}else{isLoopbackCurrently=!0;var x1=p.sourcePos[0],y1=p.sourcePos[1]-margin,cx=x1,cy=y1-loopbackRadius,_x=cx-loopbackRadius,_y=cy-loopbackRadius;_w=2*loopbackRadius;_h=2*loopbackRadius;paintInfo.points[0]=_x;paintInfo.points[1]=_y;paintInfo.points[2]=_w;paintInfo.points[3]=_h;_super.addSegment(this,"Arc",{loopback:!0,x1:(x1-_x)+4,y1:y1-_y,startAngle:0,endAngle:2*Math.PI,r:loopbackRadius,ac:!clockwise,x2:(x1-_x)-4,y2:y1-_y,cx:cx-_x,cy:cy-_y})}};_super=_jp.Connectors.AbstractConnector.apply(this,arguments);return _super};_ju.extend(_jp.Connectors.AbstractBezierConnector,_jp.Connectors.AbstractConnector);var Bezier=function(params){params=params||{};this.type="Bezier";var _super=_jp.Connectors.AbstractBezierConnector.apply(this,arguments),majorAnchor=params.curviness||150,minorAnchor=10;this.getCurviness=function(){return majorAnchor};this._findControlPoint=function(point,sourceAnchorPosition,targetAnchorPosition,sourceEndpoint,targetEndpoint,soo,too){var perpendicular=soo[0]!==too[0]||soo[1]===too[1],p=[];if(!perpendicular){if(soo[0]===0){p.push(sourceAnchorPosition[0]<targetAnchorPosition[0]?point[0]+minorAnchor:point[0]-minorAnchor)}else{p.push(point[0]-(majorAnchor*soo[0]))}
if(soo[1]===0){p.push(sourceAnchorPosition[1]<targetAnchorPosition[1]?point[1]+minorAnchor:point[1]-minorAnchor)}else{p.push(point[1]+(majorAnchor*too[1]))}}else{if(too[0]===0){p.push(targetAnchorPosition[0]<sourceAnchorPosition[0]?point[0]+minorAnchor:point[0]-minorAnchor)}else{p.push(point[0]+(majorAnchor*too[0]))}
if(too[1]===0){p.push(targetAnchorPosition[1]<sourceAnchorPosition[1]?point[1]+minorAnchor:point[1]-minorAnchor)}else{p.push(point[1]+(majorAnchor*soo[1]))}}
return p};this._computeBezier=function(paintInfo,p,sp,tp,_w,_h){var _CP,_CP2,_sx=sp[0]<tp[0]?_w:0,_sy=sp[1]<tp[1]?_h:0,_tx=sp[0]<tp[0]?0:_w,_ty=sp[1]<tp[1]?0:_h;_CP=this._findControlPoint([_sx,_sy],sp,tp,p.sourceEndpoint,p.targetEndpoint,paintInfo.so,paintInfo.to);_CP2=this._findControlPoint([_tx,_ty],tp,sp,p.targetEndpoint,p.sourceEndpoint,paintInfo.to,paintInfo.so);_super.addSegment(this,"Bezier",{x1:_sx,y1:_sy,x2:_tx,y2:_ty,cp1x:_CP[0],cp1y:_CP[1],cp2x:_CP2[0],cp2y:_CP2[1]})}};_jp.Connectors.Bezier=Bezier;_ju.extend(Bezier,_jp.Connectors.AbstractBezierConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var _segment=function(x1,y1,x2,y2){if(x1<=x2&&y2<=y1){return 1}else if(x1<=x2&&y1<=y2){return 2}else if(x2<=x1&&y2>=y1){return 3}
return 4},_findControlPoint=function(midx,midy,segment,sourceEdge,targetEdge,dx,dy,distance,proximityLimit){if(distance<=proximityLimit){return[midx,midy]}
if(segment===1){if(sourceEdge[3]<=0&&targetEdge[3]>=1){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]>=1&&targetEdge[2]<=0){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+(-1*dx),midy+(-1*dy)]}}else if(segment===2){if(sourceEdge[3]>=1&&targetEdge[3]<=0){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]>=1&&targetEdge[2]<=0){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+dx,midy+(-1*dy)]}}else if(segment===3){if(sourceEdge[3]>=1&&targetEdge[3]<=0){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]<=0&&targetEdge[2]>=1){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+(-1*dx),midy+(-1*dy)]}}else if(segment===4){if(sourceEdge[3]<=0&&targetEdge[3]>=1){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]<=0&&targetEdge[2]>=1){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+dx,midy+(-1*dy)]}}};var StateMachine=function(params){params=params||{};this.type="StateMachine";var _super=_jp.Connectors.AbstractBezierConnector.apply(this,arguments),curviness=params.curviness||10,margin=params.margin||5,proximityLimit=params.proximityLimit||80,clockwise=params.orientation&&params.orientation==="clockwise",_controlPoint;this._computeBezier=function(paintInfo,params,sp,tp,w,h){var _sx=params.sourcePos[0]<params.targetPos[0]?0:w,_sy=params.sourcePos[1]<params.targetPos[1]?0:h,_tx=params.sourcePos[0]<params.targetPos[0]?w:0,_ty=params.sourcePos[1]<params.targetPos[1]?h:0;if(params.sourcePos[2]===0){_sx-=margin}
if(params.sourcePos[2]===1){_sx+=margin}
if(params.sourcePos[3]===0){_sy-=margin}
if(params.sourcePos[3]===1){_sy+=margin}
if(params.targetPos[2]===0){_tx-=margin}
if(params.targetPos[2]===1){_tx+=margin}
if(params.targetPos[3]===0){_ty-=margin}
if(params.targetPos[3]===1){_ty+=margin}
var _midx=(_sx+_tx)/2,_midy=(_sy+_ty)/2,segment=_segment(_sx,_sy,_tx,_ty),distance=Math.sqrt(Math.pow(_tx-_sx,2)+Math.pow(_ty-_sy,2)),cp1x,cp2x,cp1y,cp2y;_controlPoint=_findControlPoint(_midx,_midy,segment,params.sourcePos,params.targetPos,curviness,curviness,distance,proximityLimit);cp1x=_controlPoint[0];cp2x=_controlPoint[0];cp1y=_controlPoint[1];cp2y=_controlPoint[1];_super.addSegment(this,"Bezier",{x1:_tx,y1:_ty,x2:_sx,y2:_sy,cp1x:cp1x,cp1y:cp1y,cp2x:cp2x,cp2y:cp2y})}};_jp.Connectors.StateMachine=StateMachine;_ju.extend(StateMachine,_jp.Connectors.AbstractBezierConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var STRAIGHT="Straight";var Straight=function(params){this.type=STRAIGHT;var _super=_jp.Connectors.AbstractConnector.apply(this,arguments);this._compute=function(paintInfo,_){_super.addSegment(this,STRAIGHT,{x1:paintInfo.sx,y1:paintInfo.sy,x2:paintInfo.startStubX,y2:paintInfo.startStubY});_super.addSegment(this,STRAIGHT,{x1:paintInfo.startStubX,y1:paintInfo.startStubY,x2:paintInfo.endStubX,y2:paintInfo.endStubY});_super.addSegment(this,STRAIGHT,{x1:paintInfo.endStubX,y1:paintInfo.endStubY,x2:paintInfo.tx,y2:paintInfo.ty})}};_jp.Connectors.Straight=Straight;_ju.extend(Straight,_jp.Connectors.AbstractConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var svgAttributeMap={"stroke-linejoin":"stroke-linejoin","stroke-dashoffset":"stroke-dashoffset","stroke-linecap":"stroke-linecap"},STROKE_DASHARRAY="stroke-dasharray",DASHSTYLE="dashstyle",LINEAR_GRADIENT="linearGradient",RADIAL_GRADIENT="radialGradient",DEFS="defs",FILL="fill",STOP="stop",STROKE="stroke",STROKE_WIDTH="stroke-width",STYLE="style",NONE="none",JSPLUMB_GRADIENT="jsplumb_gradient_",LINE_WIDTH="strokeWidth",ns={svg:"http://www.w3.org/2000/svg"},_attr=function(node,attributes){for(var i in attributes){node.setAttribute(i,""+attributes[i])}},_node=function(name,attributes){attributes=attributes||{};attributes.version="1.1";attributes.xmlns=ns.svg;return _jp.createElementNS(ns.svg,name,null,null,attributes)},_pos=function(d){return"position:absolute;left:"+d[0]+"px;top:"+d[1]+"px"},_clearGradient=function(parent){var els=parent.querySelectorAll(" defs,linearGradient,radialGradient");for(var i=0;i<els.length;i++){els[i].parentNode.removeChild(els[i])}},_updateGradient=function(parent,node,style,dimensions,uiComponent){var id=JSPLUMB_GRADIENT+uiComponent._jsPlumb.instance.idstamp();_clearGradient(parent);var g;if(!style.gradient.offset){g=_node(LINEAR_GRADIENT,{id:id,gradientUnits:"userSpaceOnUse"})}else{g=_node(RADIAL_GRADIENT,{id:id})}
var defs=_node(DEFS);parent.appendChild(defs);defs.appendChild(g);for(var i=0;i<style.gradient.stops.length;i++){var styleToUse=uiComponent.segment===1||uiComponent.segment===2?i:style.gradient.stops.length-1-i,stopColor=style.gradient.stops[styleToUse][1],s=_node(STOP,{"offset":Math.floor(style.gradient.stops[i][0]*100)+"%","stop-color":stopColor});g.appendChild(s)}
var applyGradientTo=style.stroke?STROKE:FILL;node.setAttribute(applyGradientTo,"url(#"+id+")")},_applyStyles=function(parent,node,style,dimensions,uiComponent){node.setAttribute(FILL,style.fill?style.fill:NONE);node.setAttribute(STROKE,style.stroke?style.stroke:NONE);if(style.gradient){_updateGradient(parent,node,style,dimensions,uiComponent)}else{_clearGradient(parent);node.setAttribute(STYLE,"")}
if(style.strokeWidth){node.setAttribute(STROKE_WIDTH,style.strokeWidth)}
if(style[DASHSTYLE]&&style[LINE_WIDTH]&&!style[STROKE_DASHARRAY]){var sep=style[DASHSTYLE].indexOf(",")===-1?" ":",",parts=style[DASHSTYLE].split(sep),styleToUse="";parts.forEach(function(p){styleToUse+=(Math.floor(p*style.strokeWidth)+sep)});node.setAttribute(STROKE_DASHARRAY,styleToUse)}else if(style[STROKE_DASHARRAY]){node.setAttribute(STROKE_DASHARRAY,style[STROKE_DASHARRAY])}
for(var i in svgAttributeMap){if(style[i]){node.setAttribute(svgAttributeMap[i],style[i])}}},_appendAtIndex=function(svg,path,idx){if(svg.childNodes.length>idx){svg.insertBefore(path,svg.childNodes[idx])}else{svg.appendChild(path)}};_ju.svg={node:_node,attr:_attr,pos:_pos};var SvgComponent=function(params){var pointerEventsSpec=params.pointerEventsSpec||"all",renderer={};_jp.jsPlumbUIComponent.apply(this,params.originalArgs);this.canvas=null;this.path=null;this.svg=null;this.bgCanvas=null;var clazz=params.cssClass+" "+(params.originalArgs[0].cssClass||""),svgParams={"style":"","width":0,"height":0,"pointer-events":pointerEventsSpec,"position":"absolute"};this.svg=_node("svg",svgParams);if(params.useDivWrapper){this.canvas=_jp.createElement("div",{position:"absolute"});_ju.sizeElement(this.canvas,0,0,1,1);this.canvas.className=clazz}else{_attr(this.svg,{"class":clazz});this.canvas=this.svg}
params._jsPlumb.appendElement(this.canvas,params.originalArgs[0].parent);if(params.useDivWrapper){this.canvas.appendChild(this.svg)}
var displayElements=[this.canvas];this.getDisplayElements=function(){return displayElements};this.appendDisplayElement=function(el){displayElements.push(el)};this.paint=function(style,anchor,extents){if(style!=null){var xy=[this.x,this.y],wh=[this.w,this.h],p;if(extents!=null){if(extents.xmin<0){xy[0]+=extents.xmin}
if(extents.ymin<0){xy[1]+=extents.ymin}
wh[0]=extents.xmax+((extents.xmin<0)?-extents.xmin:0);wh[1]=extents.ymax+((extents.ymin<0)?-extents.ymin:0)}
if(params.useDivWrapper){_ju.sizeElement(this.canvas,xy[0],xy[1],wh[0]>0?wh[0]:1,wh[1]>0?wh[1]:1);xy[0]=0;xy[1]=0;p=_pos([0,0])}else{p=_pos([xy[0],xy[1]])}
renderer.paint.apply(this,arguments);_attr(this.svg,{"style":p,"width":wh[0]||1,"height":wh[1]||1})}};return{renderer:renderer}};_ju.extend(SvgComponent,_jp.jsPlumbUIComponent,{cleanup:function(force){if(force||this.typeId==null){if(this.canvas){this.canvas._jsPlumb=null}
if(this.svg){this.svg._jsPlumb=null}
if(this.bgCanvas){this.bgCanvas._jsPlumb=null}
if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}
if(this.bgCanvas&&this.bgCanvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}
this.svg=null;this.canvas=null;this.path=null;this.group=null;this._jsPlumb=null}else{if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}
if(this.bgCanvas&&this.bgCanvas.parentNode){this.bgCanvas.parentNode.removeChild(this.bgCanvas)}}},reattach:function(instance){var c=instance.getContainer();if(this.canvas&&this.canvas.parentNode==null){c.appendChild(this.canvas)}
if(this.bgCanvas&&this.bgCanvas.parentNode==null){c.appendChild(this.bgCanvas)}},setVisible:function(v){if(this.canvas){this.canvas.style.display=v?"block":"none"}}});_jp.ConnectorRenderers.svg=function(params){var self=this,_super=SvgComponent.apply(this,[{cssClass:params._jsPlumb.connectorClass,originalArgs:arguments,pointerEventsSpec:"none",_jsPlumb:params._jsPlumb}]);_super.renderer.paint=function(style,anchor,extents){var segments=self.getSegments(),p="",offset=[0,0];if(extents.xmin<0){offset[0]=-extents.xmin}
if(extents.ymin<0){offset[1]=-extents.ymin}
if(segments.length>0){p=self.getPathData();var a={d:p,transform:"translate("+offset[0]+","+offset[1]+")","pointer-events":params["pointer-events"]||"visibleStroke"},outlineStyle=null,d=[self.x,self.y,self.w,self.h];if(style.outlineStroke){var outlineWidth=style.outlineWidth||1,outlineStrokeWidth=style.strokeWidth+(2*outlineWidth);outlineStyle=_jp.extend({},style);delete outlineStyle.gradient;outlineStyle.stroke=style.outlineStroke;outlineStyle.strokeWidth=outlineStrokeWidth;if(self.bgPath==null){self.bgPath=_node("path",a);_jp.addClass(self.bgPath,_jp.connectorOutlineClass);_appendAtIndex(self.svg,self.bgPath,0)}else{_attr(self.bgPath,a)}
_applyStyles(self.svg,self.bgPath,outlineStyle,d,self)}
if(self.path==null){self.path=_node("path",a);_appendAtIndex(self.svg,self.path,style.outlineStroke?1:0)}else{_attr(self.path,a)}
_applyStyles(self.svg,self.path,style,d,self)}}};_ju.extend(_jp.ConnectorRenderers.svg,SvgComponent);var SvgEndpoint=_jp.SvgEndpoint=function(params){var _super=SvgComponent.apply(this,[{cssClass:params._jsPlumb.endpointClass,originalArgs:arguments,pointerEventsSpec:"all",useDivWrapper:!0,_jsPlumb:params._jsPlumb}]);_super.renderer.paint=function(style){var s=_jp.extend({},style);if(s.outlineStroke){s.stroke=s.outlineStroke}
if(this.node==null){this.node=this.makeNode(s);this.svg.appendChild(this.node)}else if(this.updateNode!=null){this.updateNode(this.node)}
_applyStyles(this.svg,this.node,s,[this.x,this.y,this.w,this.h],this);_pos(this.node,[this.x,this.y])}.bind(this)};_ju.extend(SvgEndpoint,SvgComponent);_jp.Endpoints.svg.Dot=function(){_jp.Endpoints.Dot.apply(this,arguments);SvgEndpoint.apply(this,arguments);this.makeNode=function(style){return _node("circle",{"cx":this.w/2,"cy":this.h/2,"r":this.radius})};this.updateNode=function(node){_attr(node,{"cx":this.w/2,"cy":this.h/2,"r":this.radius})}};_ju.extend(_jp.Endpoints.svg.Dot,[_jp.Endpoints.Dot,SvgEndpoint]);_jp.Endpoints.svg.Rectangle=function(){_jp.Endpoints.Rectangle.apply(this,arguments);SvgEndpoint.apply(this,arguments);this.makeNode=function(style){return _node("rect",{"width":this.w,"height":this.h})};this.updateNode=function(node){_attr(node,{"width":this.w,"height":this.h})}};_ju.extend(_jp.Endpoints.svg.Rectangle,[_jp.Endpoints.Rectangle,SvgEndpoint]);_jp.Endpoints.svg.Image=_jp.Endpoints.Image;_jp.Endpoints.svg.Blank=_jp.Endpoints.Blank;_jp.Overlays.svg.Label=_jp.Overlays.Label;_jp.Overlays.svg.Custom=_jp.Overlays.Custom;var AbstractSvgArrowOverlay=function(superclass,originalArgs){superclass.apply(this,originalArgs);_jp.jsPlumbUIComponent.apply(this,originalArgs);this.isAppendedAtTopLevel=!1;var self=this;this.path=null;this.paint=function(params,containerExtents){if(params.component.svg&&containerExtents){if(this.path==null){this.path=_node("path",{"pointer-events":"all"});params.component.svg.appendChild(this.path);if(this.elementCreated){this.elementCreated(this.path,params.component)}
this.canvas=params.component.svg}
var clazz=originalArgs&&(originalArgs.length===1)?(originalArgs[0].cssClass||""):"",offset=[0,0];if(containerExtents.xmin<0){offset[0]=-containerExtents.xmin}
if(containerExtents.ymin<0){offset[1]=-containerExtents.ymin}
_attr(this.path,{"d":makePath(params.d),"class":clazz,stroke:params.stroke?params.stroke:null,fill:params.fill?params.fill:null,transform:"translate("+offset[0]+","+offset[1]+")"})}};var makePath=function(d){return(isNaN(d.cxy.x)||isNaN(d.cxy.y))?"":"M"+d.hxy.x+","+d.hxy.y+" L"+d.tail[0].x+","+d.tail[0].y+" L"+d.cxy.x+","+d.cxy.y+" L"+d.tail[1].x+","+d.tail[1].y+" L"+d.hxy.x+","+d.hxy.y};this.transfer=function(target){if(target.canvas&&this.path&&this.path.parentNode){this.path.parentNode.removeChild(this.path);target.canvas.appendChild(this.path)}}};var svgProtoFunctions={cleanup:function(force){if(this.path!=null){if(force){this._jsPlumb.instance.removeElement(this.path)}else{if(this.path.parentNode){this.path.parentNode.removeChild(this.path)}}}},reattach:function(instance,component){if(this.path&&component.canvas){component.canvas.appendChild(this.path)}},setVisible:function(v){if(this.path!=null){(this.path.style.display=(v?"block":"none"))}}};_ju.extend(AbstractSvgArrowOverlay,[_jp.jsPlumbUIComponent,_jp.Overlays.AbstractOverlay]);_jp.Overlays.svg.Arrow=function(){AbstractSvgArrowOverlay.apply(this,[_jp.Overlays.Arrow,arguments])};_ju.extend(_jp.Overlays.svg.Arrow,[_jp.Overlays.Arrow,AbstractSvgArrowOverlay],svgProtoFunctions);_jp.Overlays.svg.PlainArrow=function(){AbstractSvgArrowOverlay.apply(this,[_jp.Overlays.PlainArrow,arguments])};_ju.extend(_jp.Overlays.svg.PlainArrow,[_jp.Overlays.PlainArrow,AbstractSvgArrowOverlay],svgProtoFunctions);_jp.Overlays.svg.Diamond=function(){AbstractSvgArrowOverlay.apply(this,[_jp.Overlays.Diamond,arguments])};_ju.extend(_jp.Overlays.svg.Diamond,[_jp.Overlays.Diamond,AbstractSvgArrowOverlay],svgProtoFunctions);_jp.Overlays.svg.GuideLines=function(){var path=null,self=this,p1_1,p1_2;_jp.Overlays.GuideLines.apply(this,arguments);this.paint=function(params,containerExtents){if(path==null){path=_node("path");params.connector.svg.appendChild(path);self.attachListeners(path,params.connector);self.attachListeners(path,self);p1_1=_node("path");params.connector.svg.appendChild(p1_1);self.attachListeners(p1_1,params.connector);self.attachListeners(p1_1,self);p1_2=_node("path");params.connector.svg.appendChild(p1_2);self.attachListeners(p1_2,params.connector);self.attachListeners(p1_2,self)}
var offset=[0,0];if(containerExtents.xmin<0){offset[0]=-containerExtents.xmin}
if(containerExtents.ymin<0){offset[1]=-containerExtents.ymin}
_attr(path,{"d":makePath(params.head,params.tail),stroke:"red",fill:null,transform:"translate("+offset[0]+","+offset[1]+")"});_attr(p1_1,{"d":makePath(params.tailLine[0],params.tailLine[1]),stroke:"blue",fill:null,transform:"translate("+offset[0]+","+offset[1]+")"});_attr(p1_2,{"d":makePath(params.headLine[0],params.headLine[1]),stroke:"green",fill:null,transform:"translate("+offset[0]+","+offset[1]+")"})};var makePath=function(d1,d2){return"M "+d1.x+","+d1.y+" L"+d2.x+","+d2.y}};_ju.extend(_jp.Overlays.svg.GuideLines,_jp.Overlays.GuideLines)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil,_jk=root.Katavorio,_jg=root.Biltong;var _getEventManager=function(instance){var e=instance._mottle;if(!e){e=instance._mottle=new root.Mottle()}
return e};var _getDragManager=function(instance,category){category=category||"main";var key="_katavorio_"+category;var k=instance[key],e=instance.getEventManager();if(!k){k=new _jk({bind:e.on,unbind:e.off,getSize:_jp.getSize,getConstrainingRectangle:function(el){return[el.parentNode.scrollWidth,el.parentNode.scrollHeight]},getPosition:function(el,relativeToRoot){var o=instance.getOffset(el,relativeToRoot,el._katavorioDrag?el.offsetParent:null);return[o.left,o.top]},setPosition:function(el,xy){el.style.left=xy[0]+"px";el.style.top=xy[1]+"px"},addClass:_jp.addClass,removeClass:_jp.removeClass,intersects:_jg.intersects,indexOf:function(l,i){return l.indexOf(i)},scope:instance.getDefaultScope(),css:{noSelect:instance.dragSelectClass,droppable:"jtk-droppable",draggable:"jtk-draggable",drag:"jtk-drag",selected:"jtk-drag-selected",active:"jtk-drag-active",hover:"jtk-drag-hover",ghostProxy:"jtk-ghost-proxy"}});k.setZoom(instance.getZoom());instance[key]=k;instance.bind("zoom",k.setZoom)}
return k};var _dragStart=function(params){var options=params.el._jsPlumbDragOptions;var cont=!0;if(options.canDrag){cont=options.canDrag()}
if(cont){this.setHoverSuspended(!0);this.select({source:params.el}).addClass(this.elementDraggingClass+" "+this.sourceElementDraggingClass,!0);this.select({target:params.el}).addClass(this.elementDraggingClass+" "+this.targetElementDraggingClass,!0);this.setConnectionBeingDragged(!0)}
return cont};var _dragMove=function(params){var ui=this.getUIPosition(arguments,this.getZoom());if(ui!=null){var o=params.el._jsPlumbDragOptions;this.draw(params.el,ui,null,!0);if(o._dragging){this.addClass(params.el,"jtk-dragged")}
o._dragging=!0}};var _dragStop=function(params){var elements=params.selection,uip;var _one=function(_e){var drawResult;if(_e[1]!=null){uip=this.getUIPosition([{el:_e[2].el,pos:[_e[1].left,_e[1].top]}]);drawResult=this.draw(_e[2].el,uip)}
if(_e[0]._jsPlumbDragOptions!=null){delete _e[0]._jsPlumbDragOptions._dragging}
this.removeClass(_e[0],"jtk-dragged");this.select({source:_e[2].el}).removeClass(this.elementDraggingClass+" "+this.sourceElementDraggingClass,!0);this.select({target:_e[2].el}).removeClass(this.elementDraggingClass+" "+this.targetElementDraggingClass,!0);params.e._drawResult=params.e._drawResult||{c:[],e:[],a:[]};Array.prototype.push.apply(params.e._drawResult.c,drawResult.c);Array.prototype.push.apply(params.e._drawResult.e,drawResult.e);Array.prototype.push.apply(params.e._drawResult.a,drawResult.a);this.getDragManager().dragEnded(_e[2].el)}.bind(this);for(var i=0;i<elements.length;i++){_one(elements[i])}
this.setHoverSuspended(!1);this.setConnectionBeingDragged(!1)};var _animProps=function(o,p){var _one=function(pName){if(p[pName]!=null){if(_ju.isString(p[pName])){var m=p[pName].match(/-=/)?-1:1,v=p[pName].substring(2);return o[pName]+(m*v)}else{return p[pName]}}else{return o[pName]}};return[_one("left"),_one("top")]};var _genLoc=function(prefix,e){if(e==null){return[0,0]}
var ts=_touches(e),t=_getTouch(ts,0);return[t[prefix+"X"],t[prefix+"Y"]]},_pageLocation=_genLoc.bind(this,"page"),_screenLocation=_genLoc.bind(this,"screen"),_clientLocation=_genLoc.bind(this,"client"),_getTouch=function(touches,idx){return touches.item?touches.item(idx):touches[idx]},_touches=function(e){return e.touches&&e.touches.length>0?e.touches:e.changedTouches&&e.changedTouches.length>0?e.changedTouches:e.targetTouches&&e.targetTouches.length>0?e.targetTouches:[e]};var DragManager=function(_currentInstance){var _draggables={},_dlist=[],_delements={},_elementsWithEndpoints={},_draggablesForElements={};this.register=function(el){var id=_currentInstance.getId(el),parentOffset;if(!_draggables[id]){_draggables[id]=el;_dlist.push(el);_delements[id]={}}
var _oneLevel=function(p){if(p){for(var i=0;i<p.childNodes.length;i++){if(p.childNodes[i].nodeType!==3&&p.childNodes[i].nodeType!==8){var cEl=jsPlumb.getElement(p.childNodes[i]),cid=_currentInstance.getId(p.childNodes[i],null,!0);if(cid&&_elementsWithEndpoints[cid]&&_elementsWithEndpoints[cid]>0){if(!parentOffset){parentOffset=_currentInstance.getOffset(el)}
var cOff=_currentInstance.getOffset(cEl);_delements[id][cid]={id:cid,offset:{left:cOff.left-parentOffset.left,top:cOff.top-parentOffset.top}};_draggablesForElements[cid]=id}
_oneLevel(p.childNodes[i])}}}};_oneLevel(el)};this.updateOffsets=function(elId,childOffsetOverrides){if(elId!=null){childOffsetOverrides=childOffsetOverrides||{};var domEl=jsPlumb.getElement(elId),id=_currentInstance.getId(domEl),children=_delements[id],parentOffset;if(children){for(var i in children){if(children.hasOwnProperty(i)){var cel=jsPlumb.getElement(i),cOff=childOffsetOverrides[i]||_currentInstance.getOffset(cel);if(cel.offsetParent==null&&_delements[id][i]!=null){continue}
if(!parentOffset){parentOffset=_currentInstance.getOffset(domEl)}
_delements[id][i]={id:i,offset:{left:cOff.left-parentOffset.left,top:cOff.top-parentOffset.top}};_draggablesForElements[i]=id}}}}};this.endpointAdded=function(el,id){id=id||_currentInstance.getId(el);var b=document.body,p=el.parentNode;_elementsWithEndpoints[id]=_elementsWithEndpoints[id]?_elementsWithEndpoints[id]+1:1;while(p!=null&&p!==b){var pid=_currentInstance.getId(p,null,!0);if(pid&&_draggables[pid]){var pLoc=_currentInstance.getOffset(p);if(_delements[pid][id]==null){var cLoc=_currentInstance.getOffset(el);_delements[pid][id]={id:id,offset:{left:cLoc.left-pLoc.left,top:cLoc.top-pLoc.top}};_draggablesForElements[id]=pid}
break}
p=p.parentNode}};this.endpointDeleted=function(endpoint){if(_elementsWithEndpoints[endpoint.elementId]){_elementsWithEndpoints[endpoint.elementId]--;if(_elementsWithEndpoints[endpoint.elementId]<=0){for(var i in _delements){if(_delements.hasOwnProperty(i)&&_delements[i]){delete _delements[i][endpoint.elementId];delete _draggablesForElements[endpoint.elementId]}}}}};this.changeId=function(oldId,newId){_delements[newId]=_delements[oldId];_delements[oldId]={};_draggablesForElements[newId]=_draggablesForElements[oldId];_draggablesForElements[oldId]=null};this.getElementsForDraggable=function(id){return _delements[id]};this.elementRemoved=function(elementId){var elId=_draggablesForElements[elementId];if(elId){_delements[elId]&&delete _delements[elId][elementId];delete _draggablesForElements[elementId]}};this.reset=function(){_draggables={};_dlist=[];_delements={};_elementsWithEndpoints={}};this.dragEnded=function(el){if(el.offsetParent!=null){var id=_currentInstance.getId(el),ancestor=_draggablesForElements[id];if(ancestor){this.updateOffsets(ancestor)}}};this.setParent=function(el,elId,p,pId,currentChildLocation){var current=_draggablesForElements[elId];if(!_delements[pId]){_delements[pId]={}}
var pLoc=_currentInstance.getOffset(p),cLoc=currentChildLocation||_currentInstance.getOffset(el);if(current&&_delements[current]){delete _delements[current][elId]}
_delements[pId][elId]={id:elId,offset:{left:cLoc.left-pLoc.left,top:cLoc.top-pLoc.top}};_draggablesForElements[elId]=pId};this.clearParent=function(el,elId){var current=_draggablesForElements[elId];if(current){delete _delements[current][elId];delete _draggablesForElements[elId]}};this.revalidateParent=function(el,elId,childOffset){var current=_draggablesForElements[elId];if(current){var co={};co[elId]=childOffset;this.updateOffsets(current,co);_currentInstance.revalidate(current)}};this.getDragAncestor=function(el){var de=jsPlumb.getElement(el),id=_currentInstance.getId(de),aid=_draggablesForElements[id];if(aid){return jsPlumb.getElement(aid)}else{return null}}};var _setClassName=function(el,cn,classList){cn=_ju.fastTrim(cn);if(typeof el.className.baseVal!=="undefined"){el.className.baseVal=cn}else{el.className=cn}
try{var cl=el.classList;if(cl!=null){while(cl.length>0){cl.remove(cl.item(0))}
for(var i=0;i<classList.length;i++){if(classList[i]){cl.add(classList[i])}}}}catch(e){_ju.log("JSPLUMB: cannot set class list",e)}},_getClassName=function(el){return(typeof el.className.baseVal==="undefined")?el.className:el.className.baseVal},_classManip=function(el,classesToAdd,classesToRemove){classesToAdd=classesToAdd==null?[]:_ju.isArray(classesToAdd)?classesToAdd:classesToAdd.split(/\s+/);classesToRemove=classesToRemove==null?[]:_ju.isArray(classesToRemove)?classesToRemove:classesToRemove.split(/\s+/);var className=_getClassName(el),curClasses=className.split(/\s+/);var _oneSet=function(add,classes){for(var i=0;i<classes.length;i++){if(add){if(curClasses.indexOf(classes[i])===-1){curClasses.push(classes[i])}}else{var idx=curClasses.indexOf(classes[i]);if(idx!==-1){curClasses.splice(idx,1)}}}};_oneSet(!0,classesToAdd);_oneSet(!1,classesToRemove);_setClassName(el,curClasses.join(" "),curClasses)};root.jsPlumb.extend(root.jsPlumbInstance.prototype,{headless:!1,pageLocation:_pageLocation,screenLocation:_screenLocation,clientLocation:_clientLocation,getDragManager:function(){if(this.dragManager==null){this.dragManager=new DragManager(this)}
return this.dragManager},recalculateOffsets:function(elId){this.getDragManager().updateOffsets(elId)},createElement:function(tag,style,clazz,atts){return this.createElementNS(null,tag,style,clazz,atts)},createElementNS:function(ns,tag,style,clazz,atts){var e=ns==null?document.createElement(tag):document.createElementNS(ns,tag);var i;style=style||{};for(i in style){e.style[i]=style[i]}
if(clazz){e.className=clazz}
atts=atts||{};for(i in atts){e.setAttribute(i,""+atts[i])}
return e},getAttribute:function(el,attName){return el.getAttribute!=null?el.getAttribute(attName):null},setAttribute:function(el,a,v){if(el.setAttribute!=null){el.setAttribute(a,v)}},setAttributes:function(el,atts){for(var i in atts){if(atts.hasOwnProperty(i)){el.setAttribute(i,atts[i])}}},appendToRoot:function(node){document.body.appendChild(node)},getRenderModes:function(){return["svg"]},getClass:_getClassName,addClass:function(el,clazz){jsPlumb.each(el,function(e){_classManip(e,clazz)})},hasClass:function(el,clazz){el=jsPlumb.getElement(el);if(el.classList){return el.classList.contains(clazz)}else{return _getClassName(el).indexOf(clazz)!==-1}},removeClass:function(el,clazz){jsPlumb.each(el,function(e){_classManip(e,null,clazz)})},toggleClass:function(el,clazz){if(jsPlumb.hasClass(el,clazz)){jsPlumb.removeClass(el,clazz)}else{jsPlumb.addClass(el,clazz)}},updateClasses:function(el,toAdd,toRemove){jsPlumb.each(el,function(e){_classManip(e,toAdd,toRemove)})},setClass:function(el,clazz){if(clazz!=null){jsPlumb.each(el,function(e){_setClassName(e,clazz,clazz.split(/\s+/))})}},setPosition:function(el,p){el.style.left=p.left+"px";el.style.top=p.top+"px"},getPosition:function(el){var _one=function(prop){var v=el.style[prop];return v?v.substring(0,v.length-2):0};return{left:_one("left"),top:_one("top")}},getStyle:function(el,prop){if(typeof window.getComputedStyle!=='undefined'){return getComputedStyle(el,null).getPropertyValue(prop)}else{return el.currentStyle[prop]}},getSelector:function(ctx,spec){var sel=null;if(arguments.length===1){sel=ctx.nodeType!=null?ctx:document.querySelectorAll(ctx)}else{sel=ctx.querySelectorAll(spec)}
return sel},getOffset:function(el,relativeToRoot,container){el=jsPlumb.getElement(el);container=container||this.getContainer();var out={left:el.offsetLeft,top:el.offsetTop},op=(relativeToRoot||(container!=null&&(el!==container&&el.offsetParent!==container)))?el.offsetParent:null,_maybeAdjustScroll=function(offsetParent){if(offsetParent!=null&&offsetParent!==document.body&&(offsetParent.scrollTop>0||offsetParent.scrollLeft>0)){out.left-=offsetParent.scrollLeft;out.top-=offsetParent.scrollTop}}.bind(this);while(op!=null){out.left+=op.offsetLeft;out.top+=op.offsetTop;_maybeAdjustScroll(op);op=relativeToRoot?op.offsetParent:op.offsetParent===container?null:op.offsetParent}
if(container!=null&&!relativeToRoot&&(container.scrollTop>0||container.scrollLeft>0)){var pp=el.offsetParent!=null?this.getStyle(el.offsetParent,"position"):"static",p=this.getStyle(el,"position");if(p!=="absolute"&&p!=="fixed"&&pp!=="absolute"&&pp!=="fixed"){out.left-=container.scrollLeft;out.top-=container.scrollTop}}
return out},getPositionOnElement:function(evt,el,zoom){var box=typeof el.getBoundingClientRect!=="undefined"?el.getBoundingClientRect():{left:0,top:0,width:0,height:0},body=document.body,docElem=document.documentElement,scrollTop=window.pageYOffset||docElem.scrollTop||body.scrollTop,scrollLeft=window.pageXOffset||docElem.scrollLeft||body.scrollLeft,clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,pst=0,psl=0,top=box.top+scrollTop-clientTop+(pst*zoom),left=box.left+scrollLeft-clientLeft+(psl*zoom),cl=jsPlumb.pageLocation(evt),w=box.width||(el.offsetWidth*zoom),h=box.height||(el.offsetHeight*zoom),x=(cl[0]-left)/w,y=(cl[1]-top)/h;return[x,y]},getAbsolutePosition:function(el){var _one=function(s){var ss=el.style[s];if(ss){return parseFloat(ss.substring(0,ss.length-2))}};return[_one("left"),_one("top")]},setAbsolutePosition:function(el,xy,animateFrom,animateOptions){if(animateFrom){this.animate(el,{left:"+="+(xy[0]-animateFrom[0]),top:"+="+(xy[1]-animateFrom[1])},animateOptions)}else{el.style.left=xy[0]+"px";el.style.top=xy[1]+"px"}},getSize:function(el){return[el.offsetWidth,el.offsetHeight]},getWidth:function(el){return el.offsetWidth},getHeight:function(el){return el.offsetHeight},getRenderMode:function(){return"svg"},draggable:function(el,options){var info;el=_ju.isArray(el)||(el.length!=null&&!_ju.isString(el))?el:[el];Array.prototype.slice.call(el).forEach(function(_el){info=this.info(_el);if(info.el){this._initDraggableIfNecessary(info.el,!0,options,info.id,!0)}}.bind(this));return this},snapToGrid:function(el,x,y){var out=[];var _oneEl=function(_el){var info=this.info(_el);if(info.el!=null&&info.el._katavorioDrag){var snapped=info.el._katavorioDrag.snap(x,y);this.revalidate(info.el);out.push([info.el,snapped])}}.bind(this);if(arguments.length===1||arguments.length===3){_oneEl(el,x,y)}else{var _me=this.getManagedElements();for(var mel in _me){_oneEl(mel,arguments[0],arguments[1])}}
return out},initDraggable:function(el,options,category){_getDragManager(this,category).draggable(el,options);el._jsPlumbDragOptions=options},destroyDraggable:function(el,category){_getDragManager(this,category).destroyDraggable(el);el._jsPlumbDragOptions=null;el._jsPlumbRelatedElement=null},unbindDraggable:function(el,evt,fn,category){_getDragManager(this,category).destroyDraggable(el,evt,fn)},setDraggable:function(element,draggable){return jsPlumb.each(element,function(el){if(this.isDragSupported(el)){this._draggableStates[this.getAttribute(el,"id")]=draggable;this.setElementDraggable(el,draggable)}}.bind(this))},_draggableStates:{},toggleDraggable:function(el){var state;jsPlumb.each(el,function(el){var elId=this.getAttribute(el,"id");state=this._draggableStates[elId]==null?!1:this._draggableStates[elId];state=!state;this._draggableStates[elId]=state;this.setDraggable(el,state);return state}.bind(this));return state},_initDraggableIfNecessary:function(element,isDraggable,dragOptions,id,fireEvent){if(!jsPlumb.headless){var _draggable=isDraggable==null?!1:isDraggable;if(_draggable){if(jsPlumb.isDragSupported(element,this)){var options=dragOptions||this.Defaults.DragOptions;options=jsPlumb.extend({},options);if(!jsPlumb.isAlreadyDraggable(element,this)){var dragEvent=jsPlumb.dragEvents.drag,stopEvent=jsPlumb.dragEvents.stop,startEvent=jsPlumb.dragEvents.start;this.manage(id,element);options[startEvent]=_ju.wrap(options[startEvent],_dragStart.bind(this));options[dragEvent]=_ju.wrap(options[dragEvent],_dragMove.bind(this));options[stopEvent]=_ju.wrap(options[stopEvent],_dragStop.bind(this));var elId=this.getId(element);this._draggableStates[elId]=!0;var draggable=this._draggableStates[elId];options.disabled=draggable==null?!1:!draggable;this.initDraggable(element,options);this.getDragManager().register(element);if(fireEvent){this.fire("elementDraggable",{el:element,options:options})}}else{if(dragOptions.force){this.initDraggable(element,options)}}}}}},animationSupported:!0,getElement:function(el){if(el==null){return null}
el=typeof el==="string"?el:(el.tagName==null&&el.length!=null&&el.enctype==null)?el[0]:el;return typeof el==="string"?document.getElementById(el):el},removeElement:function(element){_getDragManager(this).elementRemoved(element);this.getEventManager().remove(element)},doAnimate:function(el,properties,options){options=options||{};var o=this.getOffset(el),ap=_animProps(o,properties),ldist=ap[0]-o.left,tdist=ap[1]-o.top,d=options.duration||250,step=15,steps=d/step,linc=(step/d)*ldist,tinc=(step/d)*tdist,idx=0,_int=setInterval(function(){_jp.setPosition(el,{left:o.left+(linc*(idx+1)),top:o.top+(tinc*(idx+1))});if(options.step!=null){options.step(idx,Math.ceil(steps))}
idx++;if(idx>=steps){window.clearInterval(_int);if(options.complete!=null){options.complete()}}},step)},destroyDroppable:function(el,category){_getDragManager(this,category).destroyDroppable(el)},unbindDroppable:function(el,evt,fn,category){_getDragManager(this,category).destroyDroppable(el,evt,fn)},droppable:function(el,options){el=_ju.isArray(el)||(el.length!=null&&!_ju.isString(el))?el:[el];var info;options=options||{};options.allowLoopback=!1;Array.prototype.slice.call(el).forEach(function(_el){info=this.info(_el);if(info.el){this.initDroppable(info.el,options)}}.bind(this));return this},initDroppable:function(el,options,category){_getDragManager(this,category).droppable(el,options)},isAlreadyDraggable:function(el){return el._katavorioDrag!=null},isDragSupported:function(el,options){return!0},isDropSupported:function(el,options){return!0},isElementDraggable:function(el){el=_jp.getElement(el);return el._katavorioDrag&&el._katavorioDrag.isEnabled()},getDragObject:function(eventArgs){return eventArgs[0].drag.getDragElement()},getDragScope:function(el){return el._katavorioDrag&&el._katavorioDrag.scopes.join(" ")||""},getDropEvent:function(args){return args[0].e},getUIPosition:function(eventArgs,zoom){var el=eventArgs[0].el;if(el.offsetParent==null){return null}
var finalPos=eventArgs[0].finalPos||eventArgs[0].pos;var p={left:finalPos[0],top:finalPos[1]};if(el._katavorioDrag&&el.offsetParent!==this.getContainer()){var oc=this.getOffset(el.offsetParent);p.left+=oc.left;p.top+=oc.top}
return p},setDragFilter:function(el,filter,_exclude){if(el._katavorioDrag){el._katavorioDrag.setFilter(filter,_exclude)}},setElementDraggable:function(el,draggable){el=_jp.getElement(el);if(el._katavorioDrag){el._katavorioDrag.setEnabled(draggable)}},setDragScope:function(el,scope){if(el._katavorioDrag){el._katavorioDrag.k.setDragScope(el,scope)}},setDropScope:function(el,scope){if(el._katavorioDrop&&el._katavorioDrop.length>0){el._katavorioDrop[0].k.setDropScope(el,scope)}},addToPosse:function(el,spec){var specs=Array.prototype.slice.call(arguments,1);var dm=_getDragManager(this);_jp.each(el,function(_el){_el=[_jp.getElement(_el)];_el.push.apply(_el,specs);dm.addToPosse.apply(dm,_el)})},setPosse:function(el,spec){var specs=Array.prototype.slice.call(arguments,1);var dm=_getDragManager(this);_jp.each(el,function(_el){_el=[_jp.getElement(_el)];_el.push.apply(_el,specs);dm.setPosse.apply(dm,_el)})},removeFromPosse:function(el,posseId){var specs=Array.prototype.slice.call(arguments,1);var dm=_getDragManager(this);_jp.each(el,function(_el){_el=[_jp.getElement(_el)];_el.push.apply(_el,specs);dm.removeFromPosse.apply(dm,_el)})},removeFromAllPosses:function(el){var dm=_getDragManager(this);_jp.each(el,function(_el){dm.removeFromAllPosses(_jp.getElement(_el))})},setPosseState:function(el,posseId,state){var dm=_getDragManager(this);_jp.each(el,function(_el){dm.setPosseState(_jp.getElement(_el),posseId,state)})},dragEvents:{'start':'start','stop':'stop','drag':'drag','step':'step','over':'over','out':'out','drop':'drop','complete':'complete','beforeStart':'beforeStart'},animEvents:{'step':"step",'complete':'complete'},stopDrag:function(el){if(el._katavorioDrag){el._katavorioDrag.abort()}},addToDragSelection:function(spec){var el=this.getElement(spec);if(el!=null&&(el._isJsPlumbGroup||el._jsPlumbGroup==null)){_getDragManager(this).select(spec)}},removeFromDragSelection:function(spec){_getDragManager(this).deselect(spec)},getDragSelection:function(){return _getDragManager(this).getSelection()},clearDragSelection:function(){_getDragManager(this).deselectAll()},trigger:function(el,event,originalEvent,payload){this.getEventManager().trigger(el,event,originalEvent,payload)},doReset:function(){for(var key in this){if(key.indexOf("_katavorio_")===0){this[key].reset()}}},getEventManager:function(){return _getEventManager(this)},on:function(el,event,callback){this.getEventManager().on.apply(this,arguments);return this},off:function(el,event,callback){this.getEventManager().off.apply(this,arguments);return this}});var ready=function(f){var _do=function(){if(/complete|loaded|interactive/.test(document.readyState)&&typeof(document.body)!=="undefined"&&document.body!=null){f()}else{setTimeout(_do,9)}};_do()};ready(_jp.init)}).call(typeof window!=='undefined'?window:this);/*!
 * typeahead.js 0.11.1
 * https://github.com/twitter/typeahead.js
 * Copyright 2013-2015 Twitter, Inc. and other contributors; Licensed MIT
 */
(function(root,factory){if(typeof define==="function"&&define.amd){define("bloodhound",["jquery"],function(a0){return root.Bloodhound=factory(a0)})}else if(typeof exports==="object"){module.exports=factory(require("jquery"))}else{root.Bloodhound=factory(jQuery)}})(this,function($){var _=function(){"use strict";return{isMsie:function(){return/(msie|trident)/i.test(navigator.userAgent)?navigator.userAgent.match(/(msie |rv:)(\d+(.\d+)?)/i)[2]:!1},isBlankString:function(str){return!str||/^\s*$/.test(str)},escapeRegExChars:function(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")},isString:function(obj){return typeof obj==="string"},isNumber:function(obj){return typeof obj==="number"},isArray:$.isArray,isFunction:$.isFunction,isObject:$.isPlainObject,isUndefined:function(obj){return typeof obj==="undefined"},isElement:function(obj){return!!(obj&&obj.nodeType===1)},isJQuery:function(obj){return obj instanceof $},toStr:function toStr(s){return _.isUndefined(s)||s===null?"":s+""},bind:$.proxy,each:function(collection,cb){$.each(collection,reverseArgs);function reverseArgs(index,value){return cb(value,index)}},map:$.map,filter:$.grep,every:function(obj,test){var result=!0;if(!obj){return result}
$.each(obj,function(key,val){if(!(result=test.call(null,val,key,obj))){return!1}});return!!result},some:function(obj,test){var result=!1;if(!obj){return result}
$.each(obj,function(key,val){if(result=test.call(null,val,key,obj)){return!1}});return!!result},mixin:$.extend,identity:function(x){return x},clone:function(obj){return $.extend(!0,{},obj)},getIdGenerator:function(){var counter=0;return function(){return counter++}},templatify:function templatify(obj){return $.isFunction(obj)?obj:template;function template(){return String(obj)}},defer:function(fn){setTimeout(fn,0)},debounce:function(func,wait,immediate){var timeout,result;return function(){var context=this,args=arguments,later,callNow;later=function(){timeout=null;if(!immediate){result=func.apply(context,args)}};callNow=immediate&&!timeout;clearTimeout(timeout);timeout=setTimeout(later,wait);if(callNow){result=func.apply(context,args)}
return result}},throttle:function(func,wait){var context,args,timeout,result,previous,later;previous=0;later=function(){previous=new Date();timeout=null;result=func.apply(context,args)};return function(){var now=new Date(),remaining=wait-(now-previous);context=this;args=arguments;if(remaining<=0){clearTimeout(timeout);timeout=null;previous=now;result=func.apply(context,args)}else if(!timeout){timeout=setTimeout(later,remaining)}
return result}},stringify:function(val){return _.isString(val)?val:JSON.stringify(val)},noop:function(){}}}();var VERSION="0.11.1";var tokenizers=function(){"use strict";return{nonword:nonword,whitespace:whitespace,obj:{nonword:getObjTokenizer(nonword),whitespace:getObjTokenizer(whitespace)}};function whitespace(str){str=_.toStr(str);return str?str.split(/\s+/):[]}
function nonword(str){str=_.toStr(str);return str?str.split(/\W+/):[]}
function getObjTokenizer(tokenizer){return function setKey(keys){keys=_.isArray(keys)?keys:[].slice.call(arguments,0);return function tokenize(o){var tokens=[];_.each(keys,function(k){tokens=tokens.concat(tokenizer(_.toStr(o[k])))});return tokens}}}}();var LruCache=function(){"use strict";function LruCache(maxSize){this.maxSize=_.isNumber(maxSize)?maxSize:100;this.reset();if(this.maxSize<=0){this.set=this.get=$.noop}}
_.mixin(LruCache.prototype,{set:function set(key,val){var tailItem=this.list.tail,node;if(this.size>=this.maxSize){this.list.remove(tailItem);delete this.hash[tailItem.key];this.size--}
if(node=this.hash[key]){node.val=val;this.list.moveToFront(node)}else{node=new Node(key,val);this.list.add(node);this.hash[key]=node;this.size++}},get:function get(key){var node=this.hash[key];if(node){this.list.moveToFront(node);return node.val}},reset:function reset(){this.size=0;this.hash={};this.list=new List()}});function List(){this.head=this.tail=null}
_.mixin(List.prototype,{add:function add(node){if(this.head){node.next=this.head;this.head.prev=node}
this.head=node;this.tail=this.tail||node},remove:function remove(node){node.prev?node.prev.next=node.next:this.head=node.next;node.next?node.next.prev=node.prev:this.tail=node.prev},moveToFront:function(node){this.remove(node);this.add(node)}});function Node(key,val){this.key=key;this.val=val;this.prev=this.next=null}
return LruCache}();var PersistentStorage=function(){"use strict";var LOCAL_STORAGE;try{LOCAL_STORAGE=window.localStorage;LOCAL_STORAGE.setItem("~~~","!");LOCAL_STORAGE.removeItem("~~~")}catch(err){LOCAL_STORAGE=null}
function PersistentStorage(namespace,override){this.prefix=["__",namespace,"__"].join("");this.ttlKey="__ttl__";this.keyMatcher=new RegExp("^"+_.escapeRegExChars(this.prefix));this.ls=override||LOCAL_STORAGE;!this.ls&&this._noop()}
_.mixin(PersistentStorage.prototype,{_prefix:function(key){return this.prefix+key},_ttlKey:function(key){return this._prefix(key)+this.ttlKey},_noop:function(){this.get=this.set=this.remove=this.clear=this.isExpired=_.noop},_safeSet:function(key,val){try{this.ls.setItem(key,val)}catch(err){if(err.name==="QuotaExceededError"){this.clear();this._noop()}}},get:function(key){if(this.isExpired(key)){this.remove(key)}
return decode(this.ls.getItem(this._prefix(key)))},set:function(key,val,ttl){if(_.isNumber(ttl)){this._safeSet(this._ttlKey(key),encode(now()+ttl))}else{this.ls.removeItem(this._ttlKey(key))}
return this._safeSet(this._prefix(key),encode(val))},remove:function(key){this.ls.removeItem(this._ttlKey(key));this.ls.removeItem(this._prefix(key));return this},clear:function(){var i,keys=gatherMatchingKeys(this.keyMatcher);for(i=keys.length;i--;){this.remove(keys[i])}
return this},isExpired:function(key){var ttl=decode(this.ls.getItem(this._ttlKey(key)));return _.isNumber(ttl)&&now()>ttl?!0:!1}});return PersistentStorage;function now(){return new Date().getTime()}
function encode(val){return JSON.stringify(_.isUndefined(val)?null:val)}
function decode(val){return $.parseJSON(val)}
function gatherMatchingKeys(keyMatcher){var i,key,keys=[],len=LOCAL_STORAGE.length;for(i=0;i<len;i++){if((key=LOCAL_STORAGE.key(i)).match(keyMatcher)){keys.push(key.replace(keyMatcher,""))}}
return keys}}();var Transport=function(){"use strict";var pendingRequestsCount=0,pendingRequests={},maxPendingRequests=6,sharedCache=new LruCache(10);function Transport(o){o=o||{};this.cancelled=!1;this.lastReq=null;this._send=o.transport;this._get=o.limiter?o.limiter(this._get):this._get;this._cache=o.cache===!1?new LruCache(0):sharedCache}
Transport.setMaxPendingRequests=function setMaxPendingRequests(num){maxPendingRequests=num};Transport.resetCache=function resetCache(){sharedCache.reset()};_.mixin(Transport.prototype,{_fingerprint:function fingerprint(o){o=o||{};return o.url+o.type+$.param(o.data||{})},_get:function(o,cb){var that=this,fingerprint,jqXhr;fingerprint=this._fingerprint(o);if(this.cancelled||fingerprint!==this.lastReq){return}
if(jqXhr=pendingRequests[fingerprint]){jqXhr.done(done).fail(fail)}else if(pendingRequestsCount<maxPendingRequests){pendingRequestsCount++;pendingRequests[fingerprint]=this._send(o).done(done).fail(fail).always(always)}else{this.onDeckRequestArgs=[].slice.call(arguments,0)}
function done(resp){cb(null,resp);that._cache.set(fingerprint,resp)}
function fail(){cb(!0)}
function always(){pendingRequestsCount--;delete pendingRequests[fingerprint];if(that.onDeckRequestArgs){that._get.apply(that,that.onDeckRequestArgs);that.onDeckRequestArgs=null}}},get:function(o,cb){var resp,fingerprint;cb=cb||$.noop;o=_.isString(o)?{url:o}:o||{};fingerprint=this._fingerprint(o);this.cancelled=!1;this.lastReq=fingerprint;if(resp=this._cache.get(fingerprint)){cb(null,resp)}else{this._get(o,cb)}},cancel:function(){this.cancelled=!0}});return Transport}();var SearchIndex=window.SearchIndex=function(){"use strict";var CHILDREN="c",IDS="i";function SearchIndex(o){o=o||{};if(!o.datumTokenizer||!o.queryTokenizer){$.error("datumTokenizer and queryTokenizer are both required")}
this.identify=o.identify||_.stringify;this.datumTokenizer=o.datumTokenizer;this.queryTokenizer=o.queryTokenizer;this.reset()}
_.mixin(SearchIndex.prototype,{bootstrap:function bootstrap(o){this.datums=o.datums;this.trie=o.trie},add:function(data){var that=this;data=_.isArray(data)?data:[data];_.each(data,function(datum){var id,tokens;that.datums[id=that.identify(datum)]=datum;tokens=normalizeTokens(that.datumTokenizer(datum));_.each(tokens,function(token){var node,chars,ch;node=that.trie;chars=token.split("");while(ch=chars.shift()){node=node[CHILDREN][ch]||(node[CHILDREN][ch]=newNode());node[IDS].push(id)}})})},get:function get(ids){var that=this;return _.map(ids,function(id){return that.datums[id]})},search:function search(query){var that=this,tokens,matches;tokens=normalizeTokens(this.queryTokenizer(query));_.each(tokens,function(token){var node,chars,ch,ids;if(matches&&matches.length===0){return!1}
node=that.trie;chars=token.split("");while(node&&(ch=chars.shift())){node=node[CHILDREN][ch]}
if(node&&chars.length===0){ids=node[IDS].slice(0);matches=matches?getIntersection(matches,ids):ids}else{matches=[];return!1}});return matches?_.map(unique(matches),function(id){return that.datums[id]}):[]},all:function all(){var values=[];for(var key in this.datums){values.push(this.datums[key])}
return values},reset:function reset(){this.datums={};this.trie=newNode()},serialize:function serialize(){return{datums:this.datums,trie:this.trie}}});return SearchIndex;function normalizeTokens(tokens){tokens=_.filter(tokens,function(token){return!!token});tokens=_.map(tokens,function(token){return token.toLowerCase()});return tokens}
function newNode(){var node={};node[IDS]=[];node[CHILDREN]={};return node}
function unique(array){var seen={},uniques=[];for(var i=0,len=array.length;i<len;i++){if(!seen[array[i]]){seen[array[i]]=!0;uniques.push(array[i])}}
return uniques}
function getIntersection(arrayA,arrayB){var ai=0,bi=0,intersection=[];arrayA=arrayA.sort();arrayB=arrayB.sort();var lenArrayA=arrayA.length,lenArrayB=arrayB.length;while(ai<lenArrayA&&bi<lenArrayB){if(arrayA[ai]<arrayB[bi]){ai++}else if(arrayA[ai]>arrayB[bi]){bi++}else{intersection.push(arrayA[ai]);ai++;bi++}}
return intersection}}();var Prefetch=function(){"use strict";var keys;keys={data:"data",protocol:"protocol",thumbprint:"thumbprint"};function Prefetch(o){this.url=o.url;this.ttl=o.ttl;this.cache=o.cache;this.prepare=o.prepare;this.transform=o.transform;this.transport=o.transport;this.thumbprint=o.thumbprint;this.storage=new PersistentStorage(o.cacheKey)}
_.mixin(Prefetch.prototype,{_settings:function settings(){return{url:this.url,type:"GET",dataType:"json"}},store:function store(data){if(!this.cache){return}
this.storage.set(keys.data,data,this.ttl);this.storage.set(keys.protocol,location.protocol,this.ttl);this.storage.set(keys.thumbprint,this.thumbprint,this.ttl)},fromCache:function fromCache(){var stored={},isExpired;if(!this.cache){return null}
stored.data=this.storage.get(keys.data);stored.protocol=this.storage.get(keys.protocol);stored.thumbprint=this.storage.get(keys.thumbprint);isExpired=stored.thumbprint!==this.thumbprint||stored.protocol!==location.protocol;return stored.data&&!isExpired?stored.data:null},fromNetwork:function(cb){var that=this,settings;if(!cb){return}
settings=this.prepare(this._settings());this.transport(settings).fail(onError).done(onResponse);function onError(){cb(!0)}
function onResponse(resp){cb(null,that.transform(resp))}},clear:function clear(){this.storage.clear();return this}});return Prefetch}();var Remote=function(){"use strict";function Remote(o){this.url=o.url;this.prepare=o.prepare;this.transform=o.transform;this.transport=new Transport({cache:o.cache,limiter:o.limiter,transport:o.transport})}
_.mixin(Remote.prototype,{_settings:function settings(){return{url:this.url,type:"GET",dataType:"json"}},get:function get(query,cb){var that=this,settings;if(!cb){return}
query=query||"";settings=this.prepare(query,this._settings());return this.transport.get(settings,onResponse);function onResponse(err,resp){err?cb([]):cb(that.transform(resp))}},cancelLastRequest:function cancelLastRequest(){this.transport.cancel()}});return Remote}();var oParser=function(){"use strict";return function parse(o){var defaults,sorter;defaults={initialize:!0,identify:_.stringify,datumTokenizer:null,queryTokenizer:null,sufficient:5,sorter:null,local:[],prefetch:null,remote:null};o=_.mixin(defaults,o||{});!o.datumTokenizer&&$.error("datumTokenizer is required");!o.queryTokenizer&&$.error("queryTokenizer is required");sorter=o.sorter;o.sorter=sorter?function(x){return x.sort(sorter)}:_.identity;o.local=_.isFunction(o.local)?o.local():o.local;o.prefetch=parsePrefetch(o.prefetch);o.remote=parseRemote(o.remote);return o};function parsePrefetch(o){var defaults;if(!o){return null}
defaults={url:null,ttl:24*60*60*1e3,cache:!0,cacheKey:null,thumbprint:"",prepare:_.identity,transform:_.identity,transport:null};o=_.isString(o)?{url:o}:o;o=_.mixin(defaults,o);!o.url&&$.error("prefetch requires url to be set");o.transform=o.filter||o.transform;o.cacheKey=o.cacheKey||o.url;o.thumbprint=VERSION+o.thumbprint;o.transport=o.transport?callbackToDeferred(o.transport):$.ajax;return o}
function parseRemote(o){var defaults;if(!o){return}
defaults={url:null,cache:!0,prepare:null,replace:null,wildcard:null,limiter:null,rateLimitBy:"debounce",rateLimitWait:300,transform:_.identity,transport:null};o=_.isString(o)?{url:o}:o;o=_.mixin(defaults,o);!o.url&&$.error("remote requires url to be set");o.transform=o.filter||o.transform;o.prepare=toRemotePrepare(o);o.limiter=toLimiter(o);o.transport=o.transport?callbackToDeferred(o.transport):$.ajax;delete o.replace;delete o.wildcard;delete o.rateLimitBy;delete o.rateLimitWait;return o}
function toRemotePrepare(o){var prepare,replace,wildcard;prepare=o.prepare;replace=o.replace;wildcard=o.wildcard;if(prepare){return prepare}
if(replace){prepare=prepareByReplace}else if(o.wildcard){prepare=prepareByWildcard}else{prepare=idenityPrepare}
return prepare;function prepareByReplace(query,settings){settings.url=replace(settings.url,query);return settings}
function prepareByWildcard(query,settings){settings.url=settings.url.replace(wildcard,encodeURIComponent(query));return settings}
function idenityPrepare(query,settings){return settings}}
function toLimiter(o){var limiter,method,wait;limiter=o.limiter;method=o.rateLimitBy;wait=o.rateLimitWait;if(!limiter){limiter=/^throttle$/i.test(method)?throttle(wait):debounce(wait)}
return limiter;function debounce(wait){return function debounce(fn){return _.debounce(fn,wait)}}
function throttle(wait){return function throttle(fn){return _.throttle(fn,wait)}}}
function callbackToDeferred(fn){return function wrapper(o){var deferred=$.Deferred();fn(o,onSuccess,onError);return deferred;function onSuccess(resp){_.defer(function(){deferred.resolve(resp)})}
function onError(err){_.defer(function(){deferred.reject(err)})}}}}();var Bloodhound=function(){"use strict";var old;old=window&&window.Bloodhound;function Bloodhound(o){o=oParser(o);this.sorter=o.sorter;this.identify=o.identify;this.sufficient=o.sufficient;this.local=o.local;this.remote=o.remote?new Remote(o.remote):null;this.prefetch=o.prefetch?new Prefetch(o.prefetch):null;this.index=new SearchIndex({identify:this.identify,datumTokenizer:o.datumTokenizer,queryTokenizer:o.queryTokenizer});o.initialize!==!1&&this.initialize()}
Bloodhound.noConflict=function noConflict(){window&&(window.Bloodhound=old);return Bloodhound};Bloodhound.tokenizers=tokenizers;_.mixin(Bloodhound.prototype,{__ttAdapter:function ttAdapter(){var that=this;return this.remote?withAsync:withoutAsync;function withAsync(query,sync,async){return that.search(query,sync,async)}
function withoutAsync(query,sync){return that.search(query,sync)}},_loadPrefetch:function loadPrefetch(){var that=this,deferred,serialized;deferred=$.Deferred();if(!this.prefetch){deferred.resolve()}else if(serialized=this.prefetch.fromCache()){this.index.bootstrap(serialized);deferred.resolve()}else{this.prefetch.fromNetwork(done)}
return deferred.promise();function done(err,data){if(err){return deferred.reject()}
that.add(data);that.prefetch.store(that.index.serialize());deferred.resolve()}},_initialize:function initialize(){var that=this,deferred;this.clear();(this.initPromise=this._loadPrefetch()).done(addLocalToIndex);return this.initPromise;function addLocalToIndex(){that.add(that.local)}},initialize:function initialize(force){return!this.initPromise||force?this._initialize():this.initPromise},add:function add(data){this.index.add(data);return this},get:function get(ids){ids=_.isArray(ids)?ids:[].slice.call(arguments);return this.index.get(ids)},search:function search(query,sync,async){var that=this,local;local=this.sorter(this.index.search(query));sync(this.remote?local.slice():local);if(this.remote&&local.length<this.sufficient){this.remote.get(query,processRemote)}else if(this.remote){this.remote.cancelLastRequest()}
return this;function processRemote(remote){var nonDuplicates=[];_.each(remote,function(r){!_.some(local,function(l){return that.identify(r)===that.identify(l)})&&nonDuplicates.push(r)});async&&async(nonDuplicates)}},all:function all(){return this.index.all()},clear:function clear(){this.index.reset();return this},clearPrefetchCache:function clearPrefetchCache(){this.prefetch&&this.prefetch.clear();return this},clearRemoteCache:function clearRemoteCache(){Transport.resetCache();return this},ttAdapter:function ttAdapter(){return this.__ttAdapter()}});return Bloodhound}();return Bloodhound});(function(root,factory){if(typeof define==="function"&&define.amd){define("typeahead.js",["jquery"],function(a0){return factory(a0)})}else if(typeof exports==="object"){module.exports=factory(require("jquery"))}else{factory(jQuery)}})(this,function($){var _=function(){"use strict";return{isMsie:function(){return/(msie|trident)/i.test(navigator.userAgent)?navigator.userAgent.match(/(msie |rv:)(\d+(.\d+)?)/i)[2]:!1},isBlankString:function(str){return!str||/^\s*$/.test(str)},escapeRegExChars:function(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")},isString:function(obj){return typeof obj==="string"},isNumber:function(obj){return typeof obj==="number"},isArray:$.isArray,isFunction:$.isFunction,isObject:$.isPlainObject,isUndefined:function(obj){return typeof obj==="undefined"},isElement:function(obj){return!!(obj&&obj.nodeType===1)},isJQuery:function(obj){return obj instanceof $},toStr:function toStr(s){return _.isUndefined(s)||s===null?"":s+""},bind:$.proxy,each:function(collection,cb){$.each(collection,reverseArgs);function reverseArgs(index,value){return cb(value,index)}},map:$.map,filter:$.grep,every:function(obj,test){var result=!0;if(!obj){return result}
$.each(obj,function(key,val){if(!(result=test.call(null,val,key,obj))){return!1}});return!!result},some:function(obj,test){var result=!1;if(!obj){return result}
$.each(obj,function(key,val){if(result=test.call(null,val,key,obj)){return!1}});return!!result},mixin:$.extend,identity:function(x){return x},clone:function(obj){return $.extend(!0,{},obj)},getIdGenerator:function(){var counter=0;return function(){return counter++}},templatify:function templatify(obj){return $.isFunction(obj)?obj:template;function template(){return String(obj)}},defer:function(fn){setTimeout(fn,0)},debounce:function(func,wait,immediate){var timeout,result;return function(){var context=this,args=arguments,later,callNow;later=function(){timeout=null;if(!immediate){result=func.apply(context,args)}};callNow=immediate&&!timeout;clearTimeout(timeout);timeout=setTimeout(later,wait);if(callNow){result=func.apply(context,args)}
return result}},throttle:function(func,wait){var context,args,timeout,result,previous,later;previous=0;later=function(){previous=new Date();timeout=null;result=func.apply(context,args)};return function(){var now=new Date(),remaining=wait-(now-previous);context=this;args=arguments;if(remaining<=0){clearTimeout(timeout);timeout=null;previous=now;result=func.apply(context,args)}else if(!timeout){timeout=setTimeout(later,remaining)}
return result}},stringify:function(val){return _.isString(val)?val:JSON.stringify(val)},noop:function(){}}}();var WWW=function(){"use strict";var defaultClassNames={wrapper:"twitter-typeahead",input:"tt-input",hint:"tt-hint",menu:"tt-menu",dataset:"tt-dataset",suggestion:"tt-suggestion",selectable:"tt-selectable",empty:"tt-empty",open:"tt-open",cursor:"tt-cursor",highlight:"tt-highlight"};return build;function build(o){var www,classes;classes=_.mixin({},defaultClassNames,o);www={css:buildCss(),classes:classes,html:buildHtml(classes),selectors:buildSelectors(classes)};return{css:www.css,html:www.html,classes:www.classes,selectors:www.selectors,mixin:function(o){_.mixin(o,www)}}}
function buildHtml(c){return{wrapper:'<span class="'+c.wrapper+'"></span>',menu:'<div class="'+c.menu+'"></div>'}}
function buildSelectors(classes){var selectors={};_.each(classes,function(v,k){selectors[k]="."+v});return selectors}
function buildCss(){var css={wrapper:{position:"relative",display:"inline-block"},hint:{position:"absolute",top:"0",left:"0",borderColor:"transparent",boxShadow:"none",opacity:"1"},input:{position:"relative",verticalAlign:"top",backgroundColor:"transparent"},inputWithNoHint:{position:"relative",verticalAlign:"top"},menu:{position:"absolute",top:"100%",left:"0",zIndex:"100",display:"none"},ltr:{left:"0",right:"auto"},rtl:{left:"auto",right:" 0"}};if(_.isMsie()){_.mixin(css.input,{backgroundImage:"url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)"})}
return css}}();var EventBus=function(){"use strict";var namespace,deprecationMap;namespace="typeahead:";deprecationMap={render:"rendered",cursorchange:"cursorchanged",select:"selected",autocomplete:"autocompleted"};function EventBus(o){if(!o||!o.el){$.error("EventBus initialized without el")}
this.$el=$(o.el)}
_.mixin(EventBus.prototype,{_trigger:function(type,args){var $e;$e=$.Event(namespace+type);(args=args||[]).unshift($e);this.$el.trigger.apply(this.$el,args);return $e},before:function(type){var args,$e;args=[].slice.call(arguments,1);$e=this._trigger("before"+type,args);return $e.isDefaultPrevented()},trigger:function(type){var deprecatedType;this._trigger(type,[].slice.call(arguments,1));if(deprecatedType=deprecationMap[type]){this._trigger(deprecatedType,[].slice.call(arguments,1))}}});return EventBus}();var EventEmitter=function(){"use strict";var splitter=/\s+/,nextTick=getNextTick();return{onSync:onSync,onAsync:onAsync,off:off,trigger:trigger};function on(method,types,cb,context){var type;if(!cb){return this}
types=types.split(splitter);cb=context?bindContext(cb,context):cb;this._callbacks=this._callbacks||{};while(type=types.shift()){this._callbacks[type]=this._callbacks[type]||{sync:[],async:[]};this._callbacks[type][method].push(cb)}
return this}
function onAsync(types,cb,context){return on.call(this,"async",types,cb,context)}
function onSync(types,cb,context){return on.call(this,"sync",types,cb,context)}
function off(types){var type;if(!this._callbacks){return this}
types=types.split(splitter);while(type=types.shift()){delete this._callbacks[type]}
return this}
function trigger(types){var type,callbacks,args,syncFlush,asyncFlush;if(!this._callbacks){return this}
types=types.split(splitter);args=[].slice.call(arguments,1);while((type=types.shift())&&(callbacks=this._callbacks[type])){syncFlush=getFlush(callbacks.sync,this,[type].concat(args));asyncFlush=getFlush(callbacks.async,this,[type].concat(args));syncFlush()&&nextTick(asyncFlush)}
return this}
function getFlush(callbacks,context,args){return flush;function flush(){var cancelled;for(var i=0,len=callbacks.length;!cancelled&&i<len;i+=1){cancelled=callbacks[i].apply(context,args)===!1}
return!cancelled}}
function getNextTick(){var nextTickFn;if(window.setImmediate){nextTickFn=function nextTickSetImmediate(fn){setImmediate(function(){fn()})}}else{nextTickFn=function nextTickSetTimeout(fn){setTimeout(function(){fn()},0)}}
return nextTickFn}
function bindContext(fn,context){return fn.bind?fn.bind(context):function(){fn.apply(context,[].slice.call(arguments,0))}}}();var highlight=function(doc){"use strict";var defaults={node:null,pattern:null,tagName:"strong",className:null,wordsOnly:!1,caseSensitive:!1};return function hightlight(o){var regex;o=_.mixin({},defaults,o);if(!o.node||!o.pattern){return}
o.pattern=_.isArray(o.pattern)?o.pattern:[o.pattern];regex=getRegex(o.pattern,o.caseSensitive,o.wordsOnly);traverse(o.node,hightlightTextNode);function hightlightTextNode(textNode){var match,patternNode,wrapperNode;if(match=regex.exec(textNode.data)){wrapperNode=doc.createElement(o.tagName);o.className&&(wrapperNode.className=o.className);patternNode=textNode.splitText(match.index);patternNode.splitText(match[0].length);wrapperNode.appendChild(patternNode.cloneNode(!0));textNode.parentNode.replaceChild(wrapperNode,patternNode)}
return!!match}
function traverse(el,hightlightTextNode){var childNode,TEXT_NODE_TYPE=3;for(var i=0;i<el.childNodes.length;i++){childNode=el.childNodes[i];if(childNode.nodeType===TEXT_NODE_TYPE){i+=hightlightTextNode(childNode)?1:0}else{traverse(childNode,hightlightTextNode)}}}};function getRegex(patterns,caseSensitive,wordsOnly){var escapedPatterns=[],regexStr;for(var i=0,len=patterns.length;i<len;i++){escapedPatterns.push(_.escapeRegExChars(patterns[i]))}
regexStr=wordsOnly?"\\b("+escapedPatterns.join("|")+")\\b":"("+escapedPatterns.join("|")+")";return caseSensitive?new RegExp(regexStr):new RegExp(regexStr,"i")}}(window.document);var Input=function(){"use strict";var specialKeyCodeMap;specialKeyCodeMap={9:"tab",27:"esc",37:"left",39:"right",13:"enter",38:"up",40:"down"};function Input(o,www){o=o||{};if(!o.input){$.error("input is missing")}
www.mixin(this);this.$hint=$(o.hint);this.$input=$(o.input);this.query=this.$input.val();this.queryWhenFocused=this.hasFocus()?this.query:null;this.$overflowHelper=buildOverflowHelper(this.$input);this._checkLanguageDirection();if(this.$hint.length===0){this.setHint=this.getHint=this.clearHint=this.clearHintIfInvalid=_.noop}}
Input.normalizeQuery=function(str){return _.toStr(str).replace(/^\s*/g,"").replace(/\s{2,}/g," ")};_.mixin(Input.prototype,EventEmitter,{_onBlur:function onBlur(){this.resetInputValue();this.trigger("blurred")},_onFocus:function onFocus(){this.queryWhenFocused=this.query;this.trigger("focused")},_onKeydown:function onKeydown($e){var keyName=specialKeyCodeMap[$e.which||$e.keyCode];this._managePreventDefault(keyName,$e);if(keyName&&this._shouldTrigger(keyName,$e)){this.trigger(keyName+"Keyed",$e)}},_onInput:function onInput(){this._setQuery(this.getInputValue());this.clearHintIfInvalid();this._checkLanguageDirection()},_managePreventDefault:function managePreventDefault(keyName,$e){var preventDefault;switch(keyName){case "up":case "down":preventDefault=!withModifier($e);break;default:preventDefault=!1}
preventDefault&&$e.preventDefault()},_shouldTrigger:function shouldTrigger(keyName,$e){var trigger;switch(keyName){case "tab":trigger=!withModifier($e);break;default:trigger=!0}
return trigger},_checkLanguageDirection:function checkLanguageDirection(){var dir=(this.$input.css("direction")||"ltr").toLowerCase();if(this.dir!==dir){this.dir=dir;this.$hint.attr("dir",dir);this.trigger("langDirChanged",dir)}},_setQuery:function setQuery(val,silent){var areEquivalent,hasDifferentWhitespace;areEquivalent=areQueriesEquivalent(val,this.query);hasDifferentWhitespace=areEquivalent?this.query.length!==val.length:!1;this.query=val;if(!silent&&!areEquivalent){this.trigger("queryChanged",this.query)}else if(!silent&&hasDifferentWhitespace){this.trigger("whitespaceChanged",this.query)}},bind:function(){var that=this,onBlur,onFocus,onKeydown,onInput;onBlur=_.bind(this._onBlur,this);onFocus=_.bind(this._onFocus,this);onKeydown=_.bind(this._onKeydown,this);onInput=_.bind(this._onInput,this);this.$input.on("blur.tt",onBlur).on("focus.tt",onFocus).on("keydown.tt",onKeydown);if(!_.isMsie()||_.isMsie()>9){this.$input.on("input.tt",onInput)}else{this.$input.on("keydown.tt keypress.tt cut.tt paste.tt",function($e){if(specialKeyCodeMap[$e.which||$e.keyCode]){return}
_.defer(_.bind(that._onInput,that,$e))})}
return this},focus:function focus(){this.$input.focus()},blur:function blur(){this.$input.blur()},getLangDir:function getLangDir(){return this.dir},getQuery:function getQuery(){return this.query||""},setQuery:function setQuery(val,silent){this.setInputValue(val);this._setQuery(val,silent)},hasQueryChangedSinceLastFocus:function hasQueryChangedSinceLastFocus(){return this.query!==this.queryWhenFocused},getInputValue:function getInputValue(){return this.$input.val()},setInputValue:function setInputValue(value){this.$input.val(value);this.clearHintIfInvalid();this._checkLanguageDirection()},resetInputValue:function resetInputValue(){this.setInputValue(this.query)},getHint:function getHint(){return this.$hint.val()},setHint:function setHint(value){this.$hint.val(value)},clearHint:function clearHint(){this.setHint("")},clearHintIfInvalid:function clearHintIfInvalid(){var val,hint,valIsPrefixOfHint,isValid;val=this.getInputValue();hint=this.getHint();valIsPrefixOfHint=val!==hint&&hint.indexOf(val)===0;isValid=val!==""&&valIsPrefixOfHint&&!this.hasOverflow();!isValid&&this.clearHint()},hasFocus:function hasFocus(){return this.$input.is(":focus")},hasOverflow:function hasOverflow(){var constraint=this.$input.width()-2;this.$overflowHelper.text(this.getInputValue());return this.$overflowHelper.width()>=constraint},isCursorAtEnd:function(){var valueLength,selectionStart,range;valueLength=this.$input.val().length;selectionStart=this.$input[0].selectionStart;if(_.isNumber(selectionStart)){return selectionStart===valueLength}else if(document.selection){range=document.selection.createRange();range.moveStart("character",-valueLength);return valueLength===range.text.length}
return!0},destroy:function destroy(){this.$hint.off(".tt");this.$input.off(".tt");this.$overflowHelper.remove();this.$hint=this.$input=this.$overflowHelper=$("<div>")}});return Input;function buildOverflowHelper($input){return $('<pre aria-hidden="true"></pre>').css({position:"absolute",visibility:"hidden",whiteSpace:"pre",fontFamily:$input.css("font-family"),fontSize:$input.css("font-size"),fontStyle:$input.css("font-style"),fontVariant:$input.css("font-variant"),fontWeight:$input.css("font-weight"),wordSpacing:$input.css("word-spacing"),letterSpacing:$input.css("letter-spacing"),textIndent:$input.css("text-indent"),textRendering:$input.css("text-rendering"),textTransform:$input.css("text-transform")}).insertAfter($input)}
function areQueriesEquivalent(a,b){return Input.normalizeQuery(a)===Input.normalizeQuery(b)}
function withModifier($e){return $e.altKey||$e.ctrlKey||$e.metaKey||$e.shiftKey}}();var Dataset=function(){"use strict";var keys,nameGenerator;keys={val:"tt-selectable-display",obj:"tt-selectable-object"};nameGenerator=_.getIdGenerator();function Dataset(o,www){o=o||{};o.templates=o.templates||{};o.templates.notFound=o.templates.notFound||o.templates.empty;if(!o.source){$.error("missing source")}
if(!o.node){$.error("missing node")}
if(o.name&&!isValidName(o.name)){$.error("invalid dataset name: "+o.name)}
www.mixin(this);this.highlight=!!o.highlight;this.name=o.name||nameGenerator();this.limit=o.limit||5;this.displayFn=getDisplayFn(o.display||o.displayKey);this.templates=getTemplates(o.templates,this.displayFn);this.source=o.source.__ttAdapter?o.source.__ttAdapter():o.source;this.async=_.isUndefined(o.async)?this.source.length>2:!!o.async;this._resetLastSuggestion();this.$el=$(o.node).addClass(this.classes.dataset).addClass(this.classes.dataset+"-"+this.name)}
Dataset.extractData=function extractData(el){var $el=$(el);if($el.data(keys.obj)){return{val:$el.data(keys.val)||"",obj:$el.data(keys.obj)||null}}
return null};_.mixin(Dataset.prototype,EventEmitter,{_overwrite:function overwrite(query,suggestions){suggestions=suggestions||[];if(suggestions.length){this._renderSuggestions(query,suggestions)}else if(this.async&&this.templates.pending){this._renderPending(query)}else if(!this.async&&this.templates.notFound){this._renderNotFound(query)}else{this._empty()}
this.trigger("rendered",this.name,suggestions,!1)},_append:function append(query,suggestions){suggestions=suggestions||[];if(suggestions.length&&this.$lastSuggestion.length){this._appendSuggestions(query,suggestions)}else if(suggestions.length){this._renderSuggestions(query,suggestions)}else if(!this.$lastSuggestion.length&&this.templates.notFound){this._renderNotFound(query)}
this.trigger("rendered",this.name,suggestions,!0)},_renderSuggestions:function renderSuggestions(query,suggestions){var $fragment;$fragment=this._getSuggestionsFragment(query,suggestions);this.$lastSuggestion=$fragment.children().last();this.$el.html($fragment).prepend(this._getHeader(query,suggestions)).append(this._getFooter(query,suggestions))},_appendSuggestions:function appendSuggestions(query,suggestions){var $fragment,$lastSuggestion;$fragment=this._getSuggestionsFragment(query,suggestions);$lastSuggestion=$fragment.children().last();this.$lastSuggestion.after($fragment);this.$lastSuggestion=$lastSuggestion},_renderPending:function renderPending(query){var template=this.templates.pending;this._resetLastSuggestion();template&&this.$el.html(template({query:query,dataset:this.name}))},_renderNotFound:function renderNotFound(query){var template=this.templates.notFound;this._resetLastSuggestion();template&&this.$el.html(template({query:query,dataset:this.name}))},_empty:function empty(){this.$el.empty();this._resetLastSuggestion()},_getSuggestionsFragment:function getSuggestionsFragment(query,suggestions){var that=this,fragment;fragment=document.createDocumentFragment();_.each(suggestions,function getSuggestionNode(suggestion){var $el,context;context=that._injectQuery(query,suggestion);$el=$(that.templates.suggestion(context)).data(keys.obj,suggestion).data(keys.val,that.displayFn(suggestion)).addClass(that.classes.suggestion+" "+that.classes.selectable);fragment.appendChild($el[0])});this.highlight&&highlight({className:this.classes.highlight,node:fragment,pattern:query});return $(fragment)},_getFooter:function getFooter(query,suggestions){return this.templates.footer?this.templates.footer({query:query,suggestions:suggestions,dataset:this.name}):null},_getHeader:function getHeader(query,suggestions){return this.templates.header?this.templates.header({query:query,suggestions:suggestions,dataset:this.name}):null},_resetLastSuggestion:function resetLastSuggestion(){this.$lastSuggestion=$()},_injectQuery:function injectQuery(query,obj){return _.isObject(obj)?_.mixin({_query:query},obj):obj},update:function update(query){var that=this,canceled=!1,syncCalled=!1,rendered=0;this.cancel();this.cancel=function cancel(){canceled=!0;that.cancel=$.noop;that.async&&that.trigger("asyncCanceled",query)};this.source(query,sync,async);!syncCalled&&sync([]);function sync(suggestions){if(syncCalled){return}
syncCalled=!0;suggestions=(suggestions||[]).slice(0,that.limit);rendered=suggestions.length;that._overwrite(query,suggestions);if(rendered<that.limit&&that.async){that.trigger("asyncRequested",query)}}
function async(suggestions){suggestions=suggestions||[];if(!canceled&&rendered<that.limit){that.cancel=$.noop;rendered+=suggestions.length;that._append(query,suggestions.slice(0,that.limit-rendered));that.async&&that.trigger("asyncReceived",query)}}},cancel:$.noop,clear:function clear(){this._empty();this.cancel();this.trigger("cleared")},isEmpty:function isEmpty(){return this.$el.is(":empty")},destroy:function destroy(){this.$el=$("<div>")}});return Dataset;function getDisplayFn(display){display=display||_.stringify;return _.isFunction(display)?display:displayFn;function displayFn(obj){return obj[display]}}
function getTemplates(templates,displayFn){return{notFound:templates.notFound&&_.templatify(templates.notFound),pending:templates.pending&&_.templatify(templates.pending),header:templates.header&&_.templatify(templates.header),footer:templates.footer&&_.templatify(templates.footer),suggestion:templates.suggestion||suggestionTemplate};function suggestionTemplate(context){return $("<div>").text(displayFn(context))}}
function isValidName(str){return/^[_a-zA-Z0-9-]+$/.test(str)}}();var Menu=function(){"use strict";function Menu(o,www){var that=this;o=o||{};if(!o.node){$.error("node is required")}
www.mixin(this);this.$node=$(o.node);this.query=null;this.datasets=_.map(o.datasets,initializeDataset);function initializeDataset(oDataset){var node=that.$node.find(oDataset.node).first();oDataset.node=node.length?node:$("<div>").appendTo(that.$node);return new Dataset(oDataset,www)}}
_.mixin(Menu.prototype,EventEmitter,{_onSelectableClick:function onSelectableClick($e){this.trigger("selectableClicked",$($e.currentTarget))},_onRendered:function onRendered(type,dataset,suggestions,async){this.$node.toggleClass(this.classes.empty,this._allDatasetsEmpty());this.trigger("datasetRendered",dataset,suggestions,async)},_onCleared:function onCleared(){this.$node.toggleClass(this.classes.empty,this._allDatasetsEmpty());this.trigger("datasetCleared")},_propagate:function propagate(){this.trigger.apply(this,arguments)},_allDatasetsEmpty:function allDatasetsEmpty(){return _.every(this.datasets,isDatasetEmpty);function isDatasetEmpty(dataset){return dataset.isEmpty()}},_getSelectables:function getSelectables(){return this.$node.find(this.selectors.selectable)},_removeCursor:function _removeCursor(){var $selectable=this.getActiveSelectable();$selectable&&$selectable.removeClass(this.classes.cursor)},_ensureVisible:function ensureVisible($el){var elTop,elBottom,nodeScrollTop,nodeHeight;elTop=$el.position().top;elBottom=elTop+$el.outerHeight(!0);nodeScrollTop=this.$node.scrollTop();nodeHeight=this.$node.height()+parseInt(this.$node.css("paddingTop"),10)+parseInt(this.$node.css("paddingBottom"),10);if(elTop<0){this.$node.scrollTop(nodeScrollTop+elTop)}else if(nodeHeight<elBottom){this.$node.scrollTop(nodeScrollTop+(elBottom-nodeHeight))}},bind:function(){var that=this,onSelectableClick;onSelectableClick=_.bind(this._onSelectableClick,this);this.$node.on("click.tt",this.selectors.selectable,onSelectableClick);_.each(this.datasets,function(dataset){dataset.onSync("asyncRequested",that._propagate,that).onSync("asyncCanceled",that._propagate,that).onSync("asyncReceived",that._propagate,that).onSync("rendered",that._onRendered,that).onSync("cleared",that._onCleared,that)});return this},isOpen:function isOpen(){return this.$node.hasClass(this.classes.open)},open:function open(){this.$node.addClass(this.classes.open)},close:function close(){this.$node.removeClass(this.classes.open);this._removeCursor()},setLanguageDirection:function setLanguageDirection(dir){this.$node.attr("dir",dir)},selectableRelativeToCursor:function selectableRelativeToCursor(delta){var $selectables,$oldCursor,oldIndex,newIndex;$oldCursor=this.getActiveSelectable();$selectables=this._getSelectables();oldIndex=$oldCursor?$selectables.index($oldCursor):-1;newIndex=oldIndex+delta;newIndex=(newIndex+1)%($selectables.length+1)-1;newIndex=newIndex<-1?$selectables.length-1:newIndex;return newIndex===-1?null:$selectables.eq(newIndex)},setCursor:function setCursor($selectable){this._removeCursor();if($selectable=$selectable&&$selectable.first()){$selectable.addClass(this.classes.cursor);this._ensureVisible($selectable)}},getSelectableData:function getSelectableData($el){return $el&&$el.length?Dataset.extractData($el):null},getActiveSelectable:function getActiveSelectable(){var $selectable=this._getSelectables().filter(this.selectors.cursor).first();return $selectable.length?$selectable:null},getTopSelectable:function getTopSelectable(){var $selectable=this._getSelectables().first();return $selectable.length?$selectable:null},update:function update(query){var isValidUpdate=query!==this.query;if(isValidUpdate){this.query=query;_.each(this.datasets,updateDataset)}
return isValidUpdate;function updateDataset(dataset){dataset.update(query)}},empty:function empty(){_.each(this.datasets,clearDataset);this.query=null;this.$node.addClass(this.classes.empty);function clearDataset(dataset){dataset.clear()}},destroy:function destroy(){this.$node.off(".tt");this.$node=$("<div>");_.each(this.datasets,destroyDataset);function destroyDataset(dataset){dataset.destroy()}}});return Menu}();var DefaultMenu=function(){"use strict";var s=Menu.prototype;function DefaultMenu(){Menu.apply(this,[].slice.call(arguments,0))}
_.mixin(DefaultMenu.prototype,Menu.prototype,{open:function open(){!this._allDatasetsEmpty()&&this._show();return s.open.apply(this,[].slice.call(arguments,0))},close:function close(){this._hide();return s.close.apply(this,[].slice.call(arguments,0))},_onRendered:function onRendered(){if(this._allDatasetsEmpty()){this._hide()}else{this.isOpen()&&this._show()}
return s._onRendered.apply(this,[].slice.call(arguments,0))},_onCleared:function onCleared(){if(this._allDatasetsEmpty()){this._hide()}else{this.isOpen()&&this._show()}
return s._onCleared.apply(this,[].slice.call(arguments,0))},setLanguageDirection:function setLanguageDirection(dir){this.$node.css(dir==="ltr"?this.css.ltr:this.css.rtl);return s.setLanguageDirection.apply(this,[].slice.call(arguments,0))},_hide:function hide(){this.$node.hide()},_show:function show(){this.$node.css("display","block")}});return DefaultMenu}();var Typeahead=function(){"use strict";function Typeahead(o,www){var onFocused,onBlurred,onEnterKeyed,onTabKeyed,onEscKeyed,onUpKeyed,onDownKeyed,onLeftKeyed,onRightKeyed,onQueryChanged,onWhitespaceChanged;o=o||{};if(!o.input){$.error("missing input")}
if(!o.menu){$.error("missing menu")}
if(!o.eventBus){$.error("missing event bus")}
www.mixin(this);this.eventBus=o.eventBus;this.minLength=_.isNumber(o.minLength)?o.minLength:1;this.input=o.input;this.menu=o.menu;this.enabled=!0;this.active=!1;this.input.hasFocus()&&this.activate();this.dir=this.input.getLangDir();this._hacks();this.menu.bind().onSync("selectableClicked",this._onSelectableClicked,this).onSync("asyncRequested",this._onAsyncRequested,this).onSync("asyncCanceled",this._onAsyncCanceled,this).onSync("asyncReceived",this._onAsyncReceived,this).onSync("datasetRendered",this._onDatasetRendered,this).onSync("datasetCleared",this._onDatasetCleared,this);onFocused=c(this,"activate","open","_onFocused");onBlurred=c(this,"deactivate","_onBlurred");onEnterKeyed=c(this,"isActive","isOpen","_onEnterKeyed");onTabKeyed=c(this,"isActive","isOpen","_onTabKeyed");onEscKeyed=c(this,"isActive","_onEscKeyed");onUpKeyed=c(this,"isActive","open","_onUpKeyed");onDownKeyed=c(this,"isActive","open","_onDownKeyed");onLeftKeyed=c(this,"isActive","isOpen","_onLeftKeyed");onRightKeyed=c(this,"isActive","isOpen","_onRightKeyed");onQueryChanged=c(this,"_openIfActive","_onQueryChanged");onWhitespaceChanged=c(this,"_openIfActive","_onWhitespaceChanged");this.input.bind().onSync("focused",onFocused,this).onSync("blurred",onBlurred,this).onSync("enterKeyed",onEnterKeyed,this).onSync("tabKeyed",onTabKeyed,this).onSync("escKeyed",onEscKeyed,this).onSync("upKeyed",onUpKeyed,this).onSync("downKeyed",onDownKeyed,this).onSync("leftKeyed",onLeftKeyed,this).onSync("rightKeyed",onRightKeyed,this).onSync("queryChanged",onQueryChanged,this).onSync("whitespaceChanged",onWhitespaceChanged,this).onSync("langDirChanged",this._onLangDirChanged,this)}
_.mixin(Typeahead.prototype,{_hacks:function hacks(){var $input,$menu;$input=this.input.$input||$("<div>");$menu=this.menu.$node||$("<div>");$input.on("blur.tt",function($e){var active,isActive,hasActive;active=document.activeElement;isActive=$menu.is(active);hasActive=$menu.has(active).length>0;if(_.isMsie()&&(isActive||hasActive)){$e.preventDefault();$e.stopImmediatePropagation();_.defer(function(){$input.focus()})}});$menu.on("mousedown.tt",function($e){$e.preventDefault()})},_onSelectableClicked:function onSelectableClicked(type,$el){this.select($el)},_onDatasetCleared:function onDatasetCleared(){this._updateHint()},_onDatasetRendered:function onDatasetRendered(type,dataset,suggestions,async){this._updateHint();this.eventBus.trigger("render",suggestions,async,dataset)},_onAsyncRequested:function onAsyncRequested(type,dataset,query){this.eventBus.trigger("asyncrequest",query,dataset)},_onAsyncCanceled:function onAsyncCanceled(type,dataset,query){this.eventBus.trigger("asynccancel",query,dataset)},_onAsyncReceived:function onAsyncReceived(type,dataset,query){this.eventBus.trigger("asyncreceive",query,dataset)},_onFocused:function onFocused(){this._minLengthMet()&&this.menu.update(this.input.getQuery())},_onBlurred:function onBlurred(){if(this.input.hasQueryChangedSinceLastFocus()){this.eventBus.trigger("change",this.input.getQuery())}},_onEnterKeyed:function onEnterKeyed(type,$e){var $selectable;if($selectable=this.menu.getActiveSelectable()){this.select($selectable)&&$e.preventDefault()}},_onTabKeyed:function onTabKeyed(type,$e){var $selectable;if($selectable=this.menu.getActiveSelectable()){this.select($selectable)&&$e.preventDefault()}else if($selectable=this.menu.getTopSelectable()){this.autocomplete($selectable)&&$e.preventDefault()}},_onEscKeyed:function onEscKeyed(){this.close()},_onUpKeyed:function onUpKeyed(){this.moveCursor(-1)},_onDownKeyed:function onDownKeyed(){this.moveCursor(+1)},_onLeftKeyed:function onLeftKeyed(){if(this.dir==="rtl"&&this.input.isCursorAtEnd()){this.autocomplete(this.menu.getTopSelectable())}},_onRightKeyed:function onRightKeyed(){if(this.dir==="ltr"&&this.input.isCursorAtEnd()){this.autocomplete(this.menu.getTopSelectable())}},_onQueryChanged:function onQueryChanged(e,query){this._minLengthMet(query)?this.menu.update(query):this.menu.empty()},_onWhitespaceChanged:function onWhitespaceChanged(){this._updateHint()},_onLangDirChanged:function onLangDirChanged(e,dir){if(this.dir!==dir){this.dir=dir;this.menu.setLanguageDirection(dir)}},_openIfActive:function openIfActive(){this.isActive()&&this.open()},_minLengthMet:function minLengthMet(query){query=_.isString(query)?query:this.input.getQuery()||"";return query.length>=this.minLength},_updateHint:function updateHint(){var $selectable,data,val,query,escapedQuery,frontMatchRegEx,match;$selectable=this.menu.getTopSelectable();data=this.menu.getSelectableData($selectable);val=this.input.getInputValue();if(data&&!_.isBlankString(val)&&!this.input.hasOverflow()){query=Input.normalizeQuery(val);escapedQuery=_.escapeRegExChars(query);frontMatchRegEx=new RegExp("^(?:"+escapedQuery+")(.+$)","i");match=frontMatchRegEx.exec(data.val);match&&this.input.setHint(val+match[1])}else{this.input.clearHint()}},isEnabled:function isEnabled(){return this.enabled},enable:function enable(){this.enabled=!0},disable:function disable(){this.enabled=!1},isActive:function isActive(){return this.active},activate:function activate(){if(this.isActive()){return!0}else if(!this.isEnabled()||this.eventBus.before("active")){return!1}else{this.active=!0;this.eventBus.trigger("active");return!0}},deactivate:function deactivate(){if(!this.isActive()){return!0}else if(this.eventBus.before("idle")){return!1}else{this.active=!1;this.close();this.eventBus.trigger("idle");return!0}},isOpen:function isOpen(){return this.menu.isOpen()},open:function open(){if(!this.isOpen()&&!this.eventBus.before("open")){this.menu.open();this._updateHint();this.eventBus.trigger("open")}
return this.isOpen()},close:function close(){if(this.isOpen()&&!this.eventBus.before("close")){this.menu.close();this.input.clearHint();this.input.resetInputValue();this.eventBus.trigger("close")}
return!this.isOpen()},setVal:function setVal(val){this.input.setQuery(_.toStr(val))},getVal:function getVal(){return this.input.getQuery()},select:function select($selectable){var data=this.menu.getSelectableData($selectable);if(data&&!this.eventBus.before("select",data.obj)){this.input.setQuery(data.val,!0);this.eventBus.trigger("select",data.obj);this.close();return!0}
return!1},autocomplete:function autocomplete($selectable){var query,data,isValid;query=this.input.getQuery();data=this.menu.getSelectableData($selectable);isValid=data&&query!==data.val;if(isValid&&!this.eventBus.before("autocomplete",data.obj)){this.input.setQuery(data.val);this.eventBus.trigger("autocomplete",data.obj);return!0}
return!1},moveCursor:function moveCursor(delta){var query,$candidate,data,payload,cancelMove;query=this.input.getQuery();$candidate=this.menu.selectableRelativeToCursor(delta);data=this.menu.getSelectableData($candidate);payload=data?data.obj:null;cancelMove=this._minLengthMet()&&this.menu.update(query);if(!cancelMove&&!this.eventBus.before("cursorchange",payload)){this.menu.setCursor($candidate);if(data){this.input.setInputValue(data.val)}else{this.input.resetInputValue();this._updateHint()}
this.eventBus.trigger("cursorchange",payload);return!0}
return!1},destroy:function destroy(){this.input.destroy();this.menu.destroy()}});return Typeahead;function c(ctx){var methods=[].slice.call(arguments,1);return function(){var args=[].slice.call(arguments);_.each(methods,function(method){return ctx[method].apply(ctx,args)})}}}();(function(){"use strict";var old,keys,methods;old=$.fn.typeahead;keys={www:"tt-www",attrs:"tt-attrs",typeahead:"tt-typeahead"};methods={initialize:function initialize(o,datasets){var www;datasets=_.isArray(datasets)?datasets:[].slice.call(arguments,1);o=o||{};www=WWW(o.classNames);return this.each(attach);function attach(){var $input,$wrapper,$hint,$menu,defaultHint,defaultMenu,eventBus,input,menu,typeahead,MenuConstructor;_.each(datasets,function(d){d.highlight=!!o.highlight});$input=$(this);$wrapper=$(www.html.wrapper);$hint=$elOrNull(o.hint);$menu=$elOrNull(o.menu);defaultHint=o.hint!==!1&&!$hint;defaultMenu=o.menu!==!1&&!$menu;defaultHint&&($hint=buildHintFromInput($input,www));defaultMenu&&($menu=$(www.html.menu).css(www.css.menu));$hint&&$hint.val("");$input=prepInput($input,www);if(defaultHint||defaultMenu){$wrapper.css(www.css.wrapper);$input.css(defaultHint?www.css.input:www.css.inputWithNoHint);$input.wrap($wrapper).parent().prepend(defaultHint?$hint:null).append(defaultMenu?$menu:null)}
MenuConstructor=defaultMenu?DefaultMenu:Menu;eventBus=new EventBus({el:$input});input=new Input({hint:$hint,input:$input},www);menu=new MenuConstructor({node:$menu,datasets:datasets},www);typeahead=new Typeahead({input:input,menu:menu,eventBus:eventBus,minLength:o.minLength},www);$input.data(keys.www,www);$input.data(keys.typeahead,typeahead)}},isEnabled:function isEnabled(){var enabled;ttEach(this.first(),function(t){enabled=t.isEnabled()});return enabled},enable:function enable(){ttEach(this,function(t){t.enable()});return this},disable:function disable(){ttEach(this,function(t){t.disable()});return this},isActive:function isActive(){var active;ttEach(this.first(),function(t){active=t.isActive()});return active},activate:function activate(){ttEach(this,function(t){t.activate()});return this},deactivate:function deactivate(){ttEach(this,function(t){t.deactivate()});return this},isOpen:function isOpen(){var open;ttEach(this.first(),function(t){open=t.isOpen()});return open},open:function open(){ttEach(this,function(t){t.open()});return this},close:function close(){ttEach(this,function(t){t.close()});return this},select:function select(el){var success=!1,$el=$(el);ttEach(this.first(),function(t){success=t.select($el)});return success},autocomplete:function autocomplete(el){var success=!1,$el=$(el);ttEach(this.first(),function(t){success=t.autocomplete($el)});return success},moveCursor:function moveCursoe(delta){var success=!1;ttEach(this.first(),function(t){success=t.moveCursor(delta)});return success},val:function val(newVal){var query;if(!arguments.length){ttEach(this.first(),function(t){query=t.getVal()});return query}else{ttEach(this,function(t){t.setVal(newVal)});return this}},destroy:function destroy(){ttEach(this,function(typeahead,$input){revert($input);typeahead.destroy()});return this}};$.fn.typeahead=function(method){if(methods[method]){return methods[method].apply(this,[].slice.call(arguments,1))}else{return methods.initialize.apply(this,arguments)}};$.fn.typeahead.noConflict=function noConflict(){$.fn.typeahead=old;return this};function ttEach($els,fn){$els.each(function(){var $input=$(this),typeahead;(typeahead=$input.data(keys.typeahead))&&fn(typeahead,$input)})}
function buildHintFromInput($input,www){return $input.clone().addClass(www.classes.hint).removeData().css(www.css.hint).css(getBackgroundStyles($input)).prop("readonly",!0).removeAttr("id name placeholder required").attr({autocomplete:"off",spellcheck:"false",tabindex:-1})}
function prepInput($input,www){$input.data(keys.attrs,{dir:$input.attr("dir"),autocomplete:$input.attr("autocomplete"),spellcheck:$input.attr("spellcheck"),style:$input.attr("style")});$input.addClass(www.classes.input).attr({autocomplete:"off",spellcheck:!1});try{!$input.attr("dir")&&$input.attr("dir","auto")}catch(e){}
return $input}
function getBackgroundStyles($el){return{backgroundAttachment:$el.css("background-attachment"),backgroundClip:$el.css("background-clip"),backgroundColor:$el.css("background-color"),backgroundImage:$el.css("background-image"),backgroundOrigin:$el.css("background-origin"),backgroundPosition:$el.css("background-position"),backgroundRepeat:$el.css("background-repeat"),backgroundSize:$el.css("background-size")}}
function revert($input){var www,$wrapper;www=$input.data(keys.www);$wrapper=$input.parent().filter(www.selectors.wrapper);_.each($input.data(keys.attrs),function(val,key){_.isUndefined(val)?$input.removeAttr(key):$input.attr(key,val)});$input.removeData(keys.typeahead).removeData(keys.www).removeData(keys.attr).removeClass(www.classes.input);if($wrapper.length){$input.detach().insertAfter($wrapper);$wrapper.remove()}}
function $elOrNull(obj){var isValid,$el;isValid=_.isJQuery(obj)||_.isElement(obj);$el=isValid?$(obj).first():[];return $el.length?$el:null}})()});/*!
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2016
 * @version 1.3.4
 *
 * Date formatter utility library that allows formatting date/time variables or Date objects using PHP DateTime format.
 * @see http://php.net/manual/en/function.date.php
 *
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */var DateFormatter;!function(){"use strict";var t,e,r,n,a,u,i;u=864e5,i=3600,t=function(t,e){return"string"==typeof t&&"string"==typeof e&&t.toLowerCase()===e.toLowerCase()},e=function(t,r,n){var a=n||"0",u=t.toString();return u.length<r?e(a+u,r):u},r=function(t){var e,n;for(t=t||{},e=1;e<arguments.length;e++)if(n=arguments[e])for(var a in n)n.hasOwnProperty(a)&&("object"==typeof n[a]?r(t[a],n[a]):t[a]=n[a]);return t},n=function(t,e){for(var r=0;r<e.length;r++)if(e[r].toLowerCase()===t.toLowerCase())return r;return-1},a={dateSettings:{days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],daysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],monthsShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],meridiem:["AM","PM"],ordinal:function(t){var e=t%10,r={1:"st",2:"nd",3:"rd"};return 1!==Math.floor(t%100/10)&&r[e]?r[e]:"th"}},separators:/[ \-+\/\.T:@]/g,validParts:/[dDjlNSwzWFmMntLoYyaABgGhHisueTIOPZcrU]/g,intParts:/[djwNzmnyYhHgGis]/g,tzParts:/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,tzClip:/[^-+\dA-Z]/g},DateFormatter=function(t){var e=this,n=r(a,t);e.dateSettings=n.dateSettings,e.separators=n.separators,e.validParts=n.validParts,e.intParts=n.intParts,e.tzParts=n.tzParts,e.tzClip=n.tzClip},DateFormatter.prototype={constructor:DateFormatter,getMonth:function(t){var e,r=this;return e=n(t,r.dateSettings.monthsShort)+1,0===e&&(e=n(t,r.dateSettings.months)+1),e},parseDate:function(e,r){var n,a,u,i,s,o,c,f,l,h,d=this,g=!1,m=!1,p=d.dateSettings,y={date:null,year:null,month:null,day:null,hour:0,min:0,sec:0};if(!e)return null;if(e instanceof Date)return e;if("U"===r)return u=parseInt(e),u?new Date(1e3*u):e;switch(typeof e){case"number":return new Date(e);case"string":break;default:return null}if(n=r.match(d.validParts),!n||0===n.length)throw new Error("Invalid date format definition.");for(a=e.replace(d.separators,"\x00").split("\x00"),u=0;u<a.length;u++)switch(i=a[u],s=parseInt(i),n[u]){case"y":case"Y":if(!s)return null;l=i.length,y.year=2===l?parseInt((70>s?"20":"19")+i):s,g=!0;break;case"m":case"n":case"M":case"F":if(isNaN(s)){if(o=d.getMonth(i),!(o>0))return null;y.month=o}else{if(!(s>=1&&12>=s))return null;y.month=s}g=!0;break;case"d":case"j":if(!(s>=1&&31>=s))return null;y.day=s,g=!0;break;case"g":case"h":if(c=n.indexOf("a")>-1?n.indexOf("a"):n.indexOf("A")>-1?n.indexOf("A"):-1,h=a[c],c>-1)f=t(h,p.meridiem[0])?0:t(h,p.meridiem[1])?12:-1,s>=1&&12>=s&&f>-1?y.hour=s+f-1:s>=0&&23>=s&&(y.hour=s);else{if(!(s>=0&&23>=s))return null;y.hour=s}m=!0;break;case"G":case"H":if(!(s>=0&&23>=s))return null;y.hour=s,m=!0;break;case"i":if(!(s>=0&&59>=s))return null;y.min=s,m=!0;break;case"s":if(!(s>=0&&59>=s))return null;y.sec=s,m=!0}if(g===!0&&y.year&&y.month&&y.day)y.date=new Date(y.year,y.month-1,y.day,y.hour,y.min,y.sec,0);else{if(m!==!0)return null;y.date=new Date(0,0,0,y.hour,y.min,y.sec,0)}return y.date},guessDate:function(t,e){if("string"!=typeof t)return t;var r,n,a,u,i,s,o=this,c=t.replace(o.separators,"\x00").split("\x00"),f=/^[djmn]/g,l=e.match(o.validParts),h=new Date,d=0;if(!f.test(l[0]))return t;for(a=0;a<c.length;a++){if(d=2,i=c[a],s=parseInt(i.substr(0,2)),isNaN(s))return null;switch(a){case 0:"m"===l[0]||"n"===l[0]?h.setMonth(s-1):h.setDate(s);break;case 1:"m"===l[0]||"n"===l[0]?h.setDate(s):h.setMonth(s-1);break;case 2:if(n=h.getFullYear(),r=i.length,d=4>r?r:4,n=parseInt(4>r?n.toString().substr(0,4-r)+i:i.substr(0,4)),!n)return null;h.setFullYear(n);break;case 3:h.setHours(s);break;case 4:h.setMinutes(s);break;case 5:h.setSeconds(s)}u=i.substr(d),u.length>0&&c.splice(a+1,0,u)}return h},parseFormat:function(t,r){var n,a=this,s=a.dateSettings,o=/\\?(.?)/gi,c=function(t,e){return n[t]?n[t]():e};return n={d:function(){return e(n.j(),2)},D:function(){return s.daysShort[n.w()]},j:function(){return r.getDate()},l:function(){return s.days[n.w()]},N:function(){return n.w()||7},w:function(){return r.getDay()},z:function(){var t=new Date(n.Y(),n.n()-1,n.j()),e=new Date(n.Y(),0,1);return Math.round((t-e)/u)},W:function(){var t=new Date(n.Y(),n.n()-1,n.j()-n.N()+3),r=new Date(t.getFullYear(),0,4);return e(1+Math.round((t-r)/u/7),2)},F:function(){return s.months[r.getMonth()]},m:function(){return e(n.n(),2)},M:function(){return s.monthsShort[r.getMonth()]},n:function(){return r.getMonth()+1},t:function(){return new Date(n.Y(),n.n(),0).getDate()},L:function(){var t=n.Y();return t%4===0&&t%100!==0||t%400===0?1:0},o:function(){var t=n.n(),e=n.W(),r=n.Y();return r+(12===t&&9>e?1:1===t&&e>9?-1:0)},Y:function(){return r.getFullYear()},y:function(){return n.Y().toString().slice(-2)},a:function(){return n.A().toLowerCase()},A:function(){var t=n.G()<12?0:1;return s.meridiem[t]},B:function(){var t=r.getUTCHours()*i,n=60*r.getUTCMinutes(),a=r.getUTCSeconds();return e(Math.floor((t+n+a+i)/86.4)%1e3,3)},g:function(){return n.G()%12||12},G:function(){return r.getHours()},h:function(){return e(n.g(),2)},H:function(){return e(n.G(),2)},i:function(){return e(r.getMinutes(),2)},s:function(){return e(r.getSeconds(),2)},u:function(){return e(1e3*r.getMilliseconds(),6)},e:function(){var t=/\((.*)\)/.exec(String(r))[1];return t||"Coordinated Universal Time"},I:function(){var t=new Date(n.Y(),0),e=Date.UTC(n.Y(),0),r=new Date(n.Y(),6),a=Date.UTC(n.Y(),6);return t-e!==r-a?1:0},O:function(){var t=r.getTimezoneOffset(),n=Math.abs(t);return(t>0?"-":"+")+e(100*Math.floor(n/60)+n%60,4)},P:function(){var t=n.O();return t.substr(0,3)+":"+t.substr(3,2)},T:function(){var t=(String(r).match(a.tzParts)||[""]).pop().replace(a.tzClip,"");return t||"UTC"},Z:function(){return 60*-r.getTimezoneOffset()},c:function(){return"Y-m-d\\TH:i:sP".replace(o,c)},r:function(){return"D, d M Y H:i:s O".replace(o,c)},U:function(){return r.getTime()/1e3||0}},c(t,t)},formatDate:function(t,e){var r,n,a,u,i,s=this,o="",c="\\";if("string"==typeof t&&(t=s.parseDate(t,e),!t))return null;if(t instanceof Date){for(a=e.length,r=0;a>r;r++)i=e.charAt(r),"S"!==i&&i!==c&&(r>0&&e.charAt(r-1)===c?o+=i:(u=s.parseFormat(i,t),r!==a-1&&s.intParts.test(i)&&"S"===e.charAt(r+1)&&(n=parseInt(u)||0,u+=s.dateSettings.ordinal(n)),o+=u));return o}return""}}}();/**
 * @preserve jQuery DateTimePicker
 * @homepage http://xdsoft.net/jqplugins/datetimepicker/
 * @author Chupurnov Valeriy (<chupurnov@gmail.com>)
 */
var datetimepickerFactory=function($){'use strict';var default_options={i18n:{ar:{months:["كانون الثاني","شباط","آذار","نيسان","مايو","حزيران","تموز","آب","أيلول","تشرين الأول","تشرين الثاني","كانون الأول"],dayOfWeekShort:["ن","ث","ع","خ","ج","س","ح"],dayOfWeek:["الأحد","الاثنين","الثلاثاء","الأربعاء","الخميس","الجمعة","السبت","الأحد"]},ro:{months:["Ianuarie","Februarie","Martie","Aprilie","Mai","Iunie","Iulie","August","Septembrie","Octombrie","Noiembrie","Decembrie"],dayOfWeekShort:["Du","Lu","Ma","Mi","Jo","Vi","Sâ"],dayOfWeek:["Duminică","Luni","Marţi","Miercuri","Joi","Vineri","Sâmbătă"]},id:{months:["Januari","Februari","Maret","April","Mei","Juni","Juli","Agustus","September","Oktober","November","Desember"],dayOfWeekShort:["Min","Sen","Sel","Rab","Kam","Jum","Sab"],dayOfWeek:["Minggu","Senin","Selasa","Rabu","Kamis","Jumat","Sabtu"]},is:{months:["Janúar","Febrúar","Mars","Apríl","Maí","Júní","Júlí","Ágúst","September","Október","Nóvember","Desember"],dayOfWeekShort:["Sun","Mán","Þrið","Mið","Fim","Fös","Lau"],dayOfWeek:["Sunnudagur","Mánudagur","Þriðjudagur","Miðvikudagur","Fimmtudagur","Föstudagur","Laugardagur"]},bg:{months:["Януари","Февруари","Март","Април","Май","Юни","Юли","Август","Септември","Октомври","Ноември","Декември"],dayOfWeekShort:["Нд","Пн","Вт","Ср","Чт","Пт","Сб"],dayOfWeek:["Неделя","Понеделник","Вторник","Сряда","Четвъртък","Петък","Събота"]},fa:{months:['فروردین','اردیبهشت','خرداد','تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند'],dayOfWeekShort:['یکشنبه','دوشنبه','سه شنبه','چهارشنبه','پنجشنبه','جمعه','شنبه'],dayOfWeek:["یک‌شنبه","دوشنبه","سه‌شنبه","چهارشنبه","پنج‌شنبه","جمعه","شنبه","یک‌شنبه"]},ru:{months:['Январь','Февраль','Март','Апрель','Май','Июнь','Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь'],dayOfWeekShort:["Вс","Пн","Вт","Ср","Чт","Пт","Сб"],dayOfWeek:["Воскресенье","Понедельник","Вторник","Среда","Четверг","Пятница","Суббота"]},uk:{months:['Січень','Лютий','Березень','Квітень','Травень','Червень','Липень','Серпень','Вересень','Жовтень','Листопад','Грудень'],dayOfWeekShort:["Ндл","Пнд","Втр","Срд","Чтв","Птн","Сбт"],dayOfWeek:["Неділя","Понеділок","Вівторок","Середа","Четвер","П'ятниця","Субота"]},en:{months:["January","February","March","April","May","June","July","August","September","October","November","December"],dayOfWeekShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],dayOfWeek:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},el:{months:["Ιανουάριος","Φεβρουάριος","Μάρτιος","Απρίλιος","Μάιος","Ιούνιος","Ιούλιος","Αύγουστος","Σεπτέμβριος","Οκτώβριος","Νοέμβριος","Δεκέμβριος"],dayOfWeekShort:["Κυρ","Δευ","Τρι","Τετ","Πεμ","Παρ","Σαβ"],dayOfWeek:["Κυριακή","Δευτέρα","Τρίτη","Τετάρτη","Πέμπτη","Παρασκευή","Σάββατο"]},de:{months:['Januar','Februar','März','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember'],dayOfWeekShort:["So","Mo","Di","Mi","Do","Fr","Sa"],dayOfWeek:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"]},nl:{months:["januari","februari","maart","april","mei","juni","juli","augustus","september","oktober","november","december"],dayOfWeekShort:["zo","ma","di","wo","do","vr","za"],dayOfWeek:["zondag","maandag","dinsdag","woensdag","donderdag","vrijdag","zaterdag"]},tr:{months:["Ocak","Şubat","Mart","Nisan","Mayıs","Haziran","Temmuz","Ağustos","Eylül","Ekim","Kasım","Aralık"],dayOfWeekShort:["Paz","Pts","Sal","Çar","Per","Cum","Cts"],dayOfWeek:["Pazar","Pazartesi","Salı","Çarşamba","Perşembe","Cuma","Cumartesi"]},fr:{months:["Janvier","Février","Mars","Avril","Mai","Juin","Juillet","Août","Septembre","Octobre","Novembre","Décembre"],dayOfWeekShort:["Dim","Lun","Mar","Mer","Jeu","Ven","Sam"],dayOfWeek:["dimanche","lundi","mardi","mercredi","jeudi","vendredi","samedi"]},es:{months:["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"],dayOfWeekShort:["Dom","Lun","Mar","Mié","Jue","Vie","Sáb"],dayOfWeek:["Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado"]},th:{months:['มกราคม','กุมภาพันธ์','มีนาคม','เมษายน','พฤษภาคม','มิถุนายน','กรกฎาคม','สิงหาคม','กันยายน','ตุลาคม','พฤศจิกายน','ธันวาคม'],dayOfWeekShort:['อา.','จ.','อ.','พ.','พฤ.','ศ.','ส.'],dayOfWeek:["อาทิตย์","จันทร์","อังคาร","พุธ","พฤหัส","ศุกร์","เสาร์","อาทิตย์"]},pl:{months:["styczeń","luty","marzec","kwiecień","maj","czerwiec","lipiec","sierpień","wrzesień","październik","listopad","grudzień"],dayOfWeekShort:["nd","pn","wt","śr","cz","pt","sb"],dayOfWeek:["niedziela","poniedziałek","wtorek","środa","czwartek","piątek","sobota"]},pt:{months:["Janeiro","Fevereiro","Março","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],dayOfWeekShort:["Dom","Seg","Ter","Qua","Qui","Sex","Sab"],dayOfWeek:["Domingo","Segunda","Terça","Quarta","Quinta","Sexta","Sábado"]},ch:{months:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],dayOfWeekShort:["日","一","二","三","四","五","六"]},se:{months:["Januari","Februari","Mars","April","Maj","Juni","Juli","Augusti","September","Oktober","November","December"],dayOfWeekShort:["Sön","Mån","Tis","Ons","Tor","Fre","Lör"]},km:{months:["មករា​","កុម្ភៈ","មិនា​","មេសា​","ឧសភា​","មិថុនា​","កក្កដា​","សីហា​","កញ្ញា​","តុលា​","វិច្ឆិកា","ធ្នូ​"],dayOfWeekShort:["អាទិ​","ច័ន្ទ​","អង្គារ​","ពុធ​","ព្រហ​​","សុក្រ​","សៅរ៍"],dayOfWeek:["អាទិត្យ​","ច័ន្ទ​","អង្គារ​","ពុធ​","ព្រហស្បតិ៍​","សុក្រ​","សៅរ៍"]},kr:{months:["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월"],dayOfWeekShort:["일","월","화","수","목","금","토"],dayOfWeek:["일요일","월요일","화요일","수요일","목요일","금요일","토요일"]},it:{months:["Gennaio","Febbraio","Marzo","Aprile","Maggio","Giugno","Luglio","Agosto","Settembre","Ottobre","Novembre","Dicembre"],dayOfWeekShort:["Dom","Lun","Mar","Mer","Gio","Ven","Sab"],dayOfWeek:["Domenica","Lunedì","Martedì","Mercoledì","Giovedì","Venerdì","Sabato"]},da:{months:["Januar","Februar","Marts","April","Maj","Juni","Juli","August","September","Oktober","November","December"],dayOfWeekShort:["Søn","Man","Tir","Ons","Tor","Fre","Lør"],dayOfWeek:["søndag","mandag","tirsdag","onsdag","torsdag","fredag","lørdag"]},no:{months:["Januar","Februar","Mars","April","Mai","Juni","Juli","August","September","Oktober","November","Desember"],dayOfWeekShort:["Søn","Man","Tir","Ons","Tor","Fre","Lør"],dayOfWeek:['Søndag','Mandag','Tirsdag','Onsdag','Torsdag','Fredag','Lørdag']},ja:{months:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],dayOfWeekShort:["日","月","火","水","木","金","土"],dayOfWeek:["日曜","月曜","火曜","水曜","木曜","金曜","土曜"]},vi:{months:["Tháng 1","Tháng 2","Tháng 3","Tháng 4","Tháng 5","Tháng 6","Tháng 7","Tháng 8","Tháng 9","Tháng 10","Tháng 11","Tháng 12"],dayOfWeekShort:["CN","T2","T3","T4","T5","T6","T7"],dayOfWeek:["Chủ nhật","Thứ hai","Thứ ba","Thứ tư","Thứ năm","Thứ sáu","Thứ bảy"]},sl:{months:["Januar","Februar","Marec","April","Maj","Junij","Julij","Avgust","September","Oktober","November","December"],dayOfWeekShort:["Ned","Pon","Tor","Sre","Čet","Pet","Sob"],dayOfWeek:["Nedelja","Ponedeljek","Torek","Sreda","Četrtek","Petek","Sobota"]},cs:{months:["Leden","Únor","Březen","Duben","Květen","Červen","Červenec","Srpen","Září","Říjen","Listopad","Prosinec"],dayOfWeekShort:["Ne","Po","Út","St","Čt","Pá","So"]},hu:{months:["Január","Február","Március","Április","Május","Június","Július","Augusztus","Szeptember","Október","November","December"],dayOfWeekShort:["Va","Hé","Ke","Sze","Cs","Pé","Szo"],dayOfWeek:["vasárnap","hétfő","kedd","szerda","csütörtök","péntek","szombat"]},az:{months:["Yanvar","Fevral","Mart","Aprel","May","Iyun","Iyul","Avqust","Sentyabr","Oktyabr","Noyabr","Dekabr"],dayOfWeekShort:["B","Be","Ça","Ç","Ca","C","Ş"],dayOfWeek:["Bazar","Bazar ertəsi","Çərşənbə axşamı","Çərşənbə","Cümə axşamı","Cümə","Şənbə"]},bs:{months:["Januar","Februar","Mart","April","Maj","Jun","Jul","Avgust","Septembar","Oktobar","Novembar","Decembar"],dayOfWeekShort:["Ned","Pon","Uto","Sri","Čet","Pet","Sub"],dayOfWeek:["Nedjelja","Ponedjeljak","Utorak","Srijeda","Četvrtak","Petak","Subota"]},ca:{months:["Gener","Febrer","Març","Abril","Maig","Juny","Juliol","Agost","Setembre","Octubre","Novembre","Desembre"],dayOfWeekShort:["Dg","Dl","Dt","Dc","Dj","Dv","Ds"],dayOfWeek:["Diumenge","Dilluns","Dimarts","Dimecres","Dijous","Divendres","Dissabte"]},'en-GB':{months:["January","February","March","April","May","June","July","August","September","October","November","December"],dayOfWeekShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],dayOfWeek:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},et:{months:["Jaanuar","Veebruar","Märts","Aprill","Mai","Juuni","Juuli","August","September","Oktoober","November","Detsember"],dayOfWeekShort:["P","E","T","K","N","R","L"],dayOfWeek:["Pühapäev","Esmaspäev","Teisipäev","Kolmapäev","Neljapäev","Reede","Laupäev"]},eu:{months:["Urtarrila","Otsaila","Martxoa","Apirila","Maiatza","Ekaina","Uztaila","Abuztua","Iraila","Urria","Azaroa","Abendua"],dayOfWeekShort:["Ig.","Al.","Ar.","Az.","Og.","Or.","La."],dayOfWeek:['Igandea','Astelehena','Asteartea','Asteazkena','Osteguna','Ostirala','Larunbata']},fi:{months:["Tammikuu","Helmikuu","Maaliskuu","Huhtikuu","Toukokuu","Kesäkuu","Heinäkuu","Elokuu","Syyskuu","Lokakuu","Marraskuu","Joulukuu"],dayOfWeekShort:["Su","Ma","Ti","Ke","To","Pe","La"],dayOfWeek:["sunnuntai","maanantai","tiistai","keskiviikko","torstai","perjantai","lauantai"]},gl:{months:["Xan","Feb","Maz","Abr","Mai","Xun","Xul","Ago","Set","Out","Nov","Dec"],dayOfWeekShort:["Dom","Lun","Mar","Mer","Xov","Ven","Sab"],dayOfWeek:["Domingo","Luns","Martes","Mércores","Xoves","Venres","Sábado"]},hr:{months:["Siječanj","Veljača","Ožujak","Travanj","Svibanj","Lipanj","Srpanj","Kolovoz","Rujan","Listopad","Studeni","Prosinac"],dayOfWeekShort:["Ned","Pon","Uto","Sri","Čet","Pet","Sub"],dayOfWeek:["Nedjelja","Ponedjeljak","Utorak","Srijeda","Četvrtak","Petak","Subota"]},ko:{months:["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월"],dayOfWeekShort:["일","월","화","수","목","금","토"],dayOfWeek:["일요일","월요일","화요일","수요일","목요일","금요일","토요일"]},lt:{months:["Sausio","Vasario","Kovo","Balandžio","Gegužės","Birželio","Liepos","Rugpjūčio","Rugsėjo","Spalio","Lapkričio","Gruodžio"],dayOfWeekShort:["Sek","Pir","Ant","Tre","Ket","Pen","Šeš"],dayOfWeek:["Sekmadienis","Pirmadienis","Antradienis","Trečiadienis","Ketvirtadienis","Penktadienis","Šeštadienis"]},lv:{months:["Janvāris","Februāris","Marts","Aprīlis ","Maijs","Jūnijs","Jūlijs","Augusts","Septembris","Oktobris","Novembris","Decembris"],dayOfWeekShort:["Sv","Pr","Ot","Tr","Ct","Pk","St"],dayOfWeek:["Svētdiena","Pirmdiena","Otrdiena","Trešdiena","Ceturtdiena","Piektdiena","Sestdiena"]},mk:{months:["јануари","февруари","март","април","мај","јуни","јули","август","септември","октомври","ноември","декември"],dayOfWeekShort:["нед","пон","вто","сре","чет","пет","саб"],dayOfWeek:["Недела","Понеделник","Вторник","Среда","Четврток","Петок","Сабота"]},mn:{months:["1-р сар","2-р сар","3-р сар","4-р сар","5-р сар","6-р сар","7-р сар","8-р сар","9-р сар","10-р сар","11-р сар","12-р сар"],dayOfWeekShort:["Дав","Мяг","Лха","Пүр","Бсн","Бям","Ням"],dayOfWeek:["Даваа","Мягмар","Лхагва","Пүрэв","Баасан","Бямба","Ням"]},'pt-BR':{months:["Janeiro","Fevereiro","Março","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],dayOfWeekShort:["Dom","Seg","Ter","Qua","Qui","Sex","Sáb"],dayOfWeek:["Domingo","Segunda","Terça","Quarta","Quinta","Sexta","Sábado"]},sk:{months:["Január","Február","Marec","Apríl","Máj","Jún","Júl","August","September","Október","November","December"],dayOfWeekShort:["Ne","Po","Ut","St","Št","Pi","So"],dayOfWeek:["Nedeľa","Pondelok","Utorok","Streda","Štvrtok","Piatok","Sobota"]},sq:{months:["Janar","Shkurt","Mars","Prill","Maj","Qershor","Korrik","Gusht","Shtator","Tetor","Nëntor","Dhjetor"],dayOfWeekShort:["Die","Hën","Mar","Mër","Enj","Pre","Shtu"],dayOfWeek:["E Diel","E Hënë","E Martē","E Mërkurë","E Enjte","E Premte","E Shtunë"]},'sr-YU':{months:["Januar","Februar","Mart","April","Maj","Jun","Jul","Avgust","Septembar","Oktobar","Novembar","Decembar"],dayOfWeekShort:["Ned","Pon","Uto","Sre","čet","Pet","Sub"],dayOfWeek:["Nedelja","Ponedeljak","Utorak","Sreda","Četvrtak","Petak","Subota"]},sr:{months:["јануар","фебруар","март","април","мај","јун","јул","август","септембар","октобар","новембар","децембар"],dayOfWeekShort:["нед","пон","уто","сре","чет","пет","суб"],dayOfWeek:["Недеља","Понедељак","Уторак","Среда","Четвртак","Петак","Субота"]},sv:{months:["Januari","Februari","Mars","April","Maj","Juni","Juli","Augusti","September","Oktober","November","December"],dayOfWeekShort:["Sön","Mån","Tis","Ons","Tor","Fre","Lör"],dayOfWeek:["Söndag","Måndag","Tisdag","Onsdag","Torsdag","Fredag","Lördag"]},'zh-TW':{months:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],dayOfWeekShort:["日","一","二","三","四","五","六"],dayOfWeek:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"]},zh:{months:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],dayOfWeekShort:["日","一","二","三","四","五","六"],dayOfWeek:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"]},ug:{months:["1-ئاي","2-ئاي","3-ئاي","4-ئاي","5-ئاي","6-ئاي","7-ئاي","8-ئاي","9-ئاي","10-ئاي","11-ئاي","12-ئاي"],dayOfWeek:["يەكشەنبە","دۈشەنبە","سەيشەنبە","چارشەنبە","پەيشەنبە","جۈمە","شەنبە"]},he:{months:['ינואר','פברואר','מרץ','אפריל','מאי','יוני','יולי','אוגוסט','ספטמבר','אוקטובר','נובמבר','דצמבר'],dayOfWeekShort:['א\'','ב\'','ג\'','ד\'','ה\'','ו\'','שבת'],dayOfWeek:["ראשון","שני","שלישי","רביעי","חמישי","שישי","שבת","ראשון"]},hy:{months:["Հունվար","Փետրվար","Մարտ","Ապրիլ","Մայիս","Հունիս","Հուլիս","Օգոստոս","Սեպտեմբեր","Հոկտեմբեր","Նոյեմբեր","Դեկտեմբեր"],dayOfWeekShort:["Կի","Երկ","Երք","Չոր","Հնգ","Ուրբ","Շբթ"],dayOfWeek:["Կիրակի","Երկուշաբթի","Երեքշաբթի","Չորեքշաբթի","Հինգշաբթի","Ուրբաթ","Շաբաթ"]},kg:{months:['Үчтүн айы','Бирдин айы','Жалган Куран','Чын Куран','Бугу','Кулжа','Теке','Баш Оона','Аяк Оона','Тогуздун айы','Жетинин айы','Бештин айы'],dayOfWeekShort:["Жек","Дүй","Шей","Шар","Бей","Жум","Ише"],dayOfWeek:["Жекшемб","Дүйшөмб","Шейшемб","Шаршемб","Бейшемби","Жума","Ишенб"]},rm:{months:["Schaner","Favrer","Mars","Avrigl","Matg","Zercladur","Fanadur","Avust","Settember","October","November","December"],dayOfWeekShort:["Du","Gli","Ma","Me","Gie","Ve","So"],dayOfWeek:["Dumengia","Glindesdi","Mardi","Mesemna","Gievgia","Venderdi","Sonda"]},ka:{months:['იანვარი','თებერვალი','მარტი','აპრილი','მაისი','ივნისი','ივლისი','აგვისტო','სექტემბერი','ოქტომბერი','ნოემბერი','დეკემბერი'],dayOfWeekShort:["კვ","ორშ","სამშ","ოთხ","ხუთ","პარ","შაბ"],dayOfWeek:["კვირა","ორშაბათი","სამშაბათი","ოთხშაბათი","ხუთშაბათი","პარასკევი","შაბათი"]}},ownerDocument:document,contentWindow:window,value:'',rtl:!1,format:'Y/m/d H:i',formatTime:'H:i',formatDate:'Y/m/d',startDate:!1,step:60,monthChangeSpinner:!0,closeOnDateSelect:!1,closeOnTimeSelect:!0,closeOnWithoutClick:!0,closeOnInputClick:!0,openOnFocus:!0,timepicker:!0,datepicker:!0,weeks:!1,defaultTime:!1,defaultDate:!1,minDate:!1,maxDate:!1,minTime:!1,maxTime:!1,minDateTime:!1,maxDateTime:!1,allowTimes:[],opened:!1,initTime:!0,inline:!1,theme:'',touchMovedThreshold:5,onSelectDate:function(){},onSelectTime:function(){},onChangeMonth:function(){},onGetWeekOfYear:function(){},onChangeYear:function(){},onChangeDateTime:function(){},onShow:function(){},onClose:function(){},onGenerate:function(){},withoutCopyright:!0,inverseButton:!1,hours12:!1,next:'xdsoft_next',prev:'xdsoft_prev',dayOfWeekStart:0,parentID:'body',timeHeightInTimePicker:25,timepickerScrollbar:!0,todayButton:!0,prevButton:!0,nextButton:!0,defaultSelect:!0,scrollMonth:!0,scrollTime:!0,scrollInput:!0,lazyInit:!1,mask:!1,validateOnBlur:!0,allowBlank:!0,yearStart:1950,yearEnd:2050,monthStart:0,monthEnd:11,style:'',id:'',fixed:!1,roundTime:'round',className:'',weekends:[],highlightedDates:[],highlightedPeriods:[],allowDates:[],allowDateRe:null,disabledDates:[],disabledWeekDays:[],yearOffset:0,beforeShowDay:null,enterLikeTab:!0,showApplyButton:!1,insideParent:!1,};var dateHelper=null,defaultDateHelper=null,globalLocaleDefault='en',globalLocale='en';var dateFormatterOptionsDefault={meridiem:['AM','PM']};var initDateFormatter=function(){var locale=default_options.i18n[globalLocale],opts={days:locale.dayOfWeek,daysShort:locale.dayOfWeekShort,months:locale.months,monthsShort:$.map(locale.months,function(n){return n.substring(0,3)})};if(typeof DateFormatter==='function'){dateHelper=defaultDateHelper=new DateFormatter({dateSettings:$.extend({},dateFormatterOptionsDefault,opts)})}};var dateFormatters={moment:{default_options:{format:'YYYY/MM/DD HH:mm',formatDate:'YYYY/MM/DD',formatTime:'HH:mm',},formatter:{parseDate:function(date,format){if(isFormatStandard(format)){return defaultDateHelper.parseDate(date,format)}
var d=moment(date,format);return d.isValid()?d.toDate():!1},formatDate:function(date,format){if(isFormatStandard(format)){return defaultDateHelper.formatDate(date,format)}
return moment(date).format(format)},formatMask:function(format){return format.replace(/Y{4}/g,'9999').replace(/Y{2}/g,'99').replace(/M{2}/g,'19').replace(/D{2}/g,'39').replace(/H{2}/g,'29').replace(/m{2}/g,'59').replace(/s{2}/g,'59')},}}}
$.datetimepicker={setLocale:function(locale){var newLocale=default_options.i18n[locale]?locale:globalLocaleDefault;if(globalLocale!==newLocale){globalLocale=newLocale;initDateFormatter()}},setDateFormatter:function(dateFormatter){if(typeof dateFormatter==='string'&&dateFormatters.hasOwnProperty(dateFormatter)){var df=dateFormatters[dateFormatter];$.extend(default_options,df.default_options);dateHelper=df.formatter}else{dateHelper=dateFormatter}},};var standardFormats={RFC_2822:'D, d M Y H:i:s O',ATOM:'Y-m-d\TH:i:sP',ISO_8601:'Y-m-d\TH:i:sO',RFC_822:'D, d M y H:i:s O',RFC_850:'l, d-M-y H:i:s T',RFC_1036:'D, d M y H:i:s O',RFC_1123:'D, d M Y H:i:s O',RSS:'D, d M Y H:i:s O',W3C:'Y-m-d\TH:i:sP'}
var isFormatStandard=function(format){return Object.values(standardFormats).indexOf(format)===-1?!1:!0}
$.extend($.datetimepicker,standardFormats);initDateFormatter();if(!window.getComputedStyle){window.getComputedStyle=function(el){this.el=el;this.getPropertyValue=function(prop){var re=/(-([a-z]))/g;if(prop==='float'){prop='styleFloat'}
if(re.test(prop)){prop=prop.replace(re,function(a,b,c){return c.toUpperCase()})}
return el.currentStyle[prop]||null};return this}}
if(!Array.prototype.indexOf){Array.prototype.indexOf=function(obj,start){var i,j;for(i=(start||0),j=this.length;i<j;i+=1){if(this[i]===obj){return i}}
return-1}}
Date.prototype.countDaysInMonth=function(){return new Date(this.getFullYear(),this.getMonth()+1,0).getDate()};$.fn.xdsoftScroller=function(options,percent){return this.each(function(){var timeboxparent=$(this),pointerEventToXY=function(e){var out={x:0,y:0},touch;if(e.type==='touchstart'||e.type==='touchmove'||e.type==='touchend'||e.type==='touchcancel'){touch=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];out.x=touch.clientX;out.y=touch.clientY}else if(e.type==='mousedown'||e.type==='mouseup'||e.type==='mousemove'||e.type==='mouseover'||e.type==='mouseout'||e.type==='mouseenter'||e.type==='mouseleave'){out.x=e.clientX;out.y=e.clientY}
return out},timebox,parentHeight,height,scrollbar,scroller,maximumOffset=100,start=!1,startY=0,startTop=0,h1=0,touchStart=!1,startTopScroll=0,calcOffset=function(){};if(percent==='hide'){timeboxparent.find('.xdsoft_scrollbar').hide();return}
if(!$(this).hasClass('xdsoft_scroller_box')){timebox=timeboxparent.children().eq(0);parentHeight=timeboxparent[0].clientHeight;height=timebox[0].offsetHeight;scrollbar=$('<div class="xdsoft_scrollbar"></div>');scroller=$('<div class="xdsoft_scroller"></div>');scrollbar.append(scroller);timeboxparent.addClass('xdsoft_scroller_box').append(scrollbar);calcOffset=function calcOffset(event){var offset=pointerEventToXY(event).y-startY+startTopScroll;if(offset<0){offset=0}
if(offset+scroller[0].offsetHeight>h1){offset=h1-scroller[0].offsetHeight}
timeboxparent.trigger('scroll_element.xdsoft_scroller',[maximumOffset?offset/maximumOffset:0])};scroller.on('touchstart.xdsoft_scroller mousedown.xdsoft_scroller',function(event){if(!parentHeight){timeboxparent.trigger('resize_scroll.xdsoft_scroller',[percent])}
startY=pointerEventToXY(event).y;startTopScroll=parseInt(scroller.css('margin-top'),10);h1=scrollbar[0].offsetHeight;if(event.type==='mousedown'||event.type==='touchstart'){if(options.ownerDocument){$(options.ownerDocument.body).addClass('xdsoft_noselect')}
$([options.ownerDocument.body,options.contentWindow]).on('touchend mouseup.xdsoft_scroller',function arguments_callee(){$([options.ownerDocument.body,options.contentWindow]).off('touchend mouseup.xdsoft_scroller',arguments_callee).off('mousemove.xdsoft_scroller',calcOffset).removeClass('xdsoft_noselect')});$(options.ownerDocument.body).on('mousemove.xdsoft_scroller',calcOffset)}else{touchStart=!0;event.stopPropagation();event.preventDefault()}}).on('touchmove',function(event){if(touchStart){event.preventDefault();calcOffset(event)}}).on('touchend touchcancel',function(){touchStart=!1;startTopScroll=0});timeboxparent.on('scroll_element.xdsoft_scroller',function(event,percentage){if(!parentHeight){timeboxparent.trigger('resize_scroll.xdsoft_scroller',[percentage,!0])}
percentage=percentage>1?1:(percentage<0||isNaN(percentage))?0:percentage;scroller.css('margin-top',maximumOffset*percentage);setTimeout(function(){timebox.css('marginTop',-parseInt((timebox[0].offsetHeight-parentHeight)*percentage,10))},10)}).on('resize_scroll.xdsoft_scroller',function(event,percentage,noTriggerScroll){var percent,sh;parentHeight=timeboxparent[0].clientHeight;height=timebox[0].offsetHeight;percent=parentHeight/height;sh=percent*scrollbar[0].offsetHeight;if(percent>1){scroller.hide()}else{scroller.show();scroller.css('height',parseInt(sh>10?sh:10,10));maximumOffset=scrollbar[0].offsetHeight-scroller[0].offsetHeight;if(noTriggerScroll!==!0){timeboxparent.trigger('scroll_element.xdsoft_scroller',[percentage||Math.abs(parseInt(timebox.css('marginTop'),10))/(height-parentHeight)])}}});timeboxparent.on('mousewheel',function(event){var top=Math.abs(parseInt(timebox.css('marginTop'),10));top=top-(event.deltaY*20);if(top<0){top=0}
timeboxparent.trigger('scroll_element.xdsoft_scroller',[top/(height-parentHeight)]);event.stopPropagation();return!1});timeboxparent.on('touchstart',function(event){start=pointerEventToXY(event);startTop=Math.abs(parseInt(timebox.css('marginTop'),10))});timeboxparent.on('touchmove',function(event){if(start){event.preventDefault();var coord=pointerEventToXY(event);timeboxparent.trigger('scroll_element.xdsoft_scroller',[(startTop-(coord.y-start.y))/(height-parentHeight)])}});timeboxparent.on('touchend touchcancel',function(){start=!1;startTop=0})}
timeboxparent.trigger('resize_scroll.xdsoft_scroller',[percent])})};$.fn.datetimepicker=function(opt,opt2){var result=this,KEY0=48,KEY9=57,_KEY0=96,_KEY9=105,CTRLKEY=17,CMDKEY=91,DEL=46,ENTER=13,ESC=27,BACKSPACE=8,ARROWLEFT=37,ARROWUP=38,ARROWRIGHT=39,ARROWDOWN=40,TAB=9,F5=116,AKEY=65,CKEY=67,VKEY=86,ZKEY=90,YKEY=89,ctrlDown=!1,cmdDown=!1,options=($.isPlainObject(opt)||!opt)?$.extend(!0,{},default_options,opt):$.extend(!0,{},default_options),lazyInitTimer=0,createDateTimePicker,destroyDateTimePicker,lazyInit=function(input){input.on('open.xdsoft focusin.xdsoft mousedown.xdsoft touchstart',function initOnActionCallback(){if(input.is(':disabled')||input.data('xdsoft_datetimepicker')){return}
clearTimeout(lazyInitTimer);lazyInitTimer=setTimeout(function(){if(!input.data('xdsoft_datetimepicker')){createDateTimePicker(input)}
input.off('open.xdsoft focusin.xdsoft mousedown.xdsoft touchstart',initOnActionCallback).trigger('open.xdsoft')},100)})};createDateTimePicker=function(input){var datetimepicker=$('<div class="xdsoft_datetimepicker xdsoft_noselect"></div>'),xdsoft_copyright=$('<div class="xdsoft_copyright"><a target="_blank" href="http://xdsoft.net/jqplugins/datetimepicker/">xdsoft.net</a></div>'),datepicker=$('<div class="xdsoft_datepicker active"></div>'),month_picker=$('<div class="xdsoft_monthpicker"><button type="button" class="xdsoft_prev"></button><button type="button" class="xdsoft_today_button"></button>'+'<div class="xdsoft_label xdsoft_month"><span></span><i></i></div>'+'<div class="xdsoft_label xdsoft_year"><span></span><i></i></div>'+'<button type="button" class="xdsoft_next"></button></div>'),calendar=$('<div class="xdsoft_calendar"></div>'),timepicker=$('<div class="xdsoft_timepicker active"><button type="button" class="xdsoft_prev"></button><div class="xdsoft_time_box"></div><button type="button" class="xdsoft_next"></button></div>'),timeboxparent=timepicker.find('.xdsoft_time_box').eq(0),timebox=$('<div class="xdsoft_time_variant"></div>'),applyButton=$('<button type="button" class="xdsoft_save_selected blue-gradient-button">Save Selected</button>'),monthselect=$('<div class="xdsoft_select xdsoft_monthselect"><div></div></div>'),yearselect=$('<div class="xdsoft_select xdsoft_yearselect"><div></div></div>'),triggerAfterOpen=!1,XDSoft_datetime,xchangeTimer,timerclick,current_time_index,setPos,timer=0,_xdsoft_datetime,forEachAncestorOf;if(options.id){datetimepicker.attr('id',options.id)}
if(options.style){datetimepicker.attr('style',options.style)}
if(options.weeks){datetimepicker.addClass('xdsoft_showweeks')}
if(options.rtl){datetimepicker.addClass('xdsoft_rtl')}
datetimepicker.addClass('xdsoft_'+options.theme);datetimepicker.addClass(options.className);month_picker.find('.xdsoft_month span').after(monthselect);month_picker.find('.xdsoft_year span').after(yearselect);month_picker.find('.xdsoft_month,.xdsoft_year').on('touchstart mousedown.xdsoft',function(event){var select=$(this).find('.xdsoft_select').eq(0),val=0,top=0,visible=select.is(':visible'),items,i;month_picker.find('.xdsoft_select').hide();if(_xdsoft_datetime.currentTime){val=_xdsoft_datetime.currentTime[$(this).hasClass('xdsoft_month')?'getMonth':'getFullYear']()}
select[visible?'hide':'show']();for(items=select.find('div.xdsoft_option'),i=0;i<items.length;i+=1){if(items.eq(i).data('value')===val){break}else{top+=items[0].offsetHeight}}
select.xdsoftScroller(options,top/(select.children()[0].offsetHeight-(select[0].clientHeight)));event.stopPropagation();return!1});var handleTouchMoved=function(event){var evt=event.originalEvent;var touchPosition=evt.touches?evt.touches[0]:evt;this.touchStartPosition=this.touchStartPosition||touchPosition;var xMovement=Math.abs(this.touchStartPosition.clientX-touchPosition.clientX);var yMovement=Math.abs(this.touchStartPosition.clientY-touchPosition.clientY);var distance=Math.sqrt(xMovement*xMovement+yMovement*yMovement);if(distance>options.touchMovedThreshold){this.touchMoved=!0}}
month_picker.find('.xdsoft_select').xdsoftScroller(options).on('touchstart mousedown.xdsoft',function(event){var evt=event.originalEvent;this.touchMoved=!1;this.touchStartPosition=evt.touches?evt.touches[0]:evt;event.stopPropagation();event.preventDefault()}).on('touchmove','.xdsoft_option',handleTouchMoved).on('touchend mousedown.xdsoft','.xdsoft_option',function(){if(!this.touchMoved){if(_xdsoft_datetime.currentTime===undefined||_xdsoft_datetime.currentTime===null){_xdsoft_datetime.currentTime=_xdsoft_datetime.now()}
var year=_xdsoft_datetime.currentTime.getFullYear();if(_xdsoft_datetime&&_xdsoft_datetime.currentTime){_xdsoft_datetime.currentTime[$(this).parent().parent().hasClass('xdsoft_monthselect')?'setMonth':'setFullYear']($(this).data('value'))}
$(this).parent().parent().hide();datetimepicker.trigger('xchange.xdsoft');if(options.onChangeMonth&&$.isFunction(options.onChangeMonth)){options.onChangeMonth.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'))}
if(year!==_xdsoft_datetime.currentTime.getFullYear()&&$.isFunction(options.onChangeYear)){options.onChangeYear.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'))}}});datetimepicker.getValue=function(){return _xdsoft_datetime.getCurrentTime()};datetimepicker.setOptions=function(_options){var highlightedDates={};options=$.extend(!0,{},options,_options);if(_options.allowTimes&&$.isArray(_options.allowTimes)&&_options.allowTimes.length){options.allowTimes=$.extend(!0,[],_options.allowTimes)}
if(_options.weekends&&$.isArray(_options.weekends)&&_options.weekends.length){options.weekends=$.extend(!0,[],_options.weekends)}
if(_options.allowDates&&$.isArray(_options.allowDates)&&_options.allowDates.length){options.allowDates=$.extend(!0,[],_options.allowDates)}
if(_options.allowDateRe&&Object.prototype.toString.call(_options.allowDateRe)==="[object String]"){options.allowDateRe=new RegExp(_options.allowDateRe)}
if(_options.highlightedDates&&$.isArray(_options.highlightedDates)&&_options.highlightedDates.length){$.each(_options.highlightedDates,function(index,value){var splitData=$.map(value.split(','),$.trim),exDesc,hDate=new HighlightedDate(dateHelper.parseDate(splitData[0],options.formatDate),splitData[1],splitData[2]),keyDate=dateHelper.formatDate(hDate.date,options.formatDate);if(highlightedDates[keyDate]!==undefined){exDesc=highlightedDates[keyDate].desc;if(exDesc&&exDesc.length&&hDate.desc&&hDate.desc.length){highlightedDates[keyDate].desc=exDesc+"\n"+hDate.desc}}else{highlightedDates[keyDate]=hDate}});options.highlightedDates=$.extend(!0,[],highlightedDates)}
if(_options.highlightedPeriods&&$.isArray(_options.highlightedPeriods)&&_options.highlightedPeriods.length){highlightedDates=$.extend(!0,[],options.highlightedDates);$.each(_options.highlightedPeriods,function(index,value){var dateTest,dateEnd,desc,hDate,keyDate,exDesc,style;if($.isArray(value)){dateTest=value[0];dateEnd=value[1];desc=value[2];style=value[3]}else{var splitData=$.map(value.split(','),$.trim);dateTest=dateHelper.parseDate(splitData[0],options.formatDate);dateEnd=dateHelper.parseDate(splitData[1],options.formatDate);desc=splitData[2];style=splitData[3]}
while(dateTest<=dateEnd){hDate=new HighlightedDate(dateTest,desc,style);keyDate=dateHelper.formatDate(dateTest,options.formatDate);dateTest.setDate(dateTest.getDate()+1);if(highlightedDates[keyDate]!==undefined){exDesc=highlightedDates[keyDate].desc;if(exDesc&&exDesc.length&&hDate.desc&&hDate.desc.length){highlightedDates[keyDate].desc=exDesc+"\n"+hDate.desc}}else{highlightedDates[keyDate]=hDate}}});options.highlightedDates=$.extend(!0,[],highlightedDates)}
if(_options.disabledDates&&$.isArray(_options.disabledDates)&&_options.disabledDates.length){options.disabledDates=$.extend(!0,[],_options.disabledDates)}
if(_options.disabledWeekDays&&$.isArray(_options.disabledWeekDays)&&_options.disabledWeekDays.length){options.disabledWeekDays=$.extend(!0,[],_options.disabledWeekDays)}
if((options.open||options.opened)&&(!options.inline)){input.trigger('open.xdsoft')}
if(options.inline){triggerAfterOpen=!0;datetimepicker.addClass('xdsoft_inline');input.after(datetimepicker).hide()}
if(options.inverseButton){options.next='xdsoft_prev';options.prev='xdsoft_next'}
if(options.datepicker){datepicker.addClass('active')}else{datepicker.removeClass('active')}
if(options.timepicker){timepicker.addClass('active')}else{timepicker.removeClass('active')}
if(options.value){_xdsoft_datetime.setCurrentTime(options.value);if(input&&input.val){input.val(_xdsoft_datetime.str)}}
if(isNaN(options.dayOfWeekStart)){options.dayOfWeekStart=0}else{options.dayOfWeekStart=parseInt(options.dayOfWeekStart,10)%7}
if(!options.timepickerScrollbar){timeboxparent.xdsoftScroller(options,'hide')}
if(options.minDate&&/^[\+\-](.*)$/.test(options.minDate)){options.minDate=dateHelper.formatDate(_xdsoft_datetime.strToDateTime(options.minDate),options.formatDate)}
if(options.maxDate&&/^[\+\-](.*)$/.test(options.maxDate)){options.maxDate=dateHelper.formatDate(_xdsoft_datetime.strToDateTime(options.maxDate),options.formatDate)}
if(options.minDateTime&&/^\+(.*)$/.test(options.minDateTime)){options.minDateTime=_xdsoft_datetime.strToDateTime(options.minDateTime).dateFormat(options.formatDate)}
if(options.maxDateTime&&/^\+(.*)$/.test(options.maxDateTime)){options.maxDateTime=_xdsoft_datetime.strToDateTime(options.maxDateTime).dateFormat(options.formatDate)}
applyButton.toggle(options.showApplyButton);month_picker.find('.xdsoft_today_button').css('visibility',!options.todayButton?'hidden':'visible');month_picker.find('.'+options.prev).css('visibility',!options.prevButton?'hidden':'visible');month_picker.find('.'+options.next).css('visibility',!options.nextButton?'hidden':'visible');setMask(options);if(options.validateOnBlur){input.off('blur.xdsoft').on('blur.xdsoft',function(){if(options.allowBlank&&(!$.trim($(this).val()).length||(typeof options.mask==="string"&&$.trim($(this).val())===options.mask.replace(/[0-9]/g,'_')))){$(this).val(null);datetimepicker.data('xdsoft_datetime').empty()}else{var d=dateHelper.parseDate($(this).val(),options.format);if(d){$(this).val(dateHelper.formatDate(d,options.format))}else{var splittedHours=+([$(this).val()[0],$(this).val()[1]].join('')),splittedMinutes=+([$(this).val()[2],$(this).val()[3]].join(''));if(!options.datepicker&&options.timepicker&&splittedHours>=0&&splittedHours<24&&splittedMinutes>=0&&splittedMinutes<60){$(this).val([splittedHours,splittedMinutes].map(function(item){return item>9?item:'0'+item}).join(':'))}else{$(this).val(dateHelper.formatDate(_xdsoft_datetime.now(),options.format))}}
datetimepicker.data('xdsoft_datetime').setCurrentTime($(this).val())}
datetimepicker.trigger('changedatetime.xdsoft');datetimepicker.trigger('close.xdsoft')})}
options.dayOfWeekStartPrev=(options.dayOfWeekStart===0)?6:options.dayOfWeekStart-1;datetimepicker.trigger('xchange.xdsoft').trigger('afterOpen.xdsoft')};datetimepicker.data('options',options).on('touchstart mousedown.xdsoft',function(event){event.stopPropagation();event.preventDefault();yearselect.hide();monthselect.hide();return!1});timeboxparent.append(timebox);timeboxparent.xdsoftScroller(options);datetimepicker.on('afterOpen.xdsoft',function(){timeboxparent.xdsoftScroller(options)});datetimepicker.append(datepicker).append(timepicker);if(options.withoutCopyright!==!0){datetimepicker.append(xdsoft_copyright)}
datepicker.append(month_picker).append(calendar).append(applyButton);if(options.insideParent){$(input).parent().append(datetimepicker)}else{$(options.parentID).append(datetimepicker)}
XDSoft_datetime=function(){var _this=this;_this.now=function(norecursion){var d=new Date(),date,time;if(!norecursion&&options.defaultDate){date=_this.strToDateTime(options.defaultDate);d.setFullYear(date.getFullYear());d.setMonth(date.getMonth());d.setDate(date.getDate())}
d.setFullYear(d.getFullYear());if(!norecursion&&options.defaultTime){time=_this.strtotime(options.defaultTime);d.setHours(time.getHours());d.setMinutes(time.getMinutes());d.setSeconds(time.getSeconds());d.setMilliseconds(time.getMilliseconds())}
return d};_this.isValidDate=function(d){if(Object.prototype.toString.call(d)!=="[object Date]"){return!1}
return!isNaN(d.getTime())};_this.setCurrentTime=function(dTime,requireValidDate){if(typeof dTime==='string'){_this.currentTime=_this.strToDateTime(dTime)}else if(_this.isValidDate(dTime)){_this.currentTime=dTime}else if(!dTime&&!requireValidDate&&options.allowBlank&&!options.inline){_this.currentTime=null}else{_this.currentTime=_this.now()}
datetimepicker.trigger('xchange.xdsoft')};_this.empty=function(){_this.currentTime=null};_this.getCurrentTime=function(){return _this.currentTime};_this.nextMonth=function(){if(_this.currentTime===undefined||_this.currentTime===null){_this.currentTime=_this.now()}
var month=_this.currentTime.getMonth()+1,year;if(month===12){_this.currentTime.setFullYear(_this.currentTime.getFullYear()+1);month=0}
year=_this.currentTime.getFullYear();_this.currentTime.setDate(Math.min(new Date(_this.currentTime.getFullYear(),month+1,0).getDate(),_this.currentTime.getDate()));_this.currentTime.setMonth(month);if(options.onChangeMonth&&$.isFunction(options.onChangeMonth)){options.onChangeMonth.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'))}
if(year!==_this.currentTime.getFullYear()&&$.isFunction(options.onChangeYear)){options.onChangeYear.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'))}
datetimepicker.trigger('xchange.xdsoft');return month};_this.prevMonth=function(){if(_this.currentTime===undefined||_this.currentTime===null){_this.currentTime=_this.now()}
var month=_this.currentTime.getMonth()-1;if(month===-1){_this.currentTime.setFullYear(_this.currentTime.getFullYear()-1);month=11}
_this.currentTime.setDate(Math.min(new Date(_this.currentTime.getFullYear(),month+1,0).getDate(),_this.currentTime.getDate()));_this.currentTime.setMonth(month);if(options.onChangeMonth&&$.isFunction(options.onChangeMonth)){options.onChangeMonth.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'))}
datetimepicker.trigger('xchange.xdsoft');return month};_this.getWeekOfYear=function(datetime){if(options.onGetWeekOfYear&&$.isFunction(options.onGetWeekOfYear)){var week=options.onGetWeekOfYear.call(datetimepicker,datetime);if(typeof week!=='undefined'){return week}}
var onejan=new Date(datetime.getFullYear(),0,1);if(onejan.getDay()!==4){onejan.setMonth(0,1+((4-onejan.getDay()+7)%7))}
return Math.ceil((((datetime-onejan)/86400000)+onejan.getDay()+1)/7)};_this.strToDateTime=function(sDateTime){var tmpDate=[],timeOffset,currentTime;if(sDateTime&&sDateTime instanceof Date&&_this.isValidDate(sDateTime)){return sDateTime}
tmpDate=/^([+-]{1})(.*)$/.exec(sDateTime);if(tmpDate){tmpDate[2]=dateHelper.parseDate(tmpDate[2],options.formatDate)}
if(tmpDate&&tmpDate[2]){timeOffset=tmpDate[2].getTime()-(tmpDate[2].getTimezoneOffset())*60000;currentTime=new Date((_this.now(!0)).getTime()+parseInt(tmpDate[1]+'1',10)*timeOffset)}else{currentTime=sDateTime?dateHelper.parseDate(sDateTime,options.format):_this.now()}
if(!_this.isValidDate(currentTime)){currentTime=_this.now()}
return currentTime};_this.strToDate=function(sDate){if(sDate&&sDate instanceof Date&&_this.isValidDate(sDate)){return sDate}
var currentTime=sDate?dateHelper.parseDate(sDate,options.formatDate):_this.now(!0);if(!_this.isValidDate(currentTime)){currentTime=_this.now(!0)}
return currentTime};_this.strtotime=function(sTime){if(sTime&&sTime instanceof Date&&_this.isValidDate(sTime)){return sTime}
var currentTime=sTime?dateHelper.parseDate(sTime,options.formatTime):_this.now(!0);if(!_this.isValidDate(currentTime)){currentTime=_this.now(!0)}
return currentTime};_this.str=function(){var format=options.format;if(options.yearOffset){format=format.replace('Y',_this.currentTime.getFullYear()+options.yearOffset);format=format.replace('y',String(_this.currentTime.getFullYear()+options.yearOffset).substring(2,4))}
return dateHelper.formatDate(_this.currentTime,format)};_this.currentTime=this.now()};_xdsoft_datetime=new XDSoft_datetime();applyButton.on('touchend click',function(e){e.preventDefault();datetimepicker.data('changed',!0);_xdsoft_datetime.setCurrentTime(getCurrentValue());input.val(_xdsoft_datetime.str());datetimepicker.trigger('close.xdsoft')});month_picker.find('.xdsoft_today_button').on('touchend mousedown.xdsoft',function(){datetimepicker.data('changed',!0);_xdsoft_datetime.setCurrentTime(0,!0);datetimepicker.trigger('afterOpen.xdsoft')}).on('dblclick.xdsoft',function(){var currentDate=_xdsoft_datetime.getCurrentTime(),minDate,maxDate;currentDate=new Date(currentDate.getFullYear(),currentDate.getMonth(),currentDate.getDate());minDate=_xdsoft_datetime.strToDate(options.minDate);minDate=new Date(minDate.getFullYear(),minDate.getMonth(),minDate.getDate());if(currentDate<minDate){return}
maxDate=_xdsoft_datetime.strToDate(options.maxDate);maxDate=new Date(maxDate.getFullYear(),maxDate.getMonth(),maxDate.getDate());if(currentDate>maxDate){return}
input.val(_xdsoft_datetime.str());input.trigger('change');datetimepicker.trigger('close.xdsoft')});month_picker.find('.xdsoft_prev,.xdsoft_next').on('touchend mousedown.xdsoft',function(){var $this=$(this),timer=0,stop=!1;(function arguments_callee1(v){if($this.hasClass(options.next)){_xdsoft_datetime.nextMonth()}else if($this.hasClass(options.prev)){_xdsoft_datetime.prevMonth()}
if(options.monthChangeSpinner){if(!stop){timer=setTimeout(arguments_callee1,v||100)}}}(500));$([options.ownerDocument.body,options.contentWindow]).on('touchend mouseup.xdsoft',function arguments_callee2(){clearTimeout(timer);stop=!0;$([options.ownerDocument.body,options.contentWindow]).off('touchend mouseup.xdsoft',arguments_callee2)})});timepicker.find('.xdsoft_prev,.xdsoft_next').on('touchend mousedown.xdsoft',function(){var $this=$(this),timer=0,stop=!1,period=110;(function arguments_callee4(v){var pheight=timeboxparent[0].clientHeight,height=timebox[0].offsetHeight,top=Math.abs(parseInt(timebox.css('marginTop'),10));if($this.hasClass(options.next)&&(height-pheight)-options.timeHeightInTimePicker>=top){timebox.css('marginTop','-'+(top+options.timeHeightInTimePicker)+'px')}else if($this.hasClass(options.prev)&&top-options.timeHeightInTimePicker>=0){timebox.css('marginTop','-'+(top-options.timeHeightInTimePicker)+'px')}
timeboxparent.trigger('scroll_element.xdsoft_scroller',[Math.abs(parseInt(timebox[0].style.marginTop,10)/(height-pheight))]);period=(period>10)?10:period-10;if(!stop){timer=setTimeout(arguments_callee4,v||period)}}(500));$([options.ownerDocument.body,options.contentWindow]).on('touchend mouseup.xdsoft',function arguments_callee5(){clearTimeout(timer);stop=!0;$([options.ownerDocument.body,options.contentWindow]).off('touchend mouseup.xdsoft',arguments_callee5)})});xchangeTimer=0;datetimepicker.on('xchange.xdsoft',function(event){clearTimeout(xchangeTimer);xchangeTimer=setTimeout(function(){if(_xdsoft_datetime.currentTime===undefined||_xdsoft_datetime.currentTime===null){_xdsoft_datetime.currentTime=_xdsoft_datetime.now()}
var table='',start=new Date(_xdsoft_datetime.currentTime.getFullYear(),_xdsoft_datetime.currentTime.getMonth(),1,12,0,0),i=0,j,today=_xdsoft_datetime.now(),maxDate=!1,minDate=!1,minDateTime=!1,maxDateTime=!1,hDate,day,d,y,m,w,classes=[],customDateSettings,newRow=!0,time='',h,line_time,description;while(start.getDay()!==options.dayOfWeekStart){start.setDate(start.getDate()-1)}
table+='<table><thead><tr>';if(options.weeks){table+='<th></th>'}
for(j=0;j<7;j+=1){table+='<th>'+options.i18n[globalLocale].dayOfWeekShort[(j+options.dayOfWeekStart)%7]+'</th>'}
table+='</tr></thead>';table+='<tbody>';if(options.maxDate!==!1){maxDate=_xdsoft_datetime.strToDate(options.maxDate);maxDate=new Date(maxDate.getFullYear(),maxDate.getMonth(),maxDate.getDate(),23,59,59,999)}
if(options.minDate!==!1){minDate=_xdsoft_datetime.strToDate(options.minDate);minDate=new Date(minDate.getFullYear(),minDate.getMonth(),minDate.getDate())}
if(options.minDateTime!==!1){minDateTime=_xdsoft_datetime.strToDate(options.minDateTime);minDateTime=new Date(minDateTime.getFullYear(),minDateTime.getMonth(),minDateTime.getDate(),minDateTime.getHours(),minDateTime.getMinutes(),minDateTime.getSeconds())}
if(options.maxDateTime!==!1){maxDateTime=_xdsoft_datetime.strToDate(options.maxDateTime);maxDateTime=new Date(maxDateTime.getFullYear(),maxDateTime.getMonth(),maxDateTime.getDate(),maxDateTime.getHours(),maxDateTime.getMinutes(),maxDateTime.getSeconds())}
var maxDateTimeDay;if(maxDateTime!==!1){maxDateTimeDay=((maxDateTime.getFullYear()*12)+maxDateTime.getMonth())*31+maxDateTime.getDate()}
while(i<_xdsoft_datetime.currentTime.countDaysInMonth()||start.getDay()!==options.dayOfWeekStart||_xdsoft_datetime.currentTime.getMonth()===start.getMonth()){classes=[];i+=1;day=start.getDay();d=start.getDate();y=start.getFullYear();m=start.getMonth();w=_xdsoft_datetime.getWeekOfYear(start);description='';classes.push('xdsoft_date');if(options.beforeShowDay&&$.isFunction(options.beforeShowDay.call)){customDateSettings=options.beforeShowDay.call(datetimepicker,start)}else{customDateSettings=null}
if(options.allowDateRe&&Object.prototype.toString.call(options.allowDateRe)==="[object RegExp]"){if(!options.allowDateRe.test(dateHelper.formatDate(start,options.formatDate))){classes.push('xdsoft_disabled')}}
if(options.allowDates&&options.allowDates.length>0){if(options.allowDates.indexOf(dateHelper.formatDate(start,options.formatDate))===-1){classes.push('xdsoft_disabled')}}
var currentDay=((start.getFullYear()*12)+start.getMonth())*31+start.getDate();if((maxDate!==!1&&start>maxDate)||(minDateTime!==!1&&start<minDateTime)||(minDate!==!1&&start<minDate)||(maxDateTime!==!1&&currentDay>maxDateTimeDay)||(customDateSettings&&customDateSettings[0]===!1)){classes.push('xdsoft_disabled')}
if(options.disabledDates.indexOf(dateHelper.formatDate(start,options.formatDate))!==-1){classes.push('xdsoft_disabled')}
if(options.disabledWeekDays.indexOf(day)!==-1){classes.push('xdsoft_disabled')}
if(input.is('[disabled]')){classes.push('xdsoft_disabled')}
if(customDateSettings&&customDateSettings[1]!==""){classes.push(customDateSettings[1])}
if(_xdsoft_datetime.currentTime.getMonth()!==m){classes.push('xdsoft_other_month')}
if((options.defaultSelect||datetimepicker.data('changed'))&&dateHelper.formatDate(_xdsoft_datetime.currentTime,options.formatDate)===dateHelper.formatDate(start,options.formatDate)){classes.push('xdsoft_current')}
if(dateHelper.formatDate(today,options.formatDate)===dateHelper.formatDate(start,options.formatDate)){classes.push('xdsoft_today')}
if(start.getDay()===0||start.getDay()===6||options.weekends.indexOf(dateHelper.formatDate(start,options.formatDate))!==-1){classes.push('xdsoft_weekend')}
if(options.highlightedDates[dateHelper.formatDate(start,options.formatDate)]!==undefined){hDate=options.highlightedDates[dateHelper.formatDate(start,options.formatDate)];classes.push(hDate.style===undefined?'xdsoft_highlighted_default':hDate.style);description=hDate.desc===undefined?'':hDate.desc}
if(options.beforeShowDay&&$.isFunction(options.beforeShowDay)){classes.push(options.beforeShowDay(start))}
if(newRow){table+='<tr>';newRow=!1;if(options.weeks){table+='<th>'+w+'</th>'}}
table+='<td data-date="'+d+'" data-month="'+m+'" data-year="'+y+'"'+' class="xdsoft_date xdsoft_day_of_week'+start.getDay()+' '+classes.join(' ')+'" title="'+description+'">'+'<div>'+d+'</div>'+'</td>';if(start.getDay()===options.dayOfWeekStartPrev){table+='</tr>';newRow=!0}
start.setDate(d+1)}
table+='</tbody></table>';calendar.html(table);month_picker.find('.xdsoft_label span').eq(0).text(options.i18n[globalLocale].months[_xdsoft_datetime.currentTime.getMonth()]);month_picker.find('.xdsoft_label span').eq(1).text(_xdsoft_datetime.currentTime.getFullYear()+options.yearOffset);time='';h='';m='';var minTimeMinutesOfDay=0;if(options.minTime!==!1){var t=_xdsoft_datetime.strtotime(options.minTime);minTimeMinutesOfDay=60*t.getHours()+t.getMinutes()}
var maxTimeMinutesOfDay=24*60;if(options.maxTime!==!1){var t=_xdsoft_datetime.strtotime(options.maxTime);maxTimeMinutesOfDay=60*t.getHours()+t.getMinutes()}
if(options.minDateTime!==!1){var t=_xdsoft_datetime.strToDateTime(options.minDateTime);var currentDayIsMinDateTimeDay=dateHelper.formatDate(_xdsoft_datetime.currentTime,options.formatDate)===dateHelper.formatDate(t,options.formatDate);if(currentDayIsMinDateTimeDay){var m=60*t.getHours()+t.getMinutes();if(m>minTimeMinutesOfDay)minTimeMinutesOfDay=m}}
if(options.maxDateTime!==!1){var t=_xdsoft_datetime.strToDateTime(options.maxDateTime);var currentDayIsMaxDateTimeDay=dateHelper.formatDate(_xdsoft_datetime.currentTime,options.formatDate)===dateHelper.formatDate(t,options.formatDate);if(currentDayIsMaxDateTimeDay){var m=60*t.getHours()+t.getMinutes();if(m<maxTimeMinutesOfDay)maxTimeMinutesOfDay=m}}
line_time=function line_time(h,m){var now=_xdsoft_datetime.now(),current_time,isALlowTimesInit=options.allowTimes&&$.isArray(options.allowTimes)&&options.allowTimes.length;now.setHours(h);h=parseInt(now.getHours(),10);now.setMinutes(m);m=parseInt(now.getMinutes(),10);classes=[];var currentMinutesOfDay=60*h+m;if(input.is('[disabled]')||(currentMinutesOfDay>=maxTimeMinutesOfDay)||(currentMinutesOfDay<minTimeMinutesOfDay)){classes.push('xdsoft_disabled')}
current_time=new Date(_xdsoft_datetime.currentTime);current_time.setHours(parseInt(_xdsoft_datetime.currentTime.getHours(),10));if(!isALlowTimesInit){current_time.setMinutes(Math[options.roundTime](_xdsoft_datetime.currentTime.getMinutes()/options.step)*options.step)}
if((options.initTime||options.defaultSelect||datetimepicker.data('changed'))&&current_time.getHours()===parseInt(h,10)&&((!isALlowTimesInit&&options.step>59)||current_time.getMinutes()===parseInt(m,10))){if(options.defaultSelect||datetimepicker.data('changed')){classes.push('xdsoft_current')}else if(options.initTime){classes.push('xdsoft_init_time')}}
if(parseInt(today.getHours(),10)===parseInt(h,10)&&parseInt(today.getMinutes(),10)===parseInt(m,10)){classes.push('xdsoft_today')}
time+='<div class="xdsoft_time '+classes.join(' ')+'" data-hour="'+h+'" data-minute="'+m+'">'+dateHelper.formatDate(now,options.formatTime)+'</div>'};if(!options.allowTimes||!$.isArray(options.allowTimes)||!options.allowTimes.length){for(i=0,j=0;i<(options.hours12?12:24);i+=1){for(j=0;j<60;j+=options.step){var currentMinutesOfDay=i*60+j;if(currentMinutesOfDay<minTimeMinutesOfDay)continue;if(currentMinutesOfDay>=maxTimeMinutesOfDay)continue;h=(i<10?'0':'')+i;m=(j<10?'0':'')+j;line_time(h,m)}}}else{for(i=0;i<options.allowTimes.length;i+=1){h=_xdsoft_datetime.strtotime(options.allowTimes[i]).getHours();m=_xdsoft_datetime.strtotime(options.allowTimes[i]).getMinutes();line_time(h,m)}}
timebox.html(time);opt='';for(i=parseInt(options.yearStart,10);i<=parseInt(options.yearEnd,10);i+=1){opt+='<div class="xdsoft_option '+(_xdsoft_datetime.currentTime.getFullYear()===i?'xdsoft_current':'')+'" data-value="'+i+'">'+(i+options.yearOffset)+'</div>'}
yearselect.children().eq(0).html(opt);for(i=parseInt(options.monthStart,10),opt='';i<=parseInt(options.monthEnd,10);i+=1){opt+='<div class="xdsoft_option '+(_xdsoft_datetime.currentTime.getMonth()===i?'xdsoft_current':'')+'" data-value="'+i+'">'+options.i18n[globalLocale].months[i]+'</div>'}
monthselect.children().eq(0).html(opt);$(datetimepicker).trigger('generate.xdsoft')},10);event.stopPropagation()}).on('afterOpen.xdsoft',function(){if(options.timepicker){var classType,pheight,height,top;if(timebox.find('.xdsoft_current').length){classType='.xdsoft_current'}else if(timebox.find('.xdsoft_init_time').length){classType='.xdsoft_init_time'}
if(classType){pheight=timeboxparent[0].clientHeight;height=timebox[0].offsetHeight;top=timebox.find(classType).index()*options.timeHeightInTimePicker+1;if((height-pheight)<top){top=height-pheight}
timeboxparent.trigger('scroll_element.xdsoft_scroller',[parseInt(top,10)/(height-pheight)])}else{timeboxparent.trigger('scroll_element.xdsoft_scroller',[0])}}});timerclick=0;calendar.on('touchend click.xdsoft','td',function(xdevent){xdevent.stopPropagation();timerclick+=1;var $this=$(this),currentTime=_xdsoft_datetime.currentTime;if(currentTime===undefined||currentTime===null){_xdsoft_datetime.currentTime=_xdsoft_datetime.now();currentTime=_xdsoft_datetime.currentTime}
if($this.hasClass('xdsoft_disabled')){return!1}
currentTime.setDate(1);currentTime.setFullYear($this.data('year'));currentTime.setMonth($this.data('month'));currentTime.setDate($this.data('date'));datetimepicker.trigger('select.xdsoft',[currentTime]);input.val(_xdsoft_datetime.str());if(options.onSelectDate&&$.isFunction(options.onSelectDate)){options.onSelectDate.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'),xdevent)}
datetimepicker.data('changed',!0);datetimepicker.trigger('xchange.xdsoft');datetimepicker.trigger('changedatetime.xdsoft');if((timerclick>1||(options.closeOnDateSelect===!0||(options.closeOnDateSelect===!1&&!options.timepicker)))&&!options.inline){datetimepicker.trigger('close.xdsoft')}
setTimeout(function(){timerclick=0},200)});timebox.on('touchstart','div',function(xdevent){this.touchMoved=!1}).on('touchmove','div',handleTouchMoved).on('touchend click.xdsoft','div',function(xdevent){if(!this.touchMoved){xdevent.stopPropagation();var $this=$(this),currentTime=_xdsoft_datetime.currentTime;if(currentTime===undefined||currentTime===null){_xdsoft_datetime.currentTime=_xdsoft_datetime.now();currentTime=_xdsoft_datetime.currentTime}
if($this.hasClass('xdsoft_disabled')){return!1}
currentTime.setHours($this.data('hour'));currentTime.setMinutes($this.data('minute'));datetimepicker.trigger('select.xdsoft',[currentTime]);datetimepicker.data('input').val(_xdsoft_datetime.str());if(options.onSelectTime&&$.isFunction(options.onSelectTime)){options.onSelectTime.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'),xdevent)}
datetimepicker.data('changed',!0);datetimepicker.trigger('xchange.xdsoft');datetimepicker.trigger('changedatetime.xdsoft');if(options.inline!==!0&&options.closeOnTimeSelect===!0){datetimepicker.trigger('close.xdsoft')}}});datepicker.on('mousewheel.xdsoft',function(event){if(!options.scrollMonth){return!0}
if(event.deltaY<0){_xdsoft_datetime.nextMonth()}else{_xdsoft_datetime.prevMonth()}
return!1});input.on('mousewheel.xdsoft',function(event){if(!options.scrollInput){return!0}
if(!options.datepicker&&options.timepicker){current_time_index=timebox.find('.xdsoft_current').length?timebox.find('.xdsoft_current').eq(0).index():0;if(current_time_index+event.deltaY>=0&&current_time_index+event.deltaY<timebox.children().length){current_time_index+=event.deltaY}
if(timebox.children().eq(current_time_index).length){timebox.children().eq(current_time_index).trigger('mousedown')}
return!1}
if(options.datepicker&&!options.timepicker){datepicker.trigger(event,[event.deltaY,event.deltaX,event.deltaY]);if(input.val){input.val(_xdsoft_datetime.str())}
datetimepicker.trigger('changedatetime.xdsoft');return!1}});datetimepicker.on('changedatetime.xdsoft',function(event){if(options.onChangeDateTime&&$.isFunction(options.onChangeDateTime)){var $input=datetimepicker.data('input');options.onChangeDateTime.call(datetimepicker,_xdsoft_datetime.currentTime,$input,event);delete options.value;$input.trigger('change')}}).on('generate.xdsoft',function(){if(options.onGenerate&&$.isFunction(options.onGenerate)){options.onGenerate.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'))}
if(triggerAfterOpen){datetimepicker.trigger('afterOpen.xdsoft');triggerAfterOpen=!1}}).on('click.xdsoft',function(xdevent){xdevent.stopPropagation()});current_time_index=0;forEachAncestorOf=function(node,callback){do{node=node.parentNode;if(!node||callback(node)===!1){break}}while(node.nodeName!=='HTML');};setPos=function(){var dateInputOffset,dateInputElem,verticalPosition,left,position,datetimepickerElem,dateInputHasFixedAncestor,$dateInput,windowWidth,verticalAnchorEdge,datetimepickerCss,windowHeight,windowScrollTop;$dateInput=datetimepicker.data('input');dateInputOffset=$dateInput.offset();dateInputElem=$dateInput[0];verticalAnchorEdge='top';verticalPosition=(dateInputOffset.top+dateInputElem.offsetHeight)-1;left=dateInputOffset.left;position="absolute";windowWidth=$(options.contentWindow).width();windowHeight=$(options.contentWindow).height();windowScrollTop=$(options.contentWindow).scrollTop();if((options.ownerDocument.documentElement.clientWidth-dateInputOffset.left)<datepicker.parent().outerWidth(!0)){var diff=datepicker.parent().outerWidth(!0)-dateInputElem.offsetWidth;left=left-diff}
if($dateInput.parent().css('direction')==='rtl'){left-=(datetimepicker.outerWidth()-$dateInput.outerWidth())}
if(options.fixed){verticalPosition-=windowScrollTop;left-=$(options.contentWindow).scrollLeft();position="fixed"}else{dateInputHasFixedAncestor=!1;forEachAncestorOf(dateInputElem,function(ancestorNode){if(ancestorNode===null){return!1}
if(options.contentWindow.getComputedStyle(ancestorNode).getPropertyValue('position')==='fixed'){dateInputHasFixedAncestor=!0;return!1}});if(dateInputHasFixedAncestor&&!options.insideParent){position='fixed';if(verticalPosition+datetimepicker.outerHeight()>windowHeight+windowScrollTop){verticalAnchorEdge='bottom';verticalPosition=(windowHeight+windowScrollTop)-dateInputOffset.top}else{verticalPosition-=windowScrollTop}}else{if(verticalPosition+datetimepicker[0].offsetHeight>windowHeight+windowScrollTop){verticalPosition=dateInputOffset.top-datetimepicker[0].offsetHeight+1}}
if(verticalPosition<0){verticalPosition=0}
if(left+dateInputElem.offsetWidth>windowWidth){left=windowWidth-dateInputElem.offsetWidth}}
datetimepickerElem=datetimepicker[0];forEachAncestorOf(datetimepickerElem,function(ancestorNode){var ancestorNodePosition;ancestorNodePosition=options.contentWindow.getComputedStyle(ancestorNode).getPropertyValue('position');if(ancestorNodePosition==='relative'&&windowWidth>=ancestorNode.offsetWidth){left=left-((windowWidth-ancestorNode.offsetWidth)/2);return!1}});datetimepickerCss={position:position,left:options.insideParent?dateInputElem.offsetLeft:left,top:'',bottom:''};if(options.insideParent){datetimepickerCss[verticalAnchorEdge]=dateInputElem.offsetTop+dateInputElem.offsetHeight}else{datetimepickerCss[verticalAnchorEdge]=verticalPosition}
datetimepicker.css(datetimepickerCss)};datetimepicker.on('open.xdsoft',function(event){var onShow=!0;if(options.onShow&&$.isFunction(options.onShow)){onShow=options.onShow.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'),event)}
if(onShow!==!1){datetimepicker.show();setPos();$(options.contentWindow).off('resize.xdsoft',setPos).on('resize.xdsoft',setPos);if(options.closeOnWithoutClick){$([options.ownerDocument.body,options.contentWindow]).on('touchstart mousedown.xdsoft',function arguments_callee6(){datetimepicker.trigger('close.xdsoft');$([options.ownerDocument.body,options.contentWindow]).off('touchstart mousedown.xdsoft',arguments_callee6)})}}}).on('close.xdsoft',function(event){var onClose=!0;month_picker.find('.xdsoft_month,.xdsoft_year').find('.xdsoft_select').hide();if(options.onClose&&$.isFunction(options.onClose)){onClose=options.onClose.call(datetimepicker,_xdsoft_datetime.currentTime,datetimepicker.data('input'),event)}
if(onClose!==!1&&!options.opened&&!options.inline){datetimepicker.hide()}
event.stopPropagation()}).on('toggle.xdsoft',function(){if(datetimepicker.is(':visible')){datetimepicker.trigger('close.xdsoft')}else{datetimepicker.trigger('open.xdsoft')}}).data('input',input);timer=0;datetimepicker.data('xdsoft_datetime',_xdsoft_datetime);datetimepicker.setOptions(options);function getCurrentValue(){var ct=!1,time;if(options.startDate){ct=_xdsoft_datetime.strToDate(options.startDate)}else{ct=options.value||((input&&input.val&&input.val())?input.val():'');if(ct){ct=_xdsoft_datetime.strToDateTime(ct);if(options.yearOffset){ct=new Date(ct.getFullYear()-options.yearOffset,ct.getMonth(),ct.getDate(),ct.getHours(),ct.getMinutes(),ct.getSeconds(),ct.getMilliseconds())}}else if(options.defaultDate){ct=_xdsoft_datetime.strToDateTime(options.defaultDate);if(options.defaultTime){time=_xdsoft_datetime.strtotime(options.defaultTime);ct.setHours(time.getHours());ct.setMinutes(time.getMinutes())}}}
if(ct&&_xdsoft_datetime.isValidDate(ct)){datetimepicker.data('changed',!0)}else{ct=''}
return ct||0}
function setMask(options){var isValidValue=function(mask,value){var reg=mask.replace(/([\[\]\/\{\}\(\)\-\.\+]{1})/g,'\\$1').replace(/_/g,'{digit+}').replace(/([0-9]{1})/g,'{digit$1}').replace(/\{digit([0-9]{1})\}/g,'[0-$1_]{1}').replace(/\{digit[\+]\}/g,'[0-9_]{1}');return(new RegExp(reg)).test(value)},getCaretPos=function(input){try{if(options.ownerDocument.selection&&options.ownerDocument.selection.createRange){var range=options.ownerDocument.selection.createRange();return range.getBookmark().charCodeAt(2)-2}
if(input.setSelectionRange){return input.selectionStart}}catch(e){return 0}},setCaretPos=function(node,pos){node=(typeof node==="string"||node instanceof String)?options.ownerDocument.getElementById(node):node;if(!node){return!1}
if(node.createTextRange){var textRange=node.createTextRange();textRange.collapse(!0);textRange.moveEnd('character',pos);textRange.moveStart('character',pos);textRange.select();return!0}
if(node.setSelectionRange){node.setSelectionRange(pos,pos);return!0}
return!1};if(options.mask){input.off('keydown.xdsoft')}
if(options.mask===!0){if(dateHelper.formatMask){options.mask=dateHelper.formatMask(options.format)}else{options.mask=options.format.replace(/Y/g,'9999').replace(/F/g,'9999').replace(/m/g,'19').replace(/d/g,'39').replace(/H/g,'29').replace(/i/g,'59').replace(/s/g,'59')}}
if($.type(options.mask)==='string'){if(!isValidValue(options.mask,input.val())){input.val(options.mask.replace(/[0-9]/g,'_'));setCaretPos(input[0],0)}
input.on('paste.xdsoft',function(event){var clipboardData=event.clipboardData||event.originalEvent.clipboardData||window.clipboardData,pastedData=clipboardData.getData('text'),val=this.value,pos=this.selectionStart
var valueBeforeCursor=val.substr(0,pos);var valueAfterPaste=val.substr(pos+pastedData.length);val=valueBeforeCursor+pastedData+valueAfterPaste;pos+=pastedData.length;if(isValidValue(options.mask,val)){this.value=val;setCaretPos(this,pos)}else if($.trim(val)===''){this.value=options.mask.replace(/[0-9]/g,'_')}else{input.trigger('error_input.xdsoft')}
event.preventDefault();return!1});input.on('keydown.xdsoft',function(event){var val=this.value,key=event.which,pos=this.selectionStart,selEnd=this.selectionEnd,hasSel=pos!==selEnd,digit;if(((key>=KEY0&&key<=KEY9)||(key>=_KEY0&&key<=_KEY9))||(key===BACKSPACE||key===DEL)){digit=(key===BACKSPACE||key===DEL)?'_':String.fromCharCode((_KEY0<=key&&key<=_KEY9)?key-KEY0:key);if(key===BACKSPACE&&pos&&!hasSel){pos-=1}
while(!0){var maskValueAtCurPos=options.mask.substr(pos,1);var posShorterThanMaskLength=pos<options.mask.length;var posGreaterThanZero=pos>0;var notNumberOrPlaceholder=/[^0-9_]/;var curPosOnSep=notNumberOrPlaceholder.test(maskValueAtCurPos);var continueMovingPosition=curPosOnSep&&posShorterThanMaskLength&&posGreaterThanZero
if(!continueMovingPosition)break;pos+=(key===BACKSPACE&&!hasSel)?-1:1}
if(event.metaKey){pos=0;hasSel=!0}
if(hasSel){var selLength=selEnd-pos
var defaultBlank=options.mask.replace(/[0-9]/g,'_');var defaultBlankSelectionReplacement=defaultBlank.substr(pos,selLength);var selReplacementRemainder=defaultBlankSelectionReplacement.substr(1)
var valueBeforeSel=val.substr(0,pos);var insertChars=digit+selReplacementRemainder;var charsAfterSelection=val.substr(pos+selLength);val=valueBeforeSel+insertChars+charsAfterSelection}else{var valueBeforeCursor=val.substr(0,pos);var insertChar=digit;var valueAfterNextChar=val.substr(pos+1);val=valueBeforeCursor+insertChar+valueAfterNextChar}
if($.trim(val)===''){val=defaultBlank}else{if(pos===options.mask.length){event.preventDefault();return!1}}
pos+=(key===BACKSPACE)?0:1;while(/[^0-9_]/.test(options.mask.substr(pos,1))&&pos<options.mask.length&&pos>0){pos+=(key===BACKSPACE)?0:1}
if(isValidValue(options.mask,val)){this.value=val;setCaretPos(this,pos)}else if($.trim(val)===''){this.value=options.mask.replace(/[0-9]/g,'_')}else{input.trigger('error_input.xdsoft')}}else{if(([AKEY,CKEY,VKEY,ZKEY,YKEY].indexOf(key)!==-1&&ctrlDown)||[ESC,ARROWUP,ARROWDOWN,ARROWLEFT,ARROWRIGHT,F5,CTRLKEY,TAB,ENTER].indexOf(key)!==-1){return!0}}
event.preventDefault();return!1})}}
_xdsoft_datetime.setCurrentTime(getCurrentValue());input.data('xdsoft_datetimepicker',datetimepicker).on('open.xdsoft focusin.xdsoft mousedown.xdsoft touchstart',function(){if(input.is(':disabled')||(input.data('xdsoft_datetimepicker').is(':visible')&&options.closeOnInputClick)){return}
if(!options.openOnFocus){return}
clearTimeout(timer);timer=setTimeout(function(){if(input.is(':disabled')){return}
triggerAfterOpen=!0;_xdsoft_datetime.setCurrentTime(getCurrentValue(),!0);if(options.mask){setMask(options)}
datetimepicker.trigger('open.xdsoft')},100)}).on('keydown.xdsoft',function(event){var elementSelector,key=event.which;if([ENTER].indexOf(key)!==-1&&options.enterLikeTab){elementSelector=$("input:visible,textarea:visible,button:visible,a:visible");datetimepicker.trigger('close.xdsoft');elementSelector.eq(elementSelector.index(this)+1).focus();return!1}
if([TAB].indexOf(key)!==-1){datetimepicker.trigger('close.xdsoft');return!0}}).on('blur.xdsoft',function(){datetimepicker.trigger('close.xdsoft')})};destroyDateTimePicker=function(input){var datetimepicker=input.data('xdsoft_datetimepicker');if(datetimepicker){datetimepicker.data('xdsoft_datetime',null);datetimepicker.remove();input.data('xdsoft_datetimepicker',null).off('.xdsoft');$(options.contentWindow).off('resize.xdsoft');$([options.contentWindow,options.ownerDocument.body]).off('mousedown.xdsoft touchstart');if(input.unmousewheel){input.unmousewheel()}}};$(options.ownerDocument).off('keydown.xdsoftctrl keyup.xdsoftctrl').off('keydown.xdsoftcmd keyup.xdsoftcmd').on('keydown.xdsoftctrl',function(e){if(e.keyCode===CTRLKEY){ctrlDown=!0}}).on('keyup.xdsoftctrl',function(e){if(e.keyCode===CTRLKEY){ctrlDown=!1}}).on('keydown.xdsoftcmd',function(e){if(e.keyCode===CMDKEY){cmdDown=!0}}).on('keyup.xdsoftcmd',function(e){if(e.keyCode===CMDKEY){cmdDown=!1}});this.each(function(){var datetimepicker=$(this).data('xdsoft_datetimepicker'),$input;if(datetimepicker){if($.type(opt)==='string'){switch(opt){case 'show':$(this).select().focus();datetimepicker.trigger('open.xdsoft');break;case 'hide':datetimepicker.trigger('close.xdsoft');break;case 'toggle':datetimepicker.trigger('toggle.xdsoft');break;case 'destroy':destroyDateTimePicker($(this));break;case 'reset':this.value=this.defaultValue;if(!this.value||!datetimepicker.data('xdsoft_datetime').isValidDate(dateHelper.parseDate(this.value,options.format))){datetimepicker.data('changed',!1)}
datetimepicker.data('xdsoft_datetime').setCurrentTime(this.value);break;case 'validate':$input=datetimepicker.data('input');$input.trigger('blur.xdsoft');break;default:if(datetimepicker[opt]&&$.isFunction(datetimepicker[opt])){result=datetimepicker[opt](opt2)}}}else{datetimepicker.setOptions(opt)}
return 0}
if($.type(opt)!=='string'){if(!options.lazyInit||options.open||options.inline){createDateTimePicker($(this))}else{lazyInit($(this))}}});return result};$.fn.datetimepicker.defaults=default_options;function HighlightedDate(date,desc,style){"use strict";this.date=date;this.desc=desc;this.style=style}};(function(factory){if(typeof define==='function'&&define.amd){define(['jquery','jquery-mousewheel'],factory)}else if(typeof exports==='object'){module.exports=factory(require('jquery'))}else{factory(jQuery)}}(datetimepickerFactory));
/*!
 * jQuery Mousewheel 3.1.13
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 */
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof exports==='object'){module.exports=factory}else{factory(jQuery)}}(function($){var toFix=['wheel','mousewheel','DOMMouseScroll','MozMousePixelScroll'],toBind=('onwheel' in document||document.documentMode>=9)?['wheel']:['mousewheel','DomMouseScroll','MozMousePixelScroll'],slice=Array.prototype.slice,nullLowestDeltaTimeout,lowestDelta;if($.event.fixHooks){for(var i=toFix.length;i;){$.event.fixHooks[toFix[--i]]=$.event.mouseHooks}}
var special=$.event.special.mousewheel={version:'3.1.12',setup:function(){if(this.addEventListener){for(var i=toBind.length;i;){this.addEventListener(toBind[--i],handler,!1)}}else{this.onmousewheel=handler}
$.data(this,'mousewheel-line-height',special.getLineHeight(this));$.data(this,'mousewheel-page-height',special.getPageHeight(this))},teardown:function(){if(this.removeEventListener){for(var i=toBind.length;i;){this.removeEventListener(toBind[--i],handler,!1)}}else{this.onmousewheel=null}
$.removeData(this,'mousewheel-line-height');$.removeData(this,'mousewheel-page-height')},getLineHeight:function(elem){var $elem=$(elem),$parent=$elem['offsetParent' in $.fn?'offsetParent':'parent']();if(!$parent.length){$parent=$('body')}
return parseInt($parent.css('fontSize'),10)||parseInt($elem.css('fontSize'),10)||16},getPageHeight:function(elem){return $(elem).height()},settings:{adjustOldDeltas:!0,normalizeOffset:!0}};$.fn.extend({mousewheel:function(fn){return fn?this.bind('mousewheel',fn):this.trigger('mousewheel')},unmousewheel:function(fn){return this.unbind('mousewheel',fn)}});function handler(event){var orgEvent=event||window.event,args=slice.call(arguments,1),delta=0,deltaX=0,deltaY=0,absDelta=0,offsetX=0,offsetY=0;event=$.event.fix(orgEvent);event.type='mousewheel';if('detail' in orgEvent){deltaY=orgEvent.detail*-1}
if('wheelDelta' in orgEvent){deltaY=orgEvent.wheelDelta}
if('wheelDeltaY' in orgEvent){deltaY=orgEvent.wheelDeltaY}
if('wheelDeltaX' in orgEvent){deltaX=orgEvent.wheelDeltaX*-1}
if('axis' in orgEvent&&orgEvent.axis===orgEvent.HORIZONTAL_AXIS){deltaX=deltaY*-1;deltaY=0}
delta=deltaY===0?deltaX:deltaY;if('deltaY' in orgEvent){deltaY=orgEvent.deltaY*-1;delta=deltaY}
if('deltaX' in orgEvent){deltaX=orgEvent.deltaX;if(deltaY===0){delta=deltaX*-1}}
if(deltaY===0&&deltaX===0){return}
if(orgEvent.deltaMode===1){var lineHeight=$.data(this,'mousewheel-line-height');delta*=lineHeight;deltaY*=lineHeight;deltaX*=lineHeight}else if(orgEvent.deltaMode===2){var pageHeight=$.data(this,'mousewheel-page-height');delta*=pageHeight;deltaY*=pageHeight;deltaX*=pageHeight}
absDelta=Math.max(Math.abs(deltaY),Math.abs(deltaX));if(!lowestDelta||absDelta<lowestDelta){lowestDelta=absDelta;if(shouldAdjustOldDeltas(orgEvent,absDelta)){lowestDelta/=40}}
if(shouldAdjustOldDeltas(orgEvent,absDelta)){delta/=40;deltaX/=40;deltaY/=40}
delta=Math[delta>=1?'floor':'ceil'](delta/lowestDelta);deltaX=Math[deltaX>=1?'floor':'ceil'](deltaX/lowestDelta);deltaY=Math[deltaY>=1?'floor':'ceil'](deltaY/lowestDelta);if(special.settings.normalizeOffset&&this.getBoundingClientRect){var boundingRect=this.getBoundingClientRect();offsetX=event.clientX-boundingRect.left;offsetY=event.clientY-boundingRect.top}
event.deltaX=deltaX;event.deltaY=deltaY;event.deltaFactor=lowestDelta;event.offsetX=offsetX;event.offsetY=offsetY;event.deltaMode=0;args.unshift(event,delta,deltaX,deltaY);if(nullLowestDeltaTimeout){clearTimeout(nullLowestDeltaTimeout)}
nullLowestDeltaTimeout=setTimeout(nullLowestDelta,200);return($.event.dispatch||$.event.handle).apply(this,args)}
function nullLowestDelta(){lowestDelta=null}
function shouldAdjustOldDeltas(orgEvent,absDelta){return special.settings.adjustOldDeltas&&orgEvent.type==='mousewheel'&&absDelta%120===0}}));(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory():typeof define==='function'&&define.amd?define(factory):(global=typeof globalThis!=='undefined'?globalThis:global||self,global.Shuffle=factory())}(this,(function(){'use strict';function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}
function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1;descriptor.configurable=!0;if("value" in descriptor)descriptor.writable=!0;Object.defineProperty(target,descriptor.key,descriptor)}}
function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);return Constructor}
function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function")}
subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}});if(superClass)_setPrototypeOf(subClass,superClass);}
function _getPrototypeOf(o){_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o)};return _getPrototypeOf(o)}
function _setPrototypeOf(o,p){_setPrototypeOf=Object.setPrototypeOf||function _setPrototypeOf(o,p){o.__proto__=p;return o};return _setPrototypeOf(o,p)}
function _isNativeReflectConstruct(){if(typeof Reflect==="undefined"||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if(typeof Proxy==="function")return!0;try{Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));return!0}catch(e){return!1}}
function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}
return self}
function _possibleConstructorReturn(self,call){if(call&&(typeof call==="object"||typeof call==="function")){return call}
return _assertThisInitialized(self)}
function _createSuper(Derived){var hasNativeReflectConstruct=_isNativeReflectConstruct();return function _createSuperInternal(){var Super=_getPrototypeOf(Derived),result;if(hasNativeReflectConstruct){var NewTarget=_getPrototypeOf(this).constructor;result=Reflect.construct(Super,arguments,NewTarget)}else{result=Super.apply(this,arguments)}
return _possibleConstructorReturn(this,result)}}
var tinyEmitter={exports:{}};function E(){}
E.prototype={on:function(name,callback,ctx){var e=this.e||(this.e={});(e[name]||(e[name]=[])).push({fn:callback,ctx:ctx});return this},once:function(name,callback,ctx){var self=this;function listener(){self.off(name,listener);callback.apply(ctx,arguments)}
listener._=callback;return this.on(name,listener,ctx)},emit:function(name){var data=[].slice.call(arguments,1);var evtArr=((this.e||(this.e={}))[name]||[]).slice();var i=0;var len=evtArr.length;for(i;i<len;i++){evtArr[i].fn.apply(evtArr[i].ctx,data)}
return this},off:function(name,callback){var e=this.e||(this.e={});var evts=e[name];var liveEvents=[];if(evts&&callback){for(var i=0,len=evts.length;i<len;i++){if(evts[i].fn!==callback&&evts[i].fn._!==callback)
liveEvents.push(evts[i]);}}(liveEvents.length)?e[name]=liveEvents:delete e[name];return this}};tinyEmitter.exports=E;tinyEmitter.exports.TinyEmitter=E;var TinyEmitter=tinyEmitter.exports;var proto=typeof Element!=='undefined'?Element.prototype:{};var vendor=proto.matches||proto.matchesSelector||proto.webkitMatchesSelector||proto.mozMatchesSelector||proto.msMatchesSelector||proto.oMatchesSelector;var matchesSelector=match;function match(el,selector){if(!el||el.nodeType!==1)return!1;if(vendor)return vendor.call(el,selector);var nodes=el.parentNode.querySelectorAll(selector);for(var i=0;i<nodes.length;i++){if(nodes[i]==el)return!0}
return!1}
var throttleit=throttle;function throttle(func,wait){var ctx,args,rtn,timeoutID;var last=0;return function throttled(){ctx=this;args=arguments;var delta=new Date()-last;if(!timeoutID)
if(delta>=wait)call();else timeoutID=setTimeout(call,wait-delta);return rtn};function call(){timeoutID=0;last=+new Date();rtn=func.apply(ctx,args);ctx=null;args=null}}
var arrayParallel=function parallel(fns,context,callback){if(!callback){if(typeof context==='function'){callback=context;context=null}else{callback=noop}}
var pending=fns&&fns.length;if(!pending)return callback(null,[]);var finished=!1;var results=new Array(pending);fns.forEach(context?function(fn,i){fn.call(context,maybeDone(i))}:function(fn,i){fn(maybeDone(i))});function maybeDone(i){return function(err,result){if(finished)return;if(err){callback(err,results);finished=!0;return}
results[i]=result;if(!--pending)callback(null,results);}}};function noop(){}
function getNumber(value){return parseFloat(value)||0}
var Point=function(){function Point(x,y){_classCallCheck(this,Point);this.x=getNumber(x);this.y=getNumber(y)}
_createClass(Point,null,[{key:"equals",value:function equals(a,b){return a.x===b.x&&a.y===b.y}}]);return Point}();var Rect=function(){function Rect(x,y,w,h,id){_classCallCheck(this,Rect);this.id=id;this.left=x;this.top=y;this.width=w;this.height=h}
_createClass(Rect,null,[{key:"intersects",value:function intersects(a,b){return a.left<b.left+b.width&&b.left<a.left+a.width&&a.top<b.top+b.height&&b.top<a.top+a.height}}]);return Rect}();var Classes={BASE:'shuffle',SHUFFLE_ITEM:'shuffle-item',VISIBLE:'shuffle-item--visible',HIDDEN:'shuffle-item--hidden'};var id$1=0;var ShuffleItem=function(){function ShuffleItem(element,isRTL){_classCallCheck(this,ShuffleItem);id$1+=1;this.id=id$1;this.element=element;this.isRTL=isRTL;this.isVisible=!0;this.isHidden=!1}
_createClass(ShuffleItem,[{key:"show",value:function show(){this.isVisible=!0;this.element.classList.remove(Classes.HIDDEN);this.element.classList.add(Classes.VISIBLE);this.element.removeAttribute('aria-hidden')}},{key:"hide",value:function hide(){this.isVisible=!1;this.element.classList.remove(Classes.VISIBLE);this.element.classList.add(Classes.HIDDEN);this.element.setAttribute('aria-hidden',!0)}},{key:"init",value:function init(){this.addClasses([Classes.SHUFFLE_ITEM,Classes.VISIBLE]);this.applyCss(ShuffleItem.Css.INITIAL);this.applyCss(this.isRTL?ShuffleItem.Css.DIRECTION.rtl:ShuffleItem.Css.DIRECTION.ltr);this.scale=ShuffleItem.Scale.VISIBLE;this.point=new Point()}},{key:"addClasses",value:function addClasses(classes){var _this=this;classes.forEach(function(className){_this.element.classList.add(className)})}},{key:"removeClasses",value:function removeClasses(classes){var _this2=this;classes.forEach(function(className){_this2.element.classList.remove(className)})}},{key:"applyCss",value:function applyCss(obj){var _this3=this;Object.keys(obj).forEach(function(key){_this3.element.style[key]=obj[key]})}},{key:"dispose",value:function dispose(){this.removeClasses([Classes.HIDDEN,Classes.VISIBLE,Classes.SHUFFLE_ITEM]);this.element.removeAttribute('style');this.element=null}}]);return ShuffleItem}();ShuffleItem.Css={INITIAL:{position:'absolute',top:0,visibility:'visible',willChange:'transform'},DIRECTION:{ltr:{left:0},rtl:{right:0}},VISIBLE:{before:{opacity:1,visibility:'visible'},after:{transitionDelay:''}},HIDDEN:{before:{opacity:0},after:{visibility:'hidden',transitionDelay:''}}};ShuffleItem.Scale={VISIBLE:1,HIDDEN:0.001};var value=null;var testComputedSize=(function(){if(value!==null){return value}
var element=document.body||document.documentElement;var e=document.createElement('div');e.style.cssText='width:10px;padding:2px;box-sizing:border-box;';element.appendChild(e);var _window$getComputedSt=window.getComputedStyle(e,null),width=_window$getComputedSt.width;value=Math.round(getNumber(width))===10;element.removeChild(e);return value});function getNumberStyle(element,style){var styles=arguments.length>2&&arguments[2]!==undefined?arguments[2]:window.getComputedStyle(element,null);var value=getNumber(styles[style]);if(!testComputedSize()&&style==='width'){value+=getNumber(styles.paddingLeft)+getNumber(styles.paddingRight)+getNumber(styles.borderLeftWidth)+getNumber(styles.borderRightWidth)}else if(!testComputedSize()&&style==='height'){value+=getNumber(styles.paddingTop)+getNumber(styles.paddingBottom)+getNumber(styles.borderTopWidth)+getNumber(styles.borderBottomWidth)}
return value}
function randomize(array){var n=array.length;while(n){n-=1;var i=Math.floor(Math.random()*(n+1));var temp=array[i];array[i]=array[n];array[n]=temp}
return array}
var defaults={reverse:!1,by:null,compare:null,randomize:!1,key:'element'};function sorter(arr,options){var opts=Object.assign({},defaults,options);var original=Array.from(arr);var revert=!1;if(!arr.length){return[]}
if(opts.randomize){return randomize(arr)}
if(typeof opts.by==='function'){arr.sort(function(a,b){if(revert){return 0}
var valA=opts.by(a[opts.key]);var valB=opts.by(b[opts.key]);if(valA===undefined&&valB===undefined){revert=!0;return 0}
if(valA<valB||valA==='sortFirst'||valB==='sortLast'){return-1}
if(valA>valB||valA==='sortLast'||valB==='sortFirst'){return 1}
return 0})}else if(typeof opts.compare==='function'){arr.sort(opts.compare)}
if(revert){return original}
if(opts.reverse){arr.reverse()}
return arr}
var transitions={};var eventName='transitionend';var count=0;function uniqueId(){count+=1;return eventName+count}
function cancelTransitionEnd(id){if(transitions[id]){transitions[id].element.removeEventListener(eventName,transitions[id].listener);transitions[id]=null;return!0}
return!1}
function onTransitionEnd(element,callback){var id=uniqueId();var listener=function listener(evt){if(evt.currentTarget===evt.target){cancelTransitionEnd(id);callback(evt)}};element.addEventListener(eventName,listener);transitions[id]={element:element,listener:listener};return id}
function arrayMax(array){return Math.max.apply(Math,array)}
function arrayMin(array){return Math.min.apply(Math,array)}
function getColumnSpan(itemWidth,columnWidth,columns,threshold){var columnSpan=itemWidth/columnWidth;if(Math.abs(Math.round(columnSpan)-columnSpan)<threshold){columnSpan=Math.round(columnSpan)}
return Math.min(Math.ceil(columnSpan),columns)}
function getAvailablePositions(positions,columnSpan,columns){if(columnSpan===1){return positions}
var available=[];for(var i=0;i<=columns-columnSpan;i++){available.push(arrayMax(positions.slice(i,i+columnSpan)))}
return available}
function getShortColumn(positions,buffer){var minPosition=arrayMin(positions);for(var i=0,len=positions.length;i<len;i++){if(positions[i]>=minPosition-buffer&&positions[i]<=minPosition+buffer){return i}}
return 0}
function getItemPosition(_ref){var itemSize=_ref.itemSize,positions=_ref.positions,gridSize=_ref.gridSize,total=_ref.total,threshold=_ref.threshold,buffer=_ref.buffer;var span=getColumnSpan(itemSize.width,gridSize,total,threshold);var setY=getAvailablePositions(positions,span,total);var shortColumnIndex=getShortColumn(setY,buffer);var point=new Point(gridSize*shortColumnIndex,setY[shortColumnIndex]);var setHeight=setY[shortColumnIndex]+itemSize.height;for(var i=0;i<span;i++){positions[shortColumnIndex+i]=setHeight}
return point}
function getCenteredPositions(itemRects,containerWidth){var rowMap={};itemRects.forEach(function(itemRect){if(rowMap[itemRect.top]){rowMap[itemRect.top].push(itemRect)}else{rowMap[itemRect.top]=[itemRect]}});var rects=[];var rows=[];var centeredRows=[];Object.keys(rowMap).forEach(function(key){var itemRects=rowMap[key];rows.push(itemRects);var lastItem=itemRects[itemRects.length-1];var end=lastItem.left+lastItem.width;var offset=Math.round((containerWidth-end)/2);var finalRects=itemRects;var canMove=!1;if(offset>0){var newRects=[];canMove=itemRects.every(function(r){var newRect=new Rect(r.left+offset,r.top,r.width,r.height,r.id);var noOverlap=!rects.some(function(r){return Rect.intersects(newRect,r)});newRects.push(newRect);return noOverlap});if(canMove){finalRects=newRects}}
if(!canMove){var intersectingRect;var hasOverlap=itemRects.some(function(itemRect){return rects.some(function(r){var intersects=Rect.intersects(itemRect,r);if(intersects){intersectingRect=r}
return intersects})});if(hasOverlap){var rowIndex=centeredRows.findIndex(function(items){return items.includes(intersectingRect)});centeredRows.splice(rowIndex,1,rows[rowIndex])}}
rects=rects.concat(finalRects);centeredRows.push(finalRects)});return[].concat.apply([],centeredRows).sort(function(a,b){return a.id-b.id}).map(function(itemRect){return new Point(itemRect.left,itemRect.top)})}
function hyphenate(str){return str.replace(/([A-Z])/g,function(str,m1){return"-".concat(m1.toLowerCase())})}
function arrayUnique(x){return Array.from(new Set(x))}
var id=0;var Shuffle=function(_TinyEmitter){_inherits(Shuffle,_TinyEmitter);var _super=_createSuper(Shuffle);function Shuffle(element){var _this;var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};_classCallCheck(this,Shuffle);_this=_super.call(this);_this.options=Object.assign({},Shuffle.options,options);if(_this.options.delimeter){_this.options.delimiter=_this.options.delimeter}
_this.lastSort={};_this.group=Shuffle.ALL_ITEMS;_this.lastFilter=Shuffle.ALL_ITEMS;_this.isEnabled=!0;_this.isDestroyed=!1;_this.isInitialized=!1;_this._transitions=[];_this.isTransitioning=!1;_this._queue=[];var el=_this._getElementOption(element);if(!el){throw new TypeError('Shuffle needs to be initialized with an element.')}
_this.element=el;_this.id='shuffle_'+id;id+=1;_this._init();_this.isInitialized=!0;return _this}
_createClass(Shuffle,[{key:"_init",value:function _init(){this.items=this._getItems();this.sortedItems=this.items;this.options.sizer=this._getElementOption(this.options.sizer);this.element.classList.add(Shuffle.Classes.BASE);this._initItems(this.items);this._onResize=this._getResizeFunction();window.addEventListener('resize',this._onResize);if(document.readyState!=='complete'){var layout=this.layout.bind(this);window.addEventListener('load',function onLoad(){window.removeEventListener('load',onLoad);layout()})}
var containerCss=window.getComputedStyle(this.element,null);var containerWidth=Shuffle.getSize(this.element).width;this._validateStyles(containerCss);this._setColumns(containerWidth);this.filter(this.options.group,this.options.initialSort);this.element.offsetWidth;this.setItemTransitions(this.items);this.element.style.transition="height ".concat(this.options.speed,"ms ").concat(this.options.easing)}},{key:"_getResizeFunction",value:function _getResizeFunction(){var resizeFunction=this._handleResize.bind(this);return this.options.throttle?this.options.throttle(resizeFunction,this.options.throttleTime):resizeFunction}},{key:"_getElementOption",value:function _getElementOption(option){if(typeof option==='string'){return this.element.querySelector(option)}
if(option&&option.nodeType&&option.nodeType===1){return option}
if(option&&option.jquery){return option[0]}
return null}},{key:"_validateStyles",value:function _validateStyles(styles){if(styles.position==='static'){this.element.style.position='relative'}
if(styles.overflow!=='hidden'){this.element.style.overflow='hidden'}}},{key:"_filter",value:function _filter(){var category=arguments.length>0&&arguments[0]!==undefined?arguments[0]:this.lastFilter;var collection=arguments.length>1&&arguments[1]!==undefined?arguments[1]:this.items;var set=this._getFilteredSets(category,collection);this._toggleFilterClasses(set);this.lastFilter=category;if(typeof category==='string'){this.group=category}
return set}},{key:"_getFilteredSets",value:function _getFilteredSets(category,items){var _this2=this;var visible=[];var hidden=[];if(category===Shuffle.ALL_ITEMS){visible=items}else{items.forEach(function(item){if(_this2._doesPassFilter(category,item.element)){visible.push(item)}else{hidden.push(item)}})}
return{visible:visible,hidden:hidden}}},{key:"_doesPassFilter",value:function _doesPassFilter(category,element){if(typeof category==='function'){return category.call(element,element,this)}
var attr=element.getAttribute('data-'+Shuffle.FILTER_ATTRIBUTE_KEY);var keys=this.options.delimiter?attr.split(this.options.delimiter):JSON.parse(attr);function testCategory(category){return keys.includes(category)}
if(Array.isArray(category)){if(this.options.filterMode===Shuffle.FilterMode.ANY){return category.some(testCategory)}
return category.every(testCategory)}
return keys.includes(category)}},{key:"_toggleFilterClasses",value:function _toggleFilterClasses(_ref){var visible=_ref.visible,hidden=_ref.hidden;visible.forEach(function(item){item.show()});hidden.forEach(function(item){item.hide()})}},{key:"_initItems",value:function _initItems(items){items.forEach(function(item){item.init()})}},{key:"_disposeItems",value:function _disposeItems(items){items.forEach(function(item){item.dispose()})}},{key:"_updateItemCount",value:function _updateItemCount(){this.visibleItems=this._getFilteredItems().length}},{key:"setItemTransitions",value:function setItemTransitions(items){var _this$options=this.options,speed=_this$options.speed,easing=_this$options.easing;var positionProps=this.options.useTransforms?['transform']:['top','left'];var cssProps=Object.keys(ShuffleItem.Css.HIDDEN.before).map(function(k){return hyphenate(k)});var properties=positionProps.concat(cssProps).join();items.forEach(function(item){item.element.style.transitionDuration=speed+'ms';item.element.style.transitionTimingFunction=easing;item.element.style.transitionProperty=properties})}},{key:"_getItems",value:function _getItems(){var _this3=this;return Array.from(this.element.children).filter(function(el){return matchesSelector(el,_this3.options.itemSelector)}).map(function(el){return new ShuffleItem(el,_this3.options.isRTL)})}},{key:"_mergeNewItems",value:function _mergeNewItems(items){var children=Array.from(this.element.children);return sorter(this.items.concat(items),{by:function by(element){return children.indexOf(element)}})}},{key:"_getFilteredItems",value:function _getFilteredItems(){return this.items.filter(function(item){return item.isVisible})}},{key:"_getConcealedItems",value:function _getConcealedItems(){return this.items.filter(function(item){return!item.isVisible})}},{key:"_getColumnSize",value:function _getColumnSize(containerWidth,gutterSize){var size;if(typeof this.options.columnWidth==='function'){size=this.options.columnWidth(containerWidth)}else if(this.options.sizer){size=Shuffle.getSize(this.options.sizer).width}else if(this.options.columnWidth){size=this.options.columnWidth}else if(this.items.length>0){size=Shuffle.getSize(this.items[0].element,!0).width}else{size=containerWidth}
if(size===0){size=containerWidth}
return size+gutterSize}},{key:"_getGutterSize",value:function _getGutterSize(containerWidth){var size;if(typeof this.options.gutterWidth==='function'){size=this.options.gutterWidth(containerWidth)}else if(this.options.sizer){size=getNumberStyle(this.options.sizer,'marginLeft')}else{size=this.options.gutterWidth}
return size}},{key:"_setColumns",value:function _setColumns(){var containerWidth=arguments.length>0&&arguments[0]!==undefined?arguments[0]:Shuffle.getSize(this.element).width;var gutter=this._getGutterSize(containerWidth);var columnWidth=this._getColumnSize(containerWidth,gutter);var calculatedColumns=(containerWidth+gutter)/columnWidth;if(Math.abs(Math.round(calculatedColumns)-calculatedColumns)<this.options.columnThreshold){calculatedColumns=Math.round(calculatedColumns)}
this.cols=Math.max(Math.floor(calculatedColumns||0),1);this.containerWidth=containerWidth;this.colWidth=columnWidth}},{key:"_setContainerSize",value:function _setContainerSize(){this.element.style.height=this._getContainerSize()+'px'}},{key:"_getContainerSize",value:function _getContainerSize(){return arrayMax(this.positions)}},{key:"_getStaggerAmount",value:function _getStaggerAmount(index){return Math.min(index*this.options.staggerAmount,this.options.staggerAmountMax)}},{key:"_dispatch",value:function _dispatch(name){var data=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(this.isDestroyed){return}
data.shuffle=this;this.emit(name,data)}},{key:"_resetCols",value:function _resetCols(){var i=this.cols;this.positions=[];while(i){i-=1;this.positions.push(0)}}},{key:"_layout",value:function _layout(items){var _this4=this;var itemPositions=this._getNextPositions(items);var count=0;items.forEach(function(item,i){function callback(){item.applyCss(ShuffleItem.Css.VISIBLE.after)}
if(Point.equals(item.point,itemPositions[i])&&!item.isHidden){item.applyCss(ShuffleItem.Css.VISIBLE.before);callback();return}
item.point=itemPositions[i];item.scale=ShuffleItem.Scale.VISIBLE;item.isHidden=!1;var styles=_this4.getStylesForTransition(item,ShuffleItem.Css.VISIBLE.before);styles.transitionDelay=_this4._getStaggerAmount(count)+'ms';_this4._queue.push({item:item,styles:styles,callback:callback});count+=1})}},{key:"_getNextPositions",value:function _getNextPositions(items){var _this5=this;if(this.options.isCentered){var itemsData=items.map(function(item,i){var itemSize=Shuffle.getSize(item.element,!0);var point=_this5._getItemPosition(itemSize);return new Rect(point.x,point.y,itemSize.width,itemSize.height,i)});return this.getTransformedPositions(itemsData,this.containerWidth)}
return items.map(function(item){return _this5._getItemPosition(Shuffle.getSize(item.element,!0))})}},{key:"_getItemPosition",value:function _getItemPosition(itemSize){return getItemPosition({itemSize:itemSize,positions:this.positions,gridSize:this.colWidth,total:this.cols,threshold:this.options.columnThreshold,buffer:this.options.buffer})}},{key:"getTransformedPositions",value:function getTransformedPositions(itemRects,containerWidth){return getCenteredPositions(itemRects,containerWidth)}},{key:"_shrink",value:function _shrink(){var _this6=this;var collection=arguments.length>0&&arguments[0]!==undefined?arguments[0]:this._getConcealedItems();var count=0;collection.forEach(function(item){function callback(){item.applyCss(ShuffleItem.Css.HIDDEN.after)}
if(item.isHidden){item.applyCss(ShuffleItem.Css.HIDDEN.before);callback();return}
item.scale=ShuffleItem.Scale.HIDDEN;item.isHidden=!0;var styles=_this6.getStylesForTransition(item,ShuffleItem.Css.HIDDEN.before);styles.transitionDelay=_this6._getStaggerAmount(count)+'ms';_this6._queue.push({item:item,styles:styles,callback:callback});count+=1})}},{key:"_handleResize",value:function _handleResize(){if(!this.isEnabled||this.isDestroyed){return}
this.update()}},{key:"getStylesForTransition",value:function getStylesForTransition(item,styleObject){var styles=Object.assign({},styleObject);if(this.options.useTransforms){var sign=this.options.isRTL?'-':'';var x=this.options.roundTransforms?Math.round(item.point.x):item.point.x;var y=this.options.roundTransforms?Math.round(item.point.y):item.point.y;styles.transform="translate(".concat(sign).concat(x,"px, ").concat(y,"px) scale(").concat(item.scale,")")}else{if(this.options.isRTL){styles.right=item.point.x+'px'}else{styles.left=item.point.x+'px'}
styles.top=item.point.y+'px'}
return styles}},{key:"_whenTransitionDone",value:function _whenTransitionDone(element,itemCallback,done){var id=onTransitionEnd(element,function(evt){itemCallback();done(null,evt)});this._transitions.push(id)}},{key:"_getTransitionFunction",value:function _getTransitionFunction(opts){var _this7=this;return function(done){opts.item.applyCss(opts.styles);_this7._whenTransitionDone(opts.item.element,opts.callback,done)}}},{key:"_processQueue",value:function _processQueue(){if(this.isTransitioning){this._cancelMovement()}
var hasSpeed=this.options.speed>0;var hasQueue=this._queue.length>0;if(hasQueue&&hasSpeed&&this.isInitialized){this._startTransitions(this._queue)}else if(hasQueue){this._styleImmediately(this._queue);this._dispatch(Shuffle.EventType.LAYOUT)}else{this._dispatch(Shuffle.EventType.LAYOUT)}
this._queue.length=0}},{key:"_startTransitions",value:function _startTransitions(transitions){var _this8=this;this.isTransitioning=!0;var callbacks=transitions.map(function(obj){return _this8._getTransitionFunction(obj)});arrayParallel(callbacks,this._movementFinished.bind(this))}},{key:"_cancelMovement",value:function _cancelMovement(){this._transitions.forEach(cancelTransitionEnd);this._transitions.length=0;this.isTransitioning=!1}},{key:"_styleImmediately",value:function _styleImmediately(objects){if(objects.length){var elements=objects.map(function(obj){return obj.item.element});Shuffle._skipTransitions(elements,function(){objects.forEach(function(obj){obj.item.applyCss(obj.styles);obj.callback()})})}}},{key:"_movementFinished",value:function _movementFinished(){this._transitions.length=0;this.isTransitioning=!1;this._dispatch(Shuffle.EventType.LAYOUT)}},{key:"filter",value:function filter(category,sortOptions){if(!this.isEnabled){return}
if(!category||category&&category.length===0){category=Shuffle.ALL_ITEMS}
this._filter(category);this._shrink();this._updateItemCount();this.sort(sortOptions)}},{key:"sort",value:function sort(){var sortOptions=arguments.length>0&&arguments[0]!==undefined?arguments[0]:this.lastSort;if(!this.isEnabled){return}
this._resetCols();var items=sorter(this._getFilteredItems(),sortOptions);this.sortedItems=items;this._layout(items);this._processQueue();this._setContainerSize();this.lastSort=sortOptions}},{key:"update",value:function update(){var isOnlyLayout=arguments.length>0&&arguments[0]!==undefined?arguments[0]:!1;if(this.isEnabled){if(!isOnlyLayout){this._setColumns()}
this.sort()}}},{key:"layout",value:function layout(){this.update(!0)}},{key:"add",value:function add(newItems){var _this9=this;var items=arrayUnique(newItems).map(function(el){return new ShuffleItem(el,_this9.options.isRTL)});this._initItems(items);this._resetCols();var allItems=this._mergeNewItems(items);var sortedItems=sorter(allItems,this.lastSort);var allSortedItemsSet=this._filter(this.lastFilter,sortedItems);var isNewItem=function isNewItem(item){return items.includes(item)};var applyHiddenState=function applyHiddenState(item){item.scale=ShuffleItem.Scale.HIDDEN;item.isHidden=!0;item.applyCss(ShuffleItem.Css.HIDDEN.before);item.applyCss(ShuffleItem.Css.HIDDEN.after)};var itemPositions=this._getNextPositions(allSortedItemsSet.visible);allSortedItemsSet.visible.forEach(function(item,i){if(isNewItem(item)){item.point=itemPositions[i];applyHiddenState(item);item.applyCss(_this9.getStylesForTransition(item,{}))}});allSortedItemsSet.hidden.forEach(function(item){if(isNewItem(item)){applyHiddenState(item)}});this.element.offsetWidth;this.setItemTransitions(items);this.items=this._mergeNewItems(items);this.filter(this.lastFilter)}},{key:"disable",value:function disable(){this.isEnabled=!1}},{key:"enable",value:function enable(){var isUpdateLayout=arguments.length>0&&arguments[0]!==undefined?arguments[0]:!0;this.isEnabled=!0;if(isUpdateLayout){this.update()}}},{key:"remove",value:function remove(elements){var _this10=this;if(!elements.length){return}
var collection=arrayUnique(elements);var oldItems=collection.map(function(element){return _this10.getItemByElement(element)}).filter(function(item){return!!item});var handleLayout=function handleLayout(){_this10._disposeItems(oldItems);collection.forEach(function(element){element.parentNode.removeChild(element)});_this10._dispatch(Shuffle.EventType.REMOVED,{collection:collection})};this._toggleFilterClasses({visible:[],hidden:oldItems});this._shrink(oldItems);this.sort();this.items=this.items.filter(function(item){return!oldItems.includes(item)});this._updateItemCount();this.once(Shuffle.EventType.LAYOUT,handleLayout)}},{key:"getItemByElement",value:function getItemByElement(element){return this.items.find(function(item){return item.element===element})}},{key:"resetItems",value:function resetItems(){var _this11=this;this._disposeItems(this.items);this.isInitialized=!1;this.items=this._getItems();this._initItems(this.items);this.once(Shuffle.EventType.LAYOUT,function(){_this11.setItemTransitions(_this11.items);_this11.isInitialized=!0});this.filter(this.lastFilter)}},{key:"destroy",value:function destroy(){this._cancelMovement();window.removeEventListener('resize',this._onResize);this.element.classList.remove('shuffle');this.element.removeAttribute('style');this._disposeItems(this.items);this.items.length=0;this._transitions.length=0;this.options.sizer=null;this.element=null;this.isDestroyed=!0;this.isEnabled=!1}}],[{key:"getSize",value:function getSize(element){var includeMargins=arguments.length>1&&arguments[1]!==undefined?arguments[1]:!1;var styles=window.getComputedStyle(element,null);var width=getNumberStyle(element,'width',styles);var height=getNumberStyle(element,'height',styles);if(includeMargins){var marginLeft=getNumberStyle(element,'marginLeft',styles);var marginRight=getNumberStyle(element,'marginRight',styles);var marginTop=getNumberStyle(element,'marginTop',styles);var marginBottom=getNumberStyle(element,'marginBottom',styles);width+=marginLeft+marginRight;height+=marginTop+marginBottom}
return{width:width,height:height}}},{key:"_skipTransitions",value:function _skipTransitions(elements,callback){var zero='0ms';var data=elements.map(function(element){var style=element.style;var duration=style.transitionDuration;var delay=style.transitionDelay;style.transitionDuration=zero;style.transitionDelay=zero;return{duration:duration,delay:delay}});callback();elements[0].offsetWidth;elements.forEach(function(element,i){element.style.transitionDuration=data[i].duration;element.style.transitionDelay=data[i].delay})}}]);return Shuffle}(TinyEmitter);Shuffle.ShuffleItem=ShuffleItem;Shuffle.ALL_ITEMS='all';Shuffle.FILTER_ATTRIBUTE_KEY='groups';Shuffle.EventType={LAYOUT:'shuffle:layout',REMOVED:'shuffle:removed'};Shuffle.Classes=Classes;Shuffle.FilterMode={ANY:'any',ALL:'all'};Shuffle.options={group:Shuffle.ALL_ITEMS,speed:250,easing:'cubic-bezier(0.4, 0.0, 0.2, 1)',itemSelector:'*',sizer:null,gutterWidth:0,columnWidth:0,delimiter:null,buffer:0,columnThreshold:0.01,initialSort:null,throttle:throttleit,throttleTime:300,staggerAmount:15,staggerAmountMax:150,useTransforms:!0,filterMode:Shuffle.FilterMode.ANY,isCentered:!1,isRTL:!1,roundTransforms:!0};Shuffle.Point=Point;Shuffle.Rect=Rect;Shuffle.__sorter=sorter;Shuffle.__getColumnSpan=getColumnSpan;Shuffle.__getAvailablePositions=getAvailablePositions;Shuffle.__getShortColumn=getShortColumn;Shuffle.__getCenteredPositions=getCenteredPositions;return Shuffle})));(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof exports==='object'){module.exports=factory(require('jquery'))}else{factory(jQuery)}}(function($){'use strict';$.minicolors={defaults:{animationSpeed:50,animationEasing:'swing',change:null,changeDelay:0,control:'hue',defaultValue:'',format:'hex',hide:null,hideSpeed:100,inline:!1,keywords:'',letterCase:'lowercase',opacity:!1,position:'bottom',show:null,showSpeed:100,theme:'default',swatches:[]}};$.extend($.fn,{minicolors:function(method,data){switch(method){case 'destroy':$(this).each(function(){destroy($(this))});return $(this);case 'hide':hide();return $(this);case 'opacity':if(data===undefined){return $(this).attr('data-opacity')}else{$(this).each(function(){updateFromInput($(this).attr('data-opacity',data))})}
return $(this);case 'rgbObject':return rgbObject($(this),method==='rgbaObject');case 'rgbString':case 'rgbaString':return rgbString($(this),method==='rgbaString');case 'settings':if(data===undefined){return $(this).data('minicolors-settings')}else{$(this).each(function(){var settings=$(this).data('minicolors-settings')||{};destroy($(this));$(this).minicolors($.extend(!0,settings,data))})}
return $(this);case 'show':show($(this).eq(0));return $(this);case 'value':if(data===undefined){return $(this).val()}else{$(this).each(function(){if(typeof(data)==='object'&&data!==null){if(data.opacity!==undefined){$(this).attr('data-opacity',keepWithin(data.opacity,0,1))}
if(data.color){$(this).val(data.color)}}else{$(this).val(data)}
updateFromInput($(this))})}
return $(this);default:if(method!=='create')data=method;$(this).each(function(){init($(this),data)});return $(this)}}});function init(input,settings){var minicolors=$('<div class="minicolors" />');var defaults=$.minicolors.defaults;var name;var size;var swatches;var swatch;var swatchString;var panel;var i;if(input.data('minicolors-initialized'))return;settings=$.extend(!0,{},defaults,settings);minicolors.addClass('minicolors-theme-'+settings.theme).toggleClass('minicolors-with-opacity',settings.opacity);if(settings.position!==undefined){$.each(settings.position.split(' '),function(){minicolors.addClass('minicolors-position-'+this)})}
if(settings.format==='rgb'){size=settings.opacity?'25':'20'}else{size=settings.keywords?'11':'7'}
input.addClass('minicolors-input').data('minicolors-initialized',!1).data('minicolors-settings',settings).prop('size',size).wrap(minicolors).after('<div class="minicolors-panel minicolors-slider-'+settings.control+'">'+'<div class="minicolors-slider minicolors-sprite">'+'<div class="minicolors-picker"></div>'+'</div>'+'<div class="minicolors-opacity-slider minicolors-sprite">'+'<div class="minicolors-picker"></div>'+'</div>'+'<div class="minicolors-grid minicolors-sprite">'+'<div class="minicolors-grid-inner"></div>'+'<div class="minicolors-picker"><div></div></div>'+'</div>'+'</div>');if(!settings.inline){input.after('<span class="minicolors-swatch minicolors-sprite minicolors-input-swatch"><span class="minicolors-swatch-color"></span></span>');input.next('.minicolors-input-swatch').on('click',function(event){event.preventDefault();input.trigger('focus')})}
panel=input.parent().find('.minicolors-panel');panel.on('selectstart',function(){return!1}).end();if(settings.swatches&&settings.swatches.length!==0){panel.addClass('minicolors-with-swatches');swatches=$('<ul class="minicolors-swatches"></ul>').appendTo(panel);for(i=0;i<settings.swatches.length;++i){if(typeof settings.swatches[i]==='object'){name=settings.swatches[i].name;swatch=settings.swatches[i].color}else{name='';swatch=settings.swatches[i]}
swatchString=swatch;swatch=isRgb(swatch)?parseRgb(swatch,!0):hex2rgb(parseHex(swatch,!0));$('<li class="minicolors-swatch minicolors-sprite"><span class="minicolors-swatch-color"></span></li>').attr("title",name).appendTo(swatches).data('swatch-color',swatchString).find('.minicolors-swatch-color').css({backgroundColor:((swatchString!=='transparent')?rgb2hex(swatch):'transparent'),opacity:String(swatch.a)});settings.swatches[i]=swatch}}
if(settings.inline)input.parent().addClass('minicolors-inline');updateFromInput(input,!1);input.data('minicolors-initialized',!0)}
function destroy(input){var minicolors=input.parent();input.removeData('minicolors-initialized').removeData('minicolors-settings').removeProp('size').removeClass('minicolors-input');minicolors.before(input).remove()}
function show(input){var minicolors=input.parent();var panel=minicolors.find('.minicolors-panel');var settings=input.data('minicolors-settings');if(!input.data('minicolors-initialized')||input.prop('disabled')||minicolors.hasClass('minicolors-inline')||minicolors.hasClass('minicolors-focus'))return;hide();minicolors.addClass('minicolors-focus');if(panel.animate){panel.stop(!0,!0).fadeIn(settings.showSpeed,function(){if(settings.show)settings.show.call(input.get(0));})}else{panel.show();if(settings.show)settings.show.call(input.get(0));}}
function hide(){$('.minicolors-focus').each(function(){var minicolors=$(this);var input=minicolors.find('.minicolors-input');var panel=minicolors.find('.minicolors-panel');var settings=input.data('minicolors-settings');if(panel.animate){panel.fadeOut(settings.hideSpeed,function(){if(settings.hide)settings.hide.call(input.get(0));minicolors.removeClass('minicolors-focus')})}else{panel.hide();if(settings.hide)settings.hide.call(input.get(0));minicolors.removeClass('minicolors-focus')}})}
function move(target,event,animate){var input=target.parents('.minicolors').find('.minicolors-input');var settings=input.data('minicolors-settings');var picker=target.find('[class$=-picker]');var offsetX=target.offset().left;var offsetY=target.offset().top;var x=Math.round(event.pageX-offsetX);var y=Math.round(event.pageY-offsetY);var duration=animate?settings.animationSpeed:0;var wx,wy,r,phi,styles;if(event.originalEvent.changedTouches){x=event.originalEvent.changedTouches[0].pageX-offsetX;y=event.originalEvent.changedTouches[0].pageY-offsetY}
if(x<0)x=0;if(y<0)y=0;if(x>target.width())x=target.width();if(y>target.height())y=target.height();if(target.parent().is('.minicolors-slider-wheel')&&picker.parent().is('.minicolors-grid')){wx=75-x;wy=75-y;r=Math.sqrt(wx*wx+wy*wy);phi=Math.atan2(wy,wx);if(phi<0)phi+=Math.PI*2;if(r>75){r=75;x=75-(75*Math.cos(phi));y=75-(75*Math.sin(phi))}
x=Math.round(x);y=Math.round(y)}
styles={top:y+'px'};if(target.is('.minicolors-grid')){styles.left=x+'px'}
if(picker.animate){picker.stop(!0).animate(styles,duration,settings.animationEasing,function(){updateFromControl(input,target)})}else{picker.css(styles);updateFromControl(input,target)}}
function updateFromControl(input,target){function getCoords(picker,container){var left,top;if(!picker.length||!container)return null;left=picker.offset().left;top=picker.offset().top;return{x:left-container.offset().left+(picker.outerWidth()/2),y:top-container.offset().top+(picker.outerHeight()/2)}}
var hue,saturation,brightness,x,y,r,phi;var hex=input.val();var opacity=input.attr('data-opacity');var minicolors=input.parent();var settings=input.data('minicolors-settings');var swatch=minicolors.find('.minicolors-input-swatch');var grid=minicolors.find('.minicolors-grid');var slider=minicolors.find('.minicolors-slider');var opacitySlider=minicolors.find('.minicolors-opacity-slider');var gridPicker=grid.find('[class$=-picker]');var sliderPicker=slider.find('[class$=-picker]');var opacityPicker=opacitySlider.find('[class$=-picker]');var gridPos=getCoords(gridPicker,grid);var sliderPos=getCoords(sliderPicker,slider);var opacityPos=getCoords(opacityPicker,opacitySlider);if(target.is('.minicolors-grid, .minicolors-slider, .minicolors-opacity-slider')){switch(settings.control){case 'wheel':x=(grid.width()/2)-gridPos.x;y=(grid.height()/2)-gridPos.y;r=Math.sqrt(x*x+y*y);phi=Math.atan2(y,x);if(phi<0)phi+=Math.PI*2;if(r>75){r=75;gridPos.x=69-(75*Math.cos(phi));gridPos.y=69-(75*Math.sin(phi))}
saturation=keepWithin(r/0.75,0,100);hue=keepWithin(phi*180/Math.PI,0,360);brightness=keepWithin(100-Math.floor(sliderPos.y*(100/slider.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});slider.css('backgroundColor',hsb2hex({h:hue,s:saturation,b:100}));break;case 'saturation':hue=keepWithin(parseInt(gridPos.x*(360/grid.width()),10),0,360);saturation=keepWithin(100-Math.floor(sliderPos.y*(100/slider.height())),0,100);brightness=keepWithin(100-Math.floor(gridPos.y*(100/grid.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});slider.css('backgroundColor',hsb2hex({h:hue,s:100,b:brightness}));minicolors.find('.minicolors-grid-inner').css('opacity',saturation/100);break;case 'brightness':hue=keepWithin(parseInt(gridPos.x*(360/grid.width()),10),0,360);saturation=keepWithin(100-Math.floor(gridPos.y*(100/grid.height())),0,100);brightness=keepWithin(100-Math.floor(sliderPos.y*(100/slider.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});slider.css('backgroundColor',hsb2hex({h:hue,s:saturation,b:100}));minicolors.find('.minicolors-grid-inner').css('opacity',1-(brightness/100));break;default:hue=keepWithin(360-parseInt(sliderPos.y*(360/slider.height()),10),0,360);saturation=keepWithin(Math.floor(gridPos.x*(100/grid.width())),0,100);brightness=keepWithin(100-Math.floor(gridPos.y*(100/grid.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});grid.css('backgroundColor',hsb2hex({h:hue,s:100,b:100}));break}
if(settings.opacity){opacity=parseFloat(1-(opacityPos.y/opacitySlider.height())).toFixed(2)}else{opacity=1}
updateInput(input,hex,opacity)}else{swatch.find('span').css({backgroundColor:hex,opacity:String(opacity)});doChange(input,hex,opacity)}}
function updateInput(input,value,opacity){var rgb;var minicolors=input.parent();var settings=input.data('minicolors-settings');var swatch=minicolors.find('.minicolors-input-swatch');if(settings.opacity)input.attr('data-opacity',opacity);if(settings.format==='rgb'){if(isRgb(value)){rgb=parseRgb(value,!0)}else{rgb=hex2rgb(parseHex(value,!0))}
opacity=input.attr('data-opacity')===''?1:keepWithin(parseFloat(input.attr('data-opacity')).toFixed(2),0,1);if(isNaN(opacity)||!settings.opacity)opacity=1;if(input.minicolors('rgbObject').a<=1&&rgb&&settings.opacity){value='rgba('+rgb.r+', '+rgb.g+', '+rgb.b+', '+parseFloat(opacity)+')'}else{value='rgb('+rgb.r+', '+rgb.g+', '+rgb.b+')'}}else{if(isRgb(value)){value=rgbString2hex(value)}
value=convertCase(value,settings.letterCase)}
input.val(value);swatch.find('span').css({backgroundColor:value,opacity:String(opacity)});doChange(input,value,opacity)}
function updateFromInput(input,preserveInputValue){var hex,hsb,opacity,keywords,alpha,value,x,y,r,phi;var minicolors=input.parent();var settings=input.data('minicolors-settings');var swatch=minicolors.find('.minicolors-input-swatch');var grid=minicolors.find('.minicolors-grid');var slider=minicolors.find('.minicolors-slider');var opacitySlider=minicolors.find('.minicolors-opacity-slider');var gridPicker=grid.find('[class$=-picker]');var sliderPicker=slider.find('[class$=-picker]');var opacityPicker=opacitySlider.find('[class$=-picker]');if(isRgb(input.val())){hex=rgbString2hex(input.val());alpha=keepWithin(parseFloat(getAlpha(input.val())).toFixed(2),0,1);if(alpha){input.attr('data-opacity',alpha)}}else{hex=convertCase(parseHex(input.val(),!0),settings.letterCase)}
if(!hex){hex=convertCase(parseInput(settings.defaultValue,!0),settings.letterCase)}
hsb=hex2hsb(hex);keywords=!settings.keywords?[]:$.map(settings.keywords.split(','),function(a){return a.toLowerCase().trim()});if(input.val()!==''&&$.inArray(input.val().toLowerCase(),keywords)>-1){value=convertCase(input.val())}else{value=isRgb(input.val())?parseRgb(input.val()):hex}
if(!preserveInputValue)input.val(value);if(settings.opacity){opacity=input.attr('data-opacity')===''?1:keepWithin(parseFloat(input.attr('data-opacity')).toFixed(2),0,1);if(isNaN(opacity))opacity=1;input.attr('data-opacity',opacity);swatch.find('span').css('opacity',String(opacity));y=keepWithin(opacitySlider.height()-(opacitySlider.height()*opacity),0,opacitySlider.height());opacityPicker.css('top',y+'px')}
if(input.val().toLowerCase()==='transparent'){swatch.find('span').css('opacity',String(0))}
swatch.find('span').css('backgroundColor',hex);switch(settings.control){case 'wheel':r=keepWithin(Math.ceil(hsb.s*0.75),0,grid.height()/2);phi=hsb.h*Math.PI/180;x=keepWithin(75-Math.cos(phi)*r,0,grid.width());y=keepWithin(75-Math.sin(phi)*r,0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=150-(hsb.b/(100/grid.height()));if(hex==='')y=0;sliderPicker.css('top',y+'px');slider.css('backgroundColor',hsb2hex({h:hsb.h,s:hsb.s,b:100}));break;case 'saturation':x=keepWithin((5*hsb.h)/12,0,150);y=keepWithin(grid.height()-Math.ceil(hsb.b/(100/grid.height())),0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=keepWithin(slider.height()-(hsb.s*(slider.height()/100)),0,slider.height());sliderPicker.css('top',y+'px');slider.css('backgroundColor',hsb2hex({h:hsb.h,s:100,b:hsb.b}));minicolors.find('.minicolors-grid-inner').css('opacity',hsb.s/100);break;case 'brightness':x=keepWithin((5*hsb.h)/12,0,150);y=keepWithin(grid.height()-Math.ceil(hsb.s/(100/grid.height())),0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=keepWithin(slider.height()-(hsb.b*(slider.height()/100)),0,slider.height());sliderPicker.css('top',y+'px');slider.css('backgroundColor',hsb2hex({h:hsb.h,s:hsb.s,b:100}));minicolors.find('.minicolors-grid-inner').css('opacity',1-(hsb.b/100));break;default:x=keepWithin(Math.ceil(hsb.s/(100/grid.width())),0,grid.width());y=keepWithin(grid.height()-Math.ceil(hsb.b/(100/grid.height())),0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=keepWithin(slider.height()-(hsb.h/(360/slider.height())),0,slider.height());sliderPicker.css('top',y+'px');grid.css('backgroundColor',hsb2hex({h:hsb.h,s:100,b:100}));break}
if(input.data('minicolors-initialized')){doChange(input,value,opacity)}}
function doChange(input,value,opacity){var settings=input.data('minicolors-settings');var lastChange=input.data('minicolors-lastChange');var obj,sel,i;if(!lastChange||lastChange.value!==value||lastChange.opacity!==opacity){input.data('minicolors-lastChange',{value:value,opacity:opacity});if(settings.swatches&&settings.swatches.length!==0){if(!isRgb(value)){obj=hex2rgb(value)}else{obj=parseRgb(value,!0)}
sel=-1;for(i=0;i<settings.swatches.length;++i){if(obj.r===settings.swatches[i].r&&obj.g===settings.swatches[i].g&&obj.b===settings.swatches[i].b&&obj.a===settings.swatches[i].a){sel=i;break}}
input.parent().find('.minicolors-swatches .minicolors-swatch').removeClass('selected');if(sel!==-1){input.parent().find('.minicolors-swatches .minicolors-swatch').eq(i).addClass('selected')}}
if(settings.change){if(settings.changeDelay){clearTimeout(input.data('minicolors-changeTimeout'));input.data('minicolors-changeTimeout',setTimeout(function(){settings.change.call(input.get(0),value,opacity)},settings.changeDelay))}else{settings.change.call(input.get(0),value,opacity)}}
input.trigger('change').trigger('input')}}
function rgbObject(input){var rgb,opacity=$(input).attr('data-opacity');if(isRgb($(input).val())){rgb=parseRgb($(input).val(),!0)}else{var hex=parseHex($(input).val(),!0);rgb=hex2rgb(hex)}
if(!rgb)return null;if(opacity!==undefined)$.extend(rgb,{a:parseFloat(opacity)});return rgb}
function rgbString(input,alpha){var rgb,opacity=$(input).attr('data-opacity');if(isRgb($(input).val())){rgb=parseRgb($(input).val(),!0)}else{var hex=parseHex($(input).val(),!0);rgb=hex2rgb(hex)}
if(!rgb)return null;if(opacity===undefined)opacity=1;if(alpha){return'rgba('+rgb.r+', '+rgb.g+', '+rgb.b+', '+parseFloat(opacity)+')'}else{return'rgb('+rgb.r+', '+rgb.g+', '+rgb.b+')'}}
function convertCase(string,letterCase){return letterCase==='uppercase'?string.toUpperCase():string.toLowerCase()}
function parseHex(string,expand){string=string.replace(/^#/g,'');if(!string.match(/^[A-F0-9]{3,6}/ig))return'';if(string.length!==3&&string.length!==6)return'';if(string.length===3&&expand){string=string[0]+string[0]+string[1]+string[1]+string[2]+string[2]}
return'#'+string}
function parseRgb(string,obj){var values=string.replace(/[^\d,.]/g,'');var rgba=values.split(',');rgba[0]=keepWithin(parseInt(rgba[0],10),0,255);rgba[1]=keepWithin(parseInt(rgba[1],10),0,255);rgba[2]=keepWithin(parseInt(rgba[2],10),0,255);if(rgba[3]!==undefined){rgba[3]=keepWithin(parseFloat(rgba[3],10),0,1)}
if(obj){if(rgba[3]!==undefined){return{r:rgba[0],g:rgba[1],b:rgba[2],a:rgba[3]}}else{return{r:rgba[0],g:rgba[1],b:rgba[2]}}}
if(typeof(rgba[3])!=='undefined'&&rgba[3]<=1){return'rgba('+rgba[0]+', '+rgba[1]+', '+rgba[2]+', '+rgba[3]+')'}else{return'rgb('+rgba[0]+', '+rgba[1]+', '+rgba[2]+')'}}
function parseInput(string,expand){if(isRgb(string)){return parseRgb(string)}else{return parseHex(string,expand)}}
function keepWithin(value,min,max){if(value<min)value=min;if(value>max)value=max;return value}
function isRgb(string){var rgb=string.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i);return(rgb&&rgb.length===4)?!0:!1}
function getAlpha(rgba){rgba=rgba.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+(\.\d{1,2})?|\.\d{1,2})[\s+]?/i);return(rgba&&rgba.length===6)?rgba[4]:'1'}
function hsb2rgb(hsb){var rgb={};var h=Math.round(hsb.h);var s=Math.round(hsb.s*255/100);var v=Math.round(hsb.b*255/100);if(s===0){rgb.r=rgb.g=rgb.b=v}else{var t1=v;var t2=(255-s)*v/255;var t3=(t1-t2)*(h%60)/60;if(h===360)h=0;if(h<60){rgb.r=t1;rgb.b=t2;rgb.g=t2+t3}else if(h<120){rgb.g=t1;rgb.b=t2;rgb.r=t1-t3}else if(h<180){rgb.g=t1;rgb.r=t2;rgb.b=t2+t3}else if(h<240){rgb.b=t1;rgb.r=t2;rgb.g=t1-t3}else if(h<300){rgb.b=t1;rgb.g=t2;rgb.r=t2+t3}else if(h<360){rgb.r=t1;rgb.g=t2;rgb.b=t1-t3}else{rgb.r=0;rgb.g=0;rgb.b=0}}
return{r:Math.round(rgb.r),g:Math.round(rgb.g),b:Math.round(rgb.b)}}
function rgbString2hex(rgb){rgb=rgb.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i);return(rgb&&rgb.length===4)?'#'+('0'+parseInt(rgb[1],10).toString(16)).slice(-2)+('0'+parseInt(rgb[2],10).toString(16)).slice(-2)+('0'+parseInt(rgb[3],10).toString(16)).slice(-2):''}
function rgb2hex(rgb){var hex=[rgb.r.toString(16),rgb.g.toString(16),rgb.b.toString(16)];$.each(hex,function(nr,val){if(val.length===1)hex[nr]='0'+val});return'#'+hex.join('')}
function hsb2hex(hsb){return rgb2hex(hsb2rgb(hsb))}
function hex2hsb(hex){var hsb=rgb2hsb(hex2rgb(hex));if(hsb.s===0)hsb.h=360;return hsb}
function rgb2hsb(rgb){var hsb={h:0,s:0,b:0};var min=Math.min(rgb.r,rgb.g,rgb.b);var max=Math.max(rgb.r,rgb.g,rgb.b);var delta=max-min;hsb.b=max;hsb.s=max!==0?255*delta/max:0;if(hsb.s!==0){if(rgb.r===max){hsb.h=(rgb.g-rgb.b)/delta}else if(rgb.g===max){hsb.h=2+(rgb.b-rgb.r)/delta}else{hsb.h=4+(rgb.r-rgb.g)/delta}}else{hsb.h=-1}
hsb.h*=60;if(hsb.h<0){hsb.h+=360}
hsb.s*=100/255;hsb.b*=100/255;return hsb}
function hex2rgb(hex){hex=parseInt(((hex.indexOf('#')>-1)?hex.substring(1):hex),16);return{r:hex>>16,g:(hex&0x00FF00)>>8,b:(hex&0x0000FF)}}
$([document]).on('mousedown.minicolors touchstart.minicolors',function(event){if(!$(event.target).parents().add(event.target).hasClass('minicolors')){hide()}}).on('mousedown.minicolors touchstart.minicolors','.minicolors-grid, .minicolors-slider, .minicolors-opacity-slider',function(event){var target=$(this);event.preventDefault();$(event.delegateTarget).data('minicolors-target',target);move(target,event,!0)}).on('mousemove.minicolors touchmove.minicolors',function(event){var target=$(event.delegateTarget).data('minicolors-target');if(target)move(target,event);}).on('mouseup.minicolors touchend.minicolors',function(){$(this).removeData('minicolors-target')}).on('click.minicolors','.minicolors-swatches li',function(event){event.preventDefault();var target=$(this),input=target.parents('.minicolors').find('.minicolors-input'),color=target.data('swatch-color');updateInput(input,color,getAlpha(color));updateFromInput(input)}).on('mousedown.minicolors touchstart.minicolors','.minicolors-input-swatch',function(event){var input=$(this).parent().find('.minicolors-input');event.preventDefault();show(input)}).on('focus.minicolors','.minicolors-input',function(){var input=$(this);if(!input.data('minicolors-initialized'))return;show(input)}).on('blur.minicolors','.minicolors-input',function(){var input=$(this);var settings=input.data('minicolors-settings');var keywords;var hex;var rgba;var swatchOpacity;var value;if(!input.data('minicolors-initialized'))return;keywords=!settings.keywords?[]:$.map(settings.keywords.split(','),function(a){return a.toLowerCase().trim()});if(input.val()!==''&&$.inArray(input.val().toLowerCase(),keywords)>-1){value=input.val()}else{if(isRgb(input.val())){rgba=parseRgb(input.val(),!0)}else{hex=parseHex(input.val(),!0);rgba=hex?hex2rgb(hex):null}
if(rgba===null){value=settings.defaultValue}else if(settings.format==='rgb'){value=settings.opacity?parseRgb('rgba('+rgba.r+','+rgba.g+','+rgba.b+','+input.attr('data-opacity')+')'):parseRgb('rgb('+rgba.r+','+rgba.g+','+rgba.b+')')}else{value=rgb2hex(rgba)}}
swatchOpacity=settings.opacity?input.attr('data-opacity'):1;if(value.toLowerCase()==='transparent')swatchOpacity=0;input.closest('.minicolors').find('.minicolors-input-swatch > span').css('opacity',String(swatchOpacity));input.val(value);if(input.val()==='')input.val(parseInput(settings.defaultValue,!0));input.val(convertCase(input.val(),settings.letterCase))}).on('keydown.minicolors','.minicolors-input',function(event){var input=$(this);if(!input.data('minicolors-initialized'))return;switch(event.which){case 9:hide();break;case 13:case 27:hide();input.blur();break}}).on('keyup.minicolors','.minicolors-input',function(){var input=$(this);if(!input.data('minicolors-initialized'))return;updateFromInput(input,!0)}).on('paste.minicolors','.minicolors-input',function(){var input=$(this);if(!input.data('minicolors-initialized'))return;setTimeout(function(){updateFromInput(input,!0)},1)})}));(function(){var Dropzone,Emitter,camelize,contentLoaded,detectVerticalSquash,drawImageIOSFix,noop,without,__slice=[].slice,__hasProp={}.hasOwnProperty,__extends=function(child,parent){for(var key in parent){if(__hasProp.call(parent,key))child[key]=parent[key]}function ctor(){this.constructor=child}ctor.prototype=parent.prototype;child.prototype=new ctor();child.__super__=parent.prototype;return child};noop=function(){};Emitter=(function(){function Emitter(){}
Emitter.prototype.addEventListener=Emitter.prototype.on;Emitter.prototype.on=function(event,fn){this._callbacks=this._callbacks||{};if(!this._callbacks[event]){this._callbacks[event]=[]}
this._callbacks[event].push(fn);return this};Emitter.prototype.emit=function(){var args,callback,callbacks,event,_i,_len;event=arguments[0],args=2<=arguments.length?__slice.call(arguments,1):[];this._callbacks=this._callbacks||{};callbacks=this._callbacks[event];if(callbacks){for(_i=0,_len=callbacks.length;_i<_len;_i++){callback=callbacks[_i];callback.apply(this,args)}}
return this};Emitter.prototype.removeListener=Emitter.prototype.off;Emitter.prototype.removeAllListeners=Emitter.prototype.off;Emitter.prototype.removeEventListener=Emitter.prototype.off;Emitter.prototype.off=function(event,fn){var callback,callbacks,i,_i,_len;if(!this._callbacks||arguments.length===0){this._callbacks={};return this}
callbacks=this._callbacks[event];if(!callbacks){return this}
if(arguments.length===1){delete this._callbacks[event];return this}
for(i=_i=0,_len=callbacks.length;_i<_len;i=++_i){callback=callbacks[i];if(callback===fn){callbacks.splice(i,1);break}}
return this};return Emitter})();Dropzone=(function(_super){var extend,resolveOption;__extends(Dropzone,_super);Dropzone.prototype.Emitter=Emitter;Dropzone.prototype.events=["drop","dragstart","dragend","dragenter","dragover","dragleave","addedfile","addedfiles","removedfile","thumbnail","error","errormultiple","processing","processingmultiple","uploadprogress","totaluploadprogress","sending","sendingmultiple","success","successmultiple","canceled","canceledmultiple","complete","completemultiple","reset","maxfilesexceeded","maxfilesreached","queuecomplete"];Dropzone.prototype.defaultOptions={url:null,method:"post",withCredentials:!1,parallelUploads:2,uploadMultiple:!1,maxFilesize:256,paramName:"file",createImageThumbnails:!0,maxThumbnailFilesize:10,thumbnailWidth:120,thumbnailHeight:120,filesizeBase:1000,maxFiles:null,params:{},clickable:!0,ignoreHiddenFiles:!0,acceptedFiles:null,acceptedMimeTypes:null,autoProcessQueue:!0,autoQueue:!0,addRemoveLinks:!1,previewsContainer:null,hiddenInputContainer:"body",capture:null,renameFilename:null,dictDefaultMessage:"Drop files here to upload",dictFallbackMessage:"Your browser does not support drag'n'drop file uploads.",dictFallbackText:"Please use the fallback form below to upload your files like in the olden days.",dictFileTooBig:"File is too big ({{filesize}}MiB). Max filesize: {{maxFilesize}}MiB.",dictInvalidFileType:"You can't upload files of this type.",dictResponseError:"Server responded with {{statusCode}} code.",dictCancelUpload:"Cancel upload",dictCancelUploadConfirmation:"Are you sure you want to cancel this upload?",dictRemoveFile:"Remove file",dictRemoveFileConfirmation:null,dictMaxFilesExceeded:"You can not upload any more files.",accept:function(file,done){return done()},init:function(){return noop},forceFallback:!1,fallback:function(){var child,messageElement,span,_i,_len,_ref;this.element.className=""+this.element.className+" dz-browser-not-supported";_ref=this.element.getElementsByTagName("div");for(_i=0,_len=_ref.length;_i<_len;_i++){child=_ref[_i];if(/(^| )dz-message($| )/.test(child.className)){messageElement=child;child.className="dz-message";continue}}
if(!messageElement){messageElement=Dropzone.createElement("<div class=\"dz-message\"><span></span></div>");this.element.appendChild(messageElement)}
span=messageElement.getElementsByTagName("span")[0];if(span){if(span.textContent!=null){span.textContent=this.options.dictFallbackMessage}else if(span.innerText!=null){span.innerText=this.options.dictFallbackMessage}}
return this.element.appendChild(this.getFallbackForm())},resize:function(file){var info,srcRatio,trgRatio;info={srcX:0,srcY:0,srcWidth:file.width,srcHeight:file.height};srcRatio=file.width/file.height;info.optWidth=this.options.thumbnailWidth;info.optHeight=this.options.thumbnailHeight;if((info.optWidth==null)&&(info.optHeight==null)){info.optWidth=info.srcWidth;info.optHeight=info.srcHeight}else if(info.optWidth==null){info.optWidth=srcRatio*info.optHeight}else if(info.optHeight==null){info.optHeight=(1/srcRatio)*info.optWidth}
trgRatio=info.optWidth/info.optHeight;if(file.height<info.optHeight||file.width<info.optWidth){info.trgHeight=info.srcHeight;info.trgWidth=info.srcWidth}else{if(srcRatio>trgRatio){info.srcHeight=file.height;info.srcWidth=info.srcHeight*trgRatio}else{info.srcWidth=file.width;info.srcHeight=info.srcWidth/trgRatio}}
info.srcX=(file.width-info.srcWidth)/2;info.srcY=(file.height-info.srcHeight)/2;return info},drop:function(e){return this.element.classList.remove("dz-drag-hover")},dragstart:noop,dragend:function(e){return this.element.classList.remove("dz-drag-hover")},dragenter:function(e){return this.element.classList.add("dz-drag-hover")},dragover:function(e){return this.element.classList.add("dz-drag-hover")},dragleave:function(e){return this.element.classList.remove("dz-drag-hover")},paste:noop,reset:function(){return this.element.classList.remove("dz-started")},addedfile:function(file){var node,removeFileEvent,removeLink,_i,_j,_k,_len,_len1,_len2,_ref,_ref1,_ref2,_results;if(this.element===this.previewsContainer){this.element.classList.add("dz-started")}
if(this.previewsContainer){file.previewElement=Dropzone.createElement(this.options.previewTemplate.trim());file.previewTemplate=file.previewElement;this.previewsContainer.appendChild(file.previewElement);_ref=file.previewElement.querySelectorAll("[data-dz-name]");for(_i=0,_len=_ref.length;_i<_len;_i++){node=_ref[_i];node.textContent=this._renameFilename(file.name)}
_ref1=file.previewElement.querySelectorAll("[data-dz-size]");for(_j=0,_len1=_ref1.length;_j<_len1;_j++){node=_ref1[_j];node.innerHTML=this.filesize(file.size)}
if(this.options.addRemoveLinks){file._removeLink=Dropzone.createElement("<a class=\"dz-remove\" href=\"javascript:undefined;\" data-dz-remove>"+this.options.dictRemoveFile+"</a>");file.previewElement.appendChild(file._removeLink)}
removeFileEvent=(function(_this){return function(e){e.preventDefault();e.stopPropagation();if(file.status===Dropzone.UPLOADING){return Dropzone.confirm(_this.options.dictCancelUploadConfirmation,function(){return _this.removeFile(file)})}else{if(_this.options.dictRemoveFileConfirmation){return Dropzone.confirm(_this.options.dictRemoveFileConfirmation,function(){return _this.removeFile(file)})}else{return _this.removeFile(file)}}}})(this);_ref2=file.previewElement.querySelectorAll("[data-dz-remove]");_results=[];for(_k=0,_len2=_ref2.length;_k<_len2;_k++){removeLink=_ref2[_k];_results.push(removeLink.addEventListener("click",removeFileEvent))}
return _results}},removedfile:function(file){var _ref;if(file.previewElement){if((_ref=file.previewElement)!=null){_ref.parentNode.removeChild(file.previewElement)}}
return this._updateMaxFilesReachedClass()},thumbnail:function(file,dataUrl){var thumbnailElement,_i,_len,_ref;if(file.previewElement){file.previewElement.classList.remove("dz-file-preview");_ref=file.previewElement.querySelectorAll("[data-dz-thumbnail]");for(_i=0,_len=_ref.length;_i<_len;_i++){thumbnailElement=_ref[_i];thumbnailElement.alt=file.name;thumbnailElement.src=dataUrl}
return setTimeout(((function(_this){return function(){return file.previewElement.classList.add("dz-image-preview")}})(this)),1)}},error:function(file,message){var node,_i,_len,_ref,_results;if(file.previewElement){file.previewElement.classList.add("dz-error");if(typeof message!=="String"&&message.error){message=message.error}
_ref=file.previewElement.querySelectorAll("[data-dz-errormessage]");_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){node=_ref[_i];_results.push(node.textContent=message)}
return _results}},errormultiple:noop,processing:function(file){if(file.previewElement){file.previewElement.classList.add("dz-processing");if(file._removeLink){return file._removeLink.textContent=this.options.dictCancelUpload}}},processingmultiple:noop,uploadprogress:function(file,progress,bytesSent){var node,_i,_len,_ref,_results;if(file.previewElement){_ref=file.previewElement.querySelectorAll("[data-dz-uploadprogress]");_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){node=_ref[_i];if(node.nodeName==='PROGRESS'){_results.push(node.value=progress)}else{_results.push(node.style.width=""+progress+"%")}}
return _results}},totaluploadprogress:noop,sending:noop,sendingmultiple:noop,success:function(file){if(file.previewElement){return file.previewElement.classList.add("dz-success")}},successmultiple:noop,canceled:function(file){return this.emit("error",file,"Upload canceled.")},canceledmultiple:noop,complete:function(file){if(file._removeLink){file._removeLink.textContent=this.options.dictRemoveFile}
if(file.previewElement){return file.previewElement.classList.add("dz-complete")}},completemultiple:noop,maxfilesexceeded:noop,maxfilesreached:noop,queuecomplete:noop,addedfiles:noop,previewTemplate:"<div class=\"dz-preview dz-file-preview\">\n  <div class=\"dz-image\"><img data-dz-thumbnail /></div>\n  <div class=\"dz-details\">\n    <div class=\"dz-size\"><span data-dz-size></span></div>\n    <div class=\"dz-filename\"><span data-dz-name></span></div>\n  </div>\n  <div class=\"dz-progress\"><span class=\"dz-upload\" data-dz-uploadprogress></span></div>\n  <div class=\"dz-error-message\"><span data-dz-errormessage></span></div>\n  <div class=\"dz-success-mark\">\n    <svg width=\"54px\" height=\"54px\" viewBox=\"0 0 54 54\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:sketch=\"http://www.bohemiancoding.com/sketch/ns\">\n      <title>Check</title>\n      <defs></defs>\n      <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\" sketch:type=\"MSPage\">\n        <path d=\"M23.5,31.8431458 L17.5852419,25.9283877 C16.0248253,24.3679711 13.4910294,24.366835 11.9289322,25.9289322 C10.3700136,27.4878508 10.3665912,30.0234455 11.9283877,31.5852419 L20.4147581,40.0716123 C20.5133999,40.1702541 20.6159315,40.2626649 20.7218615,40.3488435 C22.2835669,41.8725651 24.794234,41.8626202 26.3461564,40.3106978 L43.3106978,23.3461564 C44.8771021,21.7797521 44.8758057,19.2483887 43.3137085,17.6862915 C41.7547899,16.1273729 39.2176035,16.1255422 37.6538436,17.6893022 L23.5,31.8431458 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z\" id=\"Oval-2\" stroke-opacity=\"0.198794158\" stroke=\"#747474\" fill-opacity=\"0.816519475\" fill=\"#FFFFFF\" sketch:type=\"MSShapeGroup\"></path>\n      </g>\n    </svg>\n  </div>\n  <div class=\"dz-error-mark\">\n    <svg width=\"54px\" height=\"54px\" viewBox=\"0 0 54 54\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:sketch=\"http://www.bohemiancoding.com/sketch/ns\">\n      <title>Error</title>\n      <defs></defs>\n      <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\" sketch:type=\"MSPage\">\n        <g id=\"Check-+-Oval-2\" sketch:type=\"MSLayerGroup\" stroke=\"#747474\" stroke-opacity=\"0.198794158\" fill=\"#FFFFFF\" fill-opacity=\"0.816519475\">\n          <path d=\"M32.6568542,29 L38.3106978,23.3461564 C39.8771021,21.7797521 39.8758057,19.2483887 38.3137085,17.6862915 C36.7547899,16.1273729 34.2176035,16.1255422 32.6538436,17.6893022 L27,23.3431458 L21.3461564,17.6893022 C19.7823965,16.1255422 17.2452101,16.1273729 15.6862915,17.6862915 C14.1241943,19.2483887 14.1228979,21.7797521 15.6893022,23.3461564 L21.3431458,29 L15.6893022,34.6538436 C14.1228979,36.2202479 14.1241943,38.7516113 15.6862915,40.3137085 C17.2452101,41.8726271 19.7823965,41.8744578 21.3461564,40.3106978 L27,34.6568542 L32.6538436,40.3106978 C34.2176035,41.8744578 36.7547899,41.8726271 38.3137085,40.3137085 C39.8758057,38.7516113 39.8771021,36.2202479 38.3106978,34.6538436 L32.6568542,29 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z\" id=\"Oval-2\" sketch:type=\"MSShapeGroup\"></path>\n        </g>\n      </g>\n    </svg>\n  </div>\n</div>"};extend=function(){var key,object,objects,target,val,_i,_len;target=arguments[0],objects=2<=arguments.length?__slice.call(arguments,1):[];for(_i=0,_len=objects.length;_i<_len;_i++){object=objects[_i];for(key in object){val=object[key];target[key]=val}}
return target};function Dropzone(element,options){var elementOptions,fallback,_ref;this.element=element;this.version=Dropzone.version;this.defaultOptions.previewTemplate=this.defaultOptions.previewTemplate.replace(/\n*/g,"");this.clickableElements=[];this.listeners=[];this.files=[];if(typeof this.element==="string"){this.element=document.querySelector(this.element)}
if(!(this.element&&(this.element.nodeType!=null))){throw new Error("Invalid dropzone element.")}
if(this.element.dropzone){throw new Error("Dropzone already attached.")}
Dropzone.instances.push(this);this.element.dropzone=this;elementOptions=(_ref=Dropzone.optionsForElement(this.element))!=null?_ref:{};this.options=extend({},this.defaultOptions,elementOptions,options!=null?options:{});if(this.options.forceFallback||!Dropzone.isBrowserSupported()){return this.options.fallback.call(this)}
if(this.options.url==null){this.options.url=this.element.getAttribute("action")}
if(!this.options.url){throw new Error("No URL provided.")}
if(this.options.acceptedFiles&&this.options.acceptedMimeTypes){throw new Error("You can't provide both 'acceptedFiles' and 'acceptedMimeTypes'. 'acceptedMimeTypes' is deprecated.")}
if(this.options.acceptedMimeTypes){this.options.acceptedFiles=this.options.acceptedMimeTypes;delete this.options.acceptedMimeTypes}
this.options.method=this.options.method.toUpperCase();if((fallback=this.getExistingFallback())&&fallback.parentNode){fallback.parentNode.removeChild(fallback)}
if(this.options.previewsContainer!==!1){if(this.options.previewsContainer){this.previewsContainer=Dropzone.getElement(this.options.previewsContainer,"previewsContainer")}else{this.previewsContainer=this.element}}
if(this.options.clickable){if(this.options.clickable===!0){this.clickableElements=[this.element]}else{this.clickableElements=Dropzone.getElements(this.options.clickable,"clickable")}}
this.init()}
Dropzone.prototype.getAcceptedFiles=function(){var file,_i,_len,_ref,_results;_ref=this.files;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];if(file.accepted){_results.push(file)}}
return _results};Dropzone.prototype.getRejectedFiles=function(){var file,_i,_len,_ref,_results;_ref=this.files;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];if(!file.accepted){_results.push(file)}}
return _results};Dropzone.prototype.getFilesWithStatus=function(status){var file,_i,_len,_ref,_results;_ref=this.files;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];if(file.status===status){_results.push(file)}}
return _results};Dropzone.prototype.getQueuedFiles=function(){return this.getFilesWithStatus(Dropzone.QUEUED)};Dropzone.prototype.getUploadingFiles=function(){return this.getFilesWithStatus(Dropzone.UPLOADING)};Dropzone.prototype.getAddedFiles=function(){return this.getFilesWithStatus(Dropzone.ADDED)};Dropzone.prototype.getActiveFiles=function(){var file,_i,_len,_ref,_results;_ref=this.files;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];if(file.status===Dropzone.UPLOADING||file.status===Dropzone.QUEUED){_results.push(file)}}
return _results};Dropzone.prototype.init=function(){var eventName,noPropagation,setupHiddenFileInput,_i,_len,_ref,_ref1;if(this.element.tagName==="form"){this.element.setAttribute("enctype","multipart/form-data")}
if(this.element.classList.contains("dropzone")&&!this.element.querySelector(".dz-message")){this.element.appendChild(Dropzone.createElement("<div class=\"dz-default dz-message\"><span>"+this.options.dictDefaultMessage+"</span></div>"))}
if(this.clickableElements.length){setupHiddenFileInput=(function(_this){return function(){if(_this.hiddenFileInput){_this.hiddenFileInput.parentNode.removeChild(_this.hiddenFileInput)}
_this.hiddenFileInput=document.createElement("input");_this.hiddenFileInput.setAttribute("type","file");if((_this.options.maxFiles==null)||_this.options.maxFiles>1){_this.hiddenFileInput.setAttribute("multiple","multiple")}
_this.hiddenFileInput.className="dz-hidden-input";if(_this.options.acceptedFiles!=null){_this.hiddenFileInput.setAttribute("accept",_this.options.acceptedFiles)}
if(_this.options.capture!=null){_this.hiddenFileInput.setAttribute("capture",_this.options.capture)}
_this.hiddenFileInput.style.visibility="hidden";_this.hiddenFileInput.style.position="absolute";_this.hiddenFileInput.style.top="0";_this.hiddenFileInput.style.left="0";_this.hiddenFileInput.style.height="0";_this.hiddenFileInput.style.width="0";document.querySelector(_this.options.hiddenInputContainer).appendChild(_this.hiddenFileInput);return _this.hiddenFileInput.addEventListener("change",function(){var file,files,_i,_len;files=_this.hiddenFileInput.files;if(files.length){for(_i=0,_len=files.length;_i<_len;_i++){file=files[_i];_this.addFile(file)}}
_this.emit("addedfiles",files);return setupHiddenFileInput()})}})(this);setupHiddenFileInput()}
this.URL=(_ref=window.URL)!=null?_ref:window.webkitURL;_ref1=this.events;for(_i=0,_len=_ref1.length;_i<_len;_i++){eventName=_ref1[_i];this.on(eventName,this.options[eventName])}
this.on("uploadprogress",(function(_this){return function(){return _this.updateTotalUploadProgress()}})(this));this.on("removedfile",(function(_this){return function(){return _this.updateTotalUploadProgress()}})(this));this.on("canceled",(function(_this){return function(file){return _this.emit("complete",file)}})(this));this.on("complete",(function(_this){return function(file){if(_this.getAddedFiles().length===0&&_this.getUploadingFiles().length===0&&_this.getQueuedFiles().length===0){return setTimeout((function(){return _this.emit("queuecomplete")}),0)}}})(this));noPropagation=function(e){e.stopPropagation();if(e.preventDefault){return e.preventDefault()}else{return e.returnValue=!1}};this.listeners=[{element:this.element,events:{"dragstart":(function(_this){return function(e){return _this.emit("dragstart",e)}})(this),"dragenter":(function(_this){return function(e){noPropagation(e);return _this.emit("dragenter",e)}})(this),"dragover":(function(_this){return function(e){var efct;try{efct=e.dataTransfer.effectAllowed}catch(_error){}
e.dataTransfer.dropEffect='move'===efct||'linkMove'===efct?'move':'copy';noPropagation(e);return _this.emit("dragover",e)}})(this),"dragleave":(function(_this){return function(e){return _this.emit("dragleave",e)}})(this),"drop":(function(_this){return function(e){noPropagation(e);return _this.drop(e)}})(this),"dragend":(function(_this){return function(e){return _this.emit("dragend",e)}})(this)}}];this.clickableElements.forEach((function(_this){return function(clickableElement){return _this.listeners.push({element:clickableElement,events:{"click":function(evt){if((clickableElement!==_this.element)||(evt.target===_this.element||Dropzone.elementInside(evt.target,_this.element.querySelector(".dz-message")))){_this.hiddenFileInput.click()}
return!0}}})}})(this));this.enable();return this.options.init.call(this)};Dropzone.prototype.destroy=function(){var _ref;this.disable();this.removeAllFiles(!0);if((_ref=this.hiddenFileInput)!=null?_ref.parentNode:void 0){this.hiddenFileInput.parentNode.removeChild(this.hiddenFileInput);this.hiddenFileInput=null}
delete this.element.dropzone;return Dropzone.instances.splice(Dropzone.instances.indexOf(this),1)};Dropzone.prototype.updateTotalUploadProgress=function(){var activeFiles,file,totalBytes,totalBytesSent,totalUploadProgress,_i,_len,_ref;totalBytesSent=0;totalBytes=0;activeFiles=this.getActiveFiles();if(activeFiles.length){_ref=this.getActiveFiles();for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];totalBytesSent+=file.upload.bytesSent;totalBytes+=file.upload.total}
totalUploadProgress=100*totalBytesSent/totalBytes}else{totalUploadProgress=100}
return this.emit("totaluploadprogress",totalUploadProgress,totalBytes,totalBytesSent)};Dropzone.prototype._getParamName=function(n){if(typeof this.options.paramName==="function"){return this.options.paramName(n)}else{return""+this.options.paramName+(this.options.uploadMultiple?"["+n+"]":"")}};Dropzone.prototype._renameFilename=function(name){if(typeof this.options.renameFilename!=="function"){return name}
return this.options.renameFilename(name)};Dropzone.prototype.getFallbackForm=function(){var existingFallback,fields,fieldsString,form;if(existingFallback=this.getExistingFallback()){return existingFallback}
fieldsString="<div class=\"dz-fallback\">";if(this.options.dictFallbackText){fieldsString+="<p>"+this.options.dictFallbackText+"</p>"}
fieldsString+="<input type=\"file\" name=\""+(this._getParamName(0))+"\" "+(this.options.uploadMultiple?'multiple="multiple"':void 0)+" /><input type=\"submit\" value=\"Upload!\"></div>";fields=Dropzone.createElement(fieldsString);if(this.element.tagName!=="FORM"){form=Dropzone.createElement("<form action=\""+this.options.url+"\" enctype=\"multipart/form-data\" method=\""+this.options.method+"\"></form>");form.appendChild(fields)}else{this.element.setAttribute("enctype","multipart/form-data");this.element.setAttribute("method",this.options.method)}
return form!=null?form:fields};Dropzone.prototype.getExistingFallback=function(){var fallback,getFallback,tagName,_i,_len,_ref;getFallback=function(elements){var el,_i,_len;for(_i=0,_len=elements.length;_i<_len;_i++){el=elements[_i];if(/(^| )fallback($| )/.test(el.className)){return el}}};_ref=["div","form"];for(_i=0,_len=_ref.length;_i<_len;_i++){tagName=_ref[_i];if(fallback=getFallback(this.element.getElementsByTagName(tagName))){return fallback}}};Dropzone.prototype.setupEventListeners=function(){var elementListeners,event,listener,_i,_len,_ref,_results;_ref=this.listeners;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){elementListeners=_ref[_i];_results.push((function(){var _ref1,_results1;_ref1=elementListeners.events;_results1=[];for(event in _ref1){listener=_ref1[event];_results1.push(elementListeners.element.addEventListener(event,listener,!1))}
return _results1})())}
return _results};Dropzone.prototype.removeEventListeners=function(){var elementListeners,event,listener,_i,_len,_ref,_results;_ref=this.listeners;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){elementListeners=_ref[_i];_results.push((function(){var _ref1,_results1;_ref1=elementListeners.events;_results1=[];for(event in _ref1){listener=_ref1[event];_results1.push(elementListeners.element.removeEventListener(event,listener,!1))}
return _results1})())}
return _results};Dropzone.prototype.disable=function(){var file,_i,_len,_ref,_results;this.clickableElements.forEach(function(element){return element.classList.remove("dz-clickable")});this.removeEventListeners();_ref=this.files;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];_results.push(this.cancelUpload(file))}
return _results};Dropzone.prototype.enable=function(){this.clickableElements.forEach(function(element){return element.classList.add("dz-clickable")});return this.setupEventListeners()};Dropzone.prototype.filesize=function(size){var cutoff,i,selectedSize,selectedUnit,unit,units,_i,_len;selectedSize=0;selectedUnit="b";if(size>0){units=['TB','GB','MB','KB','b'];for(i=_i=0,_len=units.length;_i<_len;i=++_i){unit=units[i];cutoff=Math.pow(this.options.filesizeBase,4-i)/10;if(size>=cutoff){selectedSize=size/Math.pow(this.options.filesizeBase,4-i);selectedUnit=unit;break}}
selectedSize=Math.round(10*selectedSize)/10}
return"<strong>"+selectedSize+"</strong> "+selectedUnit};Dropzone.prototype._updateMaxFilesReachedClass=function(){if((this.options.maxFiles!=null)&&this.getAcceptedFiles().length>=this.options.maxFiles){if(this.getAcceptedFiles().length===this.options.maxFiles){this.emit('maxfilesreached',this.files)}
return this.element.classList.add("dz-max-files-reached")}else{return this.element.classList.remove("dz-max-files-reached")}};Dropzone.prototype.drop=function(e){var files,items;if(!e.dataTransfer){return}
this.emit("drop",e);files=e.dataTransfer.files;this.emit("addedfiles",files);if(files.length){items=e.dataTransfer.items;if(items&&items.length&&(items[0].webkitGetAsEntry!=null)){this._addFilesFromItems(items)}else{this.handleFiles(files)}}};Dropzone.prototype.paste=function(e){var items,_ref;if((e!=null?(_ref=e.clipboardData)!=null?_ref.items:void 0:void 0)==null){return}
this.emit("paste",e);items=e.clipboardData.items;if(items.length){return this._addFilesFromItems(items)}};Dropzone.prototype.handleFiles=function(files){var file,_i,_len,_results;_results=[];for(_i=0,_len=files.length;_i<_len;_i++){file=files[_i];_results.push(this.addFile(file))}
return _results};Dropzone.prototype._addFilesFromItems=function(items){var entry,item,_i,_len,_results;_results=[];for(_i=0,_len=items.length;_i<_len;_i++){item=items[_i];if((item.webkitGetAsEntry!=null)&&(entry=item.webkitGetAsEntry())){if(entry.isFile){_results.push(this.addFile(item.getAsFile()))}else if(entry.isDirectory){_results.push(this._addFilesFromDirectory(entry,entry.name))}else{_results.push(void 0)}}else if(item.getAsFile!=null){if((item.kind==null)||item.kind==="file"){_results.push(this.addFile(item.getAsFile()))}else{_results.push(void 0)}}else{_results.push(void 0)}}
return _results};Dropzone.prototype._addFilesFromDirectory=function(directory,path){var dirReader,errorHandler,readEntries;dirReader=directory.createReader();errorHandler=function(error){return typeof console!=="undefined"&&console!==null?typeof console.log==="function"?console.log(error):void 0:void 0};readEntries=(function(_this){return function(){return dirReader.readEntries(function(entries){var entry,_i,_len;if(entries.length>0){for(_i=0,_len=entries.length;_i<_len;_i++){entry=entries[_i];if(entry.isFile){entry.file(function(file){if(_this.options.ignoreHiddenFiles&&file.name.substring(0,1)==='.'){return}
file.fullPath=""+path+"/"+file.name;return _this.addFile(file)})}else if(entry.isDirectory){_this._addFilesFromDirectory(entry,""+path+"/"+entry.name)}}
readEntries()}
return null},errorHandler)}})(this);return readEntries()};Dropzone.prototype.accept=function(file,done){if(file.size>this.options.maxFilesize*1024*1024){return done(this.options.dictFileTooBig.replace("{{filesize}}",Math.round(file.size/1024/10.24)/100).replace("{{maxFilesize}}",this.options.maxFilesize))}else if(!Dropzone.isValidFile(file,this.options.acceptedFiles)){return done(this.options.dictInvalidFileType)}else if((this.options.maxFiles!=null)&&this.getAcceptedFiles().length>=this.options.maxFiles){done(this.options.dictMaxFilesExceeded.replace("{{maxFiles}}",this.options.maxFiles));return this.emit("maxfilesexceeded",file)}else{return this.options.accept.call(this,file,done)}};Dropzone.prototype.addFile=function(file){file.upload={progress:0,total:file.size,bytesSent:0};this.files.push(file);file.status=Dropzone.ADDED;this.emit("addedfile",file);this._enqueueThumbnail(file);return this.accept(file,(function(_this){return function(error){if(error){file.accepted=!1;_this._errorProcessing([file],error)}else{file.accepted=!0;if(_this.options.autoQueue){_this.enqueueFile(file)}}
return _this._updateMaxFilesReachedClass()}})(this))};Dropzone.prototype.enqueueFiles=function(files){var file,_i,_len;for(_i=0,_len=files.length;_i<_len;_i++){file=files[_i];this.enqueueFile(file)}
return null};Dropzone.prototype.enqueueFile=function(file){if(file.status===Dropzone.ADDED&&file.accepted===!0){file.status=Dropzone.QUEUED;if(this.options.autoProcessQueue){return setTimeout(((function(_this){return function(){return _this.processQueue()}})(this)),0)}}else{throw new Error("This file can't be queued because it has already been processed or was rejected.")}};Dropzone.prototype._thumbnailQueue=[];Dropzone.prototype._processingThumbnail=!1;Dropzone.prototype._enqueueThumbnail=function(file){if(this.options.createImageThumbnails&&file.type.match(/image.*/)&&file.size<=this.options.maxThumbnailFilesize*1024*1024){this._thumbnailQueue.push(file);return setTimeout(((function(_this){return function(){return _this._processThumbnailQueue()}})(this)),0)}};Dropzone.prototype._processThumbnailQueue=function(){if(this._processingThumbnail||this._thumbnailQueue.length===0){return}
this._processingThumbnail=!0;return this.createThumbnail(this._thumbnailQueue.shift(),(function(_this){return function(){_this._processingThumbnail=!1;return _this._processThumbnailQueue()}})(this))};Dropzone.prototype.removeFile=function(file){if(file.status===Dropzone.UPLOADING){this.cancelUpload(file)}
this.files=without(this.files,file);this.emit("removedfile",file);if(this.files.length===0){return this.emit("reset")}};Dropzone.prototype.removeAllFiles=function(cancelIfNecessary){var file,_i,_len,_ref;if(cancelIfNecessary==null){cancelIfNecessary=!1}
_ref=this.files.slice();for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];if(file.status!==Dropzone.UPLOADING||cancelIfNecessary){this.removeFile(file)}}
return null};Dropzone.prototype.createThumbnail=function(file,callback){var fileReader;fileReader=new FileReader;fileReader.onload=(function(_this){return function(){if(file.type==="image/svg+xml"){_this.emit("thumbnail",file,fileReader.result);if(callback!=null){callback()}
return}
return _this.createThumbnailFromUrl(file,fileReader.result,callback)}})(this);return fileReader.readAsDataURL(file)};Dropzone.prototype.createThumbnailFromUrl=function(file,imageUrl,callback,crossOrigin){var img;img=document.createElement("img");if(crossOrigin){img.crossOrigin=crossOrigin}
img.onload=(function(_this){return function(){var canvas,ctx,resizeInfo,thumbnail,_ref,_ref1,_ref2,_ref3;file.width=img.width;file.height=img.height;resizeInfo=_this.options.resize.call(_this,file);if(resizeInfo.trgWidth==null){resizeInfo.trgWidth=resizeInfo.optWidth}
if(resizeInfo.trgHeight==null){resizeInfo.trgHeight=resizeInfo.optHeight}
canvas=document.createElement("canvas");ctx=canvas.getContext("2d");canvas.width=resizeInfo.trgWidth;canvas.height=resizeInfo.trgHeight;drawImageIOSFix(ctx,img,(_ref=resizeInfo.srcX)!=null?_ref:0,(_ref1=resizeInfo.srcY)!=null?_ref1:0,resizeInfo.srcWidth,resizeInfo.srcHeight,(_ref2=resizeInfo.trgX)!=null?_ref2:0,(_ref3=resizeInfo.trgY)!=null?_ref3:0,resizeInfo.trgWidth,resizeInfo.trgHeight);thumbnail=canvas.toDataURL("image/png");_this.emit("thumbnail",file,thumbnail);if(callback!=null){return callback()}}})(this);if(callback!=null){img.onerror=callback}
return img.src=imageUrl};Dropzone.prototype.processQueue=function(){var i,parallelUploads,processingLength,queuedFiles;parallelUploads=this.options.parallelUploads;processingLength=this.getUploadingFiles().length;i=processingLength;if(processingLength>=parallelUploads){return}
queuedFiles=this.getQueuedFiles();if(!(queuedFiles.length>0)){return}
if(this.options.uploadMultiple){return this.processFiles(queuedFiles.slice(0,parallelUploads-processingLength))}else{while(i<parallelUploads){if(!queuedFiles.length){return}
this.processFile(queuedFiles.shift());i++}}};Dropzone.prototype.processFile=function(file){return this.processFiles([file])};Dropzone.prototype.processFiles=function(files){var file,_i,_len;for(_i=0,_len=files.length;_i<_len;_i++){file=files[_i];file.processing=!0;file.status=Dropzone.UPLOADING;this.emit("processing",file)}
if(this.options.uploadMultiple){this.emit("processingmultiple",files)}
return this.uploadFiles(files)};Dropzone.prototype._getFilesWithXhr=function(xhr){var file,files;return files=(function(){var _i,_len,_ref,_results;_ref=this.files;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){file=_ref[_i];if(file.xhr===xhr){_results.push(file)}}
return _results}).call(this)};Dropzone.prototype.cancelUpload=function(file){var groupedFile,groupedFiles,_i,_j,_len,_len1,_ref;if(file.status===Dropzone.UPLOADING){groupedFiles=this._getFilesWithXhr(file.xhr);for(_i=0,_len=groupedFiles.length;_i<_len;_i++){groupedFile=groupedFiles[_i];groupedFile.status=Dropzone.CANCELED}
file.xhr.abort();for(_j=0,_len1=groupedFiles.length;_j<_len1;_j++){groupedFile=groupedFiles[_j];this.emit("canceled",groupedFile)}
if(this.options.uploadMultiple){this.emit("canceledmultiple",groupedFiles)}}else if((_ref=file.status)===Dropzone.ADDED||_ref===Dropzone.QUEUED){file.status=Dropzone.CANCELED;this.emit("canceled",file);if(this.options.uploadMultiple){this.emit("canceledmultiple",[file])}}
if(this.options.autoProcessQueue){return this.processQueue()}};resolveOption=function(){var args,option;option=arguments[0],args=2<=arguments.length?__slice.call(arguments,1):[];if(typeof option==='function'){return option.apply(this,args)}
return option};Dropzone.prototype.uploadFile=function(file){return this.uploadFiles([file])};Dropzone.prototype.uploadFiles=function(files){var file,formData,handleError,headerName,headerValue,headers,i,input,inputName,inputType,key,method,option,progressObj,response,updateProgress,url,value,xhr,_i,_j,_k,_l,_len,_len1,_len2,_len3,_m,_ref,_ref1,_ref2,_ref3,_ref4,_ref5;xhr=new XMLHttpRequest();for(_i=0,_len=files.length;_i<_len;_i++){file=files[_i];file.xhr=xhr}
method=resolveOption(this.options.method,files);url=resolveOption(this.options.url,files);xhr.open(method,url,!0);xhr.withCredentials=!!this.options.withCredentials;response=null;handleError=(function(_this){return function(){var _j,_len1,_results;_results=[];for(_j=0,_len1=files.length;_j<_len1;_j++){file=files[_j];_results.push(_this._errorProcessing(files,response||_this.options.dictResponseError.replace("{{statusCode}}",xhr.status),xhr))}
return _results}})(this);updateProgress=(function(_this){return function(e){var allFilesFinished,progress,_j,_k,_l,_len1,_len2,_len3,_results;if(e!=null){progress=100*e.loaded/e.total;for(_j=0,_len1=files.length;_j<_len1;_j++){file=files[_j];file.upload={progress:progress,total:e.total,bytesSent:e.loaded}}}else{allFilesFinished=!0;progress=100;for(_k=0,_len2=files.length;_k<_len2;_k++){file=files[_k];if(!(file.upload.progress===100&&file.upload.bytesSent===file.upload.total)){allFilesFinished=!1}
file.upload.progress=progress;file.upload.bytesSent=file.upload.total}
if(allFilesFinished){return}}
_results=[];for(_l=0,_len3=files.length;_l<_len3;_l++){file=files[_l];_results.push(_this.emit("uploadprogress",file,progress,file.upload.bytesSent))}
return _results}})(this);xhr.onload=(function(_this){return function(e){var _ref;if(files[0].status===Dropzone.CANCELED){return}
if(xhr.readyState!==4){return}
response=xhr.responseText;if(xhr.getResponseHeader("content-type")&&~xhr.getResponseHeader("content-type").indexOf("application/json")){try{response=JSON.parse(response)}catch(_error){e=_error;response="Invalid JSON response from server."}}
updateProgress();if(!((200<=(_ref=xhr.status)&&_ref<300))){return handleError()}else{return _this._finished(files,response,e)}}})(this);xhr.onerror=(function(_this){return function(){if(files[0].status===Dropzone.CANCELED){return}
return handleError()}})(this);progressObj=(_ref=xhr.upload)!=null?_ref:xhr;progressObj.onprogress=updateProgress;headers={"Accept":"application/json","Cache-Control":"no-cache","X-Requested-With":"XMLHttpRequest"};if(this.options.headers){extend(headers,this.options.headers)}
for(headerName in headers){headerValue=headers[headerName];if(headerValue){xhr.setRequestHeader(headerName,headerValue)}}
formData=new FormData();if(this.options.params){_ref1=this.options.params;for(key in _ref1){value=_ref1[key];formData.append(key,value)}}
for(_j=0,_len1=files.length;_j<_len1;_j++){file=files[_j];this.emit("sending",file,xhr,formData)}
if(this.options.uploadMultiple){this.emit("sendingmultiple",files,xhr,formData)}
if(this.element.tagName==="FORM"){_ref2=this.element.querySelectorAll("input, textarea, select, button");for(_k=0,_len2=_ref2.length;_k<_len2;_k++){input=_ref2[_k];inputName=input.getAttribute("name");inputType=input.getAttribute("type");if(input.tagName==="SELECT"&&input.hasAttribute("multiple")){_ref3=input.options;for(_l=0,_len3=_ref3.length;_l<_len3;_l++){option=_ref3[_l];if(option.selected){formData.append(inputName,option.value)}}}else if(!inputType||((_ref4=inputType.toLowerCase())!=="checkbox"&&_ref4!=="radio")||input.checked){formData.append(inputName,input.value)}}}
for(i=_m=0,_ref5=files.length-1;0<=_ref5?_m<=_ref5:_m>=_ref5;i=0<=_ref5?++_m:--_m){formData.append(this._getParamName(i),files[i],this._renameFilename(files[i].name))}
return this.submitRequest(xhr,formData,files)};Dropzone.prototype.submitRequest=function(xhr,formData,files){return xhr.send(formData)};Dropzone.prototype._finished=function(files,responseText,e){var file,_i,_len;for(_i=0,_len=files.length;_i<_len;_i++){file=files[_i];file.status=Dropzone.SUCCESS;this.emit("success",file,responseText,e);this.emit("complete",file)}
if(this.options.uploadMultiple){this.emit("successmultiple",files,responseText,e);this.emit("completemultiple",files)}
if(this.options.autoProcessQueue){return this.processQueue()}};Dropzone.prototype._errorProcessing=function(files,message,xhr){var file,_i,_len;for(_i=0,_len=files.length;_i<_len;_i++){file=files[_i];file.status=Dropzone.ERROR;this.emit("error",file,message,xhr);this.emit("complete",file)}
if(this.options.uploadMultiple){this.emit("errormultiple",files,message,xhr);this.emit("completemultiple",files)}
if(this.options.autoProcessQueue){return this.processQueue()}};return Dropzone})(Emitter);Dropzone.version="4.3.0";Dropzone.options={};Dropzone.optionsForElement=function(element){if(element.getAttribute("id")){return Dropzone.options[camelize(element.getAttribute("id"))]}else{return void 0}};Dropzone.instances=[];Dropzone.forElement=function(element){if(typeof element==="string"){element=document.querySelector(element)}
if((element!=null?element.dropzone:void 0)==null){throw new Error("No Dropzone found for given element. This is probably because you're trying to access it before Dropzone had the time to initialize. Use the `init` option to setup any additional observers on your Dropzone.")}
return element.dropzone};Dropzone.autoDiscover=!0;Dropzone.discover=function(){var checkElements,dropzone,dropzones,_i,_len,_results;if(document.querySelectorAll){dropzones=document.querySelectorAll(".dropzone")}else{dropzones=[];checkElements=function(elements){var el,_i,_len,_results;_results=[];for(_i=0,_len=elements.length;_i<_len;_i++){el=elements[_i];if(/(^| )dropzone($| )/.test(el.className)){_results.push(dropzones.push(el))}else{_results.push(void 0)}}
return _results};checkElements(document.getElementsByTagName("div"));checkElements(document.getElementsByTagName("form"))}
_results=[];for(_i=0,_len=dropzones.length;_i<_len;_i++){dropzone=dropzones[_i];if(Dropzone.optionsForElement(dropzone)!==!1){_results.push(new Dropzone(dropzone))}else{_results.push(void 0)}}
return _results};Dropzone.blacklistedBrowsers=[/opera.*Macintosh.*version\/12/i];Dropzone.isBrowserSupported=function(){var capableBrowser,regex,_i,_len,_ref;capableBrowser=!0;if(window.File&&window.FileReader&&window.FileList&&window.Blob&&window.FormData&&document.querySelector){if(!("classList" in document.createElement("a"))){capableBrowser=!1}else{_ref=Dropzone.blacklistedBrowsers;for(_i=0,_len=_ref.length;_i<_len;_i++){regex=_ref[_i];if(regex.test(navigator.userAgent)){capableBrowser=!1;continue}}}}else{capableBrowser=!1}
return capableBrowser};without=function(list,rejectedItem){var item,_i,_len,_results;_results=[];for(_i=0,_len=list.length;_i<_len;_i++){item=list[_i];if(item!==rejectedItem){_results.push(item)}}
return _results};camelize=function(str){return str.replace(/[\-_](\w)/g,function(match){return match.charAt(1).toUpperCase()})};Dropzone.createElement=function(string){var div;div=document.createElement("div");div.innerHTML=string;return div.childNodes[0]};Dropzone.elementInside=function(element,container){if(element===container){return!0}
while(element=element.parentNode){if(element===container){return!0}}
return!1};Dropzone.getElement=function(el,name){var element;if(typeof el==="string"){element=document.querySelector(el)}else if(el.nodeType!=null){element=el}
if(element==null){throw new Error("Invalid `"+name+"` option provided. Please provide a CSS selector or a plain HTML element.")}
return element};Dropzone.getElements=function(els,name){var e,el,elements,_i,_j,_len,_len1,_ref;if(els instanceof Array){elements=[];try{for(_i=0,_len=els.length;_i<_len;_i++){el=els[_i];elements.push(this.getElement(el,name))}}catch(_error){e=_error;elements=null}}else if(typeof els==="string"){elements=[];_ref=document.querySelectorAll(els);for(_j=0,_len1=_ref.length;_j<_len1;_j++){el=_ref[_j];elements.push(el)}}else if(els.nodeType!=null){elements=[els]}
if(!((elements!=null)&&elements.length)){throw new Error("Invalid `"+name+"` option provided. Please provide a CSS selector, a plain HTML element or a list of those.")}
return elements};Dropzone.confirm=function(question,accepted,rejected){if(window.confirm(question)){return accepted()}else if(rejected!=null){return rejected()}};Dropzone.isValidFile=function(file,acceptedFiles){var baseMimeType,mimeType,validType,_i,_len;if(!acceptedFiles){return!0}
acceptedFiles=acceptedFiles.split(",");mimeType=file.type;baseMimeType=mimeType.replace(/\/.*$/,"");for(_i=0,_len=acceptedFiles.length;_i<_len;_i++){validType=acceptedFiles[_i];validType=validType.trim();if(validType.charAt(0)==="."){if(file.name.toLowerCase().indexOf(validType.toLowerCase(),file.name.length-validType.length)!==-1){return!0}}else if(/\/\*$/.test(validType)){if(baseMimeType===validType.replace(/\/.*$/,"")){return!0}}else{if(mimeType===validType){return!0}}}
return!1};if(typeof jQuery!=="undefined"&&jQuery!==null){jQuery.fn.dropzone=function(options){return this.each(function(){return new Dropzone(this,options)})}}
if(typeof module!=="undefined"&&module!==null){module.exports=Dropzone}else{window.Dropzone=Dropzone}
Dropzone.ADDED="added";Dropzone.QUEUED="queued";Dropzone.ACCEPTED=Dropzone.QUEUED;Dropzone.UPLOADING="uploading";Dropzone.PROCESSING=Dropzone.UPLOADING;Dropzone.CANCELED="canceled";Dropzone.ERROR="error";Dropzone.SUCCESS="success";detectVerticalSquash=function(img){var alpha,canvas,ctx,data,ey,ih,iw,py,ratio,sy;iw=img.naturalWidth;ih=img.naturalHeight;canvas=document.createElement("canvas");canvas.width=1;canvas.height=ih;ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);data=ctx.getImageData(0,0,1,ih).data;sy=0;ey=ih;py=ih;while(py>sy){alpha=data[(py-1)*4+3];if(alpha===0){ey=py}else{sy=py}
py=(ey+sy)>>1}
ratio=py/ih;if(ratio===0){return 1}else{return ratio}};drawImageIOSFix=function(ctx,img,sx,sy,sw,sh,dx,dy,dw,dh){var vertSquashRatio;vertSquashRatio=detectVerticalSquash(img);return ctx.drawImage(img,sx,sy,sw,sh,dx,dy,dw,dh/vertSquashRatio)};contentLoaded=function(win,fn){var add,doc,done,init,poll,pre,rem,root,top;done=!1;top=!0;doc=win.document;root=doc.documentElement;add=(doc.addEventListener?"addEventListener":"attachEvent");rem=(doc.addEventListener?"removeEventListener":"detachEvent");pre=(doc.addEventListener?"":"on");init=function(e){if(e.type==="readystatechange"&&doc.readyState!=="complete"){return}(e.type==="load"?win:doc)[rem](pre+e.type,init,!1);if(!done&&(done=!0)){return fn.call(win,e.type||e)}};poll=function(){var e;try{root.doScroll("left")}catch(_error){e=_error;setTimeout(poll,50);return}
return init("poll")};if(doc.readyState!=="complete"){if(doc.createEventObject&&root.doScroll){try{top=!win.frameElement}catch(_error){}
if(top){poll()}}
doc[add](pre+"DOMContentLoaded",init,!1);doc[add](pre+"readystatechange",init,!1);return win[add](pre+"load",init,!1)}};Dropzone._autoDiscoverFunction=function(){if(Dropzone.autoDiscover){return Dropzone.discover()}};contentLoaded(window,Dropzone._autoDiscoverFunction)}).call(this);!function($){"use strict";var MultiSelect=function(element,options){this.options=options;this.$element=$(element);this.$container=$('<div/>',{'class':"ms-container"});this.$selectableContainer=$('<div/>',{'class':'ms-selectable'});this.$selectionContainer=$('<div/>',{'class':'ms-selection'});this.$selectableUl=$('<ul/>',{'class':"ms-list",'tabindex':'-1'});this.$selectionUl=$('<ul/>',{'class':"ms-list",'tabindex':'-1'});this.scrollTo=0;this.elemsSelector='li:visible:not(.ms-optgroup-label,.ms-optgroup-container,.'+options.disabledClass+')'};MultiSelect.prototype={constructor:MultiSelect,init:function(){var that=this,ms=this.$element;if(ms.next('.ms-container').length===0){ms.css({position:'absolute',left:'-9999px'});ms.attr('id',ms.attr('id')?ms.attr('id'):Math.ceil(Math.random()*1000)+'multiselect');this.$container.attr('id','ms-'+ms.attr('id'));this.$container.addClass(that.options.cssClass);ms.find('option').each(function(){that.generateLisFromOption(this)});this.$selectionUl.find('.ms-optgroup-label').hide();if(that.options.selectableHeader){that.$selectableContainer.append(that.options.selectableHeader)}
that.$selectableContainer.append(that.$selectableUl);if(that.options.selectableFooter){that.$selectableContainer.append(that.options.selectableFooter)}
if(that.options.selectionHeader){that.$selectionContainer.append(that.options.selectionHeader)}
that.$selectionContainer.append(that.$selectionUl);if(that.options.selectionFooter){that.$selectionContainer.append(that.options.selectionFooter)}
that.$container.append(that.$selectableContainer);that.$container.append(that.$selectionContainer);ms.after(that.$container);that.activeMouse(that.$selectableUl);that.activeKeyboard(that.$selectableUl);var action=that.options.dblClick?'dblclick':'click';that.$selectableUl.on(action,'.ms-elem-selectable',function(){that.select($(this).data('ms-value'))});that.$selectionUl.on(action,'.ms-elem-selection',function(){that.deselect($(this).data('ms-value'))});that.activeMouse(that.$selectionUl);that.activeKeyboard(that.$selectionUl);ms.on('focus',function(){that.$selectableUl.focus()})}
var selectedValues=ms.find('option:selected').map(function(){return $(this).val()}).get();that.select(selectedValues,'init');if(typeof that.options.afterInit==='function'){that.options.afterInit.call(this,this.$container)}},'generateLisFromOption':function(option,index,$container){var that=this,ms=that.$element,attributes="",$option=$(option);for(var cpt=0;cpt<option.attributes.length;cpt++){var attr=option.attributes[cpt];if(attr.name!=='value'&&attr.name!=='disabled'){attributes+=attr.name+'="'+attr.value+'" '}}
var selectableLi=$('<li '+attributes+'><span>'+that.escapeHTML($option.text())+'</span></li>'),selectedLi=selectableLi.clone(),value=$option.val(),elementId=that.sanitize(value);selectableLi.data('ms-value',value).addClass('ms-elem-selectable').attr('id',elementId+'-selectable');selectedLi.data('ms-value',value).addClass('ms-elem-selection').attr('id',elementId+'-selection').hide();if($option.prop('disabled')||ms.prop('disabled')){selectedLi.addClass(that.options.disabledClass);selectableLi.addClass(that.options.disabledClass)}
var $optgroup=$option.parent('optgroup');if($optgroup.length>0){var optgroupLabel=$optgroup.attr('label'),optgroupId=that.sanitize(optgroupLabel),$selectableOptgroup=that.$selectableUl.find('#optgroup-selectable-'+optgroupId),$selectionOptgroup=that.$selectionUl.find('#optgroup-selection-'+optgroupId);if($selectableOptgroup.length===0){var optgroupContainerTpl='<li class="ms-optgroup-container"></li>',optgroupTpl='<ul class="ms-optgroup"><li class="ms-optgroup-label"><span>'+optgroupLabel+'</span></li></ul>';$selectableOptgroup=$(optgroupContainerTpl);$selectionOptgroup=$(optgroupContainerTpl);$selectableOptgroup.attr('id','optgroup-selectable-'+optgroupId);$selectionOptgroup.attr('id','optgroup-selection-'+optgroupId);$selectableOptgroup.append($(optgroupTpl));$selectionOptgroup.append($(optgroupTpl));if(that.options.selectableOptgroup){$selectableOptgroup.find('.ms-optgroup-label').on('click',function(){var values=$optgroup.children(':not(:selected, :disabled)').map(function(){return $(this).val()}).get();that.select(values)});$selectionOptgroup.find('.ms-optgroup-label').on('click',function(){var values=$optgroup.children(':selected:not(:disabled)').map(function(){return $(this).val()}).get();that.deselect(values)})}
that.$selectableUl.append($selectableOptgroup);that.$selectionUl.append($selectionOptgroup)}
index=index==undefined?$selectableOptgroup.find('ul').children().length:index+1;selectableLi.insertAt(index,$selectableOptgroup.children());selectedLi.insertAt(index,$selectionOptgroup.children())}else{index=index==undefined?that.$selectableUl.children().length:index;selectableLi.insertAt(index,that.$selectableUl);selectedLi.insertAt(index,that.$selectionUl)}},'addOption':function(options){var that=this;if(options.value!==undefined&&options.value!==null){options=[options]}
$.each(options,function(index,option){if(option.value!==undefined&&option.value!==null&&that.$element.find("option[value='"+option.value+"']").length===0){var $option=$('<option value="'+option.value+'">'+option.text+'</option>'),index=parseInt((typeof option.index==='undefined'?that.$element.children().length:option.index)),$container=option.nested==undefined?that.$element:$("optgroup[label='"+option.nested+"']")
$option.insertAt(index,$container);that.generateLisFromOption($option.get(0),index,option.nested)}})},'escapeHTML':function(text){return $("<div>").text(text).html()},'activeKeyboard':function($list){var that=this;$list.on('focus',function(){$(this).addClass('ms-focus')}).on('blur',function(){$(this).removeClass('ms-focus')}).on('keydown',function(e){switch(e.which){case 40:case 38:e.preventDefault();e.stopPropagation();that.moveHighlight($(this),(e.which===38)?-1:1);return;case 37:case 39:e.preventDefault();e.stopPropagation();that.switchList($list);return;case 9:if(that.$element.is('[tabindex]')){e.preventDefault();var tabindex=parseInt(that.$element.attr('tabindex'),10);tabindex=(e.shiftKey)?tabindex-1:tabindex+1;$('[tabindex="'+(tabindex)+'"]').focus();return}else{if(e.shiftKey){that.$element.trigger('focus')}}}
if($.inArray(e.which,that.options.keySelect)>-1){e.preventDefault();e.stopPropagation();that.selectHighlighted($list);return}})},'moveHighlight':function($list,direction){var $elems=$list.find(this.elemsSelector),$currElem=$elems.filter('.ms-hover'),$nextElem=null,elemHeight=$elems.first().outerHeight(),containerHeight=$list.height(),containerSelector='#'+this.$container.prop('id');$elems.removeClass('ms-hover');if(direction===1){$nextElem=$currElem.nextAll(this.elemsSelector).first();if($nextElem.length===0){var $optgroupUl=$currElem.parent();if($optgroupUl.hasClass('ms-optgroup')){var $optgroupLi=$optgroupUl.parent(),$nextOptgroupLi=$optgroupLi.next(':visible');if($nextOptgroupLi.length>0){$nextElem=$nextOptgroupLi.find(this.elemsSelector).first()}else{$nextElem=$elems.first()}}else{$nextElem=$elems.first()}}}else if(direction===-1){$nextElem=$currElem.prevAll(this.elemsSelector).first();if($nextElem.length===0){var $optgroupUl=$currElem.parent();if($optgroupUl.hasClass('ms-optgroup')){var $optgroupLi=$optgroupUl.parent(),$prevOptgroupLi=$optgroupLi.prev(':visible');if($prevOptgroupLi.length>0){$nextElem=$prevOptgroupLi.find(this.elemsSelector).last()}else{$nextElem=$elems.last()}}else{$nextElem=$elems.last()}}}
if($nextElem.length>0){$nextElem.addClass('ms-hover');var scrollTo=$list.scrollTop()+$nextElem.position().top-containerHeight/2+elemHeight/2;$list.scrollTop(scrollTo)}},'selectHighlighted':function($list){var $elems=$list.find(this.elemsSelector),$highlightedElem=$elems.filter('.ms-hover').first();if($highlightedElem.length>0){if($list.parent().hasClass('ms-selectable')){this.select($highlightedElem.data('ms-value'))}else{this.deselect($highlightedElem.data('ms-value'))}
$elems.removeClass('ms-hover')}},'switchList':function($list){$list.blur();this.$container.find(this.elemsSelector).removeClass('ms-hover');if($list.parent().hasClass('ms-selectable')){this.$selectionUl.focus()}else{this.$selectableUl.focus()}},'activeMouse':function($list){var that=this;this.$container.on('mouseenter',that.elemsSelector,function(){$(this).parents('.ms-container').find(that.elemsSelector).removeClass('ms-hover');$(this).addClass('ms-hover')});this.$container.on('mouseleave',that.elemsSelector,function(){$(this).parents('.ms-container').find(that.elemsSelector).removeClass('ms-hover')})},'refresh':function(){this.destroy();this.$element.multiSelect(this.options)},'destroy':function(){$("#ms-"+this.$element.attr("id")).remove();this.$element.css('position','').css('left','')
this.$element.removeData('multiselect')},'select':function(value,method){if(typeof value==='string'){value=[value]}
var that=this,ms=this.$element,msIds=$.map(value,function(val){return(that.sanitize(val))}),selectables=this.$selectableUl.find('#'+msIds.join('-selectable, #')+'-selectable').filter(':not(.'+that.options.disabledClass+')'),selections=this.$selectionUl.find('#'+msIds.join('-selection, #')+'-selection').filter(':not(.'+that.options.disabledClass+')'),options=ms.find('option:not(:disabled)').filter(function(){return($.inArray(this.value,value)>-1)});if(method==='init'){selectables=this.$selectableUl.find('#'+msIds.join('-selectable, #')+'-selectable'),selections=this.$selectionUl.find('#'+msIds.join('-selection, #')+'-selection')}
if(selectables.length>0){selectables.addClass('ms-selected').hide();selections.addClass('ms-selected').show();options.prop('selected',!0);that.$container.find(that.elemsSelector).removeClass('ms-hover');var selectableOptgroups=that.$selectableUl.children('.ms-optgroup-container');if(selectableOptgroups.length>0){selectableOptgroups.each(function(){var selectablesLi=$(this).find('.ms-elem-selectable');if(selectablesLi.length===selectablesLi.filter('.ms-selected').length){$(this).find('.ms-optgroup-label').hide()}});var selectionOptgroups=that.$selectionUl.children('.ms-optgroup-container');selectionOptgroups.each(function(){var selectionsLi=$(this).find('.ms-elem-selection');if(selectionsLi.filter('.ms-selected').length>0){$(this).find('.ms-optgroup-label').show()}})}else{if(that.options.keepOrder&&method!=='init'){var selectionLiLast=that.$selectionUl.find('.ms-selected');if((selectionLiLast.length>1)&&(selectionLiLast.last().get(0)!=selections.get(0))){selections.insertAfter(selectionLiLast.last())}}}
if(method!=='init'){ms.trigger('change');if(typeof that.options.afterSelect==='function'){that.options.afterSelect.call(this,value)}}}},'deselect':function(value){if(typeof value==='string'){value=[value]}
var that=this,ms=this.$element,msIds=$.map(value,function(val){return(that.sanitize(val))}),selectables=this.$selectableUl.find('#'+msIds.join('-selectable, #')+'-selectable'),selections=this.$selectionUl.find('#'+msIds.join('-selection, #')+'-selection').filter('.ms-selected').filter(':not(.'+that.options.disabledClass+')'),options=ms.find('option').filter(function(){return($.inArray(this.value,value)>-1)});if(selections.length>0){selectables.removeClass('ms-selected').show();selections.removeClass('ms-selected').hide();options.prop('selected',!1);that.$container.find(that.elemsSelector).removeClass('ms-hover');var selectableOptgroups=that.$selectableUl.children('.ms-optgroup-container');if(selectableOptgroups.length>0){selectableOptgroups.each(function(){var selectablesLi=$(this).find('.ms-elem-selectable');if(selectablesLi.filter(':not(.ms-selected)').length>0){$(this).find('.ms-optgroup-label').show()}});var selectionOptgroups=that.$selectionUl.children('.ms-optgroup-container');selectionOptgroups.each(function(){var selectionsLi=$(this).find('.ms-elem-selection');if(selectionsLi.filter('.ms-selected').length===0){$(this).find('.ms-optgroup-label').hide()}})}
ms.trigger('change');if(typeof that.options.afterDeselect==='function'){that.options.afterDeselect.call(this,value)}}},'select_all':function(){var ms=this.$element,values=ms.val();ms.find('option:not(":disabled")').prop('selected',!0);this.$selectableUl.find('.ms-elem-selectable').filter(':not(.'+this.options.disabledClass+')').addClass('ms-selected').hide();this.$selectionUl.find('.ms-optgroup-label').show();this.$selectableUl.find('.ms-optgroup-label').hide();this.$selectionUl.find('.ms-elem-selection').filter(':not(.'+this.options.disabledClass+')').addClass('ms-selected').show();this.$selectionUl.focus();ms.trigger('change');if(typeof this.options.afterSelect==='function'){var selectedValues=$.grep(ms.val(),function(item){return $.inArray(item,values)<0});this.options.afterSelect.call(this,selectedValues)}},'deselect_all':function(){var ms=this.$element,values=ms.val();ms.find('option').prop('selected',!1);this.$selectableUl.find('.ms-elem-selectable').removeClass('ms-selected').show();this.$selectionUl.find('.ms-optgroup-label').hide();this.$selectableUl.find('.ms-optgroup-label').show();this.$selectionUl.find('.ms-elem-selection').removeClass('ms-selected').hide();this.$selectableUl.focus();ms.trigger('change');if(typeof this.options.afterDeselect==='function'){this.options.afterDeselect.call(this,values)}},sanitize:function(value){var hash=0,i,character;if(value.length==0)return hash;var ls=0;for(i=0,ls=value.length;i<ls;i++){character=value.charCodeAt(i);hash=((hash<<5)-hash)+character;hash|=0}
return hash}};$.fn.multiSelect=function(){var option=arguments[0],args=arguments;return this.each(function(){var $this=$(this),data=$this.data('multiselect'),options=$.extend({},$.fn.multiSelect.defaults,$this.data(),typeof option==='object'&&option);if(!data){$this.data('multiselect',(data=new MultiSelect(this,options)))}
if(typeof option==='string'){data[option](args[1])}else{data.init()}})};$.fn.multiSelect.defaults={keySelect:[32],selectableOptgroup:!1,disabledClass:'disabled',dblClick:!1,keepOrder:!1,cssClass:''};$.fn.multiSelect.Constructor=MultiSelect;$.fn.insertAt=function(index,$parent){return this.each(function(){if(index===0){$parent.prepend(this)}else{$parent.children().eq(index-1).after(this)}})}}(window.jQuery);/*!
 * Chart.js v2.9.4
 * https://www.chartjs.org
 * (c) 2020 Chart.js Contributors
 * Released under the MIT License
 */
(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory(function(){try{return require('moment')}catch(e){}}()):typeof define==='function'&&define.amd?define(['require'],function(require){return factory(function(){try{return require('moment')}catch(e){}}())}):(global=global||self,global.Chart=factory(global.moment))}(this,(function(moment){'use strict';moment=moment&&moment.hasOwnProperty('default')?moment['default']:moment;function createCommonjsModule(fn,module){return module={exports:{}},fn(module,module.exports),module.exports}
function getCjsExportFromNamespace(n){return n&&n['default']||n}
var colorName={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};var conversions=createCommonjsModule(function(module){var reverseKeywords={};for(var key in colorName){if(colorName.hasOwnProperty(key)){reverseKeywords[colorName[key]]=key}}
var convert=module.exports={rgb:{channels:3,labels:'rgb'},hsl:{channels:3,labels:'hsl'},hsv:{channels:3,labels:'hsv'},hwb:{channels:3,labels:'hwb'},cmyk:{channels:4,labels:'cmyk'},xyz:{channels:3,labels:'xyz'},lab:{channels:3,labels:'lab'},lch:{channels:3,labels:'lch'},hex:{channels:1,labels:['hex']},keyword:{channels:1,labels:['keyword']},ansi16:{channels:1,labels:['ansi16']},ansi256:{channels:1,labels:['ansi256']},hcg:{channels:3,labels:['h','c','g']},apple:{channels:3,labels:['r16','g16','b16']},gray:{channels:1,labels:['gray']}};for(var model in convert){if(convert.hasOwnProperty(model)){if(!('channels' in convert[model])){throw new Error('missing channels property: '+model)}
if(!('labels' in convert[model])){throw new Error('missing channel labels property: '+model)}
if(convert[model].labels.length!==convert[model].channels){throw new Error('channel and label counts mismatch: '+model)}
var channels=convert[model].channels;var labels=convert[model].labels;delete convert[model].channels;delete convert[model].labels;Object.defineProperty(convert[model],'channels',{value:channels});Object.defineProperty(convert[model],'labels',{value:labels})}}
convert.rgb.hsl=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var min=Math.min(r,g,b);var max=Math.max(r,g,b);var delta=max-min;var h;var s;var l;if(max===min){h=0}else if(r===max){h=(g-b)/delta}else if(g===max){h=2+(b-r)/delta}else if(b===max){h=4+(r-g)/delta}
h=Math.min(h*60,360);if(h<0){h+=360}
l=(min+max)/2;if(max===min){s=0}else if(l<=0.5){s=delta/(max+min)}else{s=delta/(2-max-min)}
return[h,s*100,l*100]};convert.rgb.hsv=function(rgb){var rdif;var gdif;var bdif;var h;var s;var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var v=Math.max(r,g,b);var diff=v-Math.min(r,g,b);var diffc=function(c){return(v-c)/6/diff+1/2};if(diff===0){h=s=0}else{s=diff/v;rdif=diffc(r);gdif=diffc(g);bdif=diffc(b);if(r===v){h=bdif-gdif}else if(g===v){h=(1/3)+rdif-bdif}else if(b===v){h=(2/3)+gdif-rdif}
if(h<0){h+=1}else if(h>1){h-=1}}
return[h*360,s*100,v*100]};convert.rgb.hwb=function(rgb){var r=rgb[0];var g=rgb[1];var b=rgb[2];var h=convert.rgb.hsl(rgb)[0];var w=1/255*Math.min(r,Math.min(g,b));b=1-1/255*Math.max(r,Math.max(g,b));return[h,w*100,b*100]};convert.rgb.cmyk=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var c;var m;var y;var k;k=Math.min(1-r,1-g,1-b);c=(1-r-k)/(1-k)||0;m=(1-g-k)/(1-k)||0;y=(1-b-k)/(1-k)||0;return[c*100,m*100,y*100,k*100]};function comparativeDistance(x,y){return(Math.pow(x[0]-y[0],2)+Math.pow(x[1]-y[1],2)+Math.pow(x[2]-y[2],2))}
convert.rgb.keyword=function(rgb){var reversed=reverseKeywords[rgb];if(reversed){return reversed}
var currentClosestDistance=Infinity;var currentClosestKeyword;for(var keyword in colorName){if(colorName.hasOwnProperty(keyword)){var value=colorName[keyword];var distance=comparativeDistance(rgb,value);if(distance<currentClosestDistance){currentClosestDistance=distance;currentClosestKeyword=keyword}}}
return currentClosestKeyword};convert.keyword.rgb=function(keyword){return colorName[keyword]};convert.rgb.xyz=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;r=r>0.04045?Math.pow(((r+0.055)/1.055),2.4):(r/12.92);g=g>0.04045?Math.pow(((g+0.055)/1.055),2.4):(g/12.92);b=b>0.04045?Math.pow(((b+0.055)/1.055),2.4):(b/12.92);var x=(r*0.4124)+(g*0.3576)+(b*0.1805);var y=(r*0.2126)+(g*0.7152)+(b*0.0722);var z=(r*0.0193)+(g*0.1192)+(b*0.9505);return[x*100,y*100,z*100]};convert.rgb.lab=function(rgb){var xyz=convert.rgb.xyz(rgb);var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.hsl.rgb=function(hsl){var h=hsl[0]/360;var s=hsl[1]/100;var l=hsl[2]/100;var t1;var t2;var t3;var rgb;var val;if(s===0){val=l*255;return[val,val,val]}
if(l<0.5){t2=l*(1+s)}else{t2=l+s-l*s}
t1=2*l-t2;rgb=[0,0,0];for(var i=0;i<3;i++){t3=h+1/3*-(i-1);if(t3<0){t3++}
if(t3>1){t3--}
if(6*t3<1){val=t1+(t2-t1)*6*t3}else if(2*t3<1){val=t2}else if(3*t3<2){val=t1+(t2-t1)*(2/3-t3)*6}else{val=t1}
rgb[i]=val*255}
return rgb};convert.hsl.hsv=function(hsl){var h=hsl[0];var s=hsl[1]/100;var l=hsl[2]/100;var smin=s;var lmin=Math.max(l,0.01);var sv;var v;l*=2;s*=(l<=1)?l:2-l;smin*=lmin<=1?lmin:2-lmin;v=(l+s)/2;sv=l===0?(2*smin)/(lmin+smin):(2*s)/(l+s);return[h,sv*100,v*100]};convert.hsv.rgb=function(hsv){var h=hsv[0]/60;var s=hsv[1]/100;var v=hsv[2]/100;var hi=Math.floor(h)%6;var f=h-Math.floor(h);var p=255*v*(1-s);var q=255*v*(1-(s*f));var t=255*v*(1-(s*(1-f)));v*=255;switch(hi){case 0:return[v,t,p];case 1:return[q,v,p];case 2:return[p,v,t];case 3:return[p,q,v];case 4:return[t,p,v];case 5:return[v,p,q]}};convert.hsv.hsl=function(hsv){var h=hsv[0];var s=hsv[1]/100;var v=hsv[2]/100;var vmin=Math.max(v,0.01);var lmin;var sl;var l;l=(2-s)*v;lmin=(2-s)*vmin;sl=s*vmin;sl/=(lmin<=1)?lmin:2-lmin;sl=sl||0;l/=2;return[h,sl*100,l*100]};convert.hwb.rgb=function(hwb){var h=hwb[0]/360;var wh=hwb[1]/100;var bl=hwb[2]/100;var ratio=wh+bl;var i;var v;var f;var n;if(ratio>1){wh/=ratio;bl/=ratio}
i=Math.floor(6*h);v=1-bl;f=6*h-i;if((i&0x01)!==0){f=1-f}
n=wh+f*(v-wh);var r;var g;var b;switch(i){default:case 6:case 0:r=v;g=n;b=wh;break;case 1:r=n;g=v;b=wh;break;case 2:r=wh;g=v;b=n;break;case 3:r=wh;g=n;b=v;break;case 4:r=n;g=wh;b=v;break;case 5:r=v;g=wh;b=n;break}
return[r*255,g*255,b*255]};convert.cmyk.rgb=function(cmyk){var c=cmyk[0]/100;var m=cmyk[1]/100;var y=cmyk[2]/100;var k=cmyk[3]/100;var r;var g;var b;r=1-Math.min(1,c*(1-k)+k);g=1-Math.min(1,m*(1-k)+k);b=1-Math.min(1,y*(1-k)+k);return[r*255,g*255,b*255]};convert.xyz.rgb=function(xyz){var x=xyz[0]/100;var y=xyz[1]/100;var z=xyz[2]/100;var r;var g;var b;r=(x*3.2406)+(y*-1.5372)+(z*-0.4986);g=(x*-0.9689)+(y*1.8758)+(z*0.0415);b=(x*0.0557)+(y*-0.2040)+(z*1.0570);r=r>0.0031308?((1.055*Math.pow(r,1.0/2.4))-0.055):r*12.92;g=g>0.0031308?((1.055*Math.pow(g,1.0/2.4))-0.055):g*12.92;b=b>0.0031308?((1.055*Math.pow(b,1.0/2.4))-0.055):b*12.92;r=Math.min(Math.max(0,r),1);g=Math.min(Math.max(0,g),1);b=Math.min(Math.max(0,b),1);return[r*255,g*255,b*255]};convert.xyz.lab=function(xyz){var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.lab.xyz=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var x;var y;var z;y=(l+16)/116;x=a/500+y;z=y-b/200;var y2=Math.pow(y,3);var x2=Math.pow(x,3);var z2=Math.pow(z,3);y=y2>0.008856?y2:(y-16/116)/7.787;x=x2>0.008856?x2:(x-16/116)/7.787;z=z2>0.008856?z2:(z-16/116)/7.787;x*=95.047;y*=100;z*=108.883;return[x,y,z]};convert.lab.lch=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var hr;var h;var c;hr=Math.atan2(b,a);h=hr*360/2/Math.PI;if(h<0){h+=360}
c=Math.sqrt(a*a+b*b);return[l,c,h]};convert.lch.lab=function(lch){var l=lch[0];var c=lch[1];var h=lch[2];var a;var b;var hr;hr=h/360*2*Math.PI;a=c*Math.cos(hr);b=c*Math.sin(hr);return[l,a,b]};convert.rgb.ansi16=function(args){var r=args[0];var g=args[1];var b=args[2];var value=1 in arguments?arguments[1]:convert.rgb.hsv(args)[2];value=Math.round(value/50);if(value===0){return 30}
var ansi=30+((Math.round(b/255)<<2)|(Math.round(g/255)<<1)|Math.round(r/255));if(value===2){ansi+=60}
return ansi};convert.hsv.ansi16=function(args){return convert.rgb.ansi16(convert.hsv.rgb(args),args[2])};convert.rgb.ansi256=function(args){var r=args[0];var g=args[1];var b=args[2];if(r===g&&g===b){if(r<8){return 16}
if(r>248){return 231}
return Math.round(((r-8)/247)*24)+232}
var ansi=16+(36*Math.round(r/255*5))+(6*Math.round(g/255*5))+Math.round(b/255*5);return ansi};convert.ansi16.rgb=function(args){var color=args%10;if(color===0||color===7){if(args>50){color+=3.5}
color=color/10.5*255;return[color,color,color]}
var mult=(~~(args>50)+1)*0.5;var r=((color&1)*mult)*255;var g=(((color>>1)&1)*mult)*255;var b=(((color>>2)&1)*mult)*255;return[r,g,b]};convert.ansi256.rgb=function(args){if(args>=232){var c=(args-232)*10+8;return[c,c,c]}
args-=16;var rem;var r=Math.floor(args/36)/5*255;var g=Math.floor((rem=args%36)/6)/5*255;var b=(rem%6)/5*255;return[r,g,b]};convert.rgb.hex=function(args){var integer=((Math.round(args[0])&0xFF)<<16)+((Math.round(args[1])&0xFF)<<8)+(Math.round(args[2])&0xFF);var string=integer.toString(16).toUpperCase();return'000000'.substring(string.length)+string};convert.hex.rgb=function(args){var match=args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!match){return[0,0,0]}
var colorString=match[0];if(match[0].length===3){colorString=colorString.split('').map(function(char){return char+char}).join('')}
var integer=parseInt(colorString,16);var r=(integer>>16)&0xFF;var g=(integer>>8)&0xFF;var b=integer&0xFF;return[r,g,b]};convert.rgb.hcg=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var max=Math.max(Math.max(r,g),b);var min=Math.min(Math.min(r,g),b);var chroma=(max-min);var grayscale;var hue;if(chroma<1){grayscale=min/(1-chroma)}else{grayscale=0}
if(chroma<=0){hue=0}else if(max===r){hue=((g-b)/chroma)%6}else if(max===g){hue=2+(b-r)/chroma}else{hue=4+(r-g)/chroma+4}
hue/=6;hue%=1;return[hue*360,chroma*100,grayscale*100]};convert.hsl.hcg=function(hsl){var s=hsl[1]/100;var l=hsl[2]/100;var c=1;var f=0;if(l<0.5){c=2.0*s*l}else{c=2.0*s*(1.0-l)}
if(c<1.0){f=(l-0.5*c)/(1.0-c)}
return[hsl[0],c*100,f*100]};convert.hsv.hcg=function(hsv){var s=hsv[1]/100;var v=hsv[2]/100;var c=s*v;var f=0;if(c<1.0){f=(v-c)/(1-c)}
return[hsv[0],c*100,f*100]};convert.hcg.rgb=function(hcg){var h=hcg[0]/360;var c=hcg[1]/100;var g=hcg[2]/100;if(c===0.0){return[g*255,g*255,g*255]}
var pure=[0,0,0];var hi=(h%1)*6;var v=hi%1;var w=1-v;var mg=0;switch(Math.floor(hi)){case 0:pure[0]=1;pure[1]=v;pure[2]=0;break;case 1:pure[0]=w;pure[1]=1;pure[2]=0;break;case 2:pure[0]=0;pure[1]=1;pure[2]=v;break;case 3:pure[0]=0;pure[1]=w;pure[2]=1;break;case 4:pure[0]=v;pure[1]=0;pure[2]=1;break;default:pure[0]=1;pure[1]=0;pure[2]=w}
mg=(1.0-c)*g;return[(c*pure[0]+mg)*255,(c*pure[1]+mg)*255,(c*pure[2]+mg)*255]};convert.hcg.hsv=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1.0-c);var f=0;if(v>0.0){f=c/v}
return[hcg[0],f*100,v*100]};convert.hcg.hsl=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var l=g*(1.0-c)+0.5*c;var s=0;if(l>0.0&&l<0.5){s=c/(2*l)}else if(l>=0.5&&l<1.0){s=c/(2*(1-l))}
return[hcg[0],s*100,l*100]};convert.hcg.hwb=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1.0-c);return[hcg[0],(v-c)*100,(1-v)*100]};convert.hwb.hcg=function(hwb){var w=hwb[1]/100;var b=hwb[2]/100;var v=1-b;var c=v-w;var g=0;if(c<1){g=(v-c)/(1-c)}
return[hwb[0],c*100,g*100]};convert.apple.rgb=function(apple){return[(apple[0]/65535)*255,(apple[1]/65535)*255,(apple[2]/65535)*255]};convert.rgb.apple=function(rgb){return[(rgb[0]/255)*65535,(rgb[1]/255)*65535,(rgb[2]/255)*65535]};convert.gray.rgb=function(args){return[args[0]/100*255,args[0]/100*255,args[0]/100*255]};convert.gray.hsl=convert.gray.hsv=function(args){return[0,0,args[0]]};convert.gray.hwb=function(gray){return[0,100,gray[0]]};convert.gray.cmyk=function(gray){return[0,0,0,gray[0]]};convert.gray.lab=function(gray){return[gray[0],0,0]};convert.gray.hex=function(gray){var val=Math.round(gray[0]/100*255)&0xFF;var integer=(val<<16)+(val<<8)+val;var string=integer.toString(16).toUpperCase();return'000000'.substring(string.length)+string};convert.rgb.gray=function(rgb){var val=(rgb[0]+rgb[1]+rgb[2])/3;return[val/255*100]}});var conversions_1=conversions.rgb;var conversions_2=conversions.hsl;var conversions_3=conversions.hsv;var conversions_4=conversions.hwb;var conversions_5=conversions.cmyk;var conversions_6=conversions.xyz;var conversions_7=conversions.lab;var conversions_8=conversions.lch;var conversions_9=conversions.hex;var conversions_10=conversions.keyword;var conversions_11=conversions.ansi16;var conversions_12=conversions.ansi256;var conversions_13=conversions.hcg;var conversions_14=conversions.apple;var conversions_15=conversions.gray;function buildGraph(){var graph={};var models=Object.keys(conversions);for(var len=models.length,i=0;i<len;i++){graph[models[i]]={distance:-1,parent:null}}
return graph}
function deriveBFS(fromModel){var graph=buildGraph();var queue=[fromModel];graph[fromModel].distance=0;while(queue.length){var current=queue.pop();var adjacents=Object.keys(conversions[current]);for(var len=adjacents.length,i=0;i<len;i++){var adjacent=adjacents[i];var node=graph[adjacent];if(node.distance===-1){node.distance=graph[current].distance+1;node.parent=current;queue.unshift(adjacent)}}}
return graph}
function link(from,to){return function(args){return to(from(args))}}
function wrapConversion(toModel,graph){var path=[graph[toModel].parent,toModel];var fn=conversions[graph[toModel].parent][toModel];var cur=graph[toModel].parent;while(graph[cur].parent){path.unshift(graph[cur].parent);fn=link(conversions[graph[cur].parent][cur],fn);cur=graph[cur].parent}
fn.conversion=path;return fn}
var route=function(fromModel){var graph=deriveBFS(fromModel);var conversion={};var models=Object.keys(graph);for(var len=models.length,i=0;i<len;i++){var toModel=models[i];var node=graph[toModel];if(node.parent===null){continue}
conversion[toModel]=wrapConversion(toModel,graph)}
return conversion};var convert={};var models=Object.keys(conversions);function wrapRaw(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}
if(arguments.length>1){args=Array.prototype.slice.call(arguments)}
return fn(args)};if('conversion' in fn){wrappedFn.conversion=fn.conversion}
return wrappedFn}
function wrapRounded(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}
if(arguments.length>1){args=Array.prototype.slice.call(arguments)}
var result=fn(args);if(typeof result==='object'){for(var len=result.length,i=0;i<len;i++){result[i]=Math.round(result[i])}}
return result};if('conversion' in fn){wrappedFn.conversion=fn.conversion}
return wrappedFn}
models.forEach(function(fromModel){convert[fromModel]={};Object.defineProperty(convert[fromModel],'channels',{value:conversions[fromModel].channels});Object.defineProperty(convert[fromModel],'labels',{value:conversions[fromModel].labels});var routes=route(fromModel);var routeModels=Object.keys(routes);routeModels.forEach(function(toModel){var fn=routes[toModel];convert[fromModel][toModel]=wrapRounded(fn);convert[fromModel][toModel].raw=wrapRaw(fn)})});var colorConvert=convert;var colorName$1={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};var colorString={getRgba:getRgba,getHsla:getHsla,getRgb:getRgb,getHsl:getHsl,getHwb:getHwb,getAlpha:getAlpha,hexString:hexString,rgbString:rgbString,rgbaString:rgbaString,percentString:percentString,percentaString:percentaString,hslString:hslString,hslaString:hslaString,hwbString:hwbString,keyword:keyword};function getRgba(string){if(!string){return}
var abbr=/^#([a-fA-F0-9]{3,4})$/i,hex=/^#([a-fA-F0-9]{6}([a-fA-F0-9]{2})?)$/i,rgba=/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,per=/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,keyword=/(\w+)/;var rgb=[0,0,0],a=1,match=string.match(abbr),hexAlpha="";if(match){match=match[1];hexAlpha=match[3];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i]+match[i],16)}
if(hexAlpha){a=Math.round((parseInt(hexAlpha+hexAlpha,16)/255)*100)/100}}else if(match=string.match(hex)){hexAlpha=match[2];match=match[1];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match.slice(i*2,i*2+2),16)}
if(hexAlpha){a=Math.round((parseInt(hexAlpha,16)/255)*100)/100}}else if(match=string.match(rgba)){for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i+1])}
a=parseFloat(match[4])}else if(match=string.match(per)){for(var i=0;i<rgb.length;i++){rgb[i]=Math.round(parseFloat(match[i+1])*2.55)}
a=parseFloat(match[4])}else if(match=string.match(keyword)){if(match[1]=="transparent"){return[0,0,0,0]}
rgb=colorName$1[match[1]];if(!rgb){return}}
for(var i=0;i<rgb.length;i++){rgb[i]=scale(rgb[i],0,255)}
if(!a&&a!=0){a=1}else{a=scale(a,0,1)}
rgb[3]=a;return rgb}
function getHsla(string){if(!string){return}
var hsl=/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hsl);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),s=scale(parseFloat(match[2]),0,100),l=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,s,l,a]}}
function getHwb(string){if(!string){return}
var hwb=/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hwb);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),w=scale(parseFloat(match[2]),0,100),b=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,w,b,a]}}
function getRgb(string){var rgba=getRgba(string);return rgba&&rgba.slice(0,3)}
function getHsl(string){var hsla=getHsla(string);return hsla&&hsla.slice(0,3)}
function getAlpha(string){var vals=getRgba(string);if(vals){return vals[3]}else if(vals=getHsla(string)){return vals[3]}else if(vals=getHwb(string)){return vals[3]}}
function hexString(rgba,a){var a=(a!==undefined&&rgba.length===3)?a:rgba[3];return"#"+hexDouble(rgba[0])+hexDouble(rgba[1])+hexDouble(rgba[2])+((a>=0&&a<1)?hexDouble(Math.round(a*255)):"")}
function rgbString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return rgbaString(rgba,alpha)}
return"rgb("+rgba[0]+", "+rgba[1]+", "+rgba[2]+")"}
function rgbaString(rgba,alpha){if(alpha===undefined){alpha=(rgba[3]!==undefined?rgba[3]:1)}
return"rgba("+rgba[0]+", "+rgba[1]+", "+rgba[2]+", "+alpha+")"}
function percentString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return percentaString(rgba,alpha)}
var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgb("+r+"%, "+g+"%, "+b+"%)"}
function percentaString(rgba,alpha){var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgba("+r+"%, "+g+"%, "+b+"%, "+(alpha||rgba[3]||1)+")"}
function hslString(hsla,alpha){if(alpha<1||(hsla[3]&&hsla[3]<1)){return hslaString(hsla,alpha)}
return"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)"}
function hslaString(hsla,alpha){if(alpha===undefined){alpha=(hsla[3]!==undefined?hsla[3]:1)}
return"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "+alpha+")"}
function hwbString(hwb,alpha){if(alpha===undefined){alpha=(hwb[3]!==undefined?hwb[3]:1)}
return"hwb("+hwb[0]+", "+hwb[1]+"%, "+hwb[2]+"%"+(alpha!==undefined&&alpha!==1?", "+alpha:"")+")"}
function keyword(rgb){return reverseNames[rgb.slice(0,3)]}
function scale(num,min,max){return Math.min(Math.max(min,num),max)}
function hexDouble(num){var str=num.toString(16).toUpperCase();return(str.length<2)?"0"+str:str}
var reverseNames={};for(var name in colorName$1){reverseNames[colorName$1[name]]=name}
var Color=function(obj){if(obj instanceof Color){return obj}
if(!(this instanceof Color)){return new Color(obj)}
this.valid=!1;this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1};var vals;if(typeof obj==='string'){vals=colorString.getRgba(obj);if(vals){this.setValues('rgb',vals)}else if(vals=colorString.getHsla(obj)){this.setValues('hsl',vals)}else if(vals=colorString.getHwb(obj)){this.setValues('hwb',vals)}}else if(typeof obj==='object'){vals=obj;if(vals.r!==undefined||vals.red!==undefined){this.setValues('rgb',vals)}else if(vals.l!==undefined||vals.lightness!==undefined){this.setValues('hsl',vals)}else if(vals.v!==undefined||vals.value!==undefined){this.setValues('hsv',vals)}else if(vals.w!==undefined||vals.whiteness!==undefined){this.setValues('hwb',vals)}else if(vals.c!==undefined||vals.cyan!==undefined){this.setValues('cmyk',vals)}}};Color.prototype={isValid:function(){return this.valid},rgb:function(){return this.setSpace('rgb',arguments)},hsl:function(){return this.setSpace('hsl',arguments)},hsv:function(){return this.setSpace('hsv',arguments)},hwb:function(){return this.setSpace('hwb',arguments)},cmyk:function(){return this.setSpace('cmyk',arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){var values=this.values;if(values.alpha!==1){return values.hwb.concat([values.alpha])}
return values.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var values=this.values;return values.rgb.concat([values.alpha])},hslaArray:function(){var values=this.values;return values.hsl.concat([values.alpha])},alpha:function(val){if(val===undefined){return this.values.alpha}
this.setValues('alpha',val);return this},red:function(val){return this.setChannel('rgb',0,val)},green:function(val){return this.setChannel('rgb',1,val)},blue:function(val){return this.setChannel('rgb',2,val)},hue:function(val){if(val){val%=360;val=val<0?360+val:val}
return this.setChannel('hsl',0,val)},saturation:function(val){return this.setChannel('hsl',1,val)},lightness:function(val){return this.setChannel('hsl',2,val)},saturationv:function(val){return this.setChannel('hsv',1,val)},whiteness:function(val){return this.setChannel('hwb',1,val)},blackness:function(val){return this.setChannel('hwb',2,val)},value:function(val){return this.setChannel('hsv',2,val)},cyan:function(val){return this.setChannel('cmyk',0,val)},magenta:function(val){return this.setChannel('cmyk',1,val)},yellow:function(val){return this.setChannel('cmyk',2,val)},black:function(val){return this.setChannel('cmyk',3,val)},hexString:function(){return colorString.hexString(this.values.rgb)},rgbString:function(){return colorString.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return colorString.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return colorString.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return colorString.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return colorString.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return colorString.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return colorString.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){var rgb=this.values.rgb;return(rgb[0]<<16)|(rgb[1]<<8)|rgb[2]},luminosity:function(){var rgb=this.values.rgb;var lum=[];for(var i=0;i<rgb.length;i++){var chan=rgb[i]/255;lum[i]=(chan<=0.03928)?chan/12.92:Math.pow(((chan+0.055)/1.055),2.4)}
return 0.2126*lum[0]+0.7152*lum[1]+0.0722*lum[2]},contrast:function(color2){var lum1=this.luminosity();var lum2=color2.luminosity();if(lum1>lum2){return(lum1+0.05)/(lum2+0.05)}
return(lum2+0.05)/(lum1+0.05)},level:function(color2){var contrastRatio=this.contrast(color2);if(contrastRatio>=7.1){return'AAA'}
return(contrastRatio>=4.5)?'AA':''},dark:function(){var rgb=this.values.rgb;var yiq=(rgb[0]*299+rgb[1]*587+rgb[2]*114)/1000;return yiq<128},light:function(){return!this.dark()},negate:function(){var rgb=[];for(var i=0;i<3;i++){rgb[i]=255-this.values.rgb[i]}
this.setValues('rgb',rgb);return this},lighten:function(ratio){var hsl=this.values.hsl;hsl[2]+=hsl[2]*ratio;this.setValues('hsl',hsl);return this},darken:function(ratio){var hsl=this.values.hsl;hsl[2]-=hsl[2]*ratio;this.setValues('hsl',hsl);return this},saturate:function(ratio){var hsl=this.values.hsl;hsl[1]+=hsl[1]*ratio;this.setValues('hsl',hsl);return this},desaturate:function(ratio){var hsl=this.values.hsl;hsl[1]-=hsl[1]*ratio;this.setValues('hsl',hsl);return this},whiten:function(ratio){var hwb=this.values.hwb;hwb[1]+=hwb[1]*ratio;this.setValues('hwb',hwb);return this},blacken:function(ratio){var hwb=this.values.hwb;hwb[2]+=hwb[2]*ratio;this.setValues('hwb',hwb);return this},greyscale:function(){var rgb=this.values.rgb;var val=rgb[0]*0.3+rgb[1]*0.59+rgb[2]*0.11;this.setValues('rgb',[val,val,val]);return this},clearer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha-(alpha*ratio));return this},opaquer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha+(alpha*ratio));return this},rotate:function(degrees){var hsl=this.values.hsl;var hue=(hsl[0]+degrees)%360;hsl[0]=hue<0?360+hue:hue;this.setValues('hsl',hsl);return this},mix:function(mixinColor,weight){var color1=this;var color2=mixinColor;var p=weight===undefined?0.5:weight;var w=2*p-1;var a=color1.alpha()-color2.alpha();var w1=(((w*a===-1)?w:(w+a)/(1+w*a))+1)/2.0;var w2=1-w1;return this.rgb(w1*color1.red()+w2*color2.red(),w1*color1.green()+w2*color2.green(),w1*color1.blue()+w2*color2.blue()).alpha(color1.alpha()*p+color2.alpha()*(1-p))},toJSON:function(){return this.rgb()},clone:function(){var result=new Color();var source=this.values;var target=result.values;var value,type;for(var prop in source){if(source.hasOwnProperty(prop)){value=source[prop];type=({}).toString.call(value);if(type==='[object Array]'){target[prop]=value.slice(0)}else if(type==='[object Number]'){target[prop]=value}else{console.error('unexpected color value:',value)}}}
return result}};Color.prototype.spaces={rgb:['red','green','blue'],hsl:['hue','saturation','lightness'],hsv:['hue','saturation','value'],hwb:['hue','whiteness','blackness'],cmyk:['cyan','magenta','yellow','black']};Color.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]};Color.prototype.getValues=function(space){var values=this.values;var vals={};for(var i=0;i<space.length;i++){vals[space.charAt(i)]=values[space][i]}
if(values.alpha!==1){vals.a=values.alpha}
return vals};Color.prototype.setValues=function(space,vals){var values=this.values;var spaces=this.spaces;var maxes=this.maxes;var alpha=1;var i;this.valid=!0;if(space==='alpha'){alpha=vals}else if(vals.length){values[space]=vals.slice(0,space.length);alpha=vals[space.length]}else if(vals[space.charAt(0)]!==undefined){for(i=0;i<space.length;i++){values[space][i]=vals[space.charAt(i)]}
alpha=vals.a}else if(vals[spaces[space][0]]!==undefined){var chans=spaces[space];for(i=0;i<space.length;i++){values[space][i]=vals[chans[i]]}
alpha=vals.alpha}
values.alpha=Math.max(0,Math.min(1,(alpha===undefined?values.alpha:alpha)));if(space==='alpha'){return!1}
var capped;for(i=0;i<space.length;i++){capped=Math.max(0,Math.min(maxes[space][i],values[space][i]));values[space][i]=Math.round(capped)}
for(var sname in spaces){if(sname!==space){values[sname]=colorConvert[space][sname](values[space])}}
return!0};Color.prototype.setSpace=function(space,args){var vals=args[0];if(vals===undefined){return this.getValues(space)}
if(typeof vals==='number'){vals=Array.prototype.slice.call(args)}
this.setValues(space,vals);return this};Color.prototype.setChannel=function(space,index,val){var svalues=this.values[space];if(val===undefined){return svalues[index]}else if(val===svalues[index]){return this}
svalues[index]=val;this.setValues(space,svalues);return this};if(typeof window!=='undefined'){window.Color=Color}
var chartjsColor=Color;function isValidKey(key){return['__proto__','prototype','constructor'].indexOf(key)===-1}
var helpers={noop:function(){},uid:(function(){var id=0;return function(){return id++}}()),isNullOrUndef:function(value){return value===null||typeof value==='undefined'},isArray:function(value){if(Array.isArray&&Array.isArray(value)){return!0}
var type=Object.prototype.toString.call(value);if(type.substr(0,7)==='[object'&&type.substr(-6)==='Array]'){return!0}
return!1},isObject:function(value){return value!==null&&Object.prototype.toString.call(value)==='[object Object]'},isFinite:function(value){return(typeof value==='number'||value instanceof Number)&&isFinite(value)},valueOrDefault:function(value,defaultValue){return typeof value==='undefined'?defaultValue:value},valueAtIndexOrDefault:function(value,index,defaultValue){return helpers.valueOrDefault(helpers.isArray(value)?value[index]:value,defaultValue)},callback:function(fn,args,thisArg){if(fn&&typeof fn.call==='function'){return fn.apply(thisArg,args)}},each:function(loopable,fn,thisArg,reverse){var i,len,keys;if(helpers.isArray(loopable)){len=loopable.length;if(reverse){for(i=len-1;i>=0;i--){fn.call(thisArg,loopable[i],i)}}else{for(i=0;i<len;i++){fn.call(thisArg,loopable[i],i)}}}else if(helpers.isObject(loopable)){keys=Object.keys(loopable);len=keys.length;for(i=0;i<len;i++){fn.call(thisArg,loopable[keys[i]],keys[i])}}},arrayEquals:function(a0,a1){var i,ilen,v0,v1;if(!a0||!a1||a0.length!==a1.length){return!1}
for(i=0,ilen=a0.length;i<ilen;++i){v0=a0[i];v1=a1[i];if(v0 instanceof Array&&v1 instanceof Array){if(!helpers.arrayEquals(v0,v1)){return!1}}else if(v0!==v1){return!1}}
return!0},clone:function(source){if(helpers.isArray(source)){return source.map(helpers.clone)}
if(helpers.isObject(source)){var target=Object.create(source);var keys=Object.keys(source);var klen=keys.length;var k=0;for(;k<klen;++k){target[keys[k]]=helpers.clone(source[keys[k]])}
return target}
return source},_merger:function(key,target,source,options){if(!isValidKey(key)){return}
var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.merge(tval,sval,options)}else{target[key]=helpers.clone(sval)}},_mergerIf:function(key,target,source){if(!isValidKey(key)){return}
var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.mergeIf(tval,sval)}else if(!target.hasOwnProperty(key)){target[key]=helpers.clone(sval)}},merge:function(target,source,options){var sources=helpers.isArray(source)?source:[source];var ilen=sources.length;var merge,i,keys,klen,k;if(!helpers.isObject(target)){return target}
options=options||{};merge=options.merger||helpers._merger;for(i=0;i<ilen;++i){source=sources[i];if(!helpers.isObject(source)){continue}
keys=Object.keys(source);for(k=0,klen=keys.length;k<klen;++k){merge(keys[k],target,source,options)}}
return target},mergeIf:function(target,source){return helpers.merge(target,source,{merger:helpers._mergerIf})},extend:Object.assign||function(target){return helpers.merge(target,[].slice.call(arguments,1),{merger:function(key,dst,src){dst[key]=src[key]}})},inherits:function(extensions){var me=this;var ChartElement=(extensions&&extensions.hasOwnProperty('constructor'))?extensions.constructor:function(){return me.apply(this,arguments)};var Surrogate=function(){this.constructor=ChartElement};Surrogate.prototype=me.prototype;ChartElement.prototype=new Surrogate();ChartElement.extend=helpers.inherits;if(extensions){helpers.extend(ChartElement.prototype,extensions)}
ChartElement.__super__=me.prototype;return ChartElement},_deprecated:function(scope,value,previous,current){if(value!==undefined){console.warn(scope+': "'+previous+'" is deprecated. Please use "'+current+'" instead')}}};var helpers_core=helpers;helpers.callCallback=helpers.callback;helpers.indexOf=function(array,item,fromIndex){return Array.prototype.indexOf.call(array,item,fromIndex)};helpers.getValueOrDefault=helpers.valueOrDefault;helpers.getValueAtIndexOrDefault=helpers.valueAtIndexOrDefault;var effects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-t*(t-2)},easeInOutQuad:function(t){if((t/=0.5)<1){return 0.5*t*t}
return-0.5*((--t)*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return(t=t-1)*t*t+1},easeInOutCubic:function(t){if((t/=0.5)<1){return 0.5*t*t*t}
return 0.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-((t=t-1)*t*t*t-1)},easeInOutQuart:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t}
return-0.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return(t=t-1)*t*t*t*t+1},easeInOutQuint:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t*t}
return 0.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-Math.cos(t*(Math.PI/2))+1},easeOutSine:function(t){return Math.sin(t*(Math.PI/2))},easeInOutSine:function(t){return-0.5*(Math.cos(Math.PI*t)-1)},easeInExpo:function(t){return(t===0)?0:Math.pow(2,10*(t-1))},easeOutExpo:function(t){return(t===1)?1:-Math.pow(2,-10*t)+1},easeInOutExpo:function(t){if(t===0){return 0}
if(t===1){return 1}
if((t/=0.5)<1){return 0.5*Math.pow(2,10*(t-1))}
return 0.5*(-Math.pow(2,-10*--t)+2)},easeInCirc:function(t){if(t>=1){return t}
return-(Math.sqrt(1-t*t)-1)},easeOutCirc:function(t){return Math.sqrt(1-(t=t-1)*t)},easeInOutCirc:function(t){if((t/=0.5)<1){return-0.5*(Math.sqrt(1-t*t)-1)}
return 0.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0}
if(t===1){return 1}
if(!p){p=0.3}
if(a<1){a=1;s=p/4}else{s=p/(2*Math.PI)*Math.asin(1/a)}
return-(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p))},easeOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0}
if(t===1){return 1}
if(!p){p=0.3}
if(a<1){a=1;s=p/4}else{s=p/(2*Math.PI)*Math.asin(1/a)}
return a*Math.pow(2,-10*t)*Math.sin((t-s)*(2*Math.PI)/p)+1},easeInOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0}
if((t/=0.5)===2){return 1}
if(!p){p=0.45}
if(a<1){a=1;s=p/4}else{s=p/(2*Math.PI)*Math.asin(1/a)}
if(t<1){return-0.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p))}
return a*Math.pow(2,-10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p)*0.5+1},easeInBack:function(t){var s=1.70158;return t*t*((s+1)*t-s)},easeOutBack:function(t){var s=1.70158;return(t=t-1)*t*((s+1)*t+s)+1},easeInOutBack:function(t){var s=1.70158;if((t/=0.5)<1){return 0.5*(t*t*(((s*=(1.525))+1)*t-s))}
return 0.5*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)},easeInBounce:function(t){return 1-effects.easeOutBounce(1-t)},easeOutBounce:function(t){if(t<(1/2.75)){return 7.5625*t*t}
if(t<(2/2.75)){return 7.5625*(t-=(1.5/2.75))*t+0.75}
if(t<(2.5/2.75)){return 7.5625*(t-=(2.25/2.75))*t+0.9375}
return 7.5625*(t-=(2.625/2.75))*t+0.984375},easeInOutBounce:function(t){if(t<0.5){return effects.easeInBounce(t*2)*0.5}
return effects.easeOutBounce(t*2-1)*0.5+0.5}};var helpers_easing={effects:effects};helpers_core.easingEffects=effects;var PI=Math.PI;var RAD_PER_DEG=PI/180;var DOUBLE_PI=PI*2;var HALF_PI=PI/2;var QUARTER_PI=PI/4;var TWO_THIRDS_PI=PI*2/3;var exports$1={clear:function(chart){chart.ctx.clearRect(0,0,chart.width,chart.height)},roundedRect:function(ctx,x,y,width,height,radius){if(radius){var r=Math.min(radius,height/2,width/2);var left=x+r;var top=y+r;var right=x+width-r;var bottom=y+height-r;ctx.moveTo(x,top);if(left<right&&top<bottom){ctx.arc(left,top,r,-PI,-HALF_PI);ctx.arc(right,top,r,-HALF_PI,0);ctx.arc(right,bottom,r,0,HALF_PI);ctx.arc(left,bottom,r,HALF_PI,PI)}else if(left<right){ctx.moveTo(left,y);ctx.arc(right,top,r,-HALF_PI,HALF_PI);ctx.arc(left,top,r,HALF_PI,PI+HALF_PI)}else if(top<bottom){ctx.arc(left,top,r,-PI,0);ctx.arc(left,bottom,r,0,PI)}else{ctx.arc(left,top,r,-PI,PI)}
ctx.closePath();ctx.moveTo(x,y)}else{ctx.rect(x,y,width,height)}},drawPoint:function(ctx,style,radius,x,y,rotation){var type,xOffset,yOffset,size,cornerRadius;var rad=(rotation||0)*RAD_PER_DEG;if(style&&typeof style==='object'){type=style.toString();if(type==='[object HTMLImageElement]'||type==='[object HTMLCanvasElement]'){ctx.save();ctx.translate(x,y);ctx.rotate(rad);ctx.drawImage(style,-style.width/2,-style.height/2,style.width,style.height);ctx.restore();return}}
if(isNaN(radius)||radius<=0){return}
ctx.beginPath();switch(style){default:ctx.arc(x,y,radius,0,DOUBLE_PI);ctx.closePath();break;case 'triangle':ctx.moveTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);rad+=TWO_THIRDS_PI;ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);rad+=TWO_THIRDS_PI;ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);ctx.closePath();break;case 'rectRounded':cornerRadius=radius*0.516;size=radius-cornerRadius;xOffset=Math.cos(rad+QUARTER_PI)*size;yOffset=Math.sin(rad+QUARTER_PI)*size;ctx.arc(x-xOffset,y-yOffset,cornerRadius,rad-PI,rad-HALF_PI);ctx.arc(x+yOffset,y-xOffset,cornerRadius,rad-HALF_PI,rad);ctx.arc(x+xOffset,y+yOffset,cornerRadius,rad,rad+HALF_PI);ctx.arc(x-yOffset,y+xOffset,cornerRadius,rad+HALF_PI,rad+PI);ctx.closePath();break;case 'rect':if(!rotation){size=Math.SQRT1_2*radius;ctx.rect(x-size,y-size,2*size,2*size);break}
rad+=QUARTER_PI;case 'rectRot':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+yOffset,y-xOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.lineTo(x-yOffset,y+xOffset);ctx.closePath();break;case 'crossRot':rad+=QUARTER_PI;case 'cross':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);break;case 'star':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);rad+=QUARTER_PI;xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);break;case 'line':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);break;case 'dash':ctx.moveTo(x,y);ctx.lineTo(x+Math.cos(rad)*radius,y+Math.sin(rad)*radius);break}
ctx.fill();ctx.stroke()},_isPointInArea:function(point,area){var epsilon=1e-6;return point.x>area.left-epsilon&&point.x<area.right+epsilon&&point.y>area.top-epsilon&&point.y<area.bottom+epsilon},clipArea:function(ctx,area){ctx.save();ctx.beginPath();ctx.rect(area.left,area.top,area.right-area.left,area.bottom-area.top);ctx.clip()},unclipArea:function(ctx){ctx.restore()},lineTo:function(ctx,previous,target,flip){var stepped=target.steppedLine;if(stepped){if(stepped==='middle'){var midpoint=(previous.x+target.x)/2.0;ctx.lineTo(midpoint,flip?target.y:previous.y);ctx.lineTo(midpoint,flip?previous.y:target.y)}else if((stepped==='after'&&!flip)||(stepped!=='after'&&flip)){ctx.lineTo(previous.x,target.y)}else{ctx.lineTo(target.x,previous.y)}
ctx.lineTo(target.x,target.y);return}
if(!target.tension){ctx.lineTo(target.x,target.y);return}
ctx.bezierCurveTo(flip?previous.controlPointPreviousX:previous.controlPointNextX,flip?previous.controlPointPreviousY:previous.controlPointNextY,flip?target.controlPointNextX:target.controlPointPreviousX,flip?target.controlPointNextY:target.controlPointPreviousY,target.x,target.y)}};var helpers_canvas=exports$1;helpers_core.clear=exports$1.clear;helpers_core.drawRoundedRectangle=function(ctx){ctx.beginPath();exports$1.roundedRect.apply(exports$1,arguments)};var defaults={_set:function(scope,values){return helpers_core.merge(this[scope]||(this[scope]={}),values)}};defaults._set('global',{defaultColor:'rgba(0,0,0,0.1)',defaultFontColor:'#666',defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:'normal',defaultLineHeight:1.2,showLines:!0});var core_defaults=defaults;var valueOrDefault=helpers_core.valueOrDefault;function toFontString(font){if(!font||helpers_core.isNullOrUndef(font.size)||helpers_core.isNullOrUndef(font.family)){return null}
return(font.style?font.style+' ':'')+(font.weight?font.weight+' ':'')+font.size+'px '+font.family}
var helpers_options={toLineHeight:function(value,size){var matches=(''+value).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);if(!matches||matches[1]==='normal'){return size*1.2}
value=+matches[2];switch(matches[3]){case 'px':return value;case '%':value/=100;break}
return size*value},toPadding:function(value){var t,r,b,l;if(helpers_core.isObject(value)){t=+value.top||0;r=+value.right||0;b=+value.bottom||0;l=+value.left||0}else{t=r=b=l=+value||0}
return{top:t,right:r,bottom:b,left:l,height:t+b,width:l+r}},_parseFont:function(options){var globalDefaults=core_defaults.global;var size=valueOrDefault(options.fontSize,globalDefaults.defaultFontSize);var font={family:valueOrDefault(options.fontFamily,globalDefaults.defaultFontFamily),lineHeight:helpers_core.options.toLineHeight(valueOrDefault(options.lineHeight,globalDefaults.defaultLineHeight),size),size:size,style:valueOrDefault(options.fontStyle,globalDefaults.defaultFontStyle),weight:null,string:''};font.string=toFontString(font);return font},resolve:function(inputs,context,index,info){var cacheable=!0;var i,ilen,value;for(i=0,ilen=inputs.length;i<ilen;++i){value=inputs[i];if(value===undefined){continue}
if(context!==undefined&&typeof value==='function'){value=value(context);cacheable=!1}
if(index!==undefined&&helpers_core.isArray(value)){value=value[index];cacheable=!1}
if(value!==undefined){if(info&&!cacheable){info.cacheable=!1}
return value}}}};var exports$2={_factorize:function(value){var result=[];var sqrt=Math.sqrt(value);var i;for(i=1;i<sqrt;i++){if(value%i===0){result.push(i);result.push(value/i)}}
if(sqrt===(sqrt|0)){result.push(sqrt)}
result.sort(function(a,b){return a-b}).pop();return result},log10:Math.log10||function(x){var exponent=Math.log(x)*Math.LOG10E;var powerOf10=Math.round(exponent);var isPowerOf10=x===Math.pow(10,powerOf10);return isPowerOf10?powerOf10:exponent}};var helpers_math=exports$2;helpers_core.log10=exports$2.log10;var getRtlAdapter=function(rectX,width){return{x:function(x){return rectX+rectX+width-x},setWidth:function(w){width=w},textAlign:function(align){if(align==='center'){return align}
return align==='right'?'left':'right'},xPlus:function(x,value){return x-value},leftForLtr:function(x,itemWidth){return x-itemWidth},}};var getLtrAdapter=function(){return{x:function(x){return x},setWidth:function(w){},textAlign:function(align){return align},xPlus:function(x,value){return x+value},leftForLtr:function(x,_itemWidth){return x},}};var getAdapter=function(rtl,rectX,width){return rtl?getRtlAdapter(rectX,width):getLtrAdapter()};var overrideTextDirection=function(ctx,direction){var style,original;if(direction==='ltr'||direction==='rtl'){style=ctx.canvas.style;original=[style.getPropertyValue('direction'),style.getPropertyPriority('direction'),];style.setProperty('direction',direction,'important');ctx.prevTextDirection=original}};var restoreTextDirection=function(ctx){var original=ctx.prevTextDirection;if(original!==undefined){delete ctx.prevTextDirection;ctx.canvas.style.setProperty('direction',original[0],original[1])}};var helpers_rtl={getRtlAdapter:getAdapter,overrideTextDirection:overrideTextDirection,restoreTextDirection:restoreTextDirection,};var helpers$1=helpers_core;var easing=helpers_easing;var canvas=helpers_canvas;var options=helpers_options;var math=helpers_math;var rtl=helpers_rtl;helpers$1.easing=easing;helpers$1.canvas=canvas;helpers$1.options=options;helpers$1.math=math;helpers$1.rtl=rtl;function interpolate(start,view,model,ease){var keys=Object.keys(model);var i,ilen,key,actual,origin,target,type,c0,c1;for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];target=model[key];if(!view.hasOwnProperty(key)){view[key]=target}
actual=view[key];if(actual===target||key[0]==='_'){continue}
if(!start.hasOwnProperty(key)){start[key]=actual}
origin=start[key];type=typeof target;if(type===typeof origin){if(type==='string'){c0=chartjsColor(origin);if(c0.valid){c1=chartjsColor(target);if(c1.valid){view[key]=c1.mix(c0,ease).rgbString();continue}}}else if(helpers$1.isFinite(origin)&&helpers$1.isFinite(target)){view[key]=origin+(target-origin)*ease;continue}}
view[key]=target}}
var Element=function(configuration){helpers$1.extend(this,configuration);this.initialize.apply(this,arguments)};helpers$1.extend(Element.prototype,{_type:undefined,initialize:function(){this.hidden=!1},pivot:function(){var me=this;if(!me._view){me._view=helpers$1.extend({},me._model)}
me._start={};return me},transition:function(ease){var me=this;var model=me._model;var start=me._start;var view=me._view;if(!model||ease===1){me._view=helpers$1.extend({},model);me._start=null;return me}
if(!view){view=me._view={}}
if(!start){start=me._start={}}
interpolate(start,view,model,ease);return me},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return helpers$1.isNumber(this._model.x)&&helpers$1.isNumber(this._model.y)}});Element.extend=helpers$1.inherits;var core_element=Element;var exports$3=core_element.extend({chart:null,currentStep:0,numSteps:60,easing:'',render:null,onAnimationProgress:null,onAnimationComplete:null,});var core_animation=exports$3;Object.defineProperty(exports$3.prototype,'animationObject',{get:function(){return this}});Object.defineProperty(exports$3.prototype,'chartInstance',{get:function(){return this.chart},set:function(value){this.chart=value}});core_defaults._set('global',{animation:{duration:1000,easing:'easeOutQuart',onProgress:helpers$1.noop,onComplete:helpers$1.noop}});var core_animations={animations:[],request:null,addAnimation:function(chart,animation,duration,lazy){var animations=this.animations;var i,ilen;animation.chart=chart;animation.startTime=Date.now();animation.duration=duration;if(!lazy){chart.animating=!0}
for(i=0,ilen=animations.length;i<ilen;++i){if(animations[i].chart===chart){animations[i]=animation;return}}
animations.push(animation);if(animations.length===1){this.requestAnimationFrame()}},cancelAnimation:function(chart){var index=helpers$1.findIndex(this.animations,function(animation){return animation.chart===chart});if(index!==-1){this.animations.splice(index,1);chart.animating=!1}},requestAnimationFrame:function(){var me=this;if(me.request===null){me.request=helpers$1.requestAnimFrame.call(window,function(){me.request=null;me.startDigest()})}},startDigest:function(){var me=this;me.advance();if(me.animations.length>0){me.requestAnimationFrame()}},advance:function(){var animations=this.animations;var animation,chart,numSteps,nextStep;var i=0;while(i<animations.length){animation=animations[i];chart=animation.chart;numSteps=animation.numSteps;nextStep=Math.floor((Date.now()-animation.startTime)/animation.duration*numSteps)+1;animation.currentStep=Math.min(nextStep,numSteps);helpers$1.callback(animation.render,[chart,animation],chart);helpers$1.callback(animation.onAnimationProgress,[animation],chart);if(animation.currentStep>=numSteps){helpers$1.callback(animation.onAnimationComplete,[animation],chart);chart.animating=!1;animations.splice(i,1)}else{++i}}}};var resolve=helpers$1.options.resolve;var arrayEvents=['push','pop','shift','splice','unshift'];function listenArrayEvents(array,listener){if(array._chartjs){array._chartjs.listeners.push(listener);return}
Object.defineProperty(array,'_chartjs',{configurable:!0,enumerable:!1,value:{listeners:[listener]}});arrayEvents.forEach(function(key){var method='onData'+key.charAt(0).toUpperCase()+key.slice(1);var base=array[key];Object.defineProperty(array,key,{configurable:!0,enumerable:!1,value:function(){var args=Array.prototype.slice.call(arguments);var res=base.apply(this,args);helpers$1.each(array._chartjs.listeners,function(object){if(typeof object[method]==='function'){object[method].apply(object,args)}});return res}})})}
function unlistenArrayEvents(array,listener){var stub=array._chartjs;if(!stub){return}
var listeners=stub.listeners;var index=listeners.indexOf(listener);if(index!==-1){listeners.splice(index,1)}
if(listeners.length>0){return}
arrayEvents.forEach(function(key){delete array[key]});delete array._chartjs}
var DatasetController=function(chart,datasetIndex){this.initialize(chart,datasetIndex)};helpers$1.extend(DatasetController.prototype,{datasetElementType:null,dataElementType:null,_datasetElementOptions:['backgroundColor','borderCapStyle','borderColor','borderDash','borderDashOffset','borderJoinStyle','borderWidth'],_dataElementOptions:['backgroundColor','borderColor','borderWidth','pointStyle'],initialize:function(chart,datasetIndex){var me=this;me.chart=chart;me.index=datasetIndex;me.linkScales();me.addElements();me._type=me.getMeta().type},updateIndex:function(datasetIndex){this.index=datasetIndex},linkScales:function(){var me=this;var meta=me.getMeta();var chart=me.chart;var scales=chart.scales;var dataset=me.getDataset();var scalesOpts=chart.options.scales;if(meta.xAxisID===null||!(meta.xAxisID in scales)||dataset.xAxisID){meta.xAxisID=dataset.xAxisID||scalesOpts.xAxes[0].id}
if(meta.yAxisID===null||!(meta.yAxisID in scales)||dataset.yAxisID){meta.yAxisID=dataset.yAxisID||scalesOpts.yAxes[0].id}},getDataset:function(){return this.chart.data.datasets[this.index]},getMeta:function(){return this.chart.getDatasetMeta(this.index)},getScaleForId:function(scaleID){return this.chart.scales[scaleID]},_getValueScaleId:function(){return this.getMeta().yAxisID},_getIndexScaleId:function(){return this.getMeta().xAxisID},_getValueScale:function(){return this.getScaleForId(this._getValueScaleId())},_getIndexScale:function(){return this.getScaleForId(this._getIndexScaleId())},reset:function(){this._update(!0)},destroy:function(){if(this._data){unlistenArrayEvents(this._data,this)}},createMetaDataset:function(){var me=this;var type=me.datasetElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index})},createMetaData:function(index){var me=this;var type=me.dataElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index,_index:index})},addElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data||[];var metaData=meta.data;var i,ilen;for(i=0,ilen=data.length;i<ilen;++i){metaData[i]=metaData[i]||me.createMetaData(i)}
meta.dataset=meta.dataset||me.createMetaDataset()},addElementAndReset:function(index){var element=this.createMetaData(index);this.getMeta().data.splice(index,0,element);this.updateElement(element,index,!0)},buildOrUpdateElements:function(){var me=this;var dataset=me.getDataset();var data=dataset.data||(dataset.data=[]);if(me._data!==data){if(me._data){unlistenArrayEvents(me._data,me)}
if(data&&Object.isExtensible(data)){listenArrayEvents(data,me)}
me._data=data}
me.resyncElements()},_configure:function(){var me=this;me._config=helpers$1.merge(Object.create(null),[me.chart.options.datasets[me._type],me.getDataset(),],{merger:function(key,target,source){if(key!=='_meta'&&key!=='data'){helpers$1._merger(key,target,source)}}})},_update:function(reset){var me=this;me._configure();me._cachedDataOpts=null;me.update(reset)},update:helpers$1.noop,transition:function(easingValue){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;for(;i<ilen;++i){elements[i].transition(easingValue)}
if(meta.dataset){meta.dataset.transition(easingValue)}},draw:function(){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;if(meta.dataset){meta.dataset.draw()}
for(;i<ilen;++i){elements[i].draw()}},getStyle:function(index){var me=this;var meta=me.getMeta();var dataset=meta.dataset;var style;me._configure();if(dataset&&index===undefined){style=me._resolveDatasetElementOptions(dataset||{})}else{index=index||0;style=me._resolveDataElementOptions(meta.data[index]||{},index)}
if(style.fill===!1||style.fill===null){style.backgroundColor=style.borderColor}
return style},_resolveDatasetElementOptions:function(element,hover){var me=this;var chart=me.chart;var datasetOpts=me._config;var custom=element.custom||{};var options=chart.options.elements[me.datasetElementType.prototype._type]||{};var elementOptions=me._datasetElementOptions;var values={};var i,ilen,key,readKey;var context={chart:chart,dataset:me.getDataset(),datasetIndex:me.index,hover:hover};for(i=0,ilen=elementOptions.length;i<ilen;++i){key=elementOptions[i];readKey=hover?'hover'+key.charAt(0).toUpperCase()+key.slice(1):key;values[key]=resolve([custom[readKey],datasetOpts[readKey],options[readKey]],context)}
return values},_resolveDataElementOptions:function(element,index){var me=this;var custom=element&&element.custom;var cached=me._cachedDataOpts;if(cached&&!custom){return cached}
var chart=me.chart;var datasetOpts=me._config;var options=chart.options.elements[me.dataElementType.prototype._type]||{};var elementOptions=me._dataElementOptions;var values={};var context={chart:chart,dataIndex:index,dataset:me.getDataset(),datasetIndex:me.index};var info={cacheable:!custom};var keys,i,ilen,key;custom=custom||{};if(helpers$1.isArray(elementOptions)){for(i=0,ilen=elementOptions.length;i<ilen;++i){key=elementOptions[i];values[key]=resolve([custom[key],datasetOpts[key],options[key]],context,index,info)}}else{keys=Object.keys(elementOptions);for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];values[key]=resolve([custom[key],datasetOpts[elementOptions[key]],datasetOpts[key],options[key]],context,index,info)}}
if(info.cacheable){me._cachedDataOpts=Object.freeze(values)}
return values},removeHoverStyle:function(element){helpers$1.merge(element._model,element.$previousStyle||{});delete element.$previousStyle},setHoverStyle:function(element){var dataset=this.chart.data.datasets[element._datasetIndex];var index=element._index;var custom=element.custom||{};var model=element._model;var getHoverColor=helpers$1.getHoverColor;element.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth};model.backgroundColor=resolve([custom.hoverBackgroundColor,dataset.hoverBackgroundColor,getHoverColor(model.backgroundColor)],undefined,index);model.borderColor=resolve([custom.hoverBorderColor,dataset.hoverBorderColor,getHoverColor(model.borderColor)],undefined,index);model.borderWidth=resolve([custom.hoverBorderWidth,dataset.hoverBorderWidth,model.borderWidth],undefined,index)},_removeDatasetHoverStyle:function(){var element=this.getMeta().dataset;if(element){this.removeHoverStyle(element)}},_setDatasetHoverStyle:function(){var element=this.getMeta().dataset;var prev={};var i,ilen,key,keys,hoverOptions,model;if(!element){return}
model=element._model;hoverOptions=this._resolveDatasetElementOptions(element,!0);keys=Object.keys(hoverOptions);for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];prev[key]=model[key];model[key]=hoverOptions[key]}
element.$previousStyle=prev},resyncElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data;var numMeta=meta.data.length;var numData=data.length;if(numData<numMeta){meta.data.splice(numData,numMeta-numData)}else if(numData>numMeta){me.insertElements(numMeta,numData-numMeta)}},insertElements:function(start,count){for(var i=0;i<count;++i){this.addElementAndReset(start+i)}},onDataPush:function(){var count=arguments.length;this.insertElements(this.getDataset().data.length-count,count)},onDataPop:function(){this.getMeta().data.pop()},onDataShift:function(){this.getMeta().data.shift()},onDataSplice:function(start,count){this.getMeta().data.splice(start,count);this.insertElements(start,arguments.length-2)},onDataUnshift:function(){this.insertElements(0,arguments.length)}});DatasetController.extend=helpers$1.inherits;var core_datasetController=DatasetController;var TAU=Math.PI*2;core_defaults._set('global',{elements:{arc:{backgroundColor:core_defaults.global.defaultColor,borderColor:'#fff',borderWidth:2,borderAlign:'center'}}});function clipArc(ctx,arc){var startAngle=arc.startAngle;var endAngle=arc.endAngle;var pixelMargin=arc.pixelMargin;var angleMargin=pixelMargin/arc.outerRadius;var x=arc.x;var y=arc.y;ctx.beginPath();ctx.arc(x,y,arc.outerRadius,startAngle-angleMargin,endAngle+angleMargin);if(arc.innerRadius>pixelMargin){angleMargin=pixelMargin/arc.innerRadius;ctx.arc(x,y,arc.innerRadius-pixelMargin,endAngle+angleMargin,startAngle-angleMargin,!0)}else{ctx.arc(x,y,pixelMargin,endAngle+Math.PI/2,startAngle-Math.PI/2)}
ctx.closePath();ctx.clip()}
function drawFullCircleBorders(ctx,vm,arc,inner){var endAngle=arc.endAngle;var i;if(inner){arc.endAngle=arc.startAngle+TAU;clipArc(ctx,arc);arc.endAngle=endAngle;if(arc.endAngle===arc.startAngle&&arc.fullCircles){arc.endAngle+=TAU;arc.fullCircles--}}
ctx.beginPath();ctx.arc(arc.x,arc.y,arc.innerRadius,arc.startAngle+TAU,arc.startAngle,!0);for(i=0;i<arc.fullCircles;++i){ctx.stroke()}
ctx.beginPath();ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.startAngle+TAU);for(i=0;i<arc.fullCircles;++i){ctx.stroke()}}
function drawBorder(ctx,vm,arc){var inner=vm.borderAlign==='inner';if(inner){ctx.lineWidth=vm.borderWidth*2;ctx.lineJoin='round'}else{ctx.lineWidth=vm.borderWidth;ctx.lineJoin='bevel'}
if(arc.fullCircles){drawFullCircleBorders(ctx,vm,arc,inner)}
if(inner){clipArc(ctx,arc)}
ctx.beginPath();ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0);ctx.closePath();ctx.stroke()}
var element_arc=core_element.extend({_type:'arc',inLabelRange:function(mouseX){var vm=this._view;if(vm){return(Math.pow(mouseX-vm.x,2)<Math.pow(vm.radius+vm.hoverRadius,2))}
return!1},inRange:function(chartX,chartY){var vm=this._view;if(vm){var pointRelativePosition=helpers$1.getAngleFromPoint(vm,{x:chartX,y:chartY});var angle=pointRelativePosition.angle;var distance=pointRelativePosition.distance;var startAngle=vm.startAngle;var endAngle=vm.endAngle;while(endAngle<startAngle){endAngle+=TAU}
while(angle>endAngle){angle-=TAU}
while(angle<startAngle){angle+=TAU}
var betweenAngles=(angle>=startAngle&&angle<=endAngle);var withinRadius=(distance>=vm.innerRadius&&distance<=vm.outerRadius);return(betweenAngles&&withinRadius)}
return!1},getCenterPoint:function(){var vm=this._view;var halfAngle=(vm.startAngle+vm.endAngle)/2;var halfRadius=(vm.innerRadius+vm.outerRadius)/2;return{x:vm.x+Math.cos(halfAngle)*halfRadius,y:vm.y+Math.sin(halfAngle)*halfRadius}},getArea:function(){var vm=this._view;return Math.PI*((vm.endAngle-vm.startAngle)/(2*Math.PI))*(Math.pow(vm.outerRadius,2)-Math.pow(vm.innerRadius,2))},tooltipPosition:function(){var vm=this._view;var centreAngle=vm.startAngle+((vm.endAngle-vm.startAngle)/2);var rangeFromCentre=(vm.outerRadius-vm.innerRadius)/2+vm.innerRadius;return{x:vm.x+(Math.cos(centreAngle)*rangeFromCentre),y:vm.y+(Math.sin(centreAngle)*rangeFromCentre)}},draw:function(){var ctx=this._chart.ctx;var vm=this._view;var pixelMargin=(vm.borderAlign==='inner')?0.33:0;var arc={x:vm.x,y:vm.y,innerRadius:vm.innerRadius,outerRadius:Math.max(vm.outerRadius-pixelMargin,0),pixelMargin:pixelMargin,startAngle:vm.startAngle,endAngle:vm.endAngle,fullCircles:Math.floor(vm.circumference/TAU)};var i;ctx.save();ctx.fillStyle=vm.backgroundColor;ctx.strokeStyle=vm.borderColor;if(arc.fullCircles){arc.endAngle=arc.startAngle+TAU;ctx.beginPath();ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0);ctx.closePath();for(i=0;i<arc.fullCircles;++i){ctx.fill()}
arc.endAngle=arc.startAngle+vm.circumference%TAU}
ctx.beginPath();ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,!0);ctx.closePath();ctx.fill();if(vm.borderWidth){drawBorder(ctx,vm,arc)}
ctx.restore()}});var valueOrDefault$1=helpers$1.valueOrDefault;var defaultColor=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{line:{tension:0.4,backgroundColor:defaultColor,borderWidth:3,borderColor:defaultColor,borderCapStyle:'butt',borderDash:[],borderDashOffset:0.0,borderJoinStyle:'miter',capBezierPoints:!0,fill:!0,}}});var element_line=core_element.extend({_type:'line',draw:function(){var me=this;var vm=me._view;var ctx=me._chart.ctx;var spanGaps=vm.spanGaps;var points=me._children.slice();var globalDefaults=core_defaults.global;var globalOptionLineElements=globalDefaults.elements.line;var lastDrawnIndex=-1;var closePath=me._loop;var index,previous,currentVM;if(!points.length){return}
if(me._loop){for(index=0;index<points.length;++index){previous=helpers$1.previousItem(points,index);if(!points[index]._view.skip&&previous._view.skip){points=points.slice(index).concat(points.slice(0,index));closePath=spanGaps;break}}
if(closePath){points.push(points[0])}}
ctx.save();ctx.lineCap=vm.borderCapStyle||globalOptionLineElements.borderCapStyle;if(ctx.setLineDash){ctx.setLineDash(vm.borderDash||globalOptionLineElements.borderDash)}
ctx.lineDashOffset=valueOrDefault$1(vm.borderDashOffset,globalOptionLineElements.borderDashOffset);ctx.lineJoin=vm.borderJoinStyle||globalOptionLineElements.borderJoinStyle;ctx.lineWidth=valueOrDefault$1(vm.borderWidth,globalOptionLineElements.borderWidth);ctx.strokeStyle=vm.borderColor||globalDefaults.defaultColor;ctx.beginPath();currentVM=points[0]._view;if(!currentVM.skip){ctx.moveTo(currentVM.x,currentVM.y);lastDrawnIndex=0}
for(index=1;index<points.length;++index){currentVM=points[index]._view;previous=lastDrawnIndex===-1?helpers$1.previousItem(points,index):points[lastDrawnIndex];if(!currentVM.skip){if((lastDrawnIndex!==(index-1)&&!spanGaps)||lastDrawnIndex===-1){ctx.moveTo(currentVM.x,currentVM.y)}else{helpers$1.canvas.lineTo(ctx,previous._view,currentVM)}
lastDrawnIndex=index}}
if(closePath){ctx.closePath()}
ctx.stroke();ctx.restore()}});var valueOrDefault$2=helpers$1.valueOrDefault;var defaultColor$1=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{point:{radius:3,pointStyle:'circle',backgroundColor:defaultColor$1,borderColor:defaultColor$1,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}});function xRange(mouseX){var vm=this._view;return vm?(Math.abs(mouseX-vm.x)<vm.radius+vm.hitRadius):!1}
function yRange(mouseY){var vm=this._view;return vm?(Math.abs(mouseY-vm.y)<vm.radius+vm.hitRadius):!1}
var element_point=core_element.extend({_type:'point',inRange:function(mouseX,mouseY){var vm=this._view;return vm?((Math.pow(mouseX-vm.x,2)+Math.pow(mouseY-vm.y,2))<Math.pow(vm.hitRadius+vm.radius,2)):!1},inLabelRange:xRange,inXRange:xRange,inYRange:yRange,getCenterPoint:function(){var vm=this._view;return{x:vm.x,y:vm.y}},getArea:function(){return Math.PI*Math.pow(this._view.radius,2)},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y,padding:vm.radius+vm.borderWidth}},draw:function(chartArea){var vm=this._view;var ctx=this._chart.ctx;var pointStyle=vm.pointStyle;var rotation=vm.rotation;var radius=vm.radius;var x=vm.x;var y=vm.y;var globalDefaults=core_defaults.global;var defaultColor=globalDefaults.defaultColor;if(vm.skip){return}
if(chartArea===undefined||helpers$1.canvas._isPointInArea(vm,chartArea)){ctx.strokeStyle=vm.borderColor||defaultColor;ctx.lineWidth=valueOrDefault$2(vm.borderWidth,globalDefaults.elements.point.borderWidth);ctx.fillStyle=vm.backgroundColor||defaultColor;helpers$1.canvas.drawPoint(ctx,pointStyle,radius,x,y,rotation)}}});var defaultColor$2=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{rectangle:{backgroundColor:defaultColor$2,borderColor:defaultColor$2,borderSkipped:'bottom',borderWidth:0}}});function isVertical(vm){return vm&&vm.width!==undefined}
function getBarBounds(vm){var x1,x2,y1,y2,half;if(isVertical(vm)){half=vm.width/2;x1=vm.x-half;x2=vm.x+half;y1=Math.min(vm.y,vm.base);y2=Math.max(vm.y,vm.base)}else{half=vm.height/2;x1=Math.min(vm.x,vm.base);x2=Math.max(vm.x,vm.base);y1=vm.y-half;y2=vm.y+half}
return{left:x1,top:y1,right:x2,bottom:y2}}
function swap(orig,v1,v2){return orig===v1?v2:orig===v2?v1:orig}
function parseBorderSkipped(vm){var edge=vm.borderSkipped;var res={};if(!edge){return res}
if(vm.horizontal){if(vm.base>vm.x){edge=swap(edge,'left','right')}}else if(vm.base<vm.y){edge=swap(edge,'bottom','top')}
res[edge]=!0;return res}
function parseBorderWidth(vm,maxW,maxH){var value=vm.borderWidth;var skip=parseBorderSkipped(vm);var t,r,b,l;if(helpers$1.isObject(value)){t=+value.top||0;r=+value.right||0;b=+value.bottom||0;l=+value.left||0}else{t=r=b=l=+value||0}
return{t:skip.top||(t<0)?0:t>maxH?maxH:t,r:skip.right||(r<0)?0:r>maxW?maxW:r,b:skip.bottom||(b<0)?0:b>maxH?maxH:b,l:skip.left||(l<0)?0:l>maxW?maxW:l}}
function boundingRects(vm){var bounds=getBarBounds(vm);var width=bounds.right-bounds.left;var height=bounds.bottom-bounds.top;var border=parseBorderWidth(vm,width/2,height/2);return{outer:{x:bounds.left,y:bounds.top,w:width,h:height},inner:{x:bounds.left+border.l,y:bounds.top+border.t,w:width-border.l-border.r,h:height-border.t-border.b}}}
function inRange(vm,x,y){var skipX=x===null;var skipY=y===null;var bounds=!vm||(skipX&&skipY)?!1:getBarBounds(vm);return bounds&&(skipX||x>=bounds.left&&x<=bounds.right)&&(skipY||y>=bounds.top&&y<=bounds.bottom)}
var element_rectangle=core_element.extend({_type:'rectangle',draw:function(){var ctx=this._chart.ctx;var vm=this._view;var rects=boundingRects(vm);var outer=rects.outer;var inner=rects.inner;ctx.fillStyle=vm.backgroundColor;ctx.fillRect(outer.x,outer.y,outer.w,outer.h);if(outer.w===inner.w&&outer.h===inner.h){return}
ctx.save();ctx.beginPath();ctx.rect(outer.x,outer.y,outer.w,outer.h);ctx.clip();ctx.fillStyle=vm.borderColor;ctx.rect(inner.x,inner.y,inner.w,inner.h);ctx.fill('evenodd');ctx.restore()},height:function(){var vm=this._view;return vm.base-vm.y},inRange:function(mouseX,mouseY){return inRange(this._view,mouseX,mouseY)},inLabelRange:function(mouseX,mouseY){var vm=this._view;return isVertical(vm)?inRange(vm,mouseX,null):inRange(vm,null,mouseY)},inXRange:function(mouseX){return inRange(this._view,mouseX,null)},inYRange:function(mouseY){return inRange(this._view,null,mouseY)},getCenterPoint:function(){var vm=this._view;var x,y;if(isVertical(vm)){x=vm.x;y=(vm.y+vm.base)/2}else{x=(vm.x+vm.base)/2;y=vm.y}
return{x:x,y:y}},getArea:function(){var vm=this._view;return isVertical(vm)?vm.width*Math.abs(vm.y-vm.base):vm.height*Math.abs(vm.x-vm.base)},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y}}});var elements={};var Arc=element_arc;var Line=element_line;var Point=element_point;var Rectangle=element_rectangle;elements.Arc=Arc;elements.Line=Line;elements.Point=Point;elements.Rectangle=Rectangle;var deprecated=helpers$1._deprecated;var valueOrDefault$3=helpers$1.valueOrDefault;core_defaults._set('bar',{hover:{mode:'label'},scales:{xAxes:[{type:'category',offset:!0,gridLines:{offsetGridLines:!0}}],yAxes:[{type:'linear'}]}});core_defaults._set('global',{datasets:{bar:{categoryPercentage:0.8,barPercentage:0.9}}});function computeMinSampleSize(scale,pixels){var min=scale._length;var prev,curr,i,ilen;for(i=1,ilen=pixels.length;i<ilen;++i){min=Math.min(min,Math.abs(pixels[i]-pixels[i-1]))}
for(i=0,ilen=scale.getTicks().length;i<ilen;++i){curr=scale.getPixelForTick(i);min=i>0?Math.min(min,Math.abs(curr-prev)):min;prev=curr}
return min}
function computeFitCategoryTraits(index,ruler,options){var thickness=options.barThickness;var count=ruler.stackCount;var curr=ruler.pixels[index];var min=helpers$1.isNullOrUndef(thickness)?computeMinSampleSize(ruler.scale,ruler.pixels):-1;var size,ratio;if(helpers$1.isNullOrUndef(thickness)){size=min*options.categoryPercentage;ratio=options.barPercentage}else{size=thickness*count;ratio=1}
return{chunk:size/count,ratio:ratio,start:curr-(size/2)}}
function computeFlexCategoryTraits(index,ruler,options){var pixels=ruler.pixels;var curr=pixels[index];var prev=index>0?pixels[index-1]:null;var next=index<pixels.length-1?pixels[index+1]:null;var percent=options.categoryPercentage;var start,size;if(prev===null){prev=curr-(next===null?ruler.end-ruler.start:next-curr)}
if(next===null){next=curr+curr-prev}
start=curr-(curr-Math.min(prev,next))/2*percent;size=Math.abs(next-prev)/2*percent;return{chunk:size/ruler.stackCount,ratio:options.barPercentage,start:start}}
var controller_bar=core_datasetController.extend({dataElementType:elements.Rectangle,_dataElementOptions:['backgroundColor','borderColor','borderSkipped','borderWidth','barPercentage','barThickness','categoryPercentage','maxBarThickness','minBarLength'],initialize:function(){var me=this;var meta,scaleOpts;core_datasetController.prototype.initialize.apply(me,arguments);meta=me.getMeta();meta.stack=me.getDataset().stack;meta.bar=!0;scaleOpts=me._getIndexScale().options;deprecated('bar chart',scaleOpts.barPercentage,'scales.[x/y]Axes.barPercentage','dataset.barPercentage');deprecated('bar chart',scaleOpts.barThickness,'scales.[x/y]Axes.barThickness','dataset.barThickness');deprecated('bar chart',scaleOpts.categoryPercentage,'scales.[x/y]Axes.categoryPercentage','dataset.categoryPercentage');deprecated('bar chart',me._getValueScale().options.minBarLength,'scales.[x/y]Axes.minBarLength','dataset.minBarLength');deprecated('bar chart',scaleOpts.maxBarThickness,'scales.[x/y]Axes.maxBarThickness','dataset.maxBarThickness')},update:function(reset){var me=this;var rects=me.getMeta().data;var i,ilen;me._ruler=me.getRuler();for(i=0,ilen=rects.length;i<ilen;++i){me.updateElement(rects[i],i,reset)}},updateElement:function(rectangle,index,reset){var me=this;var meta=me.getMeta();var dataset=me.getDataset();var options=me._resolveDataElementOptions(rectangle,index);rectangle._xScale=me.getScaleForId(meta.xAxisID);rectangle._yScale=me.getScaleForId(meta.yAxisID);rectangle._datasetIndex=me.index;rectangle._index=index;rectangle._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderSkipped:options.borderSkipped,borderWidth:options.borderWidth,datasetLabel:dataset.label,label:me.chart.data.labels[index]};if(helpers$1.isArray(dataset.data[index])){rectangle._model.borderSkipped=null}
me._updateElementGeometry(rectangle,index,reset,options);rectangle.pivot()},_updateElementGeometry:function(rectangle,index,reset,options){var me=this;var model=rectangle._model;var vscale=me._getValueScale();var base=vscale.getBasePixel();var horizontal=vscale.isHorizontal();var ruler=me._ruler||me.getRuler();var vpixels=me.calculateBarValuePixels(me.index,index,options);var ipixels=me.calculateBarIndexPixels(me.index,index,ruler,options);model.horizontal=horizontal;model.base=reset?base:vpixels.base;model.x=horizontal?reset?base:vpixels.head:ipixels.center;model.y=horizontal?ipixels.center:reset?base:vpixels.head;model.height=horizontal?ipixels.size:undefined;model.width=horizontal?undefined:ipixels.size},_getStacks:function(last){var me=this;var scale=me._getIndexScale();var metasets=scale._getMatchingVisibleMetas(me._type);var stacked=scale.options.stacked;var ilen=metasets.length;var stacks=[];var i,meta;for(i=0;i<ilen;++i){meta=metasets[i];if(stacked===!1||stacks.indexOf(meta.stack)===-1||(stacked===undefined&&meta.stack===undefined)){stacks.push(meta.stack)}
if(meta.index===last){break}}
return stacks},getStackCount:function(){return this._getStacks().length},getStackIndex:function(datasetIndex,name){var stacks=this._getStacks(datasetIndex);var index=(name!==undefined)?stacks.indexOf(name):-1;return(index===-1)?stacks.length-1:index},getRuler:function(){var me=this;var scale=me._getIndexScale();var pixels=[];var i,ilen;for(i=0,ilen=me.getMeta().data.length;i<ilen;++i){pixels.push(scale.getPixelForValue(null,i,me.index))}
return{pixels:pixels,start:scale._startPixel,end:scale._endPixel,stackCount:me.getStackCount(),scale:scale}},calculateBarValuePixels:function(datasetIndex,index,options){var me=this;var chart=me.chart;var scale=me._getValueScale();var isHorizontal=scale.isHorizontal();var datasets=chart.data.datasets;var metasets=scale._getMatchingVisibleMetas(me._type);var value=scale._parseValue(datasets[datasetIndex].data[index]);var minBarLength=options.minBarLength;var stacked=scale.options.stacked;var stack=me.getMeta().stack;var start=value.start===undefined?0:value.max>=0&&value.min>=0?value.min:value.max;var length=value.start===undefined?value.end:value.max>=0&&value.min>=0?value.max-value.min:value.min-value.max;var ilen=metasets.length;var i,imeta,ivalue,base,head,size,stackLength;if(stacked||(stacked===undefined&&stack!==undefined)){for(i=0;i<ilen;++i){imeta=metasets[i];if(imeta.index===datasetIndex){break}
if(imeta.stack===stack){stackLength=scale._parseValue(datasets[imeta.index].data[index]);ivalue=stackLength.start===undefined?stackLength.end:stackLength.min>=0&&stackLength.max>=0?stackLength.max:stackLength.min;if((value.min<0&&ivalue<0)||(value.max>=0&&ivalue>0)){start+=ivalue}}}}
base=scale.getPixelForValue(start);head=scale.getPixelForValue(start+length);size=head-base;if(minBarLength!==undefined&&Math.abs(size)<minBarLength){size=minBarLength;if(length>=0&&!isHorizontal||length<0&&isHorizontal){head=base-minBarLength}else{head=base+minBarLength}}
return{size:size,base:base,head:head,center:head+size/2}},calculateBarIndexPixels:function(datasetIndex,index,ruler,options){var me=this;var range=options.barThickness==='flex'?computeFlexCategoryTraits(index,ruler,options):computeFitCategoryTraits(index,ruler,options);var stackIndex=me.getStackIndex(datasetIndex,me.getMeta().stack);var center=range.start+(range.chunk*stackIndex)+(range.chunk/2);var size=Math.min(valueOrDefault$3(options.maxBarThickness,Infinity),range.chunk*range.ratio);return{base:center-size/2,head:center+size/2,center:center,size:size}},draw:function(){var me=this;var chart=me.chart;var scale=me._getValueScale();var rects=me.getMeta().data;var dataset=me.getDataset();var ilen=rects.length;var i=0;helpers$1.canvas.clipArea(chart.ctx,chart.chartArea);for(;i<ilen;++i){var val=scale._parseValue(dataset.data[i]);if(!isNaN(val.min)&&!isNaN(val.max)){rects[i].draw()}}
helpers$1.canvas.unclipArea(chart.ctx)},_resolveDataElementOptions:function(){var me=this;var values=helpers$1.extend({},core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments));var indexOpts=me._getIndexScale().options;var valueOpts=me._getValueScale().options;values.barPercentage=valueOrDefault$3(indexOpts.barPercentage,values.barPercentage);values.barThickness=valueOrDefault$3(indexOpts.barThickness,values.barThickness);values.categoryPercentage=valueOrDefault$3(indexOpts.categoryPercentage,values.categoryPercentage);values.maxBarThickness=valueOrDefault$3(indexOpts.maxBarThickness,values.maxBarThickness);values.minBarLength=valueOrDefault$3(valueOpts.minBarLength,values.minBarLength);return values}});var valueOrDefault$4=helpers$1.valueOrDefault;var resolve$1=helpers$1.options.resolve;core_defaults._set('bubble',{hover:{mode:'single'},scales:{xAxes:[{type:'linear',position:'bottom',id:'x-axis-0'}],yAxes:[{type:'linear',position:'left',id:'y-axis-0'}]},tooltips:{callbacks:{title:function(){return''},label:function(item,data){var datasetLabel=data.datasets[item.datasetIndex].label||'';var dataPoint=data.datasets[item.datasetIndex].data[item.index];return datasetLabel+': ('+item.xLabel+', '+item.yLabel+', '+dataPoint.r+')'}}}});var controller_bubble=core_datasetController.extend({dataElementType:elements.Point,_dataElementOptions:['backgroundColor','borderColor','borderWidth','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth','hoverRadius','hitRadius','pointStyle','rotation'],update:function(reset){var me=this;var meta=me.getMeta();var points=meta.data;helpers$1.each(points,function(point,index){me.updateElement(point,index,reset)})},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var xScale=me.getScaleForId(meta.xAxisID);var yScale=me.getScaleForId(meta.yAxisID);var options=me._resolveDataElementOptions(point,index);var data=me.getDataset().data[index];var dsIndex=me.index;var x=reset?xScale.getPixelForDecimal(0.5):xScale.getPixelForValue(typeof data==='object'?data:NaN,index,dsIndex);var y=reset?yScale.getBasePixel():yScale.getPixelForValue(data,index,dsIndex);point._xScale=xScale;point._yScale=yScale;point._options=options;point._datasetIndex=dsIndex;point._index=index;point._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,hitRadius:options.hitRadius,pointStyle:options.pointStyle,rotation:options.rotation,radius:reset?0:options.radius,skip:custom.skip||isNaN(x)||isNaN(y),x:x,y:y,};point.pivot()},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$4(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$4(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$4(options.hoverBorderWidth,options.borderWidth);model.radius=options.radius+options.hoverRadius},_resolveDataElementOptions:function(point,index){var me=this;var chart=me.chart;var dataset=me.getDataset();var custom=point.custom||{};var data=dataset.data[index]||{};var values=core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments);var context={chart:chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};if(me._cachedDataOpts===values){values=helpers$1.extend({},values)}
values.radius=resolve$1([custom.radius,data.r,me._config.radius,chart.options.elements.point.radius],context,index);return values}});var valueOrDefault$5=helpers$1.valueOrDefault;var PI$1=Math.PI;var DOUBLE_PI$1=PI$1*2;var HALF_PI$1=PI$1/2;core_defaults._set('doughnut',{animation:{animateRotate:!0,animateScale:!1},hover:{mode:'single'},legendCallback:function(chart){var list=document.createElement('ul');var data=chart.data;var datasets=data.datasets;var labels=data.labels;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');if(datasets.length){for(i=0,ilen=datasets[0].data.length;i<ilen;++i){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[0].backgroundColor[i];if(labels[i]){listItem.appendChild(document.createTextNode(labels[i]))}}}
return list.outerHTML},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i}})}
return[]}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);if(meta.data[index]){meta.data[index].hidden=!meta.data[index].hidden}}
chart.update()}},cutoutPercentage:50,rotation:-HALF_PI$1,circumference:DOUBLE_PI$1,tooltips:{callbacks:{title:function(){return''},label:function(tooltipItem,data){var dataLabel=data.labels[tooltipItem.index];var value=': '+data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];if(helpers$1.isArray(dataLabel)){dataLabel=dataLabel.slice();dataLabel[0]+=value}else{dataLabel+=value}
return dataLabel}}}});var controller_doughnut=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:['backgroundColor','borderColor','borderWidth','borderAlign','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth',],getRingIndex:function(datasetIndex){var ringIndex=0;for(var j=0;j<datasetIndex;++j){if(this.chart.isDatasetVisible(j)){++ringIndex}}
return ringIndex},update:function(reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var ratioX=1;var ratioY=1;var offsetX=0;var offsetY=0;var meta=me.getMeta();var arcs=meta.data;var cutout=opts.cutoutPercentage/100||0;var circumference=opts.circumference;var chartWeight=me._getRingWeight(me.index);var maxWidth,maxHeight,i,ilen;if(circumference<DOUBLE_PI$1){var startAngle=opts.rotation%DOUBLE_PI$1;startAngle+=startAngle>=PI$1?-DOUBLE_PI$1:startAngle<-PI$1?DOUBLE_PI$1:0;var endAngle=startAngle+circumference;var startX=Math.cos(startAngle);var startY=Math.sin(startAngle);var endX=Math.cos(endAngle);var endY=Math.sin(endAngle);var contains0=(startAngle<=0&&endAngle>=0)||endAngle>=DOUBLE_PI$1;var contains90=(startAngle<=HALF_PI$1&&endAngle>=HALF_PI$1)||endAngle>=DOUBLE_PI$1+HALF_PI$1;var contains180=startAngle===-PI$1||endAngle>=PI$1;var contains270=(startAngle<=-HALF_PI$1&&endAngle>=-HALF_PI$1)||endAngle>=PI$1+HALF_PI$1;var minX=contains180?-1:Math.min(startX,startX*cutout,endX,endX*cutout);var minY=contains270?-1:Math.min(startY,startY*cutout,endY,endY*cutout);var maxX=contains0?1:Math.max(startX,startX*cutout,endX,endX*cutout);var maxY=contains90?1:Math.max(startY,startY*cutout,endY,endY*cutout);ratioX=(maxX-minX)/2;ratioY=(maxY-minY)/2;offsetX=-(maxX+minX)/2;offsetY=-(maxY+minY)/2}
for(i=0,ilen=arcs.length;i<ilen;++i){arcs[i]._options=me._resolveDataElementOptions(arcs[i],i)}
chart.borderWidth=me.getMaxBorderWidth();maxWidth=(chartArea.right-chartArea.left-chart.borderWidth)/ratioX;maxHeight=(chartArea.bottom-chartArea.top-chart.borderWidth)/ratioY;chart.outerRadius=Math.max(Math.min(maxWidth,maxHeight)/2,0);chart.innerRadius=Math.max(chart.outerRadius*cutout,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/(me._getVisibleDatasetWeightTotal()||1);chart.offsetX=offsetX*chart.outerRadius;chart.offsetY=offsetY*chart.outerRadius;meta.total=me.calculateTotal();me.outerRadius=chart.outerRadius-chart.radiusLength*me._getRingWeightOffset(me.index);me.innerRadius=Math.max(me.outerRadius-chart.radiusLength*chartWeight,0);for(i=0,ilen=arcs.length;i<ilen;++i){me.updateElement(arcs[i],i,reset)}},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var animationOpts=opts.animation;var centerX=(chartArea.left+chartArea.right)/2;var centerY=(chartArea.top+chartArea.bottom)/2;var startAngle=opts.rotation;var endAngle=opts.rotation;var dataset=me.getDataset();var circumference=reset&&animationOpts.animateRotate?0:arc.hidden?0:me.calculateCircumference(dataset.data[index])*(opts.circumference/DOUBLE_PI$1);var innerRadius=reset&&animationOpts.animateScale?0:me.innerRadius;var outerRadius=reset&&animationOpts.animateScale?0:me.outerRadius;var options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX+chart.offsetX,y:centerY+chart.offsetY,startAngle:startAngle,endAngle:endAngle,circumference:circumference,outerRadius:outerRadius,innerRadius:innerRadius,label:helpers$1.valueAtIndexOrDefault(dataset.label,index,chart.data.labels[index])}});var model=arc._model;if(!reset||!animationOpts.animateRotate){if(index===0){model.startAngle=opts.rotation}else{model.startAngle=me.getMeta().data[index-1]._model.endAngle}
model.endAngle=model.startAngle+model.circumference}
arc.pivot()},calculateTotal:function(){var dataset=this.getDataset();var meta=this.getMeta();var total=0;var value;helpers$1.each(meta.data,function(element,index){value=dataset.data[index];if(!isNaN(value)&&!element.hidden){total+=Math.abs(value)}});return total},calculateCircumference:function(value){var total=this.getMeta().total;if(total>0&&!isNaN(value)){return DOUBLE_PI$1*(Math.abs(value)/total)}
return 0},getMaxBorderWidth:function(arcs){var me=this;var max=0;var chart=me.chart;var i,ilen,meta,arc,controller,options,borderWidth,hoverWidth;if(!arcs){for(i=0,ilen=chart.data.datasets.length;i<ilen;++i){if(chart.isDatasetVisible(i)){meta=chart.getDatasetMeta(i);arcs=meta.data;if(i!==me.index){controller=meta.controller}
break}}}
if(!arcs){return 0}
for(i=0,ilen=arcs.length;i<ilen;++i){arc=arcs[i];if(controller){controller._configure();options=controller._resolveDataElementOptions(arc,i)}else{options=arc._options}
if(options.borderAlign!=='inner'){borderWidth=options.borderWidth;hoverWidth=options.hoverBorderWidth;max=borderWidth>max?borderWidth:max;max=hoverWidth>max?hoverWidth:max}}
return max},setHoverStyle:function(arc){var model=arc._model;var options=arc._options;var getHoverColor=helpers$1.getHoverColor;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,};model.backgroundColor=valueOrDefault$5(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$5(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$5(options.hoverBorderWidth,options.borderWidth)},_getRingWeightOffset:function(datasetIndex){var ringWeightOffset=0;for(var i=0;i<datasetIndex;++i){if(this.chart.isDatasetVisible(i)){ringWeightOffset+=this._getRingWeight(i)}}
return ringWeightOffset},_getRingWeight:function(dataSetIndex){return Math.max(valueOrDefault$5(this.chart.data.datasets[dataSetIndex].weight,1),0)},_getVisibleDatasetWeightTotal:function(){return this._getRingWeightOffset(this.chart.data.datasets.length)}});core_defaults._set('horizontalBar',{hover:{mode:'index',axis:'y'},scales:{xAxes:[{type:'linear',position:'bottom'}],yAxes:[{type:'category',position:'left',offset:!0,gridLines:{offsetGridLines:!0}}]},elements:{rectangle:{borderSkipped:'left'}},tooltips:{mode:'index',axis:'y'}});core_defaults._set('global',{datasets:{horizontalBar:{categoryPercentage:0.8,barPercentage:0.9}}});var controller_horizontalBar=controller_bar.extend({_getValueScaleId:function(){return this.getMeta().xAxisID},_getIndexScaleId:function(){return this.getMeta().yAxisID}});var valueOrDefault$6=helpers$1.valueOrDefault;var resolve$2=helpers$1.options.resolve;var isPointInArea=helpers$1.canvas._isPointInArea;core_defaults._set('line',{showLines:!0,spanGaps:!1,hover:{mode:'label'},scales:{xAxes:[{type:'category',id:'x-axis-0'}],yAxes:[{type:'linear',id:'y-axis-0'}]}});function scaleClip(scale,halfBorderWidth){var tickOpts=scale&&scale.options.ticks||{};var reverse=tickOpts.reverse;var min=tickOpts.min===undefined?halfBorderWidth:0;var max=tickOpts.max===undefined?halfBorderWidth:0;return{start:reverse?max:min,end:reverse?min:max}}
function defaultClip(xScale,yScale,borderWidth){var halfBorderWidth=borderWidth/2;var x=scaleClip(xScale,halfBorderWidth);var y=scaleClip(yScale,halfBorderWidth);return{top:y.end,right:x.end,bottom:y.start,left:x.start}}
function toClip(value){var t,r,b,l;if(helpers$1.isObject(value)){t=value.top;r=value.right;b=value.bottom;l=value.left}else{t=r=b=l=value}
return{top:t,right:r,bottom:b,left:l}}
var controller_line=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,_datasetElementOptions:['backgroundColor','borderCapStyle','borderColor','borderDash','borderDashOffset','borderJoinStyle','borderWidth','cubicInterpolationMode','fill'],_dataElementOptions:{backgroundColor:'pointBackgroundColor',borderColor:'pointBorderColor',borderWidth:'pointBorderWidth',hitRadius:'pointHitRadius',hoverBackgroundColor:'pointHoverBackgroundColor',hoverBorderColor:'pointHoverBorderColor',hoverBorderWidth:'pointHoverBorderWidth',hoverRadius:'pointHoverRadius',pointStyle:'pointStyle',radius:'pointRadius',rotation:'pointRotation'},update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data||[];var options=me.chart.options;var config=me._config;var showLine=me._showLine=valueOrDefault$6(config.showLine,options.showLines);var i,ilen;me._xScale=me.getScaleForId(meta.xAxisID);me._yScale=me.getScaleForId(meta.yAxisID);if(showLine){if(config.tension!==undefined&&config.lineTension===undefined){config.lineTension=config.tension}
line._scale=me._yScale;line._datasetIndex=me.index;line._children=points;line._model=me._resolveDatasetElementOptions(line);line.pivot()}
for(i=0,ilen=points.length;i<ilen;++i){me.updateElement(points[i],i,reset)}
if(showLine&&line._model.tension!==0){me.updateBezierControlPoints()}
for(i=0,ilen=points.length;i<ilen;++i){points[i].pivot()}},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var dataset=me.getDataset();var datasetIndex=me.index;var value=dataset.data[index];var xScale=me._xScale;var yScale=me._yScale;var lineModel=meta.dataset._model;var x,y;var options=me._resolveDataElementOptions(point,index);x=xScale.getPixelForValue(typeof value==='object'?value:NaN,index,datasetIndex);y=reset?yScale.getBasePixel():me.calculatePointY(value,index,datasetIndex);point._xScale=xScale;point._yScale=yScale;point._options=options;point._datasetIndex=datasetIndex;point._index=index;point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$6(custom.tension,lineModel?lineModel.tension:0),steppedLine:lineModel?lineModel.steppedLine:!1,hitRadius:options.hitRadius}},_resolveDatasetElementOptions:function(element){var me=this;var config=me._config;var custom=element.custom||{};var options=me.chart.options;var lineOptions=options.elements.line;var values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);values.spanGaps=valueOrDefault$6(config.spanGaps,options.spanGaps);values.tension=valueOrDefault$6(config.lineTension,lineOptions.tension);values.steppedLine=resolve$2([custom.steppedLine,config.steppedLine,lineOptions.stepped]);values.clip=toClip(valueOrDefault$6(config.clip,defaultClip(me._xScale,me._yScale,values.borderWidth)));return values},calculatePointY:function(value,index,datasetIndex){var me=this;var chart=me.chart;var yScale=me._yScale;var sumPos=0;var sumNeg=0;var i,ds,dsMeta,stackedRightValue,rightValue,metasets,ilen;if(yScale.options.stacked){rightValue=+yScale.getRightValue(value);metasets=chart._getSortedVisibleDatasetMetas();ilen=metasets.length;for(i=0;i<ilen;++i){dsMeta=metasets[i];if(dsMeta.index===datasetIndex){break}
ds=chart.data.datasets[dsMeta.index];if(dsMeta.type==='line'&&dsMeta.yAxisID===yScale.id){stackedRightValue=+yScale.getRightValue(ds.data[index]);if(stackedRightValue<0){sumNeg+=stackedRightValue||0}else{sumPos+=stackedRightValue||0}}}
if(rightValue<0){return yScale.getPixelForValue(sumNeg+rightValue)}
return yScale.getPixelForValue(sumPos+rightValue)}
return yScale.getPixelForValue(value)},updateBezierControlPoints:function(){var me=this;var chart=me.chart;var meta=me.getMeta();var lineModel=meta.dataset._model;var area=chart.chartArea;var points=meta.data||[];var i,ilen,model,controlPoints;if(lineModel.spanGaps){points=points.filter(function(pt){return!pt._model.skip})}
function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min)}
if(lineModel.cubicInterpolationMode==='monotone'){helpers$1.splineCurveMonotone(points)}else{for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i)._model,model,helpers$1.nextItem(points,i)._model,lineModel.tension);model.controlPointPreviousX=controlPoints.previous.x;model.controlPointPreviousY=controlPoints.previous.y;model.controlPointNextX=controlPoints.next.x;model.controlPointNextY=controlPoints.next.y}}
if(chart.options.elements.line.capBezierPoints){for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;if(isPointInArea(model,area)){if(i>0&&isPointInArea(points[i-1]._model,area)){model.controlPointPreviousX=capControlPoint(model.controlPointPreviousX,area.left,area.right);model.controlPointPreviousY=capControlPoint(model.controlPointPreviousY,area.top,area.bottom)}
if(i<points.length-1&&isPointInArea(points[i+1]._model,area)){model.controlPointNextX=capControlPoint(model.controlPointNextX,area.left,area.right);model.controlPointNextY=capControlPoint(model.controlPointNextY,area.top,area.bottom)}}}}},draw:function(){var me=this;var chart=me.chart;var meta=me.getMeta();var points=meta.data||[];var area=chart.chartArea;var canvas=chart.canvas;var i=0;var ilen=points.length;var clip;if(me._showLine){clip=meta.dataset._model.clip;helpers$1.canvas.clipArea(chart.ctx,{left:clip.left===!1?0:area.left-clip.left,right:clip.right===!1?canvas.width:area.right+clip.right,top:clip.top===!1?0:area.top-clip.top,bottom:clip.bottom===!1?canvas.height:area.bottom+clip.bottom});meta.dataset.draw();helpers$1.canvas.unclipArea(chart.ctx)}
for(;i<ilen;++i){points[i].draw(area)}},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$6(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$6(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$6(options.hoverBorderWidth,options.borderWidth);model.radius=valueOrDefault$6(options.hoverRadius,options.radius)},});var resolve$3=helpers$1.options.resolve;core_defaults._set('polarArea',{scale:{type:'radialLinear',angleLines:{display:!1},gridLines:{circular:!0},pointLabels:{display:!1},ticks:{beginAtZero:!0}},animation:{animateRotate:!0,animateScale:!0},startAngle:-0.5*Math.PI,legendCallback:function(chart){var list=document.createElement('ul');var data=chart.data;var datasets=data.datasets;var labels=data.labels;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');if(datasets.length){for(i=0,ilen=datasets[0].data.length;i<ilen;++i){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[0].backgroundColor[i];if(labels[i]){listItem.appendChild(document.createTextNode(labels[i]))}}}
return list.outerHTML},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i}})}
return[]}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);meta.data[index].hidden=!meta.data[index].hidden}
chart.update()}},tooltips:{callbacks:{title:function(){return''},label:function(item,data){return data.labels[item.index]+': '+item.yLabel}}}});var controller_polarArea=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:['backgroundColor','borderColor','borderWidth','borderAlign','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth',],_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(reset){var me=this;var dataset=me.getDataset();var meta=me.getMeta();var start=me.chart.options.startAngle||0;var starts=me._starts=[];var angles=me._angles=[];var arcs=meta.data;var i,ilen,angle;me._updateRadius();meta.count=me.countVisibleElements();for(i=0,ilen=dataset.data.length;i<ilen;i++){starts[i]=start;angle=me._computeAngle(i);angles[i]=angle;start+=angle}
for(i=0,ilen=arcs.length;i<ilen;++i){arcs[i]._options=me._resolveDataElementOptions(arcs[i],i);me.updateElement(arcs[i],i,reset)}},_updateRadius:function(){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var minSize=Math.min(chartArea.right-chartArea.left,chartArea.bottom-chartArea.top);chart.outerRadius=Math.max(minSize/2,0);chart.innerRadius=Math.max(opts.cutoutPercentage?(chart.outerRadius/100)*(opts.cutoutPercentage):1,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/chart.getVisibleDatasetCount();me.outerRadius=chart.outerRadius-(chart.radiusLength*me.index);me.innerRadius=me.outerRadius-chart.radiusLength},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var dataset=me.getDataset();var opts=chart.options;var animationOpts=opts.animation;var scale=chart.scale;var labels=chart.data.labels;var centerX=scale.xCenter;var centerY=scale.yCenter;var datasetStartAngle=opts.startAngle;var distance=arc.hidden?0:scale.getDistanceFromCenterForValue(dataset.data[index]);var startAngle=me._starts[index];var endAngle=startAngle+(arc.hidden?0:me._angles[index]);var resetRadius=animationOpts.animateScale?0:scale.getDistanceFromCenterForValue(dataset.data[index]);var options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_scale:scale,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX,y:centerY,innerRadius:0,outerRadius:reset?resetRadius:distance,startAngle:reset&&animationOpts.animateRotate?datasetStartAngle:startAngle,endAngle:reset&&animationOpts.animateRotate?datasetStartAngle:endAngle,label:helpers$1.valueAtIndexOrDefault(labels,index,labels[index])}});arc.pivot()},countVisibleElements:function(){var dataset=this.getDataset();var meta=this.getMeta();var count=0;helpers$1.each(meta.data,function(element,index){if(!isNaN(dataset.data[index])&&!element.hidden){count++}});return count},setHoverStyle:function(arc){var model=arc._model;var options=arc._options;var getHoverColor=helpers$1.getHoverColor;var valueOrDefault=helpers$1.valueOrDefault;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,};model.backgroundColor=valueOrDefault(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault(options.hoverBorderWidth,options.borderWidth)},_computeAngle:function(index){var me=this;var count=this.getMeta().count;var dataset=me.getDataset();var meta=me.getMeta();if(isNaN(dataset.data[index])||meta.data[index].hidden){return 0}
var context={chart:me.chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};return resolve$3([me.chart.options.elements.arc.angle,(2*Math.PI)/count],context,index)}});core_defaults._set('pie',helpers$1.clone(core_defaults.doughnut));core_defaults._set('pie',{cutoutPercentage:0});var controller_pie=controller_doughnut;var valueOrDefault$7=helpers$1.valueOrDefault;core_defaults._set('radar',{spanGaps:!1,scale:{type:'radialLinear'},elements:{line:{fill:'start',tension:0}}});var controller_radar=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,linkScales:helpers$1.noop,_datasetElementOptions:['backgroundColor','borderWidth','borderColor','borderCapStyle','borderDash','borderDashOffset','borderJoinStyle','fill'],_dataElementOptions:{backgroundColor:'pointBackgroundColor',borderColor:'pointBorderColor',borderWidth:'pointBorderWidth',hitRadius:'pointHitRadius',hoverBackgroundColor:'pointHoverBackgroundColor',hoverBorderColor:'pointHoverBorderColor',hoverBorderWidth:'pointHoverBorderWidth',hoverRadius:'pointHoverRadius',pointStyle:'pointStyle',radius:'pointRadius',rotation:'pointRotation'},_getIndexScaleId:function(){return this.chart.scale.id},_getValueScaleId:function(){return this.chart.scale.id},update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data||[];var scale=me.chart.scale;var config=me._config;var i,ilen;if(config.tension!==undefined&&config.lineTension===undefined){config.lineTension=config.tension}
line._scale=scale;line._datasetIndex=me.index;line._children=points;line._loop=!0;line._model=me._resolveDatasetElementOptions(line);line.pivot();for(i=0,ilen=points.length;i<ilen;++i){me.updateElement(points[i],i,reset)}
me.updateBezierControlPoints();for(i=0,ilen=points.length;i<ilen;++i){points[i].pivot()}},updateElement:function(point,index,reset){var me=this;var custom=point.custom||{};var dataset=me.getDataset();var scale=me.chart.scale;var pointPosition=scale.getPointPositionForValue(index,dataset.data[index]);var options=me._resolveDataElementOptions(point,index);var lineModel=me.getMeta().dataset._model;var x=reset?scale.xCenter:pointPosition.x;var y=reset?scale.yCenter:pointPosition.y;point._scale=scale;point._options=options;point._datasetIndex=me.index;point._index=index;point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$7(custom.tension,lineModel?lineModel.tension:0),hitRadius:options.hitRadius}},_resolveDatasetElementOptions:function(){var me=this;var config=me._config;var options=me.chart.options;var values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);values.spanGaps=valueOrDefault$7(config.spanGaps,options.spanGaps);values.tension=valueOrDefault$7(config.lineTension,options.elements.line.tension);return values},updateBezierControlPoints:function(){var me=this;var meta=me.getMeta();var area=me.chart.chartArea;var points=meta.data||[];var i,ilen,model,controlPoints;if(meta.dataset._model.spanGaps){points=points.filter(function(pt){return!pt._model.skip})}
function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min)}
for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i,!0)._model,model,helpers$1.nextItem(points,i,!0)._model,model.tension);model.controlPointPreviousX=capControlPoint(controlPoints.previous.x,area.left,area.right);model.controlPointPreviousY=capControlPoint(controlPoints.previous.y,area.top,area.bottom);model.controlPointNextX=capControlPoint(controlPoints.next.x,area.left,area.right);model.controlPointNextY=capControlPoint(controlPoints.next.y,area.top,area.bottom)}},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$7(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$7(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$7(options.hoverBorderWidth,options.borderWidth);model.radius=valueOrDefault$7(options.hoverRadius,options.radius)}});core_defaults._set('scatter',{hover:{mode:'single'},scales:{xAxes:[{id:'x-axis-1',type:'linear',position:'bottom'}],yAxes:[{id:'y-axis-1',type:'linear',position:'left'}]},tooltips:{callbacks:{title:function(){return''},label:function(item){return'('+item.xLabel+', '+item.yLabel+')'}}}});core_defaults._set('global',{datasets:{scatter:{showLine:!1}}});var controller_scatter=controller_line;var controllers={bar:controller_bar,bubble:controller_bubble,doughnut:controller_doughnut,horizontalBar:controller_horizontalBar,line:controller_line,polarArea:controller_polarArea,pie:controller_pie,radar:controller_radar,scatter:controller_scatter};function getRelativePosition(e,chart){if(e.native){return{x:e.x,y:e.y}}
return helpers$1.getRelativePosition(e,chart)}
function parseVisibleItems(chart,handler){var metasets=chart._getSortedVisibleDatasetMetas();var metadata,i,j,ilen,jlen,element;for(i=0,ilen=metasets.length;i<ilen;++i){metadata=metasets[i].data;for(j=0,jlen=metadata.length;j<jlen;++j){element=metadata[j];if(!element._view.skip){handler(element)}}}}
function getIntersectItems(chart,position){var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element)}});return elements}
function getNearestItems(chart,position,intersect,distanceMetric){var minDistance=Number.POSITIVE_INFINITY;var nearestItems=[];parseVisibleItems(chart,function(element){if(intersect&&!element.inRange(position.x,position.y)){return}
var center=element.getCenterPoint();var distance=distanceMetric(position,center);if(distance<minDistance){nearestItems=[element];minDistance=distance}else if(distance===minDistance){nearestItems.push(element)}});return nearestItems}
function getDistanceMetricForAxis(axis){var useX=axis.indexOf('x')!==-1;var useY=axis.indexOf('y')!==-1;return function(pt1,pt2){var deltaX=useX?Math.abs(pt1.x-pt2.x):0;var deltaY=useY?Math.abs(pt1.y-pt2.y):0;return Math.sqrt(Math.pow(deltaX,2)+Math.pow(deltaY,2))}}
function indexMode(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'x';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,!1,distanceMetric);var elements=[];if(!items.length){return[]}
chart._getSortedVisibleDatasetMetas().forEach(function(meta){var element=meta.data[items[0]._index];if(element&&!element._view.skip){elements.push(element)}});return elements}
var core_interaction={modes:{single:function(chart,e){var position=getRelativePosition(e,chart);var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element);return elements}});return elements.slice(0,1)},label:indexMode,index:indexMode,dataset:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,!1,distanceMetric);if(items.length>0){items=chart.getDatasetMeta(items[0]._datasetIndex).data}
return items},'x-axis':function(chart,e){return indexMode(chart,e,{intersect:!1})},point:function(chart,e){var position=getRelativePosition(e,chart);return getIntersectItems(chart,position)},nearest:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);return getNearestItems(chart,position,options.intersect,distanceMetric)},x:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=!1;parseVisibleItems(chart,function(element){if(element.inXRange(position.x)){items.push(element)}
if(element.inRange(position.x,position.y)){intersectsItem=!0}});if(options.intersect&&!intersectsItem){items=[]}
return items},y:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=!1;parseVisibleItems(chart,function(element){if(element.inYRange(position.y)){items.push(element)}
if(element.inRange(position.x,position.y)){intersectsItem=!0}});if(options.intersect&&!intersectsItem){items=[]}
return items}}};var extend=helpers$1.extend;function filterByPosition(array,position){return helpers$1.where(array,function(v){return v.pos===position})}
function sortByWeight(array,reverse){return array.sort(function(a,b){var v0=reverse?b:a;var v1=reverse?a:b;return v0.weight===v1.weight?v0.index-v1.index:v0.weight-v1.weight})}
function wrapBoxes(boxes){var layoutBoxes=[];var i,ilen,box;for(i=0,ilen=(boxes||[]).length;i<ilen;++i){box=boxes[i];layoutBoxes.push({index:i,box:box,pos:box.position,horizontal:box.isHorizontal(),weight:box.weight})}
return layoutBoxes}
function setLayoutDims(layouts,params){var i,ilen,layout;for(i=0,ilen=layouts.length;i<ilen;++i){layout=layouts[i];layout.width=layout.horizontal?layout.box.fullWidth&&params.availableWidth:params.vBoxMaxWidth;layout.height=layout.horizontal&&params.hBoxMaxHeight}}
function buildLayoutBoxes(boxes){var layoutBoxes=wrapBoxes(boxes);var left=sortByWeight(filterByPosition(layoutBoxes,'left'),!0);var right=sortByWeight(filterByPosition(layoutBoxes,'right'));var top=sortByWeight(filterByPosition(layoutBoxes,'top'),!0);var bottom=sortByWeight(filterByPosition(layoutBoxes,'bottom'));return{leftAndTop:left.concat(top),rightAndBottom:right.concat(bottom),chartArea:filterByPosition(layoutBoxes,'chartArea'),vertical:left.concat(right),horizontal:top.concat(bottom)}}
function getCombinedMax(maxPadding,chartArea,a,b){return Math.max(maxPadding[a],chartArea[a])+Math.max(maxPadding[b],chartArea[b])}
function updateDims(chartArea,params,layout){var box=layout.box;var maxPadding=chartArea.maxPadding;var newWidth,newHeight;if(layout.size){chartArea[layout.pos]-=layout.size}
layout.size=layout.horizontal?box.height:box.width;chartArea[layout.pos]+=layout.size;if(box.getPadding){var boxPadding=box.getPadding();maxPadding.top=Math.max(maxPadding.top,boxPadding.top);maxPadding.left=Math.max(maxPadding.left,boxPadding.left);maxPadding.bottom=Math.max(maxPadding.bottom,boxPadding.bottom);maxPadding.right=Math.max(maxPadding.right,boxPadding.right)}
newWidth=params.outerWidth-getCombinedMax(maxPadding,chartArea,'left','right');newHeight=params.outerHeight-getCombinedMax(maxPadding,chartArea,'top','bottom');if(newWidth!==chartArea.w||newHeight!==chartArea.h){chartArea.w=newWidth;chartArea.h=newHeight;var sizes=layout.horizontal?[newWidth,chartArea.w]:[newHeight,chartArea.h];return sizes[0]!==sizes[1]&&(!isNaN(sizes[0])||!isNaN(sizes[1]))}}
function handleMaxPadding(chartArea){var maxPadding=chartArea.maxPadding;function updatePos(pos){var change=Math.max(maxPadding[pos]-chartArea[pos],0);chartArea[pos]+=change;return change}
chartArea.y+=updatePos('top');chartArea.x+=updatePos('left');updatePos('right');updatePos('bottom')}
function getMargins(horizontal,chartArea){var maxPadding=chartArea.maxPadding;function marginForPositions(positions){var margin={left:0,top:0,right:0,bottom:0};positions.forEach(function(pos){margin[pos]=Math.max(chartArea[pos],maxPadding[pos])});return margin}
return horizontal?marginForPositions(['left','right']):marginForPositions(['top','bottom'])}
function fitBoxes(boxes,chartArea,params){var refitBoxes=[];var i,ilen,layout,box,refit,changed;for(i=0,ilen=boxes.length;i<ilen;++i){layout=boxes[i];box=layout.box;box.update(layout.width||chartArea.w,layout.height||chartArea.h,getMargins(layout.horizontal,chartArea));if(updateDims(chartArea,params,layout)){changed=!0;if(refitBoxes.length){refit=!0}}
if(!box.fullWidth){refitBoxes.push(layout)}}
return refit?fitBoxes(refitBoxes,chartArea,params)||changed:changed}
function placeBoxes(boxes,chartArea,params){var userPadding=params.padding;var x=chartArea.x;var y=chartArea.y;var i,ilen,layout,box;for(i=0,ilen=boxes.length;i<ilen;++i){layout=boxes[i];box=layout.box;if(layout.horizontal){box.left=box.fullWidth?userPadding.left:chartArea.left;box.right=box.fullWidth?params.outerWidth-userPadding.right:chartArea.left+chartArea.w;box.top=y;box.bottom=y+box.height;box.width=box.right-box.left;y=box.bottom}else{box.left=x;box.right=x+box.width;box.top=chartArea.top;box.bottom=chartArea.top+chartArea.h;box.height=box.bottom-box.top;x=box.right}}
chartArea.x=x;chartArea.y=y}
core_defaults._set('global',{layout:{padding:{top:0,right:0,bottom:0,left:0}}});var core_layouts={defaults:{},addBox:function(chart,item){if(!chart.boxes){chart.boxes=[]}
item.fullWidth=item.fullWidth||!1;item.position=item.position||'top';item.weight=item.weight||0;item._layers=item._layers||function(){return[{z:0,draw:function(){item.draw.apply(item,arguments)}}]};chart.boxes.push(item)},removeBox:function(chart,layoutItem){var index=chart.boxes?chart.boxes.indexOf(layoutItem):-1;if(index!==-1){chart.boxes.splice(index,1)}},configure:function(chart,item,options){var props=['fullWidth','position','weight'];var ilen=props.length;var i=0;var prop;for(;i<ilen;++i){prop=props[i];if(options.hasOwnProperty(prop)){item[prop]=options[prop]}}},update:function(chart,width,height){if(!chart){return}
var layoutOptions=chart.options.layout||{};var padding=helpers$1.options.toPadding(layoutOptions.padding);var availableWidth=width-padding.width;var availableHeight=height-padding.height;var boxes=buildLayoutBoxes(chart.boxes);var verticalBoxes=boxes.vertical;var horizontalBoxes=boxes.horizontal;var params=Object.freeze({outerWidth:width,outerHeight:height,padding:padding,availableWidth:availableWidth,vBoxMaxWidth:availableWidth/2/verticalBoxes.length,hBoxMaxHeight:availableHeight/2});var chartArea=extend({maxPadding:extend({},padding),w:availableWidth,h:availableHeight,x:padding.left,y:padding.top},padding);setLayoutDims(verticalBoxes.concat(horizontalBoxes),params);fitBoxes(verticalBoxes,chartArea,params);if(fitBoxes(horizontalBoxes,chartArea,params)){fitBoxes(verticalBoxes,chartArea,params)}
handleMaxPadding(chartArea);placeBoxes(boxes.leftAndTop,chartArea,params);chartArea.x+=chartArea.w;chartArea.y+=chartArea.h;placeBoxes(boxes.rightAndBottom,chartArea,params);chart.chartArea={left:chartArea.left,top:chartArea.top,right:chartArea.left+chartArea.w,bottom:chartArea.top+chartArea.h};helpers$1.each(boxes.chartArea,function(layout){var box=layout.box;extend(box,chart.chartArea);box.update(chartArea.w,chartArea.h)})}};var platform_basic={acquireContext:function(item){if(item&&item.canvas){item=item.canvas}
return item&&item.getContext('2d')||null}};var platform_dom="/*\r\n * DOM element rendering detection\r\n * https://davidwalsh.name/detect-node-insertion\r\n */\r\n@keyframes chartjs-render-animation {\r\n\tfrom { opacity: 0.99; }\r\n\tto { opacity: 1; }\r\n}\r\n\r\n.chartjs-render-monitor {\r\n\tanimation: chartjs-render-animation 0.001s;\r\n}\r\n\r\n/*\r\n * DOM element resizing detection\r\n * https://github.com/marcj/css-element-queries\r\n */\r\n.chartjs-size-monitor,\r\n.chartjs-size-monitor-expand,\r\n.chartjs-size-monitor-shrink {\r\n\tposition: absolute;\r\n\tdirection: ltr;\r\n\tleft: 0;\r\n\ttop: 0;\r\n\tright: 0;\r\n\tbottom: 0;\r\n\toverflow: hidden;\r\n\tpointer-events: none;\r\n\tvisibility: hidden;\r\n\tz-index: -1;\r\n}\r\n\r\n.chartjs-size-monitor-expand > div {\r\n\tposition: absolute;\r\n\twidth: 1000000px;\r\n\theight: 1000000px;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n\r\n.chartjs-size-monitor-shrink > div {\r\n\tposition: absolute;\r\n\twidth: 200%;\r\n\theight: 200%;\r\n\tleft: 0;\r\n\ttop: 0;\r\n}\r\n";var platform_dom$1=Object.freeze({__proto__:null,'default':platform_dom});var stylesheet=getCjsExportFromNamespace(platform_dom$1);var EXPANDO_KEY='$chartjs';var CSS_PREFIX='chartjs-';var CSS_SIZE_MONITOR=CSS_PREFIX+'size-monitor';var CSS_RENDER_MONITOR=CSS_PREFIX+'render-monitor';var CSS_RENDER_ANIMATION=CSS_PREFIX+'render-animation';var ANIMATION_START_EVENTS=['animationstart','webkitAnimationStart'];var EVENT_TYPES={touchstart:'mousedown',touchmove:'mousemove',touchend:'mouseup',pointerenter:'mouseenter',pointerdown:'mousedown',pointermove:'mousemove',pointerup:'mouseup',pointerleave:'mouseout',pointerout:'mouseout'};function readUsedSize(element,property){var value=helpers$1.getStyle(element,property);var matches=value&&value.match(/^(\d+)(\.\d+)?px$/);return matches?Number(matches[1]):undefined}
function initCanvas(canvas,config){var style=canvas.style;var renderHeight=canvas.getAttribute('height');var renderWidth=canvas.getAttribute('width');canvas[EXPANDO_KEY]={initial:{height:renderHeight,width:renderWidth,style:{display:style.display,height:style.height,width:style.width}}};style.display=style.display||'block';if(renderWidth===null||renderWidth===''){var displayWidth=readUsedSize(canvas,'width');if(displayWidth!==undefined){canvas.width=displayWidth}}
if(renderHeight===null||renderHeight===''){if(canvas.style.height===''){canvas.height=canvas.width/(config.options.aspectRatio||2)}else{var displayHeight=readUsedSize(canvas,'height');if(displayWidth!==undefined){canvas.height=displayHeight}}}
return canvas}
var supportsEventListenerOptions=(function(){var supports=!1;try{var options=Object.defineProperty({},'passive',{get:function(){supports=!0}});window.addEventListener('e',null,options)}catch(e){}
return supports}());var eventListenerOptions=supportsEventListenerOptions?{passive:!0}:!1;function addListener(node,type,listener){node.addEventListener(type,listener,eventListenerOptions)}
function removeListener(node,type,listener){node.removeEventListener(type,listener,eventListenerOptions)}
function createEvent(type,chart,x,y,nativeEvent){return{type:type,chart:chart,native:nativeEvent||null,x:x!==undefined?x:null,y:y!==undefined?y:null,}}
function fromNativeEvent(event,chart){var type=EVENT_TYPES[event.type]||event.type;var pos=helpers$1.getRelativePosition(event,chart);return createEvent(type,chart,pos.x,pos.y,event)}
function throttled(fn,thisArg){var ticking=!1;var args=[];return function(){args=Array.prototype.slice.call(arguments);thisArg=thisArg||this;if(!ticking){ticking=!0;helpers$1.requestAnimFrame.call(window,function(){ticking=!1;fn.apply(thisArg,args)})}}}
function createDiv(cls){var el=document.createElement('div');el.className=cls||'';return el}
function createResizer(handler){var maxSize=1000000;var resizer=createDiv(CSS_SIZE_MONITOR);var expand=createDiv(CSS_SIZE_MONITOR+'-expand');var shrink=createDiv(CSS_SIZE_MONITOR+'-shrink');expand.appendChild(createDiv());shrink.appendChild(createDiv());resizer.appendChild(expand);resizer.appendChild(shrink);resizer._reset=function(){expand.scrollLeft=maxSize;expand.scrollTop=maxSize;shrink.scrollLeft=maxSize;shrink.scrollTop=maxSize};var onScroll=function(){resizer._reset();handler()};addListener(expand,'scroll',onScroll.bind(expand,'expand'));addListener(shrink,'scroll',onScroll.bind(shrink,'shrink'));return resizer}
function watchForRender(node,handler){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var proxy=expando.renderProxy=function(e){if(e.animationName===CSS_RENDER_ANIMATION){handler()}};helpers$1.each(ANIMATION_START_EVENTS,function(type){addListener(node,type,proxy)});expando.reflow=!!node.offsetParent;node.classList.add(CSS_RENDER_MONITOR)}
function unwatchForRender(node){var expando=node[EXPANDO_KEY]||{};var proxy=expando.renderProxy;if(proxy){helpers$1.each(ANIMATION_START_EVENTS,function(type){removeListener(node,type,proxy)});delete expando.renderProxy}
node.classList.remove(CSS_RENDER_MONITOR)}
function addResizeListener(node,listener,chart){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var resizer=expando.resizer=createResizer(throttled(function(){if(expando.resizer){var container=chart.options.maintainAspectRatio&&node.parentNode;var w=container?container.clientWidth:0;listener(createEvent('resize',chart));if(container&&container.clientWidth<w&&chart.canvas){listener(createEvent('resize',chart))}}}));watchForRender(node,function(){if(expando.resizer){var container=node.parentNode;if(container&&container!==resizer.parentNode){container.insertBefore(resizer,container.firstChild)}
resizer._reset()}})}
function removeResizeListener(node){var expando=node[EXPANDO_KEY]||{};var resizer=expando.resizer;delete expando.resizer;unwatchForRender(node);if(resizer&&resizer.parentNode){resizer.parentNode.removeChild(resizer)}}
function injectCSS(rootNode,css){var expando=rootNode[EXPANDO_KEY]||(rootNode[EXPANDO_KEY]={});if(!expando.containsStyles){expando.containsStyles=!0;css='/* Chart.js */\n'+css;var style=document.createElement('style');style.setAttribute('type','text/css');style.appendChild(document.createTextNode(css));rootNode.appendChild(style)}}
var platform_dom$2={disableCSSInjection:!1,_enabled:typeof window!=='undefined'&&typeof document!=='undefined',_ensureLoaded:function(canvas){if(!this.disableCSSInjection){var root=canvas.getRootNode?canvas.getRootNode():document;var targetNode=root.host?root:document.head;injectCSS(targetNode,stylesheet)}},acquireContext:function(item,config){if(typeof item==='string'){item=document.getElementById(item)}else if(item.length){item=item[0]}
if(item&&item.canvas){item=item.canvas}
var context=item&&item.getContext&&item.getContext('2d');if(context&&context.canvas===item){this._ensureLoaded(item);initCanvas(item,config);return context}
return null},releaseContext:function(context){var canvas=context.canvas;if(!canvas[EXPANDO_KEY]){return}
var initial=canvas[EXPANDO_KEY].initial;['height','width'].forEach(function(prop){var value=initial[prop];if(helpers$1.isNullOrUndef(value)){canvas.removeAttribute(prop)}else{canvas.setAttribute(prop,value)}});helpers$1.each(initial.style||{},function(value,key){canvas.style[key]=value});canvas.width=canvas.width;delete canvas[EXPANDO_KEY]},addEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){addResizeListener(canvas,listener,chart);return}
var expando=listener[EXPANDO_KEY]||(listener[EXPANDO_KEY]={});var proxies=expando.proxies||(expando.proxies={});var proxy=proxies[chart.id+'_'+type]=function(event){listener(fromNativeEvent(event,chart))};addListener(canvas,type,proxy)},removeEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){removeResizeListener(canvas);return}
var expando=listener[EXPANDO_KEY]||{};var proxies=expando.proxies||{};var proxy=proxies[chart.id+'_'+type];if(!proxy){return}
removeListener(canvas,type,proxy)}};helpers$1.addEvent=addListener;helpers$1.removeEvent=removeListener;var implementation=platform_dom$2._enabled?platform_dom$2:platform_basic;var platform=helpers$1.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},implementation);core_defaults._set('global',{plugins:{}});var core_plugins={_plugins:[],_cacheId:0,register:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){if(p.indexOf(plugin)===-1){p.push(plugin)}});this._cacheId++},unregister:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){var idx=p.indexOf(plugin);if(idx!==-1){p.splice(idx,1)}});this._cacheId++},clear:function(){this._plugins=[];this._cacheId++},count:function(){return this._plugins.length},getAll:function(){return this._plugins},notify:function(chart,hook,args){var descriptors=this.descriptors(chart);var ilen=descriptors.length;var i,descriptor,plugin,params,method;for(i=0;i<ilen;++i){descriptor=descriptors[i];plugin=descriptor.plugin;method=plugin[hook];if(typeof method==='function'){params=[chart].concat(args||[]);params.push(descriptor.options);if(method.apply(plugin,params)===!1){return!1}}}
return!0},descriptors:function(chart){var cache=chart.$plugins||(chart.$plugins={});if(cache.id===this._cacheId){return cache.descriptors}
var plugins=[];var descriptors=[];var config=(chart&&chart.config)||{};var options=(config.options&&config.options.plugins)||{};this._plugins.concat(config.plugins||[]).forEach(function(plugin){var idx=plugins.indexOf(plugin);if(idx!==-1){return}
var id=plugin.id;var opts=options[id];if(opts===!1){return}
if(opts===!0){opts=helpers$1.clone(core_defaults.global.plugins[id])}
plugins.push(plugin);descriptors.push({plugin:plugin,options:opts||{}})});cache.descriptors=descriptors;cache.id=this._cacheId;return descriptors},_invalidate:function(chart){delete chart.$plugins}};var core_scaleService={constructors:{},defaults:{},registerScaleType:function(type,scaleConstructor,scaleDefaults){this.constructors[type]=scaleConstructor;this.defaults[type]=helpers$1.clone(scaleDefaults)},getScaleConstructor:function(type){return this.constructors.hasOwnProperty(type)?this.constructors[type]:undefined},getScaleDefaults:function(type){return this.defaults.hasOwnProperty(type)?helpers$1.merge(Object.create(null),[core_defaults.scale,this.defaults[type]]):{}},updateScaleDefaults:function(type,additions){var me=this;if(me.defaults.hasOwnProperty(type)){me.defaults[type]=helpers$1.extend(me.defaults[type],additions)}},addScalesToLayout:function(chart){helpers$1.each(chart.scales,function(scale){scale.fullWidth=scale.options.fullWidth;scale.position=scale.options.position;scale.weight=scale.options.weight;core_layouts.addBox(chart,scale)})}};var valueOrDefault$8=helpers$1.valueOrDefault;var getRtlHelper=helpers$1.rtl.getRtlAdapter;core_defaults._set('global',{tooltips:{enabled:!0,custom:null,mode:'nearest',position:'average',intersect:!0,backgroundColor:'rgba(0,0,0,0.8)',titleFontStyle:'bold',titleSpacing:2,titleMarginBottom:6,titleFontColor:'#fff',titleAlign:'left',bodySpacing:2,bodyFontColor:'#fff',bodyAlign:'left',footerFontStyle:'bold',footerSpacing:2,footerMarginTop:6,footerFontColor:'#fff',footerAlign:'left',yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:'#fff',displayColors:!0,borderColor:'rgba(0,0,0,0)',borderWidth:0,callbacks:{beforeTitle:helpers$1.noop,title:function(tooltipItems,data){var title='';var labels=data.labels;var labelCount=labels?labels.length:0;if(tooltipItems.length>0){var item=tooltipItems[0];if(item.label){title=item.label}else if(item.xLabel){title=item.xLabel}else if(labelCount>0&&item.index<labelCount){title=labels[item.index]}}
return title},afterTitle:helpers$1.noop,beforeBody:helpers$1.noop,beforeLabel:helpers$1.noop,label:function(tooltipItem,data){var label=data.datasets[tooltipItem.datasetIndex].label||'';if(label){label+=': '}
if(!helpers$1.isNullOrUndef(tooltipItem.value)){label+=tooltipItem.value}else{label+=tooltipItem.yLabel}
return label},labelColor:function(tooltipItem,chart){var meta=chart.getDatasetMeta(tooltipItem.datasetIndex);var activeElement=meta.data[tooltipItem.index];var view=activeElement._view;return{borderColor:view.borderColor,backgroundColor:view.backgroundColor}},labelTextColor:function(){return this._options.bodyFontColor},afterLabel:helpers$1.noop,afterBody:helpers$1.noop,beforeFooter:helpers$1.noop,footer:helpers$1.noop,afterFooter:helpers$1.noop}}});var positioners={average:function(elements){if(!elements.length){return!1}
var i,len;var x=0;var y=0;var count=0;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var pos=el.tooltipPosition();x+=pos.x;y+=pos.y;++count}}
return{x:x/count,y:y/count}},nearest:function(elements,eventPosition){var x=eventPosition.x;var y=eventPosition.y;var minDistance=Number.POSITIVE_INFINITY;var i,len,nearestElement;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var center=el.getCenterPoint();var d=helpers$1.distanceBetweenPoints(eventPosition,center);if(d<minDistance){minDistance=d;nearestElement=el}}}
if(nearestElement){var tp=nearestElement.tooltipPosition();x=tp.x;y=tp.y}
return{x:x,y:y}}};function pushOrConcat(base,toPush){if(toPush){if(helpers$1.isArray(toPush)){Array.prototype.push.apply(base,toPush)}else{base.push(toPush)}}
return base}
function splitNewlines(str){if((typeof str==='string'||str instanceof String)&&str.indexOf('\n')>-1){return str.split('\n')}
return str}
function createTooltipItem(element){var xScale=element._xScale;var yScale=element._yScale||element._scale;var index=element._index;var datasetIndex=element._datasetIndex;var controller=element._chart.getDatasetMeta(datasetIndex).controller;var indexScale=controller._getIndexScale();var valueScale=controller._getValueScale();return{xLabel:xScale?xScale.getLabelForIndex(index,datasetIndex):'',yLabel:yScale?yScale.getLabelForIndex(index,datasetIndex):'',label:indexScale?''+indexScale.getLabelForIndex(index,datasetIndex):'',value:valueScale?''+valueScale.getLabelForIndex(index,datasetIndex):'',index:index,datasetIndex:datasetIndex,x:element._model.x,y:element._model.y}}
function getBaseModel(tooltipOpts){var globalDefaults=core_defaults.global;return{xPadding:tooltipOpts.xPadding,yPadding:tooltipOpts.yPadding,xAlign:tooltipOpts.xAlign,yAlign:tooltipOpts.yAlign,rtl:tooltipOpts.rtl,textDirection:tooltipOpts.textDirection,bodyFontColor:tooltipOpts.bodyFontColor,_bodyFontFamily:valueOrDefault$8(tooltipOpts.bodyFontFamily,globalDefaults.defaultFontFamily),_bodyFontStyle:valueOrDefault$8(tooltipOpts.bodyFontStyle,globalDefaults.defaultFontStyle),_bodyAlign:tooltipOpts.bodyAlign,bodyFontSize:valueOrDefault$8(tooltipOpts.bodyFontSize,globalDefaults.defaultFontSize),bodySpacing:tooltipOpts.bodySpacing,titleFontColor:tooltipOpts.titleFontColor,_titleFontFamily:valueOrDefault$8(tooltipOpts.titleFontFamily,globalDefaults.defaultFontFamily),_titleFontStyle:valueOrDefault$8(tooltipOpts.titleFontStyle,globalDefaults.defaultFontStyle),titleFontSize:valueOrDefault$8(tooltipOpts.titleFontSize,globalDefaults.defaultFontSize),_titleAlign:tooltipOpts.titleAlign,titleSpacing:tooltipOpts.titleSpacing,titleMarginBottom:tooltipOpts.titleMarginBottom,footerFontColor:tooltipOpts.footerFontColor,_footerFontFamily:valueOrDefault$8(tooltipOpts.footerFontFamily,globalDefaults.defaultFontFamily),_footerFontStyle:valueOrDefault$8(tooltipOpts.footerFontStyle,globalDefaults.defaultFontStyle),footerFontSize:valueOrDefault$8(tooltipOpts.footerFontSize,globalDefaults.defaultFontSize),_footerAlign:tooltipOpts.footerAlign,footerSpacing:tooltipOpts.footerSpacing,footerMarginTop:tooltipOpts.footerMarginTop,caretSize:tooltipOpts.caretSize,cornerRadius:tooltipOpts.cornerRadius,backgroundColor:tooltipOpts.backgroundColor,opacity:0,legendColorBackground:tooltipOpts.multiKeyBackground,displayColors:tooltipOpts.displayColors,borderColor:tooltipOpts.borderColor,borderWidth:tooltipOpts.borderWidth}}
function getTooltipSize(tooltip,model){var ctx=tooltip._chart.ctx;var height=model.yPadding*2;var width=0;var body=model.body;var combinedBodyLength=body.reduce(function(count,bodyItem){return count+bodyItem.before.length+bodyItem.lines.length+bodyItem.after.length},0);combinedBodyLength+=model.beforeBody.length+model.afterBody.length;var titleLineCount=model.title.length;var footerLineCount=model.footer.length;var titleFontSize=model.titleFontSize;var bodyFontSize=model.bodyFontSize;var footerFontSize=model.footerFontSize;height+=titleLineCount*titleFontSize;height+=titleLineCount?(titleLineCount-1)*model.titleSpacing:0;height+=titleLineCount?model.titleMarginBottom:0;height+=combinedBodyLength*bodyFontSize;height+=combinedBodyLength?(combinedBodyLength-1)*model.bodySpacing:0;height+=footerLineCount?model.footerMarginTop:0;height+=footerLineCount*(footerFontSize);height+=footerLineCount?(footerLineCount-1)*model.footerSpacing:0;var widthPadding=0;var maxLineWidth=function(line){width=Math.max(width,ctx.measureText(line).width+widthPadding)};ctx.font=helpers$1.fontString(titleFontSize,model._titleFontStyle,model._titleFontFamily);helpers$1.each(model.title,maxLineWidth);ctx.font=helpers$1.fontString(bodyFontSize,model._bodyFontStyle,model._bodyFontFamily);helpers$1.each(model.beforeBody.concat(model.afterBody),maxLineWidth);widthPadding=model.displayColors?(bodyFontSize+2):0;helpers$1.each(body,function(bodyItem){helpers$1.each(bodyItem.before,maxLineWidth);helpers$1.each(bodyItem.lines,maxLineWidth);helpers$1.each(bodyItem.after,maxLineWidth)});widthPadding=0;ctx.font=helpers$1.fontString(footerFontSize,model._footerFontStyle,model._footerFontFamily);helpers$1.each(model.footer,maxLineWidth);width+=2*model.xPadding;return{width:width,height:height}}
function determineAlignment(tooltip,size){var model=tooltip._model;var chart=tooltip._chart;var chartArea=tooltip._chart.chartArea;var xAlign='center';var yAlign='center';if(model.y<size.height){yAlign='top'}else if(model.y>(chart.height-size.height)){yAlign='bottom'}
var lf,rf;var olf,orf;var yf;var midX=(chartArea.left+chartArea.right)/2;var midY=(chartArea.top+chartArea.bottom)/2;if(yAlign==='center'){lf=function(x){return x<=midX};rf=function(x){return x>midX}}else{lf=function(x){return x<=(size.width/2)};rf=function(x){return x>=(chart.width-(size.width/2))}}
olf=function(x){return x+size.width+model.caretSize+model.caretPadding>chart.width};orf=function(x){return x-size.width-model.caretSize-model.caretPadding<0};yf=function(y){return y<=midY?'top':'bottom'};if(lf(model.x)){xAlign='left';if(olf(model.x)){xAlign='center';yAlign=yf(model.y)}}else if(rf(model.x)){xAlign='right';if(orf(model.x)){xAlign='center';yAlign=yf(model.y)}}
var opts=tooltip._options;return{xAlign:opts.xAlign?opts.xAlign:xAlign,yAlign:opts.yAlign?opts.yAlign:yAlign}}
function getBackgroundPoint(vm,size,alignment,chart){var x=vm.x;var y=vm.y;var caretSize=vm.caretSize;var caretPadding=vm.caretPadding;var cornerRadius=vm.cornerRadius;var xAlign=alignment.xAlign;var yAlign=alignment.yAlign;var paddingAndSize=caretSize+caretPadding;var radiusAndPadding=cornerRadius+caretPadding;if(xAlign==='right'){x-=size.width}else if(xAlign==='center'){x-=(size.width/2);if(x+size.width>chart.width){x=chart.width-size.width}
if(x<0){x=0}}
if(yAlign==='top'){y+=paddingAndSize}else if(yAlign==='bottom'){y-=size.height+paddingAndSize}else{y-=(size.height/2)}
if(yAlign==='center'){if(xAlign==='left'){x+=paddingAndSize}else if(xAlign==='right'){x-=paddingAndSize}}else if(xAlign==='left'){x-=radiusAndPadding}else if(xAlign==='right'){x+=radiusAndPadding}
return{x:x,y:y}}
function getAlignedX(vm,align){return align==='center'?vm.x+vm.width/2:align==='right'?vm.x+vm.width-vm.xPadding:vm.x+vm.xPadding}
function getBeforeAfterBodyLines(callback){return pushOrConcat([],splitNewlines(callback))}
var exports$4=core_element.extend({initialize:function(){this._model=getBaseModel(this._options);this._lastActive=[]},getTitle:function(){var me=this;var opts=me._options;var callbacks=opts.callbacks;var beforeTitle=callbacks.beforeTitle.apply(me,arguments);var title=callbacks.title.apply(me,arguments);var afterTitle=callbacks.afterTitle.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,splitNewlines(beforeTitle));lines=pushOrConcat(lines,splitNewlines(title));lines=pushOrConcat(lines,splitNewlines(afterTitle));return lines},getBeforeBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.beforeBody.apply(this,arguments))},getBody:function(tooltipItems,data){var me=this;var callbacks=me._options.callbacks;var bodyItems=[];helpers$1.each(tooltipItems,function(tooltipItem){var bodyItem={before:[],lines:[],after:[]};pushOrConcat(bodyItem.before,splitNewlines(callbacks.beforeLabel.call(me,tooltipItem,data)));pushOrConcat(bodyItem.lines,callbacks.label.call(me,tooltipItem,data));pushOrConcat(bodyItem.after,splitNewlines(callbacks.afterLabel.call(me,tooltipItem,data)));bodyItems.push(bodyItem)});return bodyItems},getAfterBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.afterBody.apply(this,arguments))},getFooter:function(){var me=this;var callbacks=me._options.callbacks;var beforeFooter=callbacks.beforeFooter.apply(me,arguments);var footer=callbacks.footer.apply(me,arguments);var afterFooter=callbacks.afterFooter.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,splitNewlines(beforeFooter));lines=pushOrConcat(lines,splitNewlines(footer));lines=pushOrConcat(lines,splitNewlines(afterFooter));return lines},update:function(changed){var me=this;var opts=me._options;var existingModel=me._model;var model=me._model=getBaseModel(opts);var active=me._active;var data=me._data;var alignment={xAlign:existingModel.xAlign,yAlign:existingModel.yAlign};var backgroundPoint={x:existingModel.x,y:existingModel.y};var tooltipSize={width:existingModel.width,height:existingModel.height};var tooltipPosition={x:existingModel.caretX,y:existingModel.caretY};var i,len;if(active.length){model.opacity=1;var labelColors=[];var labelTextColors=[];tooltipPosition=positioners[opts.position].call(me,active,me._eventPosition);var tooltipItems=[];for(i=0,len=active.length;i<len;++i){tooltipItems.push(createTooltipItem(active[i]))}
if(opts.filter){tooltipItems=tooltipItems.filter(function(a){return opts.filter(a,data)})}
if(opts.itemSort){tooltipItems=tooltipItems.sort(function(a,b){return opts.itemSort(a,b,data)})}
helpers$1.each(tooltipItems,function(tooltipItem){labelColors.push(opts.callbacks.labelColor.call(me,tooltipItem,me._chart));labelTextColors.push(opts.callbacks.labelTextColor.call(me,tooltipItem,me._chart))});model.title=me.getTitle(tooltipItems,data);model.beforeBody=me.getBeforeBody(tooltipItems,data);model.body=me.getBody(tooltipItems,data);model.afterBody=me.getAfterBody(tooltipItems,data);model.footer=me.getFooter(tooltipItems,data);model.x=tooltipPosition.x;model.y=tooltipPosition.y;model.caretPadding=opts.caretPadding;model.labelColors=labelColors;model.labelTextColors=labelTextColors;model.dataPoints=tooltipItems;tooltipSize=getTooltipSize(this,model);alignment=determineAlignment(this,tooltipSize);backgroundPoint=getBackgroundPoint(model,tooltipSize,alignment,me._chart)}else{model.opacity=0}
model.xAlign=alignment.xAlign;model.yAlign=alignment.yAlign;model.x=backgroundPoint.x;model.y=backgroundPoint.y;model.width=tooltipSize.width;model.height=tooltipSize.height;model.caretX=tooltipPosition.x;model.caretY=tooltipPosition.y;me._model=model;if(changed&&opts.custom){opts.custom.call(me,model)}
return me},drawCaret:function(tooltipPoint,size){var ctx=this._chart.ctx;var vm=this._view;var caretPosition=this.getCaretPosition(tooltipPoint,size,vm);ctx.lineTo(caretPosition.x1,caretPosition.y1);ctx.lineTo(caretPosition.x2,caretPosition.y2);ctx.lineTo(caretPosition.x3,caretPosition.y3)},getCaretPosition:function(tooltipPoint,size,vm){var x1,x2,x3,y1,y2,y3;var caretSize=vm.caretSize;var cornerRadius=vm.cornerRadius;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var ptX=tooltipPoint.x;var ptY=tooltipPoint.y;var width=size.width;var height=size.height;if(yAlign==='center'){y2=ptY+(height/2);if(xAlign==='left'){x1=ptX;x2=x1-caretSize;x3=x1;y1=y2+caretSize;y3=y2-caretSize}else{x1=ptX+width;x2=x1+caretSize;x3=x1;y1=y2-caretSize;y3=y2+caretSize}}else{if(xAlign==='left'){x2=ptX+cornerRadius+(caretSize);x1=x2-caretSize;x3=x2+caretSize}else if(xAlign==='right'){x2=ptX+width-cornerRadius-caretSize;x1=x2-caretSize;x3=x2+caretSize}else{x2=vm.caretX;x1=x2-caretSize;x3=x2+caretSize}
if(yAlign==='top'){y1=ptY;y2=y1-caretSize;y3=y1}else{y1=ptY+height;y2=y1+caretSize;y3=y1;var tmp=x3;x3=x1;x1=tmp}}
return{x1:x1,x2:x2,x3:x3,y1:y1,y2:y2,y3:y3}},drawTitle:function(pt,vm,ctx){var title=vm.title;var length=title.length;var titleFontSize,titleSpacing,i;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);pt.x=getAlignedX(vm,vm._titleAlign);ctx.textAlign=rtlHelper.textAlign(vm._titleAlign);ctx.textBaseline='middle';titleFontSize=vm.titleFontSize;titleSpacing=vm.titleSpacing;ctx.fillStyle=vm.titleFontColor;ctx.font=helpers$1.fontString(titleFontSize,vm._titleFontStyle,vm._titleFontFamily);for(i=0;i<length;++i){ctx.fillText(title[i],rtlHelper.x(pt.x),pt.y+titleFontSize/2);pt.y+=titleFontSize+titleSpacing;if(i+1===length){pt.y+=vm.titleMarginBottom-titleSpacing}}}},drawBody:function(pt,vm,ctx){var bodyFontSize=vm.bodyFontSize;var bodySpacing=vm.bodySpacing;var bodyAlign=vm._bodyAlign;var body=vm.body;var drawColorBoxes=vm.displayColors;var xLinePadding=0;var colorX=drawColorBoxes?getAlignedX(vm,'left'):0;var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);var fillLineOfText=function(line){ctx.fillText(line,rtlHelper.x(pt.x+xLinePadding),pt.y+bodyFontSize/2);pt.y+=bodyFontSize+bodySpacing};var bodyItem,textColor,labelColors,lines,i,j,ilen,jlen;var bodyAlignForCalculation=rtlHelper.textAlign(bodyAlign);ctx.textAlign=bodyAlign;ctx.textBaseline='middle';ctx.font=helpers$1.fontString(bodyFontSize,vm._bodyFontStyle,vm._bodyFontFamily);pt.x=getAlignedX(vm,bodyAlignForCalculation);ctx.fillStyle=vm.bodyFontColor;helpers$1.each(vm.beforeBody,fillLineOfText);xLinePadding=drawColorBoxes&&bodyAlignForCalculation!=='right'?bodyAlign==='center'?(bodyFontSize/2+1):(bodyFontSize+2):0;for(i=0,ilen=body.length;i<ilen;++i){bodyItem=body[i];textColor=vm.labelTextColors[i];labelColors=vm.labelColors[i];ctx.fillStyle=textColor;helpers$1.each(bodyItem.before,fillLineOfText);lines=bodyItem.lines;for(j=0,jlen=lines.length;j<jlen;++j){if(drawColorBoxes){var rtlColorX=rtlHelper.x(colorX);ctx.fillStyle=vm.legendColorBackground;ctx.fillRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize);ctx.lineWidth=1;ctx.strokeStyle=labelColors.borderColor;ctx.strokeRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize);ctx.fillStyle=labelColors.backgroundColor;ctx.fillRect(rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX,1),bodyFontSize-2),pt.y+1,bodyFontSize-2,bodyFontSize-2);ctx.fillStyle=textColor}
fillLineOfText(lines[j])}
helpers$1.each(bodyItem.after,fillLineOfText)}
xLinePadding=0;helpers$1.each(vm.afterBody,fillLineOfText);pt.y-=bodySpacing},drawFooter:function(pt,vm,ctx){var footer=vm.footer;var length=footer.length;var footerFontSize,i;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);pt.x=getAlignedX(vm,vm._footerAlign);pt.y+=vm.footerMarginTop;ctx.textAlign=rtlHelper.textAlign(vm._footerAlign);ctx.textBaseline='middle';footerFontSize=vm.footerFontSize;ctx.fillStyle=vm.footerFontColor;ctx.font=helpers$1.fontString(footerFontSize,vm._footerFontStyle,vm._footerFontFamily);for(i=0;i<length;++i){ctx.fillText(footer[i],rtlHelper.x(pt.x),pt.y+footerFontSize/2);pt.y+=footerFontSize+vm.footerSpacing}}},drawBackground:function(pt,vm,ctx,tooltipSize){ctx.fillStyle=vm.backgroundColor;ctx.strokeStyle=vm.borderColor;ctx.lineWidth=vm.borderWidth;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var x=pt.x;var y=pt.y;var width=tooltipSize.width;var height=tooltipSize.height;var radius=vm.cornerRadius;ctx.beginPath();ctx.moveTo(x+radius,y);if(yAlign==='top'){this.drawCaret(pt,tooltipSize)}
ctx.lineTo(x+width-radius,y);ctx.quadraticCurveTo(x+width,y,x+width,y+radius);if(yAlign==='center'&&xAlign==='right'){this.drawCaret(pt,tooltipSize)}
ctx.lineTo(x+width,y+height-radius);ctx