<?php

if ( ! function_exists( 'is_conversational_form' ) ) {
	/**
	 * Check if the current form view is a conversational form.
	 *
	 * @since 1.4.0
	 *
	 * @param array $form The form array
	 * @param bool  $cache Whether to use a cached result if available.
	 *
	 * @return bool True if the current form view is a conversational form.
	 */
	function is_conversational_form( $form, $cache = true ) {
		if ( ! isset( $form['id'] ) ) {
			return false;
		}

		static $cached = array();

		if ( isset( $cached[ $form['id'] ] ) && $cache ) {
			return $cached[ $form['id'] ];
		}

		global $post;
		$current_post_id = $post && $post->post_type == 'conversational_form' ? $post->ID : false;

		$cached[ $form['id'] ] = rgars( $form, 'gf_theme_layers/post_id' ) === $current_post_id;

		return $cached[ $form['id'] ];
	}
}
